from typing import List

# dependencies for the generated Python class
from ..geometry_msgs.pdu_pytype_Vector3 import Vector3


# class definition for the ROS message
class DroneStatus:
    """
    ROS message: hako_msgs/DroneStatus
    Generated by hakoniwa-ros2pdu.
    """

    flight_mode: int
    internal_state: int
    propeller_wind: Vector3

    def __init__(self):
        self.flight_mode = 0
        self.internal_state = 0
        self.propeller_wind = Vector3()

    def __str__(self):
        return f"DroneStatus(" + ", ".join([
            f"flight_mode={self.flight_mode}"
            f"internal_state={self.internal_state}"
            f"propeller_wind={self.propeller_wind}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'flight_mode'
        field_val = self.flight_mode
        if isinstance(field_val, bytearray):
            d['flight_mode'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['flight_mode'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['flight_mode'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['flight_mode'] = field_val
        # handle field 'internal_state'
        field_val = self.internal_state
        if isinstance(field_val, bytearray):
            d['internal_state'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['internal_state'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['internal_state'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['internal_state'] = field_val
        # handle field 'propeller_wind'
        field_val = self.propeller_wind
        if isinstance(field_val, bytearray):
            d['propeller_wind'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['propeller_wind'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['propeller_wind'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['propeller_wind'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'flight_mode'
        if 'flight_mode' in d:
            field_type = cls.__annotations__.get('flight_mode')
            value = d['flight_mode']
            
            if field_type is bytearray:
                obj.flight_mode = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.flight_mode = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.flight_mode = value
            elif hasattr(field_type, 'from_dict'):
                obj.flight_mode = field_type.from_dict(value)
            else:
                obj.flight_mode = value
        # handle field 'internal_state'
        if 'internal_state' in d:
            field_type = cls.__annotations__.get('internal_state')
            value = d['internal_state']
            
            if field_type is bytearray:
                obj.internal_state = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.internal_state = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.internal_state = value
            elif hasattr(field_type, 'from_dict'):
                obj.internal_state = field_type.from_dict(value)
            else:
                obj.internal_state = value
        # handle field 'propeller_wind'
        if 'propeller_wind' in d:
            field_type = cls.__annotations__.get('propeller_wind')
            value = d['propeller_wind']
            
            if field_type is bytearray:
                obj.propeller_wind = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.propeller_wind = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.propeller_wind = value
            elif hasattr(field_type, 'from_dict'):
                obj.propeller_wind = field_type.from_dict(value)
            else:
                obj.propeller_wind = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
