from typing import List

# dependencies for the generated Python class
from ..hako_msgs.pdu_pytype_HakoCmdHeader import HakoCmdHeader


# class definition for the ROS message
class MonitorCameraCmd:
    """
    ROS message: hako_msgs/MonitorCameraCmd
    Generated by hakoniwa-ros2pdu.
    """

    header: HakoCmdHeader
    request_id: int
    encode_type: int
    request_type: int

    def __init__(self):
        self.header = HakoCmdHeader()
        self.request_id = 0
        self.encode_type = 0
        self.request_type = 0

    def __str__(self):
        return f"MonitorCameraCmd(" + ", ".join([
            f"header={self.header}"
            f"request_id={self.request_id}"
            f"encode_type={self.encode_type}"
            f"request_type={self.request_type}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'header'
        field_val = self.header
        if isinstance(field_val, bytearray):
            d['header'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['header'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['header'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['header'] = field_val
        # handle field 'request_id'
        field_val = self.request_id
        if isinstance(field_val, bytearray):
            d['request_id'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['request_id'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['request_id'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['request_id'] = field_val
        # handle field 'encode_type'
        field_val = self.encode_type
        if isinstance(field_val, bytearray):
            d['encode_type'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['encode_type'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['encode_type'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['encode_type'] = field_val
        # handle field 'request_type'
        field_val = self.request_type
        if isinstance(field_val, bytearray):
            d['request_type'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['request_type'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['request_type'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['request_type'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'header'
        if 'header' in d:
            field_type = cls.__annotations__.get('header')
            value = d['header']
            
            if field_type is bytearray:
                obj.header = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.header = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.header = value
            elif hasattr(field_type, 'from_dict'):
                obj.header = field_type.from_dict(value)
            else:
                obj.header = value
        # handle field 'request_id'
        if 'request_id' in d:
            field_type = cls.__annotations__.get('request_id')
            value = d['request_id']
            
            if field_type is bytearray:
                obj.request_id = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.request_id = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.request_id = value
            elif hasattr(field_type, 'from_dict'):
                obj.request_id = field_type.from_dict(value)
            else:
                obj.request_id = value
        # handle field 'encode_type'
        if 'encode_type' in d:
            field_type = cls.__annotations__.get('encode_type')
            value = d['encode_type']
            
            if field_type is bytearray:
                obj.encode_type = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.encode_type = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.encode_type = value
            elif hasattr(field_type, 'from_dict'):
                obj.encode_type = field_type.from_dict(value)
            else:
                obj.encode_type = value
        # handle field 'request_type'
        if 'request_type' in d:
            field_type = cls.__annotations__.get('request_type')
            value = d['request_type']
            
            if field_type is bytearray:
                obj.request_type = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.request_type = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.request_type = value
            elif hasattr(field_type, 'from_dict'):
                obj.request_type = field_type.from_dict(value)
            else:
                obj.request_type = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
