from typing import List

# dependencies for the generated Python class
from ..std_msgs.pdu_pytype_Header import Header
from ..builtin_interfaces.pdu_pytype_Time import Time


# class definition for the ROS message
class JointState:
    """
    ROS message: sensor_msgs/JointState
    Generated by hakoniwa-ros2pdu.
    """

    header: Header
    name: List[str]
    position: List[float]
    velocity: List[float]
    effort: List[float]

    def __init__(self):
        self.header = Header()
        self.name = []
        self.position = []
        self.velocity = []
        self.effort = []

    def __str__(self):
        return f"JointState(" + ", ".join([
            f"header={self.header}"
            f"name={self.name}"
            f"position={self.position}"
            f"velocity={self.velocity}"
            f"effort={self.effort}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'header'
        field_val = self.header
        if isinstance(field_val, bytearray):
            d['header'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['header'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['header'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['header'] = field_val
        # handle field 'name'
        field_val = self.name
        if isinstance(field_val, bytearray):
            d['name'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['name'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['name'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['name'] = field_val
        # handle field 'position'
        field_val = self.position
        if isinstance(field_val, bytearray):
            d['position'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['position'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['position'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['position'] = field_val
        # handle field 'velocity'
        field_val = self.velocity
        if isinstance(field_val, bytearray):
            d['velocity'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['velocity'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['velocity'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['velocity'] = field_val
        # handle field 'effort'
        field_val = self.effort
        if isinstance(field_val, bytearray):
            d['effort'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['effort'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['effort'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['effort'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'header'
        if 'header' in d:
            field_type = cls.__annotations__.get('header')
            value = d['header']
            
            if field_type is bytearray:
                obj.header = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.header = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.header = value
            elif hasattr(field_type, 'from_dict'):
                obj.header = field_type.from_dict(value)
            else:
                obj.header = value
        # handle field 'name'
        if 'name' in d:
            field_type = cls.__annotations__.get('name')
            value = d['name']
            
            if field_type is bytearray:
                obj.name = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.name = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.name = value
            elif hasattr(field_type, 'from_dict'):
                obj.name = field_type.from_dict(value)
            else:
                obj.name = value
        # handle field 'position'
        if 'position' in d:
            field_type = cls.__annotations__.get('position')
            value = d['position']
            
            if field_type is bytearray:
                obj.position = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.position = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.position = value
            elif hasattr(field_type, 'from_dict'):
                obj.position = field_type.from_dict(value)
            else:
                obj.position = value
        # handle field 'velocity'
        if 'velocity' in d:
            field_type = cls.__annotations__.get('velocity')
            value = d['velocity']
            
            if field_type is bytearray:
                obj.velocity = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.velocity = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.velocity = value
            elif hasattr(field_type, 'from_dict'):
                obj.velocity = field_type.from_dict(value)
            else:
                obj.velocity = value
        # handle field 'effort'
        if 'effort' in d:
            field_type = cls.__annotations__.get('effort')
            value = d['effort']
            
            if field_type is bytearray:
                obj.effort = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.effort = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.effort = value
            elif hasattr(field_type, 'from_dict'):
                obj.effort = field_type.from_dict(value)
            else:
                obj.effort = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
