from typing import List

# dependencies for the generated Python class


# class definition for the ROS message
class PointField:
    """
    ROS message: sensor_msgs/PointField
    Generated by hakoniwa-ros2pdu.
    """

    name: str
    offset: int
    datatype: int
    count: int

    def __init__(self):
        self.name = ""
        self.offset = 0
        self.datatype = 0
        self.count = 0

    def __str__(self):
        return f"PointField(" + ", ".join([
            f"name={self.name}"
            f"offset={self.offset}"
            f"datatype={self.datatype}"
            f"count={self.count}"
        ]) + ")"

    def __repr__(self):
        return self.__str__()

    def to_dict(self):
        """
        Convert the object to a dictionary.
        """
        d = {}
        # handle field 'name'
        field_val = self.name
        if isinstance(field_val, bytearray):
            d['name'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['name'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['name'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['name'] = field_val
        # handle field 'offset'
        field_val = self.offset
        if isinstance(field_val, bytearray):
            d['offset'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['offset'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['offset'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['offset'] = field_val
        # handle field 'datatype'
        field_val = self.datatype
        if isinstance(field_val, bytearray):
            d['datatype'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['datatype'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['datatype'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['datatype'] = field_val
        # handle field 'count'
        field_val = self.count
        if isinstance(field_val, bytearray):
            d['count'] = list(field_val)
        elif hasattr(field_val, 'to_dict'):
            d['count'] = field_val.to_dict()
        elif isinstance(field_val, list):
            d['count'] = [item.to_dict() if hasattr(item, 'to_dict') else item for item in field_val]
        else:
            d['count'] = field_val
        return d

    @classmethod
    def from_dict(cls, d: dict):
        """
        Create an object from a dictionary.
        """
        obj = cls()
        # handle field 'name'
        if 'name' in d:
            field_type = cls.__annotations__.get('name')
            value = d['name']
            
            if field_type is bytearray:
                obj.name = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.name = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.name = value
            elif hasattr(field_type, 'from_dict'):
                obj.name = field_type.from_dict(value)
            else:
                obj.name = value
        # handle field 'offset'
        if 'offset' in d:
            field_type = cls.__annotations__.get('offset')
            value = d['offset']
            
            if field_type is bytearray:
                obj.offset = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.offset = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.offset = value
            elif hasattr(field_type, 'from_dict'):
                obj.offset = field_type.from_dict(value)
            else:
                obj.offset = value
        # handle field 'datatype'
        if 'datatype' in d:
            field_type = cls.__annotations__.get('datatype')
            value = d['datatype']
            
            if field_type is bytearray:
                obj.datatype = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.datatype = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.datatype = value
            elif hasattr(field_type, 'from_dict'):
                obj.datatype = field_type.from_dict(value)
            else:
                obj.datatype = value
        # handle field 'count'
        if 'count' in d:
            field_type = cls.__annotations__.get('count')
            value = d['count']
            
            if field_type is bytearray:
                obj.count = bytearray(value)
            elif hasattr(field_type, '__origin__') and field_type.__origin__ is list:
                list_item_type = field_type.__args__[0]
                if hasattr(list_item_type, 'from_dict'):
                    obj.count = [list_item_type.from_dict(item) for item in value]
                else:
                    obj.count = value
            elif hasattr(field_type, 'from_dict'):
                obj.count = field_type.from_dict(value)
            else:
                obj.count = value
        return obj

    def to_json(self, indent=2):
        """
        Convert the object to a JSON string.
        """
        import json
        return json.dumps(self.to_dict(), indent=indent)

    @classmethod
    def from_json(cls, json_str: str):
        """
        Create an object from a JSON string.
        """
        import json
        return cls.from_dict(json.loads(json_str))
