# Course Documentation Generator - Prompt Template (Hybrid Approach)

## 🎯 **Purpose**
This template helps instructors systematically document their courses for project knowledge storage, enabling efficient course management and future reuse. This hybrid approach balances static documentation with live Canvas MCP access to maintain accuracy while optimizing performance.

## 🔄 **Hybrid Documentation Strategy**

### **Static Documentation (Generate Once, Update Periodically)**
Use these prompts to create foundational course documents that capture stable, design-level information:
- Course structure and philosophy
- Assignment templates and rubrics  
- Communication templates
- Resource guides and support materials

### **Live MCP Integration (Real-time Access)**
Use Canvas MCP tools for dynamic, frequently-changing data:
- Current student progress and grades
- Recent discussion activity
- Assignment submissions and feedback
- Real-time enrollment and participation data

### **Best Practices for Hybrid Approach**
1. **Document Creation Date**: Always include timestamps in generated docs
2. **Refresh Triggers**: Update static docs when course structure changes significantly
3. **Validation Workflow**: Before major decisions, verify key facts with MCP tools
4. **Version Control**: Track document versions across semesters

---

## 📋 **The Seven Core Documents**

### **1. Course Structure Overview** *(Static - Update Each Semester)*
```
Please create a comprehensive Course Structure Overview document for:

**Course Details:**
- Course Name: [COURSE_NAME]
- Course Code: [COURSE_CODE] 
- Semester/Term: [SEMESTER_YEAR]
- Student Count: [NUMBER_ENROLLED]
- Canvas/LMS URL: [COURSE_URL]
- Program Context: [DEGREE_PROGRAM/DEPARTMENT]
- **Documentation Created**: [CURRENT_DATE]
- **Next Refresh Due**: [DATE + 30 DAYS]

**Include the following sections:**
- Course identification and metadata
- Learning framework and philosophy
- Module/week structure with point distributions
- Assessment overview with percentages
- Critical dates and deadlines
- Support infrastructure and communication channels
- Technology integration strategy
- Course policies and flexibility measures
- Learning outcomes and assessment philosophy
- Continuous improvement tracking
- Support contacts and resources
- Strategic notes for instruction

**Hybrid Integration Notes:**
- This document captures course design intent
- Use Canvas MCP tools to verify current enrollment and active assignments
- Refresh when course structure or policies change significantly

**Additional Context:**
[Add any specific course characteristics, teaching innovations, or unique approaches]
```

### **2. Assignment Bank** *(Static - Update When Adding/Removing Assignments)*
```
Please create a comprehensive Assignment Bank document for [COURSE_NAME] that includes:

**Assignment Categories to Document:**
- Weekly assignments with point values
- Discussion prompts and participation requirements
- Quizzes and knowledge assessments
- Projects (individual and group)
- Extra credit opportunities
- Practical/lab assignments

**For each assignment, include:**
- Assignment title and point value
- Learning objectives and purpose
- Detailed instructions and requirements
- Submission format and deadlines
- Connection to course tools/platforms
- Grading criteria overview
- Student resources and support materials

**Hybrid Integration Notes:**
- Document template/design level information here
- Use Canvas MCP tools for:
  - Current submission status
  - Individual student progress
  - Real-time grading and feedback
- **Last Updated**: [CURRENT_DATE]

**Assignment Data:**
[Paste assignment list, descriptions, or Canvas export data here]

**Special Requirements:**
[Note any tools, platforms, or unique submission requirements]
```

### **3. Discussion Guides & Rubrics** *(Static - Seasonal Updates)*
```
Please create a Discussion Guides & Rubrics document for [COURSE_NAME] that includes:

**Discussion Framework:**
- Discussion participation philosophy
- Weekly discussion structure and timing
- Point allocation and grading approach
- Engagement expectations and guidelines

**For each discussion topic, provide:**
- Discussion prompt and context
- Learning objectives
- Participation requirements (initial posts, responses)
- Grading rubric or criteria
- Facilitation strategies
- Common student challenges and solutions

**Hybrid Integration Notes:**
- Document contains discussion design and rubrics (static)
- Use Canvas MCP tools for:
  - Current discussion activity and participation
  - Individual student engagement metrics
  - Real-time moderation needs

**Discussion Topics List:**
[Provide list of discussion topics and any existing prompts]

**Grading Approach:**
[Describe how you evaluate discussion participation]
```

### **4. Communication Templates** *(Static - Update Annually)*
```
Please create a Communication Templates document for [COURSE_NAME] with:

**Template Categories:**
- Course welcome series (pre-start and official)
- Weekly progress updates and encouragement
- Technical support and resource sharing
- Policy clarifications and announcements
- Project phase guidance and tool access
- Assessment feedback and grade communications
- Course conclusion and reflection

**For each template, include:**
- Subject line suggestions
- Timing recommendations (when to send)
- Purpose and context
- Customizable message template with placeholders
- Tone and style guidelines

**Hybrid Integration Notes:**
- Templates provide communication framework (static)
- Use Canvas MCP tools to:
  - Pull current student data for personalization
  - Verify recent course activity before sending updates
  - Check individual student progress for targeted messages

**Communication Style:**
[Describe your communication approach and tone preferences]

**Special Considerations:**
[Note any recurring issues, holidays, or timing considerations]
```

### **5. Grading Rubrics & Assessment Criteria** *(Static - Update When Policies Change)*
```
Please create a Grading Rubrics & Assessment Criteria document for [COURSE_NAME] that includes:

**Assessment Philosophy:**
- Grading approach and standards
- Feedback strategy
- Late work and flexibility policies
- Extra credit and make-up work policies

**Detailed Rubrics for:**
- Major assignments and projects
- Discussion participation
- Presentation or performance assessments
- Peer review and collaboration components

**For each rubric, provide:**
- Criteria categories and descriptions
- Point allocation and scoring scales
- Performance level definitions (exemplary, proficient, developing, inadequate)
- Sample feedback language for each level
- Common issues and improvement suggestions

**Hybrid Integration Notes:**
- Rubrics and policies documented here (static)
- Use Canvas MCP tools for:
  - Applying rubrics to current submissions
  - Tracking grade patterns and student performance
  - Real-time feedback delivery

**Existing Rubric Data:**
[Provide any existing rubrics, grading scales, or assessment criteria]
```

### **6. Student Resources & Support Materials** *(Static - Update Each Semester)*
```
Please create a Student Resources & Support Materials document for [COURSE_NAME] that includes:

**Resource Categories:**
- Technical setup and platform access guides
- Tool tutorials and training materials
- Academic support and study guides
- Professional development opportunities
- Troubleshooting guides and FAQs

**For each resource, include:**
- Resource title and purpose
- Access instructions and links
- Prerequisites or timing recommendations
- Connection to course assignments or objectives
- Maintenance and update requirements

**Hybrid Integration Notes:**
- Resource guides and links documented here (static)
- Use Canvas MCP tools to:
  - Track which students have accessed resources
  - Identify students who may need additional support
  - Monitor resource usage patterns

**Platform and Tool Information:**
[List all course platforms, tools, and required accounts]

**Support Structure:**
[Describe office hours, TA support, peer assistance, forums, etc.]

**Common Student Challenges:**
[Note frequent questions or recurring issues]
```

### **7. Weekly Learning Plans** *(Static - Update Each Semester)*
```
Please create Weekly Learning Plans for [COURSE_NAME] that includes:

**For each week/module, provide:**
- Learning objectives and outcomes
- Content overview and key concepts
- Required readings and materials
- Activities and assignments due
- Live session topics and format
- Discussion prompts and engagement
- Assessment checkpoints
- Student workload and time estimates

**Weekly Structure Template:**
- Pre-work and preparation
- Content delivery format (lectures, readings, videos)
- Active learning components
- Assessment and feedback
- Preview of upcoming week

**Hybrid Integration Notes:**
- Weekly plans provide structure and content (static)
- Use Canvas MCP tools for:
  - Current week progress tracking
  - Individual student completion status
  - Real-time adjustments based on class performance

**Course Timeline:**
[Provide course calendar, important dates, and semester schedule]

**Flexibility Considerations:**
[Note holidays, breaks, or timing adjustments]
```

---

## 🔧 **Usage Instructions**

### **Step-by-Step Hybrid Process:**
1. **Generate Static Documentation**: Use prompts above to create foundational documents
2. **Set Up MCP Integration**: Configure Canvas MCP tools for your course
3. **Establish Refresh Schedule**: 
   - Course Structure: Beginning of semester
   - Assignments/Rubrics: When making changes
   - Resources: Each semester
   - Communication Templates: Annually
4. **Create Validation Workflows**: Before major decisions, verify with MCP tools
5. **Document Integration Points**: Note where static docs connect to live data

### **Validation Workflow Example:**
```
Before sending progress updates:
1. Review communication template (static doc)
2. Use Canvas MCP to pull current grades and participation
3. Personalize message with live data
4. Send targeted communications based on real-time status
```

### **Refresh Triggers:**
- **Immediate**: Policy changes, new assignments, course structure modifications
- **Weekly**: Review accuracy of key deadlines and requirements
- **Semester**: Complete refresh of all static documentation
- **Annual**: Communication templates and resource guides

---

## 💡 **Advanced Hybrid Strategies**

### **Smart Refresh Patterns:**
- **Before semester**: Generate all static docs
- **Mid-semester**: Validate key facts with MCP before major communications
- **After semester**: Update docs based on what changed during the course

### **Integration Checkpoints:**
- Use MCP tools to verify enrollment before using communication templates
- Check current assignment status before referencing due dates
- Validate discussion activity before sending participation reminders
- Confirm grade accuracy before sending progress updates

### **Accuracy Safeguards:**
- Include "Last verified: [DATE]" in all static documents
- Create quick MCP validation scripts for key data points
- Establish "trust but verify" protocols for critical information
- Maintain change logs for significant course modifications

---

## 🔄 **Canvas MCP Integration Examples**

### **When to Use Static Docs:**
- Planning future assignments
- Onboarding new TAs or instructors
- Creating semester overviews
- Developing communication strategies
- Designing course improvements

### **When to Use Canvas MCP Tools:**
- Checking current student progress
- Sending personalized communications
- Making real-time grading decisions
- Monitoring discussion participation
- Responding to individual student needs

### **Hybrid Workflow Example:**
```
Weekly Progress Check:
1. Review weekly plan (static doc) for objectives
2. Use Canvas MCP to pull completion data
3. Identify students needing support
4. Use communication template (static) with live data
5. Send personalized messages
6. Update notes for next week's planning
```

---

*Template Version: 2.0 (Hybrid)*  
*Created: July 1, 2025*  
*Compatible with: Canvas MCP tools and any course management system*