# -*- coding: utf-8 -*-
# Generated by Django 1.9.5 on 2016-08-02 14:54
from django.db import migrations, models

import django_x509.base.models


class Migration(migrations.Migration):
    dependencies = [("django_x509", "0001_initial")]

    operations = [
        migrations.RenameField(
            model_name="ca", old_name="public_key", new_name="certificate"
        ),
        migrations.RenameField(
            model_name="cert", old_name="public_key", new_name="certificate"
        ),
        migrations.AlterField(
            model_name="ca",
            name="digest",
            field=models.CharField(
                blank=True,
                choices=[
                    ("", ""),
                    ("sha1", "SHA1"),
                    ("sha224", "SHA224"),
                    ("sha256", "SHA256"),
                    ("sha384", "SHA384"),
                    ("sha512", "SHA512"),
                ],
                default=django_x509.base.models.default_digest_algorithm,
                help_text="bits",
                max_length=8,
                verbose_name="digest algorithm",
            ),
        ),
        migrations.AlterField(
            model_name="ca",
            name="key_length",
            field=models.CharField(
                blank=True,
                choices=[
                    ("", ""),
                    ("512", "512"),
                    ("1024", "1024"),
                    ("2048", "2048"),
                    ("4096", "4096"),
                ],
                default=django_x509.base.models.default_key_length,
                help_text="bits",
                max_length=6,
                verbose_name="key length",
            ),
        ),
        migrations.AlterField(
            model_name="ca",
            name="private_key",
            field=models.TextField(
                blank=True, help_text="private key in X.509 PEM format"
            ),
        ),
        migrations.AlterField(
            model_name="cert",
            name="digest",
            field=models.CharField(
                blank=True,
                choices=[
                    ("", ""),
                    ("sha1", "SHA1"),
                    ("sha224", "SHA224"),
                    ("sha256", "SHA256"),
                    ("sha384", "SHA384"),
                    ("sha512", "SHA512"),
                ],
                default=django_x509.base.models.default_digest_algorithm,
                help_text="bits",
                max_length=8,
                verbose_name="digest algorithm",
            ),
        ),
        migrations.AlterField(
            model_name="cert",
            name="key_length",
            field=models.CharField(
                blank=True,
                choices=[
                    ("", ""),
                    ("512", "512"),
                    ("1024", "1024"),
                    ("2048", "2048"),
                    ("4096", "4096"),
                ],
                default=django_x509.base.models.default_key_length,
                help_text="bits",
                max_length=6,
                verbose_name="key length",
            ),
        ),
        migrations.AlterField(
            model_name="cert",
            name="private_key",
            field=models.TextField(
                blank=True, help_text="private key in X.509 PEM format"
            ),
        ),
        migrations.AlterField(
            model_name="ca",
            name="certificate",
            field=models.TextField(
                blank=True, help_text="certificate in X.509 PEM format"
            ),
        ),
        migrations.AlterField(
            model_name="cert",
            name="certificate",
            field=models.TextField(
                blank=True, help_text="certificate in X.509 PEM format"
            ),
        ),
    ]
