# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ApiArgs', 'Api']

@pulumi.input_type
class ApiArgs:
    def __init__(__self__, *,
                 api_management_name: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 revision: pulumi.Input[_builtins.str],
                 api_type: Optional[pulumi.Input[_builtins.str]] = None,
                 contact: Optional[pulumi.Input['ApiContactArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 import_: Optional[pulumi.Input['ApiImportArgs']] = None,
                 license: Optional[pulumi.Input['ApiLicenseArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth2_authorization: Optional[pulumi.Input['ApiOauth2AuthorizationArgs']] = None,
                 openid_authentication: Optional[pulumi.Input['ApiOpenidAuthenticationArgs']] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 revision_description: Optional[pulumi.Input[_builtins.str]] = None,
                 service_url: Optional[pulumi.Input[_builtins.str]] = None,
                 source_api_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_key_parameter_names: Optional[pulumi.Input['ApiSubscriptionKeyParameterNamesArgs']] = None,
                 subscription_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 terms_of_service_url: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 version_description: Optional[pulumi.Input[_builtins.str]] = None,
                 version_set_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Api resource.
        :param pulumi.Input[_builtins.str] api_management_name: The Name of the API Management Service where this API should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The Name of the Resource Group where the API Management API exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] revision: The Revision which used for this API. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] api_type: Type of API. Possible values are `graphql`, `http`, `soap`, and `websocket`. Defaults to `http`.
        :param pulumi.Input['ApiContactArgs'] contact: A `contact` block as documented below.
        :param pulumi.Input[_builtins.str] description: A description of the API Management API, which may include HTML formatting tags.
        :param pulumi.Input[_builtins.str] display_name: The display name of the API.
        :param pulumi.Input['ApiImportArgs'] import_: A `import` block as documented below.
               
               > **Note:** The `display_name`, `description`, `contact`, and `license` fields can be imported by the `import` block, which might cause a drift if these fields are set along with the `import` block.
        :param pulumi.Input['ApiLicenseArgs'] license: A `license` block as documented below.
        :param pulumi.Input[_builtins.str] name: The name of the API Management API. Changing this forces a new resource to be created.
        :param pulumi.Input['ApiOauth2AuthorizationArgs'] oauth2_authorization: An `oauth2_authorization` block as documented below.
        :param pulumi.Input['ApiOpenidAuthenticationArgs'] openid_authentication: An `openid_authentication` block as documented below.
        :param pulumi.Input[_builtins.str] path: The Path for this API Management API, which is a relative URL which uniquely identifies this API and all of its resource paths within the API Management Service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protocols: A list of protocols the operations in this API can be invoked. Possible values are `http`, `https`, `ws`, and `wss`.
               
               > **Note:** `display_name`, `path` and `protocols` are required when `source_api_id` is not set.
        :param pulumi.Input[_builtins.str] revision_description: The description of the API Revision of the API Management API.
        :param pulumi.Input[_builtins.str] service_url: Absolute URL of the backend service implementing this API.
               
               > **Note:** The `service_url` is required when `api_type` is specified as `websocket`.
        :param pulumi.Input[_builtins.str] source_api_id: The API id of the source API, which could be in format `azurerm_api_management_api.example.id` or in format `azurerm_api_management_api.example.id;rev=1`
        :param pulumi.Input['ApiSubscriptionKeyParameterNamesArgs'] subscription_key_parameter_names: A `subscription_key_parameter_names` block as documented below.
        :param pulumi.Input[_builtins.bool] subscription_required: Should this API require a subscription key? Defaults to `true`.
        :param pulumi.Input[_builtins.str] terms_of_service_url: Absolute URL of the Terms of Service for the API.
        :param pulumi.Input[_builtins.str] version: The Version number of this API, if this API is versioned.
        :param pulumi.Input[_builtins.str] version_description: The description of the API Version of the API Management API.
        :param pulumi.Input[_builtins.str] version_set_id: The ID of the Version Set which this API is associated with.
               
               > **Note:** When `version` is set, `version_set_id` must also be specified
        """
        pulumi.set(__self__, "api_management_name", api_management_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "revision", revision)
        if api_type is not None:
            pulumi.set(__self__, "api_type", api_type)
        if contact is not None:
            pulumi.set(__self__, "contact", contact)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if import_ is not None:
            pulumi.set(__self__, "import_", import_)
        if license is not None:
            pulumi.set(__self__, "license", license)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth2_authorization is not None:
            pulumi.set(__self__, "oauth2_authorization", oauth2_authorization)
        if openid_authentication is not None:
            pulumi.set(__self__, "openid_authentication", openid_authentication)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if revision_description is not None:
            pulumi.set(__self__, "revision_description", revision_description)
        if service_url is not None:
            pulumi.set(__self__, "service_url", service_url)
        if source_api_id is not None:
            pulumi.set(__self__, "source_api_id", source_api_id)
        if subscription_key_parameter_names is not None:
            pulumi.set(__self__, "subscription_key_parameter_names", subscription_key_parameter_names)
        if subscription_required is not None:
            pulumi.set(__self__, "subscription_required", subscription_required)
        if terms_of_service_url is not None:
            pulumi.set(__self__, "terms_of_service_url", terms_of_service_url)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if version_description is not None:
            pulumi.set(__self__, "version_description", version_description)
        if version_set_id is not None:
            pulumi.set(__self__, "version_set_id", version_set_id)

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Name of the API Management Service where this API should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @api_management_name.setter
    def api_management_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_management_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Name of the Resource Group where the API Management API exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def revision(self) -> pulumi.Input[_builtins.str]:
        """
        The Revision which used for this API. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "revision", value)

    @_builtins.property
    @pulumi.getter(name="apiType")
    def api_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of API. Possible values are `graphql`, `http`, `soap`, and `websocket`. Defaults to `http`.
        """
        return pulumi.get(self, "api_type")

    @api_type.setter
    def api_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_type", value)

    @_builtins.property
    @pulumi.getter
    def contact(self) -> Optional[pulumi.Input['ApiContactArgs']]:
        """
        A `contact` block as documented below.
        """
        return pulumi.get(self, "contact")

    @contact.setter
    def contact(self, value: Optional[pulumi.Input['ApiContactArgs']]):
        pulumi.set(self, "contact", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the API Management API, which may include HTML formatting tags.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the API.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="import")
    def import_(self) -> Optional[pulumi.Input['ApiImportArgs']]:
        """
        A `import` block as documented below.

        > **Note:** The `display_name`, `description`, `contact`, and `license` fields can be imported by the `import` block, which might cause a drift if these fields are set along with the `import` block.
        """
        return pulumi.get(self, "import_")

    @import_.setter
    def import_(self, value: Optional[pulumi.Input['ApiImportArgs']]):
        pulumi.set(self, "import_", value)

    @_builtins.property
    @pulumi.getter
    def license(self) -> Optional[pulumi.Input['ApiLicenseArgs']]:
        """
        A `license` block as documented below.
        """
        return pulumi.get(self, "license")

    @license.setter
    def license(self, value: Optional[pulumi.Input['ApiLicenseArgs']]):
        pulumi.set(self, "license", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the API Management API. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="oauth2Authorization")
    def oauth2_authorization(self) -> Optional[pulumi.Input['ApiOauth2AuthorizationArgs']]:
        """
        An `oauth2_authorization` block as documented below.
        """
        return pulumi.get(self, "oauth2_authorization")

    @oauth2_authorization.setter
    def oauth2_authorization(self, value: Optional[pulumi.Input['ApiOauth2AuthorizationArgs']]):
        pulumi.set(self, "oauth2_authorization", value)

    @_builtins.property
    @pulumi.getter(name="openidAuthentication")
    def openid_authentication(self) -> Optional[pulumi.Input['ApiOpenidAuthenticationArgs']]:
        """
        An `openid_authentication` block as documented below.
        """
        return pulumi.get(self, "openid_authentication")

    @openid_authentication.setter
    def openid_authentication(self, value: Optional[pulumi.Input['ApiOpenidAuthenticationArgs']]):
        pulumi.set(self, "openid_authentication", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Path for this API Management API, which is a relative URL which uniquely identifies this API and all of its resource paths within the API Management Service.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of protocols the operations in this API can be invoked. Possible values are `http`, `https`, `ws`, and `wss`.

        > **Note:** `display_name`, `path` and `protocols` are required when `source_api_id` is not set.
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "protocols", value)

    @_builtins.property
    @pulumi.getter(name="revisionDescription")
    def revision_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the API Revision of the API Management API.
        """
        return pulumi.get(self, "revision_description")

    @revision_description.setter
    def revision_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "revision_description", value)

    @_builtins.property
    @pulumi.getter(name="serviceUrl")
    def service_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Absolute URL of the backend service implementing this API.

        > **Note:** The `service_url` is required when `api_type` is specified as `websocket`.
        """
        return pulumi.get(self, "service_url")

    @service_url.setter
    def service_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_url", value)

    @_builtins.property
    @pulumi.getter(name="sourceApiId")
    def source_api_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The API id of the source API, which could be in format `azurerm_api_management_api.example.id` or in format `azurerm_api_management_api.example.id;rev=1`
        """
        return pulumi.get(self, "source_api_id")

    @source_api_id.setter
    def source_api_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_api_id", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionKeyParameterNames")
    def subscription_key_parameter_names(self) -> Optional[pulumi.Input['ApiSubscriptionKeyParameterNamesArgs']]:
        """
        A `subscription_key_parameter_names` block as documented below.
        """
        return pulumi.get(self, "subscription_key_parameter_names")

    @subscription_key_parameter_names.setter
    def subscription_key_parameter_names(self, value: Optional[pulumi.Input['ApiSubscriptionKeyParameterNamesArgs']]):
        pulumi.set(self, "subscription_key_parameter_names", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionRequired")
    def subscription_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should this API require a subscription key? Defaults to `true`.
        """
        return pulumi.get(self, "subscription_required")

    @subscription_required.setter
    def subscription_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "subscription_required", value)

    @_builtins.property
    @pulumi.getter(name="termsOfServiceUrl")
    def terms_of_service_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Absolute URL of the Terms of Service for the API.
        """
        return pulumi.get(self, "terms_of_service_url")

    @terms_of_service_url.setter
    def terms_of_service_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "terms_of_service_url", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Version number of this API, if this API is versioned.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the API Version of the API Management API.
        """
        return pulumi.get(self, "version_description")

    @version_description.setter
    def version_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_description", value)

    @_builtins.property
    @pulumi.getter(name="versionSetId")
    def version_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Version Set which this API is associated with.

        > **Note:** When `version` is set, `version_set_id` must also be specified
        """
        return pulumi.get(self, "version_set_id")

    @version_set_id.setter
    def version_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_set_id", value)


@pulumi.input_type
class _ApiState:
    def __init__(__self__, *,
                 api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                 api_type: Optional[pulumi.Input[_builtins.str]] = None,
                 contact: Optional[pulumi.Input['ApiContactArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 import_: Optional[pulumi.Input['ApiImportArgs']] = None,
                 is_current: Optional[pulumi.Input[_builtins.bool]] = None,
                 is_online: Optional[pulumi.Input[_builtins.bool]] = None,
                 license: Optional[pulumi.Input['ApiLicenseArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth2_authorization: Optional[pulumi.Input['ApiOauth2AuthorizationArgs']] = None,
                 openid_authentication: Optional[pulumi.Input['ApiOpenidAuthenticationArgs']] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 revision: Optional[pulumi.Input[_builtins.str]] = None,
                 revision_description: Optional[pulumi.Input[_builtins.str]] = None,
                 service_url: Optional[pulumi.Input[_builtins.str]] = None,
                 source_api_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_key_parameter_names: Optional[pulumi.Input['ApiSubscriptionKeyParameterNamesArgs']] = None,
                 subscription_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 terms_of_service_url: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 version_description: Optional[pulumi.Input[_builtins.str]] = None,
                 version_set_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Api resources.
        :param pulumi.Input[_builtins.str] api_management_name: The Name of the API Management Service where this API should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] api_type: Type of API. Possible values are `graphql`, `http`, `soap`, and `websocket`. Defaults to `http`.
        :param pulumi.Input['ApiContactArgs'] contact: A `contact` block as documented below.
        :param pulumi.Input[_builtins.str] description: A description of the API Management API, which may include HTML formatting tags.
        :param pulumi.Input[_builtins.str] display_name: The display name of the API.
        :param pulumi.Input['ApiImportArgs'] import_: A `import` block as documented below.
               
               > **Note:** The `display_name`, `description`, `contact`, and `license` fields can be imported by the `import` block, which might cause a drift if these fields are set along with the `import` block.
        :param pulumi.Input[_builtins.bool] is_current: Is this the current API Revision?
        :param pulumi.Input[_builtins.bool] is_online: Is this API Revision online/accessible via the Gateway?
        :param pulumi.Input['ApiLicenseArgs'] license: A `license` block as documented below.
        :param pulumi.Input[_builtins.str] name: The name of the API Management API. Changing this forces a new resource to be created.
        :param pulumi.Input['ApiOauth2AuthorizationArgs'] oauth2_authorization: An `oauth2_authorization` block as documented below.
        :param pulumi.Input['ApiOpenidAuthenticationArgs'] openid_authentication: An `openid_authentication` block as documented below.
        :param pulumi.Input[_builtins.str] path: The Path for this API Management API, which is a relative URL which uniquely identifies this API and all of its resource paths within the API Management Service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protocols: A list of protocols the operations in this API can be invoked. Possible values are `http`, `https`, `ws`, and `wss`.
               
               > **Note:** `display_name`, `path` and `protocols` are required when `source_api_id` is not set.
        :param pulumi.Input[_builtins.str] resource_group_name: The Name of the Resource Group where the API Management API exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] revision: The Revision which used for this API. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] revision_description: The description of the API Revision of the API Management API.
        :param pulumi.Input[_builtins.str] service_url: Absolute URL of the backend service implementing this API.
               
               > **Note:** The `service_url` is required when `api_type` is specified as `websocket`.
        :param pulumi.Input[_builtins.str] source_api_id: The API id of the source API, which could be in format `azurerm_api_management_api.example.id` or in format `azurerm_api_management_api.example.id;rev=1`
        :param pulumi.Input['ApiSubscriptionKeyParameterNamesArgs'] subscription_key_parameter_names: A `subscription_key_parameter_names` block as documented below.
        :param pulumi.Input[_builtins.bool] subscription_required: Should this API require a subscription key? Defaults to `true`.
        :param pulumi.Input[_builtins.str] terms_of_service_url: Absolute URL of the Terms of Service for the API.
        :param pulumi.Input[_builtins.str] version: The Version number of this API, if this API is versioned.
        :param pulumi.Input[_builtins.str] version_description: The description of the API Version of the API Management API.
        :param pulumi.Input[_builtins.str] version_set_id: The ID of the Version Set which this API is associated with.
               
               > **Note:** When `version` is set, `version_set_id` must also be specified
        """
        if api_management_name is not None:
            pulumi.set(__self__, "api_management_name", api_management_name)
        if api_type is not None:
            pulumi.set(__self__, "api_type", api_type)
        if contact is not None:
            pulumi.set(__self__, "contact", contact)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if import_ is not None:
            pulumi.set(__self__, "import_", import_)
        if is_current is not None:
            pulumi.set(__self__, "is_current", is_current)
        if is_online is not None:
            pulumi.set(__self__, "is_online", is_online)
        if license is not None:
            pulumi.set(__self__, "license", license)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if oauth2_authorization is not None:
            pulumi.set(__self__, "oauth2_authorization", oauth2_authorization)
        if openid_authentication is not None:
            pulumi.set(__self__, "openid_authentication", openid_authentication)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if protocols is not None:
            pulumi.set(__self__, "protocols", protocols)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if revision_description is not None:
            pulumi.set(__self__, "revision_description", revision_description)
        if service_url is not None:
            pulumi.set(__self__, "service_url", service_url)
        if source_api_id is not None:
            pulumi.set(__self__, "source_api_id", source_api_id)
        if subscription_key_parameter_names is not None:
            pulumi.set(__self__, "subscription_key_parameter_names", subscription_key_parameter_names)
        if subscription_required is not None:
            pulumi.set(__self__, "subscription_required", subscription_required)
        if terms_of_service_url is not None:
            pulumi.set(__self__, "terms_of_service_url", terms_of_service_url)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if version_description is not None:
            pulumi.set(__self__, "version_description", version_description)
        if version_set_id is not None:
            pulumi.set(__self__, "version_set_id", version_set_id)

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name of the API Management Service where this API should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @api_management_name.setter
    def api_management_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_management_name", value)

    @_builtins.property
    @pulumi.getter(name="apiType")
    def api_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Type of API. Possible values are `graphql`, `http`, `soap`, and `websocket`. Defaults to `http`.
        """
        return pulumi.get(self, "api_type")

    @api_type.setter
    def api_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_type", value)

    @_builtins.property
    @pulumi.getter
    def contact(self) -> Optional[pulumi.Input['ApiContactArgs']]:
        """
        A `contact` block as documented below.
        """
        return pulumi.get(self, "contact")

    @contact.setter
    def contact(self, value: Optional[pulumi.Input['ApiContactArgs']]):
        pulumi.set(self, "contact", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of the API Management API, which may include HTML formatting tags.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The display name of the API.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="import")
    def import_(self) -> Optional[pulumi.Input['ApiImportArgs']]:
        """
        A `import` block as documented below.

        > **Note:** The `display_name`, `description`, `contact`, and `license` fields can be imported by the `import` block, which might cause a drift if these fields are set along with the `import` block.
        """
        return pulumi.get(self, "import_")

    @import_.setter
    def import_(self, value: Optional[pulumi.Input['ApiImportArgs']]):
        pulumi.set(self, "import_", value)

    @_builtins.property
    @pulumi.getter(name="isCurrent")
    def is_current(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is this the current API Revision?
        """
        return pulumi.get(self, "is_current")

    @is_current.setter
    def is_current(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_current", value)

    @_builtins.property
    @pulumi.getter(name="isOnline")
    def is_online(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is this API Revision online/accessible via the Gateway?
        """
        return pulumi.get(self, "is_online")

    @is_online.setter
    def is_online(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "is_online", value)

    @_builtins.property
    @pulumi.getter
    def license(self) -> Optional[pulumi.Input['ApiLicenseArgs']]:
        """
        A `license` block as documented below.
        """
        return pulumi.get(self, "license")

    @license.setter
    def license(self, value: Optional[pulumi.Input['ApiLicenseArgs']]):
        pulumi.set(self, "license", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the API Management API. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="oauth2Authorization")
    def oauth2_authorization(self) -> Optional[pulumi.Input['ApiOauth2AuthorizationArgs']]:
        """
        An `oauth2_authorization` block as documented below.
        """
        return pulumi.get(self, "oauth2_authorization")

    @oauth2_authorization.setter
    def oauth2_authorization(self, value: Optional[pulumi.Input['ApiOauth2AuthorizationArgs']]):
        pulumi.set(self, "oauth2_authorization", value)

    @_builtins.property
    @pulumi.getter(name="openidAuthentication")
    def openid_authentication(self) -> Optional[pulumi.Input['ApiOpenidAuthenticationArgs']]:
        """
        An `openid_authentication` block as documented below.
        """
        return pulumi.get(self, "openid_authentication")

    @openid_authentication.setter
    def openid_authentication(self, value: Optional[pulumi.Input['ApiOpenidAuthenticationArgs']]):
        pulumi.set(self, "openid_authentication", value)

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Path for this API Management API, which is a relative URL which uniquely identifies this API and all of its resource paths within the API Management Service.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "path", value)

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of protocols the operations in this API can be invoked. Possible values are `http`, `https`, `ws`, and `wss`.

        > **Note:** `display_name`, `path` and `protocols` are required when `source_api_id` is not set.
        """
        return pulumi.get(self, "protocols")

    @protocols.setter
    def protocols(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "protocols", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name of the Resource Group where the API Management API exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Revision which used for this API. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "revision", value)

    @_builtins.property
    @pulumi.getter(name="revisionDescription")
    def revision_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the API Revision of the API Management API.
        """
        return pulumi.get(self, "revision_description")

    @revision_description.setter
    def revision_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "revision_description", value)

    @_builtins.property
    @pulumi.getter(name="serviceUrl")
    def service_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Absolute URL of the backend service implementing this API.

        > **Note:** The `service_url` is required when `api_type` is specified as `websocket`.
        """
        return pulumi.get(self, "service_url")

    @service_url.setter
    def service_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_url", value)

    @_builtins.property
    @pulumi.getter(name="sourceApiId")
    def source_api_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The API id of the source API, which could be in format `azurerm_api_management_api.example.id` or in format `azurerm_api_management_api.example.id;rev=1`
        """
        return pulumi.get(self, "source_api_id")

    @source_api_id.setter
    def source_api_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_api_id", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionKeyParameterNames")
    def subscription_key_parameter_names(self) -> Optional[pulumi.Input['ApiSubscriptionKeyParameterNamesArgs']]:
        """
        A `subscription_key_parameter_names` block as documented below.
        """
        return pulumi.get(self, "subscription_key_parameter_names")

    @subscription_key_parameter_names.setter
    def subscription_key_parameter_names(self, value: Optional[pulumi.Input['ApiSubscriptionKeyParameterNamesArgs']]):
        pulumi.set(self, "subscription_key_parameter_names", value)

    @_builtins.property
    @pulumi.getter(name="subscriptionRequired")
    def subscription_required(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should this API require a subscription key? Defaults to `true`.
        """
        return pulumi.get(self, "subscription_required")

    @subscription_required.setter
    def subscription_required(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "subscription_required", value)

    @_builtins.property
    @pulumi.getter(name="termsOfServiceUrl")
    def terms_of_service_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Absolute URL of the Terms of Service for the API.
        """
        return pulumi.get(self, "terms_of_service_url")

    @terms_of_service_url.setter
    def terms_of_service_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "terms_of_service_url", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Version number of this API, if this API is versioned.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the API Version of the API Management API.
        """
        return pulumi.get(self, "version_description")

    @version_description.setter
    def version_description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_description", value)

    @_builtins.property
    @pulumi.getter(name="versionSetId")
    def version_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Version Set which this API is associated with.

        > **Note:** When `version` is set, `version_set_id` must also be specified
        """
        return pulumi.get(self, "version_set_id")

    @version_set_id.setter
    def version_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_set_id", value)


@pulumi.type_token("azure:apimanagement/api:Api")
class Api(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                 api_type: Optional[pulumi.Input[_builtins.str]] = None,
                 contact: Optional[pulumi.Input[Union['ApiContactArgs', 'ApiContactArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 import_: Optional[pulumi.Input[Union['ApiImportArgs', 'ApiImportArgsDict']]] = None,
                 license: Optional[pulumi.Input[Union['ApiLicenseArgs', 'ApiLicenseArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth2_authorization: Optional[pulumi.Input[Union['ApiOauth2AuthorizationArgs', 'ApiOauth2AuthorizationArgsDict']]] = None,
                 openid_authentication: Optional[pulumi.Input[Union['ApiOpenidAuthenticationArgs', 'ApiOpenidAuthenticationArgsDict']]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 revision: Optional[pulumi.Input[_builtins.str]] = None,
                 revision_description: Optional[pulumi.Input[_builtins.str]] = None,
                 service_url: Optional[pulumi.Input[_builtins.str]] = None,
                 source_api_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_key_parameter_names: Optional[pulumi.Input[Union['ApiSubscriptionKeyParameterNamesArgs', 'ApiSubscriptionKeyParameterNamesArgsDict']]] = None,
                 subscription_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 terms_of_service_url: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 version_description: Optional[pulumi.Input[_builtins.str]] = None,
                 version_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an API within an API Management Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="My Company",
            publisher_email="company@exmaple.com",
            sku_name="Developer_1")
        example_api = azure.apimanagement.Api("example",
            name="example-api",
            resource_group_name=example.name,
            api_management_name=example_service.name,
            revision="1",
            display_name="Example API",
            path="example",
            protocols=["https"],
            import_={
                "content_format": "swagger-link-json",
                "content_value": "https://raw.githubusercontent.com/hashicorp/terraform-provider-azurerm/refs/heads/main/internal/services/apimanagement/testdata/api_management_api_schema_swagger.json",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement` - 2022-08-01

        ## Import

        API Management API's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/api:Api example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ApiManagement/service/instance1/apis/api1;rev=1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_name: The Name of the API Management Service where this API should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] api_type: Type of API. Possible values are `graphql`, `http`, `soap`, and `websocket`. Defaults to `http`.
        :param pulumi.Input[Union['ApiContactArgs', 'ApiContactArgsDict']] contact: A `contact` block as documented below.
        :param pulumi.Input[_builtins.str] description: A description of the API Management API, which may include HTML formatting tags.
        :param pulumi.Input[_builtins.str] display_name: The display name of the API.
        :param pulumi.Input[Union['ApiImportArgs', 'ApiImportArgsDict']] import_: A `import` block as documented below.
               
               > **Note:** The `display_name`, `description`, `contact`, and `license` fields can be imported by the `import` block, which might cause a drift if these fields are set along with the `import` block.
        :param pulumi.Input[Union['ApiLicenseArgs', 'ApiLicenseArgsDict']] license: A `license` block as documented below.
        :param pulumi.Input[_builtins.str] name: The name of the API Management API. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ApiOauth2AuthorizationArgs', 'ApiOauth2AuthorizationArgsDict']] oauth2_authorization: An `oauth2_authorization` block as documented below.
        :param pulumi.Input[Union['ApiOpenidAuthenticationArgs', 'ApiOpenidAuthenticationArgsDict']] openid_authentication: An `openid_authentication` block as documented below.
        :param pulumi.Input[_builtins.str] path: The Path for this API Management API, which is a relative URL which uniquely identifies this API and all of its resource paths within the API Management Service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protocols: A list of protocols the operations in this API can be invoked. Possible values are `http`, `https`, `ws`, and `wss`.
               
               > **Note:** `display_name`, `path` and `protocols` are required when `source_api_id` is not set.
        :param pulumi.Input[_builtins.str] resource_group_name: The Name of the Resource Group where the API Management API exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] revision: The Revision which used for this API. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] revision_description: The description of the API Revision of the API Management API.
        :param pulumi.Input[_builtins.str] service_url: Absolute URL of the backend service implementing this API.
               
               > **Note:** The `service_url` is required when `api_type` is specified as `websocket`.
        :param pulumi.Input[_builtins.str] source_api_id: The API id of the source API, which could be in format `azurerm_api_management_api.example.id` or in format `azurerm_api_management_api.example.id;rev=1`
        :param pulumi.Input[Union['ApiSubscriptionKeyParameterNamesArgs', 'ApiSubscriptionKeyParameterNamesArgsDict']] subscription_key_parameter_names: A `subscription_key_parameter_names` block as documented below.
        :param pulumi.Input[_builtins.bool] subscription_required: Should this API require a subscription key? Defaults to `true`.
        :param pulumi.Input[_builtins.str] terms_of_service_url: Absolute URL of the Terms of Service for the API.
        :param pulumi.Input[_builtins.str] version: The Version number of this API, if this API is versioned.
        :param pulumi.Input[_builtins.str] version_description: The description of the API Version of the API Management API.
        :param pulumi.Input[_builtins.str] version_set_id: The ID of the Version Set which this API is associated with.
               
               > **Note:** When `version` is set, `version_set_id` must also be specified
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ApiArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an API within an API Management Service.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="My Company",
            publisher_email="company@exmaple.com",
            sku_name="Developer_1")
        example_api = azure.apimanagement.Api("example",
            name="example-api",
            resource_group_name=example.name,
            api_management_name=example_service.name,
            revision="1",
            display_name="Example API",
            path="example",
            protocols=["https"],
            import_={
                "content_format": "swagger-link-json",
                "content_value": "https://raw.githubusercontent.com/hashicorp/terraform-provider-azurerm/refs/heads/main/internal/services/apimanagement/testdata/api_management_api_schema_swagger.json",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement` - 2022-08-01

        ## Import

        API Management API's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/api:Api example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ApiManagement/service/instance1/apis/api1;rev=1
        ```

        :param str resource_name: The name of the resource.
        :param ApiArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ApiArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                 api_type: Optional[pulumi.Input[_builtins.str]] = None,
                 contact: Optional[pulumi.Input[Union['ApiContactArgs', 'ApiContactArgsDict']]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 import_: Optional[pulumi.Input[Union['ApiImportArgs', 'ApiImportArgsDict']]] = None,
                 license: Optional[pulumi.Input[Union['ApiLicenseArgs', 'ApiLicenseArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 oauth2_authorization: Optional[pulumi.Input[Union['ApiOauth2AuthorizationArgs', 'ApiOauth2AuthorizationArgsDict']]] = None,
                 openid_authentication: Optional[pulumi.Input[Union['ApiOpenidAuthenticationArgs', 'ApiOpenidAuthenticationArgsDict']]] = None,
                 path: Optional[pulumi.Input[_builtins.str]] = None,
                 protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 revision: Optional[pulumi.Input[_builtins.str]] = None,
                 revision_description: Optional[pulumi.Input[_builtins.str]] = None,
                 service_url: Optional[pulumi.Input[_builtins.str]] = None,
                 source_api_id: Optional[pulumi.Input[_builtins.str]] = None,
                 subscription_key_parameter_names: Optional[pulumi.Input[Union['ApiSubscriptionKeyParameterNamesArgs', 'ApiSubscriptionKeyParameterNamesArgsDict']]] = None,
                 subscription_required: Optional[pulumi.Input[_builtins.bool]] = None,
                 terms_of_service_url: Optional[pulumi.Input[_builtins.str]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 version_description: Optional[pulumi.Input[_builtins.str]] = None,
                 version_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ApiArgs.__new__(ApiArgs)

            if api_management_name is None and not opts.urn:
                raise TypeError("Missing required property 'api_management_name'")
            __props__.__dict__["api_management_name"] = api_management_name
            __props__.__dict__["api_type"] = api_type
            __props__.__dict__["contact"] = contact
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["import_"] = import_
            __props__.__dict__["license"] = license
            __props__.__dict__["name"] = name
            __props__.__dict__["oauth2_authorization"] = oauth2_authorization
            __props__.__dict__["openid_authentication"] = openid_authentication
            __props__.__dict__["path"] = path
            __props__.__dict__["protocols"] = protocols
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if revision is None and not opts.urn:
                raise TypeError("Missing required property 'revision'")
            __props__.__dict__["revision"] = revision
            __props__.__dict__["revision_description"] = revision_description
            __props__.__dict__["service_url"] = service_url
            __props__.__dict__["source_api_id"] = source_api_id
            __props__.__dict__["subscription_key_parameter_names"] = subscription_key_parameter_names
            __props__.__dict__["subscription_required"] = subscription_required
            __props__.__dict__["terms_of_service_url"] = terms_of_service_url
            __props__.__dict__["version"] = version
            __props__.__dict__["version_description"] = version_description
            __props__.__dict__["version_set_id"] = version_set_id
            __props__.__dict__["is_current"] = None
            __props__.__dict__["is_online"] = None
        super(Api, __self__).__init__(
            'azure:apimanagement/api:Api',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
            api_type: Optional[pulumi.Input[_builtins.str]] = None,
            contact: Optional[pulumi.Input[Union['ApiContactArgs', 'ApiContactArgsDict']]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            import_: Optional[pulumi.Input[Union['ApiImportArgs', 'ApiImportArgsDict']]] = None,
            is_current: Optional[pulumi.Input[_builtins.bool]] = None,
            is_online: Optional[pulumi.Input[_builtins.bool]] = None,
            license: Optional[pulumi.Input[Union['ApiLicenseArgs', 'ApiLicenseArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            oauth2_authorization: Optional[pulumi.Input[Union['ApiOauth2AuthorizationArgs', 'ApiOauth2AuthorizationArgsDict']]] = None,
            openid_authentication: Optional[pulumi.Input[Union['ApiOpenidAuthenticationArgs', 'ApiOpenidAuthenticationArgsDict']]] = None,
            path: Optional[pulumi.Input[_builtins.str]] = None,
            protocols: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            revision: Optional[pulumi.Input[_builtins.str]] = None,
            revision_description: Optional[pulumi.Input[_builtins.str]] = None,
            service_url: Optional[pulumi.Input[_builtins.str]] = None,
            source_api_id: Optional[pulumi.Input[_builtins.str]] = None,
            subscription_key_parameter_names: Optional[pulumi.Input[Union['ApiSubscriptionKeyParameterNamesArgs', 'ApiSubscriptionKeyParameterNamesArgsDict']]] = None,
            subscription_required: Optional[pulumi.Input[_builtins.bool]] = None,
            terms_of_service_url: Optional[pulumi.Input[_builtins.str]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None,
            version_description: Optional[pulumi.Input[_builtins.str]] = None,
            version_set_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Api':
        """
        Get an existing Api resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_name: The Name of the API Management Service where this API should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] api_type: Type of API. Possible values are `graphql`, `http`, `soap`, and `websocket`. Defaults to `http`.
        :param pulumi.Input[Union['ApiContactArgs', 'ApiContactArgsDict']] contact: A `contact` block as documented below.
        :param pulumi.Input[_builtins.str] description: A description of the API Management API, which may include HTML formatting tags.
        :param pulumi.Input[_builtins.str] display_name: The display name of the API.
        :param pulumi.Input[Union['ApiImportArgs', 'ApiImportArgsDict']] import_: A `import` block as documented below.
               
               > **Note:** The `display_name`, `description`, `contact`, and `license` fields can be imported by the `import` block, which might cause a drift if these fields are set along with the `import` block.
        :param pulumi.Input[_builtins.bool] is_current: Is this the current API Revision?
        :param pulumi.Input[_builtins.bool] is_online: Is this API Revision online/accessible via the Gateway?
        :param pulumi.Input[Union['ApiLicenseArgs', 'ApiLicenseArgsDict']] license: A `license` block as documented below.
        :param pulumi.Input[_builtins.str] name: The name of the API Management API. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['ApiOauth2AuthorizationArgs', 'ApiOauth2AuthorizationArgsDict']] oauth2_authorization: An `oauth2_authorization` block as documented below.
        :param pulumi.Input[Union['ApiOpenidAuthenticationArgs', 'ApiOpenidAuthenticationArgsDict']] openid_authentication: An `openid_authentication` block as documented below.
        :param pulumi.Input[_builtins.str] path: The Path for this API Management API, which is a relative URL which uniquely identifies this API and all of its resource paths within the API Management Service.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] protocols: A list of protocols the operations in this API can be invoked. Possible values are `http`, `https`, `ws`, and `wss`.
               
               > **Note:** `display_name`, `path` and `protocols` are required when `source_api_id` is not set.
        :param pulumi.Input[_builtins.str] resource_group_name: The Name of the Resource Group where the API Management API exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] revision: The Revision which used for this API. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] revision_description: The description of the API Revision of the API Management API.
        :param pulumi.Input[_builtins.str] service_url: Absolute URL of the backend service implementing this API.
               
               > **Note:** The `service_url` is required when `api_type` is specified as `websocket`.
        :param pulumi.Input[_builtins.str] source_api_id: The API id of the source API, which could be in format `azurerm_api_management_api.example.id` or in format `azurerm_api_management_api.example.id;rev=1`
        :param pulumi.Input[Union['ApiSubscriptionKeyParameterNamesArgs', 'ApiSubscriptionKeyParameterNamesArgsDict']] subscription_key_parameter_names: A `subscription_key_parameter_names` block as documented below.
        :param pulumi.Input[_builtins.bool] subscription_required: Should this API require a subscription key? Defaults to `true`.
        :param pulumi.Input[_builtins.str] terms_of_service_url: Absolute URL of the Terms of Service for the API.
        :param pulumi.Input[_builtins.str] version: The Version number of this API, if this API is versioned.
        :param pulumi.Input[_builtins.str] version_description: The description of the API Version of the API Management API.
        :param pulumi.Input[_builtins.str] version_set_id: The ID of the Version Set which this API is associated with.
               
               > **Note:** When `version` is set, `version_set_id` must also be specified
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ApiState.__new__(_ApiState)

        __props__.__dict__["api_management_name"] = api_management_name
        __props__.__dict__["api_type"] = api_type
        __props__.__dict__["contact"] = contact
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["import_"] = import_
        __props__.__dict__["is_current"] = is_current
        __props__.__dict__["is_online"] = is_online
        __props__.__dict__["license"] = license
        __props__.__dict__["name"] = name
        __props__.__dict__["oauth2_authorization"] = oauth2_authorization
        __props__.__dict__["openid_authentication"] = openid_authentication
        __props__.__dict__["path"] = path
        __props__.__dict__["protocols"] = protocols
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["revision"] = revision
        __props__.__dict__["revision_description"] = revision_description
        __props__.__dict__["service_url"] = service_url
        __props__.__dict__["source_api_id"] = source_api_id
        __props__.__dict__["subscription_key_parameter_names"] = subscription_key_parameter_names
        __props__.__dict__["subscription_required"] = subscription_required
        __props__.__dict__["terms_of_service_url"] = terms_of_service_url
        __props__.__dict__["version"] = version
        __props__.__dict__["version_description"] = version_description
        __props__.__dict__["version_set_id"] = version_set_id
        return Api(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Name of the API Management Service where this API should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @_builtins.property
    @pulumi.getter(name="apiType")
    def api_type(self) -> pulumi.Output[_builtins.str]:
        """
        Type of API. Possible values are `graphql`, `http`, `soap`, and `websocket`. Defaults to `http`.
        """
        return pulumi.get(self, "api_type")

    @_builtins.property
    @pulumi.getter
    def contact(self) -> pulumi.Output[Optional['outputs.ApiContact']]:
        """
        A `contact` block as documented below.
        """
        return pulumi.get(self, "contact")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description of the API Management API, which may include HTML formatting tags.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        The display name of the API.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="import")
    def import_(self) -> pulumi.Output[Optional['outputs.ApiImport']]:
        """
        A `import` block as documented below.

        > **Note:** The `display_name`, `description`, `contact`, and `license` fields can be imported by the `import` block, which might cause a drift if these fields are set along with the `import` block.
        """
        return pulumi.get(self, "import_")

    @_builtins.property
    @pulumi.getter(name="isCurrent")
    def is_current(self) -> pulumi.Output[_builtins.bool]:
        """
        Is this the current API Revision?
        """
        return pulumi.get(self, "is_current")

    @_builtins.property
    @pulumi.getter(name="isOnline")
    def is_online(self) -> pulumi.Output[_builtins.bool]:
        """
        Is this API Revision online/accessible via the Gateway?
        """
        return pulumi.get(self, "is_online")

    @_builtins.property
    @pulumi.getter
    def license(self) -> pulumi.Output[Optional['outputs.ApiLicense']]:
        """
        A `license` block as documented below.
        """
        return pulumi.get(self, "license")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the API Management API. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="oauth2Authorization")
    def oauth2_authorization(self) -> pulumi.Output[Optional['outputs.ApiOauth2Authorization']]:
        """
        An `oauth2_authorization` block as documented below.
        """
        return pulumi.get(self, "oauth2_authorization")

    @_builtins.property
    @pulumi.getter(name="openidAuthentication")
    def openid_authentication(self) -> pulumi.Output[Optional['outputs.ApiOpenidAuthentication']]:
        """
        An `openid_authentication` block as documented below.
        """
        return pulumi.get(self, "openid_authentication")

    @_builtins.property
    @pulumi.getter
    def path(self) -> pulumi.Output[_builtins.str]:
        """
        The Path for this API Management API, which is a relative URL which uniquely identifies this API and all of its resource paths within the API Management Service.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def protocols(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of protocols the operations in this API can be invoked. Possible values are `http`, `https`, `ws`, and `wss`.

        > **Note:** `display_name`, `path` and `protocols` are required when `source_api_id` is not set.
        """
        return pulumi.get(self, "protocols")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Name of the Resource Group where the API Management API exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def revision(self) -> pulumi.Output[_builtins.str]:
        """
        The Revision which used for this API. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "revision")

    @_builtins.property
    @pulumi.getter(name="revisionDescription")
    def revision_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the API Revision of the API Management API.
        """
        return pulumi.get(self, "revision_description")

    @_builtins.property
    @pulumi.getter(name="serviceUrl")
    def service_url(self) -> pulumi.Output[_builtins.str]:
        """
        Absolute URL of the backend service implementing this API.

        > **Note:** The `service_url` is required when `api_type` is specified as `websocket`.
        """
        return pulumi.get(self, "service_url")

    @_builtins.property
    @pulumi.getter(name="sourceApiId")
    def source_api_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The API id of the source API, which could be in format `azurerm_api_management_api.example.id` or in format `azurerm_api_management_api.example.id;rev=1`
        """
        return pulumi.get(self, "source_api_id")

    @_builtins.property
    @pulumi.getter(name="subscriptionKeyParameterNames")
    def subscription_key_parameter_names(self) -> pulumi.Output['outputs.ApiSubscriptionKeyParameterNames']:
        """
        A `subscription_key_parameter_names` block as documented below.
        """
        return pulumi.get(self, "subscription_key_parameter_names")

    @_builtins.property
    @pulumi.getter(name="subscriptionRequired")
    def subscription_required(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should this API require a subscription key? Defaults to `true`.
        """
        return pulumi.get(self, "subscription_required")

    @_builtins.property
    @pulumi.getter(name="termsOfServiceUrl")
    def terms_of_service_url(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Absolute URL of the Terms of Service for the API.
        """
        return pulumi.get(self, "terms_of_service_url")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The Version number of this API, if this API is versioned.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="versionDescription")
    def version_description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the API Version of the API Management API.
        """
        return pulumi.get(self, "version_description")

    @_builtins.property
    @pulumi.getter(name="versionSetId")
    def version_set_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Version Set which this API is associated with.

        > **Note:** When `version` is set, `version_set_id` must also be specified
        """
        return pulumi.get(self, "version_set_id")

