# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetSubscriptionResult',
    'AwaitableGetSubscriptionResult',
    'get_subscription',
    'get_subscription_output',
]

@pulumi.output_type
class GetSubscriptionResult:
    """
    A collection of values returned by getSubscription.
    """
    def __init__(__self__, allow_tracing=None, api_id=None, api_management_id=None, display_name=None, id=None, primary_key=None, product_id=None, secondary_key=None, state=None, subscription_id=None, user_id=None):
        if allow_tracing and not isinstance(allow_tracing, bool):
            raise TypeError("Expected argument 'allow_tracing' to be a bool")
        pulumi.set(__self__, "allow_tracing", allow_tracing)
        if api_id and not isinstance(api_id, str):
            raise TypeError("Expected argument 'api_id' to be a str")
        pulumi.set(__self__, "api_id", api_id)
        if api_management_id and not isinstance(api_management_id, str):
            raise TypeError("Expected argument 'api_management_id' to be a str")
        pulumi.set(__self__, "api_management_id", api_management_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if primary_key and not isinstance(primary_key, str):
            raise TypeError("Expected argument 'primary_key' to be a str")
        pulumi.set(__self__, "primary_key", primary_key)
        if product_id and not isinstance(product_id, str):
            raise TypeError("Expected argument 'product_id' to be a str")
        pulumi.set(__self__, "product_id", product_id)
        if secondary_key and not isinstance(secondary_key, str):
            raise TypeError("Expected argument 'secondary_key' to be a str")
        pulumi.set(__self__, "secondary_key", secondary_key)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subscription_id and not isinstance(subscription_id, str):
            raise TypeError("Expected argument 'subscription_id' to be a str")
        pulumi.set(__self__, "subscription_id", subscription_id)
        if user_id and not isinstance(user_id, str):
            raise TypeError("Expected argument 'user_id' to be a str")
        pulumi.set(__self__, "user_id", user_id)

    @_builtins.property
    @pulumi.getter(name="allowTracing")
    def allow_tracing(self) -> _builtins.bool:
        """
        Indicates whether tracing is enabled.
        """
        return pulumi.get(self, "allow_tracing")

    @_builtins.property
    @pulumi.getter(name="apiId")
    def api_id(self) -> _builtins.str:
        """
        The ID of the API assigned to this Subscription.
        """
        return pulumi.get(self, "api_id")

    @_builtins.property
    @pulumi.getter(name="apiManagementId")
    def api_management_id(self) -> _builtins.str:
        return pulumi.get(self, "api_management_id")

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> _builtins.str:
        """
        The display name of this Subscription.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> _builtins.str:
        """
        The primary key for this subscription.
        """
        return pulumi.get(self, "primary_key")

    @_builtins.property
    @pulumi.getter(name="productId")
    def product_id(self) -> _builtins.str:
        """
        The ID of the Product assigned to this Subscription.
        """
        return pulumi.get(self, "product_id")

    @_builtins.property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> _builtins.str:
        """
        The secondary key for this subscription.
        """
        return pulumi.get(self, "secondary_key")

    @_builtins.property
    @pulumi.getter
    def state(self) -> _builtins.str:
        """
        The state of this Subscription.
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="subscriptionId")
    def subscription_id(self) -> _builtins.str:
        return pulumi.get(self, "subscription_id")

    @_builtins.property
    @pulumi.getter(name="userId")
    def user_id(self) -> _builtins.str:
        """
        The ID of the User assigned to this Subscription.
        """
        return pulumi.get(self, "user_id")


class AwaitableGetSubscriptionResult(GetSubscriptionResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSubscriptionResult(
            allow_tracing=self.allow_tracing,
            api_id=self.api_id,
            api_management_id=self.api_management_id,
            display_name=self.display_name,
            id=self.id,
            primary_key=self.primary_key,
            product_id=self.product_id,
            secondary_key=self.secondary_key,
            state=self.state,
            subscription_id=self.subscription_id,
            user_id=self.user_id)


def get_subscription(api_management_id: Optional[_builtins.str] = None,
                     subscription_id: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSubscriptionResult:
    """
    Use this data source to access information about an existing API Management Subscription.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.apimanagement.get_subscription(api_management_id="example-apim",
        subscription_id="example-subscription-id")
    pulumi.export("id", example.subscription_id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ApiManagement` - 2022-08-01


    :param _builtins.str api_management_id: The ID of the API Management Service in which this Subscription exists.
    :param _builtins.str subscription_id: The Identifier for the API Management Subscription.
    """
    __args__ = dict()
    __args__['apiManagementId'] = api_management_id
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:apimanagement/getSubscription:getSubscription', __args__, opts=opts, typ=GetSubscriptionResult).value

    return AwaitableGetSubscriptionResult(
        allow_tracing=pulumi.get(__ret__, 'allow_tracing'),
        api_id=pulumi.get(__ret__, 'api_id'),
        api_management_id=pulumi.get(__ret__, 'api_management_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        primary_key=pulumi.get(__ret__, 'primary_key'),
        product_id=pulumi.get(__ret__, 'product_id'),
        secondary_key=pulumi.get(__ret__, 'secondary_key'),
        state=pulumi.get(__ret__, 'state'),
        subscription_id=pulumi.get(__ret__, 'subscription_id'),
        user_id=pulumi.get(__ret__, 'user_id'))
def get_subscription_output(api_management_id: Optional[pulumi.Input[_builtins.str]] = None,
                            subscription_id: Optional[pulumi.Input[_builtins.str]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetSubscriptionResult]:
    """
    Use this data source to access information about an existing API Management Subscription.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.apimanagement.get_subscription(api_management_id="example-apim",
        subscription_id="example-subscription-id")
    pulumi.export("id", example.subscription_id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ApiManagement` - 2022-08-01


    :param _builtins.str api_management_id: The ID of the API Management Service in which this Subscription exists.
    :param _builtins.str subscription_id: The Identifier for the API Management Subscription.
    """
    __args__ = dict()
    __args__['apiManagementId'] = api_management_id
    __args__['subscriptionId'] = subscription_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:apimanagement/getSubscription:getSubscription', __args__, opts=opts, typ=GetSubscriptionResult)
    return __ret__.apply(lambda __response__: GetSubscriptionResult(
        allow_tracing=pulumi.get(__response__, 'allow_tracing'),
        api_id=pulumi.get(__response__, 'api_id'),
        api_management_id=pulumi.get(__response__, 'api_management_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        id=pulumi.get(__response__, 'id'),
        primary_key=pulumi.get(__response__, 'primary_key'),
        product_id=pulumi.get(__response__, 'product_id'),
        secondary_key=pulumi.get(__response__, 'secondary_key'),
        state=pulumi.get(__response__, 'state'),
        subscription_id=pulumi.get(__response__, 'subscription_id'),
        user_id=pulumi.get(__response__, 'user_id')))
