# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['IdentityProviderMicrosoftArgs', 'IdentityProviderMicrosoft']

@pulumi.input_type
class IdentityProviderMicrosoftArgs:
    def __init__(__self__, *,
                 api_management_name: pulumi.Input[_builtins.str],
                 client_id: pulumi.Input[_builtins.str],
                 client_secret: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str]):
        """
        The set of arguments for constructing a IdentityProviderMicrosoft resource.
        :param pulumi.Input[_builtins.str] api_management_name: The Name of the API Management Service where this Microsoft Identity Provider should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] client_id: Client Id of the Azure AD Application.
        :param pulumi.Input[_builtins.str] client_secret: Client secret of the Azure AD Application.
        :param pulumi.Input[_builtins.str] resource_group_name: The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "api_management_name", api_management_name)
        pulumi.set(__self__, "client_id", client_id)
        pulumi.set(__self__, "client_secret", client_secret)
        pulumi.set(__self__, "resource_group_name", resource_group_name)

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Name of the API Management Service where this Microsoft Identity Provider should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @api_management_name.setter
    def api_management_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "api_management_name", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Input[_builtins.str]:
        """
        Client Id of the Azure AD Application.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Input[_builtins.str]:
        """
        Client secret of the Azure AD Application.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)


@pulumi.input_type
class _IdentityProviderMicrosoftState:
    def __init__(__self__, *,
                 api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering IdentityProviderMicrosoft resources.
        :param pulumi.Input[_builtins.str] api_management_name: The Name of the API Management Service where this Microsoft Identity Provider should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] client_id: Client Id of the Azure AD Application.
        :param pulumi.Input[_builtins.str] client_secret: Client secret of the Azure AD Application.
        :param pulumi.Input[_builtins.str] resource_group_name: The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.
        """
        if api_management_name is not None:
            pulumi.set(__self__, "api_management_name", api_management_name)
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if client_secret is not None:
            pulumi.set(__self__, "client_secret", client_secret)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name of the API Management Service where this Microsoft Identity Provider should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @api_management_name.setter
    def api_management_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "api_management_name", value)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client Id of the Azure AD Application.
        """
        return pulumi.get(self, "client_id")

    @client_id.setter
    def client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_id", value)

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Client secret of the Azure AD Application.
        """
        return pulumi.get(self, "client_secret")

    @client_secret.setter
    def client_secret(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_secret", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)


@pulumi.type_token("azure:apimanagement/identityProviderMicrosoft:IdentityProviderMicrosoft")
class IdentityProviderMicrosoft(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an API Management Microsoft Identity Provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="My Company",
            publisher_email="company@mycompany.io",
            sku_name="Developer_1")
        example_identity_provider_microsoft = azure.apimanagement.IdentityProviderMicrosoft("example",
            resource_group_name=example.name,
            api_management_name=example_service.name,
            client_id="00000000-0000-0000-0000-000000000000",
            client_secret="00000000000000000000000000000000")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement` - 2022-08-01

        ## Import

        API Management Microsoft Identity Provider can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/identityProviderMicrosoft:IdentityProviderMicrosoft example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ApiManagement/service/instance1/identityProviders/microsoft
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_name: The Name of the API Management Service where this Microsoft Identity Provider should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] client_id: Client Id of the Azure AD Application.
        :param pulumi.Input[_builtins.str] client_secret: Client secret of the Azure AD Application.
        :param pulumi.Input[_builtins.str] resource_group_name: The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IdentityProviderMicrosoftArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an API Management Microsoft Identity Provider.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_service = azure.apimanagement.Service("example",
            name="example-apim",
            location=example.location,
            resource_group_name=example.name,
            publisher_name="My Company",
            publisher_email="company@mycompany.io",
            sku_name="Developer_1")
        example_identity_provider_microsoft = azure.apimanagement.IdentityProviderMicrosoft("example",
            resource_group_name=example.name,
            api_management_name=example_service.name,
            client_id="00000000-0000-0000-0000-000000000000",
            client_secret="00000000000000000000000000000000")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement` - 2022-08-01

        ## Import

        API Management Microsoft Identity Provider can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/identityProviderMicrosoft:IdentityProviderMicrosoft example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.ApiManagement/service/instance1/identityProviders/microsoft
        ```

        :param str resource_name: The name of the resource.
        :param IdentityProviderMicrosoftArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IdentityProviderMicrosoftArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
                 client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 client_secret: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IdentityProviderMicrosoftArgs.__new__(IdentityProviderMicrosoftArgs)

            if api_management_name is None and not opts.urn:
                raise TypeError("Missing required property 'api_management_name'")
            __props__.__dict__["api_management_name"] = api_management_name
            if client_id is None and not opts.urn:
                raise TypeError("Missing required property 'client_id'")
            __props__.__dict__["client_id"] = client_id
            if client_secret is None and not opts.urn:
                raise TypeError("Missing required property 'client_secret'")
            __props__.__dict__["client_secret"] = None if client_secret is None else pulumi.Output.secret(client_secret)
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["clientSecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(IdentityProviderMicrosoft, __self__).__init__(
            'azure:apimanagement/identityProviderMicrosoft:IdentityProviderMicrosoft',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            api_management_name: Optional[pulumi.Input[_builtins.str]] = None,
            client_id: Optional[pulumi.Input[_builtins.str]] = None,
            client_secret: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'IdentityProviderMicrosoft':
        """
        Get an existing IdentityProviderMicrosoft resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] api_management_name: The Name of the API Management Service where this Microsoft Identity Provider should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] client_id: Client Id of the Azure AD Application.
        :param pulumi.Input[_builtins.str] client_secret: Client secret of the Azure AD Application.
        :param pulumi.Input[_builtins.str] resource_group_name: The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IdentityProviderMicrosoftState.__new__(_IdentityProviderMicrosoftState)

        __props__.__dict__["api_management_name"] = api_management_name
        __props__.__dict__["client_id"] = client_id
        __props__.__dict__["client_secret"] = client_secret
        __props__.__dict__["resource_group_name"] = resource_group_name
        return IdentityProviderMicrosoft(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="apiManagementName")
    def api_management_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Name of the API Management Service where this Microsoft Identity Provider should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "api_management_name")

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> pulumi.Output[_builtins.str]:
        """
        Client Id of the Azure AD Application.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="clientSecret")
    def client_secret(self) -> pulumi.Output[_builtins.str]:
        """
        Client secret of the Azure AD Application.
        """
        return pulumi.get(self, "client_secret")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The Name of the Resource Group where the API Management Service exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

