# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StandaloneGatewayArgs', 'StandaloneGateway']

@pulumi.input_type
class StandaloneGatewayArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku: pulumi.Input['StandaloneGatewaySkuArgs'],
                 backend_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_network_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a StandaloneGateway resource.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the API Management Standalone Gateway should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['StandaloneGatewaySkuArgs'] sku: A `sku` block as defined below.
        :param pulumi.Input[_builtins.str] backend_subnet_id: Specifies the subnet ID in which the backend systems are hosted. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the API Management Standalone Gateway should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this API Management Standalone Gateway. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the API Management Standalone Gateway. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_network_type: Specifies the type of VPN in which API Management gateway needs to be configured. Possible values are `External` and `Internal`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku", sku)
        if backend_subnet_id is not None:
            pulumi.set(__self__, "backend_subnet_id", backend_subnet_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_network_type is not None:
            pulumi.set(__self__, "virtual_network_type", virtual_network_type)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Resource Group where the API Management Standalone Gateway should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Input['StandaloneGatewaySkuArgs']:
        """
        A `sku` block as defined below.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input['StandaloneGatewaySkuArgs']):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="backendSubnetId")
    def backend_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the subnet ID in which the backend systems are hosted. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "backend_subnet_id")

    @backend_subnet_id.setter
    def backend_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend_subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the API Management Standalone Gateway should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this API Management Standalone Gateway. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the API Management Standalone Gateway. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkType")
    def virtual_network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of VPN in which API Management gateway needs to be configured. Possible values are `External` and `Internal`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_network_type")

    @virtual_network_type.setter
    def virtual_network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_type", value)


@pulumi.input_type
class _StandaloneGatewayState:
    def __init__(__self__, *,
                 backend_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input['StandaloneGatewaySkuArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_network_type: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering StandaloneGateway resources.
        :param pulumi.Input[_builtins.str] backend_subnet_id: Specifies the subnet ID in which the backend systems are hosted. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the API Management Standalone Gateway should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this API Management Standalone Gateway. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the API Management Standalone Gateway should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['StandaloneGatewaySkuArgs'] sku: A `sku` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the API Management Standalone Gateway. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_network_type: Specifies the type of VPN in which API Management gateway needs to be configured. Possible values are `External` and `Internal`. Changing this forces a new resource to be created.
        """
        if backend_subnet_id is not None:
            pulumi.set(__self__, "backend_subnet_id", backend_subnet_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_network_type is not None:
            pulumi.set(__self__, "virtual_network_type", virtual_network_type)

    @_builtins.property
    @pulumi.getter(name="backendSubnetId")
    def backend_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the subnet ID in which the backend systems are hosted. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "backend_subnet_id")

    @backend_subnet_id.setter
    def backend_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend_subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the API Management Standalone Gateway should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name which should be used for this API Management Standalone Gateway. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Resource Group where the API Management Standalone Gateway should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['StandaloneGatewaySkuArgs']]:
        """
        A `sku` block as defined below.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['StandaloneGatewaySkuArgs']]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the API Management Standalone Gateway. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkType")
    def virtual_network_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the type of VPN in which API Management gateway needs to be configured. Possible values are `External` and `Internal`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_network_type")

    @virtual_network_type.setter
    def virtual_network_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_type", value)


@pulumi.type_token("azure:apimanagement/standaloneGateway:StandaloneGateway")
class StandaloneGateway(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[Union['StandaloneGatewaySkuArgs', 'StandaloneGatewaySkuArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure API Management Standalone Gateway.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"],
            delegations=[{
                "name": "apim-delegation",
                "service_delegation": {
                    "name": "Microsoft.Web/serverFarms",
                    "actions": ["Microsoft.Network/virtualNetworks/subnets/action"],
                },
            }])
        example_standalone_gateway = azure.apimanagement.StandaloneGateway("example",
            name="example-gateway-flexible",
            resource_group_name=example.name,
            location=example.location,
            virtual_network_type="External",
            backend_subnet_id=example_subnet.id,
            sku={
                "capacity": 1,
                "name": "WorkspaceGatewayPremium",
            },
            tags={
                "Hello": "World",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement` - 2024-05-01

        ## Import

        API Management Standalone Gateway can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/standaloneGateway:StandaloneGateway example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ApiManagement/gateways/gateway1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend_subnet_id: Specifies the subnet ID in which the backend systems are hosted. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the API Management Standalone Gateway should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this API Management Standalone Gateway. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the API Management Standalone Gateway should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['StandaloneGatewaySkuArgs', 'StandaloneGatewaySkuArgsDict']] sku: A `sku` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the API Management Standalone Gateway. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_network_type: Specifies the type of VPN in which API Management gateway needs to be configured. Possible values are `External` and `Internal`. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StandaloneGatewayArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure API Management Standalone Gateway.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.1.0/24"],
            delegations=[{
                "name": "apim-delegation",
                "service_delegation": {
                    "name": "Microsoft.Web/serverFarms",
                    "actions": ["Microsoft.Network/virtualNetworks/subnets/action"],
                },
            }])
        example_standalone_gateway = azure.apimanagement.StandaloneGateway("example",
            name="example-gateway-flexible",
            resource_group_name=example.name,
            location=example.location,
            virtual_network_type="External",
            backend_subnet_id=example_subnet.id,
            sku={
                "capacity": 1,
                "name": "WorkspaceGatewayPremium",
            },
            tags={
                "Hello": "World",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.ApiManagement` - 2024-05-01

        ## Import

        API Management Standalone Gateway can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:apimanagement/standaloneGateway:StandaloneGateway example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.ApiManagement/gateways/gateway1
        ```

        :param str resource_name: The name of the resource.
        :param StandaloneGatewayArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StandaloneGatewayArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[Union['StandaloneGatewaySkuArgs', 'StandaloneGatewaySkuArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_network_type: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StandaloneGatewayArgs.__new__(StandaloneGatewayArgs)

            __props__.__dict__["backend_subnet_id"] = backend_subnet_id
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            __props__.__dict__["tags"] = tags
            __props__.__dict__["virtual_network_type"] = virtual_network_type
        super(StandaloneGateway, __self__).__init__(
            'azure:apimanagement/standaloneGateway:StandaloneGateway',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku: Optional[pulumi.Input[Union['StandaloneGatewaySkuArgs', 'StandaloneGatewaySkuArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            virtual_network_type: Optional[pulumi.Input[_builtins.str]] = None) -> 'StandaloneGateway':
        """
        Get an existing StandaloneGateway resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] backend_subnet_id: Specifies the subnet ID in which the backend systems are hosted. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the API Management Standalone Gateway should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name which should be used for this API Management Standalone Gateway. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the API Management Standalone Gateway should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['StandaloneGatewaySkuArgs', 'StandaloneGatewaySkuArgsDict']] sku: A `sku` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the API Management Standalone Gateway. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_network_type: Specifies the type of VPN in which API Management gateway needs to be configured. Possible values are `External` and `Internal`. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StandaloneGatewayState.__new__(_StandaloneGatewayState)

        __props__.__dict__["backend_subnet_id"] = backend_subnet_id
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku"] = sku
        __props__.__dict__["tags"] = tags
        __props__.__dict__["virtual_network_type"] = virtual_network_type
        return StandaloneGateway(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="backendSubnetId")
    def backend_subnet_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the subnet ID in which the backend systems are hosted. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "backend_subnet_id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Azure Region where the API Management Standalone Gateway should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name which should be used for this API Management Standalone Gateway. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Resource Group where the API Management Standalone Gateway should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Output['outputs.StandaloneGatewaySku']:
        """
        A `sku` block as defined below.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the API Management Standalone Gateway. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkType")
    def virtual_network_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the type of VPN in which API Management gateway needs to be configured. Possible values are `External` and `Internal`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_network_type")

