# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SpringCloudCustomDomainArgs', 'SpringCloudCustomDomain']

@pulumi.input_type
class SpringCloudCustomDomainArgs:
    def __init__(__self__, *,
                 spring_cloud_app_id: pulumi.Input[_builtins.str],
                 certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 thumbprint: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SpringCloudCustomDomain resource.
        :param pulumi.Input[_builtins.str] spring_cloud_app_id: Specifies the resource ID of the Spring Cloud Application. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] certificate_name: Specifies the name of the Spring Cloud Certificate that binds to the Spring Cloud Custom Domain. Required when `thumbprint` is specified
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Spring Cloud Custom Domain. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] thumbprint: Specifies the thumbprint of the Spring Cloud Certificate that binds to the Spring Cloud Custom Domain. Required when `certificate_name` is specified. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "spring_cloud_app_id", spring_cloud_app_id)
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @_builtins.property
    @pulumi.getter(name="springCloudAppId")
    def spring_cloud_app_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the resource ID of the Spring Cloud Application. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_app_id")

    @spring_cloud_app_id.setter
    def spring_cloud_app_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "spring_cloud_app_id", value)

    @_builtins.property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Spring Cloud Certificate that binds to the Spring Cloud Custom Domain. Required when `thumbprint` is specified
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Spring Cloud Custom Domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the thumbprint of the Spring Cloud Certificate that binds to the Spring Cloud Custom Domain. Required when `certificate_name` is specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "thumbprint", value)


@pulumi.input_type
class _SpringCloudCustomDomainState:
    def __init__(__self__, *,
                 certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 spring_cloud_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 thumbprint: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SpringCloudCustomDomain resources.
        :param pulumi.Input[_builtins.str] certificate_name: Specifies the name of the Spring Cloud Certificate that binds to the Spring Cloud Custom Domain. Required when `thumbprint` is specified
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Spring Cloud Custom Domain. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] spring_cloud_app_id: Specifies the resource ID of the Spring Cloud Application. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] thumbprint: Specifies the thumbprint of the Spring Cloud Certificate that binds to the Spring Cloud Custom Domain. Required when `certificate_name` is specified. Changing this forces a new resource to be created.
        """
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if spring_cloud_app_id is not None:
            pulumi.set(__self__, "spring_cloud_app_id", spring_cloud_app_id)
        if thumbprint is not None:
            pulumi.set(__self__, "thumbprint", thumbprint)

    @_builtins.property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Spring Cloud Certificate that binds to the Spring Cloud Custom Domain. Required when `thumbprint` is specified
        """
        return pulumi.get(self, "certificate_name")

    @certificate_name.setter
    def certificate_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "certificate_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Spring Cloud Custom Domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="springCloudAppId")
    def spring_cloud_app_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the resource ID of the Spring Cloud Application. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_app_id")

    @spring_cloud_app_id.setter
    def spring_cloud_app_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "spring_cloud_app_id", value)

    @_builtins.property
    @pulumi.getter
    def thumbprint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the thumbprint of the Spring Cloud Certificate that binds to the Spring Cloud Custom Domain. Required when `certificate_name` is specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "thumbprint")

    @thumbprint.setter
    def thumbprint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "thumbprint", value)


@pulumi.type_token("azure:appplatform/springCloudCustomDomain:SpringCloudCustomDomain")
class SpringCloudCustomDomain(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 spring_cloud_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 thumbprint: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an Azure Spring Cloud Custom Domain.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudCustomDomain` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example_resource_group = azure.core.ResourceGroup("example",
            name="rg-example",
            location="West Europe")
        example = azure.dns.get_zone_output(name="mydomain.com",
            resource_group_name=example_resource_group.name)
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example-springcloud",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location)
        example_spring_cloud_app = azure.appplatform.SpringCloudApp("example",
            name="example-springcloudapp",
            resource_group_name=example_resource_group.name,
            service_name=example_spring_cloud_service.name)
        example_c_name_record = azure.dns.CNameRecord("example",
            name="record1",
            zone_name=example.name,
            resource_group_name=example.resource_group_name,
            ttl=300,
            record=example_spring_cloud_app.fqdn)
        example_spring_cloud_custom_domain = azure.appplatform.SpringCloudCustomDomain("example",
            name=std.join_output(separator=".",
                input=[
                    example_c_name_record.name,
                    example_c_name_record.zone_name,
                ]).apply(lambda invoke: invoke.result),
            spring_cloud_app_id=example_spring_cloud_app.id)
        ```

        ## Import

        Spring Cloud Custom Domain can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudCustomDomain:SpringCloudCustomDomain example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.AppPlatform/spring/spring1/apps/app1/domains/domain.com
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_name: Specifies the name of the Spring Cloud Certificate that binds to the Spring Cloud Custom Domain. Required when `thumbprint` is specified
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Spring Cloud Custom Domain. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] spring_cloud_app_id: Specifies the resource ID of the Spring Cloud Application. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] thumbprint: Specifies the thumbprint of the Spring Cloud Certificate that binds to the Spring Cloud Custom Domain. Required when `certificate_name` is specified. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SpringCloudCustomDomainArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Spring Cloud Custom Domain.

        !> **Note:** Azure Spring Apps is now deprecated and will be retired on 2028-05-31 - as such the `appplatform.SpringCloudCustomDomain` resource is deprecated and will be removed in a future major version of the AzureRM Provider. See https://aka.ms/asaretirement for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_std as std

        example_resource_group = azure.core.ResourceGroup("example",
            name="rg-example",
            location="West Europe")
        example = azure.dns.get_zone_output(name="mydomain.com",
            resource_group_name=example_resource_group.name)
        example_spring_cloud_service = azure.appplatform.SpringCloudService("example",
            name="example-springcloud",
            resource_group_name=example_resource_group.name,
            location=example_resource_group.location)
        example_spring_cloud_app = azure.appplatform.SpringCloudApp("example",
            name="example-springcloudapp",
            resource_group_name=example_resource_group.name,
            service_name=example_spring_cloud_service.name)
        example_c_name_record = azure.dns.CNameRecord("example",
            name="record1",
            zone_name=example.name,
            resource_group_name=example.resource_group_name,
            ttl=300,
            record=example_spring_cloud_app.fqdn)
        example_spring_cloud_custom_domain = azure.appplatform.SpringCloudCustomDomain("example",
            name=std.join_output(separator=".",
                input=[
                    example_c_name_record.name,
                    example_c_name_record.zone_name,
                ]).apply(lambda invoke: invoke.result),
            spring_cloud_app_id=example_spring_cloud_app.id)
        ```

        ## Import

        Spring Cloud Custom Domain can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:appplatform/springCloudCustomDomain:SpringCloudCustomDomain example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.AppPlatform/spring/spring1/apps/app1/domains/domain.com
        ```

        :param str resource_name: The name of the resource.
        :param SpringCloudCustomDomainArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SpringCloudCustomDomainArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 spring_cloud_app_id: Optional[pulumi.Input[_builtins.str]] = None,
                 thumbprint: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SpringCloudCustomDomainArgs.__new__(SpringCloudCustomDomainArgs)

            __props__.__dict__["certificate_name"] = certificate_name
            __props__.__dict__["name"] = name
            if spring_cloud_app_id is None and not opts.urn:
                raise TypeError("Missing required property 'spring_cloud_app_id'")
            __props__.__dict__["spring_cloud_app_id"] = spring_cloud_app_id
            __props__.__dict__["thumbprint"] = thumbprint
        super(SpringCloudCustomDomain, __self__).__init__(
            'azure:appplatform/springCloudCustomDomain:SpringCloudCustomDomain',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            certificate_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            spring_cloud_app_id: Optional[pulumi.Input[_builtins.str]] = None,
            thumbprint: Optional[pulumi.Input[_builtins.str]] = None) -> 'SpringCloudCustomDomain':
        """
        Get an existing SpringCloudCustomDomain resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] certificate_name: Specifies the name of the Spring Cloud Certificate that binds to the Spring Cloud Custom Domain. Required when `thumbprint` is specified
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Spring Cloud Custom Domain. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] spring_cloud_app_id: Specifies the resource ID of the Spring Cloud Application. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] thumbprint: Specifies the thumbprint of the Spring Cloud Certificate that binds to the Spring Cloud Custom Domain. Required when `certificate_name` is specified. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SpringCloudCustomDomainState.__new__(_SpringCloudCustomDomainState)

        __props__.__dict__["certificate_name"] = certificate_name
        __props__.__dict__["name"] = name
        __props__.__dict__["spring_cloud_app_id"] = spring_cloud_app_id
        __props__.__dict__["thumbprint"] = thumbprint
        return SpringCloudCustomDomain(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the name of the Spring Cloud Certificate that binds to the Spring Cloud Custom Domain. Required when `thumbprint` is specified
        """
        return pulumi.get(self, "certificate_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Spring Cloud Custom Domain. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="springCloudAppId")
    def spring_cloud_app_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the resource ID of the Spring Cloud Application. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "spring_cloud_app_id")

    @_builtins.property
    @pulumi.getter
    def thumbprint(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the thumbprint of the Spring Cloud Certificate that binds to the Spring Cloud Custom Domain. Required when `certificate_name` is specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "thumbprint")

