# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['WatcherArgs', 'Watcher']

@pulumi.input_type
class WatcherArgs:
    def __init__(__self__, *,
                 automation_account_id: pulumi.Input[_builtins.str],
                 execution_frequency_in_seconds: pulumi.Input[_builtins.int],
                 script_name: pulumi.Input[_builtins.str],
                 script_run_on: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 script_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a Watcher resource.
        :param pulumi.Input[_builtins.str] automation_account_id: The ID of Automation Account to manage this Watcher. Changing this forces a new Watcher to be created.
        :param pulumi.Input[_builtins.int] execution_frequency_in_seconds: Specify the frequency at which the watcher is invoked.
        :param pulumi.Input[_builtins.str] script_name: Specify the name of an existing runbook this watcher is attached to. Changing this forces a new Automation to be created.
        :param pulumi.Input[_builtins.str] script_run_on: Specify the name of the Hybrid work group the watcher will run on.
        :param pulumi.Input[_builtins.str] description: A description of this Automation Watcher.
        :param pulumi.Input[_builtins.str] etag: A string of etag assigned to this Automation Watcher.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Automation Watcher should exist. Changing this forces a new Automation Watcher to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Automation Watcher. Changing this forces a new Automation Watcher to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] script_parameters: Specifies a list of key-vaule parameters. Changing this forces a new Automation watcher to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Automation Watcher.
        """
        pulumi.set(__self__, "automation_account_id", automation_account_id)
        pulumi.set(__self__, "execution_frequency_in_seconds", execution_frequency_in_seconds)
        pulumi.set(__self__, "script_name", script_name)
        pulumi.set(__self__, "script_run_on", script_run_on)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if script_parameters is not None:
            pulumi.set(__self__, "script_parameters", script_parameters)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="automationAccountId")
    def automation_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of Automation Account to manage this Watcher. Changing this forces a new Watcher to be created.
        """
        return pulumi.get(self, "automation_account_id")

    @automation_account_id.setter
    def automation_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "automation_account_id", value)

    @_builtins.property
    @pulumi.getter(name="executionFrequencyInSeconds")
    def execution_frequency_in_seconds(self) -> pulumi.Input[_builtins.int]:
        """
        Specify the frequency at which the watcher is invoked.
        """
        return pulumi.get(self, "execution_frequency_in_seconds")

    @execution_frequency_in_seconds.setter
    def execution_frequency_in_seconds(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "execution_frequency_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="scriptName")
    def script_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specify the name of an existing runbook this watcher is attached to. Changing this forces a new Automation to be created.
        """
        return pulumi.get(self, "script_name")

    @script_name.setter
    def script_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "script_name", value)

    @_builtins.property
    @pulumi.getter(name="scriptRunOn")
    def script_run_on(self) -> pulumi.Input[_builtins.str]:
        """
        Specify the name of the Hybrid work group the watcher will run on.
        """
        return pulumi.get(self, "script_run_on")

    @script_run_on.setter
    def script_run_on(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "script_run_on", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of this Automation Watcher.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A string of etag assigned to this Automation Watcher.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Automation Watcher should exist. Changing this forces a new Automation Watcher to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Automation Watcher. Changing this forces a new Automation Watcher to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="scriptParameters")
    def script_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of key-vaule parameters. Changing this forces a new Automation watcher to be created.
        """
        return pulumi.get(self, "script_parameters")

    @script_parameters.setter
    def script_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "script_parameters", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Automation Watcher.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _WatcherState:
    def __init__(__self__, *,
                 automation_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_frequency_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 script_name: Optional[pulumi.Input[_builtins.str]] = None,
                 script_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 script_run_on: Optional[pulumi.Input[_builtins.str]] = None,
                 status: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering Watcher resources.
        :param pulumi.Input[_builtins.str] automation_account_id: The ID of Automation Account to manage this Watcher. Changing this forces a new Watcher to be created.
        :param pulumi.Input[_builtins.str] description: A description of this Automation Watcher.
        :param pulumi.Input[_builtins.str] etag: A string of etag assigned to this Automation Watcher.
        :param pulumi.Input[_builtins.int] execution_frequency_in_seconds: Specify the frequency at which the watcher is invoked.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Automation Watcher should exist. Changing this forces a new Automation Watcher to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Automation Watcher. Changing this forces a new Automation Watcher to be created.
        :param pulumi.Input[_builtins.str] script_name: Specify the name of an existing runbook this watcher is attached to. Changing this forces a new Automation to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] script_parameters: Specifies a list of key-vaule parameters. Changing this forces a new Automation watcher to be created.
        :param pulumi.Input[_builtins.str] script_run_on: Specify the name of the Hybrid work group the watcher will run on.
        :param pulumi.Input[_builtins.str] status: The current status of the Automation Watcher.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Automation Watcher.
        """
        if automation_account_id is not None:
            pulumi.set(__self__, "automation_account_id", automation_account_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if execution_frequency_in_seconds is not None:
            pulumi.set(__self__, "execution_frequency_in_seconds", execution_frequency_in_seconds)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if script_name is not None:
            pulumi.set(__self__, "script_name", script_name)
        if script_parameters is not None:
            pulumi.set(__self__, "script_parameters", script_parameters)
        if script_run_on is not None:
            pulumi.set(__self__, "script_run_on", script_run_on)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="automationAccountId")
    def automation_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of Automation Account to manage this Watcher. Changing this forces a new Watcher to be created.
        """
        return pulumi.get(self, "automation_account_id")

    @automation_account_id.setter
    def automation_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "automation_account_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of this Automation Watcher.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A string of etag assigned to this Automation Watcher.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="executionFrequencyInSeconds")
    def execution_frequency_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specify the frequency at which the watcher is invoked.
        """
        return pulumi.get(self, "execution_frequency_in_seconds")

    @execution_frequency_in_seconds.setter
    def execution_frequency_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "execution_frequency_in_seconds", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Automation Watcher should exist. Changing this forces a new Automation Watcher to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Automation Watcher. Changing this forces a new Automation Watcher to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="scriptName")
    def script_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the name of an existing runbook this watcher is attached to. Changing this forces a new Automation to be created.
        """
        return pulumi.get(self, "script_name")

    @script_name.setter
    def script_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "script_name", value)

    @_builtins.property
    @pulumi.getter(name="scriptParameters")
    def script_parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of key-vaule parameters. Changing this forces a new Automation watcher to be created.
        """
        return pulumi.get(self, "script_parameters")

    @script_parameters.setter
    def script_parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "script_parameters", value)

    @_builtins.property
    @pulumi.getter(name="scriptRunOn")
    def script_run_on(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify the name of the Hybrid work group the watcher will run on.
        """
        return pulumi.get(self, "script_run_on")

    @script_run_on.setter
    def script_run_on(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "script_run_on", value)

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The current status of the Automation Watcher.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "status", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Automation Watcher.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:automation/watcher:Watcher")
class Watcher(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automation_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_frequency_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 script_name: Optional[pulumi.Input[_builtins.str]] = None,
                 script_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 script_run_on: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Automation Wacher.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.automation.Account("example",
            name="example-account",
            location=example.location,
            resource_group_name=example.name,
            sku_name="Basic")
        example_hybrid_runbook_worker_group = azure.automation.HybridRunbookWorkerGroup("example",
            name="example",
            resource_group_name=example.name,
            automation_account_name=example_account.name)
        example_run_book = azure.automation.RunBook("example",
            name="Get-AzureVMTutorial",
            location=example.location,
            resource_group_name=example.name,
            automation_account_name=example_account.name,
            log_verbose=True,
            log_progress=True,
            description="This is an example runbook",
            runbook_type="PowerShellWorkflow",
            publish_content_link={
                "uri": "https://raw.githubusercontent.com/Azure/azure-quickstart-templates/c4935ffb69246a6058eb24f54640f53f69d3ac9f/101-automation-runbook-getvms/Runbooks/Get-AzureVMTutorial.ps1",
            })
        example_watcher = azure.automation.Watcher("example",
            name="example",
            automation_account_id=example_account.id,
            location="West Europe",
            script_name=example_run_book.name,
            script_run_on=example_hybrid_runbook_worker_group.name,
            description="example-watcher desc",
            execution_frequency_in_seconds=42,
            tags={
                "foo": "bar",
            },
            script_parameters={
                "foo": "bar",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Automation` - 2020-01-13-preview

        ## Import

        Automation Watchers can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:automation/watcher:Watcher example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.Automation/automationAccounts/account1/watchers/watch1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] automation_account_id: The ID of Automation Account to manage this Watcher. Changing this forces a new Watcher to be created.
        :param pulumi.Input[_builtins.str] description: A description of this Automation Watcher.
        :param pulumi.Input[_builtins.str] etag: A string of etag assigned to this Automation Watcher.
        :param pulumi.Input[_builtins.int] execution_frequency_in_seconds: Specify the frequency at which the watcher is invoked.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Automation Watcher should exist. Changing this forces a new Automation Watcher to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Automation Watcher. Changing this forces a new Automation Watcher to be created.
        :param pulumi.Input[_builtins.str] script_name: Specify the name of an existing runbook this watcher is attached to. Changing this forces a new Automation to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] script_parameters: Specifies a list of key-vaule parameters. Changing this forces a new Automation watcher to be created.
        :param pulumi.Input[_builtins.str] script_run_on: Specify the name of the Hybrid work group the watcher will run on.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Automation Watcher.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WatcherArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Automation Wacher.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.automation.Account("example",
            name="example-account",
            location=example.location,
            resource_group_name=example.name,
            sku_name="Basic")
        example_hybrid_runbook_worker_group = azure.automation.HybridRunbookWorkerGroup("example",
            name="example",
            resource_group_name=example.name,
            automation_account_name=example_account.name)
        example_run_book = azure.automation.RunBook("example",
            name="Get-AzureVMTutorial",
            location=example.location,
            resource_group_name=example.name,
            automation_account_name=example_account.name,
            log_verbose=True,
            log_progress=True,
            description="This is an example runbook",
            runbook_type="PowerShellWorkflow",
            publish_content_link={
                "uri": "https://raw.githubusercontent.com/Azure/azure-quickstart-templates/c4935ffb69246a6058eb24f54640f53f69d3ac9f/101-automation-runbook-getvms/Runbooks/Get-AzureVMTutorial.ps1",
            })
        example_watcher = azure.automation.Watcher("example",
            name="example",
            automation_account_id=example_account.id,
            location="West Europe",
            script_name=example_run_book.name,
            script_run_on=example_hybrid_runbook_worker_group.name,
            description="example-watcher desc",
            execution_frequency_in_seconds=42,
            tags={
                "foo": "bar",
            },
            script_parameters={
                "foo": "bar",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Automation` - 2020-01-13-preview

        ## Import

        Automation Watchers can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:automation/watcher:Watcher example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.Automation/automationAccounts/account1/watchers/watch1
        ```

        :param str resource_name: The name of the resource.
        :param WatcherArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WatcherArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 automation_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 execution_frequency_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 script_name: Optional[pulumi.Input[_builtins.str]] = None,
                 script_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 script_run_on: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WatcherArgs.__new__(WatcherArgs)

            if automation_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'automation_account_id'")
            __props__.__dict__["automation_account_id"] = automation_account_id
            __props__.__dict__["description"] = description
            __props__.__dict__["etag"] = etag
            if execution_frequency_in_seconds is None and not opts.urn:
                raise TypeError("Missing required property 'execution_frequency_in_seconds'")
            __props__.__dict__["execution_frequency_in_seconds"] = execution_frequency_in_seconds
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if script_name is None and not opts.urn:
                raise TypeError("Missing required property 'script_name'")
            __props__.__dict__["script_name"] = script_name
            __props__.__dict__["script_parameters"] = script_parameters
            if script_run_on is None and not opts.urn:
                raise TypeError("Missing required property 'script_run_on'")
            __props__.__dict__["script_run_on"] = script_run_on
            __props__.__dict__["tags"] = tags
            __props__.__dict__["status"] = None
        super(Watcher, __self__).__init__(
            'azure:automation/watcher:Watcher',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            automation_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            execution_frequency_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            script_name: Optional[pulumi.Input[_builtins.str]] = None,
            script_parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            script_run_on: Optional[pulumi.Input[_builtins.str]] = None,
            status: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'Watcher':
        """
        Get an existing Watcher resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] automation_account_id: The ID of Automation Account to manage this Watcher. Changing this forces a new Watcher to be created.
        :param pulumi.Input[_builtins.str] description: A description of this Automation Watcher.
        :param pulumi.Input[_builtins.str] etag: A string of etag assigned to this Automation Watcher.
        :param pulumi.Input[_builtins.int] execution_frequency_in_seconds: Specify the frequency at which the watcher is invoked.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Automation Watcher should exist. Changing this forces a new Automation Watcher to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Automation Watcher. Changing this forces a new Automation Watcher to be created.
        :param pulumi.Input[_builtins.str] script_name: Specify the name of an existing runbook this watcher is attached to. Changing this forces a new Automation to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] script_parameters: Specifies a list of key-vaule parameters. Changing this forces a new Automation watcher to be created.
        :param pulumi.Input[_builtins.str] script_run_on: Specify the name of the Hybrid work group the watcher will run on.
        :param pulumi.Input[_builtins.str] status: The current status of the Automation Watcher.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Automation Watcher.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WatcherState.__new__(_WatcherState)

        __props__.__dict__["automation_account_id"] = automation_account_id
        __props__.__dict__["description"] = description
        __props__.__dict__["etag"] = etag
        __props__.__dict__["execution_frequency_in_seconds"] = execution_frequency_in_seconds
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["script_name"] = script_name
        __props__.__dict__["script_parameters"] = script_parameters
        __props__.__dict__["script_run_on"] = script_run_on
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        return Watcher(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="automationAccountId")
    def automation_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of Automation Account to manage this Watcher. Changing this forces a new Watcher to be created.
        """
        return pulumi.get(self, "automation_account_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description of this Automation Watcher.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A string of etag assigned to this Automation Watcher.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="executionFrequencyInSeconds")
    def execution_frequency_in_seconds(self) -> pulumi.Output[_builtins.int]:
        """
        Specify the frequency at which the watcher is invoked.
        """
        return pulumi.get(self, "execution_frequency_in_seconds")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Automation Watcher should exist. Changing this forces a new Automation Watcher to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Automation Watcher. Changing this forces a new Automation Watcher to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="scriptName")
    def script_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specify the name of an existing runbook this watcher is attached to. Changing this forces a new Automation to be created.
        """
        return pulumi.get(self, "script_name")

    @_builtins.property
    @pulumi.getter(name="scriptParameters")
    def script_parameters(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Specifies a list of key-vaule parameters. Changing this forces a new Automation watcher to be created.
        """
        return pulumi.get(self, "script_parameters")

    @_builtins.property
    @pulumi.getter(name="scriptRunOn")
    def script_run_on(self) -> pulumi.Output[_builtins.str]:
        """
        Specify the name of the Hybrid work group the watcher will run on.
        """
        return pulumi.get(self, "script_run_on")

    @_builtins.property
    @pulumi.getter
    def status(self) -> pulumi.Output[_builtins.str]:
        """
        The current status of the Automation Watcher.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Automation Watcher.
        """
        return pulumi.get(self, "tags")

