# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'AIServicesCustomerManagedKeyArgs',
    'AIServicesCustomerManagedKeyArgsDict',
    'AIServicesIdentityArgs',
    'AIServicesIdentityArgsDict',
    'AIServicesNetworkAclsArgs',
    'AIServicesNetworkAclsArgsDict',
    'AIServicesNetworkAclsVirtualNetworkRuleArgs',
    'AIServicesNetworkAclsVirtualNetworkRuleArgsDict',
    'AIServicesStorageArgs',
    'AIServicesStorageArgsDict',
    'AccountCustomerManagedKeyArgs',
    'AccountCustomerManagedKeyArgsDict',
    'AccountIdentityArgs',
    'AccountIdentityArgsDict',
    'AccountNetworkAclsArgs',
    'AccountNetworkAclsArgsDict',
    'AccountNetworkAclsVirtualNetworkRuleArgs',
    'AccountNetworkAclsVirtualNetworkRuleArgsDict',
    'AccountRaiPolicyContentFilterArgs',
    'AccountRaiPolicyContentFilterArgsDict',
    'AccountStorageArgs',
    'AccountStorageArgsDict',
    'DeploymentModelArgs',
    'DeploymentModelArgsDict',
    'DeploymentSkuArgs',
    'DeploymentSkuArgsDict',
]

MYPY = False

if not MYPY:
    class AIServicesCustomerManagedKeyArgsDict(TypedDict):
        identity_client_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Client ID of the User Assigned Identity that has access to the key. This property only needs to be specified when there are multiple identities attached to the Azure AI Service.
        """
        key_vault_key_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the Key Vault Key which should be used to encrypt the data in this AI Services Account. Exactly one of `key_vault_key_id`, `managed_hsm_key_id` must be specified.
        """
        managed_hsm_key_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the managed HSM Key which should be used to encrypt the data in this AI Services Account. Exactly one of `key_vault_key_id`, `managed_hsm_key_id` must be specified.
        """
elif False:
    AIServicesCustomerManagedKeyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AIServicesCustomerManagedKeyArgs:
    def __init__(__self__, *,
                 identity_client_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_hsm_key_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] identity_client_id: The Client ID of the User Assigned Identity that has access to the key. This property only needs to be specified when there are multiple identities attached to the Azure AI Service.
        :param pulumi.Input[_builtins.str] key_vault_key_id: The ID of the Key Vault Key which should be used to encrypt the data in this AI Services Account. Exactly one of `key_vault_key_id`, `managed_hsm_key_id` must be specified.
        :param pulumi.Input[_builtins.str] managed_hsm_key_id: The ID of the managed HSM Key which should be used to encrypt the data in this AI Services Account. Exactly one of `key_vault_key_id`, `managed_hsm_key_id` must be specified.
        """
        if identity_client_id is not None:
            pulumi.set(__self__, "identity_client_id", identity_client_id)
        if key_vault_key_id is not None:
            pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if managed_hsm_key_id is not None:
            pulumi.set(__self__, "managed_hsm_key_id", managed_hsm_key_id)

    @_builtins.property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Client ID of the User Assigned Identity that has access to the key. This property only needs to be specified when there are multiple identities attached to the Azure AI Service.
        """
        return pulumi.get(self, "identity_client_id")

    @identity_client_id.setter
    def identity_client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_client_id", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Key Vault Key which should be used to encrypt the data in this AI Services Account. Exactly one of `key_vault_key_id`, `managed_hsm_key_id` must be specified.
        """
        return pulumi.get(self, "key_vault_key_id")

    @key_vault_key_id.setter
    def key_vault_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_key_id", value)

    @_builtins.property
    @pulumi.getter(name="managedHsmKeyId")
    def managed_hsm_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the managed HSM Key which should be used to encrypt the data in this AI Services Account. Exactly one of `key_vault_key_id`, `managed_hsm_key_id` must be specified.
        """
        return pulumi.get(self, "managed_hsm_key_id")

    @managed_hsm_key_id.setter
    def managed_hsm_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "managed_hsm_key_id", value)


if not MYPY:
    class AIServicesIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this AI Services Account. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned`
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this AI Services Account.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Principal ID associated with this Managed Service Identity.
        """
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Tenant ID associated with this Managed Service Identity.
        """
elif False:
    AIServicesIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AIServicesIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this AI Services Account. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this AI Services Account.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param pulumi.Input[_builtins.str] principal_id: The Principal ID associated with this Managed Service Identity.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this AI Services Account. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this AI Services Account.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class AIServicesNetworkAclsArgsDict(TypedDict):
        default_action: pulumi.Input[_builtins.str]
        """
        The Default Action to use when no rules match from `ip_rules` / `virtual_network_rules`. Possible values are `Allow` and `Deny`.
        """
        bypass: NotRequired[pulumi.Input[_builtins.str]]
        """
        Whether to allow trusted Azure Services to access the service. Possible values are `None` and `AzureServices`. Defaults to `AzureServices`.
        *
        """
        ip_rules: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        One or more IP Addresses, or CIDR Blocks which should be able to access the AI Services Account.
        """
        virtual_network_rules: NotRequired[pulumi.Input[Sequence[pulumi.Input['AIServicesNetworkAclsVirtualNetworkRuleArgsDict']]]]
        """
        A `virtual_network_rules` block as defined below.
        """
elif False:
    AIServicesNetworkAclsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AIServicesNetworkAclsArgs:
    def __init__(__self__, *,
                 default_action: pulumi.Input[_builtins.str],
                 bypass: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 virtual_network_rules: Optional[pulumi.Input[Sequence[pulumi.Input['AIServicesNetworkAclsVirtualNetworkRuleArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.str] default_action: The Default Action to use when no rules match from `ip_rules` / `virtual_network_rules`. Possible values are `Allow` and `Deny`.
        :param pulumi.Input[_builtins.str] bypass: Whether to allow trusted Azure Services to access the service. Possible values are `None` and `AzureServices`. Defaults to `AzureServices`.
               *
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_rules: One or more IP Addresses, or CIDR Blocks which should be able to access the AI Services Account.
        :param pulumi.Input[Sequence[pulumi.Input['AIServicesNetworkAclsVirtualNetworkRuleArgs']]] virtual_network_rules: A `virtual_network_rules` block as defined below.
        """
        pulumi.set(__self__, "default_action", default_action)
        if bypass is not None:
            pulumi.set(__self__, "bypass", bypass)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)
        if virtual_network_rules is not None:
            pulumi.set(__self__, "virtual_network_rules", virtual_network_rules)

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> pulumi.Input[_builtins.str]:
        """
        The Default Action to use when no rules match from `ip_rules` / `virtual_network_rules`. Possible values are `Allow` and `Deny`.
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "default_action", value)

    @_builtins.property
    @pulumi.getter
    def bypass(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to allow trusted Azure Services to access the service. Possible values are `None` and `AzureServices`. Defaults to `AzureServices`.
        *
        """
        return pulumi.get(self, "bypass")

    @bypass.setter
    def bypass(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bypass", value)

    @_builtins.property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        One or more IP Addresses, or CIDR Blocks which should be able to access the AI Services Account.
        """
        return pulumi.get(self, "ip_rules")

    @ip_rules.setter
    def ip_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_rules", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkRules")
    def virtual_network_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AIServicesNetworkAclsVirtualNetworkRuleArgs']]]]:
        """
        A `virtual_network_rules` block as defined below.
        """
        return pulumi.get(self, "virtual_network_rules")

    @virtual_network_rules.setter
    def virtual_network_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AIServicesNetworkAclsVirtualNetworkRuleArgs']]]]):
        pulumi.set(self, "virtual_network_rules", value)


if not MYPY:
    class AIServicesNetworkAclsVirtualNetworkRuleArgsDict(TypedDict):
        subnet_id: pulumi.Input[_builtins.str]
        """
        The ID of the subnet which should be able to access this AI Services Account.
        """
        ignore_missing_vnet_service_endpoint: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether to ignore a missing Virtual Network Service Endpoint or not. Default to `false`.
        """
elif False:
    AIServicesNetworkAclsVirtualNetworkRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AIServicesNetworkAclsVirtualNetworkRuleArgs:
    def __init__(__self__, *,
                 subnet_id: pulumi.Input[_builtins.str],
                 ignore_missing_vnet_service_endpoint: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the subnet which should be able to access this AI Services Account.
        :param pulumi.Input[_builtins.bool] ignore_missing_vnet_service_endpoint: Whether to ignore a missing Virtual Network Service Endpoint or not. Default to `false`.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if ignore_missing_vnet_service_endpoint is not None:
            pulumi.set(__self__, "ignore_missing_vnet_service_endpoint", ignore_missing_vnet_service_endpoint)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the subnet which should be able to access this AI Services Account.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="ignoreMissingVnetServiceEndpoint")
    def ignore_missing_vnet_service_endpoint(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to ignore a missing Virtual Network Service Endpoint or not. Default to `false`.
        """
        return pulumi.get(self, "ignore_missing_vnet_service_endpoint")

    @ignore_missing_vnet_service_endpoint.setter
    def ignore_missing_vnet_service_endpoint(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_missing_vnet_service_endpoint", value)


if not MYPY:
    class AIServicesStorageArgsDict(TypedDict):
        storage_account_id: pulumi.Input[_builtins.str]
        """
        The ID of the Storage Account.
        """
        identity_client_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The client ID of the Managed Identity associated with the Storage Account.
        """
elif False:
    AIServicesStorageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AIServicesStorageArgs:
    def __init__(__self__, *,
                 storage_account_id: pulumi.Input[_builtins.str],
                 identity_client_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account.
        :param pulumi.Input[_builtins.str] identity_client_id: The client ID of the Managed Identity associated with the Storage Account.
        """
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        if identity_client_id is not None:
            pulumi.set(__self__, "identity_client_id", identity_client_id)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Storage Account.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_account_id", value)

    @_builtins.property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client ID of the Managed Identity associated with the Storage Account.
        """
        return pulumi.get(self, "identity_client_id")

    @identity_client_id.setter
    def identity_client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_client_id", value)


if not MYPY:
    class AccountCustomerManagedKeyArgsDict(TypedDict):
        key_vault_key_id: pulumi.Input[_builtins.str]
        """
        The ID of the Key Vault Key which should be used to Encrypt the data in this Cognitive Account.
        """
        identity_client_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Client ID of the User Assigned Identity that has access to the key. This property only needs to be specified when there're multiple identities attached to the Cognitive Account.
        """
elif False:
    AccountCustomerManagedKeyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountCustomerManagedKeyArgs:
    def __init__(__self__, *,
                 key_vault_key_id: pulumi.Input[_builtins.str],
                 identity_client_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] key_vault_key_id: The ID of the Key Vault Key which should be used to Encrypt the data in this Cognitive Account.
        :param pulumi.Input[_builtins.str] identity_client_id: The Client ID of the User Assigned Identity that has access to the key. This property only needs to be specified when there're multiple identities attached to the Cognitive Account.
        """
        pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if identity_client_id is not None:
            pulumi.set(__self__, "identity_client_id", identity_client_id)

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Key Vault Key which should be used to Encrypt the data in this Cognitive Account.
        """
        return pulumi.get(self, "key_vault_key_id")

    @key_vault_key_id.setter
    def key_vault_key_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_vault_key_id", value)

    @_builtins.property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Client ID of the User Assigned Identity that has access to the key. This property only needs to be specified when there're multiple identities attached to the Cognitive Account.
        """
        return pulumi.get(self, "identity_client_id")

    @identity_client_id.setter
    def identity_client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_client_id", value)


if not MYPY:
    class AccountIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this Cognitive Account. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Cognitive Account.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Principal ID associated with this Managed Service Identity.
        """
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Tenant ID associated with this Managed Service Identity.
        """
elif False:
    AccountIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this Cognitive Account. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Cognitive Account.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param pulumi.Input[_builtins.str] principal_id: The Principal ID associated with this Managed Service Identity.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this Cognitive Account. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Cognitive Account.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class AccountNetworkAclsArgsDict(TypedDict):
        default_action: pulumi.Input[_builtins.str]
        """
        The Default Action to use when no rules match from `ip_rules` / `virtual_network_rules`. Possible values are `Allow` and `Deny`.
        """
        bypass: NotRequired[pulumi.Input[_builtins.str]]
        """
        Whether to allow trusted Azure Services to access the service. Possible values are `None` and `AzureServices`.

        > **Note:** `bypass` can only be set when `kind` is set to `OpenAI`
        """
        ip_rules: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        One or more IP Addresses, or CIDR Blocks which should be able to access the Cognitive Account.
        """
        virtual_network_rules: NotRequired[pulumi.Input[Sequence[pulumi.Input['AccountNetworkAclsVirtualNetworkRuleArgsDict']]]]
        """
        A `virtual_network_rules` block as defined below.
        """
elif False:
    AccountNetworkAclsArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountNetworkAclsArgs:
    def __init__(__self__, *,
                 default_action: pulumi.Input[_builtins.str],
                 bypass: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 virtual_network_rules: Optional[pulumi.Input[Sequence[pulumi.Input['AccountNetworkAclsVirtualNetworkRuleArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.str] default_action: The Default Action to use when no rules match from `ip_rules` / `virtual_network_rules`. Possible values are `Allow` and `Deny`.
        :param pulumi.Input[_builtins.str] bypass: Whether to allow trusted Azure Services to access the service. Possible values are `None` and `AzureServices`.
               
               > **Note:** `bypass` can only be set when `kind` is set to `OpenAI`
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] ip_rules: One or more IP Addresses, or CIDR Blocks which should be able to access the Cognitive Account.
        :param pulumi.Input[Sequence[pulumi.Input['AccountNetworkAclsVirtualNetworkRuleArgs']]] virtual_network_rules: A `virtual_network_rules` block as defined below.
        """
        pulumi.set(__self__, "default_action", default_action)
        if bypass is not None:
            pulumi.set(__self__, "bypass", bypass)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)
        if virtual_network_rules is not None:
            pulumi.set(__self__, "virtual_network_rules", virtual_network_rules)

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> pulumi.Input[_builtins.str]:
        """
        The Default Action to use when no rules match from `ip_rules` / `virtual_network_rules`. Possible values are `Allow` and `Deny`.
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "default_action", value)

    @_builtins.property
    @pulumi.getter
    def bypass(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether to allow trusted Azure Services to access the service. Possible values are `None` and `AzureServices`.

        > **Note:** `bypass` can only be set when `kind` is set to `OpenAI`
        """
        return pulumi.get(self, "bypass")

    @bypass.setter
    def bypass(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bypass", value)

    @_builtins.property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        One or more IP Addresses, or CIDR Blocks which should be able to access the Cognitive Account.
        """
        return pulumi.get(self, "ip_rules")

    @ip_rules.setter
    def ip_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "ip_rules", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkRules")
    def virtual_network_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AccountNetworkAclsVirtualNetworkRuleArgs']]]]:
        """
        A `virtual_network_rules` block as defined below.
        """
        return pulumi.get(self, "virtual_network_rules")

    @virtual_network_rules.setter
    def virtual_network_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AccountNetworkAclsVirtualNetworkRuleArgs']]]]):
        pulumi.set(self, "virtual_network_rules", value)


if not MYPY:
    class AccountNetworkAclsVirtualNetworkRuleArgsDict(TypedDict):
        subnet_id: pulumi.Input[_builtins.str]
        """
        The ID of the subnet which should be able to access this Cognitive Account.
        """
        ignore_missing_vnet_service_endpoint: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Whether ignore missing vnet service endpoint or not. Default to `false`.
        """
elif False:
    AccountNetworkAclsVirtualNetworkRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountNetworkAclsVirtualNetworkRuleArgs:
    def __init__(__self__, *,
                 subnet_id: pulumi.Input[_builtins.str],
                 ignore_missing_vnet_service_endpoint: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the subnet which should be able to access this Cognitive Account.
        :param pulumi.Input[_builtins.bool] ignore_missing_vnet_service_endpoint: Whether ignore missing vnet service endpoint or not. Default to `false`.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if ignore_missing_vnet_service_endpoint is not None:
            pulumi.set(__self__, "ignore_missing_vnet_service_endpoint", ignore_missing_vnet_service_endpoint)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the subnet which should be able to access this Cognitive Account.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="ignoreMissingVnetServiceEndpoint")
    def ignore_missing_vnet_service_endpoint(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether ignore missing vnet service endpoint or not. Default to `false`.
        """
        return pulumi.get(self, "ignore_missing_vnet_service_endpoint")

    @ignore_missing_vnet_service_endpoint.setter
    def ignore_missing_vnet_service_endpoint(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_missing_vnet_service_endpoint", value)


if not MYPY:
    class AccountRaiPolicyContentFilterArgsDict(TypedDict):
        block_enabled: pulumi.Input[_builtins.bool]
        """
        Whether the filter should block content. Possible values are `true` or `false`.
        """
        filter_enabled: pulumi.Input[_builtins.bool]
        """
        Whether the filter is enabled. Possible values are `true` or `false`.
        """
        name: pulumi.Input[_builtins.str]
        """
        The name of the content filter.
        """
        severity_threshold: pulumi.Input[_builtins.str]
        """
        The severity threshold for the filter. Possible values are `Low`, `Medium` or `High`.
        """
        source: pulumi.Input[_builtins.str]
        """
        Content source to apply the content filter. Possible values are `Prompt` or `Completion`.
        """
elif False:
    AccountRaiPolicyContentFilterArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountRaiPolicyContentFilterArgs:
    def __init__(__self__, *,
                 block_enabled: pulumi.Input[_builtins.bool],
                 filter_enabled: pulumi.Input[_builtins.bool],
                 name: pulumi.Input[_builtins.str],
                 severity_threshold: pulumi.Input[_builtins.str],
                 source: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.bool] block_enabled: Whether the filter should block content. Possible values are `true` or `false`.
        :param pulumi.Input[_builtins.bool] filter_enabled: Whether the filter is enabled. Possible values are `true` or `false`.
        :param pulumi.Input[_builtins.str] name: The name of the content filter.
        :param pulumi.Input[_builtins.str] severity_threshold: The severity threshold for the filter. Possible values are `Low`, `Medium` or `High`.
        :param pulumi.Input[_builtins.str] source: Content source to apply the content filter. Possible values are `Prompt` or `Completion`.
        """
        pulumi.set(__self__, "block_enabled", block_enabled)
        pulumi.set(__self__, "filter_enabled", filter_enabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "severity_threshold", severity_threshold)
        pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter(name="blockEnabled")
    def block_enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether the filter should block content. Possible values are `true` or `false`.
        """
        return pulumi.get(self, "block_enabled")

    @block_enabled.setter
    def block_enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "block_enabled", value)

    @_builtins.property
    @pulumi.getter(name="filterEnabled")
    def filter_enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Whether the filter is enabled. Possible values are `true` or `false`.
        """
        return pulumi.get(self, "filter_enabled")

    @filter_enabled.setter
    def filter_enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "filter_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the content filter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="severityThreshold")
    def severity_threshold(self) -> pulumi.Input[_builtins.str]:
        """
        The severity threshold for the filter. Possible values are `Low`, `Medium` or `High`.
        """
        return pulumi.get(self, "severity_threshold")

    @severity_threshold.setter
    def severity_threshold(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "severity_threshold", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Input[_builtins.str]:
        """
        Content source to apply the content filter. Possible values are `Prompt` or `Completion`.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source", value)


if not MYPY:
    class AccountStorageArgsDict(TypedDict):
        storage_account_id: pulumi.Input[_builtins.str]
        """
        Full resource id of a Microsoft.Storage resource.
        """
        identity_client_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The client ID of the managed identity associated with the storage resource.

        > **Note:** Not all `kind` support a `storage` block. For example the `kind` `OpenAI` does not support it.
        """
elif False:
    AccountStorageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class AccountStorageArgs:
    def __init__(__self__, *,
                 storage_account_id: pulumi.Input[_builtins.str],
                 identity_client_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] storage_account_id: Full resource id of a Microsoft.Storage resource.
        :param pulumi.Input[_builtins.str] identity_client_id: The client ID of the managed identity associated with the storage resource.
               
               > **Note:** Not all `kind` support a `storage` block. For example the `kind` `OpenAI` does not support it.
        """
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        if identity_client_id is not None:
            pulumi.set(__self__, "identity_client_id", identity_client_id)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        Full resource id of a Microsoft.Storage resource.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_account_id", value)

    @_builtins.property
    @pulumi.getter(name="identityClientId")
    def identity_client_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The client ID of the managed identity associated with the storage resource.

        > **Note:** Not all `kind` support a `storage` block. For example the `kind` `OpenAI` does not support it.
        """
        return pulumi.get(self, "identity_client_id")

    @identity_client_id.setter
    def identity_client_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_client_id", value)


if not MYPY:
    class DeploymentModelArgsDict(TypedDict):
        format: pulumi.Input[_builtins.str]
        """
        The format of the Cognitive Services Account Deployment model. Changing this forces a new resource to be created.

        > **Note:** Possible values of `format` can be found by running the command `az cognitiveservices account list-models`. The available values may vary by region or due to quota limitations. These could include models from `AI21 Labs`, `Black Forest Labs`, `Cohere`, `Core42`, `DeepSeek`, `Meta`, `Microsoft`, `Mistral AI`, `OpenAI`, and `xAI`.
        """
        name: pulumi.Input[_builtins.str]
        """
        The name of the Cognitive Services Account Deployment model. Changing this forces a new resource to be created.
        """
        version: NotRequired[pulumi.Input[_builtins.str]]
        """
        The version of Cognitive Services Account Deployment model. If `version` is not specified, the default version of the model at the time will be assigned.
        """
elif False:
    DeploymentModelArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentModelArgs:
    def __init__(__self__, *,
                 format: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 version: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] format: The format of the Cognitive Services Account Deployment model. Changing this forces a new resource to be created.
               
               > **Note:** Possible values of `format` can be found by running the command `az cognitiveservices account list-models`. The available values may vary by region or due to quota limitations. These could include models from `AI21 Labs`, `Black Forest Labs`, `Cohere`, `Core42`, `DeepSeek`, `Meta`, `Microsoft`, `Mistral AI`, `OpenAI`, and `xAI`.
        :param pulumi.Input[_builtins.str] name: The name of the Cognitive Services Account Deployment model. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] version: The version of Cognitive Services Account Deployment model. If `version` is not specified, the default version of the model at the time will be assigned.
        """
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def format(self) -> pulumi.Input[_builtins.str]:
        """
        The format of the Cognitive Services Account Deployment model. Changing this forces a new resource to be created.

        > **Note:** Possible values of `format` can be found by running the command `az cognitiveservices account list-models`. The available values may vary by region or due to quota limitations. These could include models from `AI21 Labs`, `Black Forest Labs`, `Cohere`, `Core42`, `DeepSeek`, `Meta`, `Microsoft`, `Mistral AI`, `OpenAI`, and `xAI`.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "format", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Cognitive Services Account Deployment model. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of Cognitive Services Account Deployment model. If `version` is not specified, the default version of the model at the time will be assigned.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)


if not MYPY:
    class DeploymentSkuArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        capacity: NotRequired[pulumi.Input[_builtins.int]]
        """
        Tokens-per-Minute (TPM). The unit of measure for this field is in the thousands of Tokens-per-Minute. Defaults to `1` which means that the limitation is `1000` tokens per minute. If the resources SKU supports scale in/out then the capacity field should be included in the resources' configuration. If the scale in/out is not supported by the resources SKU then this field can be safely omitted. For more information about TPM please see the [product documentation](https://learn.microsoft.com/azure/ai-services/openai/how-to/quota?tabs=rest).
        """
        family: NotRequired[pulumi.Input[_builtins.str]]
        """
        If the service has different generations of hardware, for the same SKU, then that can be captured here. Changing this forces a new resource to be created.
        """
        size: NotRequired[pulumi.Input[_builtins.str]]
        """
        The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. Changing this forces a new resource to be created.
        """
        tier: NotRequired[pulumi.Input[_builtins.str]]
        """
        Possible values are `Free`, `Basic`, `Standard`, `Premium`, `Enterprise`. This property is required only when multiple tiers are available with the SKU name. Changing this forces a new resource to be created.
        """
elif False:
    DeploymentSkuArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class DeploymentSkuArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 family: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.str]] = None,
                 tier: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.int] capacity: Tokens-per-Minute (TPM). The unit of measure for this field is in the thousands of Tokens-per-Minute. Defaults to `1` which means that the limitation is `1000` tokens per minute. If the resources SKU supports scale in/out then the capacity field should be included in the resources' configuration. If the scale in/out is not supported by the resources SKU then this field can be safely omitted. For more information about TPM please see the [product documentation](https://learn.microsoft.com/azure/ai-services/openai/how-to/quota?tabs=rest).
        :param pulumi.Input[_builtins.str] family: If the service has different generations of hardware, for the same SKU, then that can be captured here. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] size: The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] tier: Possible values are `Free`, `Basic`, `Standard`, `Premium`, `Enterprise`. This property is required only when multiple tiers are available with the SKU name. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "name", name)
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if family is not None:
            pulumi.set(__self__, "family", family)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Tokens-per-Minute (TPM). The unit of measure for this field is in the thousands of Tokens-per-Minute. Defaults to `1` which means that the limitation is `1000` tokens per minute. If the resources SKU supports scale in/out then the capacity field should be included in the resources' configuration. If the scale in/out is not supported by the resources SKU then this field can be safely omitted. For more information about TPM please see the [product documentation](https://learn.microsoft.com/azure/ai-services/openai/how-to/quota?tabs=rest).
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter
    def family(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If the service has different generations of hardware, for the same SKU, then that can be captured here. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "family")

    @family.setter
    def family(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "family", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU size. When the name field is the combination of tier and some other value, this would be the standalone code. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Possible values are `Free`, `Basic`, `Standard`, `Premium`, `Enterprise`. This property is required only when multiple tiers are available with the SKU name. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tier", value)


