# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AIServicesArgs', 'AIServices']

@pulumi.input_type
class AIServicesArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku_name: pulumi.Input[_builtins.str],
                 custom_subdomain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input['AIServicesCustomerManagedKeyArgs']] = None,
                 fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 identity: Optional[pulumi.Input['AIServicesIdentityArgs']] = None,
                 local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_acls: Optional[pulumi.Input['AIServicesNetworkAclsArgs']] = None,
                 outbound_network_access_restricted: Optional[pulumi.Input[_builtins.bool]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 storages: Optional[pulumi.Input[Sequence[pulumi.Input['AIServicesStorageArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a AIServices resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the AI Services Account is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: Specifies the SKU Name for this AI Services Account. Possible values are `F0`, `F1`, `S0`, `S`, `S1`, `S2`, `S3`, `S4`, `S5`, `S6`, `P0`, `P1`, `P2`, `E0` and `DC0`.
               
               > **Note:** SKU `DC0` is the commitment tier for AI Services Account containers running in disconnected environments. You must obtain approval from Microsoft by submitting the [request form](https://aka.ms/csdisconnectedcontainers) first, before you can use this SKU. More information on [Purchase a commitment plan to use containers in disconnected environments](https://learn.microsoft.com/en-us/azure/cognitive-services/containers/disconnected-containers?tabs=stt#purchase-a-commitment-plan-to-use-containers-in-disconnected-environments).
        :param pulumi.Input[_builtins.str] custom_subdomain_name: The subdomain name used for token-based authentication. This property is required when `network_acls` is specified. Changing this forces a new resource to be created.
               
               > **Note:** If you do not specify a `custom_subdomain_name` then you will not be able to attach a Private Endpoint to the resource.
        :param pulumi.Input['AIServicesCustomerManagedKeyArgs'] customer_managed_key: A `customer_managed_key` block as documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fqdns: List of FQDNs allowed for the AI Services Account.
        :param pulumi.Input['AIServicesIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] local_authentication_enabled: Whether local authentication is enabled for the AI Services Account. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the AI Services Account. Changing this forces a new resource to be created.
        :param pulumi.Input['AIServicesNetworkAclsArgs'] network_acls: A `network_acls` block as defined below. When this property is specified, `custom_subdomain_name` is also required to be set.
        :param pulumi.Input[_builtins.bool] outbound_network_access_restricted: Whether outbound network access is restricted for the AI Services Account. Defaults to `false`.
        :param pulumi.Input[_builtins.str] public_network_access: Whether public network access is allowed for the AI Services Account. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.
        :param pulumi.Input[Sequence[pulumi.Input['AIServicesStorageArgs']]] storages: A `storage` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku_name", sku_name)
        if custom_subdomain_name is not None:
            pulumi.set(__self__, "custom_subdomain_name", custom_subdomain_name)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if fqdns is not None:
            pulumi.set(__self__, "fqdns", fqdns)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if local_authentication_enabled is not None:
            pulumi.set(__self__, "local_authentication_enabled", local_authentication_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_acls is not None:
            pulumi.set(__self__, "network_acls", network_acls)
        if outbound_network_access_restricted is not None:
            pulumi.set(__self__, "outbound_network_access_restricted", outbound_network_access_restricted)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if storages is not None:
            pulumi.set(__self__, "storages", storages)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which the AI Services Account is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the SKU Name for this AI Services Account. Possible values are `F0`, `F1`, `S0`, `S`, `S1`, `S2`, `S3`, `S4`, `S5`, `S6`, `P0`, `P1`, `P2`, `E0` and `DC0`.

        > **Note:** SKU `DC0` is the commitment tier for AI Services Account containers running in disconnected environments. You must obtain approval from Microsoft by submitting the [request form](https://aka.ms/csdisconnectedcontainers) first, before you can use this SKU. More information on [Purchase a commitment plan to use containers in disconnected environments](https://learn.microsoft.com/en-us/azure/cognitive-services/containers/disconnected-containers?tabs=stt#purchase-a-commitment-plan-to-use-containers-in-disconnected-environments).
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="customSubdomainName")
    def custom_subdomain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subdomain name used for token-based authentication. This property is required when `network_acls` is specified. Changing this forces a new resource to be created.

        > **Note:** If you do not specify a `custom_subdomain_name` then you will not be able to attach a Private Endpoint to the resource.
        """
        return pulumi.get(self, "custom_subdomain_name")

    @custom_subdomain_name.setter
    def custom_subdomain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_subdomain_name", value)

    @_builtins.property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input['AIServicesCustomerManagedKeyArgs']]:
        """
        A `customer_managed_key` block as documented below.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input['AIServicesCustomerManagedKeyArgs']]):
        pulumi.set(self, "customer_managed_key", value)

    @_builtins.property
    @pulumi.getter
    def fqdns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of FQDNs allowed for the AI Services Account.
        """
        return pulumi.get(self, "fqdns")

    @fqdns.setter
    def fqdns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "fqdns", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['AIServicesIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['AIServicesIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="localAuthenticationEnabled")
    def local_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether local authentication is enabled for the AI Services Account. Defaults to `true`.
        """
        return pulumi.get(self, "local_authentication_enabled")

    @local_authentication_enabled.setter
    def local_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_authentication_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the AI Services Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkAcls")
    def network_acls(self) -> Optional[pulumi.Input['AIServicesNetworkAclsArgs']]:
        """
        A `network_acls` block as defined below. When this property is specified, `custom_subdomain_name` is also required to be set.
        """
        return pulumi.get(self, "network_acls")

    @network_acls.setter
    def network_acls(self, value: Optional[pulumi.Input['AIServicesNetworkAclsArgs']]):
        pulumi.set(self, "network_acls", value)

    @_builtins.property
    @pulumi.getter(name="outboundNetworkAccessRestricted")
    def outbound_network_access_restricted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether outbound network access is restricted for the AI Services Account. Defaults to `false`.
        """
        return pulumi.get(self, "outbound_network_access_restricted")

    @outbound_network_access_restricted.setter
    def outbound_network_access_restricted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "outbound_network_access_restricted", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether public network access is allowed for the AI Services Account. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_network_access", value)

    @_builtins.property
    @pulumi.getter
    def storages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AIServicesStorageArgs']]]]:
        """
        A `storage` block as defined below.
        """
        return pulumi.get(self, "storages")

    @storages.setter
    def storages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AIServicesStorageArgs']]]]):
        pulumi.set(self, "storages", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _AIServicesState:
    def __init__(__self__, *,
                 custom_subdomain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input['AIServicesCustomerManagedKeyArgs']] = None,
                 endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 identity: Optional[pulumi.Input['AIServicesIdentityArgs']] = None,
                 local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_acls: Optional[pulumi.Input['AIServicesNetworkAclsArgs']] = None,
                 outbound_network_access_restricted: Optional[pulumi.Input[_builtins.bool]] = None,
                 primary_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storages: Optional[pulumi.Input[Sequence[pulumi.Input['AIServicesStorageArgs']]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering AIServices resources.
        :param pulumi.Input[_builtins.str] custom_subdomain_name: The subdomain name used for token-based authentication. This property is required when `network_acls` is specified. Changing this forces a new resource to be created.
               
               > **Note:** If you do not specify a `custom_subdomain_name` then you will not be able to attach a Private Endpoint to the resource.
        :param pulumi.Input['AIServicesCustomerManagedKeyArgs'] customer_managed_key: A `customer_managed_key` block as documented below.
        :param pulumi.Input[_builtins.str] endpoint: The endpoint used to connect to the AI Services Account.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fqdns: List of FQDNs allowed for the AI Services Account.
        :param pulumi.Input['AIServicesIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] local_authentication_enabled: Whether local authentication is enabled for the AI Services Account. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the AI Services Account. Changing this forces a new resource to be created.
        :param pulumi.Input['AIServicesNetworkAclsArgs'] network_acls: A `network_acls` block as defined below. When this property is specified, `custom_subdomain_name` is also required to be set.
        :param pulumi.Input[_builtins.bool] outbound_network_access_restricted: Whether outbound network access is restricted for the AI Services Account. Defaults to `false`.
        :param pulumi.Input[_builtins.str] primary_access_key: A primary access key which can be used to connect to the AI Services Account.
        :param pulumi.Input[_builtins.str] public_network_access: Whether public network access is allowed for the AI Services Account. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the AI Services Account is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] secondary_access_key: The secondary access key which can be used to connect to the AI Services Account.
        :param pulumi.Input[_builtins.str] sku_name: Specifies the SKU Name for this AI Services Account. Possible values are `F0`, `F1`, `S0`, `S`, `S1`, `S2`, `S3`, `S4`, `S5`, `S6`, `P0`, `P1`, `P2`, `E0` and `DC0`.
               
               > **Note:** SKU `DC0` is the commitment tier for AI Services Account containers running in disconnected environments. You must obtain approval from Microsoft by submitting the [request form](https://aka.ms/csdisconnectedcontainers) first, before you can use this SKU. More information on [Purchase a commitment plan to use containers in disconnected environments](https://learn.microsoft.com/en-us/azure/cognitive-services/containers/disconnected-containers?tabs=stt#purchase-a-commitment-plan-to-use-containers-in-disconnected-environments).
        :param pulumi.Input[Sequence[pulumi.Input['AIServicesStorageArgs']]] storages: A `storage` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if custom_subdomain_name is not None:
            pulumi.set(__self__, "custom_subdomain_name", custom_subdomain_name)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if endpoint is not None:
            pulumi.set(__self__, "endpoint", endpoint)
        if fqdns is not None:
            pulumi.set(__self__, "fqdns", fqdns)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if local_authentication_enabled is not None:
            pulumi.set(__self__, "local_authentication_enabled", local_authentication_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_acls is not None:
            pulumi.set(__self__, "network_acls", network_acls)
        if outbound_network_access_restricted is not None:
            pulumi.set(__self__, "outbound_network_access_restricted", outbound_network_access_restricted)
        if primary_access_key is not None:
            pulumi.set(__self__, "primary_access_key", primary_access_key)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if secondary_access_key is not None:
            pulumi.set(__self__, "secondary_access_key", secondary_access_key)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if storages is not None:
            pulumi.set(__self__, "storages", storages)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="customSubdomainName")
    def custom_subdomain_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The subdomain name used for token-based authentication. This property is required when `network_acls` is specified. Changing this forces a new resource to be created.

        > **Note:** If you do not specify a `custom_subdomain_name` then you will not be able to attach a Private Endpoint to the resource.
        """
        return pulumi.get(self, "custom_subdomain_name")

    @custom_subdomain_name.setter
    def custom_subdomain_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_subdomain_name", value)

    @_builtins.property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input['AIServicesCustomerManagedKeyArgs']]:
        """
        A `customer_managed_key` block as documented below.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input['AIServicesCustomerManagedKeyArgs']]):
        pulumi.set(self, "customer_managed_key", value)

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The endpoint used to connect to the AI Services Account.
        """
        return pulumi.get(self, "endpoint")

    @endpoint.setter
    def endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint", value)

    @_builtins.property
    @pulumi.getter
    def fqdns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of FQDNs allowed for the AI Services Account.
        """
        return pulumi.get(self, "fqdns")

    @fqdns.setter
    def fqdns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "fqdns", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['AIServicesIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['AIServicesIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="localAuthenticationEnabled")
    def local_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether local authentication is enabled for the AI Services Account. Defaults to `true`.
        """
        return pulumi.get(self, "local_authentication_enabled")

    @local_authentication_enabled.setter
    def local_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_authentication_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the AI Services Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkAcls")
    def network_acls(self) -> Optional[pulumi.Input['AIServicesNetworkAclsArgs']]:
        """
        A `network_acls` block as defined below. When this property is specified, `custom_subdomain_name` is also required to be set.
        """
        return pulumi.get(self, "network_acls")

    @network_acls.setter
    def network_acls(self, value: Optional[pulumi.Input['AIServicesNetworkAclsArgs']]):
        pulumi.set(self, "network_acls", value)

    @_builtins.property
    @pulumi.getter(name="outboundNetworkAccessRestricted")
    def outbound_network_access_restricted(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether outbound network access is restricted for the AI Services Account. Defaults to `false`.
        """
        return pulumi.get(self, "outbound_network_access_restricted")

    @outbound_network_access_restricted.setter
    def outbound_network_access_restricted(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "outbound_network_access_restricted", value)

    @_builtins.property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A primary access key which can be used to connect to the AI Services Account.
        """
        return pulumi.get(self, "primary_access_key")

    @primary_access_key.setter
    def primary_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_access_key", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether public network access is allowed for the AI Services Account. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_network_access", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which the AI Services Account is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secondary access key which can be used to connect to the AI Services Account.
        """
        return pulumi.get(self, "secondary_access_key")

    @secondary_access_key.setter
    def secondary_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_access_key", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the SKU Name for this AI Services Account. Possible values are `F0`, `F1`, `S0`, `S`, `S1`, `S2`, `S3`, `S4`, `S5`, `S6`, `P0`, `P1`, `P2`, `E0` and `DC0`.

        > **Note:** SKU `DC0` is the commitment tier for AI Services Account containers running in disconnected environments. You must obtain approval from Microsoft by submitting the [request form](https://aka.ms/csdisconnectedcontainers) first, before you can use this SKU. More information on [Purchase a commitment plan to use containers in disconnected environments](https://learn.microsoft.com/en-us/azure/cognitive-services/containers/disconnected-containers?tabs=stt#purchase-a-commitment-plan-to-use-containers-in-disconnected-environments).
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter
    def storages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AIServicesStorageArgs']]]]:
        """
        A `storage` block as defined below.
        """
        return pulumi.get(self, "storages")

    @storages.setter
    def storages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AIServicesStorageArgs']]]]):
        pulumi.set(self, "storages", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:cognitive/aIServices:AIServices")
class AIServices(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_subdomain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input[Union['AIServicesCustomerManagedKeyArgs', 'AIServicesCustomerManagedKeyArgsDict']]] = None,
                 fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 identity: Optional[pulumi.Input[Union['AIServicesIdentityArgs', 'AIServicesIdentityArgsDict']]] = None,
                 local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_acls: Optional[pulumi.Input[Union['AIServicesNetworkAclsArgs', 'AIServicesNetworkAclsArgsDict']]] = None,
                 outbound_network_access_restricted: Optional[pulumi.Input[_builtins.bool]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AIServicesStorageArgs', 'AIServicesStorageArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an AI Services Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_ai_services = azure.cognitive.AIServices("example",
            name="example-account",
            location=example.location,
            resource_group_name=example.name,
            sku_name="S0",
            tags={
                "Acceptance": "Test",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.CognitiveServices` - 2025-06-01

        ## Import

        AI Services Account can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cognitive/aIServices:AIServices account1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.CognitiveServices/accounts/account1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_subdomain_name: The subdomain name used for token-based authentication. This property is required when `network_acls` is specified. Changing this forces a new resource to be created.
               
               > **Note:** If you do not specify a `custom_subdomain_name` then you will not be able to attach a Private Endpoint to the resource.
        :param pulumi.Input[Union['AIServicesCustomerManagedKeyArgs', 'AIServicesCustomerManagedKeyArgsDict']] customer_managed_key: A `customer_managed_key` block as documented below.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fqdns: List of FQDNs allowed for the AI Services Account.
        :param pulumi.Input[Union['AIServicesIdentityArgs', 'AIServicesIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] local_authentication_enabled: Whether local authentication is enabled for the AI Services Account. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the AI Services Account. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['AIServicesNetworkAclsArgs', 'AIServicesNetworkAclsArgsDict']] network_acls: A `network_acls` block as defined below. When this property is specified, `custom_subdomain_name` is also required to be set.
        :param pulumi.Input[_builtins.bool] outbound_network_access_restricted: Whether outbound network access is restricted for the AI Services Account. Defaults to `false`.
        :param pulumi.Input[_builtins.str] public_network_access: Whether public network access is allowed for the AI Services Account. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the AI Services Account is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku_name: Specifies the SKU Name for this AI Services Account. Possible values are `F0`, `F1`, `S0`, `S`, `S1`, `S2`, `S3`, `S4`, `S5`, `S6`, `P0`, `P1`, `P2`, `E0` and `DC0`.
               
               > **Note:** SKU `DC0` is the commitment tier for AI Services Account containers running in disconnected environments. You must obtain approval from Microsoft by submitting the [request form](https://aka.ms/csdisconnectedcontainers) first, before you can use this SKU. More information on [Purchase a commitment plan to use containers in disconnected environments](https://learn.microsoft.com/en-us/azure/cognitive-services/containers/disconnected-containers?tabs=stt#purchase-a-commitment-plan-to-use-containers-in-disconnected-environments).
        :param pulumi.Input[Sequence[pulumi.Input[Union['AIServicesStorageArgs', 'AIServicesStorageArgsDict']]]] storages: A `storage` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AIServicesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an AI Services Account.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_ai_services = azure.cognitive.AIServices("example",
            name="example-account",
            location=example.location,
            resource_group_name=example.name,
            sku_name="S0",
            tags={
                "Acceptance": "Test",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.CognitiveServices` - 2025-06-01

        ## Import

        AI Services Account can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cognitive/aIServices:AIServices account1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.CognitiveServices/accounts/account1
        ```

        :param str resource_name: The name of the resource.
        :param AIServicesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AIServicesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_subdomain_name: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input[Union['AIServicesCustomerManagedKeyArgs', 'AIServicesCustomerManagedKeyArgsDict']]] = None,
                 fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 identity: Optional[pulumi.Input[Union['AIServicesIdentityArgs', 'AIServicesIdentityArgsDict']]] = None,
                 local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_acls: Optional[pulumi.Input[Union['AIServicesNetworkAclsArgs', 'AIServicesNetworkAclsArgsDict']]] = None,
                 outbound_network_access_restricted: Optional[pulumi.Input[_builtins.bool]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AIServicesStorageArgs', 'AIServicesStorageArgsDict']]]]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AIServicesArgs.__new__(AIServicesArgs)

            __props__.__dict__["custom_subdomain_name"] = custom_subdomain_name
            __props__.__dict__["customer_managed_key"] = customer_managed_key
            __props__.__dict__["fqdns"] = fqdns
            __props__.__dict__["identity"] = identity
            __props__.__dict__["local_authentication_enabled"] = local_authentication_enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["network_acls"] = network_acls
            __props__.__dict__["outbound_network_access_restricted"] = outbound_network_access_restricted
            __props__.__dict__["public_network_access"] = public_network_access
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku_name is None and not opts.urn:
                raise TypeError("Missing required property 'sku_name'")
            __props__.__dict__["sku_name"] = sku_name
            __props__.__dict__["storages"] = storages
            __props__.__dict__["tags"] = tags
            __props__.__dict__["endpoint"] = None
            __props__.__dict__["primary_access_key"] = None
            __props__.__dict__["secondary_access_key"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["primaryAccessKey", "secondaryAccessKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AIServices, __self__).__init__(
            'azure:cognitive/aIServices:AIServices',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_subdomain_name: Optional[pulumi.Input[_builtins.str]] = None,
            customer_managed_key: Optional[pulumi.Input[Union['AIServicesCustomerManagedKeyArgs', 'AIServicesCustomerManagedKeyArgsDict']]] = None,
            endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            fqdns: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            identity: Optional[pulumi.Input[Union['AIServicesIdentityArgs', 'AIServicesIdentityArgsDict']]] = None,
            local_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_acls: Optional[pulumi.Input[Union['AIServicesNetworkAclsArgs', 'AIServicesNetworkAclsArgsDict']]] = None,
            outbound_network_access_restricted: Optional[pulumi.Input[_builtins.bool]] = None,
            primary_access_key: Optional[pulumi.Input[_builtins.str]] = None,
            public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            secondary_access_key: Optional[pulumi.Input[_builtins.str]] = None,
            sku_name: Optional[pulumi.Input[_builtins.str]] = None,
            storages: Optional[pulumi.Input[Sequence[pulumi.Input[Union['AIServicesStorageArgs', 'AIServicesStorageArgsDict']]]]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'AIServices':
        """
        Get an existing AIServices resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_subdomain_name: The subdomain name used for token-based authentication. This property is required when `network_acls` is specified. Changing this forces a new resource to be created.
               
               > **Note:** If you do not specify a `custom_subdomain_name` then you will not be able to attach a Private Endpoint to the resource.
        :param pulumi.Input[Union['AIServicesCustomerManagedKeyArgs', 'AIServicesCustomerManagedKeyArgsDict']] customer_managed_key: A `customer_managed_key` block as documented below.
        :param pulumi.Input[_builtins.str] endpoint: The endpoint used to connect to the AI Services Account.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] fqdns: List of FQDNs allowed for the AI Services Account.
        :param pulumi.Input[Union['AIServicesIdentityArgs', 'AIServicesIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] local_authentication_enabled: Whether local authentication is enabled for the AI Services Account. Defaults to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the AI Services Account. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['AIServicesNetworkAclsArgs', 'AIServicesNetworkAclsArgsDict']] network_acls: A `network_acls` block as defined below. When this property is specified, `custom_subdomain_name` is also required to be set.
        :param pulumi.Input[_builtins.bool] outbound_network_access_restricted: Whether outbound network access is restricted for the AI Services Account. Defaults to `false`.
        :param pulumi.Input[_builtins.str] primary_access_key: A primary access key which can be used to connect to the AI Services Account.
        :param pulumi.Input[_builtins.str] public_network_access: Whether public network access is allowed for the AI Services Account. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the AI Services Account is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] secondary_access_key: The secondary access key which can be used to connect to the AI Services Account.
        :param pulumi.Input[_builtins.str] sku_name: Specifies the SKU Name for this AI Services Account. Possible values are `F0`, `F1`, `S0`, `S`, `S1`, `S2`, `S3`, `S4`, `S5`, `S6`, `P0`, `P1`, `P2`, `E0` and `DC0`.
               
               > **Note:** SKU `DC0` is the commitment tier for AI Services Account containers running in disconnected environments. You must obtain approval from Microsoft by submitting the [request form](https://aka.ms/csdisconnectedcontainers) first, before you can use this SKU. More information on [Purchase a commitment plan to use containers in disconnected environments](https://learn.microsoft.com/en-us/azure/cognitive-services/containers/disconnected-containers?tabs=stt#purchase-a-commitment-plan-to-use-containers-in-disconnected-environments).
        :param pulumi.Input[Sequence[pulumi.Input[Union['AIServicesStorageArgs', 'AIServicesStorageArgsDict']]]] storages: A `storage` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AIServicesState.__new__(_AIServicesState)

        __props__.__dict__["custom_subdomain_name"] = custom_subdomain_name
        __props__.__dict__["customer_managed_key"] = customer_managed_key
        __props__.__dict__["endpoint"] = endpoint
        __props__.__dict__["fqdns"] = fqdns
        __props__.__dict__["identity"] = identity
        __props__.__dict__["local_authentication_enabled"] = local_authentication_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["network_acls"] = network_acls
        __props__.__dict__["outbound_network_access_restricted"] = outbound_network_access_restricted
        __props__.__dict__["primary_access_key"] = primary_access_key
        __props__.__dict__["public_network_access"] = public_network_access
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["secondary_access_key"] = secondary_access_key
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["storages"] = storages
        __props__.__dict__["tags"] = tags
        return AIServices(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="customSubdomainName")
    def custom_subdomain_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The subdomain name used for token-based authentication. This property is required when `network_acls` is specified. Changing this forces a new resource to be created.

        > **Note:** If you do not specify a `custom_subdomain_name` then you will not be able to attach a Private Endpoint to the resource.
        """
        return pulumi.get(self, "custom_subdomain_name")

    @_builtins.property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> pulumi.Output[Optional['outputs.AIServicesCustomerManagedKey']]:
        """
        A `customer_managed_key` block as documented below.
        """
        return pulumi.get(self, "customer_managed_key")

    @_builtins.property
    @pulumi.getter
    def endpoint(self) -> pulumi.Output[_builtins.str]:
        """
        The endpoint used to connect to the AI Services Account.
        """
        return pulumi.get(self, "endpoint")

    @_builtins.property
    @pulumi.getter
    def fqdns(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of FQDNs allowed for the AI Services Account.
        """
        return pulumi.get(self, "fqdns")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.AIServicesIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="localAuthenticationEnabled")
    def local_authentication_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether local authentication is enabled for the AI Services Account. Defaults to `true`.
        """
        return pulumi.get(self, "local_authentication_enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the AI Services Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkAcls")
    def network_acls(self) -> pulumi.Output[Optional['outputs.AIServicesNetworkAcls']]:
        """
        A `network_acls` block as defined below. When this property is specified, `custom_subdomain_name` is also required to be set.
        """
        return pulumi.get(self, "network_acls")

    @_builtins.property
    @pulumi.getter(name="outboundNetworkAccessRestricted")
    def outbound_network_access_restricted(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether outbound network access is restricted for the AI Services Account. Defaults to `false`.
        """
        return pulumi.get(self, "outbound_network_access_restricted")

    @_builtins.property
    @pulumi.getter(name="primaryAccessKey")
    def primary_access_key(self) -> pulumi.Output[_builtins.str]:
        """
        A primary access key which can be used to connect to the AI Services Account.
        """
        return pulumi.get(self, "primary_access_key")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether public network access is allowed for the AI Services Account. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.
        """
        return pulumi.get(self, "public_network_access")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which the AI Services Account is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="secondaryAccessKey")
    def secondary_access_key(self) -> pulumi.Output[_builtins.str]:
        """
        The secondary access key which can be used to connect to the AI Services Account.
        """
        return pulumi.get(self, "secondary_access_key")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the SKU Name for this AI Services Account. Possible values are `F0`, `F1`, `S0`, `S`, `S1`, `S2`, `S3`, `S4`, `S5`, `S6`, `P0`, `P1`, `P2`, `E0` and `DC0`.

        > **Note:** SKU `DC0` is the commitment tier for AI Services Account containers running in disconnected environments. You must obtain approval from Microsoft by submitting the [request form](https://aka.ms/csdisconnectedcontainers) first, before you can use this SKU. More information on [Purchase a commitment plan to use containers in disconnected environments](https://learn.microsoft.com/en-us/azure/cognitive-services/containers/disconnected-containers?tabs=stt#purchase-a-commitment-plan-to-use-containers-in-disconnected-environments).
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter
    def storages(self) -> pulumi.Output[Optional[Sequence['outputs.AIServicesStorage']]]:
        """
        A `storage` block as defined below.
        """
        return pulumi.get(self, "storages")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

