# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DeploymentArgs', 'Deployment']

@pulumi.input_type
class DeploymentArgs:
    def __init__(__self__, *,
                 cognitive_account_id: pulumi.Input[_builtins.str],
                 model: pulumi.Input['DeploymentModelArgs'],
                 sku: pulumi.Input['DeploymentSkuArgs'],
                 dynamic_throttling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rai_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 version_upgrade_option: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Deployment resource.
        :param pulumi.Input[_builtins.str] cognitive_account_id: The ID of the Cognitive Services Account. Changing this forces a new resource to be created.
        :param pulumi.Input['DeploymentModelArgs'] model: A `model` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input['DeploymentSkuArgs'] sku: A `sku` block as defined below.
        :param pulumi.Input[_builtins.bool] dynamic_throttling_enabled: Whether dynamic throttling is enabled.
        :param pulumi.Input[_builtins.str] name: The name of the Cognitive Services Account Deployment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] rai_policy_name: The name of RAI policy.
        :param pulumi.Input[_builtins.str] version_upgrade_option: Deployment model version upgrade option. Possible values are `OnceNewDefaultVersionAvailable`, `OnceCurrentVersionExpired`, and `NoAutoUpgrade`. Defaults to `OnceNewDefaultVersionAvailable`.
        """
        pulumi.set(__self__, "cognitive_account_id", cognitive_account_id)
        pulumi.set(__self__, "model", model)
        pulumi.set(__self__, "sku", sku)
        if dynamic_throttling_enabled is not None:
            pulumi.set(__self__, "dynamic_throttling_enabled", dynamic_throttling_enabled)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rai_policy_name is not None:
            pulumi.set(__self__, "rai_policy_name", rai_policy_name)
        if version_upgrade_option is not None:
            pulumi.set(__self__, "version_upgrade_option", version_upgrade_option)

    @_builtins.property
    @pulumi.getter(name="cognitiveAccountId")
    def cognitive_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Cognitive Services Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cognitive_account_id")

    @cognitive_account_id.setter
    def cognitive_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cognitive_account_id", value)

    @_builtins.property
    @pulumi.getter
    def model(self) -> pulumi.Input['DeploymentModelArgs']:
        """
        A `model` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "model")

    @model.setter
    def model(self, value: pulumi.Input['DeploymentModelArgs']):
        pulumi.set(self, "model", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Input['DeploymentSkuArgs']:
        """
        A `sku` block as defined below.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input['DeploymentSkuArgs']):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="dynamicThrottlingEnabled")
    def dynamic_throttling_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether dynamic throttling is enabled.
        """
        return pulumi.get(self, "dynamic_throttling_enabled")

    @dynamic_throttling_enabled.setter
    def dynamic_throttling_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dynamic_throttling_enabled", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Cognitive Services Account Deployment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="raiPolicyName")
    def rai_policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of RAI policy.
        """
        return pulumi.get(self, "rai_policy_name")

    @rai_policy_name.setter
    def rai_policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rai_policy_name", value)

    @_builtins.property
    @pulumi.getter(name="versionUpgradeOption")
    def version_upgrade_option(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deployment model version upgrade option. Possible values are `OnceNewDefaultVersionAvailable`, `OnceCurrentVersionExpired`, and `NoAutoUpgrade`. Defaults to `OnceNewDefaultVersionAvailable`.
        """
        return pulumi.get(self, "version_upgrade_option")

    @version_upgrade_option.setter
    def version_upgrade_option(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_upgrade_option", value)


@pulumi.input_type
class _DeploymentState:
    def __init__(__self__, *,
                 cognitive_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_throttling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 model: Optional[pulumi.Input['DeploymentModelArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rai_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input['DeploymentSkuArgs']] = None,
                 version_upgrade_option: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Deployment resources.
        :param pulumi.Input[_builtins.str] cognitive_account_id: The ID of the Cognitive Services Account. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] dynamic_throttling_enabled: Whether dynamic throttling is enabled.
        :param pulumi.Input['DeploymentModelArgs'] model: A `model` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Cognitive Services Account Deployment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] rai_policy_name: The name of RAI policy.
        :param pulumi.Input['DeploymentSkuArgs'] sku: A `sku` block as defined below.
        :param pulumi.Input[_builtins.str] version_upgrade_option: Deployment model version upgrade option. Possible values are `OnceNewDefaultVersionAvailable`, `OnceCurrentVersionExpired`, and `NoAutoUpgrade`. Defaults to `OnceNewDefaultVersionAvailable`.
        """
        if cognitive_account_id is not None:
            pulumi.set(__self__, "cognitive_account_id", cognitive_account_id)
        if dynamic_throttling_enabled is not None:
            pulumi.set(__self__, "dynamic_throttling_enabled", dynamic_throttling_enabled)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rai_policy_name is not None:
            pulumi.set(__self__, "rai_policy_name", rai_policy_name)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if version_upgrade_option is not None:
            pulumi.set(__self__, "version_upgrade_option", version_upgrade_option)

    @_builtins.property
    @pulumi.getter(name="cognitiveAccountId")
    def cognitive_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Cognitive Services Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cognitive_account_id")

    @cognitive_account_id.setter
    def cognitive_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cognitive_account_id", value)

    @_builtins.property
    @pulumi.getter(name="dynamicThrottlingEnabled")
    def dynamic_throttling_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether dynamic throttling is enabled.
        """
        return pulumi.get(self, "dynamic_throttling_enabled")

    @dynamic_throttling_enabled.setter
    def dynamic_throttling_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "dynamic_throttling_enabled", value)

    @_builtins.property
    @pulumi.getter
    def model(self) -> Optional[pulumi.Input['DeploymentModelArgs']]:
        """
        A `model` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "model")

    @model.setter
    def model(self, value: Optional[pulumi.Input['DeploymentModelArgs']]):
        pulumi.set(self, "model", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Cognitive Services Account Deployment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="raiPolicyName")
    def rai_policy_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of RAI policy.
        """
        return pulumi.get(self, "rai_policy_name")

    @rai_policy_name.setter
    def rai_policy_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "rai_policy_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input['DeploymentSkuArgs']]:
        """
        A `sku` block as defined below.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input['DeploymentSkuArgs']]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="versionUpgradeOption")
    def version_upgrade_option(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Deployment model version upgrade option. Possible values are `OnceNewDefaultVersionAvailable`, `OnceCurrentVersionExpired`, and `NoAutoUpgrade`. Defaults to `OnceNewDefaultVersionAvailable`.
        """
        return pulumi.get(self, "version_upgrade_option")

    @version_upgrade_option.setter
    def version_upgrade_option(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version_upgrade_option", value)


@pulumi.type_token("azure:cognitive/deployment:Deployment")
class Deployment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cognitive_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_throttling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 model: Optional[pulumi.Input[Union['DeploymentModelArgs', 'DeploymentModelArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rai_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[Union['DeploymentSkuArgs', 'DeploymentSkuArgsDict']]] = None,
                 version_upgrade_option: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Cognitive Services Account Deployment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.cognitive.Account("example",
            name="example-ca",
            location=example.location,
            resource_group_name=example.name,
            kind="OpenAI",
            sku_name="S0")
        example_deployment = azure.cognitive.Deployment("example",
            name="example-cd",
            cognitive_account_id=example_account.id,
            model={
                "format": "OpenAI",
                "name": "text-curie-001",
                "version": "1",
            },
            sku={
                "name": "Standard",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.CognitiveServices` - 2025-06-01

        ## Import

        Cognitive Services Account Deployment can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cognitive/deployment:Deployment example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.CognitiveServices/accounts/account1/deployments/deployment1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cognitive_account_id: The ID of the Cognitive Services Account. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] dynamic_throttling_enabled: Whether dynamic throttling is enabled.
        :param pulumi.Input[Union['DeploymentModelArgs', 'DeploymentModelArgsDict']] model: A `model` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Cognitive Services Account Deployment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] rai_policy_name: The name of RAI policy.
        :param pulumi.Input[Union['DeploymentSkuArgs', 'DeploymentSkuArgsDict']] sku: A `sku` block as defined below.
        :param pulumi.Input[_builtins.str] version_upgrade_option: Deployment model version upgrade option. Possible values are `OnceNewDefaultVersionAvailable`, `OnceCurrentVersionExpired`, and `NoAutoUpgrade`. Defaults to `OnceNewDefaultVersionAvailable`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DeploymentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Cognitive Services Account Deployment.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_account = azure.cognitive.Account("example",
            name="example-ca",
            location=example.location,
            resource_group_name=example.name,
            kind="OpenAI",
            sku_name="S0")
        example_deployment = azure.cognitive.Deployment("example",
            name="example-cd",
            cognitive_account_id=example_account.id,
            model={
                "format": "OpenAI",
                "name": "text-curie-001",
                "version": "1",
            },
            sku={
                "name": "Standard",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.CognitiveServices` - 2025-06-01

        ## Import

        Cognitive Services Account Deployment can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cognitive/deployment:Deployment example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resourceGroup1/providers/Microsoft.CognitiveServices/accounts/account1/deployments/deployment1
        ```

        :param str resource_name: The name of the resource.
        :param DeploymentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DeploymentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cognitive_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 dynamic_throttling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 model: Optional[pulumi.Input[Union['DeploymentModelArgs', 'DeploymentModelArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 rai_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[Union['DeploymentSkuArgs', 'DeploymentSkuArgsDict']]] = None,
                 version_upgrade_option: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DeploymentArgs.__new__(DeploymentArgs)

            if cognitive_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'cognitive_account_id'")
            __props__.__dict__["cognitive_account_id"] = cognitive_account_id
            __props__.__dict__["dynamic_throttling_enabled"] = dynamic_throttling_enabled
            if model is None and not opts.urn:
                raise TypeError("Missing required property 'model'")
            __props__.__dict__["model"] = model
            __props__.__dict__["name"] = name
            __props__.__dict__["rai_policy_name"] = rai_policy_name
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            __props__.__dict__["version_upgrade_option"] = version_upgrade_option
        super(Deployment, __self__).__init__(
            'azure:cognitive/deployment:Deployment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cognitive_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            dynamic_throttling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            model: Optional[pulumi.Input[Union['DeploymentModelArgs', 'DeploymentModelArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            rai_policy_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku: Optional[pulumi.Input[Union['DeploymentSkuArgs', 'DeploymentSkuArgsDict']]] = None,
            version_upgrade_option: Optional[pulumi.Input[_builtins.str]] = None) -> 'Deployment':
        """
        Get an existing Deployment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cognitive_account_id: The ID of the Cognitive Services Account. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] dynamic_throttling_enabled: Whether dynamic throttling is enabled.
        :param pulumi.Input[Union['DeploymentModelArgs', 'DeploymentModelArgsDict']] model: A `model` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Cognitive Services Account Deployment. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] rai_policy_name: The name of RAI policy.
        :param pulumi.Input[Union['DeploymentSkuArgs', 'DeploymentSkuArgsDict']] sku: A `sku` block as defined below.
        :param pulumi.Input[_builtins.str] version_upgrade_option: Deployment model version upgrade option. Possible values are `OnceNewDefaultVersionAvailable`, `OnceCurrentVersionExpired`, and `NoAutoUpgrade`. Defaults to `OnceNewDefaultVersionAvailable`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DeploymentState.__new__(_DeploymentState)

        __props__.__dict__["cognitive_account_id"] = cognitive_account_id
        __props__.__dict__["dynamic_throttling_enabled"] = dynamic_throttling_enabled
        __props__.__dict__["model"] = model
        __props__.__dict__["name"] = name
        __props__.__dict__["rai_policy_name"] = rai_policy_name
        __props__.__dict__["sku"] = sku
        __props__.__dict__["version_upgrade_option"] = version_upgrade_option
        return Deployment(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="cognitiveAccountId")
    def cognitive_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Cognitive Services Account. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cognitive_account_id")

    @_builtins.property
    @pulumi.getter(name="dynamicThrottlingEnabled")
    def dynamic_throttling_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether dynamic throttling is enabled.
        """
        return pulumi.get(self, "dynamic_throttling_enabled")

    @_builtins.property
    @pulumi.getter
    def model(self) -> pulumi.Output['outputs.DeploymentModel']:
        """
        A `model` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "model")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Cognitive Services Account Deployment. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="raiPolicyName")
    def rai_policy_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of RAI policy.
        """
        return pulumi.get(self, "rai_policy_name")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Output['outputs.DeploymentSku']:
        """
        A `sku` block as defined below.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter(name="versionUpgradeOption")
    def version_upgrade_option(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Deployment model version upgrade option. Possible values are `OnceNewDefaultVersionAvailable`, `OnceCurrentVersionExpired`, and `NoAutoUpgrade`. Defaults to `OnceNewDefaultVersionAvailable`.
        """
        return pulumi.get(self, "version_upgrade_option")

