# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagedDiskArgs', 'ManagedDisk']

@pulumi.input_type
class ManagedDiskArgs:
    def __init__(__self__, *,
                 create_option: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 storage_account_type: pulumi.Input[_builtins.str],
                 disk_access_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_iops_read_only: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_iops_read_write: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_mbps_read_only: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_mbps_read_write: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_settings: Optional[pulumi.Input['ManagedDiskEncryptionSettingsArgs']] = None,
                 gallery_image_reference_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hyper_v_generation: Optional[pulumi.Input[_builtins.str]] = None,
                 image_reference_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logical_sector_size: Optional[pulumi.Input[_builtins.int]] = None,
                 max_shares: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_access_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 on_demand_bursting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 optimized_frequent_attach_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_plus_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 secure_vm_disk_encryption_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[_builtins.str]] = None,
                 trusted_launch_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 upload_size_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ManagedDisk resource.
        :param pulumi.Input[_builtins.str] create_option: The method to use when creating the managed disk. Changing this forces a new resource to be created. Possible values include:
               * `Import` - Import a VHD file in to the managed disk (VHD specified with `source_uri`).
               * `ImportSecure` - Securely import a VHD file in to the managed disk (VHD specified with `source_uri`).
               * `Empty` - Create an empty managed disk.
               * `Copy` - Copy an existing managed disk or snapshot (specified with `source_resource_id`).
               * `FromImage` - Copy a Platform Image (specified with `image_reference_id`)
               * `Restore` - Set by Azure Backup or Site Recovery on a restored disk (specified with `source_resource_id`).
               * `Upload` - Upload a VHD disk with the help of SAS URL (to be used with `upload_size_bytes`).
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Managed Disk should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_account_type: The type of storage to use for the managed disk. Possible values are `Standard_LRS`, `StandardSSD_ZRS`, `Premium_LRS`, `PremiumV2_LRS`, `Premium_ZRS`, `StandardSSD_LRS` or `UltraSSD_LRS`.
               
               > **Note:** Azure Ultra Disk Storage is only available in a region that support availability zones and can only enabled on the following VM series: `ESv3`, `DSv3`, `FSv3`, `LSv2`, `M` and `Mv2`. For more information see the `Azure Ultra Disk Storage` [product documentation](https://docs.microsoft.com/azure/virtual-machines/windows/disks-enable-ultra-ssd).
        :param pulumi.Input[_builtins.str] disk_access_id: The ID of the disk access resource for using private endpoints on disks.
               
               > **Note:** `disk_access_id` is only supported when `network_access_policy` is set to `AllowPrivate`.
        :param pulumi.Input[_builtins.str] disk_encryption_set_id: The ID of a Disk Encryption Set which should be used to encrypt this Managed Disk. Conflicts with `secure_vm_disk_encryption_set_id`.
               
               > **NOTE:** The Disk Encryption Set must have the `Reader` Role Assignment scoped on the Key Vault - in addition to an Access Policy to the Key Vault
               
               > **NOTE:** Disk Encryption Sets are in Public Preview in a limited set of regions
        :param pulumi.Input[_builtins.int] disk_iops_read_only: The number of IOPS allowed across all VMs mounting the shared disk as read-only; only settable for UltraSSD disks and PremiumV2 disks with shared disk enabled. One operation can transfer between 4k and 256k bytes.
        :param pulumi.Input[_builtins.int] disk_iops_read_write: The number of IOPS allowed for this disk; only settable for UltraSSD disks and PremiumV2 disks. One operation can transfer between 4k and 256k bytes.
        :param pulumi.Input[_builtins.int] disk_mbps_read_only: The bandwidth allowed across all VMs mounting the shared disk as read-only; only settable for UltraSSD disks and PremiumV2 disks with shared disk enabled. MBps means millions of bytes per second.
        :param pulumi.Input[_builtins.int] disk_mbps_read_write: The bandwidth allowed for this disk; only settable for UltraSSD disks and PremiumV2 disks. MBps means millions of bytes per second.
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Managed Disk should exist. Changing this forces a new Managed Disk to be created.
        :param pulumi.Input['ManagedDiskEncryptionSettingsArgs'] encryption_settings: A `encryption_settings` block as defined below.
               
               > **NOTE:** Removing `encryption_settings` forces a new resource to be created.
        :param pulumi.Input[_builtins.str] gallery_image_reference_id: ID of a Gallery Image Version to copy when `create_option` is `FromImage`. This field cannot be specified if image_reference_id is specified. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] hyper_v_generation: The HyperV Generation of the Disk when the source of an `Import` or `Copy` operation targets a source that contains an operating system. Possible values are `V1` and `V2`. For `ImportSecure` it must be set to `V2`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] image_reference_id: ID of an existing platform/marketplace disk image to copy when `create_option` is `FromImage`. This field cannot be specified if gallery_image_reference_id is specified. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specified the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] logical_sector_size: Logical Sector Size. Possible values are: `512` and `4096`. Defaults to `4096`. Changing this forces a new resource to be created.
               
               > **NOTE:** Setting logical sector size is supported only with `UltraSSD_LRS` disks and `PremiumV2_LRS` disks.
        :param pulumi.Input[_builtins.int] max_shares: The maximum number of VMs that can attach to the disk at the same time. Value greater than one indicates a disk that can be mounted on multiple VMs at the same time.
               
               > **Note:** Premium SSD maxShares limit: `P15` and `P20` disks: 2. `P30`,`P40`,`P50` disks: 5. `P60`,`P70`,`P80` disks: 10. For ultra disks the `max_shares` minimum value is 1 and the maximum is 5.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Managed Disk. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] network_access_policy: Policy for accessing the disk via network. Allowed values are `AllowAll`, `AllowPrivate`, and `DenyAll`.
        :param pulumi.Input[_builtins.bool] on_demand_bursting_enabled: Specifies if On-Demand Bursting is enabled for the Managed Disk.
               
               > **Note:** Credit-Based Bursting is enabled by default on all eligible disks. More information on [Credit-Based and On-Demand Bursting can be found in the documentation](https://docs.microsoft.com/azure/virtual-machines/disk-bursting#disk-level-bursting).
        :param pulumi.Input[_builtins.bool] optimized_frequent_attach_enabled: Specifies whether this Managed Disk should be optimized for frequent disk attachments (where a disk is attached/detached more than 5 times in a day). Defaults to `false`.
               
               > **Note:** Setting `optimized_frequent_attach_enabled` to `true` causes the disks to not align with the fault domain of the Virtual Machine, which can have operational implications.
        :param pulumi.Input[_builtins.str] os_type: Specify a value when the source of an `Import`, `ImportSecure` or `Copy` operation targets a source that contains an operating system. Valid values are `Linux` or `Windows`.
        :param pulumi.Input[_builtins.bool] performance_plus_enabled: Specifies whether Performance Plus is enabled for this Managed Disk. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether it is allowed to access the disk via public network. Defaults to `true`.
               
               For more information on managed disks, such as sizing options and pricing, please check out the [Azure Documentation](https://docs.microsoft.com/azure/storage/storage-managed-disks-overview).
        :param pulumi.Input[_builtins.str] secure_vm_disk_encryption_set_id: The ID of the Disk Encryption Set which should be used to Encrypt this OS Disk when the Virtual Machine is a Confidential VM. Conflicts with `disk_encryption_set_id`. Changing this forces a new resource to be created.
               
               > **NOTE:** `secure_vm_disk_encryption_set_id` can only be specified when `security_type` is set to `ConfidentialVM_DiskEncryptedWithCustomerKey`.
        :param pulumi.Input[_builtins.str] security_type: Security Type of the Managed Disk when it is used for a Confidential VM. Possible values are `ConfidentialVM_VMGuestStateOnlyEncryptedWithPlatformKey`, `ConfidentialVM_DiskEncryptedWithPlatformKey` and `ConfidentialVM_DiskEncryptedWithCustomerKey`. Changing this forces a new resource to be created.
               
               > **NOTE:** When `security_type` is set to `ConfidentialVM_DiskEncryptedWithCustomerKey` the value of `create_option` must be one of `FromImage` or `ImportSecure`.
               
               
               > **NOTE:** `security_type` cannot be specified when `trusted_launch_enabled` is set to true.
               
               > **NOTE:** `secure_vm_disk_encryption_set_id` must be specified when `security_type` is set to `ConfidentialVM_DiskEncryptedWithCustomerKey`.
        :param pulumi.Input[_builtins.str] source_resource_id: The ID of an existing Managed Disk or Snapshot to copy when `create_option` is `Copy` or the recovery point to restore when `create_option` is `Restore`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_uri: URI to a valid VHD file to be used when `create_option` is `Import` or `ImportSecure`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account where the `source_uri` is located. Required when `create_option` is set to `Import` or `ImportSecure`. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.bool] trusted_launch_enabled: Specifies if Trusted Launch is enabled for the Managed Disk. Changing this forces a new resource to be created.
               
               > **Note:** Trusted Launch can only be enabled when `create_option` is `FromImage` or `Import`.
        :param pulumi.Input[_builtins.int] upload_size_bytes: Specifies the size of the managed disk to create in bytes. Required when `create_option` is `Upload`. The value must be equal to the source disk to be copied in bytes. Source disk size could be calculated with `ls -l` or `wc -c`. More information can be found at [Copy a managed disk](https://learn.microsoft.com/en-us/azure/virtual-machines/linux/disks-upload-vhd-to-managed-disk-cli#copy-a-managed-disk). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] zone: Specifies the Availability Zone in which this Managed Disk should be located. Changing this property forces a new resource to be created.
               
               > **Note:** Availability Zones are [only supported in select regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        pulumi.set(__self__, "create_option", create_option)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "storage_account_type", storage_account_type)
        if disk_access_id is not None:
            pulumi.set(__self__, "disk_access_id", disk_access_id)
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if disk_iops_read_only is not None:
            pulumi.set(__self__, "disk_iops_read_only", disk_iops_read_only)
        if disk_iops_read_write is not None:
            pulumi.set(__self__, "disk_iops_read_write", disk_iops_read_write)
        if disk_mbps_read_only is not None:
            pulumi.set(__self__, "disk_mbps_read_only", disk_mbps_read_only)
        if disk_mbps_read_write is not None:
            pulumi.set(__self__, "disk_mbps_read_write", disk_mbps_read_write)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if edge_zone is not None:
            pulumi.set(__self__, "edge_zone", edge_zone)
        if encryption_settings is not None:
            pulumi.set(__self__, "encryption_settings", encryption_settings)
        if gallery_image_reference_id is not None:
            pulumi.set(__self__, "gallery_image_reference_id", gallery_image_reference_id)
        if hyper_v_generation is not None:
            pulumi.set(__self__, "hyper_v_generation", hyper_v_generation)
        if image_reference_id is not None:
            pulumi.set(__self__, "image_reference_id", image_reference_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if logical_sector_size is not None:
            pulumi.set(__self__, "logical_sector_size", logical_sector_size)
        if max_shares is not None:
            pulumi.set(__self__, "max_shares", max_shares)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_access_policy is not None:
            pulumi.set(__self__, "network_access_policy", network_access_policy)
        if on_demand_bursting_enabled is not None:
            pulumi.set(__self__, "on_demand_bursting_enabled", on_demand_bursting_enabled)
        if optimized_frequent_attach_enabled is not None:
            pulumi.set(__self__, "optimized_frequent_attach_enabled", optimized_frequent_attach_enabled)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if performance_plus_enabled is not None:
            pulumi.set(__self__, "performance_plus_enabled", performance_plus_enabled)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if secure_vm_disk_encryption_set_id is not None:
            pulumi.set(__self__, "secure_vm_disk_encryption_set_id", secure_vm_disk_encryption_set_id)
        if security_type is not None:
            pulumi.set(__self__, "security_type", security_type)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if source_uri is not None:
            pulumi.set(__self__, "source_uri", source_uri)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)
        if trusted_launch_enabled is not None:
            pulumi.set(__self__, "trusted_launch_enabled", trusted_launch_enabled)
        if upload_size_bytes is not None:
            pulumi.set(__self__, "upload_size_bytes", upload_size_bytes)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="createOption")
    def create_option(self) -> pulumi.Input[_builtins.str]:
        """
        The method to use when creating the managed disk. Changing this forces a new resource to be created. Possible values include:
        * `Import` - Import a VHD file in to the managed disk (VHD specified with `source_uri`).
        * `ImportSecure` - Securely import a VHD file in to the managed disk (VHD specified with `source_uri`).
        * `Empty` - Create an empty managed disk.
        * `Copy` - Copy an existing managed disk or snapshot (specified with `source_resource_id`).
        * `FromImage` - Copy a Platform Image (specified with `image_reference_id`)
        * `Restore` - Set by Azure Backup or Site Recovery on a restored disk (specified with `source_resource_id`).
        * `Upload` - Upload a VHD disk with the help of SAS URL (to be used with `upload_size_bytes`).
        """
        return pulumi.get(self, "create_option")

    @create_option.setter
    def create_option(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "create_option", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the Managed Disk should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of storage to use for the managed disk. Possible values are `Standard_LRS`, `StandardSSD_ZRS`, `Premium_LRS`, `PremiumV2_LRS`, `Premium_ZRS`, `StandardSSD_LRS` or `UltraSSD_LRS`.

        > **Note:** Azure Ultra Disk Storage is only available in a region that support availability zones and can only enabled on the following VM series: `ESv3`, `DSv3`, `FSv3`, `LSv2`, `M` and `Mv2`. For more information see the `Azure Ultra Disk Storage` [product documentation](https://docs.microsoft.com/azure/virtual-machines/windows/disks-enable-ultra-ssd).
        """
        return pulumi.get(self, "storage_account_type")

    @storage_account_type.setter
    def storage_account_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_account_type", value)

    @_builtins.property
    @pulumi.getter(name="diskAccessId")
    def disk_access_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the disk access resource for using private endpoints on disks.

        > **Note:** `disk_access_id` is only supported when `network_access_policy` is set to `AllowPrivate`.
        """
        return pulumi.get(self, "disk_access_id")

    @disk_access_id.setter
    def disk_access_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_access_id", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of a Disk Encryption Set which should be used to encrypt this Managed Disk. Conflicts with `secure_vm_disk_encryption_set_id`.

        > **NOTE:** The Disk Encryption Set must have the `Reader` Role Assignment scoped on the Key Vault - in addition to an Access Policy to the Key Vault

        > **NOTE:** Disk Encryption Sets are in Public Preview in a limited set of regions
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @disk_encryption_set_id.setter
    def disk_encryption_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_encryption_set_id", value)

    @_builtins.property
    @pulumi.getter(name="diskIopsReadOnly")
    def disk_iops_read_only(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of IOPS allowed across all VMs mounting the shared disk as read-only; only settable for UltraSSD disks and PremiumV2 disks with shared disk enabled. One operation can transfer between 4k and 256k bytes.
        """
        return pulumi.get(self, "disk_iops_read_only")

    @disk_iops_read_only.setter
    def disk_iops_read_only(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_iops_read_only", value)

    @_builtins.property
    @pulumi.getter(name="diskIopsReadWrite")
    def disk_iops_read_write(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of IOPS allowed for this disk; only settable for UltraSSD disks and PremiumV2 disks. One operation can transfer between 4k and 256k bytes.
        """
        return pulumi.get(self, "disk_iops_read_write")

    @disk_iops_read_write.setter
    def disk_iops_read_write(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_iops_read_write", value)

    @_builtins.property
    @pulumi.getter(name="diskMbpsReadOnly")
    def disk_mbps_read_only(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The bandwidth allowed across all VMs mounting the shared disk as read-only; only settable for UltraSSD disks and PremiumV2 disks with shared disk enabled. MBps means millions of bytes per second.
        """
        return pulumi.get(self, "disk_mbps_read_only")

    @disk_mbps_read_only.setter
    def disk_mbps_read_only(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_mbps_read_only", value)

    @_builtins.property
    @pulumi.getter(name="diskMbpsReadWrite")
    def disk_mbps_read_write(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The bandwidth allowed for this disk; only settable for UltraSSD disks and PremiumV2 disks. MBps means millions of bytes per second.
        """
        return pulumi.get(self, "disk_mbps_read_write")

    @disk_mbps_read_write.setter
    def disk_mbps_read_write(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_mbps_read_write", value)

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_size_gb", value)

    @_builtins.property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Managed Disk should exist. Changing this forces a new Managed Disk to be created.
        """
        return pulumi.get(self, "edge_zone")

    @edge_zone.setter
    def edge_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_zone", value)

    @_builtins.property
    @pulumi.getter(name="encryptionSettings")
    def encryption_settings(self) -> Optional[pulumi.Input['ManagedDiskEncryptionSettingsArgs']]:
        """
        A `encryption_settings` block as defined below.

        > **NOTE:** Removing `encryption_settings` forces a new resource to be created.
        """
        return pulumi.get(self, "encryption_settings")

    @encryption_settings.setter
    def encryption_settings(self, value: Optional[pulumi.Input['ManagedDiskEncryptionSettingsArgs']]):
        pulumi.set(self, "encryption_settings", value)

    @_builtins.property
    @pulumi.getter(name="galleryImageReferenceId")
    def gallery_image_reference_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of a Gallery Image Version to copy when `create_option` is `FromImage`. This field cannot be specified if image_reference_id is specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "gallery_image_reference_id")

    @gallery_image_reference_id.setter
    def gallery_image_reference_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gallery_image_reference_id", value)

    @_builtins.property
    @pulumi.getter(name="hyperVGeneration")
    def hyper_v_generation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HyperV Generation of the Disk when the source of an `Import` or `Copy` operation targets a source that contains an operating system. Possible values are `V1` and `V2`. For `ImportSecure` it must be set to `V2`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "hyper_v_generation")

    @hyper_v_generation.setter
    def hyper_v_generation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hyper_v_generation", value)

    @_builtins.property
    @pulumi.getter(name="imageReferenceId")
    def image_reference_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of an existing platform/marketplace disk image to copy when `create_option` is `FromImage`. This field cannot be specified if gallery_image_reference_id is specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "image_reference_id")

    @image_reference_id.setter
    def image_reference_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_reference_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specified the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="logicalSectorSize")
    def logical_sector_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Logical Sector Size. Possible values are: `512` and `4096`. Defaults to `4096`. Changing this forces a new resource to be created.

        > **NOTE:** Setting logical sector size is supported only with `UltraSSD_LRS` disks and `PremiumV2_LRS` disks.
        """
        return pulumi.get(self, "logical_sector_size")

    @logical_sector_size.setter
    def logical_sector_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "logical_sector_size", value)

    @_builtins.property
    @pulumi.getter(name="maxShares")
    def max_shares(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of VMs that can attach to the disk at the same time. Value greater than one indicates a disk that can be mounted on multiple VMs at the same time.

        > **Note:** Premium SSD maxShares limit: `P15` and `P20` disks: 2. `P30`,`P40`,`P50` disks: 5. `P60`,`P70`,`P80` disks: 10. For ultra disks the `max_shares` minimum value is 1 and the maximum is 5.
        """
        return pulumi.get(self, "max_shares")

    @max_shares.setter
    def max_shares(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_shares", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Managed Disk. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkAccessPolicy")
    def network_access_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy for accessing the disk via network. Allowed values are `AllowAll`, `AllowPrivate`, and `DenyAll`.
        """
        return pulumi.get(self, "network_access_policy")

    @network_access_policy.setter
    def network_access_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_access_policy", value)

    @_builtins.property
    @pulumi.getter(name="onDemandBurstingEnabled")
    def on_demand_bursting_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if On-Demand Bursting is enabled for the Managed Disk.

        > **Note:** Credit-Based Bursting is enabled by default on all eligible disks. More information on [Credit-Based and On-Demand Bursting can be found in the documentation](https://docs.microsoft.com/azure/virtual-machines/disk-bursting#disk-level-bursting).
        """
        return pulumi.get(self, "on_demand_bursting_enabled")

    @on_demand_bursting_enabled.setter
    def on_demand_bursting_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "on_demand_bursting_enabled", value)

    @_builtins.property
    @pulumi.getter(name="optimizedFrequentAttachEnabled")
    def optimized_frequent_attach_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether this Managed Disk should be optimized for frequent disk attachments (where a disk is attached/detached more than 5 times in a day). Defaults to `false`.

        > **Note:** Setting `optimized_frequent_attach_enabled` to `true` causes the disks to not align with the fault domain of the Virtual Machine, which can have operational implications.
        """
        return pulumi.get(self, "optimized_frequent_attach_enabled")

    @optimized_frequent_attach_enabled.setter
    def optimized_frequent_attach_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "optimized_frequent_attach_enabled", value)

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify a value when the source of an `Import`, `ImportSecure` or `Copy` operation targets a source that contains an operating system. Valid values are `Linux` or `Windows`.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_type", value)

    @_builtins.property
    @pulumi.getter(name="performancePlusEnabled")
    def performance_plus_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether Performance Plus is enabled for this Managed Disk. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "performance_plus_enabled")

    @performance_plus_enabled.setter
    def performance_plus_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "performance_plus_enabled", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether it is allowed to access the disk via public network. Defaults to `true`.

        For more information on managed disks, such as sizing options and pricing, please check out the [Azure Documentation](https://docs.microsoft.com/azure/storage/storage-managed-disks-overview).
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="secureVmDiskEncryptionSetId")
    def secure_vm_disk_encryption_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Disk Encryption Set which should be used to Encrypt this OS Disk when the Virtual Machine is a Confidential VM. Conflicts with `disk_encryption_set_id`. Changing this forces a new resource to be created.

        > **NOTE:** `secure_vm_disk_encryption_set_id` can only be specified when `security_type` is set to `ConfidentialVM_DiskEncryptedWithCustomerKey`.
        """
        return pulumi.get(self, "secure_vm_disk_encryption_set_id")

    @secure_vm_disk_encryption_set_id.setter
    def secure_vm_disk_encryption_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secure_vm_disk_encryption_set_id", value)

    @_builtins.property
    @pulumi.getter(name="securityType")
    def security_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Security Type of the Managed Disk when it is used for a Confidential VM. Possible values are `ConfidentialVM_VMGuestStateOnlyEncryptedWithPlatformKey`, `ConfidentialVM_DiskEncryptedWithPlatformKey` and `ConfidentialVM_DiskEncryptedWithCustomerKey`. Changing this forces a new resource to be created.

        > **NOTE:** When `security_type` is set to `ConfidentialVM_DiskEncryptedWithCustomerKey` the value of `create_option` must be one of `FromImage` or `ImportSecure`.


        > **NOTE:** `security_type` cannot be specified when `trusted_launch_enabled` is set to true.

        > **NOTE:** `secure_vm_disk_encryption_set_id` must be specified when `security_type` is set to `ConfidentialVM_DiskEncryptedWithCustomerKey`.
        """
        return pulumi.get(self, "security_type")

    @security_type.setter
    def security_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_type", value)

    @_builtins.property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of an existing Managed Disk or Snapshot to copy when `create_option` is `Copy` or the recovery point to restore when `create_option` is `Restore`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceUri")
    def source_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URI to a valid VHD file to be used when `create_option` is `Import` or `ImportSecure`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_uri")

    @source_uri.setter
    def source_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_uri", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Storage Account where the `source_uri` is located. Required when `create_option` is set to `Import` or `ImportSecure`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tier", value)

    @_builtins.property
    @pulumi.getter(name="trustedLaunchEnabled")
    def trusted_launch_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if Trusted Launch is enabled for the Managed Disk. Changing this forces a new resource to be created.

        > **Note:** Trusted Launch can only be enabled when `create_option` is `FromImage` or `Import`.
        """
        return pulumi.get(self, "trusted_launch_enabled")

    @trusted_launch_enabled.setter
    def trusted_launch_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "trusted_launch_enabled", value)

    @_builtins.property
    @pulumi.getter(name="uploadSizeBytes")
    def upload_size_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the size of the managed disk to create in bytes. Required when `create_option` is `Upload`. The value must be equal to the source disk to be copied in bytes. Source disk size could be calculated with `ls -l` or `wc -c`. More information can be found at [Copy a managed disk](https://learn.microsoft.com/en-us/azure/virtual-machines/linux/disks-upload-vhd-to-managed-disk-cli#copy-a-managed-disk). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "upload_size_bytes")

    @upload_size_bytes.setter
    def upload_size_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "upload_size_bytes", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Availability Zone in which this Managed Disk should be located. Changing this property forces a new resource to be created.

        > **Note:** Availability Zones are [only supported in select regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _ManagedDiskState:
    def __init__(__self__, *,
                 create_option: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_access_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_iops_read_only: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_iops_read_write: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_mbps_read_only: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_mbps_read_write: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_settings: Optional[pulumi.Input['ManagedDiskEncryptionSettingsArgs']] = None,
                 gallery_image_reference_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hyper_v_generation: Optional[pulumi.Input[_builtins.str]] = None,
                 image_reference_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logical_sector_size: Optional[pulumi.Input[_builtins.int]] = None,
                 max_shares: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_access_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 on_demand_bursting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 optimized_frequent_attach_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_plus_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secure_vm_disk_encryption_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[_builtins.str]] = None,
                 trusted_launch_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 upload_size_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManagedDisk resources.
        :param pulumi.Input[_builtins.str] create_option: The method to use when creating the managed disk. Changing this forces a new resource to be created. Possible values include:
               * `Import` - Import a VHD file in to the managed disk (VHD specified with `source_uri`).
               * `ImportSecure` - Securely import a VHD file in to the managed disk (VHD specified with `source_uri`).
               * `Empty` - Create an empty managed disk.
               * `Copy` - Copy an existing managed disk or snapshot (specified with `source_resource_id`).
               * `FromImage` - Copy a Platform Image (specified with `image_reference_id`)
               * `Restore` - Set by Azure Backup or Site Recovery on a restored disk (specified with `source_resource_id`).
               * `Upload` - Upload a VHD disk with the help of SAS URL (to be used with `upload_size_bytes`).
        :param pulumi.Input[_builtins.str] disk_access_id: The ID of the disk access resource for using private endpoints on disks.
               
               > **Note:** `disk_access_id` is only supported when `network_access_policy` is set to `AllowPrivate`.
        :param pulumi.Input[_builtins.str] disk_encryption_set_id: The ID of a Disk Encryption Set which should be used to encrypt this Managed Disk. Conflicts with `secure_vm_disk_encryption_set_id`.
               
               > **NOTE:** The Disk Encryption Set must have the `Reader` Role Assignment scoped on the Key Vault - in addition to an Access Policy to the Key Vault
               
               > **NOTE:** Disk Encryption Sets are in Public Preview in a limited set of regions
        :param pulumi.Input[_builtins.int] disk_iops_read_only: The number of IOPS allowed across all VMs mounting the shared disk as read-only; only settable for UltraSSD disks and PremiumV2 disks with shared disk enabled. One operation can transfer between 4k and 256k bytes.
        :param pulumi.Input[_builtins.int] disk_iops_read_write: The number of IOPS allowed for this disk; only settable for UltraSSD disks and PremiumV2 disks. One operation can transfer between 4k and 256k bytes.
        :param pulumi.Input[_builtins.int] disk_mbps_read_only: The bandwidth allowed across all VMs mounting the shared disk as read-only; only settable for UltraSSD disks and PremiumV2 disks with shared disk enabled. MBps means millions of bytes per second.
        :param pulumi.Input[_builtins.int] disk_mbps_read_write: The bandwidth allowed for this disk; only settable for UltraSSD disks and PremiumV2 disks. MBps means millions of bytes per second.
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Managed Disk should exist. Changing this forces a new Managed Disk to be created.
        :param pulumi.Input['ManagedDiskEncryptionSettingsArgs'] encryption_settings: A `encryption_settings` block as defined below.
               
               > **NOTE:** Removing `encryption_settings` forces a new resource to be created.
        :param pulumi.Input[_builtins.str] gallery_image_reference_id: ID of a Gallery Image Version to copy when `create_option` is `FromImage`. This field cannot be specified if image_reference_id is specified. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] hyper_v_generation: The HyperV Generation of the Disk when the source of an `Import` or `Copy` operation targets a source that contains an operating system. Possible values are `V1` and `V2`. For `ImportSecure` it must be set to `V2`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] image_reference_id: ID of an existing platform/marketplace disk image to copy when `create_option` is `FromImage`. This field cannot be specified if gallery_image_reference_id is specified. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specified the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] logical_sector_size: Logical Sector Size. Possible values are: `512` and `4096`. Defaults to `4096`. Changing this forces a new resource to be created.
               
               > **NOTE:** Setting logical sector size is supported only with `UltraSSD_LRS` disks and `PremiumV2_LRS` disks.
        :param pulumi.Input[_builtins.int] max_shares: The maximum number of VMs that can attach to the disk at the same time. Value greater than one indicates a disk that can be mounted on multiple VMs at the same time.
               
               > **Note:** Premium SSD maxShares limit: `P15` and `P20` disks: 2. `P30`,`P40`,`P50` disks: 5. `P60`,`P70`,`P80` disks: 10. For ultra disks the `max_shares` minimum value is 1 and the maximum is 5.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Managed Disk. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] network_access_policy: Policy for accessing the disk via network. Allowed values are `AllowAll`, `AllowPrivate`, and `DenyAll`.
        :param pulumi.Input[_builtins.bool] on_demand_bursting_enabled: Specifies if On-Demand Bursting is enabled for the Managed Disk.
               
               > **Note:** Credit-Based Bursting is enabled by default on all eligible disks. More information on [Credit-Based and On-Demand Bursting can be found in the documentation](https://docs.microsoft.com/azure/virtual-machines/disk-bursting#disk-level-bursting).
        :param pulumi.Input[_builtins.bool] optimized_frequent_attach_enabled: Specifies whether this Managed Disk should be optimized for frequent disk attachments (where a disk is attached/detached more than 5 times in a day). Defaults to `false`.
               
               > **Note:** Setting `optimized_frequent_attach_enabled` to `true` causes the disks to not align with the fault domain of the Virtual Machine, which can have operational implications.
        :param pulumi.Input[_builtins.str] os_type: Specify a value when the source of an `Import`, `ImportSecure` or `Copy` operation targets a source that contains an operating system. Valid values are `Linux` or `Windows`.
        :param pulumi.Input[_builtins.bool] performance_plus_enabled: Specifies whether Performance Plus is enabled for this Managed Disk. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether it is allowed to access the disk via public network. Defaults to `true`.
               
               For more information on managed disks, such as sizing options and pricing, please check out the [Azure Documentation](https://docs.microsoft.com/azure/storage/storage-managed-disks-overview).
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Managed Disk should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] secure_vm_disk_encryption_set_id: The ID of the Disk Encryption Set which should be used to Encrypt this OS Disk when the Virtual Machine is a Confidential VM. Conflicts with `disk_encryption_set_id`. Changing this forces a new resource to be created.
               
               > **NOTE:** `secure_vm_disk_encryption_set_id` can only be specified when `security_type` is set to `ConfidentialVM_DiskEncryptedWithCustomerKey`.
        :param pulumi.Input[_builtins.str] security_type: Security Type of the Managed Disk when it is used for a Confidential VM. Possible values are `ConfidentialVM_VMGuestStateOnlyEncryptedWithPlatformKey`, `ConfidentialVM_DiskEncryptedWithPlatformKey` and `ConfidentialVM_DiskEncryptedWithCustomerKey`. Changing this forces a new resource to be created.
               
               > **NOTE:** When `security_type` is set to `ConfidentialVM_DiskEncryptedWithCustomerKey` the value of `create_option` must be one of `FromImage` or `ImportSecure`.
               
               
               > **NOTE:** `security_type` cannot be specified when `trusted_launch_enabled` is set to true.
               
               > **NOTE:** `secure_vm_disk_encryption_set_id` must be specified when `security_type` is set to `ConfidentialVM_DiskEncryptedWithCustomerKey`.
        :param pulumi.Input[_builtins.str] source_resource_id: The ID of an existing Managed Disk or Snapshot to copy when `create_option` is `Copy` or the recovery point to restore when `create_option` is `Restore`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_uri: URI to a valid VHD file to be used when `create_option` is `Import` or `ImportSecure`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account where the `source_uri` is located. Required when `create_option` is set to `Import` or `ImportSecure`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_account_type: The type of storage to use for the managed disk. Possible values are `Standard_LRS`, `StandardSSD_ZRS`, `Premium_LRS`, `PremiumV2_LRS`, `Premium_ZRS`, `StandardSSD_LRS` or `UltraSSD_LRS`.
               
               > **Note:** Azure Ultra Disk Storage is only available in a region that support availability zones and can only enabled on the following VM series: `ESv3`, `DSv3`, `FSv3`, `LSv2`, `M` and `Mv2`. For more information see the `Azure Ultra Disk Storage` [product documentation](https://docs.microsoft.com/azure/virtual-machines/windows/disks-enable-ultra-ssd).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.bool] trusted_launch_enabled: Specifies if Trusted Launch is enabled for the Managed Disk. Changing this forces a new resource to be created.
               
               > **Note:** Trusted Launch can only be enabled when `create_option` is `FromImage` or `Import`.
        :param pulumi.Input[_builtins.int] upload_size_bytes: Specifies the size of the managed disk to create in bytes. Required when `create_option` is `Upload`. The value must be equal to the source disk to be copied in bytes. Source disk size could be calculated with `ls -l` or `wc -c`. More information can be found at [Copy a managed disk](https://learn.microsoft.com/en-us/azure/virtual-machines/linux/disks-upload-vhd-to-managed-disk-cli#copy-a-managed-disk). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] zone: Specifies the Availability Zone in which this Managed Disk should be located. Changing this property forces a new resource to be created.
               
               > **Note:** Availability Zones are [only supported in select regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        if create_option is not None:
            pulumi.set(__self__, "create_option", create_option)
        if disk_access_id is not None:
            pulumi.set(__self__, "disk_access_id", disk_access_id)
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if disk_iops_read_only is not None:
            pulumi.set(__self__, "disk_iops_read_only", disk_iops_read_only)
        if disk_iops_read_write is not None:
            pulumi.set(__self__, "disk_iops_read_write", disk_iops_read_write)
        if disk_mbps_read_only is not None:
            pulumi.set(__self__, "disk_mbps_read_only", disk_mbps_read_only)
        if disk_mbps_read_write is not None:
            pulumi.set(__self__, "disk_mbps_read_write", disk_mbps_read_write)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if edge_zone is not None:
            pulumi.set(__self__, "edge_zone", edge_zone)
        if encryption_settings is not None:
            pulumi.set(__self__, "encryption_settings", encryption_settings)
        if gallery_image_reference_id is not None:
            pulumi.set(__self__, "gallery_image_reference_id", gallery_image_reference_id)
        if hyper_v_generation is not None:
            pulumi.set(__self__, "hyper_v_generation", hyper_v_generation)
        if image_reference_id is not None:
            pulumi.set(__self__, "image_reference_id", image_reference_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if logical_sector_size is not None:
            pulumi.set(__self__, "logical_sector_size", logical_sector_size)
        if max_shares is not None:
            pulumi.set(__self__, "max_shares", max_shares)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_access_policy is not None:
            pulumi.set(__self__, "network_access_policy", network_access_policy)
        if on_demand_bursting_enabled is not None:
            pulumi.set(__self__, "on_demand_bursting_enabled", on_demand_bursting_enabled)
        if optimized_frequent_attach_enabled is not None:
            pulumi.set(__self__, "optimized_frequent_attach_enabled", optimized_frequent_attach_enabled)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if performance_plus_enabled is not None:
            pulumi.set(__self__, "performance_plus_enabled", performance_plus_enabled)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if secure_vm_disk_encryption_set_id is not None:
            pulumi.set(__self__, "secure_vm_disk_encryption_set_id", secure_vm_disk_encryption_set_id)
        if security_type is not None:
            pulumi.set(__self__, "security_type", security_type)
        if source_resource_id is not None:
            pulumi.set(__self__, "source_resource_id", source_resource_id)
        if source_uri is not None:
            pulumi.set(__self__, "source_uri", source_uri)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)
        if trusted_launch_enabled is not None:
            pulumi.set(__self__, "trusted_launch_enabled", trusted_launch_enabled)
        if upload_size_bytes is not None:
            pulumi.set(__self__, "upload_size_bytes", upload_size_bytes)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="createOption")
    def create_option(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The method to use when creating the managed disk. Changing this forces a new resource to be created. Possible values include:
        * `Import` - Import a VHD file in to the managed disk (VHD specified with `source_uri`).
        * `ImportSecure` - Securely import a VHD file in to the managed disk (VHD specified with `source_uri`).
        * `Empty` - Create an empty managed disk.
        * `Copy` - Copy an existing managed disk or snapshot (specified with `source_resource_id`).
        * `FromImage` - Copy a Platform Image (specified with `image_reference_id`)
        * `Restore` - Set by Azure Backup or Site Recovery on a restored disk (specified with `source_resource_id`).
        * `Upload` - Upload a VHD disk with the help of SAS URL (to be used with `upload_size_bytes`).
        """
        return pulumi.get(self, "create_option")

    @create_option.setter
    def create_option(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_option", value)

    @_builtins.property
    @pulumi.getter(name="diskAccessId")
    def disk_access_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the disk access resource for using private endpoints on disks.

        > **Note:** `disk_access_id` is only supported when `network_access_policy` is set to `AllowPrivate`.
        """
        return pulumi.get(self, "disk_access_id")

    @disk_access_id.setter
    def disk_access_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_access_id", value)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of a Disk Encryption Set which should be used to encrypt this Managed Disk. Conflicts with `secure_vm_disk_encryption_set_id`.

        > **NOTE:** The Disk Encryption Set must have the `Reader` Role Assignment scoped on the Key Vault - in addition to an Access Policy to the Key Vault

        > **NOTE:** Disk Encryption Sets are in Public Preview in a limited set of regions
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @disk_encryption_set_id.setter
    def disk_encryption_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "disk_encryption_set_id", value)

    @_builtins.property
    @pulumi.getter(name="diskIopsReadOnly")
    def disk_iops_read_only(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of IOPS allowed across all VMs mounting the shared disk as read-only; only settable for UltraSSD disks and PremiumV2 disks with shared disk enabled. One operation can transfer between 4k and 256k bytes.
        """
        return pulumi.get(self, "disk_iops_read_only")

    @disk_iops_read_only.setter
    def disk_iops_read_only(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_iops_read_only", value)

    @_builtins.property
    @pulumi.getter(name="diskIopsReadWrite")
    def disk_iops_read_write(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of IOPS allowed for this disk; only settable for UltraSSD disks and PremiumV2 disks. One operation can transfer between 4k and 256k bytes.
        """
        return pulumi.get(self, "disk_iops_read_write")

    @disk_iops_read_write.setter
    def disk_iops_read_write(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_iops_read_write", value)

    @_builtins.property
    @pulumi.getter(name="diskMbpsReadOnly")
    def disk_mbps_read_only(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The bandwidth allowed across all VMs mounting the shared disk as read-only; only settable for UltraSSD disks and PremiumV2 disks with shared disk enabled. MBps means millions of bytes per second.
        """
        return pulumi.get(self, "disk_mbps_read_only")

    @disk_mbps_read_only.setter
    def disk_mbps_read_only(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_mbps_read_only", value)

    @_builtins.property
    @pulumi.getter(name="diskMbpsReadWrite")
    def disk_mbps_read_write(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The bandwidth allowed for this disk; only settable for UltraSSD disks and PremiumV2 disks. MBps means millions of bytes per second.
        """
        return pulumi.get(self, "disk_mbps_read_write")

    @disk_mbps_read_write.setter
    def disk_mbps_read_write(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_mbps_read_write", value)

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "disk_size_gb", value)

    @_builtins.property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Managed Disk should exist. Changing this forces a new Managed Disk to be created.
        """
        return pulumi.get(self, "edge_zone")

    @edge_zone.setter
    def edge_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edge_zone", value)

    @_builtins.property
    @pulumi.getter(name="encryptionSettings")
    def encryption_settings(self) -> Optional[pulumi.Input['ManagedDiskEncryptionSettingsArgs']]:
        """
        A `encryption_settings` block as defined below.

        > **NOTE:** Removing `encryption_settings` forces a new resource to be created.
        """
        return pulumi.get(self, "encryption_settings")

    @encryption_settings.setter
    def encryption_settings(self, value: Optional[pulumi.Input['ManagedDiskEncryptionSettingsArgs']]):
        pulumi.set(self, "encryption_settings", value)

    @_builtins.property
    @pulumi.getter(name="galleryImageReferenceId")
    def gallery_image_reference_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of a Gallery Image Version to copy when `create_option` is `FromImage`. This field cannot be specified if image_reference_id is specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "gallery_image_reference_id")

    @gallery_image_reference_id.setter
    def gallery_image_reference_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gallery_image_reference_id", value)

    @_builtins.property
    @pulumi.getter(name="hyperVGeneration")
    def hyper_v_generation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The HyperV Generation of the Disk when the source of an `Import` or `Copy` operation targets a source that contains an operating system. Possible values are `V1` and `V2`. For `ImportSecure` it must be set to `V2`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "hyper_v_generation")

    @hyper_v_generation.setter
    def hyper_v_generation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hyper_v_generation", value)

    @_builtins.property
    @pulumi.getter(name="imageReferenceId")
    def image_reference_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        ID of an existing platform/marketplace disk image to copy when `create_option` is `FromImage`. This field cannot be specified if gallery_image_reference_id is specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "image_reference_id")

    @image_reference_id.setter
    def image_reference_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_reference_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specified the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="logicalSectorSize")
    def logical_sector_size(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Logical Sector Size. Possible values are: `512` and `4096`. Defaults to `4096`. Changing this forces a new resource to be created.

        > **NOTE:** Setting logical sector size is supported only with `UltraSSD_LRS` disks and `PremiumV2_LRS` disks.
        """
        return pulumi.get(self, "logical_sector_size")

    @logical_sector_size.setter
    def logical_sector_size(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "logical_sector_size", value)

    @_builtins.property
    @pulumi.getter(name="maxShares")
    def max_shares(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of VMs that can attach to the disk at the same time. Value greater than one indicates a disk that can be mounted on multiple VMs at the same time.

        > **Note:** Premium SSD maxShares limit: `P15` and `P20` disks: 2. `P30`,`P40`,`P50` disks: 5. `P60`,`P70`,`P80` disks: 10. For ultra disks the `max_shares` minimum value is 1 and the maximum is 5.
        """
        return pulumi.get(self, "max_shares")

    @max_shares.setter
    def max_shares(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_shares", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Managed Disk. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkAccessPolicy")
    def network_access_policy(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Policy for accessing the disk via network. Allowed values are `AllowAll`, `AllowPrivate`, and `DenyAll`.
        """
        return pulumi.get(self, "network_access_policy")

    @network_access_policy.setter
    def network_access_policy(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_access_policy", value)

    @_builtins.property
    @pulumi.getter(name="onDemandBurstingEnabled")
    def on_demand_bursting_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if On-Demand Bursting is enabled for the Managed Disk.

        > **Note:** Credit-Based Bursting is enabled by default on all eligible disks. More information on [Credit-Based and On-Demand Bursting can be found in the documentation](https://docs.microsoft.com/azure/virtual-machines/disk-bursting#disk-level-bursting).
        """
        return pulumi.get(self, "on_demand_bursting_enabled")

    @on_demand_bursting_enabled.setter
    def on_demand_bursting_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "on_demand_bursting_enabled", value)

    @_builtins.property
    @pulumi.getter(name="optimizedFrequentAttachEnabled")
    def optimized_frequent_attach_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether this Managed Disk should be optimized for frequent disk attachments (where a disk is attached/detached more than 5 times in a day). Defaults to `false`.

        > **Note:** Setting `optimized_frequent_attach_enabled` to `true` causes the disks to not align with the fault domain of the Virtual Machine, which can have operational implications.
        """
        return pulumi.get(self, "optimized_frequent_attach_enabled")

    @optimized_frequent_attach_enabled.setter
    def optimized_frequent_attach_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "optimized_frequent_attach_enabled", value)

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specify a value when the source of an `Import`, `ImportSecure` or `Copy` operation targets a source that contains an operating system. Valid values are `Linux` or `Windows`.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_type", value)

    @_builtins.property
    @pulumi.getter(name="performancePlusEnabled")
    def performance_plus_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether Performance Plus is enabled for this Managed Disk. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "performance_plus_enabled")

    @performance_plus_enabled.setter
    def performance_plus_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "performance_plus_enabled", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether it is allowed to access the disk via public network. Defaults to `true`.

        For more information on managed disks, such as sizing options and pricing, please check out the [Azure Documentation](https://docs.microsoft.com/azure/storage/storage-managed-disks-overview).
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the Managed Disk should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="secureVmDiskEncryptionSetId")
    def secure_vm_disk_encryption_set_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Disk Encryption Set which should be used to Encrypt this OS Disk when the Virtual Machine is a Confidential VM. Conflicts with `disk_encryption_set_id`. Changing this forces a new resource to be created.

        > **NOTE:** `secure_vm_disk_encryption_set_id` can only be specified when `security_type` is set to `ConfidentialVM_DiskEncryptedWithCustomerKey`.
        """
        return pulumi.get(self, "secure_vm_disk_encryption_set_id")

    @secure_vm_disk_encryption_set_id.setter
    def secure_vm_disk_encryption_set_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secure_vm_disk_encryption_set_id", value)

    @_builtins.property
    @pulumi.getter(name="securityType")
    def security_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Security Type of the Managed Disk when it is used for a Confidential VM. Possible values are `ConfidentialVM_VMGuestStateOnlyEncryptedWithPlatformKey`, `ConfidentialVM_DiskEncryptedWithPlatformKey` and `ConfidentialVM_DiskEncryptedWithCustomerKey`. Changing this forces a new resource to be created.

        > **NOTE:** When `security_type` is set to `ConfidentialVM_DiskEncryptedWithCustomerKey` the value of `create_option` must be one of `FromImage` or `ImportSecure`.


        > **NOTE:** `security_type` cannot be specified when `trusted_launch_enabled` is set to true.

        > **NOTE:** `secure_vm_disk_encryption_set_id` must be specified when `security_type` is set to `ConfidentialVM_DiskEncryptedWithCustomerKey`.
        """
        return pulumi.get(self, "security_type")

    @security_type.setter
    def security_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "security_type", value)

    @_builtins.property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of an existing Managed Disk or Snapshot to copy when `create_option` is `Copy` or the recovery point to restore when `create_option` is `Restore`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_resource_id")

    @source_resource_id.setter
    def source_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="sourceUri")
    def source_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URI to a valid VHD file to be used when `create_option` is `Import` or `ImportSecure`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_uri")

    @source_uri.setter
    def source_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_uri", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Storage Account where the `source_uri` is located. Required when `create_option` is set to `Import` or `ImportSecure`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_id", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of storage to use for the managed disk. Possible values are `Standard_LRS`, `StandardSSD_ZRS`, `Premium_LRS`, `PremiumV2_LRS`, `Premium_ZRS`, `StandardSSD_LRS` or `UltraSSD_LRS`.

        > **Note:** Azure Ultra Disk Storage is only available in a region that support availability zones and can only enabled on the following VM series: `ESv3`, `DSv3`, `FSv3`, `LSv2`, `M` and `Mv2`. For more information see the `Azure Ultra Disk Storage` [product documentation](https://docs.microsoft.com/azure/virtual-machines/windows/disks-enable-ultra-ssd).
        """
        return pulumi.get(self, "storage_account_type")

    @storage_account_type.setter
    def storage_account_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def tier(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tier")

    @tier.setter
    def tier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tier", value)

    @_builtins.property
    @pulumi.getter(name="trustedLaunchEnabled")
    def trusted_launch_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if Trusted Launch is enabled for the Managed Disk. Changing this forces a new resource to be created.

        > **Note:** Trusted Launch can only be enabled when `create_option` is `FromImage` or `Import`.
        """
        return pulumi.get(self, "trusted_launch_enabled")

    @trusted_launch_enabled.setter
    def trusted_launch_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "trusted_launch_enabled", value)

    @_builtins.property
    @pulumi.getter(name="uploadSizeBytes")
    def upload_size_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Specifies the size of the managed disk to create in bytes. Required when `create_option` is `Upload`. The value must be equal to the source disk to be copied in bytes. Source disk size could be calculated with `ls -l` or `wc -c`. More information can be found at [Copy a managed disk](https://learn.microsoft.com/en-us/azure/virtual-machines/linux/disks-upload-vhd-to-managed-disk-cli#copy-a-managed-disk). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "upload_size_bytes")

    @upload_size_bytes.setter
    def upload_size_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "upload_size_bytes", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Availability Zone in which this Managed Disk should be located. Changing this property forces a new resource to be created.

        > **Note:** Availability Zones are [only supported in select regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("azure:compute/managedDisk:ManagedDisk")
class ManagedDisk(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 create_option: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_access_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_iops_read_only: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_iops_read_write: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_mbps_read_only: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_mbps_read_write: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_settings: Optional[pulumi.Input[Union['ManagedDiskEncryptionSettingsArgs', 'ManagedDiskEncryptionSettingsArgsDict']]] = None,
                 gallery_image_reference_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hyper_v_generation: Optional[pulumi.Input[_builtins.str]] = None,
                 image_reference_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logical_sector_size: Optional[pulumi.Input[_builtins.int]] = None,
                 max_shares: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_access_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 on_demand_bursting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 optimized_frequent_attach_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_plus_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secure_vm_disk_encryption_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[_builtins.str]] = None,
                 trusted_launch_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 upload_size_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a managed disk.

        ## Example Usage

        ### With Create Empty

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_managed_disk = azure.compute.ManagedDisk("example",
            name="acctestmd",
            location=example.location,
            resource_group_name=example.name,
            storage_account_type="Standard_LRS",
            create_option="Empty",
            disk_size_gb=1,
            tags={
                "environment": "staging",
            })
        ```

        ### With Create Copy

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        source = azure.compute.ManagedDisk("source",
            name="acctestmd1",
            location=example.location,
            resource_group_name=example.name,
            storage_account_type="Standard_LRS",
            create_option="Empty",
            disk_size_gb=1,
            tags={
                "environment": "staging",
            })
        copy = azure.compute.ManagedDisk("copy",
            name="acctestmd2",
            location=example.location,
            resource_group_name=example.name,
            storage_account_type="Standard_LRS",
            create_option="Copy",
            source_resource_id=source.id,
            disk_size_gb=1,
            tags={
                "environment": "staging",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute` - 2023-04-02

        ## Import

        Managed Disks can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/managedDisk:ManagedDisk example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Compute/disks/manageddisk1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_option: The method to use when creating the managed disk. Changing this forces a new resource to be created. Possible values include:
               * `Import` - Import a VHD file in to the managed disk (VHD specified with `source_uri`).
               * `ImportSecure` - Securely import a VHD file in to the managed disk (VHD specified with `source_uri`).
               * `Empty` - Create an empty managed disk.
               * `Copy` - Copy an existing managed disk or snapshot (specified with `source_resource_id`).
               * `FromImage` - Copy a Platform Image (specified with `image_reference_id`)
               * `Restore` - Set by Azure Backup or Site Recovery on a restored disk (specified with `source_resource_id`).
               * `Upload` - Upload a VHD disk with the help of SAS URL (to be used with `upload_size_bytes`).
        :param pulumi.Input[_builtins.str] disk_access_id: The ID of the disk access resource for using private endpoints on disks.
               
               > **Note:** `disk_access_id` is only supported when `network_access_policy` is set to `AllowPrivate`.
        :param pulumi.Input[_builtins.str] disk_encryption_set_id: The ID of a Disk Encryption Set which should be used to encrypt this Managed Disk. Conflicts with `secure_vm_disk_encryption_set_id`.
               
               > **NOTE:** The Disk Encryption Set must have the `Reader` Role Assignment scoped on the Key Vault - in addition to an Access Policy to the Key Vault
               
               > **NOTE:** Disk Encryption Sets are in Public Preview in a limited set of regions
        :param pulumi.Input[_builtins.int] disk_iops_read_only: The number of IOPS allowed across all VMs mounting the shared disk as read-only; only settable for UltraSSD disks and PremiumV2 disks with shared disk enabled. One operation can transfer between 4k and 256k bytes.
        :param pulumi.Input[_builtins.int] disk_iops_read_write: The number of IOPS allowed for this disk; only settable for UltraSSD disks and PremiumV2 disks. One operation can transfer between 4k and 256k bytes.
        :param pulumi.Input[_builtins.int] disk_mbps_read_only: The bandwidth allowed across all VMs mounting the shared disk as read-only; only settable for UltraSSD disks and PremiumV2 disks with shared disk enabled. MBps means millions of bytes per second.
        :param pulumi.Input[_builtins.int] disk_mbps_read_write: The bandwidth allowed for this disk; only settable for UltraSSD disks and PremiumV2 disks. MBps means millions of bytes per second.
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Managed Disk should exist. Changing this forces a new Managed Disk to be created.
        :param pulumi.Input[Union['ManagedDiskEncryptionSettingsArgs', 'ManagedDiskEncryptionSettingsArgsDict']] encryption_settings: A `encryption_settings` block as defined below.
               
               > **NOTE:** Removing `encryption_settings` forces a new resource to be created.
        :param pulumi.Input[_builtins.str] gallery_image_reference_id: ID of a Gallery Image Version to copy when `create_option` is `FromImage`. This field cannot be specified if image_reference_id is specified. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] hyper_v_generation: The HyperV Generation of the Disk when the source of an `Import` or `Copy` operation targets a source that contains an operating system. Possible values are `V1` and `V2`. For `ImportSecure` it must be set to `V2`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] image_reference_id: ID of an existing platform/marketplace disk image to copy when `create_option` is `FromImage`. This field cannot be specified if gallery_image_reference_id is specified. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specified the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] logical_sector_size: Logical Sector Size. Possible values are: `512` and `4096`. Defaults to `4096`. Changing this forces a new resource to be created.
               
               > **NOTE:** Setting logical sector size is supported only with `UltraSSD_LRS` disks and `PremiumV2_LRS` disks.
        :param pulumi.Input[_builtins.int] max_shares: The maximum number of VMs that can attach to the disk at the same time. Value greater than one indicates a disk that can be mounted on multiple VMs at the same time.
               
               > **Note:** Premium SSD maxShares limit: `P15` and `P20` disks: 2. `P30`,`P40`,`P50` disks: 5. `P60`,`P70`,`P80` disks: 10. For ultra disks the `max_shares` minimum value is 1 and the maximum is 5.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Managed Disk. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] network_access_policy: Policy for accessing the disk via network. Allowed values are `AllowAll`, `AllowPrivate`, and `DenyAll`.
        :param pulumi.Input[_builtins.bool] on_demand_bursting_enabled: Specifies if On-Demand Bursting is enabled for the Managed Disk.
               
               > **Note:** Credit-Based Bursting is enabled by default on all eligible disks. More information on [Credit-Based and On-Demand Bursting can be found in the documentation](https://docs.microsoft.com/azure/virtual-machines/disk-bursting#disk-level-bursting).
        :param pulumi.Input[_builtins.bool] optimized_frequent_attach_enabled: Specifies whether this Managed Disk should be optimized for frequent disk attachments (where a disk is attached/detached more than 5 times in a day). Defaults to `false`.
               
               > **Note:** Setting `optimized_frequent_attach_enabled` to `true` causes the disks to not align with the fault domain of the Virtual Machine, which can have operational implications.
        :param pulumi.Input[_builtins.str] os_type: Specify a value when the source of an `Import`, `ImportSecure` or `Copy` operation targets a source that contains an operating system. Valid values are `Linux` or `Windows`.
        :param pulumi.Input[_builtins.bool] performance_plus_enabled: Specifies whether Performance Plus is enabled for this Managed Disk. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether it is allowed to access the disk via public network. Defaults to `true`.
               
               For more information on managed disks, such as sizing options and pricing, please check out the [Azure Documentation](https://docs.microsoft.com/azure/storage/storage-managed-disks-overview).
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Managed Disk should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] secure_vm_disk_encryption_set_id: The ID of the Disk Encryption Set which should be used to Encrypt this OS Disk when the Virtual Machine is a Confidential VM. Conflicts with `disk_encryption_set_id`. Changing this forces a new resource to be created.
               
               > **NOTE:** `secure_vm_disk_encryption_set_id` can only be specified when `security_type` is set to `ConfidentialVM_DiskEncryptedWithCustomerKey`.
        :param pulumi.Input[_builtins.str] security_type: Security Type of the Managed Disk when it is used for a Confidential VM. Possible values are `ConfidentialVM_VMGuestStateOnlyEncryptedWithPlatformKey`, `ConfidentialVM_DiskEncryptedWithPlatformKey` and `ConfidentialVM_DiskEncryptedWithCustomerKey`. Changing this forces a new resource to be created.
               
               > **NOTE:** When `security_type` is set to `ConfidentialVM_DiskEncryptedWithCustomerKey` the value of `create_option` must be one of `FromImage` or `ImportSecure`.
               
               
               > **NOTE:** `security_type` cannot be specified when `trusted_launch_enabled` is set to true.
               
               > **NOTE:** `secure_vm_disk_encryption_set_id` must be specified when `security_type` is set to `ConfidentialVM_DiskEncryptedWithCustomerKey`.
        :param pulumi.Input[_builtins.str] source_resource_id: The ID of an existing Managed Disk or Snapshot to copy when `create_option` is `Copy` or the recovery point to restore when `create_option` is `Restore`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_uri: URI to a valid VHD file to be used when `create_option` is `Import` or `ImportSecure`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account where the `source_uri` is located. Required when `create_option` is set to `Import` or `ImportSecure`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_account_type: The type of storage to use for the managed disk. Possible values are `Standard_LRS`, `StandardSSD_ZRS`, `Premium_LRS`, `PremiumV2_LRS`, `Premium_ZRS`, `StandardSSD_LRS` or `UltraSSD_LRS`.
               
               > **Note:** Azure Ultra Disk Storage is only available in a region that support availability zones and can only enabled on the following VM series: `ESv3`, `DSv3`, `FSv3`, `LSv2`, `M` and `Mv2`. For more information see the `Azure Ultra Disk Storage` [product documentation](https://docs.microsoft.com/azure/virtual-machines/windows/disks-enable-ultra-ssd).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.bool] trusted_launch_enabled: Specifies if Trusted Launch is enabled for the Managed Disk. Changing this forces a new resource to be created.
               
               > **Note:** Trusted Launch can only be enabled when `create_option` is `FromImage` or `Import`.
        :param pulumi.Input[_builtins.int] upload_size_bytes: Specifies the size of the managed disk to create in bytes. Required when `create_option` is `Upload`. The value must be equal to the source disk to be copied in bytes. Source disk size could be calculated with `ls -l` or `wc -c`. More information can be found at [Copy a managed disk](https://learn.microsoft.com/en-us/azure/virtual-machines/linux/disks-upload-vhd-to-managed-disk-cli#copy-a-managed-disk). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] zone: Specifies the Availability Zone in which this Managed Disk should be located. Changing this property forces a new resource to be created.
               
               > **Note:** Availability Zones are [only supported in select regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagedDiskArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a managed disk.

        ## Example Usage

        ### With Create Empty

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_managed_disk = azure.compute.ManagedDisk("example",
            name="acctestmd",
            location=example.location,
            resource_group_name=example.name,
            storage_account_type="Standard_LRS",
            create_option="Empty",
            disk_size_gb=1,
            tags={
                "environment": "staging",
            })
        ```

        ### With Create Copy

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        source = azure.compute.ManagedDisk("source",
            name="acctestmd1",
            location=example.location,
            resource_group_name=example.name,
            storage_account_type="Standard_LRS",
            create_option="Empty",
            disk_size_gb=1,
            tags={
                "environment": "staging",
            })
        copy = azure.compute.ManagedDisk("copy",
            name="acctestmd2",
            location=example.location,
            resource_group_name=example.name,
            storage_account_type="Standard_LRS",
            create_option="Copy",
            source_resource_id=source.id,
            disk_size_gb=1,
            tags={
                "environment": "staging",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute` - 2023-04-02

        ## Import

        Managed Disks can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/managedDisk:ManagedDisk example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Compute/disks/manageddisk1
        ```

        :param str resource_name: The name of the resource.
        :param ManagedDiskArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagedDiskArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 create_option: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_access_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_encryption_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_iops_read_only: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_iops_read_write: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_mbps_read_only: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_mbps_read_write: Optional[pulumi.Input[_builtins.int]] = None,
                 disk_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption_settings: Optional[pulumi.Input[Union['ManagedDiskEncryptionSettingsArgs', 'ManagedDiskEncryptionSettingsArgsDict']]] = None,
                 gallery_image_reference_id: Optional[pulumi.Input[_builtins.str]] = None,
                 hyper_v_generation: Optional[pulumi.Input[_builtins.str]] = None,
                 image_reference_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 logical_sector_size: Optional[pulumi.Input[_builtins.int]] = None,
                 max_shares: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_access_policy: Optional[pulumi.Input[_builtins.str]] = None,
                 on_demand_bursting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 optimized_frequent_attach_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 performance_plus_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 secure_vm_disk_encryption_set_id: Optional[pulumi.Input[_builtins.str]] = None,
                 security_type: Optional[pulumi.Input[_builtins.str]] = None,
                 source_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 source_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 tier: Optional[pulumi.Input[_builtins.str]] = None,
                 trusted_launch_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 upload_size_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagedDiskArgs.__new__(ManagedDiskArgs)

            if create_option is None and not opts.urn:
                raise TypeError("Missing required property 'create_option'")
            __props__.__dict__["create_option"] = create_option
            __props__.__dict__["disk_access_id"] = disk_access_id
            __props__.__dict__["disk_encryption_set_id"] = disk_encryption_set_id
            __props__.__dict__["disk_iops_read_only"] = disk_iops_read_only
            __props__.__dict__["disk_iops_read_write"] = disk_iops_read_write
            __props__.__dict__["disk_mbps_read_only"] = disk_mbps_read_only
            __props__.__dict__["disk_mbps_read_write"] = disk_mbps_read_write
            __props__.__dict__["disk_size_gb"] = disk_size_gb
            __props__.__dict__["edge_zone"] = edge_zone
            __props__.__dict__["encryption_settings"] = encryption_settings
            __props__.__dict__["gallery_image_reference_id"] = gallery_image_reference_id
            __props__.__dict__["hyper_v_generation"] = hyper_v_generation
            __props__.__dict__["image_reference_id"] = image_reference_id
            __props__.__dict__["location"] = location
            __props__.__dict__["logical_sector_size"] = logical_sector_size
            __props__.__dict__["max_shares"] = max_shares
            __props__.__dict__["name"] = name
            __props__.__dict__["network_access_policy"] = network_access_policy
            __props__.__dict__["on_demand_bursting_enabled"] = on_demand_bursting_enabled
            __props__.__dict__["optimized_frequent_attach_enabled"] = optimized_frequent_attach_enabled
            __props__.__dict__["os_type"] = os_type
            __props__.__dict__["performance_plus_enabled"] = performance_plus_enabled
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["secure_vm_disk_encryption_set_id"] = secure_vm_disk_encryption_set_id
            __props__.__dict__["security_type"] = security_type
            __props__.__dict__["source_resource_id"] = source_resource_id
            __props__.__dict__["source_uri"] = source_uri
            __props__.__dict__["storage_account_id"] = storage_account_id
            if storage_account_type is None and not opts.urn:
                raise TypeError("Missing required property 'storage_account_type'")
            __props__.__dict__["storage_account_type"] = storage_account_type
            __props__.__dict__["tags"] = tags
            __props__.__dict__["tier"] = tier
            __props__.__dict__["trusted_launch_enabled"] = trusted_launch_enabled
            __props__.__dict__["upload_size_bytes"] = upload_size_bytes
            __props__.__dict__["zone"] = zone
        super(ManagedDisk, __self__).__init__(
            'azure:compute/managedDisk:ManagedDisk',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_option: Optional[pulumi.Input[_builtins.str]] = None,
            disk_access_id: Optional[pulumi.Input[_builtins.str]] = None,
            disk_encryption_set_id: Optional[pulumi.Input[_builtins.str]] = None,
            disk_iops_read_only: Optional[pulumi.Input[_builtins.int]] = None,
            disk_iops_read_write: Optional[pulumi.Input[_builtins.int]] = None,
            disk_mbps_read_only: Optional[pulumi.Input[_builtins.int]] = None,
            disk_mbps_read_write: Optional[pulumi.Input[_builtins.int]] = None,
            disk_size_gb: Optional[pulumi.Input[_builtins.int]] = None,
            edge_zone: Optional[pulumi.Input[_builtins.str]] = None,
            encryption_settings: Optional[pulumi.Input[Union['ManagedDiskEncryptionSettingsArgs', 'ManagedDiskEncryptionSettingsArgsDict']]] = None,
            gallery_image_reference_id: Optional[pulumi.Input[_builtins.str]] = None,
            hyper_v_generation: Optional[pulumi.Input[_builtins.str]] = None,
            image_reference_id: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            logical_sector_size: Optional[pulumi.Input[_builtins.int]] = None,
            max_shares: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_access_policy: Optional[pulumi.Input[_builtins.str]] = None,
            on_demand_bursting_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            optimized_frequent_attach_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            os_type: Optional[pulumi.Input[_builtins.str]] = None,
            performance_plus_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            secure_vm_disk_encryption_set_id: Optional[pulumi.Input[_builtins.str]] = None,
            security_type: Optional[pulumi.Input[_builtins.str]] = None,
            source_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            source_uri: Optional[pulumi.Input[_builtins.str]] = None,
            storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            storage_account_type: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            tier: Optional[pulumi.Input[_builtins.str]] = None,
            trusted_launch_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            upload_size_bytes: Optional[pulumi.Input[_builtins.int]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'ManagedDisk':
        """
        Get an existing ManagedDisk resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] create_option: The method to use when creating the managed disk. Changing this forces a new resource to be created. Possible values include:
               * `Import` - Import a VHD file in to the managed disk (VHD specified with `source_uri`).
               * `ImportSecure` - Securely import a VHD file in to the managed disk (VHD specified with `source_uri`).
               * `Empty` - Create an empty managed disk.
               * `Copy` - Copy an existing managed disk or snapshot (specified with `source_resource_id`).
               * `FromImage` - Copy a Platform Image (specified with `image_reference_id`)
               * `Restore` - Set by Azure Backup or Site Recovery on a restored disk (specified with `source_resource_id`).
               * `Upload` - Upload a VHD disk with the help of SAS URL (to be used with `upload_size_bytes`).
        :param pulumi.Input[_builtins.str] disk_access_id: The ID of the disk access resource for using private endpoints on disks.
               
               > **Note:** `disk_access_id` is only supported when `network_access_policy` is set to `AllowPrivate`.
        :param pulumi.Input[_builtins.str] disk_encryption_set_id: The ID of a Disk Encryption Set which should be used to encrypt this Managed Disk. Conflicts with `secure_vm_disk_encryption_set_id`.
               
               > **NOTE:** The Disk Encryption Set must have the `Reader` Role Assignment scoped on the Key Vault - in addition to an Access Policy to the Key Vault
               
               > **NOTE:** Disk Encryption Sets are in Public Preview in a limited set of regions
        :param pulumi.Input[_builtins.int] disk_iops_read_only: The number of IOPS allowed across all VMs mounting the shared disk as read-only; only settable for UltraSSD disks and PremiumV2 disks with shared disk enabled. One operation can transfer between 4k and 256k bytes.
        :param pulumi.Input[_builtins.int] disk_iops_read_write: The number of IOPS allowed for this disk; only settable for UltraSSD disks and PremiumV2 disks. One operation can transfer between 4k and 256k bytes.
        :param pulumi.Input[_builtins.int] disk_mbps_read_only: The bandwidth allowed across all VMs mounting the shared disk as read-only; only settable for UltraSSD disks and PremiumV2 disks with shared disk enabled. MBps means millions of bytes per second.
        :param pulumi.Input[_builtins.int] disk_mbps_read_write: The bandwidth allowed for this disk; only settable for UltraSSD disks and PremiumV2 disks. MBps means millions of bytes per second.
        :param pulumi.Input[_builtins.str] edge_zone: Specifies the Edge Zone within the Azure Region where this Managed Disk should exist. Changing this forces a new Managed Disk to be created.
        :param pulumi.Input[Union['ManagedDiskEncryptionSettingsArgs', 'ManagedDiskEncryptionSettingsArgsDict']] encryption_settings: A `encryption_settings` block as defined below.
               
               > **NOTE:** Removing `encryption_settings` forces a new resource to be created.
        :param pulumi.Input[_builtins.str] gallery_image_reference_id: ID of a Gallery Image Version to copy when `create_option` is `FromImage`. This field cannot be specified if image_reference_id is specified. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] hyper_v_generation: The HyperV Generation of the Disk when the source of an `Import` or `Copy` operation targets a source that contains an operating system. Possible values are `V1` and `V2`. For `ImportSecure` it must be set to `V2`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] image_reference_id: ID of an existing platform/marketplace disk image to copy when `create_option` is `FromImage`. This field cannot be specified if gallery_image_reference_id is specified. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specified the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] logical_sector_size: Logical Sector Size. Possible values are: `512` and `4096`. Defaults to `4096`. Changing this forces a new resource to be created.
               
               > **NOTE:** Setting logical sector size is supported only with `UltraSSD_LRS` disks and `PremiumV2_LRS` disks.
        :param pulumi.Input[_builtins.int] max_shares: The maximum number of VMs that can attach to the disk at the same time. Value greater than one indicates a disk that can be mounted on multiple VMs at the same time.
               
               > **Note:** Premium SSD maxShares limit: `P15` and `P20` disks: 2. `P30`,`P40`,`P50` disks: 5. `P60`,`P70`,`P80` disks: 10. For ultra disks the `max_shares` minimum value is 1 and the maximum is 5.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Managed Disk. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] network_access_policy: Policy for accessing the disk via network. Allowed values are `AllowAll`, `AllowPrivate`, and `DenyAll`.
        :param pulumi.Input[_builtins.bool] on_demand_bursting_enabled: Specifies if On-Demand Bursting is enabled for the Managed Disk.
               
               > **Note:** Credit-Based Bursting is enabled by default on all eligible disks. More information on [Credit-Based and On-Demand Bursting can be found in the documentation](https://docs.microsoft.com/azure/virtual-machines/disk-bursting#disk-level-bursting).
        :param pulumi.Input[_builtins.bool] optimized_frequent_attach_enabled: Specifies whether this Managed Disk should be optimized for frequent disk attachments (where a disk is attached/detached more than 5 times in a day). Defaults to `false`.
               
               > **Note:** Setting `optimized_frequent_attach_enabled` to `true` causes the disks to not align with the fault domain of the Virtual Machine, which can have operational implications.
        :param pulumi.Input[_builtins.str] os_type: Specify a value when the source of an `Import`, `ImportSecure` or `Copy` operation targets a source that contains an operating system. Valid values are `Linux` or `Windows`.
        :param pulumi.Input[_builtins.bool] performance_plus_enabled: Specifies whether Performance Plus is enabled for this Managed Disk. Defaults to `false`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Whether it is allowed to access the disk via public network. Defaults to `true`.
               
               For more information on managed disks, such as sizing options and pricing, please check out the [Azure Documentation](https://docs.microsoft.com/azure/storage/storage-managed-disks-overview).
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the Managed Disk should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] secure_vm_disk_encryption_set_id: The ID of the Disk Encryption Set which should be used to Encrypt this OS Disk when the Virtual Machine is a Confidential VM. Conflicts with `disk_encryption_set_id`. Changing this forces a new resource to be created.
               
               > **NOTE:** `secure_vm_disk_encryption_set_id` can only be specified when `security_type` is set to `ConfidentialVM_DiskEncryptedWithCustomerKey`.
        :param pulumi.Input[_builtins.str] security_type: Security Type of the Managed Disk when it is used for a Confidential VM. Possible values are `ConfidentialVM_VMGuestStateOnlyEncryptedWithPlatformKey`, `ConfidentialVM_DiskEncryptedWithPlatformKey` and `ConfidentialVM_DiskEncryptedWithCustomerKey`. Changing this forces a new resource to be created.
               
               > **NOTE:** When `security_type` is set to `ConfidentialVM_DiskEncryptedWithCustomerKey` the value of `create_option` must be one of `FromImage` or `ImportSecure`.
               
               
               > **NOTE:** `security_type` cannot be specified when `trusted_launch_enabled` is set to true.
               
               > **NOTE:** `secure_vm_disk_encryption_set_id` must be specified when `security_type` is set to `ConfidentialVM_DiskEncryptedWithCustomerKey`.
        :param pulumi.Input[_builtins.str] source_resource_id: The ID of an existing Managed Disk or Snapshot to copy when `create_option` is `Copy` or the recovery point to restore when `create_option` is `Restore`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] source_uri: URI to a valid VHD file to be used when `create_option` is `Import` or `ImportSecure`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account where the `source_uri` is located. Required when `create_option` is set to `Import` or `ImportSecure`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_account_type: The type of storage to use for the managed disk. Possible values are `Standard_LRS`, `StandardSSD_ZRS`, `Premium_LRS`, `PremiumV2_LRS`, `Premium_ZRS`, `StandardSSD_LRS` or `UltraSSD_LRS`.
               
               > **Note:** Azure Ultra Disk Storage is only available in a region that support availability zones and can only enabled on the following VM series: `ESv3`, `DSv3`, `FSv3`, `LSv2`, `M` and `Mv2`. For more information see the `Azure Ultra Disk Storage` [product documentation](https://docs.microsoft.com/azure/virtual-machines/windows/disks-enable-ultra-ssd).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.bool] trusted_launch_enabled: Specifies if Trusted Launch is enabled for the Managed Disk. Changing this forces a new resource to be created.
               
               > **Note:** Trusted Launch can only be enabled when `create_option` is `FromImage` or `Import`.
        :param pulumi.Input[_builtins.int] upload_size_bytes: Specifies the size of the managed disk to create in bytes. Required when `create_option` is `Upload`. The value must be equal to the source disk to be copied in bytes. Source disk size could be calculated with `ls -l` or `wc -c`. More information can be found at [Copy a managed disk](https://learn.microsoft.com/en-us/azure/virtual-machines/linux/disks-upload-vhd-to-managed-disk-cli#copy-a-managed-disk). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] zone: Specifies the Availability Zone in which this Managed Disk should be located. Changing this property forces a new resource to be created.
               
               > **Note:** Availability Zones are [only supported in select regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagedDiskState.__new__(_ManagedDiskState)

        __props__.__dict__["create_option"] = create_option
        __props__.__dict__["disk_access_id"] = disk_access_id
        __props__.__dict__["disk_encryption_set_id"] = disk_encryption_set_id
        __props__.__dict__["disk_iops_read_only"] = disk_iops_read_only
        __props__.__dict__["disk_iops_read_write"] = disk_iops_read_write
        __props__.__dict__["disk_mbps_read_only"] = disk_mbps_read_only
        __props__.__dict__["disk_mbps_read_write"] = disk_mbps_read_write
        __props__.__dict__["disk_size_gb"] = disk_size_gb
        __props__.__dict__["edge_zone"] = edge_zone
        __props__.__dict__["encryption_settings"] = encryption_settings
        __props__.__dict__["gallery_image_reference_id"] = gallery_image_reference_id
        __props__.__dict__["hyper_v_generation"] = hyper_v_generation
        __props__.__dict__["image_reference_id"] = image_reference_id
        __props__.__dict__["location"] = location
        __props__.__dict__["logical_sector_size"] = logical_sector_size
        __props__.__dict__["max_shares"] = max_shares
        __props__.__dict__["name"] = name
        __props__.__dict__["network_access_policy"] = network_access_policy
        __props__.__dict__["on_demand_bursting_enabled"] = on_demand_bursting_enabled
        __props__.__dict__["optimized_frequent_attach_enabled"] = optimized_frequent_attach_enabled
        __props__.__dict__["os_type"] = os_type
        __props__.__dict__["performance_plus_enabled"] = performance_plus_enabled
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["secure_vm_disk_encryption_set_id"] = secure_vm_disk_encryption_set_id
        __props__.__dict__["security_type"] = security_type
        __props__.__dict__["source_resource_id"] = source_resource_id
        __props__.__dict__["source_uri"] = source_uri
        __props__.__dict__["storage_account_id"] = storage_account_id
        __props__.__dict__["storage_account_type"] = storage_account_type
        __props__.__dict__["tags"] = tags
        __props__.__dict__["tier"] = tier
        __props__.__dict__["trusted_launch_enabled"] = trusted_launch_enabled
        __props__.__dict__["upload_size_bytes"] = upload_size_bytes
        __props__.__dict__["zone"] = zone
        return ManagedDisk(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="createOption")
    def create_option(self) -> pulumi.Output[_builtins.str]:
        """
        The method to use when creating the managed disk. Changing this forces a new resource to be created. Possible values include:
        * `Import` - Import a VHD file in to the managed disk (VHD specified with `source_uri`).
        * `ImportSecure` - Securely import a VHD file in to the managed disk (VHD specified with `source_uri`).
        * `Empty` - Create an empty managed disk.
        * `Copy` - Copy an existing managed disk or snapshot (specified with `source_resource_id`).
        * `FromImage` - Copy a Platform Image (specified with `image_reference_id`)
        * `Restore` - Set by Azure Backup or Site Recovery on a restored disk (specified with `source_resource_id`).
        * `Upload` - Upload a VHD disk with the help of SAS URL (to be used with `upload_size_bytes`).
        """
        return pulumi.get(self, "create_option")

    @_builtins.property
    @pulumi.getter(name="diskAccessId")
    def disk_access_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the disk access resource for using private endpoints on disks.

        > **Note:** `disk_access_id` is only supported when `network_access_policy` is set to `AllowPrivate`.
        """
        return pulumi.get(self, "disk_access_id")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of a Disk Encryption Set which should be used to encrypt this Managed Disk. Conflicts with `secure_vm_disk_encryption_set_id`.

        > **NOTE:** The Disk Encryption Set must have the `Reader` Role Assignment scoped on the Key Vault - in addition to an Access Policy to the Key Vault

        > **NOTE:** Disk Encryption Sets are in Public Preview in a limited set of regions
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @_builtins.property
    @pulumi.getter(name="diskIopsReadOnly")
    def disk_iops_read_only(self) -> pulumi.Output[_builtins.int]:
        """
        The number of IOPS allowed across all VMs mounting the shared disk as read-only; only settable for UltraSSD disks and PremiumV2 disks with shared disk enabled. One operation can transfer between 4k and 256k bytes.
        """
        return pulumi.get(self, "disk_iops_read_only")

    @_builtins.property
    @pulumi.getter(name="diskIopsReadWrite")
    def disk_iops_read_write(self) -> pulumi.Output[_builtins.int]:
        """
        The number of IOPS allowed for this disk; only settable for UltraSSD disks and PremiumV2 disks. One operation can transfer between 4k and 256k bytes.
        """
        return pulumi.get(self, "disk_iops_read_write")

    @_builtins.property
    @pulumi.getter(name="diskMbpsReadOnly")
    def disk_mbps_read_only(self) -> pulumi.Output[_builtins.int]:
        """
        The bandwidth allowed across all VMs mounting the shared disk as read-only; only settable for UltraSSD disks and PremiumV2 disks with shared disk enabled. MBps means millions of bytes per second.
        """
        return pulumi.get(self, "disk_mbps_read_only")

    @_builtins.property
    @pulumi.getter(name="diskMbpsReadWrite")
    def disk_mbps_read_write(self) -> pulumi.Output[_builtins.int]:
        """
        The bandwidth allowed for this disk; only settable for UltraSSD disks and PremiumV2 disks. MBps means millions of bytes per second.
        """
        return pulumi.get(self, "disk_mbps_read_write")

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="edgeZone")
    def edge_zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Edge Zone within the Azure Region where this Managed Disk should exist. Changing this forces a new Managed Disk to be created.
        """
        return pulumi.get(self, "edge_zone")

    @_builtins.property
    @pulumi.getter(name="encryptionSettings")
    def encryption_settings(self) -> pulumi.Output[Optional['outputs.ManagedDiskEncryptionSettings']]:
        """
        A `encryption_settings` block as defined below.

        > **NOTE:** Removing `encryption_settings` forces a new resource to be created.
        """
        return pulumi.get(self, "encryption_settings")

    @_builtins.property
    @pulumi.getter(name="galleryImageReferenceId")
    def gallery_image_reference_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of a Gallery Image Version to copy when `create_option` is `FromImage`. This field cannot be specified if image_reference_id is specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "gallery_image_reference_id")

    @_builtins.property
    @pulumi.getter(name="hyperVGeneration")
    def hyper_v_generation(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The HyperV Generation of the Disk when the source of an `Import` or `Copy` operation targets a source that contains an operating system. Possible values are `V1` and `V2`. For `ImportSecure` it must be set to `V2`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "hyper_v_generation")

    @_builtins.property
    @pulumi.getter(name="imageReferenceId")
    def image_reference_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        ID of an existing platform/marketplace disk image to copy when `create_option` is `FromImage`. This field cannot be specified if gallery_image_reference_id is specified. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "image_reference_id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specified the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="logicalSectorSize")
    def logical_sector_size(self) -> pulumi.Output[_builtins.int]:
        """
        Logical Sector Size. Possible values are: `512` and `4096`. Defaults to `4096`. Changing this forces a new resource to be created.

        > **NOTE:** Setting logical sector size is supported only with `UltraSSD_LRS` disks and `PremiumV2_LRS` disks.
        """
        return pulumi.get(self, "logical_sector_size")

    @_builtins.property
    @pulumi.getter(name="maxShares")
    def max_shares(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum number of VMs that can attach to the disk at the same time. Value greater than one indicates a disk that can be mounted on multiple VMs at the same time.

        > **Note:** Premium SSD maxShares limit: `P15` and `P20` disks: 2. `P30`,`P40`,`P50` disks: 5. `P60`,`P70`,`P80` disks: 10. For ultra disks the `max_shares` minimum value is 1 and the maximum is 5.
        """
        return pulumi.get(self, "max_shares")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Managed Disk. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkAccessPolicy")
    def network_access_policy(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Policy for accessing the disk via network. Allowed values are `AllowAll`, `AllowPrivate`, and `DenyAll`.
        """
        return pulumi.get(self, "network_access_policy")

    @_builtins.property
    @pulumi.getter(name="onDemandBurstingEnabled")
    def on_demand_bursting_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if On-Demand Bursting is enabled for the Managed Disk.

        > **Note:** Credit-Based Bursting is enabled by default on all eligible disks. More information on [Credit-Based and On-Demand Bursting can be found in the documentation](https://docs.microsoft.com/azure/virtual-machines/disk-bursting#disk-level-bursting).
        """
        return pulumi.get(self, "on_demand_bursting_enabled")

    @_builtins.property
    @pulumi.getter(name="optimizedFrequentAttachEnabled")
    def optimized_frequent_attach_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether this Managed Disk should be optimized for frequent disk attachments (where a disk is attached/detached more than 5 times in a day). Defaults to `false`.

        > **Note:** Setting `optimized_frequent_attach_enabled` to `true` causes the disks to not align with the fault domain of the Virtual Machine, which can have operational implications.
        """
        return pulumi.get(self, "optimized_frequent_attach_enabled")

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specify a value when the source of an `Import`, `ImportSecure` or `Copy` operation targets a source that contains an operating system. Valid values are `Linux` or `Windows`.
        """
        return pulumi.get(self, "os_type")

    @_builtins.property
    @pulumi.getter(name="performancePlusEnabled")
    def performance_plus_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether Performance Plus is enabled for this Managed Disk. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "performance_plus_enabled")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether it is allowed to access the disk via public network. Defaults to `true`.

        For more information on managed disks, such as sizing options and pricing, please check out the [Azure Documentation](https://docs.microsoft.com/azure/storage/storage-managed-disks-overview).
        """
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the Managed Disk should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="secureVmDiskEncryptionSetId")
    def secure_vm_disk_encryption_set_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Disk Encryption Set which should be used to Encrypt this OS Disk when the Virtual Machine is a Confidential VM. Conflicts with `disk_encryption_set_id`. Changing this forces a new resource to be created.

        > **NOTE:** `secure_vm_disk_encryption_set_id` can only be specified when `security_type` is set to `ConfidentialVM_DiskEncryptedWithCustomerKey`.
        """
        return pulumi.get(self, "secure_vm_disk_encryption_set_id")

    @_builtins.property
    @pulumi.getter(name="securityType")
    def security_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Security Type of the Managed Disk when it is used for a Confidential VM. Possible values are `ConfidentialVM_VMGuestStateOnlyEncryptedWithPlatformKey`, `ConfidentialVM_DiskEncryptedWithPlatformKey` and `ConfidentialVM_DiskEncryptedWithCustomerKey`. Changing this forces a new resource to be created.

        > **NOTE:** When `security_type` is set to `ConfidentialVM_DiskEncryptedWithCustomerKey` the value of `create_option` must be one of `FromImage` or `ImportSecure`.


        > **NOTE:** `security_type` cannot be specified when `trusted_launch_enabled` is set to true.

        > **NOTE:** `secure_vm_disk_encryption_set_id` must be specified when `security_type` is set to `ConfidentialVM_DiskEncryptedWithCustomerKey`.
        """
        return pulumi.get(self, "security_type")

    @_builtins.property
    @pulumi.getter(name="sourceResourceId")
    def source_resource_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of an existing Managed Disk or Snapshot to copy when `create_option` is `Copy` or the recovery point to restore when `create_option` is `Restore`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_resource_id")

    @_builtins.property
    @pulumi.getter(name="sourceUri")
    def source_uri(self) -> pulumi.Output[_builtins.str]:
        """
        URI to a valid VHD file to be used when `create_option` is `Import` or `ImportSecure`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "source_uri")

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Storage Account where the `source_uri` is located. Required when `create_option` is set to `Import` or `ImportSecure`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_id")

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of storage to use for the managed disk. Possible values are `Standard_LRS`, `StandardSSD_ZRS`, `Premium_LRS`, `PremiumV2_LRS`, `Premium_ZRS`, `StandardSSD_LRS` or `UltraSSD_LRS`.

        > **Note:** Azure Ultra Disk Storage is only available in a region that support availability zones and can only enabled on the following VM series: `ESv3`, `DSv3`, `FSv3`, `LSv2`, `M` and `Mv2`. For more information see the `Azure Ultra Disk Storage` [product documentation](https://docs.microsoft.com/azure/virtual-machines/windows/disks-enable-ultra-ssd).
        """
        return pulumi.get(self, "storage_account_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def tier(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "tier")

    @_builtins.property
    @pulumi.getter(name="trustedLaunchEnabled")
    def trusted_launch_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if Trusted Launch is enabled for the Managed Disk. Changing this forces a new resource to be created.

        > **Note:** Trusted Launch can only be enabled when `create_option` is `FromImage` or `Import`.
        """
        return pulumi.get(self, "trusted_launch_enabled")

    @_builtins.property
    @pulumi.getter(name="uploadSizeBytes")
    def upload_size_bytes(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Specifies the size of the managed disk to create in bytes. Required when `create_option` is `Upload`. The value must be equal to the source disk to be copied in bytes. Source disk size could be calculated with `ls -l` or `wc -c`. More information can be found at [Copy a managed disk](https://learn.microsoft.com/en-us/azure/virtual-machines/linux/disks-upload-vhd-to-managed-disk-cli#copy-a-managed-disk). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "upload_size_bytes")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies the Availability Zone in which this Managed Disk should be located. Changing this property forces a new resource to be created.

        > **Note:** Availability Zones are [only supported in select regions at this time](https://docs.microsoft.com/azure/availability-zones/az-overview).
        """
        return pulumi.get(self, "zone")

