# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BastionHostIpConfiguration',
    'CapacityReservationSku',
    'DiskEncryptionSetIdentity',
    'ExtensionProtectedSettingsFromKeyVault',
    'GalleryApplicationVersionManageAction',
    'GalleryApplicationVersionSource',
    'GalleryApplicationVersionTargetRegion',
    'ImageDataDisk',
    'ImageOsDisk',
    'LinuxVirtualMachineAdditionalCapabilities',
    'LinuxVirtualMachineAdminSshKey',
    'LinuxVirtualMachineBootDiagnostics',
    'LinuxVirtualMachineGalleryApplication',
    'LinuxVirtualMachineIdentity',
    'LinuxVirtualMachineOsDisk',
    'LinuxVirtualMachineOsDiskDiffDiskSettings',
    'LinuxVirtualMachineOsImageNotification',
    'LinuxVirtualMachinePlan',
    'LinuxVirtualMachineScaleSetAdditionalCapabilities',
    'LinuxVirtualMachineScaleSetAdminSshKey',
    'LinuxVirtualMachineScaleSetAutomaticInstanceRepair',
    'LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicy',
    'LinuxVirtualMachineScaleSetBootDiagnostics',
    'LinuxVirtualMachineScaleSetDataDisk',
    'LinuxVirtualMachineScaleSetExtension',
    'LinuxVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault',
    'LinuxVirtualMachineScaleSetGalleryApplication',
    'LinuxVirtualMachineScaleSetIdentity',
    'LinuxVirtualMachineScaleSetNetworkInterface',
    'LinuxVirtualMachineScaleSetNetworkInterfaceIpConfiguration',
    'LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress',
    'LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag',
    'LinuxVirtualMachineScaleSetOsDisk',
    'LinuxVirtualMachineScaleSetOsDiskDiffDiskSettings',
    'LinuxVirtualMachineScaleSetPlan',
    'LinuxVirtualMachineScaleSetRollingUpgradePolicy',
    'LinuxVirtualMachineScaleSetScaleIn',
    'LinuxVirtualMachineScaleSetSecret',
    'LinuxVirtualMachineScaleSetSecretCertificate',
    'LinuxVirtualMachineScaleSetSourceImageReference',
    'LinuxVirtualMachineScaleSetSpotRestore',
    'LinuxVirtualMachineScaleSetTerminationNotification',
    'LinuxVirtualMachineSecret',
    'LinuxVirtualMachineSecretCertificate',
    'LinuxVirtualMachineSourceImageReference',
    'LinuxVirtualMachineTerminationNotification',
    'ManagedDiskEncryptionSettings',
    'ManagedDiskEncryptionSettingsDiskEncryptionKey',
    'ManagedDiskEncryptionSettingsKeyEncryptionKey',
    'OrchestratedVirtualMachineScaleSetAdditionalCapabilities',
    'OrchestratedVirtualMachineScaleSetAutomaticInstanceRepair',
    'OrchestratedVirtualMachineScaleSetBootDiagnostics',
    'OrchestratedVirtualMachineScaleSetDataDisk',
    'OrchestratedVirtualMachineScaleSetExtension',
    'OrchestratedVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault',
    'OrchestratedVirtualMachineScaleSetIdentity',
    'OrchestratedVirtualMachineScaleSetNetworkInterface',
    'OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfiguration',
    'OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress',
    'OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag',
    'OrchestratedVirtualMachineScaleSetOsDisk',
    'OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettings',
    'OrchestratedVirtualMachineScaleSetOsProfile',
    'OrchestratedVirtualMachineScaleSetOsProfileLinuxConfiguration',
    'OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKey',
    'OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecret',
    'OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretCertificate',
    'OrchestratedVirtualMachineScaleSetOsProfileWindowsConfiguration',
    'OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationAdditionalUnattendContent',
    'OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecret',
    'OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretCertificate',
    'OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListener',
    'OrchestratedVirtualMachineScaleSetPlan',
    'OrchestratedVirtualMachineScaleSetPriorityMix',
    'OrchestratedVirtualMachineScaleSetRollingUpgradePolicy',
    'OrchestratedVirtualMachineScaleSetSkuProfile',
    'OrchestratedVirtualMachineScaleSetSourceImageReference',
    'OrchestratedVirtualMachineScaleSetTerminationNotification',
    'PacketCaptureFilter',
    'PacketCaptureStorageLocation',
    'RunCommandErrorBlobManagedIdentity',
    'RunCommandInstanceView',
    'RunCommandOutputBlobManagedIdentity',
    'RunCommandParameter',
    'RunCommandProtectedParameter',
    'RunCommandSource',
    'RunCommandSourceScriptUriManagedIdentity',
    'ScaleSetBootDiagnostics',
    'ScaleSetExtension',
    'ScaleSetIdentity',
    'ScaleSetNetworkProfile',
    'ScaleSetNetworkProfileDnsSettings',
    'ScaleSetNetworkProfileIpConfiguration',
    'ScaleSetNetworkProfileIpConfigurationPublicIpAddressConfiguration',
    'ScaleSetOsProfile',
    'ScaleSetOsProfileLinuxConfig',
    'ScaleSetOsProfileLinuxConfigSshKey',
    'ScaleSetOsProfileSecret',
    'ScaleSetOsProfileSecretVaultCertificate',
    'ScaleSetOsProfileWindowsConfig',
    'ScaleSetOsProfileWindowsConfigAdditionalUnattendConfig',
    'ScaleSetOsProfileWindowsConfigWinrm',
    'ScaleSetPacketCaptureFilter',
    'ScaleSetPacketCaptureMachineScope',
    'ScaleSetPacketCaptureStorageLocation',
    'ScaleSetPlan',
    'ScaleSetRollingUpgradePolicy',
    'ScaleSetSku',
    'ScaleSetStandbyPoolElasticityProfile',
    'ScaleSetStorageProfileDataDisk',
    'ScaleSetStorageProfileImageReference',
    'ScaleSetStorageProfileOsDisk',
    'SharedImageGallerySharing',
    'SharedImageGallerySharingCommunityGallery',
    'SharedImageIdentifier',
    'SharedImagePurchasePlan',
    'SharedImageVersionTargetRegion',
    'SnapshotEncryptionSettings',
    'SnapshotEncryptionSettingsDiskEncryptionKey',
    'SnapshotEncryptionSettingsKeyEncryptionKey',
    'VirtualMachineAdditionalCapabilities',
    'VirtualMachineBootDiagnostics',
    'VirtualMachineIdentity',
    'VirtualMachineOsProfile',
    'VirtualMachineOsProfileLinuxConfig',
    'VirtualMachineOsProfileLinuxConfigSshKey',
    'VirtualMachineOsProfileSecret',
    'VirtualMachineOsProfileSecretVaultCertificate',
    'VirtualMachineOsProfileWindowsConfig',
    'VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfig',
    'VirtualMachineOsProfileWindowsConfigWinrm',
    'VirtualMachinePlan',
    'VirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault',
    'VirtualMachineStorageDataDisk',
    'VirtualMachineStorageImageReference',
    'VirtualMachineStorageOsDisk',
    'WindowsVirtualMachineAdditionalCapabilities',
    'WindowsVirtualMachineAdditionalUnattendContent',
    'WindowsVirtualMachineBootDiagnostics',
    'WindowsVirtualMachineGalleryApplication',
    'WindowsVirtualMachineIdentity',
    'WindowsVirtualMachineOsDisk',
    'WindowsVirtualMachineOsDiskDiffDiskSettings',
    'WindowsVirtualMachineOsImageNotification',
    'WindowsVirtualMachinePlan',
    'WindowsVirtualMachineScaleSetAdditionalCapabilities',
    'WindowsVirtualMachineScaleSetAdditionalUnattendContent',
    'WindowsVirtualMachineScaleSetAutomaticInstanceRepair',
    'WindowsVirtualMachineScaleSetAutomaticOsUpgradePolicy',
    'WindowsVirtualMachineScaleSetBootDiagnostics',
    'WindowsVirtualMachineScaleSetDataDisk',
    'WindowsVirtualMachineScaleSetExtension',
    'WindowsVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault',
    'WindowsVirtualMachineScaleSetGalleryApplication',
    'WindowsVirtualMachineScaleSetIdentity',
    'WindowsVirtualMachineScaleSetNetworkInterface',
    'WindowsVirtualMachineScaleSetNetworkInterfaceIpConfiguration',
    'WindowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress',
    'WindowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag',
    'WindowsVirtualMachineScaleSetOsDisk',
    'WindowsVirtualMachineScaleSetOsDiskDiffDiskSettings',
    'WindowsVirtualMachineScaleSetPlan',
    'WindowsVirtualMachineScaleSetRollingUpgradePolicy',
    'WindowsVirtualMachineScaleSetScaleIn',
    'WindowsVirtualMachineScaleSetSecret',
    'WindowsVirtualMachineScaleSetSecretCertificate',
    'WindowsVirtualMachineScaleSetSourceImageReference',
    'WindowsVirtualMachineScaleSetSpotRestore',
    'WindowsVirtualMachineScaleSetTerminationNotification',
    'WindowsVirtualMachineScaleSetWinrmListener',
    'WindowsVirtualMachineSecret',
    'WindowsVirtualMachineSecretCertificate',
    'WindowsVirtualMachineSourceImageReference',
    'WindowsVirtualMachineTerminationNotification',
    'WindowsVirtualMachineWinrmListener',
    'GetBastionHostIpConfigurationResult',
    'GetConfidentialLedgerAzureadBasedServicePrincipalResult',
    'GetConfidentialLedgerCertificateBasedSecurityPrincipalResult',
    'GetDiskEncryptionSetIdentityResult',
    'GetImageDataDiskResult',
    'GetImageOsDiskResult',
    'GetImagesImageResult',
    'GetImagesImageDataDiskResult',
    'GetImagesImageOsDiskResult',
    'GetManagedDiskEncryptionSettingResult',
    'GetManagedDiskEncryptionSettingDiskEncryptionKeyResult',
    'GetManagedDiskEncryptionSettingKeyEncryptionKeyResult',
    'GetOrchestratedVirtualMachineScaleSetIdentityResult',
    'GetOrchestratedVirtualMachineScaleSetNetworkInterfaceResult',
    'GetOrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationResult',
    'GetOrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressResult',
    'GetOrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagResult',
    'GetSharedImageIdentifierResult',
    'GetSharedImagePurchasePlanResult',
    'GetSharedImageVersionTargetRegionResult',
    'GetSharedImageVersionsImageResult',
    'GetSharedImageVersionsImageTargetRegionResult',
    'GetSnapshotEncryptionSettingResult',
    'GetSnapshotEncryptionSettingDiskEncryptionKeyResult',
    'GetSnapshotEncryptionSettingKeyEncryptionKeyResult',
    'GetVirtualMachineIdentityResult',
    'GetVirtualMachineScaleSetIdentityResult',
    'GetVirtualMachineScaleSetInstanceResult',
    'GetVirtualMachineScaleSetNetworkInterfaceResult',
    'GetVirtualMachineScaleSetNetworkInterfaceIpConfigurationResult',
    'GetVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressResult',
    'GetVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagResult',
]

@pulumi.output_type
class BastionHostIpConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicIpAddressId":
            suggest = "public_ip_address_id"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BastionHostIpConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BastionHostIpConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BastionHostIpConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 public_ip_address_id: _builtins.str,
                 subnet_id: _builtins.str):
        """
        :param _builtins.str name: The name of the IP configuration. Changing this forces a new resource to be created.
        :param _builtins.str public_ip_address_id: Reference to a Public IP Address to associate with this Bastion Host. Changing this forces a new resource to be created.
        :param _builtins.str subnet_id: Reference to a subnet in which this Bastion Host has been created. Changing this forces a new resource to be created.
               
               > **Note:** The Subnet used for the Bastion Host must have the name `AzureBastionSubnet` and the subnet mask must be at least a `/26`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "public_ip_address_id", public_ip_address_id)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the IP configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="publicIpAddressId")
    def public_ip_address_id(self) -> _builtins.str:
        """
        Reference to a Public IP Address to associate with this Bastion Host. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "public_ip_address_id")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        Reference to a subnet in which this Bastion Host has been created. Changing this forces a new resource to be created.

        > **Note:** The Subnet used for the Bastion Host must have the name `AzureBastionSubnet` and the subnet mask must be at least a `/26`.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class CapacityReservationSku(dict):
    def __init__(__self__, *,
                 capacity: _builtins.int,
                 name: _builtins.str):
        """
        :param _builtins.int capacity: Specifies the number of instances to be reserved. It must be greater than or equal to `0` and not exceed the quota in the subscription.
        :param _builtins.str name: Name of the sku, such as `Standard_F2`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> _builtins.int:
        """
        Specifies the number of instances to be reserved. It must be greater than or equal to `0` and not exceed the quota in the subscription.
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of the sku, such as `Standard_F2`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DiskEncryptionSetIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskEncryptionSetIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskEncryptionSetIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskEncryptionSetIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: The type of Managed Service Identity that is configured on this Disk Encryption Set. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        :param Sequence[_builtins.str] identity_ids: A list of User Assigned Managed Identity IDs to be assigned to this Disk Encryption Set.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param _builtins.str principal_id: The (Client) ID of the Service Principal.
        :param _builtins.str tenant_id: The ID of the Tenant the Service Principal is assigned in.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of Managed Service Identity that is configured on this Disk Encryption Set. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of User Assigned Managed Identity IDs to be assigned to this Disk Encryption Set.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The (Client) ID of the Service Principal.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Tenant the Service Principal is assigned in.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ExtensionProtectedSettingsFromKeyVault(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretUrl":
            suggest = "secret_url"
        elif key == "sourceVaultId":
            suggest = "source_vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExtensionProtectedSettingsFromKeyVault. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExtensionProtectedSettingsFromKeyVault.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExtensionProtectedSettingsFromKeyVault.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_url: _builtins.str,
                 source_vault_id: _builtins.str):
        """
        :param _builtins.str secret_url: The URL to the Key Vault Secret which stores the protected settings.
        :param _builtins.str source_vault_id: The ID of the source Key Vault.
        """
        pulumi.set(__self__, "secret_url", secret_url)
        pulumi.set(__self__, "source_vault_id", source_vault_id)

    @_builtins.property
    @pulumi.getter(name="secretUrl")
    def secret_url(self) -> _builtins.str:
        """
        The URL to the Key Vault Secret which stores the protected settings.
        """
        return pulumi.get(self, "secret_url")

    @_builtins.property
    @pulumi.getter(name="sourceVaultId")
    def source_vault_id(self) -> _builtins.str:
        """
        The ID of the source Key Vault.
        """
        return pulumi.get(self, "source_vault_id")


@pulumi.output_type
class GalleryApplicationVersionManageAction(dict):
    def __init__(__self__, *,
                 install: _builtins.str,
                 remove: _builtins.str,
                 update: Optional[_builtins.str] = None):
        """
        :param _builtins.str install: The command to install the Gallery Application. Changing this forces a new resource to be created.
        :param _builtins.str remove: The command to remove the Gallery Application. Changing this forces a new resource to be created.
        :param _builtins.str update: The command to update the Gallery Application. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "install", install)
        pulumi.set(__self__, "remove", remove)
        if update is not None:
            pulumi.set(__self__, "update", update)

    @_builtins.property
    @pulumi.getter
    def install(self) -> _builtins.str:
        """
        The command to install the Gallery Application. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "install")

    @_builtins.property
    @pulumi.getter
    def remove(self) -> _builtins.str:
        """
        The command to remove the Gallery Application. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "remove")

    @_builtins.property
    @pulumi.getter
    def update(self) -> Optional[_builtins.str]:
        """
        The command to update the Gallery Application. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "update")


@pulumi.output_type
class GalleryApplicationVersionSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mediaLink":
            suggest = "media_link"
        elif key == "defaultConfigurationLink":
            suggest = "default_configuration_link"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GalleryApplicationVersionSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GalleryApplicationVersionSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GalleryApplicationVersionSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 media_link: _builtins.str,
                 default_configuration_link: Optional[_builtins.str] = None):
        """
        :param _builtins.str media_link: The Storage Blob URI of the source application package. Changing this forces a new resource to be created.
        :param _builtins.str default_configuration_link: The Storage Blob URI of the default configuration. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "media_link", media_link)
        if default_configuration_link is not None:
            pulumi.set(__self__, "default_configuration_link", default_configuration_link)

    @_builtins.property
    @pulumi.getter(name="mediaLink")
    def media_link(self) -> _builtins.str:
        """
        The Storage Blob URI of the source application package. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "media_link")

    @_builtins.property
    @pulumi.getter(name="defaultConfigurationLink")
    def default_configuration_link(self) -> Optional[_builtins.str]:
        """
        The Storage Blob URI of the default configuration. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "default_configuration_link")


@pulumi.output_type
class GalleryApplicationVersionTargetRegion(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "regionalReplicaCount":
            suggest = "regional_replica_count"
        elif key == "excludeFromLatest":
            suggest = "exclude_from_latest"
        elif key == "storageAccountType":
            suggest = "storage_account_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GalleryApplicationVersionTargetRegion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GalleryApplicationVersionTargetRegion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GalleryApplicationVersionTargetRegion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 regional_replica_count: _builtins.int,
                 exclude_from_latest: Optional[_builtins.bool] = None,
                 storage_account_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The Azure Region in which the Gallery Application Version exists.
        :param _builtins.int regional_replica_count: The number of replicas of the Gallery Application Version to be created per region. Possible values are between `1` and `10`.
        :param _builtins.bool exclude_from_latest: Specifies whether this Gallery Application Version should be excluded from the `latest` filter. If set to `true`, this Gallery Application Version won't be returned for the `latest` version. Defaults to `false`.
        :param _builtins.str storage_account_type: The storage account type for the Gallery Application Version. Possible values are `Standard_LRS`, `Premium_LRS` and `Standard_ZRS`. Defaults to `Standard_LRS`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "regional_replica_count", regional_replica_count)
        if exclude_from_latest is not None:
            pulumi.set(__self__, "exclude_from_latest", exclude_from_latest)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The Azure Region in which the Gallery Application Version exists.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="regionalReplicaCount")
    def regional_replica_count(self) -> _builtins.int:
        """
        The number of replicas of the Gallery Application Version to be created per region. Possible values are between `1` and `10`.
        """
        return pulumi.get(self, "regional_replica_count")

    @_builtins.property
    @pulumi.getter(name="excludeFromLatest")
    def exclude_from_latest(self) -> Optional[_builtins.bool]:
        """
        Specifies whether this Gallery Application Version should be excluded from the `latest` filter. If set to `true`, this Gallery Application Version won't be returned for the `latest` version. Defaults to `false`.
        """
        return pulumi.get(self, "exclude_from_latest")

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[_builtins.str]:
        """
        The storage account type for the Gallery Application Version. Possible values are `Standard_LRS`, `Premium_LRS` and `Standard_ZRS`. Defaults to `Standard_LRS`.
        """
        return pulumi.get(self, "storage_account_type")


@pulumi.output_type
class ImageDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageType":
            suggest = "storage_type"
        elif key == "blobUri":
            suggest = "blob_uri"
        elif key == "diskEncryptionSetId":
            suggest = "disk_encryption_set_id"
        elif key == "managedDiskId":
            suggest = "managed_disk_id"
        elif key == "sizeGb":
            suggest = "size_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_type: _builtins.str,
                 blob_uri: Optional[_builtins.str] = None,
                 caching: Optional[_builtins.str] = None,
                 disk_encryption_set_id: Optional[_builtins.str] = None,
                 lun: Optional[_builtins.int] = None,
                 managed_disk_id: Optional[_builtins.str] = None,
                 size_gb: Optional[_builtins.int] = None):
        """
        :param _builtins.str storage_type: The type of Storage Disk to use. Possible values are `Premium_LRS`, `PremiumV2_LRS`, `Premium_ZRS`, `Standard_LRS`, `StandardSSD_LRS`, `StandardSSD_ZRS` and `UltraSSD_LRS`. Changing this forces a new resource to be created.
        :param _builtins.str blob_uri: Specifies the URI in Azure storage of the blob that you want to use to create the image.
        :param _builtins.str caching: Specifies the caching mode as `ReadWrite`, `ReadOnly`, or `None`. Defaults to `None`.
        :param _builtins.str disk_encryption_set_id: The ID of the Disk Encryption Set which should be used to encrypt this disk. Changing this forces a new resource to be created.
        :param _builtins.int lun: Specifies the logical unit number of the data disk.
        :param _builtins.str managed_disk_id: Specifies the ID of the managed disk resource that you want to use to create the image. Changing this forces a new resource to be created.
        :param _builtins.int size_gb: Specifies the size of the image to be created. The target size can't be smaller than the source size.
        """
        pulumi.set(__self__, "storage_type", storage_type)
        if blob_uri is not None:
            pulumi.set(__self__, "blob_uri", blob_uri)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if lun is not None:
            pulumi.set(__self__, "lun", lun)
        if managed_disk_id is not None:
            pulumi.set(__self__, "managed_disk_id", managed_disk_id)
        if size_gb is not None:
            pulumi.set(__self__, "size_gb", size_gb)

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> _builtins.str:
        """
        The type of Storage Disk to use. Possible values are `Premium_LRS`, `PremiumV2_LRS`, `Premium_ZRS`, `Standard_LRS`, `StandardSSD_LRS`, `StandardSSD_ZRS` and `UltraSSD_LRS`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_type")

    @_builtins.property
    @pulumi.getter(name="blobUri")
    def blob_uri(self) -> Optional[_builtins.str]:
        """
        Specifies the URI in Azure storage of the blob that you want to use to create the image.
        """
        return pulumi.get(self, "blob_uri")

    @_builtins.property
    @pulumi.getter
    def caching(self) -> Optional[_builtins.str]:
        """
        Specifies the caching mode as `ReadWrite`, `ReadOnly`, or `None`. Defaults to `None`.
        """
        return pulumi.get(self, "caching")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Disk Encryption Set which should be used to encrypt this disk. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @_builtins.property
    @pulumi.getter
    def lun(self) -> Optional[_builtins.int]:
        """
        Specifies the logical unit number of the data disk.
        """
        return pulumi.get(self, "lun")

    @_builtins.property
    @pulumi.getter(name="managedDiskId")
    def managed_disk_id(self) -> Optional[_builtins.str]:
        """
        Specifies the ID of the managed disk resource that you want to use to create the image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_disk_id")

    @_builtins.property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> Optional[_builtins.int]:
        """
        Specifies the size of the image to be created. The target size can't be smaller than the source size.
        """
        return pulumi.get(self, "size_gb")


@pulumi.output_type
class ImageOsDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageType":
            suggest = "storage_type"
        elif key == "blobUri":
            suggest = "blob_uri"
        elif key == "diskEncryptionSetId":
            suggest = "disk_encryption_set_id"
        elif key == "managedDiskId":
            suggest = "managed_disk_id"
        elif key == "osState":
            suggest = "os_state"
        elif key == "osType":
            suggest = "os_type"
        elif key == "sizeGb":
            suggest = "size_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ImageOsDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ImageOsDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ImageOsDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_type: _builtins.str,
                 blob_uri: Optional[_builtins.str] = None,
                 caching: Optional[_builtins.str] = None,
                 disk_encryption_set_id: Optional[_builtins.str] = None,
                 managed_disk_id: Optional[_builtins.str] = None,
                 os_state: Optional[_builtins.str] = None,
                 os_type: Optional[_builtins.str] = None,
                 size_gb: Optional[_builtins.int] = None):
        """
        :param _builtins.str storage_type: The type of Storage Disk to use. Possible values are `Premium_LRS`, `PremiumV2_LRS`, `Premium_ZRS`, `Standard_LRS`, `StandardSSD_LRS`, `StandardSSD_ZRS` and `UltraSSD_LRS`. Changing this forces a new resource to be created.
        :param _builtins.str blob_uri: Specifies the URI in Azure storage of the blob that you want to use to create the image. Changing this forces a new resource to be created.
        :param _builtins.str caching: Specifies the caching mode as `ReadWrite`, `ReadOnly`, or `None`. The default is `None`.
        :param _builtins.str disk_encryption_set_id: The ID of the Disk Encryption Set which should be used to encrypt this disk. Changing this forces a new resource to be created.
        :param _builtins.str managed_disk_id: Specifies the ID of the managed disk resource that you want to use to create the image.
        :param _builtins.str os_state: Specifies the state of the operating system contained in the blob. Currently, the only value is Generalized. Possible values are `Generalized` and `Specialized`.
        :param _builtins.str os_type: Specifies the type of operating system contained in the virtual machine image. Possible values are: `Windows` or `Linux`.
        :param _builtins.int size_gb: Specifies the size of the image to be created. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "storage_type", storage_type)
        if blob_uri is not None:
            pulumi.set(__self__, "blob_uri", blob_uri)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if managed_disk_id is not None:
            pulumi.set(__self__, "managed_disk_id", managed_disk_id)
        if os_state is not None:
            pulumi.set(__self__, "os_state", os_state)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if size_gb is not None:
            pulumi.set(__self__, "size_gb", size_gb)

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> _builtins.str:
        """
        The type of Storage Disk to use. Possible values are `Premium_LRS`, `PremiumV2_LRS`, `Premium_ZRS`, `Standard_LRS`, `StandardSSD_LRS`, `StandardSSD_ZRS` and `UltraSSD_LRS`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_type")

    @_builtins.property
    @pulumi.getter(name="blobUri")
    def blob_uri(self) -> Optional[_builtins.str]:
        """
        Specifies the URI in Azure storage of the blob that you want to use to create the image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "blob_uri")

    @_builtins.property
    @pulumi.getter
    def caching(self) -> Optional[_builtins.str]:
        """
        Specifies the caching mode as `ReadWrite`, `ReadOnly`, or `None`. The default is `None`.
        """
        return pulumi.get(self, "caching")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Disk Encryption Set which should be used to encrypt this disk. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @_builtins.property
    @pulumi.getter(name="managedDiskId")
    def managed_disk_id(self) -> Optional[_builtins.str]:
        """
        Specifies the ID of the managed disk resource that you want to use to create the image.
        """
        return pulumi.get(self, "managed_disk_id")

    @_builtins.property
    @pulumi.getter(name="osState")
    def os_state(self) -> Optional[_builtins.str]:
        """
        Specifies the state of the operating system contained in the blob. Currently, the only value is Generalized. Possible values are `Generalized` and `Specialized`.
        """
        return pulumi.get(self, "os_state")

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[_builtins.str]:
        """
        Specifies the type of operating system contained in the virtual machine image. Possible values are: `Windows` or `Linux`.
        """
        return pulumi.get(self, "os_type")

    @_builtins.property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> Optional[_builtins.int]:
        """
        Specifies the size of the image to be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "size_gb")


@pulumi.output_type
class LinuxVirtualMachineAdditionalCapabilities(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hibernationEnabled":
            suggest = "hibernation_enabled"
        elif key == "ultraSsdEnabled":
            suggest = "ultra_ssd_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxVirtualMachineAdditionalCapabilities. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxVirtualMachineAdditionalCapabilities.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxVirtualMachineAdditionalCapabilities.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hibernation_enabled: Optional[_builtins.bool] = None,
                 ultra_ssd_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool hibernation_enabled: Whether to enable the hibernation capability or not.
        :param _builtins.bool ultra_ssd_enabled: Should the capacity to enable Data Disks of the `UltraSSD_LRS` storage account type be supported on this Virtual Machine? Defaults to `false`.
        """
        if hibernation_enabled is not None:
            pulumi.set(__self__, "hibernation_enabled", hibernation_enabled)
        if ultra_ssd_enabled is not None:
            pulumi.set(__self__, "ultra_ssd_enabled", ultra_ssd_enabled)

    @_builtins.property
    @pulumi.getter(name="hibernationEnabled")
    def hibernation_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable the hibernation capability or not.
        """
        return pulumi.get(self, "hibernation_enabled")

    @_builtins.property
    @pulumi.getter(name="ultraSsdEnabled")
    def ultra_ssd_enabled(self) -> Optional[_builtins.bool]:
        """
        Should the capacity to enable Data Disks of the `UltraSSD_LRS` storage account type be supported on this Virtual Machine? Defaults to `false`.
        """
        return pulumi.get(self, "ultra_ssd_enabled")


@pulumi.output_type
class LinuxVirtualMachineAdminSshKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKey":
            suggest = "public_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxVirtualMachineAdminSshKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxVirtualMachineAdminSshKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxVirtualMachineAdminSshKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_key: _builtins.str,
                 username: _builtins.str):
        """
        :param _builtins.str public_key: The Public Key which should be used for authentication, which needs to be in `ssh-rsa` format with at least 2048-bit or in `ssh-ed25519` format. Changing this forces a new resource to be created.
        :param _builtins.str username: The Username for which this Public SSH Key should be configured. Changing this forces a new resource to be created.
               
               > **NOTE:** The Azure VM Agent only allows creating SSH Keys at the path `/home/{username}/.ssh/authorized_keys` - as such this public key will be written to the authorized keys file.
        """
        pulumi.set(__self__, "public_key", public_key)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> _builtins.str:
        """
        The Public Key which should be used for authentication, which needs to be in `ssh-rsa` format with at least 2048-bit or in `ssh-ed25519` format. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The Username for which this Public SSH Key should be configured. Changing this forces a new resource to be created.

        > **NOTE:** The Azure VM Agent only allows creating SSH Keys at the path `/home/{username}/.ssh/authorized_keys` - as such this public key will be written to the authorized keys file.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class LinuxVirtualMachineBootDiagnostics(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageAccountUri":
            suggest = "storage_account_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxVirtualMachineBootDiagnostics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxVirtualMachineBootDiagnostics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxVirtualMachineBootDiagnostics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_account_uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str storage_account_uri: The Primary/Secondary Endpoint for the Azure Storage Account which should be used to store Boot Diagnostics, including Console Output and Screenshots from the Hypervisor.
               
               > **NOTE:** Passing a null value will utilize a Managed Storage Account to store Boot Diagnostics
        """
        if storage_account_uri is not None:
            pulumi.set(__self__, "storage_account_uri", storage_account_uri)

    @_builtins.property
    @pulumi.getter(name="storageAccountUri")
    def storage_account_uri(self) -> Optional[_builtins.str]:
        """
        The Primary/Secondary Endpoint for the Azure Storage Account which should be used to store Boot Diagnostics, including Console Output and Screenshots from the Hypervisor.

        > **NOTE:** Passing a null value will utilize a Managed Storage Account to store Boot Diagnostics
        """
        return pulumi.get(self, "storage_account_uri")


@pulumi.output_type
class LinuxVirtualMachineGalleryApplication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "versionId":
            suggest = "version_id"
        elif key == "automaticUpgradeEnabled":
            suggest = "automatic_upgrade_enabled"
        elif key == "configurationBlobUri":
            suggest = "configuration_blob_uri"
        elif key == "treatFailureAsDeploymentFailureEnabled":
            suggest = "treat_failure_as_deployment_failure_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxVirtualMachineGalleryApplication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxVirtualMachineGalleryApplication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxVirtualMachineGalleryApplication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 version_id: _builtins.str,
                 automatic_upgrade_enabled: Optional[_builtins.bool] = None,
                 configuration_blob_uri: Optional[_builtins.str] = None,
                 order: Optional[_builtins.int] = None,
                 tag: Optional[_builtins.str] = None,
                 treat_failure_as_deployment_failure_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str version_id: Specifies the Gallery Application Version resource ID.
        :param _builtins.bool automatic_upgrade_enabled: Specifies whether the version will be automatically updated for the VM when a new Gallery Application version is available in PIR/SIG. Defaults to `false`.
        :param _builtins.str configuration_blob_uri: Specifies the URI to an Azure Blob that will replace the default configuration for the package if provided.
        :param _builtins.int order: Specifies the order in which the packages have to be installed. Possible values are between `0` and `2147483647`. Defaults to `0`.
        :param _builtins.str tag: Specifies a passthrough value for more generic context. This field can be any valid `string` value.
        :param _builtins.bool treat_failure_as_deployment_failure_enabled: Specifies whether any failure for any operation in the VmApplication will fail the deployment of the VM. Defaults to `false`.
        """
        pulumi.set(__self__, "version_id", version_id)
        if automatic_upgrade_enabled is not None:
            pulumi.set(__self__, "automatic_upgrade_enabled", automatic_upgrade_enabled)
        if configuration_blob_uri is not None:
            pulumi.set(__self__, "configuration_blob_uri", configuration_blob_uri)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if treat_failure_as_deployment_failure_enabled is not None:
            pulumi.set(__self__, "treat_failure_as_deployment_failure_enabled", treat_failure_as_deployment_failure_enabled)

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> _builtins.str:
        """
        Specifies the Gallery Application Version resource ID.
        """
        return pulumi.get(self, "version_id")

    @_builtins.property
    @pulumi.getter(name="automaticUpgradeEnabled")
    def automatic_upgrade_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether the version will be automatically updated for the VM when a new Gallery Application version is available in PIR/SIG. Defaults to `false`.
        """
        return pulumi.get(self, "automatic_upgrade_enabled")

    @_builtins.property
    @pulumi.getter(name="configurationBlobUri")
    def configuration_blob_uri(self) -> Optional[_builtins.str]:
        """
        Specifies the URI to an Azure Blob that will replace the default configuration for the package if provided.
        """
        return pulumi.get(self, "configuration_blob_uri")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.int]:
        """
        Specifies the order in which the packages have to be installed. Possible values are between `0` and `2147483647`. Defaults to `0`.
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[_builtins.str]:
        """
        Specifies a passthrough value for more generic context. This field can be any valid `string` value.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter(name="treatFailureAsDeploymentFailureEnabled")
    def treat_failure_as_deployment_failure_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether any failure for any operation in the VmApplication will fail the deployment of the VM. Defaults to `false`.
        """
        return pulumi.get(self, "treat_failure_as_deployment_failure_enabled")


@pulumi.output_type
class LinuxVirtualMachineIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxVirtualMachineIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxVirtualMachineIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxVirtualMachineIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Linux Virtual Machine. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        :param Sequence[_builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Linux Virtual Machine.
               
               > **NOTE:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param _builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param _builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Linux Virtual Machine. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Linux Virtual Machine.

        > **NOTE:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class LinuxVirtualMachineOsDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageAccountType":
            suggest = "storage_account_type"
        elif key == "diffDiskSettings":
            suggest = "diff_disk_settings"
        elif key == "diskEncryptionSetId":
            suggest = "disk_encryption_set_id"
        elif key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "secureVmDiskEncryptionSetId":
            suggest = "secure_vm_disk_encryption_set_id"
        elif key == "securityEncryptionType":
            suggest = "security_encryption_type"
        elif key == "writeAcceleratorEnabled":
            suggest = "write_accelerator_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxVirtualMachineOsDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxVirtualMachineOsDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxVirtualMachineOsDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 caching: _builtins.str,
                 storage_account_type: _builtins.str,
                 diff_disk_settings: Optional['outputs.LinuxVirtualMachineOsDiskDiffDiskSettings'] = None,
                 disk_encryption_set_id: Optional[_builtins.str] = None,
                 disk_size_gb: Optional[_builtins.int] = None,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 secure_vm_disk_encryption_set_id: Optional[_builtins.str] = None,
                 security_encryption_type: Optional[_builtins.str] = None,
                 write_accelerator_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str caching: The Type of Caching which should be used for the Internal OS Disk. Possible values are `None`, `ReadOnly` and `ReadWrite`.
        :param _builtins.str storage_account_type: The Type of Storage Account which should back this the Internal OS Disk. Possible values are `Standard_LRS`, `StandardSSD_LRS`, `Premium_LRS`, `StandardSSD_ZRS` and `Premium_ZRS`. Changing this forces a new resource to be created.
        :param 'LinuxVirtualMachineOsDiskDiffDiskSettingsArgs' diff_disk_settings: A `diff_disk_settings` block as defined above. Changing this forces a new resource to be created.
               
               > **NOTE:** `diff_disk_settings` can only be set when `caching` is set to `ReadOnly`. More information can be found [here](https://docs.microsoft.com/azure/virtual-machines/ephemeral-os-disks-deploy#vm-template-deployment)
        :param _builtins.str disk_encryption_set_id: The ID of the Disk Encryption Set which should be used to Encrypt this OS Disk. Conflicts with `secure_vm_disk_encryption_set_id`.
               
               > **NOTE:** The Disk Encryption Set must have the `Reader` Role Assignment scoped on the Key Vault - in addition to an Access Policy to the Key Vault
        :param _builtins.int disk_size_gb: The Size of the Internal OS Disk in GB, if you wish to vary from the size used in the image this Virtual Machine is sourced from.
               
               > **NOTE:** If specified this must be equal to or larger than the size of the Image the Virtual Machine is based on. When creating a larger disk than exists in the image you'll need to repartition the disk to use the remaining space.
        :param _builtins.str id: The ID of the OS disk.
        :param _builtins.str name: The name which should be used for the Internal OS Disk. Changing this forces a new resource to be created.
        :param _builtins.str secure_vm_disk_encryption_set_id: The ID of the Disk Encryption Set which should be used to Encrypt this OS Disk when the Virtual Machine is a Confidential VM. Conflicts with `disk_encryption_set_id`. Changing this forces a new resource to be created.
               
               > **NOTE:** `secure_vm_disk_encryption_set_id` can only be specified when `security_encryption_type` is set to `DiskWithVMGuestState`.
        :param _builtins.str security_encryption_type: Encryption Type when the Virtual Machine is a Confidential VM. Possible values are `VMGuestStateOnly` and `DiskWithVMGuestState`. Changing this forces a new resource to be created.
               
               > **NOTE:** `vtpm_enabled` must be set to `true` when `security_encryption_type` is specified.
               
               > **NOTE:** `encryption_at_host_enabled` cannot be set to `true` when `security_encryption_type` is set to `DiskWithVMGuestState`.
        :param _builtins.bool write_accelerator_enabled: Should Write Accelerator be Enabled for this OS Disk? Defaults to `false`.
               
               > **NOTE:** This requires that the `storage_account_type` is set to `Premium_LRS` and that `caching` is set to `None`.
        """
        pulumi.set(__self__, "caching", caching)
        pulumi.set(__self__, "storage_account_type", storage_account_type)
        if diff_disk_settings is not None:
            pulumi.set(__self__, "diff_disk_settings", diff_disk_settings)
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secure_vm_disk_encryption_set_id is not None:
            pulumi.set(__self__, "secure_vm_disk_encryption_set_id", secure_vm_disk_encryption_set_id)
        if security_encryption_type is not None:
            pulumi.set(__self__, "security_encryption_type", security_encryption_type)
        if write_accelerator_enabled is not None:
            pulumi.set(__self__, "write_accelerator_enabled", write_accelerator_enabled)

    @_builtins.property
    @pulumi.getter
    def caching(self) -> _builtins.str:
        """
        The Type of Caching which should be used for the Internal OS Disk. Possible values are `None`, `ReadOnly` and `ReadWrite`.
        """
        return pulumi.get(self, "caching")

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> _builtins.str:
        """
        The Type of Storage Account which should back this the Internal OS Disk. Possible values are `Standard_LRS`, `StandardSSD_LRS`, `Premium_LRS`, `StandardSSD_ZRS` and `Premium_ZRS`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_type")

    @_builtins.property
    @pulumi.getter(name="diffDiskSettings")
    def diff_disk_settings(self) -> Optional['outputs.LinuxVirtualMachineOsDiskDiffDiskSettings']:
        """
        A `diff_disk_settings` block as defined above. Changing this forces a new resource to be created.

        > **NOTE:** `diff_disk_settings` can only be set when `caching` is set to `ReadOnly`. More information can be found [here](https://docs.microsoft.com/azure/virtual-machines/ephemeral-os-disks-deploy#vm-template-deployment)
        """
        return pulumi.get(self, "diff_disk_settings")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Disk Encryption Set which should be used to Encrypt this OS Disk. Conflicts with `secure_vm_disk_encryption_set_id`.

        > **NOTE:** The Disk Encryption Set must have the `Reader` Role Assignment scoped on the Key Vault - in addition to an Access Policy to the Key Vault
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[_builtins.int]:
        """
        The Size of the Internal OS Disk in GB, if you wish to vary from the size used in the image this Virtual Machine is sourced from.

        > **NOTE:** If specified this must be equal to or larger than the size of the Image the Virtual Machine is based on. When creating a larger disk than exists in the image you'll need to repartition the disk to use the remaining space.
        """
        return pulumi.get(self, "disk_size_gb")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the OS disk.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name which should be used for the Internal OS Disk. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="secureVmDiskEncryptionSetId")
    def secure_vm_disk_encryption_set_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Disk Encryption Set which should be used to Encrypt this OS Disk when the Virtual Machine is a Confidential VM. Conflicts with `disk_encryption_set_id`. Changing this forces a new resource to be created.

        > **NOTE:** `secure_vm_disk_encryption_set_id` can only be specified when `security_encryption_type` is set to `DiskWithVMGuestState`.
        """
        return pulumi.get(self, "secure_vm_disk_encryption_set_id")

    @_builtins.property
    @pulumi.getter(name="securityEncryptionType")
    def security_encryption_type(self) -> Optional[_builtins.str]:
        """
        Encryption Type when the Virtual Machine is a Confidential VM. Possible values are `VMGuestStateOnly` and `DiskWithVMGuestState`. Changing this forces a new resource to be created.

        > **NOTE:** `vtpm_enabled` must be set to `true` when `security_encryption_type` is specified.

        > **NOTE:** `encryption_at_host_enabled` cannot be set to `true` when `security_encryption_type` is set to `DiskWithVMGuestState`.
        """
        return pulumi.get(self, "security_encryption_type")

    @_builtins.property
    @pulumi.getter(name="writeAcceleratorEnabled")
    def write_accelerator_enabled(self) -> Optional[_builtins.bool]:
        """
        Should Write Accelerator be Enabled for this OS Disk? Defaults to `false`.

        > **NOTE:** This requires that the `storage_account_type` is set to `Premium_LRS` and that `caching` is set to `None`.
        """
        return pulumi.get(self, "write_accelerator_enabled")


@pulumi.output_type
class LinuxVirtualMachineOsDiskDiffDiskSettings(dict):
    def __init__(__self__, *,
                 option: _builtins.str,
                 placement: Optional[_builtins.str] = None):
        """
        :param _builtins.str option: Specifies the Ephemeral Disk Settings for the OS Disk. At this time the only possible value is `Local`. Changing this forces a new resource to be created.
        :param _builtins.str placement: Specifies where to store the Ephemeral Disk. Possible values are `CacheDisk` and `ResourceDisk`. Defaults to `CacheDisk`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "option", option)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)

    @_builtins.property
    @pulumi.getter
    def option(self) -> _builtins.str:
        """
        Specifies the Ephemeral Disk Settings for the OS Disk. At this time the only possible value is `Local`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "option")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Specifies where to store the Ephemeral Disk. Possible values are `CacheDisk` and `ResourceDisk`. Defaults to `CacheDisk`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "placement")


@pulumi.output_type
class LinuxVirtualMachineOsImageNotification(dict):
    def __init__(__self__, *,
                 timeout: Optional[_builtins.str] = None):
        """
        :param _builtins.str timeout: Length of time a notification to be sent to the VM on the instance metadata server till the VM gets OS upgraded. The only possible value is `PT15M`. Defaults to `PT15M`.
        """
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.str]:
        """
        Length of time a notification to be sent to the VM on the instance metadata server till the VM gets OS upgraded. The only possible value is `PT15M`. Defaults to `PT15M`.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class LinuxVirtualMachinePlan(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 product: _builtins.str,
                 publisher: _builtins.str):
        """
        :param _builtins.str name: Specifies the Name of the Marketplace Image this Virtual Machine should be created from. Changing this forces a new resource to be created.
        :param _builtins.str product: Specifies the Product of the Marketplace Image this Virtual Machine should be created from. Changing this forces a new resource to be created.
        :param _builtins.str publisher: Specifies the Publisher of the Marketplace Image this Virtual Machine should be created from. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "publisher", publisher)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the Name of the Marketplace Image this Virtual Machine should be created from. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def product(self) -> _builtins.str:
        """
        Specifies the Product of the Marketplace Image this Virtual Machine should be created from. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "product")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        """
        Specifies the Publisher of the Marketplace Image this Virtual Machine should be created from. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher")


@pulumi.output_type
class LinuxVirtualMachineScaleSetAdditionalCapabilities(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ultraSsdEnabled":
            suggest = "ultra_ssd_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxVirtualMachineScaleSetAdditionalCapabilities. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxVirtualMachineScaleSetAdditionalCapabilities.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxVirtualMachineScaleSetAdditionalCapabilities.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ultra_ssd_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool ultra_ssd_enabled: Should the capacity to enable Data Disks of the `UltraSSD_LRS` storage account type be supported on this Virtual Machine Scale Set? Possible values are `true` or `false`. Defaults to `false`. Changing this forces a new resource to be created.
        """
        if ultra_ssd_enabled is not None:
            pulumi.set(__self__, "ultra_ssd_enabled", ultra_ssd_enabled)

    @_builtins.property
    @pulumi.getter(name="ultraSsdEnabled")
    def ultra_ssd_enabled(self) -> Optional[_builtins.bool]:
        """
        Should the capacity to enable Data Disks of the `UltraSSD_LRS` storage account type be supported on this Virtual Machine Scale Set? Possible values are `true` or `false`. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "ultra_ssd_enabled")


@pulumi.output_type
class LinuxVirtualMachineScaleSetAdminSshKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKey":
            suggest = "public_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxVirtualMachineScaleSetAdminSshKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxVirtualMachineScaleSetAdminSshKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxVirtualMachineScaleSetAdminSshKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_key: _builtins.str,
                 username: _builtins.str):
        """
        :param _builtins.str public_key: The Public Key which should be used for authentication, which needs to be in `ssh-rsa` format with at least 2048-bit or in `ssh-ed25519` format.
        :param _builtins.str username: The Username for which this Public SSH Key should be configured.
               
               > **Note:** The Azure VM Agent only allows creating SSH Keys at the path `/home/{username}/.ssh/authorized_keys` - as such this public key will be added/appended to the authorized keys file.
        """
        pulumi.set(__self__, "public_key", public_key)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> _builtins.str:
        """
        The Public Key which should be used for authentication, which needs to be in `ssh-rsa` format with at least 2048-bit or in `ssh-ed25519` format.
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The Username for which this Public SSH Key should be configured.

        > **Note:** The Azure VM Agent only allows creating SSH Keys at the path `/home/{username}/.ssh/authorized_keys` - as such this public key will be added/appended to the authorized keys file.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class LinuxVirtualMachineScaleSetAutomaticInstanceRepair(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gracePeriod":
            suggest = "grace_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxVirtualMachineScaleSetAutomaticInstanceRepair. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxVirtualMachineScaleSetAutomaticInstanceRepair.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxVirtualMachineScaleSetAutomaticInstanceRepair.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 action: Optional[_builtins.str] = None,
                 grace_period: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Should the automatic instance repair be enabled on this Virtual Machine Scale Set?
        :param _builtins.str action: The repair action that will be used for repairing unhealthy virtual machines in the scale set. Possible values include `Replace`, `Restart`, `Reimage`.
               
               > **Note:** Once the `action` field has been set it will always return the last value it was assigned if it is removed from the configuration file.
               
               > **Note:** If you wish to update the repair `action` of an existing `automatic_instance_repair` policy, you must first `disable` the `automatic_instance_repair` policy before you can re-enable the `automatic_instance_repair` policy with the new repair `action` defined.
        :param _builtins.str grace_period: Amount of time for which automatic repairs will be delayed. The grace period starts right after the VM is found unhealthy. Possible values are between `10` and `90` minutes. The time duration should be specified in `ISO 8601` format (e.g. `PT10M` to `PT90M`).
               
               > **Note:** Once the `grace_period` field has been set it will always return the last value it was assigned if it is removed from the configuration file.
        """
        pulumi.set(__self__, "enabled", enabled)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if grace_period is not None:
            pulumi.set(__self__, "grace_period", grace_period)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Should the automatic instance repair be enabled on this Virtual Machine Scale Set?
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        """
        The repair action that will be used for repairing unhealthy virtual machines in the scale set. Possible values include `Replace`, `Restart`, `Reimage`.

        > **Note:** Once the `action` field has been set it will always return the last value it was assigned if it is removed from the configuration file.

        > **Note:** If you wish to update the repair `action` of an existing `automatic_instance_repair` policy, you must first `disable` the `automatic_instance_repair` policy before you can re-enable the `automatic_instance_repair` policy with the new repair `action` defined.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> Optional[_builtins.str]:
        """
        Amount of time for which automatic repairs will be delayed. The grace period starts right after the VM is found unhealthy. Possible values are between `10` and `90` minutes. The time duration should be specified in `ISO 8601` format (e.g. `PT10M` to `PT90M`).

        > **Note:** Once the `grace_period` field has been set it will always return the last value it was assigned if it is removed from the configuration file.
        """
        return pulumi.get(self, "grace_period")


@pulumi.output_type
class LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableAutomaticRollback":
            suggest = "disable_automatic_rollback"
        elif key == "enableAutomaticOsUpgrade":
            suggest = "enable_automatic_os_upgrade"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxVirtualMachineScaleSetAutomaticOsUpgradePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_automatic_rollback: _builtins.bool,
                 enable_automatic_os_upgrade: _builtins.bool):
        """
        :param _builtins.bool disable_automatic_rollback: Should automatic rollbacks be disabled?
        :param _builtins.bool enable_automatic_os_upgrade: Should OS Upgrades automatically be applied to Scale Set instances in a rolling fashion when a newer version of the OS Image becomes available?
        """
        pulumi.set(__self__, "disable_automatic_rollback", disable_automatic_rollback)
        pulumi.set(__self__, "enable_automatic_os_upgrade", enable_automatic_os_upgrade)

    @_builtins.property
    @pulumi.getter(name="disableAutomaticRollback")
    def disable_automatic_rollback(self) -> _builtins.bool:
        """
        Should automatic rollbacks be disabled?
        """
        return pulumi.get(self, "disable_automatic_rollback")

    @_builtins.property
    @pulumi.getter(name="enableAutomaticOsUpgrade")
    def enable_automatic_os_upgrade(self) -> _builtins.bool:
        """
        Should OS Upgrades automatically be applied to Scale Set instances in a rolling fashion when a newer version of the OS Image becomes available?
        """
        return pulumi.get(self, "enable_automatic_os_upgrade")


@pulumi.output_type
class LinuxVirtualMachineScaleSetBootDiagnostics(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageAccountUri":
            suggest = "storage_account_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxVirtualMachineScaleSetBootDiagnostics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxVirtualMachineScaleSetBootDiagnostics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxVirtualMachineScaleSetBootDiagnostics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_account_uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str storage_account_uri: The Primary/Secondary Endpoint for the Azure Storage Account which should be used to store Boot Diagnostics, including Console Output and Screenshots from the Hypervisor.
               
               > **Note:** Passing a null value will utilize a Managed Storage Account to store Boot Diagnostics.
        """
        if storage_account_uri is not None:
            pulumi.set(__self__, "storage_account_uri", storage_account_uri)

    @_builtins.property
    @pulumi.getter(name="storageAccountUri")
    def storage_account_uri(self) -> Optional[_builtins.str]:
        """
        The Primary/Secondary Endpoint for the Azure Storage Account which should be used to store Boot Diagnostics, including Console Output and Screenshots from the Hypervisor.

        > **Note:** Passing a null value will utilize a Managed Storage Account to store Boot Diagnostics.
        """
        return pulumi.get(self, "storage_account_uri")


@pulumi.output_type
class LinuxVirtualMachineScaleSetDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "storageAccountType":
            suggest = "storage_account_type"
        elif key == "createOption":
            suggest = "create_option"
        elif key == "diskEncryptionSetId":
            suggest = "disk_encryption_set_id"
        elif key == "ultraSsdDiskIopsReadWrite":
            suggest = "ultra_ssd_disk_iops_read_write"
        elif key == "ultraSsdDiskMbpsReadWrite":
            suggest = "ultra_ssd_disk_mbps_read_write"
        elif key == "writeAcceleratorEnabled":
            suggest = "write_accelerator_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxVirtualMachineScaleSetDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxVirtualMachineScaleSetDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxVirtualMachineScaleSetDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 caching: _builtins.str,
                 disk_size_gb: _builtins.int,
                 lun: _builtins.int,
                 storage_account_type: _builtins.str,
                 create_option: Optional[_builtins.str] = None,
                 disk_encryption_set_id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 ultra_ssd_disk_iops_read_write: Optional[_builtins.int] = None,
                 ultra_ssd_disk_mbps_read_write: Optional[_builtins.int] = None,
                 write_accelerator_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str caching: The type of Caching which should be used for this Data Disk. Possible values are `None`, `ReadOnly` and `ReadWrite`.
        :param _builtins.int disk_size_gb: The size of the Data Disk which should be created.
        :param _builtins.int lun: The Logical Unit Number of the Data Disk, which must be unique within the Virtual Machine.
        :param _builtins.str storage_account_type: The Type of Storage Account which should back this Data Disk. Possible values include `Standard_LRS`, `StandardSSD_LRS`, `StandardSSD_ZRS`, `Premium_LRS`, `PremiumV2_LRS`, `Premium_ZRS` and `UltraSSD_LRS`.
               
               > **Note:** `UltraSSD_LRS` is only supported when `ultra_ssd_enabled` within the `additional_capabilities` block is enabled.
        :param _builtins.str create_option: The create option which should be used for this Data Disk. Possible values are `Empty` and `FromImage`. Defaults to `Empty`. (`FromImage` should only be used if the source image includes data disks).
        :param _builtins.str disk_encryption_set_id: The ID of the Disk Encryption Set which should be used to encrypt this Data Disk. Changing this forces a new resource to be created.
               
               > **Note:** The Disk Encryption Set must have the `Reader` Role Assignment scoped on the Key Vault - in addition to an Access Policy to the Key Vault
               
               > **Note:** Disk Encryption Sets are in Public Preview in a limited set of regions
        :param _builtins.str name: The name of the Data Disk.
        :param _builtins.int ultra_ssd_disk_iops_read_write: Specifies the Read-Write IOPS for this Data Disk. Only settable when `storage_account_type` is `PremiumV2_LRS` or `UltraSSD_LRS`.
        :param _builtins.int ultra_ssd_disk_mbps_read_write: Specifies the bandwidth in MB per second for this Data Disk. Only settable when `storage_account_type` is `PremiumV2_LRS` or `UltraSSD_LRS`.
        :param _builtins.bool write_accelerator_enabled: Should Write Accelerator be enabled for this Data Disk? Defaults to `false`.
               
               > **Note:** This requires that the `storage_account_type` is set to `Premium_LRS` and that `caching` is set to `None`.
        """
        pulumi.set(__self__, "caching", caching)
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "lun", lun)
        pulumi.set(__self__, "storage_account_type", storage_account_type)
        if create_option is not None:
            pulumi.set(__self__, "create_option", create_option)
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ultra_ssd_disk_iops_read_write is not None:
            pulumi.set(__self__, "ultra_ssd_disk_iops_read_write", ultra_ssd_disk_iops_read_write)
        if ultra_ssd_disk_mbps_read_write is not None:
            pulumi.set(__self__, "ultra_ssd_disk_mbps_read_write", ultra_ssd_disk_mbps_read_write)
        if write_accelerator_enabled is not None:
            pulumi.set(__self__, "write_accelerator_enabled", write_accelerator_enabled)

    @_builtins.property
    @pulumi.getter
    def caching(self) -> _builtins.str:
        """
        The type of Caching which should be used for this Data Disk. Possible values are `None`, `ReadOnly` and `ReadWrite`.
        """
        return pulumi.get(self, "caching")

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> _builtins.int:
        """
        The size of the Data Disk which should be created.
        """
        return pulumi.get(self, "disk_size_gb")

    @_builtins.property
    @pulumi.getter
    def lun(self) -> _builtins.int:
        """
        The Logical Unit Number of the Data Disk, which must be unique within the Virtual Machine.
        """
        return pulumi.get(self, "lun")

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> _builtins.str:
        """
        The Type of Storage Account which should back this Data Disk. Possible values include `Standard_LRS`, `StandardSSD_LRS`, `StandardSSD_ZRS`, `Premium_LRS`, `PremiumV2_LRS`, `Premium_ZRS` and `UltraSSD_LRS`.

        > **Note:** `UltraSSD_LRS` is only supported when `ultra_ssd_enabled` within the `additional_capabilities` block is enabled.
        """
        return pulumi.get(self, "storage_account_type")

    @_builtins.property
    @pulumi.getter(name="createOption")
    def create_option(self) -> Optional[_builtins.str]:
        """
        The create option which should be used for this Data Disk. Possible values are `Empty` and `FromImage`. Defaults to `Empty`. (`FromImage` should only be used if the source image includes data disks).
        """
        return pulumi.get(self, "create_option")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Disk Encryption Set which should be used to encrypt this Data Disk. Changing this forces a new resource to be created.

        > **Note:** The Disk Encryption Set must have the `Reader` Role Assignment scoped on the Key Vault - in addition to an Access Policy to the Key Vault

        > **Note:** Disk Encryption Sets are in Public Preview in a limited set of regions
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the Data Disk.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ultraSsdDiskIopsReadWrite")
    def ultra_ssd_disk_iops_read_write(self) -> Optional[_builtins.int]:
        """
        Specifies the Read-Write IOPS for this Data Disk. Only settable when `storage_account_type` is `PremiumV2_LRS` or `UltraSSD_LRS`.
        """
        return pulumi.get(self, "ultra_ssd_disk_iops_read_write")

    @_builtins.property
    @pulumi.getter(name="ultraSsdDiskMbpsReadWrite")
    def ultra_ssd_disk_mbps_read_write(self) -> Optional[_builtins.int]:
        """
        Specifies the bandwidth in MB per second for this Data Disk. Only settable when `storage_account_type` is `PremiumV2_LRS` or `UltraSSD_LRS`.
        """
        return pulumi.get(self, "ultra_ssd_disk_mbps_read_write")

    @_builtins.property
    @pulumi.getter(name="writeAcceleratorEnabled")
    def write_accelerator_enabled(self) -> Optional[_builtins.bool]:
        """
        Should Write Accelerator be enabled for this Data Disk? Defaults to `false`.

        > **Note:** This requires that the `storage_account_type` is set to `Premium_LRS` and that `caching` is set to `None`.
        """
        return pulumi.get(self, "write_accelerator_enabled")


@pulumi.output_type
class LinuxVirtualMachineScaleSetExtension(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "typeHandlerVersion":
            suggest = "type_handler_version"
        elif key == "autoUpgradeMinorVersion":
            suggest = "auto_upgrade_minor_version"
        elif key == "automaticUpgradeEnabled":
            suggest = "automatic_upgrade_enabled"
        elif key == "forceUpdateTag":
            suggest = "force_update_tag"
        elif key == "protectedSettings":
            suggest = "protected_settings"
        elif key == "protectedSettingsFromKeyVault":
            suggest = "protected_settings_from_key_vault"
        elif key == "provisionAfterExtensions":
            suggest = "provision_after_extensions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxVirtualMachineScaleSetExtension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxVirtualMachineScaleSetExtension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxVirtualMachineScaleSetExtension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 publisher: _builtins.str,
                 type: _builtins.str,
                 type_handler_version: _builtins.str,
                 auto_upgrade_minor_version: Optional[_builtins.bool] = None,
                 automatic_upgrade_enabled: Optional[_builtins.bool] = None,
                 force_update_tag: Optional[_builtins.str] = None,
                 protected_settings: Optional[_builtins.str] = None,
                 protected_settings_from_key_vault: Optional['outputs.LinuxVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault'] = None,
                 provision_after_extensions: Optional[Sequence[_builtins.str]] = None,
                 settings: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name for the Virtual Machine Scale Set Extension.
        :param _builtins.str publisher: Specifies the Publisher of the Extension.
        :param _builtins.str type: Specifies the Type of the Extension.
        :param _builtins.str type_handler_version: Specifies the version of the extension to use, available versions can be found using the Azure CLI.
        :param _builtins.bool auto_upgrade_minor_version: Should the latest version of the Extension be used at Deployment Time, if one is available? This won't auto-update the extension on existing installation. Defaults to `true`.
        :param _builtins.bool automatic_upgrade_enabled: Should the Extension be automatically updated whenever the Publisher releases a new version of this VM Extension?
        :param _builtins.str force_update_tag: A value which, when different to the previous value can be used to force-run the Extension even if the Extension Configuration hasn't changed.
        :param _builtins.str protected_settings: A JSON String which specifies Sensitive Settings (such as Passwords) for the Extension.
               
               > **Note:** Keys within the `protected_settings` block are notoriously case-sensitive, where the casing required (e.g. TitleCase vs snakeCase) depends on the Extension being used. Please refer to the documentation for the specific Virtual Machine Extension you're looking to use for more information.
        :param 'LinuxVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultArgs' protected_settings_from_key_vault: A `protected_settings_from_key_vault` block as defined below.
               
               > **Note:** `protected_settings_from_key_vault` cannot be used with `protected_settings`
        :param Sequence[_builtins.str] provision_after_extensions: An ordered list of Extension names which this should be provisioned after.
        :param _builtins.str settings: A JSON String which specifies Settings for the Extension.
               
               > **Note:** Keys within the `settings` block are notoriously case-sensitive, where the casing required (e.g. TitleCase vs snakeCase) depends on the Extension being used. Please refer to the documentation for the specific Virtual Machine Extension you're looking to use for more information.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "type_handler_version", type_handler_version)
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if automatic_upgrade_enabled is not None:
            pulumi.set(__self__, "automatic_upgrade_enabled", automatic_upgrade_enabled)
        if force_update_tag is not None:
            pulumi.set(__self__, "force_update_tag", force_update_tag)
        if protected_settings is not None:
            pulumi.set(__self__, "protected_settings", protected_settings)
        if protected_settings_from_key_vault is not None:
            pulumi.set(__self__, "protected_settings_from_key_vault", protected_settings_from_key_vault)
        if provision_after_extensions is not None:
            pulumi.set(__self__, "provision_after_extensions", provision_after_extensions)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name for the Virtual Machine Scale Set Extension.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        """
        Specifies the Publisher of the Extension.
        """
        return pulumi.get(self, "publisher")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the Type of the Extension.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> _builtins.str:
        """
        Specifies the version of the extension to use, available versions can be found using the Azure CLI.
        """
        return pulumi.get(self, "type_handler_version")

    @_builtins.property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[_builtins.bool]:
        """
        Should the latest version of the Extension be used at Deployment Time, if one is available? This won't auto-update the extension on existing installation. Defaults to `true`.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @_builtins.property
    @pulumi.getter(name="automaticUpgradeEnabled")
    def automatic_upgrade_enabled(self) -> Optional[_builtins.bool]:
        """
        Should the Extension be automatically updated whenever the Publisher releases a new version of this VM Extension?
        """
        return pulumi.get(self, "automatic_upgrade_enabled")

    @_builtins.property
    @pulumi.getter(name="forceUpdateTag")
    def force_update_tag(self) -> Optional[_builtins.str]:
        """
        A value which, when different to the previous value can be used to force-run the Extension even if the Extension Configuration hasn't changed.
        """
        return pulumi.get(self, "force_update_tag")

    @_builtins.property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> Optional[_builtins.str]:
        """
        A JSON String which specifies Sensitive Settings (such as Passwords) for the Extension.

        > **Note:** Keys within the `protected_settings` block are notoriously case-sensitive, where the casing required (e.g. TitleCase vs snakeCase) depends on the Extension being used. Please refer to the documentation for the specific Virtual Machine Extension you're looking to use for more information.
        """
        return pulumi.get(self, "protected_settings")

    @_builtins.property
    @pulumi.getter(name="protectedSettingsFromKeyVault")
    def protected_settings_from_key_vault(self) -> Optional['outputs.LinuxVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault']:
        """
        A `protected_settings_from_key_vault` block as defined below.

        > **Note:** `protected_settings_from_key_vault` cannot be used with `protected_settings`
        """
        return pulumi.get(self, "protected_settings_from_key_vault")

    @_builtins.property
    @pulumi.getter(name="provisionAfterExtensions")
    def provision_after_extensions(self) -> Optional[Sequence[_builtins.str]]:
        """
        An ordered list of Extension names which this should be provisioned after.
        """
        return pulumi.get(self, "provision_after_extensions")

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[_builtins.str]:
        """
        A JSON String which specifies Settings for the Extension.

        > **Note:** Keys within the `settings` block are notoriously case-sensitive, where the casing required (e.g. TitleCase vs snakeCase) depends on the Extension being used. Please refer to the documentation for the specific Virtual Machine Extension you're looking to use for more information.
        """
        return pulumi.get(self, "settings")


@pulumi.output_type
class LinuxVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretUrl":
            suggest = "secret_url"
        elif key == "sourceVaultId":
            suggest = "source_vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_url: _builtins.str,
                 source_vault_id: _builtins.str):
        """
        :param _builtins.str secret_url: The URL to the Key Vault Secret which stores the protected settings.
        :param _builtins.str source_vault_id: The ID of the source Key Vault.
        """
        pulumi.set(__self__, "secret_url", secret_url)
        pulumi.set(__self__, "source_vault_id", source_vault_id)

    @_builtins.property
    @pulumi.getter(name="secretUrl")
    def secret_url(self) -> _builtins.str:
        """
        The URL to the Key Vault Secret which stores the protected settings.
        """
        return pulumi.get(self, "secret_url")

    @_builtins.property
    @pulumi.getter(name="sourceVaultId")
    def source_vault_id(self) -> _builtins.str:
        """
        The ID of the source Key Vault.
        """
        return pulumi.get(self, "source_vault_id")


@pulumi.output_type
class LinuxVirtualMachineScaleSetGalleryApplication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "versionId":
            suggest = "version_id"
        elif key == "configurationBlobUri":
            suggest = "configuration_blob_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxVirtualMachineScaleSetGalleryApplication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxVirtualMachineScaleSetGalleryApplication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxVirtualMachineScaleSetGalleryApplication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 version_id: _builtins.str,
                 configuration_blob_uri: Optional[_builtins.str] = None,
                 order: Optional[_builtins.int] = None,
                 tag: Optional[_builtins.str] = None):
        """
        :param _builtins.str version_id: Specifies the Gallery Application Version resource ID. Changing this forces a new resource to be created.
        :param _builtins.str configuration_blob_uri: Specifies the URI to an Azure Blob that will replace the default configuration for the package if provided. Changing this forces a new resource to be created.
        :param _builtins.int order: Specifies the order in which the packages have to be installed. Possible values are between `0` and `2147483647`. Defaults to `0`. Changing this forces a new resource to be created.
        :param _builtins.str tag: Specifies a passthrough value for more generic context. This field can be any valid `string` value. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "version_id", version_id)
        if configuration_blob_uri is not None:
            pulumi.set(__self__, "configuration_blob_uri", configuration_blob_uri)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> _builtins.str:
        """
        Specifies the Gallery Application Version resource ID. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "version_id")

    @_builtins.property
    @pulumi.getter(name="configurationBlobUri")
    def configuration_blob_uri(self) -> Optional[_builtins.str]:
        """
        Specifies the URI to an Azure Blob that will replace the default configuration for the package if provided. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "configuration_blob_uri")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.int]:
        """
        Specifies the order in which the packages have to be installed. Possible values are between `0` and `2147483647`. Defaults to `0`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[_builtins.str]:
        """
        Specifies a passthrough value for more generic context. This field can be any valid `string` value. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class LinuxVirtualMachineScaleSetIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxVirtualMachineScaleSetIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxVirtualMachineScaleSetIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxVirtualMachineScaleSetIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Linux Virtual Machine Scale Set. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        :param Sequence[_builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Linux Virtual Machine Scale Set.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param _builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param _builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Linux Virtual Machine Scale Set. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Linux Virtual Machine Scale Set.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class LinuxVirtualMachineScaleSetNetworkInterface(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipConfigurations":
            suggest = "ip_configurations"
        elif key == "auxiliaryMode":
            suggest = "auxiliary_mode"
        elif key == "auxiliarySku":
            suggest = "auxiliary_sku"
        elif key == "dnsServers":
            suggest = "dns_servers"
        elif key == "enableAcceleratedNetworking":
            suggest = "enable_accelerated_networking"
        elif key == "enableIpForwarding":
            suggest = "enable_ip_forwarding"
        elif key == "networkSecurityGroupId":
            suggest = "network_security_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxVirtualMachineScaleSetNetworkInterface. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxVirtualMachineScaleSetNetworkInterface.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxVirtualMachineScaleSetNetworkInterface.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_configurations: Sequence['outputs.LinuxVirtualMachineScaleSetNetworkInterfaceIpConfiguration'],
                 name: _builtins.str,
                 auxiliary_mode: Optional[_builtins.str] = None,
                 auxiliary_sku: Optional[_builtins.str] = None,
                 dns_servers: Optional[Sequence[_builtins.str]] = None,
                 enable_accelerated_networking: Optional[_builtins.bool] = None,
                 enable_ip_forwarding: Optional[_builtins.bool] = None,
                 network_security_group_id: Optional[_builtins.str] = None,
                 primary: Optional[_builtins.bool] = None):
        """
        :param Sequence['LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationArgs'] ip_configurations: One or more `ip_configuration` blocks as defined above.
        :param _builtins.str name: The Name which should be used for this Network Interface. Changing this forces a new resource to be created.
        :param _builtins.str auxiliary_mode: Specifies the auxiliary mode used to enable network high-performance feature on Network Virtual Appliances (NVAs). This feature offers competitive performance in Connections Per Second (CPS) optimization, along with improvements to handling large amounts of simultaneous connections. Possible values are `AcceleratedConnections` and `Floating`.
               
               > **Note:** `auxiliary_mode` is in **Preview** and requires that the prerequisites are enabled - [more information can be found in the Azure documentation](https://learn.microsoft.com/azure/networking/nva-accelerated-connections#prerequisites).
        :param _builtins.str auxiliary_sku: Specifies the SKU used for the network high-performance feature on Network Virtual Appliances (NVAs). Possible values are `A1`, `A2`, `A4` and `A8`.
               
               > **Note:** `auxiliary_sku` is in **Preview** and requires that the prerequisites are enabled - [more information can be found in the Azure documentation](https://learn.microsoft.com/azure/networking/nva-accelerated-connections#prerequisites).
        :param Sequence[_builtins.str] dns_servers: A list of IP Addresses of DNS Servers which should be assigned to the Network Interface.
        :param _builtins.bool enable_accelerated_networking: Does this Network Interface support Accelerated Networking? Defaults to `false`.
        :param _builtins.bool enable_ip_forwarding: Does this Network Interface support IP Forwarding? Defaults to `false`.
        :param _builtins.str network_security_group_id: The ID of a Network Security Group which should be assigned to this Network Interface.
        :param _builtins.bool primary: Is this the Primary IP Configuration?
               
               > **Note:** If multiple `network_interface` blocks are specified, one must be set to `primary`.
        """
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        pulumi.set(__self__, "name", name)
        if auxiliary_mode is not None:
            pulumi.set(__self__, "auxiliary_mode", auxiliary_mode)
        if auxiliary_sku is not None:
            pulumi.set(__self__, "auxiliary_sku", auxiliary_sku)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if enable_accelerated_networking is not None:
            pulumi.set(__self__, "enable_accelerated_networking", enable_accelerated_networking)
        if enable_ip_forwarding is not None:
            pulumi.set(__self__, "enable_ip_forwarding", enable_ip_forwarding)
        if network_security_group_id is not None:
            pulumi.set(__self__, "network_security_group_id", network_security_group_id)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)

    @_builtins.property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Sequence['outputs.LinuxVirtualMachineScaleSetNetworkInterfaceIpConfiguration']:
        """
        One or more `ip_configuration` blocks as defined above.
        """
        return pulumi.get(self, "ip_configurations")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The Name which should be used for this Network Interface. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="auxiliaryMode")
    def auxiliary_mode(self) -> Optional[_builtins.str]:
        """
        Specifies the auxiliary mode used to enable network high-performance feature on Network Virtual Appliances (NVAs). This feature offers competitive performance in Connections Per Second (CPS) optimization, along with improvements to handling large amounts of simultaneous connections. Possible values are `AcceleratedConnections` and `Floating`.

        > **Note:** `auxiliary_mode` is in **Preview** and requires that the prerequisites are enabled - [more information can be found in the Azure documentation](https://learn.microsoft.com/azure/networking/nva-accelerated-connections#prerequisites).
        """
        return pulumi.get(self, "auxiliary_mode")

    @_builtins.property
    @pulumi.getter(name="auxiliarySku")
    def auxiliary_sku(self) -> Optional[_builtins.str]:
        """
        Specifies the SKU used for the network high-performance feature on Network Virtual Appliances (NVAs). Possible values are `A1`, `A2`, `A4` and `A8`.

        > **Note:** `auxiliary_sku` is in **Preview** and requires that the prerequisites are enabled - [more information can be found in the Azure documentation](https://learn.microsoft.com/azure/networking/nva-accelerated-connections#prerequisites).
        """
        return pulumi.get(self, "auxiliary_sku")

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of IP Addresses of DNS Servers which should be assigned to the Network Interface.
        """
        return pulumi.get(self, "dns_servers")

    @_builtins.property
    @pulumi.getter(name="enableAcceleratedNetworking")
    def enable_accelerated_networking(self) -> Optional[_builtins.bool]:
        """
        Does this Network Interface support Accelerated Networking? Defaults to `false`.
        """
        return pulumi.get(self, "enable_accelerated_networking")

    @_builtins.property
    @pulumi.getter(name="enableIpForwarding")
    def enable_ip_forwarding(self) -> Optional[_builtins.bool]:
        """
        Does this Network Interface support IP Forwarding? Defaults to `false`.
        """
        return pulumi.get(self, "enable_ip_forwarding")

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupId")
    def network_security_group_id(self) -> Optional[_builtins.str]:
        """
        The ID of a Network Security Group which should be assigned to this Network Interface.
        """
        return pulumi.get(self, "network_security_group_id")

    @_builtins.property
    @pulumi.getter
    def primary(self) -> Optional[_builtins.bool]:
        """
        Is this the Primary IP Configuration?

        > **Note:** If multiple `network_interface` blocks are specified, one must be set to `primary`.
        """
        return pulumi.get(self, "primary")


@pulumi.output_type
class LinuxVirtualMachineScaleSetNetworkInterfaceIpConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationGatewayBackendAddressPoolIds":
            suggest = "application_gateway_backend_address_pool_ids"
        elif key == "applicationSecurityGroupIds":
            suggest = "application_security_group_ids"
        elif key == "loadBalancerBackendAddressPoolIds":
            suggest = "load_balancer_backend_address_pool_ids"
        elif key == "loadBalancerInboundNatRulesIds":
            suggest = "load_balancer_inbound_nat_rules_ids"
        elif key == "publicIpAddresses":
            suggest = "public_ip_addresses"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxVirtualMachineScaleSetNetworkInterfaceIpConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxVirtualMachineScaleSetNetworkInterfaceIpConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxVirtualMachineScaleSetNetworkInterfaceIpConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 application_gateway_backend_address_pool_ids: Optional[Sequence[_builtins.str]] = None,
                 application_security_group_ids: Optional[Sequence[_builtins.str]] = None,
                 load_balancer_backend_address_pool_ids: Optional[Sequence[_builtins.str]] = None,
                 load_balancer_inbound_nat_rules_ids: Optional[Sequence[_builtins.str]] = None,
                 primary: Optional[_builtins.bool] = None,
                 public_ip_addresses: Optional[Sequence['outputs.LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress']] = None,
                 subnet_id: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The Name which should be used for this IP Configuration.
        :param Sequence[_builtins.str] application_gateway_backend_address_pool_ids: A list of Backend Address Pools ID's from a Application Gateway which this Virtual Machine Scale Set should be connected to.
        :param Sequence[_builtins.str] application_security_group_ids: A list of Application Security Group ID's which this Virtual Machine Scale Set should be connected to.
        :param Sequence[_builtins.str] load_balancer_backend_address_pool_ids: A list of Backend Address Pools ID's from a Load Balancer which this Virtual Machine Scale Set should be connected to.
               
               > **Note:** When the Virtual Machine Scale Set is configured to have public IPs per instance are created with a load balancer, the SKU of the Virtual Machine instance IPs is determined by the SKU of the Virtual Machine Scale Sets Load Balancer (e.g. `Basic` or `Standard`). Alternatively, you may use the `public_ip_prefix_id` field to generate instance-level IPs in a virtual machine scale set as well. The zonal properties of the prefix will be passed to the Virtual Machine instance IPs, though they will not be shown in the output. To view the public IP addresses assigned to the Virtual Machine Scale Sets Virtual Machine instances use the **az vmss list-instance-public-ips --resource-group `ResourceGroupName` --name `VirtualMachineScaleSetName`** CLI command.
               
               > **Note:** When using this field you'll also need to configure a Rule for the Load Balancer, and use a `depends_on` between this resource and the Load Balancer Rule.
        :param Sequence[_builtins.str] load_balancer_inbound_nat_rules_ids: A list of NAT Rule ID's from a Load Balancer which this Virtual Machine Scale Set should be connected to.
               
               > **Note:** When using this field you'll also need to configure a Rule for the Load Balancer, and use a `depends_on` between this resource and the Load Balancer Rule.
        :param _builtins.bool primary: Is this the Primary IP Configuration for this Network Interface? Defaults to `false`.
               
               > **Note:** One `ip_configuration` block must be marked as Primary for each Network Interface.
        :param Sequence['LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressArgs'] public_ip_addresses: A `public_ip_address` block as defined below.
        :param _builtins.str subnet_id: The ID of the Subnet which this IP Configuration should be connected to.
               
               > **Note:** `subnet_id` is required if `version` is set to `IPv4`.
        :param _builtins.str version: The Internet Protocol Version which should be used for this IP Configuration. Possible values are `IPv4` and `IPv6`. Defaults to `IPv4`.
        """
        pulumi.set(__self__, "name", name)
        if application_gateway_backend_address_pool_ids is not None:
            pulumi.set(__self__, "application_gateway_backend_address_pool_ids", application_gateway_backend_address_pool_ids)
        if application_security_group_ids is not None:
            pulumi.set(__self__, "application_security_group_ids", application_security_group_ids)
        if load_balancer_backend_address_pool_ids is not None:
            pulumi.set(__self__, "load_balancer_backend_address_pool_ids", load_balancer_backend_address_pool_ids)
        if load_balancer_inbound_nat_rules_ids is not None:
            pulumi.set(__self__, "load_balancer_inbound_nat_rules_ids", load_balancer_inbound_nat_rules_ids)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if public_ip_addresses is not None:
            pulumi.set(__self__, "public_ip_addresses", public_ip_addresses)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The Name which should be used for this IP Configuration.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="applicationGatewayBackendAddressPoolIds")
    def application_gateway_backend_address_pool_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of Backend Address Pools ID's from a Application Gateway which this Virtual Machine Scale Set should be connected to.
        """
        return pulumi.get(self, "application_gateway_backend_address_pool_ids")

    @_builtins.property
    @pulumi.getter(name="applicationSecurityGroupIds")
    def application_security_group_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of Application Security Group ID's which this Virtual Machine Scale Set should be connected to.
        """
        return pulumi.get(self, "application_security_group_ids")

    @_builtins.property
    @pulumi.getter(name="loadBalancerBackendAddressPoolIds")
    def load_balancer_backend_address_pool_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of Backend Address Pools ID's from a Load Balancer which this Virtual Machine Scale Set should be connected to.

        > **Note:** When the Virtual Machine Scale Set is configured to have public IPs per instance are created with a load balancer, the SKU of the Virtual Machine instance IPs is determined by the SKU of the Virtual Machine Scale Sets Load Balancer (e.g. `Basic` or `Standard`). Alternatively, you may use the `public_ip_prefix_id` field to generate instance-level IPs in a virtual machine scale set as well. The zonal properties of the prefix will be passed to the Virtual Machine instance IPs, though they will not be shown in the output. To view the public IP addresses assigned to the Virtual Machine Scale Sets Virtual Machine instances use the **az vmss list-instance-public-ips --resource-group `ResourceGroupName` --name `VirtualMachineScaleSetName`** CLI command.

        > **Note:** When using this field you'll also need to configure a Rule for the Load Balancer, and use a `depends_on` between this resource and the Load Balancer Rule.
        """
        return pulumi.get(self, "load_balancer_backend_address_pool_ids")

    @_builtins.property
    @pulumi.getter(name="loadBalancerInboundNatRulesIds")
    def load_balancer_inbound_nat_rules_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of NAT Rule ID's from a Load Balancer which this Virtual Machine Scale Set should be connected to.

        > **Note:** When using this field you'll also need to configure a Rule for the Load Balancer, and use a `depends_on` between this resource and the Load Balancer Rule.
        """
        return pulumi.get(self, "load_balancer_inbound_nat_rules_ids")

    @_builtins.property
    @pulumi.getter
    def primary(self) -> Optional[_builtins.bool]:
        """
        Is this the Primary IP Configuration for this Network Interface? Defaults to `false`.

        > **Note:** One `ip_configuration` block must be marked as Primary for each Network Interface.
        """
        return pulumi.get(self, "primary")

    @_builtins.property
    @pulumi.getter(name="publicIpAddresses")
    def public_ip_addresses(self) -> Optional[Sequence['outputs.LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress']]:
        """
        A `public_ip_address` block as defined below.
        """
        return pulumi.get(self, "public_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Subnet which this IP Configuration should be connected to.

        > **Note:** `subnet_id` is required if `version` is set to `IPv4`.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The Internet Protocol Version which should be used for this IP Configuration. Possible values are `IPv4` and `IPv6`. Defaults to `IPv4`.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainNameLabel":
            suggest = "domain_name_label"
        elif key == "idleTimeoutInMinutes":
            suggest = "idle_timeout_in_minutes"
        elif key == "ipTags":
            suggest = "ip_tags"
        elif key == "publicIpPrefixId":
            suggest = "public_ip_prefix_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 domain_name_label: Optional[_builtins.str] = None,
                 idle_timeout_in_minutes: Optional[_builtins.int] = None,
                 ip_tags: Optional[Sequence['outputs.LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag']] = None,
                 public_ip_prefix_id: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The Name of the Public IP Address Configuration.
        :param _builtins.str domain_name_label: The Prefix which should be used for the Domain Name Label for each Virtual Machine Instance. Azure concatenates the Domain Name Label and Virtual Machine Index to create a unique Domain Name Label for each Virtual Machine.
        :param _builtins.int idle_timeout_in_minutes: The Idle Timeout in Minutes for the Public IP Address. Possible values are in the range `4` to `32`.
        :param Sequence['LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagArgs'] ip_tags: One or more `ip_tag` blocks as defined above. Changing this forces a new resource to be created.
        :param _builtins.str public_ip_prefix_id: The ID of the Public IP Address Prefix from where Public IP Addresses should be allocated. Changing this forces a new resource to be created.
               
               > **Note:** This functionality is in Preview and must be opted into via `az feature register --namespace Microsoft.Network --name AllowBringYourOwnPublicIpAddress` and then `az provider register -n Microsoft.Network`.
        :param _builtins.str version: The Internet Protocol Version which should be used for this public IP address. Possible values are `IPv4` and `IPv6`. Defaults to `IPv4`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "name", name)
        if domain_name_label is not None:
            pulumi.set(__self__, "domain_name_label", domain_name_label)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if ip_tags is not None:
            pulumi.set(__self__, "ip_tags", ip_tags)
        if public_ip_prefix_id is not None:
            pulumi.set(__self__, "public_ip_prefix_id", public_ip_prefix_id)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The Name of the Public IP Address Configuration.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="domainNameLabel")
    def domain_name_label(self) -> Optional[_builtins.str]:
        """
        The Prefix which should be used for the Domain Name Label for each Virtual Machine Instance. Azure concatenates the Domain Name Label and Virtual Machine Index to create a unique Domain Name Label for each Virtual Machine.
        """
        return pulumi.get(self, "domain_name_label")

    @_builtins.property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[_builtins.int]:
        """
        The Idle Timeout in Minutes for the Public IP Address. Possible values are in the range `4` to `32`.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @_builtins.property
    @pulumi.getter(name="ipTags")
    def ip_tags(self) -> Optional[Sequence['outputs.LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag']]:
        """
        One or more `ip_tag` blocks as defined above. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "ip_tags")

    @_builtins.property
    @pulumi.getter(name="publicIpPrefixId")
    def public_ip_prefix_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Public IP Address Prefix from where Public IP Addresses should be allocated. Changing this forces a new resource to be created.

        > **Note:** This functionality is in Preview and must be opted into via `az feature register --namespace Microsoft.Network --name AllowBringYourOwnPublicIpAddress` and then `az provider register -n Microsoft.Network`.
        """
        return pulumi.get(self, "public_ip_prefix_id")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The Internet Protocol Version which should be used for this public IP address. Possible values are `IPv4` and `IPv6`. Defaults to `IPv4`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class LinuxVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag(dict):
    def __init__(__self__, *,
                 tag: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str tag: The IP Tag associated with the Public IP, such as `SQL` or `Storage`. Changing this forces a new resource to be created.
        :param _builtins.str type: The Type of IP Tag, such as `FirstPartyUsage`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def tag(self) -> _builtins.str:
        """
        The IP Tag associated with the Public IP, such as `SQL` or `Storage`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The Type of IP Tag, such as `FirstPartyUsage`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class LinuxVirtualMachineScaleSetOsDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageAccountType":
            suggest = "storage_account_type"
        elif key == "diffDiskSettings":
            suggest = "diff_disk_settings"
        elif key == "diskEncryptionSetId":
            suggest = "disk_encryption_set_id"
        elif key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "secureVmDiskEncryptionSetId":
            suggest = "secure_vm_disk_encryption_set_id"
        elif key == "securityEncryptionType":
            suggest = "security_encryption_type"
        elif key == "writeAcceleratorEnabled":
            suggest = "write_accelerator_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxVirtualMachineScaleSetOsDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxVirtualMachineScaleSetOsDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxVirtualMachineScaleSetOsDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 caching: _builtins.str,
                 storage_account_type: _builtins.str,
                 diff_disk_settings: Optional['outputs.LinuxVirtualMachineScaleSetOsDiskDiffDiskSettings'] = None,
                 disk_encryption_set_id: Optional[_builtins.str] = None,
                 disk_size_gb: Optional[_builtins.int] = None,
                 secure_vm_disk_encryption_set_id: Optional[_builtins.str] = None,
                 security_encryption_type: Optional[_builtins.str] = None,
                 write_accelerator_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str caching: The Type of Caching which should be used for the Internal OS Disk. Possible values are `None`, `ReadOnly` and `ReadWrite`.
        :param _builtins.str storage_account_type: The Type of Storage Account which should back this the Internal OS Disk. Possible values include `Standard_LRS`, `StandardSSD_LRS`, `StandardSSD_ZRS`, `Premium_LRS` and `Premium_ZRS`. Changing this forces a new resource to be created.
        :param 'LinuxVirtualMachineScaleSetOsDiskDiffDiskSettingsArgs' diff_disk_settings: A `diff_disk_settings` block as defined above. Changing this forces a new resource to be created.
        :param _builtins.str disk_encryption_set_id: The ID of the Disk Encryption Set which should be used to encrypt this OS Disk. Conflicts with `secure_vm_disk_encryption_set_id`. Changing this forces a new resource to be created.
               
               > **Note:** The Disk Encryption Set must have the `Reader` Role Assignment scoped on the Key Vault - in addition to an Access Policy to the Key Vault
               
               > **Note:** Disk Encryption Sets are in Public Preview in a limited set of regions
        :param _builtins.int disk_size_gb: The Size of the Internal OS Disk in GB, if you wish to vary from the size used in the image this Virtual Machine Scale Set is sourced from.
               
               > **Note:** If specified this must be equal to or larger than the size of the Image the VM Scale Set is based on. When creating a larger disk than exists in the image you'll need to repartition the disk to use the remaining space.
        :param _builtins.str secure_vm_disk_encryption_set_id: The ID of the Disk Encryption Set which should be used to Encrypt the OS Disk when the Virtual Machine Scale Set is Confidential VMSS. Conflicts with `disk_encryption_set_id`. Changing this forces a new resource to be created.
               
               > **Note:** `secure_vm_disk_encryption_set_id` can only be specified when `security_encryption_type` is set to `DiskWithVMGuestState`.
        :param _builtins.str security_encryption_type: Encryption Type when the Virtual Machine Scale Set is Confidential VMSS. Possible values are `VMGuestStateOnly` and `DiskWithVMGuestState`. Changing this forces a new resource to be created.
               
               > **Note:** `vtpm_enabled` must be set to `true` when `security_encryption_type` is specified.
               
               > **Note:** `encryption_at_host_enabled` cannot be set to `true` when `security_encryption_type` is set to `DiskWithVMGuestState`.
        :param _builtins.bool write_accelerator_enabled: Should Write Accelerator be Enabled for this OS Disk? Defaults to `false`.
               
               > **Note:** This requires that the `storage_account_type` is set to `Premium_LRS` and that `caching` is set to `None`.
        """
        pulumi.set(__self__, "caching", caching)
        pulumi.set(__self__, "storage_account_type", storage_account_type)
        if diff_disk_settings is not None:
            pulumi.set(__self__, "diff_disk_settings", diff_disk_settings)
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if secure_vm_disk_encryption_set_id is not None:
            pulumi.set(__self__, "secure_vm_disk_encryption_set_id", secure_vm_disk_encryption_set_id)
        if security_encryption_type is not None:
            pulumi.set(__self__, "security_encryption_type", security_encryption_type)
        if write_accelerator_enabled is not None:
            pulumi.set(__self__, "write_accelerator_enabled", write_accelerator_enabled)

    @_builtins.property
    @pulumi.getter
    def caching(self) -> _builtins.str:
        """
        The Type of Caching which should be used for the Internal OS Disk. Possible values are `None`, `ReadOnly` and `ReadWrite`.
        """
        return pulumi.get(self, "caching")

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> _builtins.str:
        """
        The Type of Storage Account which should back this the Internal OS Disk. Possible values include `Standard_LRS`, `StandardSSD_LRS`, `StandardSSD_ZRS`, `Premium_LRS` and `Premium_ZRS`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_type")

    @_builtins.property
    @pulumi.getter(name="diffDiskSettings")
    def diff_disk_settings(self) -> Optional['outputs.LinuxVirtualMachineScaleSetOsDiskDiffDiskSettings']:
        """
        A `diff_disk_settings` block as defined above. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "diff_disk_settings")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Disk Encryption Set which should be used to encrypt this OS Disk. Conflicts with `secure_vm_disk_encryption_set_id`. Changing this forces a new resource to be created.

        > **Note:** The Disk Encryption Set must have the `Reader` Role Assignment scoped on the Key Vault - in addition to an Access Policy to the Key Vault

        > **Note:** Disk Encryption Sets are in Public Preview in a limited set of regions
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[_builtins.int]:
        """
        The Size of the Internal OS Disk in GB, if you wish to vary from the size used in the image this Virtual Machine Scale Set is sourced from.

        > **Note:** If specified this must be equal to or larger than the size of the Image the VM Scale Set is based on. When creating a larger disk than exists in the image you'll need to repartition the disk to use the remaining space.
        """
        return pulumi.get(self, "disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="secureVmDiskEncryptionSetId")
    def secure_vm_disk_encryption_set_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Disk Encryption Set which should be used to Encrypt the OS Disk when the Virtual Machine Scale Set is Confidential VMSS. Conflicts with `disk_encryption_set_id`. Changing this forces a new resource to be created.

        > **Note:** `secure_vm_disk_encryption_set_id` can only be specified when `security_encryption_type` is set to `DiskWithVMGuestState`.
        """
        return pulumi.get(self, "secure_vm_disk_encryption_set_id")

    @_builtins.property
    @pulumi.getter(name="securityEncryptionType")
    def security_encryption_type(self) -> Optional[_builtins.str]:
        """
        Encryption Type when the Virtual Machine Scale Set is Confidential VMSS. Possible values are `VMGuestStateOnly` and `DiskWithVMGuestState`. Changing this forces a new resource to be created.

        > **Note:** `vtpm_enabled` must be set to `true` when `security_encryption_type` is specified.

        > **Note:** `encryption_at_host_enabled` cannot be set to `true` when `security_encryption_type` is set to `DiskWithVMGuestState`.
        """
        return pulumi.get(self, "security_encryption_type")

    @_builtins.property
    @pulumi.getter(name="writeAcceleratorEnabled")
    def write_accelerator_enabled(self) -> Optional[_builtins.bool]:
        """
        Should Write Accelerator be Enabled for this OS Disk? Defaults to `false`.

        > **Note:** This requires that the `storage_account_type` is set to `Premium_LRS` and that `caching` is set to `None`.
        """
        return pulumi.get(self, "write_accelerator_enabled")


@pulumi.output_type
class LinuxVirtualMachineScaleSetOsDiskDiffDiskSettings(dict):
    def __init__(__self__, *,
                 option: _builtins.str,
                 placement: Optional[_builtins.str] = None):
        """
        :param _builtins.str option: Specifies the Ephemeral Disk Settings for the OS Disk. At this time the only possible value is `Local`. Changing this forces a new resource to be created.
        :param _builtins.str placement: Specifies where to store the Ephemeral Disk. Possible values are `CacheDisk` and `ResourceDisk`. Defaults to `CacheDisk`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "option", option)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)

    @_builtins.property
    @pulumi.getter
    def option(self) -> _builtins.str:
        """
        Specifies the Ephemeral Disk Settings for the OS Disk. At this time the only possible value is `Local`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "option")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Specifies where to store the Ephemeral Disk. Possible values are `CacheDisk` and `ResourceDisk`. Defaults to `CacheDisk`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "placement")


@pulumi.output_type
class LinuxVirtualMachineScaleSetPlan(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 product: _builtins.str,
                 publisher: _builtins.str):
        """
        :param _builtins.str name: Specifies the name of the image from the marketplace. Changing this forces a new resource to be created.
        :param _builtins.str product: Specifies the product of the image from the marketplace. Changing this forces a new resource to be created.
        :param _builtins.str publisher: Specifies the publisher of the image. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "publisher", publisher)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the image from the marketplace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def product(self) -> _builtins.str:
        """
        Specifies the product of the image from the marketplace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "product")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        """
        Specifies the publisher of the image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher")


@pulumi.output_type
class LinuxVirtualMachineScaleSetRollingUpgradePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxBatchInstancePercent":
            suggest = "max_batch_instance_percent"
        elif key == "maxUnhealthyInstancePercent":
            suggest = "max_unhealthy_instance_percent"
        elif key == "maxUnhealthyUpgradedInstancePercent":
            suggest = "max_unhealthy_upgraded_instance_percent"
        elif key == "pauseTimeBetweenBatches":
            suggest = "pause_time_between_batches"
        elif key == "crossZoneUpgradesEnabled":
            suggest = "cross_zone_upgrades_enabled"
        elif key == "maximumSurgeInstancesEnabled":
            suggest = "maximum_surge_instances_enabled"
        elif key == "prioritizeUnhealthyInstancesEnabled":
            suggest = "prioritize_unhealthy_instances_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxVirtualMachineScaleSetRollingUpgradePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxVirtualMachineScaleSetRollingUpgradePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxVirtualMachineScaleSetRollingUpgradePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_batch_instance_percent: _builtins.int,
                 max_unhealthy_instance_percent: _builtins.int,
                 max_unhealthy_upgraded_instance_percent: _builtins.int,
                 pause_time_between_batches: _builtins.str,
                 cross_zone_upgrades_enabled: Optional[_builtins.bool] = None,
                 maximum_surge_instances_enabled: Optional[_builtins.bool] = None,
                 prioritize_unhealthy_instances_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.int max_batch_instance_percent: The maximum percent of total virtual machine instances that will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum, unhealthy instances in previous or future batches can cause the percentage of instances in a batch to decrease to ensure higher reliability.
        :param _builtins.int max_unhealthy_instance_percent: The maximum percentage of the total virtual machine instances in the scale set that can be simultaneously unhealthy, either as a result of being upgraded, or by being found in an unhealthy state by the virtual machine health checks before the rolling upgrade aborts. This constraint will be checked prior to starting any batch.
        :param _builtins.int max_unhealthy_upgraded_instance_percent: The maximum percentage of upgraded virtual machine instances that can be found to be in an unhealthy state. This check will happen after each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts.
        :param _builtins.str pause_time_between_batches: The wait time between completing the update for all virtual machines in one batch and starting the next batch. The time duration should be specified in ISO 8601 format.
        :param _builtins.bool cross_zone_upgrades_enabled: Should the Virtual Machine Scale Set ignore the Azure Zone boundaries when constructing upgrade batches? Possible values are `true` or `false`.
        :param _builtins.bool maximum_surge_instances_enabled: Create new virtual machines to upgrade the scale set, rather than updating the existing virtual machines. Existing virtual machines will be deleted once the new virtual machines are created for each batch. Possible values are `true` or `false`.
               
               > **Note:** `overprovision` must be set to `false` when `maximum_surge_instances_enabled` is specified.
        :param _builtins.bool prioritize_unhealthy_instances_enabled: Upgrade all unhealthy instances in a scale set before any healthy instances. Possible values are `true` or `false`.
        """
        pulumi.set(__self__, "max_batch_instance_percent", max_batch_instance_percent)
        pulumi.set(__self__, "max_unhealthy_instance_percent", max_unhealthy_instance_percent)
        pulumi.set(__self__, "max_unhealthy_upgraded_instance_percent", max_unhealthy_upgraded_instance_percent)
        pulumi.set(__self__, "pause_time_between_batches", pause_time_between_batches)
        if cross_zone_upgrades_enabled is not None:
            pulumi.set(__self__, "cross_zone_upgrades_enabled", cross_zone_upgrades_enabled)
        if maximum_surge_instances_enabled is not None:
            pulumi.set(__self__, "maximum_surge_instances_enabled", maximum_surge_instances_enabled)
        if prioritize_unhealthy_instances_enabled is not None:
            pulumi.set(__self__, "prioritize_unhealthy_instances_enabled", prioritize_unhealthy_instances_enabled)

    @_builtins.property
    @pulumi.getter(name="maxBatchInstancePercent")
    def max_batch_instance_percent(self) -> _builtins.int:
        """
        The maximum percent of total virtual machine instances that will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum, unhealthy instances in previous or future batches can cause the percentage of instances in a batch to decrease to ensure higher reliability.
        """
        return pulumi.get(self, "max_batch_instance_percent")

    @_builtins.property
    @pulumi.getter(name="maxUnhealthyInstancePercent")
    def max_unhealthy_instance_percent(self) -> _builtins.int:
        """
        The maximum percentage of the total virtual machine instances in the scale set that can be simultaneously unhealthy, either as a result of being upgraded, or by being found in an unhealthy state by the virtual machine health checks before the rolling upgrade aborts. This constraint will be checked prior to starting any batch.
        """
        return pulumi.get(self, "max_unhealthy_instance_percent")

    @_builtins.property
    @pulumi.getter(name="maxUnhealthyUpgradedInstancePercent")
    def max_unhealthy_upgraded_instance_percent(self) -> _builtins.int:
        """
        The maximum percentage of upgraded virtual machine instances that can be found to be in an unhealthy state. This check will happen after each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts.
        """
        return pulumi.get(self, "max_unhealthy_upgraded_instance_percent")

    @_builtins.property
    @pulumi.getter(name="pauseTimeBetweenBatches")
    def pause_time_between_batches(self) -> _builtins.str:
        """
        The wait time between completing the update for all virtual machines in one batch and starting the next batch. The time duration should be specified in ISO 8601 format.
        """
        return pulumi.get(self, "pause_time_between_batches")

    @_builtins.property
    @pulumi.getter(name="crossZoneUpgradesEnabled")
    def cross_zone_upgrades_enabled(self) -> Optional[_builtins.bool]:
        """
        Should the Virtual Machine Scale Set ignore the Azure Zone boundaries when constructing upgrade batches? Possible values are `true` or `false`.
        """
        return pulumi.get(self, "cross_zone_upgrades_enabled")

    @_builtins.property
    @pulumi.getter(name="maximumSurgeInstancesEnabled")
    def maximum_surge_instances_enabled(self) -> Optional[_builtins.bool]:
        """
        Create new virtual machines to upgrade the scale set, rather than updating the existing virtual machines. Existing virtual machines will be deleted once the new virtual machines are created for each batch. Possible values are `true` or `false`.

        > **Note:** `overprovision` must be set to `false` when `maximum_surge_instances_enabled` is specified.
        """
        return pulumi.get(self, "maximum_surge_instances_enabled")

    @_builtins.property
    @pulumi.getter(name="prioritizeUnhealthyInstancesEnabled")
    def prioritize_unhealthy_instances_enabled(self) -> Optional[_builtins.bool]:
        """
        Upgrade all unhealthy instances in a scale set before any healthy instances. Possible values are `true` or `false`.
        """
        return pulumi.get(self, "prioritize_unhealthy_instances_enabled")


@pulumi.output_type
class LinuxVirtualMachineScaleSetScaleIn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forceDeletionEnabled":
            suggest = "force_deletion_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxVirtualMachineScaleSetScaleIn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxVirtualMachineScaleSetScaleIn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxVirtualMachineScaleSetScaleIn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 force_deletion_enabled: Optional[_builtins.bool] = None,
                 rule: Optional[_builtins.str] = None):
        """
        :param _builtins.bool force_deletion_enabled: Should the virtual machines chosen for removal be force deleted when the virtual machine scale set is being scaled-in? Possible values are `true` or `false`. Defaults to `false`.
        :param _builtins.str rule: The scale-in policy rule that decides which virtual machines are chosen for removal when a Virtual Machine Scale Set is scaled in. Possible values for the scale-in policy rules are `Default`, `NewestVM` and `OldestVM`, defaults to `Default`. For more information about scale in policy, please [refer to this doc](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-scale-in-policy).
        """
        if force_deletion_enabled is not None:
            pulumi.set(__self__, "force_deletion_enabled", force_deletion_enabled)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)

    @_builtins.property
    @pulumi.getter(name="forceDeletionEnabled")
    def force_deletion_enabled(self) -> Optional[_builtins.bool]:
        """
        Should the virtual machines chosen for removal be force deleted when the virtual machine scale set is being scaled-in? Possible values are `true` or `false`. Defaults to `false`.
        """
        return pulumi.get(self, "force_deletion_enabled")

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[_builtins.str]:
        """
        The scale-in policy rule that decides which virtual machines are chosen for removal when a Virtual Machine Scale Set is scaled in. Possible values for the scale-in policy rules are `Default`, `NewestVM` and `OldestVM`, defaults to `Default`. For more information about scale in policy, please [refer to this doc](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-scale-in-policy).
        """
        return pulumi.get(self, "rule")


@pulumi.output_type
class LinuxVirtualMachineScaleSetSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultId":
            suggest = "key_vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxVirtualMachineScaleSetSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxVirtualMachineScaleSetSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxVirtualMachineScaleSetSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificates: Sequence['outputs.LinuxVirtualMachineScaleSetSecretCertificate'],
                 key_vault_id: _builtins.str):
        """
        :param Sequence['LinuxVirtualMachineScaleSetSecretCertificateArgs'] certificates: One or more `certificate` blocks as defined above.
        :param _builtins.str key_vault_id: The ID of the Key Vault from which all Secrets should be sourced.
        """
        pulumi.set(__self__, "certificates", certificates)
        pulumi.set(__self__, "key_vault_id", key_vault_id)

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Sequence['outputs.LinuxVirtualMachineScaleSetSecretCertificate']:
        """
        One or more `certificate` blocks as defined above.
        """
        return pulumi.get(self, "certificates")

    @_builtins.property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> _builtins.str:
        """
        The ID of the Key Vault from which all Secrets should be sourced.
        """
        return pulumi.get(self, "key_vault_id")


@pulumi.output_type
class LinuxVirtualMachineScaleSetSecretCertificate(dict):
    def __init__(__self__, *,
                 url: _builtins.str):
        """
        :param _builtins.str url: The Secret URL of a Key Vault Certificate.
               
               > **Note:** This can be sourced from the `secret_id` field within the `keyvault.Certificate` Resource.
               
               > **Note:** The certificate must have been uploaded/created in PFX format, PEM certificates are not currently supported by Azure.
        """
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The Secret URL of a Key Vault Certificate.

        > **Note:** This can be sourced from the `secret_id` field within the `keyvault.Certificate` Resource.

        > **Note:** The certificate must have been uploaded/created in PFX format, PEM certificates are not currently supported by Azure.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class LinuxVirtualMachineScaleSetSourceImageReference(dict):
    def __init__(__self__, *,
                 offer: _builtins.str,
                 publisher: _builtins.str,
                 sku: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str offer: Specifies the offer of the image used to create the virtual machines. Changing this forces a new resource to be created.
        :param _builtins.str publisher: Specifies the publisher of the image used to create the virtual machines. Changing this forces a new resource to be created.
        :param _builtins.str sku: Specifies the SKU of the image used to create the virtual machines.
        :param _builtins.str version: Specifies the version of the image used to create the virtual machines.
        """
        pulumi.set(__self__, "offer", offer)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "sku", sku)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def offer(self) -> _builtins.str:
        """
        Specifies the offer of the image used to create the virtual machines. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "offer")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        """
        Specifies the publisher of the image used to create the virtual machines. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> _builtins.str:
        """
        Specifies the SKU of the image used to create the virtual machines.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Specifies the version of the image used to create the virtual machines.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class LinuxVirtualMachineScaleSetSpotRestore(dict):
    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 timeout: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Should the Spot-Try-Restore feature be enabled? The Spot-Try-Restore feature will attempt to automatically restore the evicted Spot Virtual Machine Scale Set VM instances opportunistically based on capacity availability and pricing constraints. Possible values are `true` or `false`. Defaults to `false`. Changing this forces a new resource to be created.
        :param _builtins.str timeout: The length of time that the Virtual Machine Scale Set should attempt to restore the Spot VM instances which have been evicted. The time duration should be between `15` minutes and `120` minutes (inclusive). The time duration should be specified in the ISO 8601 format. Defaults to `PT1H`. Changing this forces a new resource to be created.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Should the Spot-Try-Restore feature be enabled? The Spot-Try-Restore feature will attempt to automatically restore the evicted Spot Virtual Machine Scale Set VM instances opportunistically based on capacity availability and pricing constraints. Possible values are `true` or `false`. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.str]:
        """
        The length of time that the Virtual Machine Scale Set should attempt to restore the Spot VM instances which have been evicted. The time duration should be between `15` minutes and `120` minutes (inclusive). The time duration should be specified in the ISO 8601 format. Defaults to `PT1H`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class LinuxVirtualMachineScaleSetTerminationNotification(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 timeout: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Should the termination notification be enabled on this Virtual Machine Scale Set?
        :param _builtins.str timeout: Length of time (in minutes, between 5 and 15) a notification to be sent to the VM on the instance metadata server till the VM gets deleted. The time duration should be specified in ISO 8601 format. Defaults to `PT5M`.
               
               > **Note:** For more information about the termination notification, please [refer to this doc](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-terminate-notification).
        """
        pulumi.set(__self__, "enabled", enabled)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Should the termination notification be enabled on this Virtual Machine Scale Set?
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.str]:
        """
        Length of time (in minutes, between 5 and 15) a notification to be sent to the VM on the instance metadata server till the VM gets deleted. The time duration should be specified in ISO 8601 format. Defaults to `PT5M`.

        > **Note:** For more information about the termination notification, please [refer to this doc](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-terminate-notification).
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class LinuxVirtualMachineSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultId":
            suggest = "key_vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LinuxVirtualMachineSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LinuxVirtualMachineSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LinuxVirtualMachineSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificates: Sequence['outputs.LinuxVirtualMachineSecretCertificate'],
                 key_vault_id: _builtins.str):
        """
        :param Sequence['LinuxVirtualMachineSecretCertificateArgs'] certificates: One or more `certificate` blocks as defined above.
        :param _builtins.str key_vault_id: The ID of the Key Vault from which all Secrets should be sourced.
        """
        pulumi.set(__self__, "certificates", certificates)
        pulumi.set(__self__, "key_vault_id", key_vault_id)

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Sequence['outputs.LinuxVirtualMachineSecretCertificate']:
        """
        One or more `certificate` blocks as defined above.
        """
        return pulumi.get(self, "certificates")

    @_builtins.property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> _builtins.str:
        """
        The ID of the Key Vault from which all Secrets should be sourced.
        """
        return pulumi.get(self, "key_vault_id")


@pulumi.output_type
class LinuxVirtualMachineSecretCertificate(dict):
    def __init__(__self__, *,
                 url: _builtins.str):
        """
        :param _builtins.str url: The Secret URL of a Key Vault Certificate.
               
               > **NOTE:** This can be sourced from the `secret_id` field within the `keyvault.Certificate` Resource.
        """
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The Secret URL of a Key Vault Certificate.

        > **NOTE:** This can be sourced from the `secret_id` field within the `keyvault.Certificate` Resource.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class LinuxVirtualMachineSourceImageReference(dict):
    def __init__(__self__, *,
                 offer: _builtins.str,
                 publisher: _builtins.str,
                 sku: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str offer: Specifies the offer of the image used to create the virtual machines. Changing this forces a new resource to be created.
        :param _builtins.str publisher: Specifies the publisher of the image used to create the virtual machines. Changing this forces a new resource to be created.
        :param _builtins.str sku: Specifies the SKU of the image used to create the virtual machines. Changing this forces a new resource to be created.
        :param _builtins.str version: Specifies the version of the image used to create the virtual machines. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "offer", offer)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "sku", sku)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def offer(self) -> _builtins.str:
        """
        Specifies the offer of the image used to create the virtual machines. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "offer")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        """
        Specifies the publisher of the image used to create the virtual machines. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> _builtins.str:
        """
        Specifies the SKU of the image used to create the virtual machines. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Specifies the version of the image used to create the virtual machines. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class LinuxVirtualMachineTerminationNotification(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 timeout: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Should the termination notification be enabled on this Virtual Machine?
        :param _builtins.str timeout: Length of time (in minutes, between `5` and `15`) a notification to be sent to the VM on the instance metadata server till the VM gets deleted. The time duration should be specified in ISO 8601 format. Defaults to `PT5M`.
               
               > **NOTE:** For more information about the termination notification, please [refer to this doc](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-terminate-notification).
        """
        pulumi.set(__self__, "enabled", enabled)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Should the termination notification be enabled on this Virtual Machine?
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.str]:
        """
        Length of time (in minutes, between `5` and `15`) a notification to be sent to the VM on the instance metadata server till the VM gets deleted. The time duration should be specified in ISO 8601 format. Defaults to `PT5M`.

        > **NOTE:** For more information about the termination notification, please [refer to this doc](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-terminate-notification).
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class ManagedDiskEncryptionSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskEncryptionKey":
            suggest = "disk_encryption_key"
        elif key == "keyEncryptionKey":
            suggest = "key_encryption_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDiskEncryptionSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDiskEncryptionSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDiskEncryptionSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_encryption_key: 'outputs.ManagedDiskEncryptionSettingsDiskEncryptionKey',
                 key_encryption_key: Optional['outputs.ManagedDiskEncryptionSettingsKeyEncryptionKey'] = None):
        """
        :param 'ManagedDiskEncryptionSettingsDiskEncryptionKeyArgs' disk_encryption_key: A `disk_encryption_key` block as defined above.
        :param 'ManagedDiskEncryptionSettingsKeyEncryptionKeyArgs' key_encryption_key: A `key_encryption_key` block as defined below.
        """
        pulumi.set(__self__, "disk_encryption_key", disk_encryption_key)
        if key_encryption_key is not None:
            pulumi.set(__self__, "key_encryption_key", key_encryption_key)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionKey")
    def disk_encryption_key(self) -> 'outputs.ManagedDiskEncryptionSettingsDiskEncryptionKey':
        """
        A `disk_encryption_key` block as defined above.
        """
        return pulumi.get(self, "disk_encryption_key")

    @_builtins.property
    @pulumi.getter(name="keyEncryptionKey")
    def key_encryption_key(self) -> Optional['outputs.ManagedDiskEncryptionSettingsKeyEncryptionKey']:
        """
        A `key_encryption_key` block as defined below.
        """
        return pulumi.get(self, "key_encryption_key")


@pulumi.output_type
class ManagedDiskEncryptionSettingsDiskEncryptionKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretUrl":
            suggest = "secret_url"
        elif key == "sourceVaultId":
            suggest = "source_vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDiskEncryptionSettingsDiskEncryptionKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDiskEncryptionSettingsDiskEncryptionKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDiskEncryptionSettingsDiskEncryptionKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_url: _builtins.str,
                 source_vault_id: _builtins.str):
        """
        :param _builtins.str secret_url: The URL to the Key Vault Secret used as the Disk Encryption Key. This can be found as `id` on the `keyvault.Secret` resource.
        :param _builtins.str source_vault_id: The ID of the source Key Vault. This can be found as `id` on the `keyvault.KeyVault` resource.
        """
        pulumi.set(__self__, "secret_url", secret_url)
        pulumi.set(__self__, "source_vault_id", source_vault_id)

    @_builtins.property
    @pulumi.getter(name="secretUrl")
    def secret_url(self) -> _builtins.str:
        """
        The URL to the Key Vault Secret used as the Disk Encryption Key. This can be found as `id` on the `keyvault.Secret` resource.
        """
        return pulumi.get(self, "secret_url")

    @_builtins.property
    @pulumi.getter(name="sourceVaultId")
    def source_vault_id(self) -> _builtins.str:
        """
        The ID of the source Key Vault. This can be found as `id` on the `keyvault.KeyVault` resource.
        """
        return pulumi.get(self, "source_vault_id")


@pulumi.output_type
class ManagedDiskEncryptionSettingsKeyEncryptionKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyUrl":
            suggest = "key_url"
        elif key == "sourceVaultId":
            suggest = "source_vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedDiskEncryptionSettingsKeyEncryptionKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedDiskEncryptionSettingsKeyEncryptionKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedDiskEncryptionSettingsKeyEncryptionKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_url: _builtins.str,
                 source_vault_id: _builtins.str):
        """
        :param _builtins.str key_url: The URL to the Key Vault Key used as the Key Encryption Key. This can be found as `id` on the `keyvault.Key` resource.
        :param _builtins.str source_vault_id: The ID of the source Key Vault. This can be found as `id` on the `keyvault.KeyVault` resource.
        """
        pulumi.set(__self__, "key_url", key_url)
        pulumi.set(__self__, "source_vault_id", source_vault_id)

    @_builtins.property
    @pulumi.getter(name="keyUrl")
    def key_url(self) -> _builtins.str:
        """
        The URL to the Key Vault Key used as the Key Encryption Key. This can be found as `id` on the `keyvault.Key` resource.
        """
        return pulumi.get(self, "key_url")

    @_builtins.property
    @pulumi.getter(name="sourceVaultId")
    def source_vault_id(self) -> _builtins.str:
        """
        The ID of the source Key Vault. This can be found as `id` on the `keyvault.KeyVault` resource.
        """
        return pulumi.get(self, "source_vault_id")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetAdditionalCapabilities(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ultraSsdEnabled":
            suggest = "ultra_ssd_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrchestratedVirtualMachineScaleSetAdditionalCapabilities. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrchestratedVirtualMachineScaleSetAdditionalCapabilities.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrchestratedVirtualMachineScaleSetAdditionalCapabilities.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ultra_ssd_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool ultra_ssd_enabled: Should the capacity to enable Data Disks of the `UltraSSD_LRS` storage account type be supported on this Virtual Machine Scale Set? Defaults to `false`. Changing this forces a new resource to be created.
        """
        if ultra_ssd_enabled is not None:
            pulumi.set(__self__, "ultra_ssd_enabled", ultra_ssd_enabled)

    @_builtins.property
    @pulumi.getter(name="ultraSsdEnabled")
    def ultra_ssd_enabled(self) -> Optional[_builtins.bool]:
        """
        Should the capacity to enable Data Disks of the `UltraSSD_LRS` storage account type be supported on this Virtual Machine Scale Set? Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "ultra_ssd_enabled")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetAutomaticInstanceRepair(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gracePeriod":
            suggest = "grace_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrchestratedVirtualMachineScaleSetAutomaticInstanceRepair. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrchestratedVirtualMachineScaleSetAutomaticInstanceRepair.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrchestratedVirtualMachineScaleSetAutomaticInstanceRepair.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 action: Optional[_builtins.str] = None,
                 grace_period: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Should the automatic instance repair be enabled on this Virtual Machine Scale Set? Possible values are `true` and `false`.
        :param _builtins.str action: The repair action that will be used for repairing unhealthy virtual machines in the scale set. Possible values include `Replace`, `Restart`, `Reimage`.
               
               > **Note:** Once the `action` field has been set it will always return the last value it was assigned if it is removed from the configuration file.
               
               > **Note:** If you wish to update the repair `action` of an existing `automatic_instance_repair` policy, you must first `disable` the `automatic_instance_repair` policy before you can re-enable the `automatic_instance_repair` policy with the new repair `action` defined.
        :param _builtins.str grace_period: Amount of time for which automatic repairs will be delayed. The grace period starts right after the VM is found unhealthy. Possible values are between `10` and `90` minutes. The time duration should be specified in `ISO 8601` format (e.g. `PT10M` to `PT90M`).
               
               > **Note:** Once the `grace_period` field has been set it will always return the last value it was assigned if it is removed from the configuration file.
        """
        pulumi.set(__self__, "enabled", enabled)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if grace_period is not None:
            pulumi.set(__self__, "grace_period", grace_period)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Should the automatic instance repair be enabled on this Virtual Machine Scale Set? Possible values are `true` and `false`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        """
        The repair action that will be used for repairing unhealthy virtual machines in the scale set. Possible values include `Replace`, `Restart`, `Reimage`.

        > **Note:** Once the `action` field has been set it will always return the last value it was assigned if it is removed from the configuration file.

        > **Note:** If you wish to update the repair `action` of an existing `automatic_instance_repair` policy, you must first `disable` the `automatic_instance_repair` policy before you can re-enable the `automatic_instance_repair` policy with the new repair `action` defined.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> Optional[_builtins.str]:
        """
        Amount of time for which automatic repairs will be delayed. The grace period starts right after the VM is found unhealthy. Possible values are between `10` and `90` minutes. The time duration should be specified in `ISO 8601` format (e.g. `PT10M` to `PT90M`).

        > **Note:** Once the `grace_period` field has been set it will always return the last value it was assigned if it is removed from the configuration file.
        """
        return pulumi.get(self, "grace_period")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetBootDiagnostics(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageAccountUri":
            suggest = "storage_account_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrchestratedVirtualMachineScaleSetBootDiagnostics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrchestratedVirtualMachineScaleSetBootDiagnostics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrchestratedVirtualMachineScaleSetBootDiagnostics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_account_uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str storage_account_uri: The Primary/Secondary Endpoint for the Azure Storage Account which should be used to store Boot Diagnostics, including Console Output and Screenshots from the Hypervisor. By including a `boot_diagnostics` block without passing the `storage_account_uri` field will cause the API to utilize a Managed Storage Account to store the Boot Diagnostics output.
        """
        if storage_account_uri is not None:
            pulumi.set(__self__, "storage_account_uri", storage_account_uri)

    @_builtins.property
    @pulumi.getter(name="storageAccountUri")
    def storage_account_uri(self) -> Optional[_builtins.str]:
        """
        The Primary/Secondary Endpoint for the Azure Storage Account which should be used to store Boot Diagnostics, including Console Output and Screenshots from the Hypervisor. By including a `boot_diagnostics` block without passing the `storage_account_uri` field will cause the API to utilize a Managed Storage Account to store the Boot Diagnostics output.
        """
        return pulumi.get(self, "storage_account_uri")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageAccountType":
            suggest = "storage_account_type"
        elif key == "createOption":
            suggest = "create_option"
        elif key == "diskEncryptionSetId":
            suggest = "disk_encryption_set_id"
        elif key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "ultraSsdDiskIopsReadWrite":
            suggest = "ultra_ssd_disk_iops_read_write"
        elif key == "ultraSsdDiskMbpsReadWrite":
            suggest = "ultra_ssd_disk_mbps_read_write"
        elif key == "writeAcceleratorEnabled":
            suggest = "write_accelerator_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrchestratedVirtualMachineScaleSetDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrchestratedVirtualMachineScaleSetDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrchestratedVirtualMachineScaleSetDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 caching: _builtins.str,
                 storage_account_type: _builtins.str,
                 create_option: Optional[_builtins.str] = None,
                 disk_encryption_set_id: Optional[_builtins.str] = None,
                 disk_size_gb: Optional[_builtins.int] = None,
                 lun: Optional[_builtins.int] = None,
                 ultra_ssd_disk_iops_read_write: Optional[_builtins.int] = None,
                 ultra_ssd_disk_mbps_read_write: Optional[_builtins.int] = None,
                 write_accelerator_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str caching: The type of Caching which should be used for this Data Disk. Possible values are None, ReadOnly and ReadWrite.
        :param _builtins.str storage_account_type: The Type of Storage Account which should back this Data Disk. Possible values include `Standard_LRS`, `StandardSSD_LRS`, `StandardSSD_ZRS`, `Premium_LRS`, `PremiumV2_LRS`, `Premium_ZRS` and `UltraSSD_LRS`.
        :param _builtins.str create_option: The create option which should be used for this Data Disk. Possible values are Empty and FromImage. Defaults to `Empty`. (FromImage should only be used if the source image includes data disks).
        :param _builtins.str disk_encryption_set_id: The ID of the Disk Encryption Set which should be used to encrypt the Data Disk. Changing this forces a new resource to be created.
        :param _builtins.int disk_size_gb: The size of the Data Disk which should be created. Required if `create_option` is specified as `Empty`.
        :param _builtins.int lun: The Logical Unit Number of the Data Disk, which must be unique within the Virtual Machine. Required if `create_option` is specified as `Empty`.
        :param _builtins.int ultra_ssd_disk_iops_read_write: Specifies the Read-Write IOPS for this Data Disk. Only settable when `storage_account_type` is `PremiumV2_LRS` or `UltraSSD_LRS`.
        :param _builtins.int ultra_ssd_disk_mbps_read_write: Specifies the bandwidth in MB per second for this Data Disk. Only settable when `storage_account_type` is `PremiumV2_LRS` or `UltraSSD_LRS`.
        :param _builtins.bool write_accelerator_enabled: Specifies if Write Accelerator is enabled on the Data Disk. Defaults to `false`.
        """
        pulumi.set(__self__, "caching", caching)
        pulumi.set(__self__, "storage_account_type", storage_account_type)
        if create_option is not None:
            pulumi.set(__self__, "create_option", create_option)
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if lun is not None:
            pulumi.set(__self__, "lun", lun)
        if ultra_ssd_disk_iops_read_write is not None:
            pulumi.set(__self__, "ultra_ssd_disk_iops_read_write", ultra_ssd_disk_iops_read_write)
        if ultra_ssd_disk_mbps_read_write is not None:
            pulumi.set(__self__, "ultra_ssd_disk_mbps_read_write", ultra_ssd_disk_mbps_read_write)
        if write_accelerator_enabled is not None:
            pulumi.set(__self__, "write_accelerator_enabled", write_accelerator_enabled)

    @_builtins.property
    @pulumi.getter
    def caching(self) -> _builtins.str:
        """
        The type of Caching which should be used for this Data Disk. Possible values are None, ReadOnly and ReadWrite.
        """
        return pulumi.get(self, "caching")

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> _builtins.str:
        """
        The Type of Storage Account which should back this Data Disk. Possible values include `Standard_LRS`, `StandardSSD_LRS`, `StandardSSD_ZRS`, `Premium_LRS`, `PremiumV2_LRS`, `Premium_ZRS` and `UltraSSD_LRS`.
        """
        return pulumi.get(self, "storage_account_type")

    @_builtins.property
    @pulumi.getter(name="createOption")
    def create_option(self) -> Optional[_builtins.str]:
        """
        The create option which should be used for this Data Disk. Possible values are Empty and FromImage. Defaults to `Empty`. (FromImage should only be used if the source image includes data disks).
        """
        return pulumi.get(self, "create_option")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Disk Encryption Set which should be used to encrypt the Data Disk. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[_builtins.int]:
        """
        The size of the Data Disk which should be created. Required if `create_option` is specified as `Empty`.
        """
        return pulumi.get(self, "disk_size_gb")

    @_builtins.property
    @pulumi.getter
    def lun(self) -> Optional[_builtins.int]:
        """
        The Logical Unit Number of the Data Disk, which must be unique within the Virtual Machine. Required if `create_option` is specified as `Empty`.
        """
        return pulumi.get(self, "lun")

    @_builtins.property
    @pulumi.getter(name="ultraSsdDiskIopsReadWrite")
    def ultra_ssd_disk_iops_read_write(self) -> Optional[_builtins.int]:
        """
        Specifies the Read-Write IOPS for this Data Disk. Only settable when `storage_account_type` is `PremiumV2_LRS` or `UltraSSD_LRS`.
        """
        return pulumi.get(self, "ultra_ssd_disk_iops_read_write")

    @_builtins.property
    @pulumi.getter(name="ultraSsdDiskMbpsReadWrite")
    def ultra_ssd_disk_mbps_read_write(self) -> Optional[_builtins.int]:
        """
        Specifies the bandwidth in MB per second for this Data Disk. Only settable when `storage_account_type` is `PremiumV2_LRS` or `UltraSSD_LRS`.
        """
        return pulumi.get(self, "ultra_ssd_disk_mbps_read_write")

    @_builtins.property
    @pulumi.getter(name="writeAcceleratorEnabled")
    def write_accelerator_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies if Write Accelerator is enabled on the Data Disk. Defaults to `false`.
        """
        return pulumi.get(self, "write_accelerator_enabled")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetExtension(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "typeHandlerVersion":
            suggest = "type_handler_version"
        elif key == "autoUpgradeMinorVersionEnabled":
            suggest = "auto_upgrade_minor_version_enabled"
        elif key == "extensionsToProvisionAfterVmCreations":
            suggest = "extensions_to_provision_after_vm_creations"
        elif key == "failureSuppressionEnabled":
            suggest = "failure_suppression_enabled"
        elif key == "forceExtensionExecutionOnChange":
            suggest = "force_extension_execution_on_change"
        elif key == "protectedSettings":
            suggest = "protected_settings"
        elif key == "protectedSettingsFromKeyVault":
            suggest = "protected_settings_from_key_vault"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrchestratedVirtualMachineScaleSetExtension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrchestratedVirtualMachineScaleSetExtension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrchestratedVirtualMachineScaleSetExtension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 publisher: _builtins.str,
                 type: _builtins.str,
                 type_handler_version: _builtins.str,
                 auto_upgrade_minor_version_enabled: Optional[_builtins.bool] = None,
                 extensions_to_provision_after_vm_creations: Optional[Sequence[_builtins.str]] = None,
                 failure_suppression_enabled: Optional[_builtins.bool] = None,
                 force_extension_execution_on_change: Optional[_builtins.str] = None,
                 protected_settings: Optional[_builtins.str] = None,
                 protected_settings_from_key_vault: Optional['outputs.OrchestratedVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault'] = None,
                 settings: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name for the Virtual Machine Scale Set Extension.
        :param _builtins.str publisher: Specifies the Publisher of the Extension.
        :param _builtins.str type: Specifies the Type of the Extension.
        :param _builtins.str type_handler_version: Specifies the version of the extension to use, available versions can be found using the Azure CLI.
        :param _builtins.bool auto_upgrade_minor_version_enabled: Should the latest version of the Extension be used at Deployment Time, if one is available? This won't auto-update the extension on existing installation. Defaults to `true`.
        :param Sequence[_builtins.str] extensions_to_provision_after_vm_creations: An ordered list of Extension names which Virtual Machine Scale Set should provision after VM creation.
        :param _builtins.bool failure_suppression_enabled: Should failures from the extension be suppressed? Possible values are `true` or `false`.
               
               > **Note:** Operational failures such as not connecting to the VM will not be suppressed regardless of the `failure_suppression_enabled` value.
        :param _builtins.str force_extension_execution_on_change: A value which, when different to the previous value can be used to force-run the Extension even if the Extension Configuration hasn't changed.
        :param _builtins.str protected_settings: A JSON String which specifies Sensitive Settings (such as Passwords) for the Extension.
               
               > **Note:** Keys within the `protected_settings` block are notoriously case-sensitive, where the casing required (e.g. `TitleCase` vs `snakeCase`) depends on the Extension being used. Please refer to the documentation for the specific Virtual Machine Extension you're looking to use for more information.
        :param 'OrchestratedVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultArgs' protected_settings_from_key_vault: A `protected_settings_from_key_vault` block as defined below.
               
               > **Note:** `protected_settings_from_key_vault` cannot be used with `protected_settings`
        :param _builtins.str settings: A JSON String which specifies Settings for the Extension.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "type_handler_version", type_handler_version)
        if auto_upgrade_minor_version_enabled is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version_enabled", auto_upgrade_minor_version_enabled)
        if extensions_to_provision_after_vm_creations is not None:
            pulumi.set(__self__, "extensions_to_provision_after_vm_creations", extensions_to_provision_after_vm_creations)
        if failure_suppression_enabled is not None:
            pulumi.set(__self__, "failure_suppression_enabled", failure_suppression_enabled)
        if force_extension_execution_on_change is not None:
            pulumi.set(__self__, "force_extension_execution_on_change", force_extension_execution_on_change)
        if protected_settings is not None:
            pulumi.set(__self__, "protected_settings", protected_settings)
        if protected_settings_from_key_vault is not None:
            pulumi.set(__self__, "protected_settings_from_key_vault", protected_settings_from_key_vault)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name for the Virtual Machine Scale Set Extension.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        """
        Specifies the Publisher of the Extension.
        """
        return pulumi.get(self, "publisher")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the Type of the Extension.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> _builtins.str:
        """
        Specifies the version of the extension to use, available versions can be found using the Azure CLI.
        """
        return pulumi.get(self, "type_handler_version")

    @_builtins.property
    @pulumi.getter(name="autoUpgradeMinorVersionEnabled")
    def auto_upgrade_minor_version_enabled(self) -> Optional[_builtins.bool]:
        """
        Should the latest version of the Extension be used at Deployment Time, if one is available? This won't auto-update the extension on existing installation. Defaults to `true`.
        """
        return pulumi.get(self, "auto_upgrade_minor_version_enabled")

    @_builtins.property
    @pulumi.getter(name="extensionsToProvisionAfterVmCreations")
    def extensions_to_provision_after_vm_creations(self) -> Optional[Sequence[_builtins.str]]:
        """
        An ordered list of Extension names which Virtual Machine Scale Set should provision after VM creation.
        """
        return pulumi.get(self, "extensions_to_provision_after_vm_creations")

    @_builtins.property
    @pulumi.getter(name="failureSuppressionEnabled")
    def failure_suppression_enabled(self) -> Optional[_builtins.bool]:
        """
        Should failures from the extension be suppressed? Possible values are `true` or `false`.

        > **Note:** Operational failures such as not connecting to the VM will not be suppressed regardless of the `failure_suppression_enabled` value.
        """
        return pulumi.get(self, "failure_suppression_enabled")

    @_builtins.property
    @pulumi.getter(name="forceExtensionExecutionOnChange")
    def force_extension_execution_on_change(self) -> Optional[_builtins.str]:
        """
        A value which, when different to the previous value can be used to force-run the Extension even if the Extension Configuration hasn't changed.
        """
        return pulumi.get(self, "force_extension_execution_on_change")

    @_builtins.property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> Optional[_builtins.str]:
        """
        A JSON String which specifies Sensitive Settings (such as Passwords) for the Extension.

        > **Note:** Keys within the `protected_settings` block are notoriously case-sensitive, where the casing required (e.g. `TitleCase` vs `snakeCase`) depends on the Extension being used. Please refer to the documentation for the specific Virtual Machine Extension you're looking to use for more information.
        """
        return pulumi.get(self, "protected_settings")

    @_builtins.property
    @pulumi.getter(name="protectedSettingsFromKeyVault")
    def protected_settings_from_key_vault(self) -> Optional['outputs.OrchestratedVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault']:
        """
        A `protected_settings_from_key_vault` block as defined below.

        > **Note:** `protected_settings_from_key_vault` cannot be used with `protected_settings`
        """
        return pulumi.get(self, "protected_settings_from_key_vault")

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[_builtins.str]:
        """
        A JSON String which specifies Settings for the Extension.
        """
        return pulumi.get(self, "settings")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretUrl":
            suggest = "secret_url"
        elif key == "sourceVaultId":
            suggest = "source_vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrchestratedVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrchestratedVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrchestratedVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_url: _builtins.str,
                 source_vault_id: _builtins.str):
        """
        :param _builtins.str secret_url: The URL to the Key Vault Secret which stores the protected settings.
        :param _builtins.str source_vault_id: The ID of the source Key Vault.
        """
        pulumi.set(__self__, "secret_url", secret_url)
        pulumi.set(__self__, "source_vault_id", source_vault_id)

    @_builtins.property
    @pulumi.getter(name="secretUrl")
    def secret_url(self) -> _builtins.str:
        """
        The URL to the Key Vault Secret which stores the protected settings.
        """
        return pulumi.get(self, "secret_url")

    @_builtins.property
    @pulumi.getter(name="sourceVaultId")
    def source_vault_id(self) -> _builtins.str:
        """
        The ID of the source Key Vault.
        """
        return pulumi.get(self, "source_vault_id")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrchestratedVirtualMachineScaleSetIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrchestratedVirtualMachineScaleSetIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrchestratedVirtualMachineScaleSetIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_ids: Sequence[_builtins.str],
                 type: _builtins.str):
        """
        :param Sequence[_builtins.str] identity_ids: Specifies a list of User Managed Identity IDs to be assigned to this Windows Virtual Machine Scale Set.
        :param _builtins.str type: The type of Managed Identity that should be configured on this Windows Virtual Machine Scale Set. Only possible value is `UserAssigned`.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[_builtins.str]:
        """
        Specifies a list of User Managed Identity IDs to be assigned to this Windows Virtual Machine Scale Set.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of Managed Identity that should be configured on this Windows Virtual Machine Scale Set. Only possible value is `UserAssigned`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetNetworkInterface(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipConfigurations":
            suggest = "ip_configurations"
        elif key == "auxiliaryMode":
            suggest = "auxiliary_mode"
        elif key == "auxiliarySku":
            suggest = "auxiliary_sku"
        elif key == "dnsServers":
            suggest = "dns_servers"
        elif key == "enableAcceleratedNetworking":
            suggest = "enable_accelerated_networking"
        elif key == "enableIpForwarding":
            suggest = "enable_ip_forwarding"
        elif key == "networkSecurityGroupId":
            suggest = "network_security_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrchestratedVirtualMachineScaleSetNetworkInterface. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrchestratedVirtualMachineScaleSetNetworkInterface.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrchestratedVirtualMachineScaleSetNetworkInterface.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_configurations: Sequence['outputs.OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfiguration'],
                 name: _builtins.str,
                 auxiliary_mode: Optional[_builtins.str] = None,
                 auxiliary_sku: Optional[_builtins.str] = None,
                 dns_servers: Optional[Sequence[_builtins.str]] = None,
                 enable_accelerated_networking: Optional[_builtins.bool] = None,
                 enable_ip_forwarding: Optional[_builtins.bool] = None,
                 network_security_group_id: Optional[_builtins.str] = None,
                 primary: Optional[_builtins.bool] = None):
        """
        :param Sequence['OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationArgs'] ip_configurations: One or more `ip_configuration` blocks as defined above.
        :param _builtins.str name: The Name which should be used for this Network Interface. Changing this forces a new resource to be created.
        :param _builtins.str auxiliary_mode: Specifies the auxiliary mode used to enable network high-performance feature on Network Virtual Appliances (NVAs). This feature offers competitive performance in Connections Per Second (CPS) optimization, along with improvements to handling large amounts of simultaneous connections. Possible values are `AcceleratedConnections` and `Floating`.
               
               > **Note:** `auxiliary_mode` is in **Preview** and requires that the prerequisites are enabled - [more information can be found in the Azure documentation](https://learn.microsoft.com/azure/networking/nva-accelerated-connections#prerequisites).
        :param _builtins.str auxiliary_sku: Specifies the SKU used for the network high-performance feature on Network Virtual Appliances (NVAs). Possible values are `A1`, `A2`, `A4` and `A8`.
               
               > **Note:** `auxiliary_sku` is in **Preview** and requires that the prerequisites are enabled - [more information can be found in the Azure documentation](https://learn.microsoft.com/azure/networking/nva-accelerated-connections#prerequisites).
        :param Sequence[_builtins.str] dns_servers: A list of IP Addresses of DNS Servers which should be assigned to the Network Interface.
        :param _builtins.bool enable_accelerated_networking: Does this Network Interface support Accelerated Networking? Possible values are `true` and `false`. Defaults to `false`.
        :param _builtins.bool enable_ip_forwarding: Does this Network Interface support IP Forwarding? Possible values are `true` and `false`. Defaults to `false`.
        :param _builtins.str network_security_group_id: The ID of a Network Security Group which should be assigned to this Network Interface.
        :param _builtins.bool primary: Is this the Primary IP Configuration? Possible values are `true` and `false`. Defaults to `false`.
               
               > **Note:** If multiple `network_interface` blocks are specified, one must be set to `primary`.
        """
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        pulumi.set(__self__, "name", name)
        if auxiliary_mode is not None:
            pulumi.set(__self__, "auxiliary_mode", auxiliary_mode)
        if auxiliary_sku is not None:
            pulumi.set(__self__, "auxiliary_sku", auxiliary_sku)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if enable_accelerated_networking is not None:
            pulumi.set(__self__, "enable_accelerated_networking", enable_accelerated_networking)
        if enable_ip_forwarding is not None:
            pulumi.set(__self__, "enable_ip_forwarding", enable_ip_forwarding)
        if network_security_group_id is not None:
            pulumi.set(__self__, "network_security_group_id", network_security_group_id)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)

    @_builtins.property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Sequence['outputs.OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfiguration']:
        """
        One or more `ip_configuration` blocks as defined above.
        """
        return pulumi.get(self, "ip_configurations")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The Name which should be used for this Network Interface. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="auxiliaryMode")
    def auxiliary_mode(self) -> Optional[_builtins.str]:
        """
        Specifies the auxiliary mode used to enable network high-performance feature on Network Virtual Appliances (NVAs). This feature offers competitive performance in Connections Per Second (CPS) optimization, along with improvements to handling large amounts of simultaneous connections. Possible values are `AcceleratedConnections` and `Floating`.

        > **Note:** `auxiliary_mode` is in **Preview** and requires that the prerequisites are enabled - [more information can be found in the Azure documentation](https://learn.microsoft.com/azure/networking/nva-accelerated-connections#prerequisites).
        """
        return pulumi.get(self, "auxiliary_mode")

    @_builtins.property
    @pulumi.getter(name="auxiliarySku")
    def auxiliary_sku(self) -> Optional[_builtins.str]:
        """
        Specifies the SKU used for the network high-performance feature on Network Virtual Appliances (NVAs). Possible values are `A1`, `A2`, `A4` and `A8`.

        > **Note:** `auxiliary_sku` is in **Preview** and requires that the prerequisites are enabled - [more information can be found in the Azure documentation](https://learn.microsoft.com/azure/networking/nva-accelerated-connections#prerequisites).
        """
        return pulumi.get(self, "auxiliary_sku")

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of IP Addresses of DNS Servers which should be assigned to the Network Interface.
        """
        return pulumi.get(self, "dns_servers")

    @_builtins.property
    @pulumi.getter(name="enableAcceleratedNetworking")
    def enable_accelerated_networking(self) -> Optional[_builtins.bool]:
        """
        Does this Network Interface support Accelerated Networking? Possible values are `true` and `false`. Defaults to `false`.
        """
        return pulumi.get(self, "enable_accelerated_networking")

    @_builtins.property
    @pulumi.getter(name="enableIpForwarding")
    def enable_ip_forwarding(self) -> Optional[_builtins.bool]:
        """
        Does this Network Interface support IP Forwarding? Possible values are `true` and `false`. Defaults to `false`.
        """
        return pulumi.get(self, "enable_ip_forwarding")

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupId")
    def network_security_group_id(self) -> Optional[_builtins.str]:
        """
        The ID of a Network Security Group which should be assigned to this Network Interface.
        """
        return pulumi.get(self, "network_security_group_id")

    @_builtins.property
    @pulumi.getter
    def primary(self) -> Optional[_builtins.bool]:
        """
        Is this the Primary IP Configuration? Possible values are `true` and `false`. Defaults to `false`.

        > **Note:** If multiple `network_interface` blocks are specified, one must be set to `primary`.
        """
        return pulumi.get(self, "primary")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationGatewayBackendAddressPoolIds":
            suggest = "application_gateway_backend_address_pool_ids"
        elif key == "applicationSecurityGroupIds":
            suggest = "application_security_group_ids"
        elif key == "loadBalancerBackendAddressPoolIds":
            suggest = "load_balancer_backend_address_pool_ids"
        elif key == "publicIpAddresses":
            suggest = "public_ip_addresses"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 application_gateway_backend_address_pool_ids: Optional[Sequence[_builtins.str]] = None,
                 application_security_group_ids: Optional[Sequence[_builtins.str]] = None,
                 load_balancer_backend_address_pool_ids: Optional[Sequence[_builtins.str]] = None,
                 primary: Optional[_builtins.bool] = None,
                 public_ip_addresses: Optional[Sequence['outputs.OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress']] = None,
                 subnet_id: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The Name which should be used for this IP Configuration.
        :param Sequence[_builtins.str] application_gateway_backend_address_pool_ids: A list of Backend Address Pools IDs from a Application Gateway which this Virtual Machine Scale Set should be connected to.
        :param Sequence[_builtins.str] application_security_group_ids: A list of Application Security Group IDs which this Virtual Machine Scale Set should be connected to.
        :param Sequence[_builtins.str] load_balancer_backend_address_pool_ids: A list of Backend Address Pools IDs from a Load Balancer which this Virtual Machine Scale Set should be connected to.
               
               > **Note:** When using this field you'll also need to configure a Rule for the Load Balancer, and use a depends_on between this resource and the Load Balancer Rule.
        :param _builtins.bool primary: Is this the Primary IP Configuration for this Network Interface? Possible values are `true` and `false`. Defaults to `false`.
               
               > **Note:** One `ip_configuration` block must be marked as Primary for each Network Interface.
        :param Sequence['OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressArgs'] public_ip_addresses: A `public_ip_address` block as defined below.
        :param _builtins.str subnet_id: The ID of the Subnet which this IP Configuration should be connected to.
               
               > **Note:** `subnet_id` is required if version is set to `IPv4`.
        :param _builtins.str version: The Internet Protocol Version which should be used for this IP Configuration. Possible values are `IPv4` and `IPv6`. Defaults to `IPv4`.
        """
        pulumi.set(__self__, "name", name)
        if application_gateway_backend_address_pool_ids is not None:
            pulumi.set(__self__, "application_gateway_backend_address_pool_ids", application_gateway_backend_address_pool_ids)
        if application_security_group_ids is not None:
            pulumi.set(__self__, "application_security_group_ids", application_security_group_ids)
        if load_balancer_backend_address_pool_ids is not None:
            pulumi.set(__self__, "load_balancer_backend_address_pool_ids", load_balancer_backend_address_pool_ids)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if public_ip_addresses is not None:
            pulumi.set(__self__, "public_ip_addresses", public_ip_addresses)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The Name which should be used for this IP Configuration.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="applicationGatewayBackendAddressPoolIds")
    def application_gateway_backend_address_pool_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of Backend Address Pools IDs from a Application Gateway which this Virtual Machine Scale Set should be connected to.
        """
        return pulumi.get(self, "application_gateway_backend_address_pool_ids")

    @_builtins.property
    @pulumi.getter(name="applicationSecurityGroupIds")
    def application_security_group_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of Application Security Group IDs which this Virtual Machine Scale Set should be connected to.
        """
        return pulumi.get(self, "application_security_group_ids")

    @_builtins.property
    @pulumi.getter(name="loadBalancerBackendAddressPoolIds")
    def load_balancer_backend_address_pool_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of Backend Address Pools IDs from a Load Balancer which this Virtual Machine Scale Set should be connected to.

        > **Note:** When using this field you'll also need to configure a Rule for the Load Balancer, and use a depends_on between this resource and the Load Balancer Rule.
        """
        return pulumi.get(self, "load_balancer_backend_address_pool_ids")

    @_builtins.property
    @pulumi.getter
    def primary(self) -> Optional[_builtins.bool]:
        """
        Is this the Primary IP Configuration for this Network Interface? Possible values are `true` and `false`. Defaults to `false`.

        > **Note:** One `ip_configuration` block must be marked as Primary for each Network Interface.
        """
        return pulumi.get(self, "primary")

    @_builtins.property
    @pulumi.getter(name="publicIpAddresses")
    def public_ip_addresses(self) -> Optional[Sequence['outputs.OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress']]:
        """
        A `public_ip_address` block as defined below.
        """
        return pulumi.get(self, "public_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Subnet which this IP Configuration should be connected to.

        > **Note:** `subnet_id` is required if version is set to `IPv4`.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The Internet Protocol Version which should be used for this IP Configuration. Possible values are `IPv4` and `IPv6`. Defaults to `IPv4`.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainNameLabel":
            suggest = "domain_name_label"
        elif key == "idleTimeoutInMinutes":
            suggest = "idle_timeout_in_minutes"
        elif key == "ipTags":
            suggest = "ip_tags"
        elif key == "publicIpPrefixId":
            suggest = "public_ip_prefix_id"
        elif key == "skuName":
            suggest = "sku_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 domain_name_label: Optional[_builtins.str] = None,
                 idle_timeout_in_minutes: Optional[_builtins.int] = None,
                 ip_tags: Optional[Sequence['outputs.OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag']] = None,
                 public_ip_prefix_id: Optional[_builtins.str] = None,
                 sku_name: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The Name of the Public IP Address Configuration.
        :param _builtins.str domain_name_label: The Prefix which should be used for the Domain Name Label for each Virtual Machine Instance. Azure concatenates the Domain Name Label and Virtual Machine Index to create a unique Domain Name Label for each Virtual Machine. Valid values must be between `1` and `26` characters long, start with a lower case letter, end with a lower case letter or number and contains only `a-z`, `0-9` and `hyphens`.
        :param _builtins.int idle_timeout_in_minutes: The Idle Timeout in Minutes for the Public IP Address. Possible values are in the range `4` to `32`.
        :param Sequence['OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagArgs'] ip_tags: One or more `ip_tag` blocks as defined above. Changing this forces a new resource to be created.
        :param _builtins.str public_ip_prefix_id: The ID of the Public IP Address Prefix from where Public IP Addresses should be allocated. Changing this forces a new resource to be created.
        :param _builtins.str sku_name: Specifies what Public IP Address SKU the Public IP Address should be provisioned as. Possible vaules include `Basic_Regional`, `Basic_Global`, `Standard_Regional` or `Standard_Global`. For more information about Public IP Address SKU's and their capabilities, please see the [product documentation](https://docs.microsoft.com/azure/virtual-network/ip-services/public-ip-addresses#sku). Changing this forces a new resource to be created.
        :param _builtins.str version: The Internet Protocol Version which should be used for this public IP address. Possible values are `IPv4` and `IPv6`. Defaults to `IPv4`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "name", name)
        if domain_name_label is not None:
            pulumi.set(__self__, "domain_name_label", domain_name_label)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if ip_tags is not None:
            pulumi.set(__self__, "ip_tags", ip_tags)
        if public_ip_prefix_id is not None:
            pulumi.set(__self__, "public_ip_prefix_id", public_ip_prefix_id)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The Name of the Public IP Address Configuration.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="domainNameLabel")
    def domain_name_label(self) -> Optional[_builtins.str]:
        """
        The Prefix which should be used for the Domain Name Label for each Virtual Machine Instance. Azure concatenates the Domain Name Label and Virtual Machine Index to create a unique Domain Name Label for each Virtual Machine. Valid values must be between `1` and `26` characters long, start with a lower case letter, end with a lower case letter or number and contains only `a-z`, `0-9` and `hyphens`.
        """
        return pulumi.get(self, "domain_name_label")

    @_builtins.property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[_builtins.int]:
        """
        The Idle Timeout in Minutes for the Public IP Address. Possible values are in the range `4` to `32`.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @_builtins.property
    @pulumi.getter(name="ipTags")
    def ip_tags(self) -> Optional[Sequence['outputs.OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag']]:
        """
        One or more `ip_tag` blocks as defined above. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "ip_tags")

    @_builtins.property
    @pulumi.getter(name="publicIpPrefixId")
    def public_ip_prefix_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Public IP Address Prefix from where Public IP Addresses should be allocated. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "public_ip_prefix_id")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[_builtins.str]:
        """
        Specifies what Public IP Address SKU the Public IP Address should be provisioned as. Possible vaules include `Basic_Regional`, `Basic_Global`, `Standard_Regional` or `Standard_Global`. For more information about Public IP Address SKU's and their capabilities, please see the [product documentation](https://docs.microsoft.com/azure/virtual-network/ip-services/public-ip-addresses#sku). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The Internet Protocol Version which should be used for this public IP address. Possible values are `IPv4` and `IPv6`. Defaults to `IPv4`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag(dict):
    def __init__(__self__, *,
                 tag: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str tag: The IP Tag associated with the Public IP, such as `SQL` or `Storage`. Changing this forces a new resource to be created.
        :param _builtins.str type: The Type of IP Tag, such as `FirstPartyUsage`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def tag(self) -> _builtins.str:
        """
        The IP Tag associated with the Public IP, such as `SQL` or `Storage`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The Type of IP Tag, such as `FirstPartyUsage`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetOsDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageAccountType":
            suggest = "storage_account_type"
        elif key == "diffDiskSettings":
            suggest = "diff_disk_settings"
        elif key == "diskEncryptionSetId":
            suggest = "disk_encryption_set_id"
        elif key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "writeAcceleratorEnabled":
            suggest = "write_accelerator_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrchestratedVirtualMachineScaleSetOsDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrchestratedVirtualMachineScaleSetOsDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrchestratedVirtualMachineScaleSetOsDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 caching: _builtins.str,
                 storage_account_type: _builtins.str,
                 diff_disk_settings: Optional['outputs.OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettings'] = None,
                 disk_encryption_set_id: Optional[_builtins.str] = None,
                 disk_size_gb: Optional[_builtins.int] = None,
                 write_accelerator_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str caching: The Type of Caching which should be used for the Internal OS Disk. Possible values are `None`, `ReadOnly` and `ReadWrite`.
        :param _builtins.str storage_account_type: The Type of Storage Account which should back this the Internal OS Disk. Possible values include `Standard_LRS`, `StandardSSD_LRS`, `StandardSSD_ZRS`, `Premium_LRS` and `Premium_ZRS`. Changing this forces a new resource to be created.
        :param 'OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettingsArgs' diff_disk_settings: A `diff_disk_settings` block as defined above. Changing this forces a new resource to be created.
        :param _builtins.str disk_encryption_set_id: The ID of the Disk Encryption Set which should be used to encrypt this OS Disk. Changing this forces a new resource to be created.
               
               > **Note:** Disk Encryption Sets are in Public Preview in a limited set of regions
        :param _builtins.int disk_size_gb: The Size of the Internal OS Disk in GB, if you wish to vary from the size used in the image this Virtual Machine Scale Set is sourced from.
        :param _builtins.bool write_accelerator_enabled: Specifies if Write Accelerator is enabled on the OS Disk. Defaults to `false`.
        """
        pulumi.set(__self__, "caching", caching)
        pulumi.set(__self__, "storage_account_type", storage_account_type)
        if diff_disk_settings is not None:
            pulumi.set(__self__, "diff_disk_settings", diff_disk_settings)
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if write_accelerator_enabled is not None:
            pulumi.set(__self__, "write_accelerator_enabled", write_accelerator_enabled)

    @_builtins.property
    @pulumi.getter
    def caching(self) -> _builtins.str:
        """
        The Type of Caching which should be used for the Internal OS Disk. Possible values are `None`, `ReadOnly` and `ReadWrite`.
        """
        return pulumi.get(self, "caching")

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> _builtins.str:
        """
        The Type of Storage Account which should back this the Internal OS Disk. Possible values include `Standard_LRS`, `StandardSSD_LRS`, `StandardSSD_ZRS`, `Premium_LRS` and `Premium_ZRS`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_type")

    @_builtins.property
    @pulumi.getter(name="diffDiskSettings")
    def diff_disk_settings(self) -> Optional['outputs.OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettings']:
        """
        A `diff_disk_settings` block as defined above. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "diff_disk_settings")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Disk Encryption Set which should be used to encrypt this OS Disk. Changing this forces a new resource to be created.

        > **Note:** Disk Encryption Sets are in Public Preview in a limited set of regions
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[_builtins.int]:
        """
        The Size of the Internal OS Disk in GB, if you wish to vary from the size used in the image this Virtual Machine Scale Set is sourced from.
        """
        return pulumi.get(self, "disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="writeAcceleratorEnabled")
    def write_accelerator_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies if Write Accelerator is enabled on the OS Disk. Defaults to `false`.
        """
        return pulumi.get(self, "write_accelerator_enabled")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetOsDiskDiffDiskSettings(dict):
    def __init__(__self__, *,
                 option: _builtins.str,
                 placement: Optional[_builtins.str] = None):
        """
        :param _builtins.str option: Specifies the Ephemeral Disk Settings for the OS Disk. At this time the only possible value is `Local`. Changing this forces a new resource to be created.
        :param _builtins.str placement: Specifies where to store the Ephemeral Disk. Possible values are `CacheDisk` and `ResourceDisk`. Defaults to `CacheDisk`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "option", option)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)

    @_builtins.property
    @pulumi.getter
    def option(self) -> _builtins.str:
        """
        Specifies the Ephemeral Disk Settings for the OS Disk. At this time the only possible value is `Local`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "option")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Specifies where to store the Ephemeral Disk. Possible values are `CacheDisk` and `ResourceDisk`. Defaults to `CacheDisk`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "placement")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetOsProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customData":
            suggest = "custom_data"
        elif key == "linuxConfiguration":
            suggest = "linux_configuration"
        elif key == "windowsConfiguration":
            suggest = "windows_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrchestratedVirtualMachineScaleSetOsProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrchestratedVirtualMachineScaleSetOsProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrchestratedVirtualMachineScaleSetOsProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_data: Optional[_builtins.str] = None,
                 linux_configuration: Optional['outputs.OrchestratedVirtualMachineScaleSetOsProfileLinuxConfiguration'] = None,
                 windows_configuration: Optional['outputs.OrchestratedVirtualMachineScaleSetOsProfileWindowsConfiguration'] = None):
        """
        :param _builtins.str custom_data: The Base64-Encoded Custom Data which should be used for this Virtual Machine Scale Set.
               
               > **Note:** When Custom Data has been configured, it's not possible to remove it without tainting the Virtual Machine Scale Set, due to a limitation of the Azure API.
        :param 'OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationArgs' linux_configuration: A `linux_configuration` block as documented below.
        :param 'OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationArgs' windows_configuration: A `windows_configuration` block as documented below.
        """
        if custom_data is not None:
            pulumi.set(__self__, "custom_data", custom_data)
        if linux_configuration is not None:
            pulumi.set(__self__, "linux_configuration", linux_configuration)
        if windows_configuration is not None:
            pulumi.set(__self__, "windows_configuration", windows_configuration)

    @_builtins.property
    @pulumi.getter(name="customData")
    def custom_data(self) -> Optional[_builtins.str]:
        """
        The Base64-Encoded Custom Data which should be used for this Virtual Machine Scale Set.

        > **Note:** When Custom Data has been configured, it's not possible to remove it without tainting the Virtual Machine Scale Set, due to a limitation of the Azure API.
        """
        return pulumi.get(self, "custom_data")

    @_builtins.property
    @pulumi.getter(name="linuxConfiguration")
    def linux_configuration(self) -> Optional['outputs.OrchestratedVirtualMachineScaleSetOsProfileLinuxConfiguration']:
        """
        A `linux_configuration` block as documented below.
        """
        return pulumi.get(self, "linux_configuration")

    @_builtins.property
    @pulumi.getter(name="windowsConfiguration")
    def windows_configuration(self) -> Optional['outputs.OrchestratedVirtualMachineScaleSetOsProfileWindowsConfiguration']:
        """
        A `windows_configuration` block as documented below.
        """
        return pulumi.get(self, "windows_configuration")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetOsProfileLinuxConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminUsername":
            suggest = "admin_username"
        elif key == "adminPassword":
            suggest = "admin_password"
        elif key == "adminSshKeys":
            suggest = "admin_ssh_keys"
        elif key == "computerNamePrefix":
            suggest = "computer_name_prefix"
        elif key == "disablePasswordAuthentication":
            suggest = "disable_password_authentication"
        elif key == "patchAssessmentMode":
            suggest = "patch_assessment_mode"
        elif key == "patchMode":
            suggest = "patch_mode"
        elif key == "provisionVmAgent":
            suggest = "provision_vm_agent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrchestratedVirtualMachineScaleSetOsProfileLinuxConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrchestratedVirtualMachineScaleSetOsProfileLinuxConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrchestratedVirtualMachineScaleSetOsProfileLinuxConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_username: _builtins.str,
                 admin_password: Optional[_builtins.str] = None,
                 admin_ssh_keys: Optional[Sequence['outputs.OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKey']] = None,
                 computer_name_prefix: Optional[_builtins.str] = None,
                 disable_password_authentication: Optional[_builtins.bool] = None,
                 patch_assessment_mode: Optional[_builtins.str] = None,
                 patch_mode: Optional[_builtins.str] = None,
                 provision_vm_agent: Optional[_builtins.bool] = None,
                 secrets: Optional[Sequence['outputs.OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecret']] = None):
        """
        :param _builtins.str admin_username: The username of the local administrator on each Virtual Machine Scale Set instance. Changing this forces a new resource to be created.
        :param _builtins.str admin_password: The Password which should be used for the local-administrator on this Virtual Machine. Changing this forces a new resource to be created.
        :param Sequence['OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKeyArgs'] admin_ssh_keys: A `admin_ssh_key` block as documented below.
        :param _builtins.str computer_name_prefix: The prefix which should be used for the name of the Virtual Machines in this Scale Set. If unspecified this defaults to the value for the name field. If the value of the name field is not a valid `computer_name_prefix`, then you must specify `computer_name_prefix`. Changing this forces a new resource to be created.
        :param _builtins.bool disable_password_authentication: When an `admin_password` is specified `disable_password_authentication` must be set to `false`. Defaults to `true`.
               
               > **Note:** Either `admin_password` or `admin_ssh_key` must be specified.
        :param _builtins.str patch_assessment_mode: Specifies the mode of VM Guest Patching for the virtual machines that are associated to the Virtual Machine Scale Set. Possible values are `AutomaticByPlatform` or `ImageDefault`. Defaults to `ImageDefault`.
               
               > **Note:** If the `patch_assessment_mode` is set to `AutomaticByPlatform` then the `provision_vm_agent` field must be set to `true`.
        :param _builtins.str patch_mode: Specifies the mode of in-guest patching of this Windows Virtual Machine. Possible values are `ImageDefault` or `AutomaticByPlatform`. Defaults to `ImageDefault`. For more information on patch modes please see the [product documentation](https://docs.microsoft.com/azure/virtual-machines/automatic-vm-guest-patching#patch-orchestration-modes).
               
               > **Note:** If `patch_mode` is set to `AutomaticByPlatform` the `provision_vm_agent` must be set to `true` and the `extension` must contain at least one application health extension.  An example of how to correctly configure a Virtual Machine Scale Set to provision a Linux Virtual Machine with Automatic VM Guest Patching enabled can be found in the `./examples/orchestrated-vm-scale-set/automatic-vm-guest-patching` directory within the GitHub Repository.
        :param _builtins.bool provision_vm_agent: Should the Azure VM Agent be provisioned on each Virtual Machine in the Scale Set? Defaults to `true`. Changing this value forces a new resource to be created.
        :param Sequence['OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretArgs'] secrets: One or more `secret` blocks as defined below.
        """
        pulumi.set(__self__, "admin_username", admin_username)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if admin_ssh_keys is not None:
            pulumi.set(__self__, "admin_ssh_keys", admin_ssh_keys)
        if computer_name_prefix is not None:
            pulumi.set(__self__, "computer_name_prefix", computer_name_prefix)
        if disable_password_authentication is not None:
            pulumi.set(__self__, "disable_password_authentication", disable_password_authentication)
        if patch_assessment_mode is not None:
            pulumi.set(__self__, "patch_assessment_mode", patch_assessment_mode)
        if patch_mode is not None:
            pulumi.set(__self__, "patch_mode", patch_mode)
        if provision_vm_agent is not None:
            pulumi.set(__self__, "provision_vm_agent", provision_vm_agent)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)

    @_builtins.property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> _builtins.str:
        """
        The username of the local administrator on each Virtual Machine Scale Set instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "admin_username")

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[_builtins.str]:
        """
        The Password which should be used for the local-administrator on this Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "admin_password")

    @_builtins.property
    @pulumi.getter(name="adminSshKeys")
    def admin_ssh_keys(self) -> Optional[Sequence['outputs.OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKey']]:
        """
        A `admin_ssh_key` block as documented below.
        """
        return pulumi.get(self, "admin_ssh_keys")

    @_builtins.property
    @pulumi.getter(name="computerNamePrefix")
    def computer_name_prefix(self) -> Optional[_builtins.str]:
        """
        The prefix which should be used for the name of the Virtual Machines in this Scale Set. If unspecified this defaults to the value for the name field. If the value of the name field is not a valid `computer_name_prefix`, then you must specify `computer_name_prefix`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "computer_name_prefix")

    @_builtins.property
    @pulumi.getter(name="disablePasswordAuthentication")
    def disable_password_authentication(self) -> Optional[_builtins.bool]:
        """
        When an `admin_password` is specified `disable_password_authentication` must be set to `false`. Defaults to `true`.

        > **Note:** Either `admin_password` or `admin_ssh_key` must be specified.
        """
        return pulumi.get(self, "disable_password_authentication")

    @_builtins.property
    @pulumi.getter(name="patchAssessmentMode")
    def patch_assessment_mode(self) -> Optional[_builtins.str]:
        """
        Specifies the mode of VM Guest Patching for the virtual machines that are associated to the Virtual Machine Scale Set. Possible values are `AutomaticByPlatform` or `ImageDefault`. Defaults to `ImageDefault`.

        > **Note:** If the `patch_assessment_mode` is set to `AutomaticByPlatform` then the `provision_vm_agent` field must be set to `true`.
        """
        return pulumi.get(self, "patch_assessment_mode")

    @_builtins.property
    @pulumi.getter(name="patchMode")
    def patch_mode(self) -> Optional[_builtins.str]:
        """
        Specifies the mode of in-guest patching of this Windows Virtual Machine. Possible values are `ImageDefault` or `AutomaticByPlatform`. Defaults to `ImageDefault`. For more information on patch modes please see the [product documentation](https://docs.microsoft.com/azure/virtual-machines/automatic-vm-guest-patching#patch-orchestration-modes).

        > **Note:** If `patch_mode` is set to `AutomaticByPlatform` the `provision_vm_agent` must be set to `true` and the `extension` must contain at least one application health extension.  An example of how to correctly configure a Virtual Machine Scale Set to provision a Linux Virtual Machine with Automatic VM Guest Patching enabled can be found in the `./examples/orchestrated-vm-scale-set/automatic-vm-guest-patching` directory within the GitHub Repository.
        """
        return pulumi.get(self, "patch_mode")

    @_builtins.property
    @pulumi.getter(name="provisionVmAgent")
    def provision_vm_agent(self) -> Optional[_builtins.bool]:
        """
        Should the Azure VM Agent be provisioned on each Virtual Machine in the Scale Set? Defaults to `true`. Changing this value forces a new resource to be created.
        """
        return pulumi.get(self, "provision_vm_agent")

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Optional[Sequence['outputs.OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecret']]:
        """
        One or more `secret` blocks as defined below.
        """
        return pulumi.get(self, "secrets")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publicKey":
            suggest = "public_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationAdminSshKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 public_key: _builtins.str,
                 username: _builtins.str):
        """
        :param _builtins.str public_key: The Public Key which should be used for authentication, which needs to be in `ssh-rsa` format with at least 2048-bit or in `ssh-ed25519` format.
        :param _builtins.str username: The Username for which this Public SSH Key should be configured.
               
               > **Note:** The Azure VM Agent only allows creating SSH Keys at the path `/home/{username}/.ssh/authorized_keys` - as such this public key will be written to the authorized keys file.
        """
        pulumi.set(__self__, "public_key", public_key)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> _builtins.str:
        """
        The Public Key which should be used for authentication, which needs to be in `ssh-rsa` format with at least 2048-bit or in `ssh-ed25519` format.
        """
        return pulumi.get(self, "public_key")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The Username for which this Public SSH Key should be configured.

        > **Note:** The Azure VM Agent only allows creating SSH Keys at the path `/home/{username}/.ssh/authorized_keys` - as such this public key will be written to the authorized keys file.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultId":
            suggest = "key_vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificates: Sequence['outputs.OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretCertificate'],
                 key_vault_id: _builtins.str):
        """
        :param Sequence['OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretCertificateArgs'] certificates: One or more `certificate` blocks as defined below.
        :param _builtins.str key_vault_id: The ID of the Key Vault from which all Secrets should be sourced.
        """
        pulumi.set(__self__, "certificates", certificates)
        pulumi.set(__self__, "key_vault_id", key_vault_id)

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Sequence['outputs.OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretCertificate']:
        """
        One or more `certificate` blocks as defined below.
        """
        return pulumi.get(self, "certificates")

    @_builtins.property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> _builtins.str:
        """
        The ID of the Key Vault from which all Secrets should be sourced.
        """
        return pulumi.get(self, "key_vault_id")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetOsProfileLinuxConfigurationSecretCertificate(dict):
    def __init__(__self__, *,
                 url: _builtins.str):
        """
        :param _builtins.str url: The Secret URL of a Key Vault Certificate.
               
               > **Note:** This can be sourced from the `secret_id` field within the `keyvault.Certificate` Resource.
        """
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The Secret URL of a Key Vault Certificate.

        > **Note:** This can be sourced from the `secret_id` field within the `keyvault.Certificate` Resource.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetOsProfileWindowsConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminPassword":
            suggest = "admin_password"
        elif key == "adminUsername":
            suggest = "admin_username"
        elif key == "additionalUnattendContents":
            suggest = "additional_unattend_contents"
        elif key == "computerNamePrefix":
            suggest = "computer_name_prefix"
        elif key == "enableAutomaticUpdates":
            suggest = "enable_automatic_updates"
        elif key == "hotpatchingEnabled":
            suggest = "hotpatching_enabled"
        elif key == "patchAssessmentMode":
            suggest = "patch_assessment_mode"
        elif key == "patchMode":
            suggest = "patch_mode"
        elif key == "provisionVmAgent":
            suggest = "provision_vm_agent"
        elif key == "winrmListeners":
            suggest = "winrm_listeners"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrchestratedVirtualMachineScaleSetOsProfileWindowsConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrchestratedVirtualMachineScaleSetOsProfileWindowsConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrchestratedVirtualMachineScaleSetOsProfileWindowsConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_password: _builtins.str,
                 admin_username: _builtins.str,
                 additional_unattend_contents: Optional[Sequence['outputs.OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationAdditionalUnattendContent']] = None,
                 computer_name_prefix: Optional[_builtins.str] = None,
                 enable_automatic_updates: Optional[_builtins.bool] = None,
                 hotpatching_enabled: Optional[_builtins.bool] = None,
                 patch_assessment_mode: Optional[_builtins.str] = None,
                 patch_mode: Optional[_builtins.str] = None,
                 provision_vm_agent: Optional[_builtins.bool] = None,
                 secrets: Optional[Sequence['outputs.OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecret']] = None,
                 timezone: Optional[_builtins.str] = None,
                 winrm_listeners: Optional[Sequence['outputs.OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListener']] = None):
        """
        :param _builtins.str admin_password: The Password which should be used for the local-administrator on this Virtual Machine. Changing this forces a new resource to be created.
        :param _builtins.str admin_username: The username of the local administrator on each Virtual Machine Scale Set instance. Changing this forces a new resource to be created.
        :param Sequence['OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationAdditionalUnattendContentArgs'] additional_unattend_contents: One or more `additional_unattend_content` blocks as defined below. Changing this forces a new resource to be created.
        :param _builtins.str computer_name_prefix: The prefix which should be used for the name of the Virtual Machines in this Scale Set. If unspecified this defaults to the value for the `name` field. If the value of the `name` field is not a valid `computer_name_prefix`, then you must specify `computer_name_prefix`. Changing this forces a new resource to be created.
        :param _builtins.bool enable_automatic_updates: Are automatic updates enabled for this Virtual Machine? Defaults to `true`.
        :param _builtins.bool hotpatching_enabled: Should the VM be patched without requiring a reboot? Possible values are `true` or `false`. Defaults to `false`. For more information about hot patching please see the [product documentation](https://docs.microsoft.com/azure/automanage/automanage-hotpatch).
               
               > **Note:** Hotpatching can only be enabled if the `patch_mode` is set to `AutomaticByPlatform`, the `provision_vm_agent` is set to `true`, your `source_image_reference` references a hotpatching enabled image, the VM's `sku_name` is set to a [Azure generation 2](https://docs.microsoft.com/azure/virtual-machines/generation-2#generation-2-vm-sizes) VM SKU and the `extension` contains an application health extension. An example of how to correctly configure a Virtual Machine Scale Set to provision a Windows Virtual Machine with hotpatching enabled can be found in the `./examples/orchestrated-vm-scale-set/hotpatching-enabled` directory within the GitHub Repository.
        :param _builtins.str patch_assessment_mode: Specifies the mode of VM Guest Patching for the virtual machines that are associated to the Virtual Machine Scale Set. Possible values are `AutomaticByPlatform` or `ImageDefault`. Defaults to `ImageDefault`.
               
               > **Note:** If the `patch_assessment_mode` is set to `AutomaticByPlatform` then the `provision_vm_agent` field must be set to `true`.
        :param _builtins.str patch_mode: Specifies the mode of in-guest patching of this Windows Virtual Machine. Possible values are `Manual`, `AutomaticByOS` and `AutomaticByPlatform`. Defaults to `AutomaticByOS`. For more information on patch modes please see the [product documentation](https://docs.microsoft.com/azure/virtual-machines/automatic-vm-guest-patching#patch-orchestration-modes).
               
               > **Note:** If `patch_mode` is set to `AutomaticByPlatform` the `provision_vm_agent` must be set to `true` and the `extension` must contain at least one application health extension.
        :param _builtins.bool provision_vm_agent: Should the Azure VM Agent be provisioned on each Virtual Machine in the Scale Set? Defaults to `true`. Changing this value forces a new resource to be created.
        :param Sequence['OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretArgs'] secrets: One or more `secret` blocks as defined below.
        :param _builtins.str timezone: Specifies the time zone of the virtual machine, the possible values are defined [here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/).
        :param Sequence['OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListenerArgs'] winrm_listeners: One or more `winrm_listener` blocks as defined below. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "admin_password", admin_password)
        pulumi.set(__self__, "admin_username", admin_username)
        if additional_unattend_contents is not None:
            pulumi.set(__self__, "additional_unattend_contents", additional_unattend_contents)
        if computer_name_prefix is not None:
            pulumi.set(__self__, "computer_name_prefix", computer_name_prefix)
        if enable_automatic_updates is not None:
            pulumi.set(__self__, "enable_automatic_updates", enable_automatic_updates)
        if hotpatching_enabled is not None:
            pulumi.set(__self__, "hotpatching_enabled", hotpatching_enabled)
        if patch_assessment_mode is not None:
            pulumi.set(__self__, "patch_assessment_mode", patch_assessment_mode)
        if patch_mode is not None:
            pulumi.set(__self__, "patch_mode", patch_mode)
        if provision_vm_agent is not None:
            pulumi.set(__self__, "provision_vm_agent", provision_vm_agent)
        if secrets is not None:
            pulumi.set(__self__, "secrets", secrets)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if winrm_listeners is not None:
            pulumi.set(__self__, "winrm_listeners", winrm_listeners)

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> _builtins.str:
        """
        The Password which should be used for the local-administrator on this Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "admin_password")

    @_builtins.property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> _builtins.str:
        """
        The username of the local administrator on each Virtual Machine Scale Set instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "admin_username")

    @_builtins.property
    @pulumi.getter(name="additionalUnattendContents")
    def additional_unattend_contents(self) -> Optional[Sequence['outputs.OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationAdditionalUnattendContent']]:
        """
        One or more `additional_unattend_content` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "additional_unattend_contents")

    @_builtins.property
    @pulumi.getter(name="computerNamePrefix")
    def computer_name_prefix(self) -> Optional[_builtins.str]:
        """
        The prefix which should be used for the name of the Virtual Machines in this Scale Set. If unspecified this defaults to the value for the `name` field. If the value of the `name` field is not a valid `computer_name_prefix`, then you must specify `computer_name_prefix`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "computer_name_prefix")

    @_builtins.property
    @pulumi.getter(name="enableAutomaticUpdates")
    def enable_automatic_updates(self) -> Optional[_builtins.bool]:
        """
        Are automatic updates enabled for this Virtual Machine? Defaults to `true`.
        """
        return pulumi.get(self, "enable_automatic_updates")

    @_builtins.property
    @pulumi.getter(name="hotpatchingEnabled")
    def hotpatching_enabled(self) -> Optional[_builtins.bool]:
        """
        Should the VM be patched without requiring a reboot? Possible values are `true` or `false`. Defaults to `false`. For more information about hot patching please see the [product documentation](https://docs.microsoft.com/azure/automanage/automanage-hotpatch).

        > **Note:** Hotpatching can only be enabled if the `patch_mode` is set to `AutomaticByPlatform`, the `provision_vm_agent` is set to `true`, your `source_image_reference` references a hotpatching enabled image, the VM's `sku_name` is set to a [Azure generation 2](https://docs.microsoft.com/azure/virtual-machines/generation-2#generation-2-vm-sizes) VM SKU and the `extension` contains an application health extension. An example of how to correctly configure a Virtual Machine Scale Set to provision a Windows Virtual Machine with hotpatching enabled can be found in the `./examples/orchestrated-vm-scale-set/hotpatching-enabled` directory within the GitHub Repository.
        """
        return pulumi.get(self, "hotpatching_enabled")

    @_builtins.property
    @pulumi.getter(name="patchAssessmentMode")
    def patch_assessment_mode(self) -> Optional[_builtins.str]:
        """
        Specifies the mode of VM Guest Patching for the virtual machines that are associated to the Virtual Machine Scale Set. Possible values are `AutomaticByPlatform` or `ImageDefault`. Defaults to `ImageDefault`.

        > **Note:** If the `patch_assessment_mode` is set to `AutomaticByPlatform` then the `provision_vm_agent` field must be set to `true`.
        """
        return pulumi.get(self, "patch_assessment_mode")

    @_builtins.property
    @pulumi.getter(name="patchMode")
    def patch_mode(self) -> Optional[_builtins.str]:
        """
        Specifies the mode of in-guest patching of this Windows Virtual Machine. Possible values are `Manual`, `AutomaticByOS` and `AutomaticByPlatform`. Defaults to `AutomaticByOS`. For more information on patch modes please see the [product documentation](https://docs.microsoft.com/azure/virtual-machines/automatic-vm-guest-patching#patch-orchestration-modes).

        > **Note:** If `patch_mode` is set to `AutomaticByPlatform` the `provision_vm_agent` must be set to `true` and the `extension` must contain at least one application health extension.
        """
        return pulumi.get(self, "patch_mode")

    @_builtins.property
    @pulumi.getter(name="provisionVmAgent")
    def provision_vm_agent(self) -> Optional[_builtins.bool]:
        """
        Should the Azure VM Agent be provisioned on each Virtual Machine in the Scale Set? Defaults to `true`. Changing this value forces a new resource to be created.
        """
        return pulumi.get(self, "provision_vm_agent")

    @_builtins.property
    @pulumi.getter
    def secrets(self) -> Optional[Sequence['outputs.OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecret']]:
        """
        One or more `secret` blocks as defined below.
        """
        return pulumi.get(self, "secrets")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[_builtins.str]:
        """
        Specifies the time zone of the virtual machine, the possible values are defined [here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/).
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter(name="winrmListeners")
    def winrm_listeners(self) -> Optional[Sequence['outputs.OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListener']]:
        """
        One or more `winrm_listener` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "winrm_listeners")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationAdditionalUnattendContent(dict):
    def __init__(__self__, *,
                 content: _builtins.str,
                 setting: _builtins.str):
        """
        :param _builtins.str content: The XML formatted content that is added to the unattend.xml file for the specified path and component. Changing this forces a new resource to be created.
        :param _builtins.str setting: The name of the setting to which the content applies. Possible values are `AutoLogon` and `FirstLogonCommands`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "setting", setting)

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        The XML formatted content that is added to the unattend.xml file for the specified path and component. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def setting(self) -> _builtins.str:
        """
        The name of the setting to which the content applies. Possible values are `AutoLogon` and `FirstLogonCommands`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "setting")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultId":
            suggest = "key_vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificates: Sequence['outputs.OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretCertificate'],
                 key_vault_id: _builtins.str):
        """
        :param Sequence['OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretCertificateArgs'] certificates: One or more `certificate` blocks as defined below.
        :param _builtins.str key_vault_id: The ID of the Key Vault from which all Secrets should be sourced.
        """
        pulumi.set(__self__, "certificates", certificates)
        pulumi.set(__self__, "key_vault_id", key_vault_id)

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Sequence['outputs.OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretCertificate']:
        """
        One or more `certificate` blocks as defined below.
        """
        return pulumi.get(self, "certificates")

    @_builtins.property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> _builtins.str:
        """
        The ID of the Key Vault from which all Secrets should be sourced.
        """
        return pulumi.get(self, "key_vault_id")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationSecretCertificate(dict):
    def __init__(__self__, *,
                 store: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.str store: The certificate store on the Virtual Machine where the certificate should be added.
        :param _builtins.str url: The Secret URL of a Key Vault Certificate.
               
               > **Note:** This can be sourced from the `secret_id` field within the `keyvault.Certificate` Resource.
        """
        pulumi.set(__self__, "store", store)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def store(self) -> _builtins.str:
        """
        The certificate store on the Virtual Machine where the certificate should be added.
        """
        return pulumi.get(self, "store")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The Secret URL of a Key Vault Certificate.

        > **Note:** This can be sourced from the `secret_id` field within the `keyvault.Certificate` Resource.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListener(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateUrl":
            suggest = "certificate_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListener. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListener.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrchestratedVirtualMachineScaleSetOsProfileWindowsConfigurationWinrmListener.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protocol: _builtins.str,
                 certificate_url: Optional[_builtins.str] = None):
        """
        :param _builtins.str protocol: Specifies the protocol of listener. Possible values are `Http` or `Https`. Changing this forces a new resource to be created.
        :param _builtins.str certificate_url: The Secret URL of a Key Vault Certificate, which must be specified when protocol is set to `Https`. Changing this forces a new resource to be created.
               
               > **Note:** This can be sourced from the `secret_id` field within the `keyvault.Certificate` Resource.
        """
        pulumi.set(__self__, "protocol", protocol)
        if certificate_url is not None:
            pulumi.set(__self__, "certificate_url", certificate_url)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Specifies the protocol of listener. Possible values are `Http` or `Https`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="certificateUrl")
    def certificate_url(self) -> Optional[_builtins.str]:
        """
        The Secret URL of a Key Vault Certificate, which must be specified when protocol is set to `Https`. Changing this forces a new resource to be created.

        > **Note:** This can be sourced from the `secret_id` field within the `keyvault.Certificate` Resource.
        """
        return pulumi.get(self, "certificate_url")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetPlan(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 product: _builtins.str,
                 publisher: _builtins.str):
        """
        :param _builtins.str name: Specifies the name of the image from the marketplace. Changing this forces a new resource to be created.
        :param _builtins.str product: Specifies the product of the image from the marketplace. Changing this forces a new resource to be created.
        :param _builtins.str publisher: Specifies the publisher of the image. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "publisher", publisher)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the image from the marketplace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def product(self) -> _builtins.str:
        """
        Specifies the product of the image from the marketplace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "product")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        """
        Specifies the publisher of the image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetPriorityMix(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "baseRegularCount":
            suggest = "base_regular_count"
        elif key == "regularPercentageAboveBase":
            suggest = "regular_percentage_above_base"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrchestratedVirtualMachineScaleSetPriorityMix. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrchestratedVirtualMachineScaleSetPriorityMix.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrchestratedVirtualMachineScaleSetPriorityMix.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 base_regular_count: Optional[_builtins.int] = None,
                 regular_percentage_above_base: Optional[_builtins.int] = None):
        """
        :param _builtins.int base_regular_count: Specifies the base number of VMs of `Regular` priority that will be created before any VMs of priority `Spot` are created. Possible values are integers between `0` and `1000`. Defaults to `0`.
        :param _builtins.int regular_percentage_above_base: Specifies the desired percentage of VM instances that are of `Regular` priority after the base count has been reached. Possible values are integers between `0` and `100`. Defaults to `0`.
        """
        if base_regular_count is not None:
            pulumi.set(__self__, "base_regular_count", base_regular_count)
        if regular_percentage_above_base is not None:
            pulumi.set(__self__, "regular_percentage_above_base", regular_percentage_above_base)

    @_builtins.property
    @pulumi.getter(name="baseRegularCount")
    def base_regular_count(self) -> Optional[_builtins.int]:
        """
        Specifies the base number of VMs of `Regular` priority that will be created before any VMs of priority `Spot` are created. Possible values are integers between `0` and `1000`. Defaults to `0`.
        """
        return pulumi.get(self, "base_regular_count")

    @_builtins.property
    @pulumi.getter(name="regularPercentageAboveBase")
    def regular_percentage_above_base(self) -> Optional[_builtins.int]:
        """
        Specifies the desired percentage of VM instances that are of `Regular` priority after the base count has been reached. Possible values are integers between `0` and `100`. Defaults to `0`.
        """
        return pulumi.get(self, "regular_percentage_above_base")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetRollingUpgradePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxBatchInstancePercent":
            suggest = "max_batch_instance_percent"
        elif key == "maxUnhealthyInstancePercent":
            suggest = "max_unhealthy_instance_percent"
        elif key == "maxUnhealthyUpgradedInstancePercent":
            suggest = "max_unhealthy_upgraded_instance_percent"
        elif key == "pauseTimeBetweenBatches":
            suggest = "pause_time_between_batches"
        elif key == "crossZoneUpgradesEnabled":
            suggest = "cross_zone_upgrades_enabled"
        elif key == "maximumSurgeInstancesEnabled":
            suggest = "maximum_surge_instances_enabled"
        elif key == "prioritizeUnhealthyInstancesEnabled":
            suggest = "prioritize_unhealthy_instances_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrchestratedVirtualMachineScaleSetRollingUpgradePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrchestratedVirtualMachineScaleSetRollingUpgradePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrchestratedVirtualMachineScaleSetRollingUpgradePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_batch_instance_percent: _builtins.int,
                 max_unhealthy_instance_percent: _builtins.int,
                 max_unhealthy_upgraded_instance_percent: _builtins.int,
                 pause_time_between_batches: _builtins.str,
                 cross_zone_upgrades_enabled: Optional[_builtins.bool] = None,
                 maximum_surge_instances_enabled: Optional[_builtins.bool] = None,
                 prioritize_unhealthy_instances_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.int max_batch_instance_percent: The maximum percent of total virtual machine instances that will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum, unhealthy instances in previous or future batches can cause the percentage of instances in a batch to decrease to ensure higher reliability.
        :param _builtins.int max_unhealthy_instance_percent: The maximum percentage of the total virtual machine instances in the scale set that can be simultaneously unhealthy, either as a result of being upgraded, or by being found in an unhealthy state by the virtual machine health checks before the rolling upgrade aborts. This constraint will be checked prior to starting any batch.
        :param _builtins.int max_unhealthy_upgraded_instance_percent: The maximum percentage of upgraded virtual machine instances that can be found to be in an unhealthy state. This check will happen after each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts.
        :param _builtins.str pause_time_between_batches: The wait time between completing the update for all virtual machines in one batch and starting the next batch. The time duration should be specified in ISO 8601 duration format.
        :param _builtins.bool cross_zone_upgrades_enabled: Should the Virtual Machine Scale Set ignore the Azure Zone boundaries when constructing upgrade batches? Possible values are `true` or `false`.
        :param _builtins.bool maximum_surge_instances_enabled: Create new virtual machines to upgrade the scale set, rather than updating the existing virtual machines. Existing virtual machines will be deleted once the new virtual machines are created for each batch. Possible values are `true` or `false`.
        :param _builtins.bool prioritize_unhealthy_instances_enabled: Upgrade all unhealthy instances in a scale set before any healthy instances. Possible values are `true` or `false`.
        """
        pulumi.set(__self__, "max_batch_instance_percent", max_batch_instance_percent)
        pulumi.set(__self__, "max_unhealthy_instance_percent", max_unhealthy_instance_percent)
        pulumi.set(__self__, "max_unhealthy_upgraded_instance_percent", max_unhealthy_upgraded_instance_percent)
        pulumi.set(__self__, "pause_time_between_batches", pause_time_between_batches)
        if cross_zone_upgrades_enabled is not None:
            pulumi.set(__self__, "cross_zone_upgrades_enabled", cross_zone_upgrades_enabled)
        if maximum_surge_instances_enabled is not None:
            pulumi.set(__self__, "maximum_surge_instances_enabled", maximum_surge_instances_enabled)
        if prioritize_unhealthy_instances_enabled is not None:
            pulumi.set(__self__, "prioritize_unhealthy_instances_enabled", prioritize_unhealthy_instances_enabled)

    @_builtins.property
    @pulumi.getter(name="maxBatchInstancePercent")
    def max_batch_instance_percent(self) -> _builtins.int:
        """
        The maximum percent of total virtual machine instances that will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum, unhealthy instances in previous or future batches can cause the percentage of instances in a batch to decrease to ensure higher reliability.
        """
        return pulumi.get(self, "max_batch_instance_percent")

    @_builtins.property
    @pulumi.getter(name="maxUnhealthyInstancePercent")
    def max_unhealthy_instance_percent(self) -> _builtins.int:
        """
        The maximum percentage of the total virtual machine instances in the scale set that can be simultaneously unhealthy, either as a result of being upgraded, or by being found in an unhealthy state by the virtual machine health checks before the rolling upgrade aborts. This constraint will be checked prior to starting any batch.
        """
        return pulumi.get(self, "max_unhealthy_instance_percent")

    @_builtins.property
    @pulumi.getter(name="maxUnhealthyUpgradedInstancePercent")
    def max_unhealthy_upgraded_instance_percent(self) -> _builtins.int:
        """
        The maximum percentage of upgraded virtual machine instances that can be found to be in an unhealthy state. This check will happen after each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts.
        """
        return pulumi.get(self, "max_unhealthy_upgraded_instance_percent")

    @_builtins.property
    @pulumi.getter(name="pauseTimeBetweenBatches")
    def pause_time_between_batches(self) -> _builtins.str:
        """
        The wait time between completing the update for all virtual machines in one batch and starting the next batch. The time duration should be specified in ISO 8601 duration format.
        """
        return pulumi.get(self, "pause_time_between_batches")

    @_builtins.property
    @pulumi.getter(name="crossZoneUpgradesEnabled")
    def cross_zone_upgrades_enabled(self) -> Optional[_builtins.bool]:
        """
        Should the Virtual Machine Scale Set ignore the Azure Zone boundaries when constructing upgrade batches? Possible values are `true` or `false`.
        """
        return pulumi.get(self, "cross_zone_upgrades_enabled")

    @_builtins.property
    @pulumi.getter(name="maximumSurgeInstancesEnabled")
    def maximum_surge_instances_enabled(self) -> Optional[_builtins.bool]:
        """
        Create new virtual machines to upgrade the scale set, rather than updating the existing virtual machines. Existing virtual machines will be deleted once the new virtual machines are created for each batch. Possible values are `true` or `false`.
        """
        return pulumi.get(self, "maximum_surge_instances_enabled")

    @_builtins.property
    @pulumi.getter(name="prioritizeUnhealthyInstancesEnabled")
    def prioritize_unhealthy_instances_enabled(self) -> Optional[_builtins.bool]:
        """
        Upgrade all unhealthy instances in a scale set before any healthy instances. Possible values are `true` or `false`.
        """
        return pulumi.get(self, "prioritize_unhealthy_instances_enabled")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetSkuProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocationStrategy":
            suggest = "allocation_strategy"
        elif key == "vmSizes":
            suggest = "vm_sizes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrchestratedVirtualMachineScaleSetSkuProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrchestratedVirtualMachineScaleSetSkuProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrchestratedVirtualMachineScaleSetSkuProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocation_strategy: _builtins.str,
                 vm_sizes: Sequence[_builtins.str]):
        """
        :param _builtins.str allocation_strategy: Specifies the allocation strategy for the virtual machine scale set based on which the VMs will be allocated. Possible values are `LowestPrice` and `CapacityOptimized`.
        :param Sequence[_builtins.str] vm_sizes: Specifies the VM sizes for the virtual machine scale set.
        """
        pulumi.set(__self__, "allocation_strategy", allocation_strategy)
        pulumi.set(__self__, "vm_sizes", vm_sizes)

    @_builtins.property
    @pulumi.getter(name="allocationStrategy")
    def allocation_strategy(self) -> _builtins.str:
        """
        Specifies the allocation strategy for the virtual machine scale set based on which the VMs will be allocated. Possible values are `LowestPrice` and `CapacityOptimized`.
        """
        return pulumi.get(self, "allocation_strategy")

    @_builtins.property
    @pulumi.getter(name="vmSizes")
    def vm_sizes(self) -> Sequence[_builtins.str]:
        """
        Specifies the VM sizes for the virtual machine scale set.
        """
        return pulumi.get(self, "vm_sizes")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetSourceImageReference(dict):
    def __init__(__self__, *,
                 offer: _builtins.str,
                 publisher: _builtins.str,
                 sku: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str offer: Specifies the offer of the image used to create the virtual machines. Changing this forces a new resource to be created.
        :param _builtins.str publisher: Specifies the publisher of the image used to create the virtual machines. Changing this forces a new resource to be created.
        :param _builtins.str sku: Specifies the SKU of the image used to create the virtual machines.
        :param _builtins.str version: Specifies the version of the image used to create the virtual machines.
        """
        pulumi.set(__self__, "offer", offer)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "sku", sku)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def offer(self) -> _builtins.str:
        """
        Specifies the offer of the image used to create the virtual machines. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "offer")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        """
        Specifies the publisher of the image used to create the virtual machines. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> _builtins.str:
        """
        Specifies the SKU of the image used to create the virtual machines.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Specifies the version of the image used to create the virtual machines.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class OrchestratedVirtualMachineScaleSetTerminationNotification(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 timeout: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Should the termination notification be enabled on this Virtual Machine Scale Set? Possible values `true` or `false`.
        :param _builtins.str timeout: Length of time (in minutes, between `5` and `15`) a notification to be sent to the VM on the instance metadata server till the VM gets deleted. The time duration should be specified in `ISO 8601` format. Defaults to `PT5M`.
        """
        pulumi.set(__self__, "enabled", enabled)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Should the termination notification be enabled on this Virtual Machine Scale Set? Possible values `true` or `false`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.str]:
        """
        Length of time (in minutes, between `5` and `15`) a notification to be sent to the VM on the instance metadata server till the VM gets deleted. The time duration should be specified in `ISO 8601` format. Defaults to `PT5M`.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class PacketCaptureFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localIpAddress":
            suggest = "local_ip_address"
        elif key == "localPort":
            suggest = "local_port"
        elif key == "remoteIpAddress":
            suggest = "remote_ip_address"
        elif key == "remotePort":
            suggest = "remote_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PacketCaptureFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PacketCaptureFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PacketCaptureFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protocol: _builtins.str,
                 local_ip_address: Optional[_builtins.str] = None,
                 local_port: Optional[_builtins.str] = None,
                 remote_ip_address: Optional[_builtins.str] = None,
                 remote_port: Optional[_builtins.str] = None):
        """
        :param _builtins.str protocol: The Protocol to be filtered on. Possible values include `Any`, `TCP` and `UDP`. Changing this forces a new resource to be created.
        :param _builtins.str local_ip_address: The local IP Address to be filtered on. Specify `127.0.0.1` for a single address entry, `127.0.0.1-127.0.0.255` for a range and `127.0.0.1;127.0.0.5` for multiple entries. Multiple ranges and mixing ranges with multiple entries are currently not supported. Changing this forces a new resource to be created.
        :param _builtins.str local_port: The local port to be filtered on. Specify `80` for single port entry, `80-85` for a range and `80;443;` for multiple entries. Multiple ranges and mixing ranges with multiple entries are currently not supported. Changing this forces a new resource to be created.
        :param _builtins.str remote_ip_address: The remote IP Address to be filtered on. Specify `127.0.0.1` for a single address entry, `127.0.0.1-127.0.0.255` for a range and `127.0.0.1;127.0.0.5` for multiple entries. Multiple ranges and mixing ranges with multiple entries are currently not supported. Changing this forces a new resource to be created.
        :param _builtins.str remote_port: The remote port to be filtered on. Specify `80` for single port entry, `80-85` for a range and `80;443;` for multiple entries. Multiple ranges and mixing ranges with multiple entries are currently not supported. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "protocol", protocol)
        if local_ip_address is not None:
            pulumi.set(__self__, "local_ip_address", local_ip_address)
        if local_port is not None:
            pulumi.set(__self__, "local_port", local_port)
        if remote_ip_address is not None:
            pulumi.set(__self__, "remote_ip_address", remote_ip_address)
        if remote_port is not None:
            pulumi.set(__self__, "remote_port", remote_port)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The Protocol to be filtered on. Possible values include `Any`, `TCP` and `UDP`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="localIpAddress")
    def local_ip_address(self) -> Optional[_builtins.str]:
        """
        The local IP Address to be filtered on. Specify `127.0.0.1` for a single address entry, `127.0.0.1-127.0.0.255` for a range and `127.0.0.1;127.0.0.5` for multiple entries. Multiple ranges and mixing ranges with multiple entries are currently not supported. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "local_ip_address")

    @_builtins.property
    @pulumi.getter(name="localPort")
    def local_port(self) -> Optional[_builtins.str]:
        """
        The local port to be filtered on. Specify `80` for single port entry, `80-85` for a range and `80;443;` for multiple entries. Multiple ranges and mixing ranges with multiple entries are currently not supported. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "local_port")

    @_builtins.property
    @pulumi.getter(name="remoteIpAddress")
    def remote_ip_address(self) -> Optional[_builtins.str]:
        """
        The remote IP Address to be filtered on. Specify `127.0.0.1` for a single address entry, `127.0.0.1-127.0.0.255` for a range and `127.0.0.1;127.0.0.5` for multiple entries. Multiple ranges and mixing ranges with multiple entries are currently not supported. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "remote_ip_address")

    @_builtins.property
    @pulumi.getter(name="remotePort")
    def remote_port(self) -> Optional[_builtins.str]:
        """
        The remote port to be filtered on. Specify `80` for single port entry, `80-85` for a range and `80;443;` for multiple entries. Multiple ranges and mixing ranges with multiple entries are currently not supported. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "remote_port")


@pulumi.output_type
class PacketCaptureStorageLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filePath":
            suggest = "file_path"
        elif key == "storageAccountId":
            suggest = "storage_account_id"
        elif key == "storagePath":
            suggest = "storage_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PacketCaptureStorageLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PacketCaptureStorageLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PacketCaptureStorageLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_path: Optional[_builtins.str] = None,
                 storage_account_id: Optional[_builtins.str] = None,
                 storage_path: Optional[_builtins.str] = None):
        """
        :param _builtins.str file_path: A valid local path on the target Virtual Machine. Must include the name of the capture file (*.cap). For Linux Virtual Machines it must start with `/var/captures`.
        :param _builtins.str storage_account_id: The ID of the storage account where the packet capture sessions should be saved to.
               
               > **Note:** At least one of `file_path` or `storage_account_id` must be specified.
        :param _builtins.str storage_path: The URI of the storage path where the packet capture sessions are saved to.
        """
        if file_path is not None:
            pulumi.set(__self__, "file_path", file_path)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)
        if storage_path is not None:
            pulumi.set(__self__, "storage_path", storage_path)

    @_builtins.property
    @pulumi.getter(name="filePath")
    def file_path(self) -> Optional[_builtins.str]:
        """
        A valid local path on the target Virtual Machine. Must include the name of the capture file (*.cap). For Linux Virtual Machines it must start with `/var/captures`.
        """
        return pulumi.get(self, "file_path")

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[_builtins.str]:
        """
        The ID of the storage account where the packet capture sessions should be saved to.

        > **Note:** At least one of `file_path` or `storage_account_id` must be specified.
        """
        return pulumi.get(self, "storage_account_id")

    @_builtins.property
    @pulumi.getter(name="storagePath")
    def storage_path(self) -> Optional[_builtins.str]:
        """
        The URI of the storage path where the packet capture sessions are saved to.
        """
        return pulumi.get(self, "storage_path")


@pulumi.output_type
class RunCommandErrorBlobManagedIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "objectId":
            suggest = "object_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RunCommandErrorBlobManagedIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RunCommandErrorBlobManagedIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RunCommandErrorBlobManagedIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[_builtins.str] = None,
                 object_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str client_id: The client ID of the managed identity.
        :param _builtins.str object_id: The object ID of the managed identity.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[_builtins.str]:
        """
        The client ID of the managed identity.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[_builtins.str]:
        """
        The object ID of the managed identity.
        """
        return pulumi.get(self, "object_id")


@pulumi.output_type
class RunCommandInstanceView(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "errorMessage":
            suggest = "error_message"
        elif key == "executionMessage":
            suggest = "execution_message"
        elif key == "executionState":
            suggest = "execution_state"
        elif key == "exitCode":
            suggest = "exit_code"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RunCommandInstanceView. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RunCommandInstanceView.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RunCommandInstanceView.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: Optional[_builtins.str] = None,
                 error_message: Optional[_builtins.str] = None,
                 execution_message: Optional[_builtins.str] = None,
                 execution_state: Optional[_builtins.str] = None,
                 exit_code: Optional[_builtins.int] = None,
                 output: Optional[_builtins.str] = None,
                 start_time: Optional[_builtins.str] = None):
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if execution_message is not None:
            pulumi.set(__self__, "execution_message", execution_message)
        if execution_state is not None:
            pulumi.set(__self__, "execution_state", execution_state)
        if exit_code is not None:
            pulumi.set(__self__, "exit_code", exit_code)
        if output is not None:
            pulumi.set(__self__, "output", output)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "error_message")

    @_builtins.property
    @pulumi.getter(name="executionMessage")
    def execution_message(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "execution_message")

    @_builtins.property
    @pulumi.getter(name="executionState")
    def execution_state(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "execution_state")

    @_builtins.property
    @pulumi.getter(name="exitCode")
    def exit_code(self) -> Optional[_builtins.int]:
        return pulumi.get(self, "exit_code")

    @_builtins.property
    @pulumi.getter
    def output(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "output")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "start_time")


@pulumi.output_type
class RunCommandOutputBlobManagedIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "objectId":
            suggest = "object_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RunCommandOutputBlobManagedIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RunCommandOutputBlobManagedIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RunCommandOutputBlobManagedIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[_builtins.str] = None,
                 object_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str client_id: The client ID of the managed identity.
        :param _builtins.str object_id: The object ID of the managed identity.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[_builtins.str]:
        """
        The client ID of the managed identity.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[_builtins.str]:
        """
        The object ID of the managed identity.
        """
        return pulumi.get(self, "object_id")


@pulumi.output_type
class RunCommandParameter(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The run parameter name.
        :param _builtins.str value: The run parameter value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The run parameter name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The run parameter value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RunCommandProtectedParameter(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The run parameter name.
        :param _builtins.str value: The run parameter value.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The run parameter name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The run parameter value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RunCommandSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commandId":
            suggest = "command_id"
        elif key == "scriptUri":
            suggest = "script_uri"
        elif key == "scriptUriManagedIdentity":
            suggest = "script_uri_managed_identity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RunCommandSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RunCommandSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RunCommandSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 command_id: Optional[_builtins.str] = None,
                 script: Optional[_builtins.str] = None,
                 script_uri: Optional[_builtins.str] = None,
                 script_uri_managed_identity: Optional['outputs.RunCommandSourceScriptUriManagedIdentity'] = None):
        """
        :param 'RunCommandSourceScriptUriManagedIdentityArgs' script_uri_managed_identity: A `script_uri_managed_identity` block as defined above.
        """
        if command_id is not None:
            pulumi.set(__self__, "command_id", command_id)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if script_uri is not None:
            pulumi.set(__self__, "script_uri", script_uri)
        if script_uri_managed_identity is not None:
            pulumi.set(__self__, "script_uri_managed_identity", script_uri_managed_identity)

    @_builtins.property
    @pulumi.getter(name="commandId")
    def command_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "command_id")

    @_builtins.property
    @pulumi.getter
    def script(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "script")

    @_builtins.property
    @pulumi.getter(name="scriptUri")
    def script_uri(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "script_uri")

    @_builtins.property
    @pulumi.getter(name="scriptUriManagedIdentity")
    def script_uri_managed_identity(self) -> Optional['outputs.RunCommandSourceScriptUriManagedIdentity']:
        """
        A `script_uri_managed_identity` block as defined above.
        """
        return pulumi.get(self, "script_uri_managed_identity")


@pulumi.output_type
class RunCommandSourceScriptUriManagedIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientId":
            suggest = "client_id"
        elif key == "objectId":
            suggest = "object_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RunCommandSourceScriptUriManagedIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RunCommandSourceScriptUriManagedIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RunCommandSourceScriptUriManagedIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_id: Optional[_builtins.str] = None,
                 object_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str client_id: The client ID of the managed identity.
        :param _builtins.str object_id: The object ID of the managed identity.
        """
        if client_id is not None:
            pulumi.set(__self__, "client_id", client_id)
        if object_id is not None:
            pulumi.set(__self__, "object_id", object_id)

    @_builtins.property
    @pulumi.getter(name="clientId")
    def client_id(self) -> Optional[_builtins.str]:
        """
        The client ID of the managed identity.
        """
        return pulumi.get(self, "client_id")

    @_builtins.property
    @pulumi.getter(name="objectId")
    def object_id(self) -> Optional[_builtins.str]:
        """
        The object ID of the managed identity.
        """
        return pulumi.get(self, "object_id")


@pulumi.output_type
class ScaleSetBootDiagnostics(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageUri":
            suggest = "storage_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSetBootDiagnostics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSetBootDiagnostics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSetBootDiagnostics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_uri: _builtins.str,
                 enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str storage_uri: Blob endpoint for the storage account to hold the virtual machine's diagnostic files. This must be the root of a storage account, and not a storage container.
        :param _builtins.bool enabled: Whether to enable boot diagnostics for the virtual machine. Defaults to `true`.
        """
        pulumi.set(__self__, "storage_uri", storage_uri)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @_builtins.property
    @pulumi.getter(name="storageUri")
    def storage_uri(self) -> _builtins.str:
        """
        Blob endpoint for the storage account to hold the virtual machine's diagnostic files. This must be the root of a storage account, and not a storage container.
        """
        return pulumi.get(self, "storage_uri")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable boot diagnostics for the virtual machine. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class ScaleSetExtension(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "typeHandlerVersion":
            suggest = "type_handler_version"
        elif key == "autoUpgradeMinorVersion":
            suggest = "auto_upgrade_minor_version"
        elif key == "protectedSettings":
            suggest = "protected_settings"
        elif key == "provisionAfterExtensions":
            suggest = "provision_after_extensions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSetExtension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSetExtension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSetExtension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 publisher: _builtins.str,
                 type: _builtins.str,
                 type_handler_version: _builtins.str,
                 auto_upgrade_minor_version: Optional[_builtins.bool] = None,
                 protected_settings: Optional[_builtins.str] = None,
                 provision_after_extensions: Optional[Sequence[_builtins.str]] = None,
                 settings: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Specifies the name of the extension.
        :param _builtins.str publisher: The publisher of the extension, available publishers can be found by using the Azure CLI.
        :param _builtins.str type: The type of extension, available types for a publisher can be found using the Azure CLI.
        :param _builtins.str type_handler_version: Specifies the version of the extension to use, available versions can be found using the Azure CLI.
        :param _builtins.bool auto_upgrade_minor_version: Specifies whether or not to use the latest minor version available.
        :param _builtins.str protected_settings: The protected_settings passed to the extension, like settings, these are specified as a JSON object in a string.
        :param Sequence[_builtins.str] provision_after_extensions: Specifies a dependency array of extensions required to be executed before, the array stores the name of each extension.
        :param _builtins.str settings: The settings passed to the extension, these are specified as a JSON object in a string.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "type_handler_version", type_handler_version)
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if protected_settings is not None:
            pulumi.set(__self__, "protected_settings", protected_settings)
        if provision_after_extensions is not None:
            pulumi.set(__self__, "provision_after_extensions", provision_after_extensions)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the extension.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        """
        The publisher of the extension, available publishers can be found by using the Azure CLI.
        """
        return pulumi.get(self, "publisher")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of extension, available types for a publisher can be found using the Azure CLI.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> _builtins.str:
        """
        Specifies the version of the extension to use, available versions can be found using the Azure CLI.
        """
        return pulumi.get(self, "type_handler_version")

    @_builtins.property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[_builtins.bool]:
        """
        Specifies whether or not to use the latest minor version available.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @_builtins.property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> Optional[_builtins.str]:
        """
        The protected_settings passed to the extension, like settings, these are specified as a JSON object in a string.
        """
        return pulumi.get(self, "protected_settings")

    @_builtins.property
    @pulumi.getter(name="provisionAfterExtensions")
    def provision_after_extensions(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a dependency array of extensions required to be executed before, the array stores the name of each extension.
        """
        return pulumi.get(self, "provision_after_extensions")

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[_builtins.str]:
        """
        The settings passed to the extension, these are specified as a JSON object in a string.
        """
        return pulumi.get(self, "settings")


@pulumi.output_type
class ScaleSetIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSetIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSetIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSetIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the identity type to be assigned to the scale set. Allowable values are `SystemAssigned` and `UserAssigned`. For the `SystemAssigned` identity the scale set's Service Principal ID (SPN) can be retrieved after the scale set has been created. See [documentation](https://docs.microsoft.com/azure/active-directory/managed-service-identity/overview) for more information. Possible values are `SystemAssigned`, `UserAssigned` and `SystemAssigned, UserAssigned`.
        :param Sequence[_builtins.str] identity_ids: Specifies a list of user managed identity ids to be assigned to the VMSS. Required if `type` is `UserAssigned`.
               
               ```python
               import pulumi
               import pulumi_azure as azure
               
               example = azure.compute.ScaleSet("example",
                   name="vm-scaleset",
                   resource_group_name=example_azurerm_resource_group["name"],
                   location=example_azurerm_resource_group["location"],
                   sku={
                       "name": vm_sku,
                       "tier": "Standard",
                       "capacity": instance_count,
                   },
                   identity={
                       "type": "SystemAssigned",
                   },
                   extensions=[{
                       "name": "MSILinuxExtension",
                       "publisher": "Microsoft.ManagedIdentity",
                       "type": "ManagedIdentityExtensionForLinux",
                       "type_handler_version": "1.0",
                       "settings": "{\\"port\\": 50342}",
                   }])
               pulumi.export("principalId", example.identity.principal_id)
               ```
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the identity type to be assigned to the scale set. Allowable values are `SystemAssigned` and `UserAssigned`. For the `SystemAssigned` identity the scale set's Service Principal ID (SPN) can be retrieved after the scale set has been created. See [documentation](https://docs.microsoft.com/azure/active-directory/managed-service-identity/overview) for more information. Possible values are `SystemAssigned`, `UserAssigned` and `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of user managed identity ids to be assigned to the VMSS. Required if `type` is `UserAssigned`.

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.compute.ScaleSet("example",
            name="vm-scaleset",
            resource_group_name=example_azurerm_resource_group["name"],
            location=example_azurerm_resource_group["location"],
            sku={
                "name": vm_sku,
                "tier": "Standard",
                "capacity": instance_count,
            },
            identity={
                "type": "SystemAssigned",
            },
            extensions=[{
                "name": "MSILinuxExtension",
                "publisher": "Microsoft.ManagedIdentity",
                "type": "ManagedIdentityExtensionForLinux",
                "type_handler_version": "1.0",
                "settings": "{\\"port\\": 50342}",
            }])
        pulumi.export("principalId", example.identity.principal_id)
        ```
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class ScaleSetNetworkProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipConfigurations":
            suggest = "ip_configurations"
        elif key == "acceleratedNetworking":
            suggest = "accelerated_networking"
        elif key == "dnsSettings":
            suggest = "dns_settings"
        elif key == "ipForwarding":
            suggest = "ip_forwarding"
        elif key == "networkSecurityGroupId":
            suggest = "network_security_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSetNetworkProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSetNetworkProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSetNetworkProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_configurations: Sequence['outputs.ScaleSetNetworkProfileIpConfiguration'],
                 name: _builtins.str,
                 primary: _builtins.bool,
                 accelerated_networking: Optional[_builtins.bool] = None,
                 dns_settings: Optional['outputs.ScaleSetNetworkProfileDnsSettings'] = None,
                 ip_forwarding: Optional[_builtins.bool] = None,
                 network_security_group_id: Optional[_builtins.str] = None):
        """
        :param Sequence['ScaleSetNetworkProfileIpConfigurationArgs'] ip_configurations: An `ip_configuration` block as documented below.
        :param _builtins.str name: Specifies the name of the network interface configuration.
        :param _builtins.bool primary: Indicates whether network interfaces created from the network interface configuration will be the primary NIC of the VM.
        :param _builtins.bool accelerated_networking: Specifies whether to enable accelerated networking or not.
        :param 'ScaleSetNetworkProfileDnsSettingsArgs' dns_settings: A `dns_settings` block as documented below.
        :param _builtins.bool ip_forwarding: Whether IP forwarding is enabled on this NIC. Defaults to `false`.
        :param _builtins.str network_security_group_id: Specifies the identifier for the network security group.
        """
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "primary", primary)
        if accelerated_networking is not None:
            pulumi.set(__self__, "accelerated_networking", accelerated_networking)
        if dns_settings is not None:
            pulumi.set(__self__, "dns_settings", dns_settings)
        if ip_forwarding is not None:
            pulumi.set(__self__, "ip_forwarding", ip_forwarding)
        if network_security_group_id is not None:
            pulumi.set(__self__, "network_security_group_id", network_security_group_id)

    @_builtins.property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Sequence['outputs.ScaleSetNetworkProfileIpConfiguration']:
        """
        An `ip_configuration` block as documented below.
        """
        return pulumi.get(self, "ip_configurations")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the network interface configuration.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def primary(self) -> _builtins.bool:
        """
        Indicates whether network interfaces created from the network interface configuration will be the primary NIC of the VM.
        """
        return pulumi.get(self, "primary")

    @_builtins.property
    @pulumi.getter(name="acceleratedNetworking")
    def accelerated_networking(self) -> Optional[_builtins.bool]:
        """
        Specifies whether to enable accelerated networking or not.
        """
        return pulumi.get(self, "accelerated_networking")

    @_builtins.property
    @pulumi.getter(name="dnsSettings")
    def dns_settings(self) -> Optional['outputs.ScaleSetNetworkProfileDnsSettings']:
        """
        A `dns_settings` block as documented below.
        """
        return pulumi.get(self, "dns_settings")

    @_builtins.property
    @pulumi.getter(name="ipForwarding")
    def ip_forwarding(self) -> Optional[_builtins.bool]:
        """
        Whether IP forwarding is enabled on this NIC. Defaults to `false`.
        """
        return pulumi.get(self, "ip_forwarding")

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupId")
    def network_security_group_id(self) -> Optional[_builtins.str]:
        """
        Specifies the identifier for the network security group.
        """
        return pulumi.get(self, "network_security_group_id")


@pulumi.output_type
class ScaleSetNetworkProfileDnsSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsServers":
            suggest = "dns_servers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSetNetworkProfileDnsSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSetNetworkProfileDnsSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSetNetworkProfileDnsSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_servers: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] dns_servers: Specifies an array of DNS servers.
        """
        pulumi.set(__self__, "dns_servers", dns_servers)

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Sequence[_builtins.str]:
        """
        Specifies an array of DNS servers.
        """
        return pulumi.get(self, "dns_servers")


@pulumi.output_type
class ScaleSetNetworkProfileIpConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "applicationGatewayBackendAddressPoolIds":
            suggest = "application_gateway_backend_address_pool_ids"
        elif key == "applicationSecurityGroupIds":
            suggest = "application_security_group_ids"
        elif key == "loadBalancerBackendAddressPoolIds":
            suggest = "load_balancer_backend_address_pool_ids"
        elif key == "loadBalancerInboundNatRulesIds":
            suggest = "load_balancer_inbound_nat_rules_ids"
        elif key == "publicIpAddressConfiguration":
            suggest = "public_ip_address_configuration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSetNetworkProfileIpConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSetNetworkProfileIpConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSetNetworkProfileIpConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 primary: _builtins.bool,
                 subnet_id: _builtins.str,
                 application_gateway_backend_address_pool_ids: Optional[Sequence[_builtins.str]] = None,
                 application_security_group_ids: Optional[Sequence[_builtins.str]] = None,
                 load_balancer_backend_address_pool_ids: Optional[Sequence[_builtins.str]] = None,
                 load_balancer_inbound_nat_rules_ids: Optional[Sequence[_builtins.str]] = None,
                 public_ip_address_configuration: Optional['outputs.ScaleSetNetworkProfileIpConfigurationPublicIpAddressConfiguration'] = None):
        """
        :param _builtins.str name: Specifies name of the IP configuration.
        :param _builtins.bool primary: Specifies if this ip_configuration is the primary one.
        :param _builtins.str subnet_id: Specifies the identifier of the subnet.
        :param Sequence[_builtins.str] application_gateway_backend_address_pool_ids: Specifies an array of references to backend address pools of application gateways. A scale set can reference backend address pools of multiple application gateways. Multiple scale sets can use the same application gateway.
        :param Sequence[_builtins.str] application_security_group_ids: Specifies up to `20` application security group IDs.
        :param Sequence[_builtins.str] load_balancer_backend_address_pool_ids: Specifies an array of references to backend address pools of load balancers. A scale set can reference backend address pools of one public and one internal load balancer. Multiple scale sets cannot use the same load balancer.
               
               > **NOTE:** When using this field you'll also need to configure a Rule for the Load Balancer, and use a `depends_on` between this resource and the Load Balancer Rule.
        :param Sequence[_builtins.str] load_balancer_inbound_nat_rules_ids: Specifies an array of references to inbound NAT pools for load balancers. A scale set can reference inbound NAT pools of one public and one internal load balancer. Multiple scale sets cannot use the same load balancer.
               
               > **NOTE:** When using this field you'll also need to configure a Rule for the Load Balancer, and use a `depends_on` between this resource and the Load Balancer Rule.
        :param 'ScaleSetNetworkProfileIpConfigurationPublicIpAddressConfigurationArgs' public_ip_address_configuration: Describes a virtual machines scale set IP Configuration's PublicIPAddress configuration. The `public_ip_address_configuration` block is documented below.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "primary", primary)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if application_gateway_backend_address_pool_ids is not None:
            pulumi.set(__self__, "application_gateway_backend_address_pool_ids", application_gateway_backend_address_pool_ids)
        if application_security_group_ids is not None:
            pulumi.set(__self__, "application_security_group_ids", application_security_group_ids)
        if load_balancer_backend_address_pool_ids is not None:
            pulumi.set(__self__, "load_balancer_backend_address_pool_ids", load_balancer_backend_address_pool_ids)
        if load_balancer_inbound_nat_rules_ids is not None:
            pulumi.set(__self__, "load_balancer_inbound_nat_rules_ids", load_balancer_inbound_nat_rules_ids)
        if public_ip_address_configuration is not None:
            pulumi.set(__self__, "public_ip_address_configuration", public_ip_address_configuration)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies name of the IP configuration.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def primary(self) -> _builtins.bool:
        """
        Specifies if this ip_configuration is the primary one.
        """
        return pulumi.get(self, "primary")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        Specifies the identifier of the subnet.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="applicationGatewayBackendAddressPoolIds")
    def application_gateway_backend_address_pool_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies an array of references to backend address pools of application gateways. A scale set can reference backend address pools of multiple application gateways. Multiple scale sets can use the same application gateway.
        """
        return pulumi.get(self, "application_gateway_backend_address_pool_ids")

    @_builtins.property
    @pulumi.getter(name="applicationSecurityGroupIds")
    def application_security_group_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies up to `20` application security group IDs.
        """
        return pulumi.get(self, "application_security_group_ids")

    @_builtins.property
    @pulumi.getter(name="loadBalancerBackendAddressPoolIds")
    def load_balancer_backend_address_pool_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies an array of references to backend address pools of load balancers. A scale set can reference backend address pools of one public and one internal load balancer. Multiple scale sets cannot use the same load balancer.

        > **NOTE:** When using this field you'll also need to configure a Rule for the Load Balancer, and use a `depends_on` between this resource and the Load Balancer Rule.
        """
        return pulumi.get(self, "load_balancer_backend_address_pool_ids")

    @_builtins.property
    @pulumi.getter(name="loadBalancerInboundNatRulesIds")
    def load_balancer_inbound_nat_rules_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies an array of references to inbound NAT pools for load balancers. A scale set can reference inbound NAT pools of one public and one internal load balancer. Multiple scale sets cannot use the same load balancer.

        > **NOTE:** When using this field you'll also need to configure a Rule for the Load Balancer, and use a `depends_on` between this resource and the Load Balancer Rule.
        """
        return pulumi.get(self, "load_balancer_inbound_nat_rules_ids")

    @_builtins.property
    @pulumi.getter(name="publicIpAddressConfiguration")
    def public_ip_address_configuration(self) -> Optional['outputs.ScaleSetNetworkProfileIpConfigurationPublicIpAddressConfiguration']:
        """
        Describes a virtual machines scale set IP Configuration's PublicIPAddress configuration. The `public_ip_address_configuration` block is documented below.
        """
        return pulumi.get(self, "public_ip_address_configuration")


@pulumi.output_type
class ScaleSetNetworkProfileIpConfigurationPublicIpAddressConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainNameLabel":
            suggest = "domain_name_label"
        elif key == "idleTimeout":
            suggest = "idle_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSetNetworkProfileIpConfigurationPublicIpAddressConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSetNetworkProfileIpConfigurationPublicIpAddressConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSetNetworkProfileIpConfigurationPublicIpAddressConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain_name_label: _builtins.str,
                 idle_timeout: _builtins.int,
                 name: _builtins.str):
        """
        :param _builtins.str domain_name_label: The domain name label for the DNS settings.
        :param _builtins.int idle_timeout: The idle timeout in minutes. This value must be between 4 and 30.
        :param _builtins.str name: The name of the public IP address configuration
        """
        pulumi.set(__self__, "domain_name_label", domain_name_label)
        pulumi.set(__self__, "idle_timeout", idle_timeout)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="domainNameLabel")
    def domain_name_label(self) -> _builtins.str:
        """
        The domain name label for the DNS settings.
        """
        return pulumi.get(self, "domain_name_label")

    @_builtins.property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> _builtins.int:
        """
        The idle timeout in minutes. This value must be between 4 and 30.
        """
        return pulumi.get(self, "idle_timeout")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the public IP address configuration
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ScaleSetOsProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminUsername":
            suggest = "admin_username"
        elif key == "computerNamePrefix":
            suggest = "computer_name_prefix"
        elif key == "adminPassword":
            suggest = "admin_password"
        elif key == "customData":
            suggest = "custom_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSetOsProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSetOsProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSetOsProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_username: _builtins.str,
                 computer_name_prefix: _builtins.str,
                 admin_password: Optional[_builtins.str] = None,
                 custom_data: Optional[_builtins.str] = None):
        """
        :param _builtins.str admin_username: Specifies the administrator account name to use for all the instances of virtual machines in the scale set.
        :param _builtins.str computer_name_prefix: Specifies the computer name prefix for all of the virtual machines in the scale set. Computer name prefixes must be 1 to 9 characters long for windows images and 1 - 58 for Linux. Changing this forces a new resource to be created.
        :param _builtins.str admin_password: Specifies the administrator password to use for all the instances of virtual machines in a scale set.
        :param _builtins.str custom_data: Specifies custom data to supply to the machine. On Linux-based systems, this can be used as a cloud-init script. On other systems, this will be copied as a file on disk. Internally, this provider will base64 encode this value before sending it to the API. The maximum length of the binary array is 65535 bytes.
        """
        pulumi.set(__self__, "admin_username", admin_username)
        pulumi.set(__self__, "computer_name_prefix", computer_name_prefix)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if custom_data is not None:
            pulumi.set(__self__, "custom_data", custom_data)

    @_builtins.property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> _builtins.str:
        """
        Specifies the administrator account name to use for all the instances of virtual machines in the scale set.
        """
        return pulumi.get(self, "admin_username")

    @_builtins.property
    @pulumi.getter(name="computerNamePrefix")
    def computer_name_prefix(self) -> _builtins.str:
        """
        Specifies the computer name prefix for all of the virtual machines in the scale set. Computer name prefixes must be 1 to 9 characters long for windows images and 1 - 58 for Linux. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "computer_name_prefix")

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[_builtins.str]:
        """
        Specifies the administrator password to use for all the instances of virtual machines in a scale set.
        """
        return pulumi.get(self, "admin_password")

    @_builtins.property
    @pulumi.getter(name="customData")
    def custom_data(self) -> Optional[_builtins.str]:
        """
        Specifies custom data to supply to the machine. On Linux-based systems, this can be used as a cloud-init script. On other systems, this will be copied as a file on disk. Internally, this provider will base64 encode this value before sending it to the API. The maximum length of the binary array is 65535 bytes.
        """
        return pulumi.get(self, "custom_data")


@pulumi.output_type
class ScaleSetOsProfileLinuxConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disablePasswordAuthentication":
            suggest = "disable_password_authentication"
        elif key == "sshKeys":
            suggest = "ssh_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSetOsProfileLinuxConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSetOsProfileLinuxConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSetOsProfileLinuxConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_password_authentication: Optional[_builtins.bool] = None,
                 ssh_keys: Optional[Sequence['outputs.ScaleSetOsProfileLinuxConfigSshKey']] = None):
        """
        :param _builtins.bool disable_password_authentication: Specifies whether password authentication should be disabled. Defaults to `false`. Changing this forces a new resource to be created.
        :param Sequence['ScaleSetOsProfileLinuxConfigSshKeyArgs'] ssh_keys: One or more `ssh_keys` blocks as defined below.
               
               > **Note:** Please note that the only allowed `path` is `/home/<username>/.ssh/authorized_keys` due to a limitation of Azure.
               
               > **NOTE:** At least one `ssh_keys` block is required if `disable_password_authentication` is set to `true`.
        """
        if disable_password_authentication is not None:
            pulumi.set(__self__, "disable_password_authentication", disable_password_authentication)
        if ssh_keys is not None:
            pulumi.set(__self__, "ssh_keys", ssh_keys)

    @_builtins.property
    @pulumi.getter(name="disablePasswordAuthentication")
    def disable_password_authentication(self) -> Optional[_builtins.bool]:
        """
        Specifies whether password authentication should be disabled. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "disable_password_authentication")

    @_builtins.property
    @pulumi.getter(name="sshKeys")
    def ssh_keys(self) -> Optional[Sequence['outputs.ScaleSetOsProfileLinuxConfigSshKey']]:
        """
        One or more `ssh_keys` blocks as defined below.

        > **Note:** Please note that the only allowed `path` is `/home/<username>/.ssh/authorized_keys` due to a limitation of Azure.

        > **NOTE:** At least one `ssh_keys` block is required if `disable_password_authentication` is set to `true`.
        """
        return pulumi.get(self, "ssh_keys")


@pulumi.output_type
class ScaleSetOsProfileLinuxConfigSshKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyData":
            suggest = "key_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSetOsProfileLinuxConfigSshKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSetOsProfileLinuxConfigSshKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSetOsProfileLinuxConfigSshKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: _builtins.str,
                 key_data: Optional[_builtins.str] = None):
        """
        :param _builtins.str path: The path of the destination file on the virtual machine
               
               > **NOTE:** Due to a limitation in the Azure VM Agent the only allowed `path` is `/home/{username}/.ssh/authorized_keys`.
        :param _builtins.str key_data: The Public SSH Key which should be written to the `path` defined above.
               
               > **Note:** Azure only supports RSA SSH2 key signatures of at least 2048 bits in length
               
               > **NOTE:** Rather than defining this in-line you can source this from a local file using the `file` function - for example `key_data = file("~/.ssh/id_rsa.pub")`.
        """
        pulumi.set(__self__, "path", path)
        if key_data is not None:
            pulumi.set(__self__, "key_data", key_data)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path of the destination file on the virtual machine

        > **NOTE:** Due to a limitation in the Azure VM Agent the only allowed `path` is `/home/{username}/.ssh/authorized_keys`.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="keyData")
    def key_data(self) -> Optional[_builtins.str]:
        """
        The Public SSH Key which should be written to the `path` defined above.

        > **Note:** Azure only supports RSA SSH2 key signatures of at least 2048 bits in length

        > **NOTE:** Rather than defining this in-line you can source this from a local file using the `file` function - for example `key_data = file("~/.ssh/id_rsa.pub")`.
        """
        return pulumi.get(self, "key_data")


@pulumi.output_type
class ScaleSetOsProfileSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceVaultId":
            suggest = "source_vault_id"
        elif key == "vaultCertificates":
            suggest = "vault_certificates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSetOsProfileSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSetOsProfileSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSetOsProfileSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_vault_id: _builtins.str,
                 vault_certificates: Optional[Sequence['outputs.ScaleSetOsProfileSecretVaultCertificate']] = None):
        """
        :param _builtins.str source_vault_id: Specifies the key vault to use.
        :param Sequence['ScaleSetOsProfileSecretVaultCertificateArgs'] vault_certificates: (Required, on Windows machines) One or more `vault_certificates` blocks as defined below.
        """
        pulumi.set(__self__, "source_vault_id", source_vault_id)
        if vault_certificates is not None:
            pulumi.set(__self__, "vault_certificates", vault_certificates)

    @_builtins.property
    @pulumi.getter(name="sourceVaultId")
    def source_vault_id(self) -> _builtins.str:
        """
        Specifies the key vault to use.
        """
        return pulumi.get(self, "source_vault_id")

    @_builtins.property
    @pulumi.getter(name="vaultCertificates")
    def vault_certificates(self) -> Optional[Sequence['outputs.ScaleSetOsProfileSecretVaultCertificate']]:
        """
        (Required, on Windows machines) One or more `vault_certificates` blocks as defined below.
        """
        return pulumi.get(self, "vault_certificates")


@pulumi.output_type
class ScaleSetOsProfileSecretVaultCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateUrl":
            suggest = "certificate_url"
        elif key == "certificateStore":
            suggest = "certificate_store"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSetOsProfileSecretVaultCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSetOsProfileSecretVaultCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSetOsProfileSecretVaultCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_url: _builtins.str,
                 certificate_store: Optional[_builtins.str] = None):
        """
        :param _builtins.str certificate_url: It is the Base64 encoding of a JSON Object that which is encoded in UTF-8 of which the contents need to be `data`, `dataType` and `password`.
        :param _builtins.str certificate_store: (Required, on windows machines) Specifies the certificate store on the Virtual Machine where the certificate should be added to.
        """
        pulumi.set(__self__, "certificate_url", certificate_url)
        if certificate_store is not None:
            pulumi.set(__self__, "certificate_store", certificate_store)

    @_builtins.property
    @pulumi.getter(name="certificateUrl")
    def certificate_url(self) -> _builtins.str:
        """
        It is the Base64 encoding of a JSON Object that which is encoded in UTF-8 of which the contents need to be `data`, `dataType` and `password`.
        """
        return pulumi.get(self, "certificate_url")

    @_builtins.property
    @pulumi.getter(name="certificateStore")
    def certificate_store(self) -> Optional[_builtins.str]:
        """
        (Required, on windows machines) Specifies the certificate store on the Virtual Machine where the certificate should be added to.
        """
        return pulumi.get(self, "certificate_store")


@pulumi.output_type
class ScaleSetOsProfileWindowsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalUnattendConfigs":
            suggest = "additional_unattend_configs"
        elif key == "enableAutomaticUpgrades":
            suggest = "enable_automatic_upgrades"
        elif key == "provisionVmAgent":
            suggest = "provision_vm_agent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSetOsProfileWindowsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSetOsProfileWindowsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSetOsProfileWindowsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_unattend_configs: Optional[Sequence['outputs.ScaleSetOsProfileWindowsConfigAdditionalUnattendConfig']] = None,
                 enable_automatic_upgrades: Optional[_builtins.bool] = None,
                 provision_vm_agent: Optional[_builtins.bool] = None,
                 winrms: Optional[Sequence['outputs.ScaleSetOsProfileWindowsConfigWinrm']] = None):
        """
        :param Sequence['ScaleSetOsProfileWindowsConfigAdditionalUnattendConfigArgs'] additional_unattend_configs: An `additional_unattend_config` block as documented below.
        :param _builtins.bool enable_automatic_upgrades: Indicates whether virtual machines in the scale set are enabled for automatic updates.
        :param _builtins.bool provision_vm_agent: Indicates whether virtual machine agent should be provisioned on the virtual machines in the scale set.
        :param Sequence['ScaleSetOsProfileWindowsConfigWinrmArgs'] winrms: A collection of `winrm` blocks as documented below.
        """
        if additional_unattend_configs is not None:
            pulumi.set(__self__, "additional_unattend_configs", additional_unattend_configs)
        if enable_automatic_upgrades is not None:
            pulumi.set(__self__, "enable_automatic_upgrades", enable_automatic_upgrades)
        if provision_vm_agent is not None:
            pulumi.set(__self__, "provision_vm_agent", provision_vm_agent)
        if winrms is not None:
            pulumi.set(__self__, "winrms", winrms)

    @_builtins.property
    @pulumi.getter(name="additionalUnattendConfigs")
    def additional_unattend_configs(self) -> Optional[Sequence['outputs.ScaleSetOsProfileWindowsConfigAdditionalUnattendConfig']]:
        """
        An `additional_unattend_config` block as documented below.
        """
        return pulumi.get(self, "additional_unattend_configs")

    @_builtins.property
    @pulumi.getter(name="enableAutomaticUpgrades")
    def enable_automatic_upgrades(self) -> Optional[_builtins.bool]:
        """
        Indicates whether virtual machines in the scale set are enabled for automatic updates.
        """
        return pulumi.get(self, "enable_automatic_upgrades")

    @_builtins.property
    @pulumi.getter(name="provisionVmAgent")
    def provision_vm_agent(self) -> Optional[_builtins.bool]:
        """
        Indicates whether virtual machine agent should be provisioned on the virtual machines in the scale set.
        """
        return pulumi.get(self, "provision_vm_agent")

    @_builtins.property
    @pulumi.getter
    def winrms(self) -> Optional[Sequence['outputs.ScaleSetOsProfileWindowsConfigWinrm']]:
        """
        A collection of `winrm` blocks as documented below.
        """
        return pulumi.get(self, "winrms")


@pulumi.output_type
class ScaleSetOsProfileWindowsConfigAdditionalUnattendConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pass":
            suggest = "pass_"
        elif key == "settingName":
            suggest = "setting_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSetOsProfileWindowsConfigAdditionalUnattendConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSetOsProfileWindowsConfigAdditionalUnattendConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSetOsProfileWindowsConfigAdditionalUnattendConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component: _builtins.str,
                 content: _builtins.str,
                 pass_: _builtins.str,
                 setting_name: _builtins.str):
        """
        :param _builtins.str component: Specifies the name of the component to configure with the added content. The only allowable value is `Microsoft-Windows-Shell-Setup`.
        :param _builtins.str content: Specifies the base-64 encoded XML formatted content that is added to the unattend.xml file for the specified path and component.
        :param _builtins.str pass_: Specifies the name of the pass that the content applies to. The only allowable value is `oobeSystem`.
        :param _builtins.str setting_name: Specifies the name of the setting to which the content applies. Possible values are: `FirstLogonCommands` and `AutoLogon`.
        """
        pulumi.set(__self__, "component", component)
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "pass_", pass_)
        pulumi.set(__self__, "setting_name", setting_name)

    @_builtins.property
    @pulumi.getter
    def component(self) -> _builtins.str:
        """
        Specifies the name of the component to configure with the added content. The only allowable value is `Microsoft-Windows-Shell-Setup`.
        """
        return pulumi.get(self, "component")

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        Specifies the base-64 encoded XML formatted content that is added to the unattend.xml file for the specified path and component.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="pass")
    def pass_(self) -> _builtins.str:
        """
        Specifies the name of the pass that the content applies to. The only allowable value is `oobeSystem`.
        """
        return pulumi.get(self, "pass_")

    @_builtins.property
    @pulumi.getter(name="settingName")
    def setting_name(self) -> _builtins.str:
        """
        Specifies the name of the setting to which the content applies. Possible values are: `FirstLogonCommands` and `AutoLogon`.
        """
        return pulumi.get(self, "setting_name")


@pulumi.output_type
class ScaleSetOsProfileWindowsConfigWinrm(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateUrl":
            suggest = "certificate_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSetOsProfileWindowsConfigWinrm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSetOsProfileWindowsConfigWinrm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSetOsProfileWindowsConfigWinrm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protocol: _builtins.str,
                 certificate_url: Optional[_builtins.str] = None):
        """
        :param _builtins.str protocol: Specifies the protocol of listener
        :param _builtins.str certificate_url: Specifies URL of the certificate with which new Virtual Machines is provisioned.
        """
        pulumi.set(__self__, "protocol", protocol)
        if certificate_url is not None:
            pulumi.set(__self__, "certificate_url", certificate_url)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Specifies the protocol of listener
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="certificateUrl")
    def certificate_url(self) -> Optional[_builtins.str]:
        """
        Specifies URL of the certificate with which new Virtual Machines is provisioned.
        """
        return pulumi.get(self, "certificate_url")


@pulumi.output_type
class ScaleSetPacketCaptureFilter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "localIpAddress":
            suggest = "local_ip_address"
        elif key == "localPort":
            suggest = "local_port"
        elif key == "remoteIpAddress":
            suggest = "remote_ip_address"
        elif key == "remotePort":
            suggest = "remote_port"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSetPacketCaptureFilter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSetPacketCaptureFilter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSetPacketCaptureFilter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protocol: _builtins.str,
                 local_ip_address: Optional[_builtins.str] = None,
                 local_port: Optional[_builtins.str] = None,
                 remote_ip_address: Optional[_builtins.str] = None,
                 remote_port: Optional[_builtins.str] = None):
        """
        :param _builtins.str protocol: The Protocol to be filtered on. Possible values include `Any`, `TCP` and `UDP`. Changing this forces a new resource to be created.
        :param _builtins.str local_ip_address: The local IP Address to be filtered on. Specify `127.0.0.1` for a single address entry, `127.0.0.1-127.0.0.255` for a range and `127.0.0.1;127.0.0.5` for multiple entries. Multiple ranges and mixing ranges with multiple entries are currently not supported. Changing this forces a new resource to be created.
        :param _builtins.str local_port: The local port to be filtered on. Specify `80` for single port entry, `80-85` for a range and `80;443;` for multiple entries. Multiple ranges and mixing ranges with multiple entries are currently not supported. Changing this forces a new resource to be created.
        :param _builtins.str remote_ip_address: The remote IP Address to be filtered on. Specify `127.0.0.1` for a single address entry, `127.0.0.1-127.0.0.255` for a range and `127.0.0.1;127.0.0.5` for multiple entries. Multiple ranges and mixing ranges with multiple entries are currently not supported. Changing this forces a new resource to be created.
        :param _builtins.str remote_port: The remote port to be filtered on. Specify `80` for single port entry, `80-85` for a range and `80;443;` for multiple entries. Multiple ranges and mixing ranges with multiple entries are currently not supported. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "protocol", protocol)
        if local_ip_address is not None:
            pulumi.set(__self__, "local_ip_address", local_ip_address)
        if local_port is not None:
            pulumi.set(__self__, "local_port", local_port)
        if remote_ip_address is not None:
            pulumi.set(__self__, "remote_ip_address", remote_ip_address)
        if remote_port is not None:
            pulumi.set(__self__, "remote_port", remote_port)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The Protocol to be filtered on. Possible values include `Any`, `TCP` and `UDP`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="localIpAddress")
    def local_ip_address(self) -> Optional[_builtins.str]:
        """
        The local IP Address to be filtered on. Specify `127.0.0.1` for a single address entry, `127.0.0.1-127.0.0.255` for a range and `127.0.0.1;127.0.0.5` for multiple entries. Multiple ranges and mixing ranges with multiple entries are currently not supported. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "local_ip_address")

    @_builtins.property
    @pulumi.getter(name="localPort")
    def local_port(self) -> Optional[_builtins.str]:
        """
        The local port to be filtered on. Specify `80` for single port entry, `80-85` for a range and `80;443;` for multiple entries. Multiple ranges and mixing ranges with multiple entries are currently not supported. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "local_port")

    @_builtins.property
    @pulumi.getter(name="remoteIpAddress")
    def remote_ip_address(self) -> Optional[_builtins.str]:
        """
        The remote IP Address to be filtered on. Specify `127.0.0.1` for a single address entry, `127.0.0.1-127.0.0.255` for a range and `127.0.0.1;127.0.0.5` for multiple entries. Multiple ranges and mixing ranges with multiple entries are currently not supported. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "remote_ip_address")

    @_builtins.property
    @pulumi.getter(name="remotePort")
    def remote_port(self) -> Optional[_builtins.str]:
        """
        The remote port to be filtered on. Specify `80` for single port entry, `80-85` for a range and `80;443;` for multiple entries. Multiple ranges and mixing ranges with multiple entries are currently not supported. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "remote_port")


@pulumi.output_type
class ScaleSetPacketCaptureMachineScope(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "excludeInstanceIds":
            suggest = "exclude_instance_ids"
        elif key == "includeInstanceIds":
            suggest = "include_instance_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSetPacketCaptureMachineScope. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSetPacketCaptureMachineScope.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSetPacketCaptureMachineScope.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exclude_instance_ids: Optional[Sequence[_builtins.str]] = None,
                 include_instance_ids: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] exclude_instance_ids: A list of Virtual Machine Scale Set instance IDs which should be excluded from running Packet Capture, e.g. `["0", "2"]`. Changing this forces a new resource to be created.
        :param Sequence[_builtins.str] include_instance_ids: A list of Virtual Machine Scale Set instance IDs which should be included for Packet Capture, e.g. `["1", "3"]`. Changing this forces a new resource to be created.
        """
        if exclude_instance_ids is not None:
            pulumi.set(__self__, "exclude_instance_ids", exclude_instance_ids)
        if include_instance_ids is not None:
            pulumi.set(__self__, "include_instance_ids", include_instance_ids)

    @_builtins.property
    @pulumi.getter(name="excludeInstanceIds")
    def exclude_instance_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of Virtual Machine Scale Set instance IDs which should be excluded from running Packet Capture, e.g. `["0", "2"]`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "exclude_instance_ids")

    @_builtins.property
    @pulumi.getter(name="includeInstanceIds")
    def include_instance_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of Virtual Machine Scale Set instance IDs which should be included for Packet Capture, e.g. `["1", "3"]`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "include_instance_ids")


@pulumi.output_type
class ScaleSetPacketCaptureStorageLocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "filePath":
            suggest = "file_path"
        elif key == "storageAccountId":
            suggest = "storage_account_id"
        elif key == "storagePath":
            suggest = "storage_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSetPacketCaptureStorageLocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSetPacketCaptureStorageLocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSetPacketCaptureStorageLocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 file_path: Optional[_builtins.str] = None,
                 storage_account_id: Optional[_builtins.str] = None,
                 storage_path: Optional[_builtins.str] = None):
        """
        :param _builtins.str file_path: A valid local path on the targeting VM. Must include the name of the capture file (*.cap). For Linux virtual machine it must start with `/var/captures`.
        :param _builtins.str storage_account_id: The ID of the storage account to save the packet capture session
               
               > **Note:** At least one of `file_path` or `storage_account_id` must be specified.
        :param _builtins.str storage_path: The URI of the storage path where the packet capture sessions are saved to.
        """
        if file_path is not None:
            pulumi.set(__self__, "file_path", file_path)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)
        if storage_path is not None:
            pulumi.set(__self__, "storage_path", storage_path)

    @_builtins.property
    @pulumi.getter(name="filePath")
    def file_path(self) -> Optional[_builtins.str]:
        """
        A valid local path on the targeting VM. Must include the name of the capture file (*.cap). For Linux virtual machine it must start with `/var/captures`.
        """
        return pulumi.get(self, "file_path")

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[_builtins.str]:
        """
        The ID of the storage account to save the packet capture session

        > **Note:** At least one of `file_path` or `storage_account_id` must be specified.
        """
        return pulumi.get(self, "storage_account_id")

    @_builtins.property
    @pulumi.getter(name="storagePath")
    def storage_path(self) -> Optional[_builtins.str]:
        """
        The URI of the storage path where the packet capture sessions are saved to.
        """
        return pulumi.get(self, "storage_path")


@pulumi.output_type
class ScaleSetPlan(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 product: _builtins.str,
                 publisher: _builtins.str):
        """
        :param _builtins.str name: Specifies the name of the image from the marketplace.
        :param _builtins.str product: Specifies the product of the image from the marketplace.
        :param _builtins.str publisher: Specifies the publisher of the image.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "publisher", publisher)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the image from the marketplace.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def product(self) -> _builtins.str:
        """
        Specifies the product of the image from the marketplace.
        """
        return pulumi.get(self, "product")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        """
        Specifies the publisher of the image.
        """
        return pulumi.get(self, "publisher")


@pulumi.output_type
class ScaleSetRollingUpgradePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxBatchInstancePercent":
            suggest = "max_batch_instance_percent"
        elif key == "maxUnhealthyInstancePercent":
            suggest = "max_unhealthy_instance_percent"
        elif key == "maxUnhealthyUpgradedInstancePercent":
            suggest = "max_unhealthy_upgraded_instance_percent"
        elif key == "pauseTimeBetweenBatches":
            suggest = "pause_time_between_batches"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSetRollingUpgradePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSetRollingUpgradePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSetRollingUpgradePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_batch_instance_percent: Optional[_builtins.int] = None,
                 max_unhealthy_instance_percent: Optional[_builtins.int] = None,
                 max_unhealthy_upgraded_instance_percent: Optional[_builtins.int] = None,
                 pause_time_between_batches: Optional[_builtins.str] = None):
        """
        :param _builtins.int max_batch_instance_percent: The maximum percent of total virtual machine instances that will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum, unhealthy instances in previous or future batches can cause the percentage of instances in a batch to decrease to ensure higher reliability. Defaults to `20`.
        :param _builtins.int max_unhealthy_instance_percent: The maximum percentage of the total virtual machine instances in the scale set that can be simultaneously unhealthy, either as a result of being upgraded, or by being found in an unhealthy state by the virtual machine health checks before the rolling upgrade aborts. This constraint will be checked prior to starting any batch. Defaults to `20`.
        :param _builtins.int max_unhealthy_upgraded_instance_percent: The maximum percentage of upgraded virtual machine instances that can be found to be in an unhealthy state. This check will happen after each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. Defaults to `20`.
        :param _builtins.str pause_time_between_batches: The wait time between completing the update for all virtual machines in one batch and starting the next batch. The time duration should be specified in ISO 8601 format for duration (<https://en.wikipedia.org/wiki/ISO_8601#Durations>). Defaults to `PT0S` seconds represented as `PT0S`.
        """
        if max_batch_instance_percent is not None:
            pulumi.set(__self__, "max_batch_instance_percent", max_batch_instance_percent)
        if max_unhealthy_instance_percent is not None:
            pulumi.set(__self__, "max_unhealthy_instance_percent", max_unhealthy_instance_percent)
        if max_unhealthy_upgraded_instance_percent is not None:
            pulumi.set(__self__, "max_unhealthy_upgraded_instance_percent", max_unhealthy_upgraded_instance_percent)
        if pause_time_between_batches is not None:
            pulumi.set(__self__, "pause_time_between_batches", pause_time_between_batches)

    @_builtins.property
    @pulumi.getter(name="maxBatchInstancePercent")
    def max_batch_instance_percent(self) -> Optional[_builtins.int]:
        """
        The maximum percent of total virtual machine instances that will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum, unhealthy instances in previous or future batches can cause the percentage of instances in a batch to decrease to ensure higher reliability. Defaults to `20`.
        """
        return pulumi.get(self, "max_batch_instance_percent")

    @_builtins.property
    @pulumi.getter(name="maxUnhealthyInstancePercent")
    def max_unhealthy_instance_percent(self) -> Optional[_builtins.int]:
        """
        The maximum percentage of the total virtual machine instances in the scale set that can be simultaneously unhealthy, either as a result of being upgraded, or by being found in an unhealthy state by the virtual machine health checks before the rolling upgrade aborts. This constraint will be checked prior to starting any batch. Defaults to `20`.
        """
        return pulumi.get(self, "max_unhealthy_instance_percent")

    @_builtins.property
    @pulumi.getter(name="maxUnhealthyUpgradedInstancePercent")
    def max_unhealthy_upgraded_instance_percent(self) -> Optional[_builtins.int]:
        """
        The maximum percentage of upgraded virtual machine instances that can be found to be in an unhealthy state. This check will happen after each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. Defaults to `20`.
        """
        return pulumi.get(self, "max_unhealthy_upgraded_instance_percent")

    @_builtins.property
    @pulumi.getter(name="pauseTimeBetweenBatches")
    def pause_time_between_batches(self) -> Optional[_builtins.str]:
        """
        The wait time between completing the update for all virtual machines in one batch and starting the next batch. The time duration should be specified in ISO 8601 format for duration (<https://en.wikipedia.org/wiki/ISO_8601#Durations>). Defaults to `PT0S` seconds represented as `PT0S`.
        """
        return pulumi.get(self, "pause_time_between_batches")


@pulumi.output_type
class ScaleSetSku(dict):
    def __init__(__self__, *,
                 capacity: _builtins.int,
                 name: _builtins.str,
                 tier: Optional[_builtins.str] = None):
        """
        :param _builtins.int capacity: Specifies the number of virtual machines in the scale set.
        :param _builtins.str name: Specifies the size of virtual machines in a scale set.
        :param _builtins.str tier: Specifies the tier of virtual machines in a scale set. Possible values, `standard` or `basic`.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "name", name)
        if tier is not None:
            pulumi.set(__self__, "tier", tier)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> _builtins.int:
        """
        Specifies the number of virtual machines in the scale set.
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the size of virtual machines in a scale set.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def tier(self) -> Optional[_builtins.str]:
        """
        Specifies the tier of virtual machines in a scale set. Possible values, `standard` or `basic`.
        """
        return pulumi.get(self, "tier")


@pulumi.output_type
class ScaleSetStandbyPoolElasticityProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxReadyCapacity":
            suggest = "max_ready_capacity"
        elif key == "minReadyCapacity":
            suggest = "min_ready_capacity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSetStandbyPoolElasticityProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSetStandbyPoolElasticityProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSetStandbyPoolElasticityProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_ready_capacity: _builtins.int,
                 min_ready_capacity: _builtins.int):
        """
        :param _builtins.int max_ready_capacity: Specifies the maximum number of virtual machines in the standby pool.
        :param _builtins.int min_ready_capacity: Specifies the desired minimum number of virtual machines in the standby pool.
               
               > **Note:** `min_ready_capacity` cannot exceed `max_ready_capacity`.
        """
        pulumi.set(__self__, "max_ready_capacity", max_ready_capacity)
        pulumi.set(__self__, "min_ready_capacity", min_ready_capacity)

    @_builtins.property
    @pulumi.getter(name="maxReadyCapacity")
    def max_ready_capacity(self) -> _builtins.int:
        """
        Specifies the maximum number of virtual machines in the standby pool.
        """
        return pulumi.get(self, "max_ready_capacity")

    @_builtins.property
    @pulumi.getter(name="minReadyCapacity")
    def min_ready_capacity(self) -> _builtins.int:
        """
        Specifies the desired minimum number of virtual machines in the standby pool.

        > **Note:** `min_ready_capacity` cannot exceed `max_ready_capacity`.
        """
        return pulumi.get(self, "min_ready_capacity")


@pulumi.output_type
class ScaleSetStorageProfileDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createOption":
            suggest = "create_option"
        elif key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "managedDiskType":
            suggest = "managed_disk_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSetStorageProfileDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSetStorageProfileDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSetStorageProfileDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_option: _builtins.str,
                 lun: _builtins.int,
                 caching: Optional[_builtins.str] = None,
                 disk_size_gb: Optional[_builtins.int] = None,
                 managed_disk_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str create_option: Specifies how the data disk should be created. The only possible options are `FromImage` and `Empty`.
        :param _builtins.int lun: Specifies the Logical Unit Number of the disk in each virtual machine in the scale set.
        :param _builtins.str caching: Specifies the caching requirements. Possible values include: `None` (default), `ReadOnly`, `ReadWrite`.
        :param _builtins.int disk_size_gb: Specifies the size of the disk in GB. This element is required when creating an empty disk.
        :param _builtins.str managed_disk_type: Specifies the type of managed disk to create. Value must be either `Standard_LRS`, `StandardSSD_LRS` or `Premium_LRS`.
        """
        pulumi.set(__self__, "create_option", create_option)
        pulumi.set(__self__, "lun", lun)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if managed_disk_type is not None:
            pulumi.set(__self__, "managed_disk_type", managed_disk_type)

    @_builtins.property
    @pulumi.getter(name="createOption")
    def create_option(self) -> _builtins.str:
        """
        Specifies how the data disk should be created. The only possible options are `FromImage` and `Empty`.
        """
        return pulumi.get(self, "create_option")

    @_builtins.property
    @pulumi.getter
    def lun(self) -> _builtins.int:
        """
        Specifies the Logical Unit Number of the disk in each virtual machine in the scale set.
        """
        return pulumi.get(self, "lun")

    @_builtins.property
    @pulumi.getter
    def caching(self) -> Optional[_builtins.str]:
        """
        Specifies the caching requirements. Possible values include: `None` (default), `ReadOnly`, `ReadWrite`.
        """
        return pulumi.get(self, "caching")

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[_builtins.int]:
        """
        Specifies the size of the disk in GB. This element is required when creating an empty disk.
        """
        return pulumi.get(self, "disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="managedDiskType")
    def managed_disk_type(self) -> Optional[_builtins.str]:
        """
        Specifies the type of managed disk to create. Value must be either `Standard_LRS`, `StandardSSD_LRS` or `Premium_LRS`.
        """
        return pulumi.get(self, "managed_disk_type")


@pulumi.output_type
class ScaleSetStorageProfileImageReference(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 offer: Optional[_builtins.str] = None,
                 publisher: Optional[_builtins.str] = None,
                 sku: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: Specifies the ID of the (custom) image to use to create the virtual machine scale set, as in the example below.
        :param _builtins.str offer: Specifies the offer of the image used to create the virtual machines.
        :param _builtins.str publisher: Specifies the publisher of the image used to create the virtual machines.
        :param _builtins.str sku: Specifies the SKU of the image used to create the virtual machines.
        :param _builtins.str version: Specifies the version of the image used to create the virtual machines.
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Specifies the ID of the (custom) image to use to create the virtual machine scale set, as in the example below.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def offer(self) -> Optional[_builtins.str]:
        """
        Specifies the offer of the image used to create the virtual machines.
        """
        return pulumi.get(self, "offer")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> Optional[_builtins.str]:
        """
        Specifies the publisher of the image used to create the virtual machines.
        """
        return pulumi.get(self, "publisher")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[_builtins.str]:
        """
        Specifies the SKU of the image used to create the virtual machines.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        Specifies the version of the image used to create the virtual machines.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class ScaleSetStorageProfileOsDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createOption":
            suggest = "create_option"
        elif key == "managedDiskType":
            suggest = "managed_disk_type"
        elif key == "osType":
            suggest = "os_type"
        elif key == "vhdContainers":
            suggest = "vhd_containers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ScaleSetStorageProfileOsDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ScaleSetStorageProfileOsDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ScaleSetStorageProfileOsDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_option: _builtins.str,
                 caching: Optional[_builtins.str] = None,
                 image: Optional[_builtins.str] = None,
                 managed_disk_type: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 os_type: Optional[_builtins.str] = None,
                 vhd_containers: Optional[Sequence[_builtins.str]] = None):
        """
        :param _builtins.str create_option: Specifies how the virtual machine should be created. The only possible option is `FromImage`.
        :param _builtins.str caching: Specifies the caching requirements. Possible values include: `None` (default), `ReadOnly`, `ReadWrite`.
        :param _builtins.str image: Specifies the blob URI for user image. A virtual machine scale set creates an os disk in the same container as the user image.
               Updating the osDisk image causes the existing disk to be deleted and a new one created with the new image. If the VM scale set is in Manual upgrade mode then the virtual machines are not updated until they have manualUpgrade applied to them.
               When setting this field `os_type` needs to be specified. Cannot be used when `vhd_containers`, `managed_disk_type` or `storage_profile_image_reference` are specified.
        :param _builtins.str managed_disk_type: Specifies the type of managed disk to create. Value you must be either `Standard_LRS`, `StandardSSD_LRS` or `Premium_LRS`. Cannot be used when `vhd_containers` or `image` is specified.
        :param _builtins.str name: Specifies the disk name. Must be specified when using unmanaged disk ('managed_disk_type' property not set).
        :param _builtins.str os_type: Specifies the operating system Type, valid values are windows, Linux.
        :param Sequence[_builtins.str] vhd_containers: Specifies the VHD URI. Cannot be used when `image` or `managed_disk_type` is specified.
        """
        pulumi.set(__self__, "create_option", create_option)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if managed_disk_type is not None:
            pulumi.set(__self__, "managed_disk_type", managed_disk_type)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if vhd_containers is not None:
            pulumi.set(__self__, "vhd_containers", vhd_containers)

    @_builtins.property
    @pulumi.getter(name="createOption")
    def create_option(self) -> _builtins.str:
        """
        Specifies how the virtual machine should be created. The only possible option is `FromImage`.
        """
        return pulumi.get(self, "create_option")

    @_builtins.property
    @pulumi.getter
    def caching(self) -> Optional[_builtins.str]:
        """
        Specifies the caching requirements. Possible values include: `None` (default), `ReadOnly`, `ReadWrite`.
        """
        return pulumi.get(self, "caching")

    @_builtins.property
    @pulumi.getter
    def image(self) -> Optional[_builtins.str]:
        """
        Specifies the blob URI for user image. A virtual machine scale set creates an os disk in the same container as the user image.
        Updating the osDisk image causes the existing disk to be deleted and a new one created with the new image. If the VM scale set is in Manual upgrade mode then the virtual machines are not updated until they have manualUpgrade applied to them.
        When setting this field `os_type` needs to be specified. Cannot be used when `vhd_containers`, `managed_disk_type` or `storage_profile_image_reference` are specified.
        """
        return pulumi.get(self, "image")

    @_builtins.property
    @pulumi.getter(name="managedDiskType")
    def managed_disk_type(self) -> Optional[_builtins.str]:
        """
        Specifies the type of managed disk to create. Value you must be either `Standard_LRS`, `StandardSSD_LRS` or `Premium_LRS`. Cannot be used when `vhd_containers` or `image` is specified.
        """
        return pulumi.get(self, "managed_disk_type")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Specifies the disk name. Must be specified when using unmanaged disk ('managed_disk_type' property not set).
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[_builtins.str]:
        """
        Specifies the operating system Type, valid values are windows, Linux.
        """
        return pulumi.get(self, "os_type")

    @_builtins.property
    @pulumi.getter(name="vhdContainers")
    def vhd_containers(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies the VHD URI. Cannot be used when `image` or `managed_disk_type` is specified.
        """
        return pulumi.get(self, "vhd_containers")


@pulumi.output_type
class SharedImageGallerySharing(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "communityGallery":
            suggest = "community_gallery"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SharedImageGallerySharing. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SharedImageGallerySharing.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SharedImageGallerySharing.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 permission: _builtins.str,
                 community_gallery: Optional['outputs.SharedImageGallerySharingCommunityGallery'] = None):
        """
        :param _builtins.str permission: The permission of the Shared Image Gallery when sharing. Possible values are `Community`, `Groups` and `Private`. Changing this forces a new resource to be created.
               
               > **Note:** This requires that the Preview Feature `Microsoft.Compute/CommunityGalleries` is enabled, see [the documentation](https://learn.microsoft.com/azure/virtual-machines/share-gallery-community?tabs=cli) for more information.
        :param 'SharedImageGallerySharingCommunityGalleryArgs' community_gallery: A `community_gallery` block as defined below. Changing this forces a new resource to be created.
               
               > **Note:** `community_gallery` must be set when `permission` is set to `Community`.
        """
        pulumi.set(__self__, "permission", permission)
        if community_gallery is not None:
            pulumi.set(__self__, "community_gallery", community_gallery)

    @_builtins.property
    @pulumi.getter
    def permission(self) -> _builtins.str:
        """
        The permission of the Shared Image Gallery when sharing. Possible values are `Community`, `Groups` and `Private`. Changing this forces a new resource to be created.

        > **Note:** This requires that the Preview Feature `Microsoft.Compute/CommunityGalleries` is enabled, see [the documentation](https://learn.microsoft.com/azure/virtual-machines/share-gallery-community?tabs=cli) for more information.
        """
        return pulumi.get(self, "permission")

    @_builtins.property
    @pulumi.getter(name="communityGallery")
    def community_gallery(self) -> Optional['outputs.SharedImageGallerySharingCommunityGallery']:
        """
        A `community_gallery` block as defined below. Changing this forces a new resource to be created.

        > **Note:** `community_gallery` must be set when `permission` is set to `Community`.
        """
        return pulumi.get(self, "community_gallery")


@pulumi.output_type
class SharedImageGallerySharingCommunityGallery(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "publisherEmail":
            suggest = "publisher_email"
        elif key == "publisherUri":
            suggest = "publisher_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SharedImageGallerySharingCommunityGallery. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SharedImageGallerySharingCommunityGallery.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SharedImageGallerySharingCommunityGallery.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 eula: _builtins.str,
                 prefix: _builtins.str,
                 publisher_email: _builtins.str,
                 publisher_uri: _builtins.str,
                 name: Optional[_builtins.str] = None):
        """
        :param _builtins.str eula: The End User Licence Agreement for the Shared Image Gallery. Changing this forces a new resource to be created.
        :param _builtins.str prefix: Prefix of the community public name for the Shared Image Gallery. Changing this forces a new resource to be created.
        :param _builtins.str publisher_email: Email of the publisher for the Shared Image Gallery. Changing this forces a new resource to be created.
        :param _builtins.str publisher_uri: URI of the publisher for the Shared Image Gallery. Changing this forces a new resource to be created.
        :param _builtins.str name: Specifies the name of the Shared Image Gallery. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "eula", eula)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "publisher_email", publisher_email)
        pulumi.set(__self__, "publisher_uri", publisher_uri)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def eula(self) -> _builtins.str:
        """
        The End User Licence Agreement for the Shared Image Gallery. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "eula")

    @_builtins.property
    @pulumi.getter
    def prefix(self) -> _builtins.str:
        """
        Prefix of the community public name for the Shared Image Gallery. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "prefix")

    @_builtins.property
    @pulumi.getter(name="publisherEmail")
    def publisher_email(self) -> _builtins.str:
        """
        Email of the publisher for the Shared Image Gallery. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher_email")

    @_builtins.property
    @pulumi.getter(name="publisherUri")
    def publisher_uri(self) -> _builtins.str:
        """
        URI of the publisher for the Shared Image Gallery. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher_uri")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Specifies the name of the Shared Image Gallery. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class SharedImageIdentifier(dict):
    def __init__(__self__, *,
                 offer: _builtins.str,
                 publisher: _builtins.str,
                 sku: _builtins.str):
        """
        :param _builtins.str offer: The Offer Name for this Shared Image. Changing this forces a new resource to be created.
        :param _builtins.str publisher: The Publisher Name for this Gallery Image. Changing this forces a new resource to be created.
        :param _builtins.str sku: The Name of the SKU for this Gallery Image. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "offer", offer)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "sku", sku)

    @_builtins.property
    @pulumi.getter
    def offer(self) -> _builtins.str:
        """
        The Offer Name for this Shared Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "offer")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        """
        The Publisher Name for this Gallery Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> _builtins.str:
        """
        The Name of the SKU for this Gallery Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku")


@pulumi.output_type
class SharedImagePurchasePlan(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 product: Optional[_builtins.str] = None,
                 publisher: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The Purchase Plan Name for this Shared Image. Changing this forces a new resource to be created.
        :param _builtins.str product: The Purchase Plan Product for this Gallery Image. Changing this forces a new resource to be created.
        :param _builtins.str publisher: The Purchase Plan Publisher for this Gallery Image. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "name", name)
        if product is not None:
            pulumi.set(__self__, "product", product)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The Purchase Plan Name for this Shared Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def product(self) -> Optional[_builtins.str]:
        """
        The Purchase Plan Product for this Gallery Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "product")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> Optional[_builtins.str]:
        """
        The Purchase Plan Publisher for this Gallery Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher")


@pulumi.output_type
class SharedImageVersionTargetRegion(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "regionalReplicaCount":
            suggest = "regional_replica_count"
        elif key == "diskEncryptionSetId":
            suggest = "disk_encryption_set_id"
        elif key == "excludeFromLatestEnabled":
            suggest = "exclude_from_latest_enabled"
        elif key == "storageAccountType":
            suggest = "storage_account_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SharedImageVersionTargetRegion. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SharedImageVersionTargetRegion.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SharedImageVersionTargetRegion.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 regional_replica_count: _builtins.int,
                 disk_encryption_set_id: Optional[_builtins.str] = None,
                 exclude_from_latest_enabled: Optional[_builtins.bool] = None,
                 storage_account_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The Azure Region in which this Image Version should exist.
        :param _builtins.int regional_replica_count: The number of replicas of the Image Version to be created per region.
        :param _builtins.str disk_encryption_set_id: The ID of the Disk Encryption Set to encrypt the Image Version in the target region. Changing this forces a new resource to be created.
        :param _builtins.bool exclude_from_latest_enabled: Specifies whether this Shared Image Version should be excluded when querying for the `latest` version. Defaults to `false`.
        :param _builtins.str storage_account_type: The storage account type for the image version. Possible values are `Standard_LRS`, `Premium_LRS` and `Standard_ZRS`. Defaults to `Standard_LRS`. You can store all of your image version replicas in Zone Redundant Storage by specifying `Standard_ZRS`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "regional_replica_count", regional_replica_count)
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if exclude_from_latest_enabled is not None:
            pulumi.set(__self__, "exclude_from_latest_enabled", exclude_from_latest_enabled)
        if storage_account_type is not None:
            pulumi.set(__self__, "storage_account_type", storage_account_type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The Azure Region in which this Image Version should exist.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="regionalReplicaCount")
    def regional_replica_count(self) -> _builtins.int:
        """
        The number of replicas of the Image Version to be created per region.
        """
        return pulumi.get(self, "regional_replica_count")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Disk Encryption Set to encrypt the Image Version in the target region. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @_builtins.property
    @pulumi.getter(name="excludeFromLatestEnabled")
    def exclude_from_latest_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether this Shared Image Version should be excluded when querying for the `latest` version. Defaults to `false`.
        """
        return pulumi.get(self, "exclude_from_latest_enabled")

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> Optional[_builtins.str]:
        """
        The storage account type for the image version. Possible values are `Standard_LRS`, `Premium_LRS` and `Standard_ZRS`. Defaults to `Standard_LRS`. You can store all of your image version replicas in Zone Redundant Storage by specifying `Standard_ZRS`.
        """
        return pulumi.get(self, "storage_account_type")


@pulumi.output_type
class SnapshotEncryptionSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskEncryptionKey":
            suggest = "disk_encryption_key"
        elif key == "keyEncryptionKey":
            suggest = "key_encryption_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SnapshotEncryptionSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SnapshotEncryptionSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SnapshotEncryptionSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disk_encryption_key: 'outputs.SnapshotEncryptionSettingsDiskEncryptionKey',
                 key_encryption_key: Optional['outputs.SnapshotEncryptionSettingsKeyEncryptionKey'] = None):
        """
        :param 'SnapshotEncryptionSettingsDiskEncryptionKeyArgs' disk_encryption_key: A `disk_encryption_key` block as defined below.
        :param 'SnapshotEncryptionSettingsKeyEncryptionKeyArgs' key_encryption_key: A `key_encryption_key` block as defined below.
        """
        pulumi.set(__self__, "disk_encryption_key", disk_encryption_key)
        if key_encryption_key is not None:
            pulumi.set(__self__, "key_encryption_key", key_encryption_key)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionKey")
    def disk_encryption_key(self) -> 'outputs.SnapshotEncryptionSettingsDiskEncryptionKey':
        """
        A `disk_encryption_key` block as defined below.
        """
        return pulumi.get(self, "disk_encryption_key")

    @_builtins.property
    @pulumi.getter(name="keyEncryptionKey")
    def key_encryption_key(self) -> Optional['outputs.SnapshotEncryptionSettingsKeyEncryptionKey']:
        """
        A `key_encryption_key` block as defined below.
        """
        return pulumi.get(self, "key_encryption_key")


@pulumi.output_type
class SnapshotEncryptionSettingsDiskEncryptionKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretUrl":
            suggest = "secret_url"
        elif key == "sourceVaultId":
            suggest = "source_vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SnapshotEncryptionSettingsDiskEncryptionKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SnapshotEncryptionSettingsDiskEncryptionKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SnapshotEncryptionSettingsDiskEncryptionKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_url: _builtins.str,
                 source_vault_id: _builtins.str):
        """
        :param _builtins.str secret_url: The URL to the Key Vault Secret used as the Disk Encryption Key. This can be found as `id` on the `keyvault.Secret` resource.
        :param _builtins.str source_vault_id: The ID of the source Key Vault. This can be found as `id` on the `keyvault.KeyVault` resource.
        """
        pulumi.set(__self__, "secret_url", secret_url)
        pulumi.set(__self__, "source_vault_id", source_vault_id)

    @_builtins.property
    @pulumi.getter(name="secretUrl")
    def secret_url(self) -> _builtins.str:
        """
        The URL to the Key Vault Secret used as the Disk Encryption Key. This can be found as `id` on the `keyvault.Secret` resource.
        """
        return pulumi.get(self, "secret_url")

    @_builtins.property
    @pulumi.getter(name="sourceVaultId")
    def source_vault_id(self) -> _builtins.str:
        """
        The ID of the source Key Vault. This can be found as `id` on the `keyvault.KeyVault` resource.
        """
        return pulumi.get(self, "source_vault_id")


@pulumi.output_type
class SnapshotEncryptionSettingsKeyEncryptionKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyUrl":
            suggest = "key_url"
        elif key == "sourceVaultId":
            suggest = "source_vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SnapshotEncryptionSettingsKeyEncryptionKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SnapshotEncryptionSettingsKeyEncryptionKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SnapshotEncryptionSettingsKeyEncryptionKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_url: _builtins.str,
                 source_vault_id: _builtins.str):
        """
        :param _builtins.str key_url: The URL to the Key Vault Key used as the Key Encryption Key. This can be found as `id` on the `keyvault.Key` resource.
        :param _builtins.str source_vault_id: The ID of the source Key Vault. This can be found as `id` on the `keyvault.KeyVault` resource.
        """
        pulumi.set(__self__, "key_url", key_url)
        pulumi.set(__self__, "source_vault_id", source_vault_id)

    @_builtins.property
    @pulumi.getter(name="keyUrl")
    def key_url(self) -> _builtins.str:
        """
        The URL to the Key Vault Key used as the Key Encryption Key. This can be found as `id` on the `keyvault.Key` resource.
        """
        return pulumi.get(self, "key_url")

    @_builtins.property
    @pulumi.getter(name="sourceVaultId")
    def source_vault_id(self) -> _builtins.str:
        """
        The ID of the source Key Vault. This can be found as `id` on the `keyvault.KeyVault` resource.
        """
        return pulumi.get(self, "source_vault_id")


@pulumi.output_type
class VirtualMachineAdditionalCapabilities(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ultraSsdEnabled":
            suggest = "ultra_ssd_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineAdditionalCapabilities. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineAdditionalCapabilities.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineAdditionalCapabilities.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ultra_ssd_enabled: _builtins.bool):
        """
        :param _builtins.bool ultra_ssd_enabled: Should Ultra SSD disk be enabled for this Virtual Machine? Changing this forces a new resource to be created.
               
               > **Note:** Azure Ultra Disk Storage is only available in a region that support availability zones and can only enabled on the following VM series: `ESv3`, `DSv3`, `FSv3`, `LSv2`, `M` and `Mv2`. For more information see the `Azure Ultra Disk Storage` [product documentation](https://docs.microsoft.com/azure/virtual-machines/windows/disks-enable-ultra-ssd).
        """
        pulumi.set(__self__, "ultra_ssd_enabled", ultra_ssd_enabled)

    @_builtins.property
    @pulumi.getter(name="ultraSsdEnabled")
    def ultra_ssd_enabled(self) -> _builtins.bool:
        """
        Should Ultra SSD disk be enabled for this Virtual Machine? Changing this forces a new resource to be created.

        > **Note:** Azure Ultra Disk Storage is only available in a region that support availability zones and can only enabled on the following VM series: `ESv3`, `DSv3`, `FSv3`, `LSv2`, `M` and `Mv2`. For more information see the `Azure Ultra Disk Storage` [product documentation](https://docs.microsoft.com/azure/virtual-machines/windows/disks-enable-ultra-ssd).
        """
        return pulumi.get(self, "ultra_ssd_enabled")


@pulumi.output_type
class VirtualMachineBootDiagnostics(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageUri":
            suggest = "storage_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineBootDiagnostics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineBootDiagnostics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineBootDiagnostics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 storage_uri: _builtins.str):
        """
        :param _builtins.bool enabled: Should Boot Diagnostics be enabled for this Virtual Machine?
        :param _builtins.str storage_uri: The Storage Account's Blob Endpoint which should hold the virtual machine's diagnostic files.
               
               > **NOTE:** This needs to be the root of a Storage Account and not a Storage Container.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "storage_uri", storage_uri)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Should Boot Diagnostics be enabled for this Virtual Machine?
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="storageUri")
    def storage_uri(self) -> _builtins.str:
        """
        The Storage Account's Blob Endpoint which should hold the virtual machine's diagnostic files.

        > **NOTE:** This needs to be the root of a Storage Account and not a Storage Container.
        """
        return pulumi.get(self, "storage_uri")


@pulumi.output_type
class VirtualMachineIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Virtual Machine. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
               
               > **NOTE:** Managed Service Identity previously required the installation of a VM Extension, but this information [is now available via the Azure Instance Metadata Service](https://docs.microsoft.com/azure/active-directory/managed-service-identity/overview#how-does-it-work).
               
               > **NOTE:** When `type` is set to `SystemAssigned`, identity the Principal ID can be retrieved after the virtual machine has been created. More details are available below. See [documentation](https://docs.microsoft.com/azure/active-directory/managed-service-identity/overview) for additional information.
        :param Sequence[_builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Virtual Machine.
               
               > **NOTE:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param _builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Virtual Machine. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).

        > **NOTE:** Managed Service Identity previously required the installation of a VM Extension, but this information [is now available via the Azure Instance Metadata Service](https://docs.microsoft.com/azure/active-directory/managed-service-identity/overview#how-does-it-work).

        > **NOTE:** When `type` is set to `SystemAssigned`, identity the Principal ID can be retrieved after the virtual machine has been created. More details are available below. See [documentation](https://docs.microsoft.com/azure/active-directory/managed-service-identity/overview) for additional information.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Virtual Machine.

        > **NOTE:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class VirtualMachineOsProfile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminUsername":
            suggest = "admin_username"
        elif key == "computerName":
            suggest = "computer_name"
        elif key == "adminPassword":
            suggest = "admin_password"
        elif key == "customData":
            suggest = "custom_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineOsProfile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineOsProfile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineOsProfile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_username: _builtins.str,
                 computer_name: _builtins.str,
                 admin_password: Optional[_builtins.str] = None,
                 custom_data: Optional[_builtins.str] = None):
        """
        :param _builtins.str admin_username: Specifies the name of the local administrator account.
        :param _builtins.str computer_name: Specifies the name of the Virtual Machine. Changing this forces a new resource to be created.
        :param _builtins.str admin_password: (Optional for Windows, Optional for Linux) The password associated with the local administrator account.
               
               > **NOTE:** If using Linux, it may be preferable to use SSH Key authentication (available in the `os_profile_linux_config` block) instead of password authentication.
        :param _builtins.str custom_data: Specifies custom data to supply to the machine. On Linux-based systems, this can be used as a cloud-init script. On other systems, this will be copied as a file on disk. Internally, this provider will base64 encode this value before sending it to the API. The maximum length of the binary array is 65535 bytes. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "admin_username", admin_username)
        pulumi.set(__self__, "computer_name", computer_name)
        if admin_password is not None:
            pulumi.set(__self__, "admin_password", admin_password)
        if custom_data is not None:
            pulumi.set(__self__, "custom_data", custom_data)

    @_builtins.property
    @pulumi.getter(name="adminUsername")
    def admin_username(self) -> _builtins.str:
        """
        Specifies the name of the local administrator account.
        """
        return pulumi.get(self, "admin_username")

    @_builtins.property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> _builtins.str:
        """
        Specifies the name of the Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "computer_name")

    @_builtins.property
    @pulumi.getter(name="adminPassword")
    def admin_password(self) -> Optional[_builtins.str]:
        """
        (Optional for Windows, Optional for Linux) The password associated with the local administrator account.

        > **NOTE:** If using Linux, it may be preferable to use SSH Key authentication (available in the `os_profile_linux_config` block) instead of password authentication.
        """
        return pulumi.get(self, "admin_password")

    @_builtins.property
    @pulumi.getter(name="customData")
    def custom_data(self) -> Optional[_builtins.str]:
        """
        Specifies custom data to supply to the machine. On Linux-based systems, this can be used as a cloud-init script. On other systems, this will be copied as a file on disk. Internally, this provider will base64 encode this value before sending it to the API. The maximum length of the binary array is 65535 bytes. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "custom_data")


@pulumi.output_type
class VirtualMachineOsProfileLinuxConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disablePasswordAuthentication":
            suggest = "disable_password_authentication"
        elif key == "sshKeys":
            suggest = "ssh_keys"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineOsProfileLinuxConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineOsProfileLinuxConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineOsProfileLinuxConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_password_authentication: _builtins.bool,
                 ssh_keys: Optional[Sequence['outputs.VirtualMachineOsProfileLinuxConfigSshKey']] = None):
        """
        :param _builtins.bool disable_password_authentication: Specifies whether password authentication should be disabled. If set to `false`, an `admin_password` must be specified.
        :param Sequence['VirtualMachineOsProfileLinuxConfigSshKeyArgs'] ssh_keys: One or more `ssh_keys` blocks as defined below. This field is required if `disable_password_authentication` is set to `true`.
        """
        pulumi.set(__self__, "disable_password_authentication", disable_password_authentication)
        if ssh_keys is not None:
            pulumi.set(__self__, "ssh_keys", ssh_keys)

    @_builtins.property
    @pulumi.getter(name="disablePasswordAuthentication")
    def disable_password_authentication(self) -> _builtins.bool:
        """
        Specifies whether password authentication should be disabled. If set to `false`, an `admin_password` must be specified.
        """
        return pulumi.get(self, "disable_password_authentication")

    @_builtins.property
    @pulumi.getter(name="sshKeys")
    def ssh_keys(self) -> Optional[Sequence['outputs.VirtualMachineOsProfileLinuxConfigSshKey']]:
        """
        One or more `ssh_keys` blocks as defined below. This field is required if `disable_password_authentication` is set to `true`.
        """
        return pulumi.get(self, "ssh_keys")


@pulumi.output_type
class VirtualMachineOsProfileLinuxConfigSshKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyData":
            suggest = "key_data"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineOsProfileLinuxConfigSshKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineOsProfileLinuxConfigSshKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineOsProfileLinuxConfigSshKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_data: _builtins.str,
                 path: _builtins.str):
        """
        :param _builtins.str key_data: The Public SSH Key which should be written to the `path` defined above.
               
               > **Note:** Azure only supports RSA SSH2 key signatures of at least 2048 bits in length
        :param _builtins.str path: The path of the destination file on the virtual machine
               
               > **NOTE:** Due to a limitation in the Azure VM Agent the only allowed `path` is `/home/{username}/.ssh/authorized_keys`.
        """
        pulumi.set(__self__, "key_data", key_data)
        pulumi.set(__self__, "path", path)

    @_builtins.property
    @pulumi.getter(name="keyData")
    def key_data(self) -> _builtins.str:
        """
        The Public SSH Key which should be written to the `path` defined above.

        > **Note:** Azure only supports RSA SSH2 key signatures of at least 2048 bits in length
        """
        return pulumi.get(self, "key_data")

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The path of the destination file on the virtual machine

        > **NOTE:** Due to a limitation in the Azure VM Agent the only allowed `path` is `/home/{username}/.ssh/authorized_keys`.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class VirtualMachineOsProfileSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceVaultId":
            suggest = "source_vault_id"
        elif key == "vaultCertificates":
            suggest = "vault_certificates"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineOsProfileSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineOsProfileSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineOsProfileSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_vault_id: _builtins.str,
                 vault_certificates: Optional[Sequence['outputs.VirtualMachineOsProfileSecretVaultCertificate']] = None):
        """
        :param _builtins.str source_vault_id: Specifies the ID of the Key Vault to use.
        :param Sequence['VirtualMachineOsProfileSecretVaultCertificateArgs'] vault_certificates: One or more `vault_certificates` blocks as defined below.
        """
        pulumi.set(__self__, "source_vault_id", source_vault_id)
        if vault_certificates is not None:
            pulumi.set(__self__, "vault_certificates", vault_certificates)

    @_builtins.property
    @pulumi.getter(name="sourceVaultId")
    def source_vault_id(self) -> _builtins.str:
        """
        Specifies the ID of the Key Vault to use.
        """
        return pulumi.get(self, "source_vault_id")

    @_builtins.property
    @pulumi.getter(name="vaultCertificates")
    def vault_certificates(self) -> Optional[Sequence['outputs.VirtualMachineOsProfileSecretVaultCertificate']]:
        """
        One or more `vault_certificates` blocks as defined below.
        """
        return pulumi.get(self, "vault_certificates")


@pulumi.output_type
class VirtualMachineOsProfileSecretVaultCertificate(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateUrl":
            suggest = "certificate_url"
        elif key == "certificateStore":
            suggest = "certificate_store"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineOsProfileSecretVaultCertificate. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineOsProfileSecretVaultCertificate.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineOsProfileSecretVaultCertificate.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificate_url: _builtins.str,
                 certificate_store: Optional[_builtins.str] = None):
        """
        :param _builtins.str certificate_url: The ID of the Key Vault Secret. Stored secret is the Base64 encoding of a JSON Object that which is encoded in UTF-8 of which the contents need to be:
               
               ```json
               {
               "data":"<Base64-encoded-certificate>",
               "dataType":"pfx",
               "password":"<pfx-file-password>"
               }
               ```
               
               > **NOTE:** If your certificate is stored in Azure Key Vault - this can be sourced from the `secret_id` property on the `keyvault.Certificate` resource.
        :param _builtins.str certificate_store: (Required, on windows machines) Specifies the certificate store on the Virtual Machine where the certificate should be added to, such as `My`.
        """
        pulumi.set(__self__, "certificate_url", certificate_url)
        if certificate_store is not None:
            pulumi.set(__self__, "certificate_store", certificate_store)

    @_builtins.property
    @pulumi.getter(name="certificateUrl")
    def certificate_url(self) -> _builtins.str:
        """
        The ID of the Key Vault Secret. Stored secret is the Base64 encoding of a JSON Object that which is encoded in UTF-8 of which the contents need to be:

        ```json
        {
        "data":"<Base64-encoded-certificate>",
        "dataType":"pfx",
        "password":"<pfx-file-password>"
        }
        ```

        > **NOTE:** If your certificate is stored in Azure Key Vault - this can be sourced from the `secret_id` property on the `keyvault.Certificate` resource.
        """
        return pulumi.get(self, "certificate_url")

    @_builtins.property
    @pulumi.getter(name="certificateStore")
    def certificate_store(self) -> Optional[_builtins.str]:
        """
        (Required, on windows machines) Specifies the certificate store on the Virtual Machine where the certificate should be added to, such as `My`.
        """
        return pulumi.get(self, "certificate_store")


@pulumi.output_type
class VirtualMachineOsProfileWindowsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "additionalUnattendConfigs":
            suggest = "additional_unattend_configs"
        elif key == "enableAutomaticUpgrades":
            suggest = "enable_automatic_upgrades"
        elif key == "provisionVmAgent":
            suggest = "provision_vm_agent"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineOsProfileWindowsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineOsProfileWindowsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineOsProfileWindowsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 additional_unattend_configs: Optional[Sequence['outputs.VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfig']] = None,
                 enable_automatic_upgrades: Optional[_builtins.bool] = None,
                 provision_vm_agent: Optional[_builtins.bool] = None,
                 timezone: Optional[_builtins.str] = None,
                 winrms: Optional[Sequence['outputs.VirtualMachineOsProfileWindowsConfigWinrm']] = None):
        """
        :param Sequence['VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfigArgs'] additional_unattend_configs: An `additional_unattend_config` block as defined below.
        :param _builtins.bool enable_automatic_upgrades: Are automatic updates enabled on this Virtual Machine? Defaults to `false`.
        :param _builtins.bool provision_vm_agent: Should the Azure Virtual Machine Guest Agent be installed on this Virtual Machine? Defaults to `false`.
               
               > **NOTE:** This is different from the Default value used for this field within Azure.
        :param _builtins.str timezone: Specifies the time zone of the virtual machine, [the possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/). Changing this forces a new resource to be created.
        :param Sequence['VirtualMachineOsProfileWindowsConfigWinrmArgs'] winrms: One or more `winrm` blocks as defined below.
        """
        if additional_unattend_configs is not None:
            pulumi.set(__self__, "additional_unattend_configs", additional_unattend_configs)
        if enable_automatic_upgrades is not None:
            pulumi.set(__self__, "enable_automatic_upgrades", enable_automatic_upgrades)
        if provision_vm_agent is not None:
            pulumi.set(__self__, "provision_vm_agent", provision_vm_agent)
        if timezone is not None:
            pulumi.set(__self__, "timezone", timezone)
        if winrms is not None:
            pulumi.set(__self__, "winrms", winrms)

    @_builtins.property
    @pulumi.getter(name="additionalUnattendConfigs")
    def additional_unattend_configs(self) -> Optional[Sequence['outputs.VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfig']]:
        """
        An `additional_unattend_config` block as defined below.
        """
        return pulumi.get(self, "additional_unattend_configs")

    @_builtins.property
    @pulumi.getter(name="enableAutomaticUpgrades")
    def enable_automatic_upgrades(self) -> Optional[_builtins.bool]:
        """
        Are automatic updates enabled on this Virtual Machine? Defaults to `false`.
        """
        return pulumi.get(self, "enable_automatic_upgrades")

    @_builtins.property
    @pulumi.getter(name="provisionVmAgent")
    def provision_vm_agent(self) -> Optional[_builtins.bool]:
        """
        Should the Azure Virtual Machine Guest Agent be installed on this Virtual Machine? Defaults to `false`.

        > **NOTE:** This is different from the Default value used for this field within Azure.
        """
        return pulumi.get(self, "provision_vm_agent")

    @_builtins.property
    @pulumi.getter
    def timezone(self) -> Optional[_builtins.str]:
        """
        Specifies the time zone of the virtual machine, [the possible values are defined here](https://jackstromberg.com/2017/01/list-of-time-zones-consumed-by-azure/). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "timezone")

    @_builtins.property
    @pulumi.getter
    def winrms(self) -> Optional[Sequence['outputs.VirtualMachineOsProfileWindowsConfigWinrm']]:
        """
        One or more `winrm` blocks as defined below.
        """
        return pulumi.get(self, "winrms")


@pulumi.output_type
class VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pass":
            suggest = "pass_"
        elif key == "settingName":
            suggest = "setting_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineOsProfileWindowsConfigAdditionalUnattendConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 component: _builtins.str,
                 content: _builtins.str,
                 pass_: _builtins.str,
                 setting_name: _builtins.str):
        """
        :param _builtins.str component: Specifies the name of the component to configure with the added content. The only allowable value is `Microsoft-Windows-Shell-Setup`.
        :param _builtins.str content: Specifies the base-64 encoded XML formatted content that is added to the unattend.xml file for the specified path and component.
        :param _builtins.str pass_: Specifies the name of the pass that the content applies to. The only allowable value is `oobeSystem`.
        :param _builtins.str setting_name: Specifies the name of the setting to which the content applies. Possible values are: `FirstLogonCommands` and `AutoLogon`.
        """
        pulumi.set(__self__, "component", component)
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "pass_", pass_)
        pulumi.set(__self__, "setting_name", setting_name)

    @_builtins.property
    @pulumi.getter
    def component(self) -> _builtins.str:
        """
        Specifies the name of the component to configure with the added content. The only allowable value is `Microsoft-Windows-Shell-Setup`.
        """
        return pulumi.get(self, "component")

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        Specifies the base-64 encoded XML formatted content that is added to the unattend.xml file for the specified path and component.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter(name="pass")
    def pass_(self) -> _builtins.str:
        """
        Specifies the name of the pass that the content applies to. The only allowable value is `oobeSystem`.
        """
        return pulumi.get(self, "pass_")

    @_builtins.property
    @pulumi.getter(name="settingName")
    def setting_name(self) -> _builtins.str:
        """
        Specifies the name of the setting to which the content applies. Possible values are: `FirstLogonCommands` and `AutoLogon`.
        """
        return pulumi.get(self, "setting_name")


@pulumi.output_type
class VirtualMachineOsProfileWindowsConfigWinrm(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateUrl":
            suggest = "certificate_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineOsProfileWindowsConfigWinrm. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineOsProfileWindowsConfigWinrm.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineOsProfileWindowsConfigWinrm.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protocol: _builtins.str,
                 certificate_url: Optional[_builtins.str] = None):
        """
        :param _builtins.str protocol: Specifies the protocol of listener. Possible values are `HTTP` or `HTTPS`.
        :param _builtins.str certificate_url: The ID of the Key Vault Secret which contains the encrypted Certificate which should be installed on the Virtual Machine. This certificate must also be specified in the `vault_certificates` block within the `os_profile_secrets` block.
               
               > **NOTE:** This can be sourced from the `secret_id` field on the `keyvault.Certificate` resource.
        """
        pulumi.set(__self__, "protocol", protocol)
        if certificate_url is not None:
            pulumi.set(__self__, "certificate_url", certificate_url)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Specifies the protocol of listener. Possible values are `HTTP` or `HTTPS`.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="certificateUrl")
    def certificate_url(self) -> Optional[_builtins.str]:
        """
        The ID of the Key Vault Secret which contains the encrypted Certificate which should be installed on the Virtual Machine. This certificate must also be specified in the `vault_certificates` block within the `os_profile_secrets` block.

        > **NOTE:** This can be sourced from the `secret_id` field on the `keyvault.Certificate` resource.
        """
        return pulumi.get(self, "certificate_url")


@pulumi.output_type
class VirtualMachinePlan(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 product: _builtins.str,
                 publisher: _builtins.str):
        """
        :param _builtins.str name: Specifies the name of the image from the marketplace.
        :param _builtins.str product: Specifies the product of the image from the marketplace.
        :param _builtins.str publisher: Specifies the publisher of the image.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "publisher", publisher)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the image from the marketplace.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def product(self) -> _builtins.str:
        """
        Specifies the product of the image from the marketplace.
        """
        return pulumi.get(self, "product")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        """
        Specifies the publisher of the image.
        """
        return pulumi.get(self, "publisher")


@pulumi.output_type
class VirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretUrl":
            suggest = "secret_url"
        elif key == "sourceVaultId":
            suggest = "source_vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_url: _builtins.str,
                 source_vault_id: _builtins.str):
        """
        :param _builtins.str secret_url: The URL to the Key Vault Secret which stores the protected settings.
        :param _builtins.str source_vault_id: The ID of the source Key Vault.
        """
        pulumi.set(__self__, "secret_url", secret_url)
        pulumi.set(__self__, "source_vault_id", source_vault_id)

    @_builtins.property
    @pulumi.getter(name="secretUrl")
    def secret_url(self) -> _builtins.str:
        """
        The URL to the Key Vault Secret which stores the protected settings.
        """
        return pulumi.get(self, "secret_url")

    @_builtins.property
    @pulumi.getter(name="sourceVaultId")
    def source_vault_id(self) -> _builtins.str:
        """
        The ID of the source Key Vault.
        """
        return pulumi.get(self, "source_vault_id")


@pulumi.output_type
class VirtualMachineStorageDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createOption":
            suggest = "create_option"
        elif key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "managedDiskId":
            suggest = "managed_disk_id"
        elif key == "managedDiskType":
            suggest = "managed_disk_type"
        elif key == "vhdUri":
            suggest = "vhd_uri"
        elif key == "writeAcceleratorEnabled":
            suggest = "write_accelerator_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineStorageDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineStorageDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineStorageDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_option: _builtins.str,
                 lun: _builtins.int,
                 name: _builtins.str,
                 caching: Optional[_builtins.str] = None,
                 disk_size_gb: Optional[_builtins.int] = None,
                 managed_disk_id: Optional[_builtins.str] = None,
                 managed_disk_type: Optional[_builtins.str] = None,
                 vhd_uri: Optional[_builtins.str] = None,
                 write_accelerator_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str create_option: Specifies how the data disk should be created. Possible values are `Attach`, `FromImage` and `Empty`.
               
               > **NOTE:** If using an image that does not have data to be written to the Data Disk, use `Empty` as the create option in order to create the desired disk without any data.
        :param _builtins.int lun: Specifies the logical unit number of the data disk. This needs to be unique within all the Data Disks on the Virtual Machine.
        :param _builtins.str name: The name of the Data Disk.
        :param _builtins.str caching: Specifies the caching requirements for the Data Disk. Possible values include `None`, `ReadOnly` and `ReadWrite`.
        :param _builtins.int disk_size_gb: Specifies the size of the data disk in gigabytes.
        :param _builtins.str managed_disk_id: Specifies the ID of an Existing Managed Disk which should be attached to this Virtual Machine. When this field is set `create_option` must be set to `Attach`.
               
               The following properties apply when using Unmanaged Disks:
        :param _builtins.str managed_disk_type: Specifies the type of managed disk to create. Possible values are either `Standard_LRS`, `StandardSSD_LRS`, `Premium_LRS` or `UltraSSD_LRS`.
               
               > **Note:** `managed_disk_type` of type `UltraSSD_LRS` is currently in preview and are not available to subscriptions that have not [requested](https://aka.ms/UltraSSDPreviewSignUp) onboarding to `Azure Ultra Disk Storage` preview. `Azure Ultra Disk Storage` is only available in `East US 2`, `North Europe`, and `Southeast Asia` regions. For more information see the `Azure Ultra Disk Storage` [product documentation](https://docs.microsoft.com/azure/virtual-machines/windows/disks-enable-ultra-ssd), [product blog](https://azure.microsoft.com/en-us/blog/announcing-the-general-availability-of-azure-ultra-disk-storage/) and [FAQ](https://docs.microsoft.com/azure/virtual-machines/windows/faq-for-disks#ultra-disks). You must also set `additional_capabilities.ultra_ssd_enabled` to `true`.
        :param _builtins.str vhd_uri: Specifies the URI of the VHD file backing this Unmanaged Data Disk.
        :param _builtins.bool write_accelerator_enabled: Specifies if Write Accelerator is enabled on the disk. This can only be enabled on `Premium_LRS` managed disks with no caching and [M-Series VMs](https://docs.microsoft.com/azure/virtual-machines/workloads/sap/how-to-enable-write-accelerator). Defaults to `false`.
               
               The following properties apply when using Managed Disks:
        """
        pulumi.set(__self__, "create_option", create_option)
        pulumi.set(__self__, "lun", lun)
        pulumi.set(__self__, "name", name)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if managed_disk_id is not None:
            pulumi.set(__self__, "managed_disk_id", managed_disk_id)
        if managed_disk_type is not None:
            pulumi.set(__self__, "managed_disk_type", managed_disk_type)
        if vhd_uri is not None:
            pulumi.set(__self__, "vhd_uri", vhd_uri)
        if write_accelerator_enabled is not None:
            pulumi.set(__self__, "write_accelerator_enabled", write_accelerator_enabled)

    @_builtins.property
    @pulumi.getter(name="createOption")
    def create_option(self) -> _builtins.str:
        """
        Specifies how the data disk should be created. Possible values are `Attach`, `FromImage` and `Empty`.

        > **NOTE:** If using an image that does not have data to be written to the Data Disk, use `Empty` as the create option in order to create the desired disk without any data.
        """
        return pulumi.get(self, "create_option")

    @_builtins.property
    @pulumi.getter
    def lun(self) -> _builtins.int:
        """
        Specifies the logical unit number of the data disk. This needs to be unique within all the Data Disks on the Virtual Machine.
        """
        return pulumi.get(self, "lun")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Data Disk.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def caching(self) -> Optional[_builtins.str]:
        """
        Specifies the caching requirements for the Data Disk. Possible values include `None`, `ReadOnly` and `ReadWrite`.
        """
        return pulumi.get(self, "caching")

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[_builtins.int]:
        """
        Specifies the size of the data disk in gigabytes.
        """
        return pulumi.get(self, "disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="managedDiskId")
    def managed_disk_id(self) -> Optional[_builtins.str]:
        """
        Specifies the ID of an Existing Managed Disk which should be attached to this Virtual Machine. When this field is set `create_option` must be set to `Attach`.

        The following properties apply when using Unmanaged Disks:
        """
        return pulumi.get(self, "managed_disk_id")

    @_builtins.property
    @pulumi.getter(name="managedDiskType")
    def managed_disk_type(self) -> Optional[_builtins.str]:
        """
        Specifies the type of managed disk to create. Possible values are either `Standard_LRS`, `StandardSSD_LRS`, `Premium_LRS` or `UltraSSD_LRS`.

        > **Note:** `managed_disk_type` of type `UltraSSD_LRS` is currently in preview and are not available to subscriptions that have not [requested](https://aka.ms/UltraSSDPreviewSignUp) onboarding to `Azure Ultra Disk Storage` preview. `Azure Ultra Disk Storage` is only available in `East US 2`, `North Europe`, and `Southeast Asia` regions. For more information see the `Azure Ultra Disk Storage` [product documentation](https://docs.microsoft.com/azure/virtual-machines/windows/disks-enable-ultra-ssd), [product blog](https://azure.microsoft.com/en-us/blog/announcing-the-general-availability-of-azure-ultra-disk-storage/) and [FAQ](https://docs.microsoft.com/azure/virtual-machines/windows/faq-for-disks#ultra-disks). You must also set `additional_capabilities.ultra_ssd_enabled` to `true`.
        """
        return pulumi.get(self, "managed_disk_type")

    @_builtins.property
    @pulumi.getter(name="vhdUri")
    def vhd_uri(self) -> Optional[_builtins.str]:
        """
        Specifies the URI of the VHD file backing this Unmanaged Data Disk.
        """
        return pulumi.get(self, "vhd_uri")

    @_builtins.property
    @pulumi.getter(name="writeAcceleratorEnabled")
    def write_accelerator_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies if Write Accelerator is enabled on the disk. This can only be enabled on `Premium_LRS` managed disks with no caching and [M-Series VMs](https://docs.microsoft.com/azure/virtual-machines/workloads/sap/how-to-enable-write-accelerator). Defaults to `false`.

        The following properties apply when using Managed Disks:
        """
        return pulumi.get(self, "write_accelerator_enabled")


@pulumi.output_type
class VirtualMachineStorageImageReference(dict):
    def __init__(__self__, *,
                 id: Optional[_builtins.str] = None,
                 offer: Optional[_builtins.str] = None,
                 publisher: Optional[_builtins.str] = None,
                 sku: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str id: Specifies the ID of the Custom Image which the Virtual Machine should be created from. Changing this forces a new resource to be created.
        :param _builtins.str offer: Specifies the offer of the image used to create the virtual machine. Changing this forces a new resource to be created.
        :param _builtins.str publisher: Specifies the publisher of the image used to create the virtual machine. Changing this forces a new resource to be created.
        :param _builtins.str sku: Specifies the SKU of the image used to create the virtual machine. Changing this forces a new resource to be created.
        :param _builtins.str version: Specifies the version of the image used to create the virtual machine. Changing this forces a new resource to be created.
               
               To provision a Custom Image, the following fields are applicable:
        """
        if id is not None:
            pulumi.set(__self__, "id", id)
        if offer is not None:
            pulumi.set(__self__, "offer", offer)
        if publisher is not None:
            pulumi.set(__self__, "publisher", publisher)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        Specifies the ID of the Custom Image which the Virtual Machine should be created from. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def offer(self) -> Optional[_builtins.str]:
        """
        Specifies the offer of the image used to create the virtual machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "offer")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> Optional[_builtins.str]:
        """
        Specifies the publisher of the image used to create the virtual machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[_builtins.str]:
        """
        Specifies the SKU of the image used to create the virtual machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        Specifies the version of the image used to create the virtual machine. Changing this forces a new resource to be created.

        To provision a Custom Image, the following fields are applicable:
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class VirtualMachineStorageOsDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createOption":
            suggest = "create_option"
        elif key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "imageUri":
            suggest = "image_uri"
        elif key == "managedDiskId":
            suggest = "managed_disk_id"
        elif key == "managedDiskType":
            suggest = "managed_disk_type"
        elif key == "osType":
            suggest = "os_type"
        elif key == "vhdUri":
            suggest = "vhd_uri"
        elif key == "writeAcceleratorEnabled":
            suggest = "write_accelerator_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualMachineStorageOsDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualMachineStorageOsDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualMachineStorageOsDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_option: _builtins.str,
                 name: _builtins.str,
                 caching: Optional[_builtins.str] = None,
                 disk_size_gb: Optional[_builtins.int] = None,
                 image_uri: Optional[_builtins.str] = None,
                 managed_disk_id: Optional[_builtins.str] = None,
                 managed_disk_type: Optional[_builtins.str] = None,
                 os_type: Optional[_builtins.str] = None,
                 vhd_uri: Optional[_builtins.str] = None,
                 write_accelerator_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str create_option: Specifies how the OS Disk should be created. Possible values are `Attach` (managed disks only) and `FromImage`.
        :param _builtins.str name: Specifies the name of the OS Disk.
        :param _builtins.str caching: Specifies the caching requirements for the OS Disk. Possible values include `None`, `ReadOnly` and `ReadWrite`.
        :param _builtins.int disk_size_gb: Specifies the size of the OS Disk in gigabytes.
        :param _builtins.str image_uri: Specifies the Image URI in the format `publisherName:offer:skus:version`. This field can also specify the [VHD URI](https://docs.microsoft.com/azure/virtual-machines/linux/tutorial-custom-images) of a custom VM image to clone. When cloning a Custom (Unmanaged) Disk Image the `os_type` field must be set.
        :param _builtins.str managed_disk_id: Specifies the ID of an existing Managed Disk which should be attached as the OS Disk of this Virtual Machine. If this is set then the `create_option` must be set to `Attach`. Changing this forces a new resource to be created.
        :param _builtins.str managed_disk_type: Specifies the type of Managed Disk which should be created. Possible values are `Standard_LRS`, `StandardSSD_LRS` or `Premium_LRS`.
               
               The following properties apply when using Unmanaged Disks:
        :param _builtins.str os_type: Specifies the Operating System on the OS Disk. Possible values are `Linux` and `Windows`.
        :param _builtins.str vhd_uri: Specifies the URI of the VHD file backing this Unmanaged OS Disk. Changing this forces a new resource to be created.
        :param _builtins.bool write_accelerator_enabled: Specifies if Write Accelerator is enabled on the disk. This can only be enabled on `Premium_LRS` managed disks with no caching and [M-Series VMs](https://docs.microsoft.com/azure/virtual-machines/workloads/sap/how-to-enable-write-accelerator). Defaults to `false`.
               
               The following properties apply when using Managed Disks:
        """
        pulumi.set(__self__, "create_option", create_option)
        pulumi.set(__self__, "name", name)
        if caching is not None:
            pulumi.set(__self__, "caching", caching)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if image_uri is not None:
            pulumi.set(__self__, "image_uri", image_uri)
        if managed_disk_id is not None:
            pulumi.set(__self__, "managed_disk_id", managed_disk_id)
        if managed_disk_type is not None:
            pulumi.set(__self__, "managed_disk_type", managed_disk_type)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if vhd_uri is not None:
            pulumi.set(__self__, "vhd_uri", vhd_uri)
        if write_accelerator_enabled is not None:
            pulumi.set(__self__, "write_accelerator_enabled", write_accelerator_enabled)

    @_builtins.property
    @pulumi.getter(name="createOption")
    def create_option(self) -> _builtins.str:
        """
        Specifies how the OS Disk should be created. Possible values are `Attach` (managed disks only) and `FromImage`.
        """
        return pulumi.get(self, "create_option")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the OS Disk.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def caching(self) -> Optional[_builtins.str]:
        """
        Specifies the caching requirements for the OS Disk. Possible values include `None`, `ReadOnly` and `ReadWrite`.
        """
        return pulumi.get(self, "caching")

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[_builtins.int]:
        """
        Specifies the size of the OS Disk in gigabytes.
        """
        return pulumi.get(self, "disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> Optional[_builtins.str]:
        """
        Specifies the Image URI in the format `publisherName:offer:skus:version`. This field can also specify the [VHD URI](https://docs.microsoft.com/azure/virtual-machines/linux/tutorial-custom-images) of a custom VM image to clone. When cloning a Custom (Unmanaged) Disk Image the `os_type` field must be set.
        """
        return pulumi.get(self, "image_uri")

    @_builtins.property
    @pulumi.getter(name="managedDiskId")
    def managed_disk_id(self) -> Optional[_builtins.str]:
        """
        Specifies the ID of an existing Managed Disk which should be attached as the OS Disk of this Virtual Machine. If this is set then the `create_option` must be set to `Attach`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "managed_disk_id")

    @_builtins.property
    @pulumi.getter(name="managedDiskType")
    def managed_disk_type(self) -> Optional[_builtins.str]:
        """
        Specifies the type of Managed Disk which should be created. Possible values are `Standard_LRS`, `StandardSSD_LRS` or `Premium_LRS`.

        The following properties apply when using Unmanaged Disks:
        """
        return pulumi.get(self, "managed_disk_type")

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[_builtins.str]:
        """
        Specifies the Operating System on the OS Disk. Possible values are `Linux` and `Windows`.
        """
        return pulumi.get(self, "os_type")

    @_builtins.property
    @pulumi.getter(name="vhdUri")
    def vhd_uri(self) -> Optional[_builtins.str]:
        """
        Specifies the URI of the VHD file backing this Unmanaged OS Disk. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "vhd_uri")

    @_builtins.property
    @pulumi.getter(name="writeAcceleratorEnabled")
    def write_accelerator_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies if Write Accelerator is enabled on the disk. This can only be enabled on `Premium_LRS` managed disks with no caching and [M-Series VMs](https://docs.microsoft.com/azure/virtual-machines/workloads/sap/how-to-enable-write-accelerator). Defaults to `false`.

        The following properties apply when using Managed Disks:
        """
        return pulumi.get(self, "write_accelerator_enabled")


@pulumi.output_type
class WindowsVirtualMachineAdditionalCapabilities(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hibernationEnabled":
            suggest = "hibernation_enabled"
        elif key == "ultraSsdEnabled":
            suggest = "ultra_ssd_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsVirtualMachineAdditionalCapabilities. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsVirtualMachineAdditionalCapabilities.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsVirtualMachineAdditionalCapabilities.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hibernation_enabled: Optional[_builtins.bool] = None,
                 ultra_ssd_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool hibernation_enabled: Whether to enable the hibernation capability or not.
        :param _builtins.bool ultra_ssd_enabled: Should the capacity to enable Data Disks of the `UltraSSD_LRS` storage account type be supported on this Virtual Machine? Defaults to `false`.
        """
        if hibernation_enabled is not None:
            pulumi.set(__self__, "hibernation_enabled", hibernation_enabled)
        if ultra_ssd_enabled is not None:
            pulumi.set(__self__, "ultra_ssd_enabled", ultra_ssd_enabled)

    @_builtins.property
    @pulumi.getter(name="hibernationEnabled")
    def hibernation_enabled(self) -> Optional[_builtins.bool]:
        """
        Whether to enable the hibernation capability or not.
        """
        return pulumi.get(self, "hibernation_enabled")

    @_builtins.property
    @pulumi.getter(name="ultraSsdEnabled")
    def ultra_ssd_enabled(self) -> Optional[_builtins.bool]:
        """
        Should the capacity to enable Data Disks of the `UltraSSD_LRS` storage account type be supported on this Virtual Machine? Defaults to `false`.
        """
        return pulumi.get(self, "ultra_ssd_enabled")


@pulumi.output_type
class WindowsVirtualMachineAdditionalUnattendContent(dict):
    def __init__(__self__, *,
                 content: _builtins.str,
                 setting: _builtins.str):
        """
        :param _builtins.str content: The XML formatted content that is added to the unattend.xml file for the specified path and component. Changing this forces a new resource to be created.
        :param _builtins.str setting: The name of the setting to which the content applies. Possible values are `AutoLogon` and `FirstLogonCommands`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "setting", setting)

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        The XML formatted content that is added to the unattend.xml file for the specified path and component. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def setting(self) -> _builtins.str:
        """
        The name of the setting to which the content applies. Possible values are `AutoLogon` and `FirstLogonCommands`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "setting")


@pulumi.output_type
class WindowsVirtualMachineBootDiagnostics(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageAccountUri":
            suggest = "storage_account_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsVirtualMachineBootDiagnostics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsVirtualMachineBootDiagnostics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsVirtualMachineBootDiagnostics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_account_uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str storage_account_uri: The Primary/Secondary Endpoint for the Azure Storage Account which should be used to store Boot Diagnostics, including Console Output and Screenshots from the Hypervisor.
               
               > **NOTE:** Passing a null value will utilize a Managed Storage Account to store Boot Diagnostics.
        """
        if storage_account_uri is not None:
            pulumi.set(__self__, "storage_account_uri", storage_account_uri)

    @_builtins.property
    @pulumi.getter(name="storageAccountUri")
    def storage_account_uri(self) -> Optional[_builtins.str]:
        """
        The Primary/Secondary Endpoint for the Azure Storage Account which should be used to store Boot Diagnostics, including Console Output and Screenshots from the Hypervisor.

        > **NOTE:** Passing a null value will utilize a Managed Storage Account to store Boot Diagnostics.
        """
        return pulumi.get(self, "storage_account_uri")


@pulumi.output_type
class WindowsVirtualMachineGalleryApplication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "versionId":
            suggest = "version_id"
        elif key == "automaticUpgradeEnabled":
            suggest = "automatic_upgrade_enabled"
        elif key == "configurationBlobUri":
            suggest = "configuration_blob_uri"
        elif key == "treatFailureAsDeploymentFailureEnabled":
            suggest = "treat_failure_as_deployment_failure_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsVirtualMachineGalleryApplication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsVirtualMachineGalleryApplication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsVirtualMachineGalleryApplication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 version_id: _builtins.str,
                 automatic_upgrade_enabled: Optional[_builtins.bool] = None,
                 configuration_blob_uri: Optional[_builtins.str] = None,
                 order: Optional[_builtins.int] = None,
                 tag: Optional[_builtins.str] = None,
                 treat_failure_as_deployment_failure_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str version_id: Specifies the Gallery Application Version resource ID.
        :param _builtins.bool automatic_upgrade_enabled: Specifies whether the version will be automatically updated for the VM when a new Gallery Application version is available in PIR/SIG. Defaults to `false`.
        :param _builtins.str configuration_blob_uri: Specifies the URI to an Azure Blob that will replace the default configuration for the package if provided.
        :param _builtins.int order: Specifies the order in which the packages have to be installed. Possible values are between `0` and `2147483647`. Defaults to `0`.
        :param _builtins.str tag: Specifies a passthrough value for more generic context. This field can be any valid `string` value.
        :param _builtins.bool treat_failure_as_deployment_failure_enabled: Specifies whether any failure for any operation in the VmApplication will fail the deployment of the VM. Defaults to `false`.
        """
        pulumi.set(__self__, "version_id", version_id)
        if automatic_upgrade_enabled is not None:
            pulumi.set(__self__, "automatic_upgrade_enabled", automatic_upgrade_enabled)
        if configuration_blob_uri is not None:
            pulumi.set(__self__, "configuration_blob_uri", configuration_blob_uri)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)
        if treat_failure_as_deployment_failure_enabled is not None:
            pulumi.set(__self__, "treat_failure_as_deployment_failure_enabled", treat_failure_as_deployment_failure_enabled)

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> _builtins.str:
        """
        Specifies the Gallery Application Version resource ID.
        """
        return pulumi.get(self, "version_id")

    @_builtins.property
    @pulumi.getter(name="automaticUpgradeEnabled")
    def automatic_upgrade_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether the version will be automatically updated for the VM when a new Gallery Application version is available in PIR/SIG. Defaults to `false`.
        """
        return pulumi.get(self, "automatic_upgrade_enabled")

    @_builtins.property
    @pulumi.getter(name="configurationBlobUri")
    def configuration_blob_uri(self) -> Optional[_builtins.str]:
        """
        Specifies the URI to an Azure Blob that will replace the default configuration for the package if provided.
        """
        return pulumi.get(self, "configuration_blob_uri")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.int]:
        """
        Specifies the order in which the packages have to be installed. Possible values are between `0` and `2147483647`. Defaults to `0`.
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[_builtins.str]:
        """
        Specifies a passthrough value for more generic context. This field can be any valid `string` value.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter(name="treatFailureAsDeploymentFailureEnabled")
    def treat_failure_as_deployment_failure_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether any failure for any operation in the VmApplication will fail the deployment of the VM. Defaults to `false`.
        """
        return pulumi.get(self, "treat_failure_as_deployment_failure_enabled")


@pulumi.output_type
class WindowsVirtualMachineIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsVirtualMachineIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsVirtualMachineIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsVirtualMachineIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Windows Virtual Machine. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        :param Sequence[_builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Windows Virtual Machine.
               
               > **NOTE:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param _builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param _builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Windows Virtual Machine. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Windows Virtual Machine.

        > **NOTE:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class WindowsVirtualMachineOsDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageAccountType":
            suggest = "storage_account_type"
        elif key == "diffDiskSettings":
            suggest = "diff_disk_settings"
        elif key == "diskEncryptionSetId":
            suggest = "disk_encryption_set_id"
        elif key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "secureVmDiskEncryptionSetId":
            suggest = "secure_vm_disk_encryption_set_id"
        elif key == "securityEncryptionType":
            suggest = "security_encryption_type"
        elif key == "writeAcceleratorEnabled":
            suggest = "write_accelerator_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsVirtualMachineOsDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsVirtualMachineOsDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsVirtualMachineOsDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 caching: _builtins.str,
                 storage_account_type: _builtins.str,
                 diff_disk_settings: Optional['outputs.WindowsVirtualMachineOsDiskDiffDiskSettings'] = None,
                 disk_encryption_set_id: Optional[_builtins.str] = None,
                 disk_size_gb: Optional[_builtins.int] = None,
                 id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 secure_vm_disk_encryption_set_id: Optional[_builtins.str] = None,
                 security_encryption_type: Optional[_builtins.str] = None,
                 write_accelerator_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str caching: The Type of Caching which should be used for the Internal OS Disk. Possible values are `None`, `ReadOnly` and `ReadWrite`.
        :param _builtins.str storage_account_type: The Type of Storage Account which should back this the Internal OS Disk. Possible values are `Standard_LRS`, `StandardSSD_LRS`, `Premium_LRS`, `StandardSSD_ZRS` and `Premium_ZRS`. Changing this forces a new resource to be created.
        :param 'WindowsVirtualMachineOsDiskDiffDiskSettingsArgs' diff_disk_settings: A `diff_disk_settings` block as defined above. Changing this forces a new resource to be created.
               
               > **NOTE:** `diff_disk_settings` can only be set when `caching` is set to `ReadOnly`. More information can be found [here](https://docs.microsoft.com/azure/virtual-machines/ephemeral-os-disks-deploy#vm-template-deployment)
        :param _builtins.str disk_encryption_set_id: The ID of the Disk Encryption Set which should be used to Encrypt this OS Disk. Conflicts with `secure_vm_disk_encryption_set_id`.
               
               > **NOTE:** The Disk Encryption Set must have the `Reader` Role Assignment scoped on the Key Vault - in addition to an Access Policy to the Key Vault
        :param _builtins.int disk_size_gb: The Size of the Internal OS Disk in GB, if you wish to vary from the size used in the image this Virtual Machine is sourced from.
               
               > **NOTE:** If specified this must be equal to or larger than the size of the Image the Virtual Machine is based on. When creating a larger disk than exists in the image you'll need to repartition the disk to use the remaining space.
        :param _builtins.str id: The ID of the OS disk.
        :param _builtins.str name: The name which should be used for the Internal OS Disk. Changing this forces a new resource to be created.
        :param _builtins.str secure_vm_disk_encryption_set_id: The ID of the Disk Encryption Set which should be used to Encrypt this OS Disk when the Virtual Machine is a Confidential VM. Conflicts with `disk_encryption_set_id`. Changing this forces a new resource to be created.
               
               > **NOTE:** `secure_vm_disk_encryption_set_id` can only be specified when `security_encryption_type` is set to `DiskWithVMGuestState`.
        :param _builtins.str security_encryption_type: Encryption Type when the Virtual Machine is a Confidential VM. Possible values are `VMGuestStateOnly` and `DiskWithVMGuestState`. Changing this forces a new resource to be created.
               
               > **NOTE:** `vtpm_enabled` must be set to `true` when `security_encryption_type` is specified.
               
               > **NOTE:** `encryption_at_host_enabled` cannot be set to `true` when `security_encryption_type` is set to `DiskWithVMGuestState`.
        :param _builtins.bool write_accelerator_enabled: Should Write Accelerator be Enabled for this OS Disk? Defaults to `false`.
               
               > **NOTE:** This requires that the `storage_account_type` is set to `Premium_LRS` and that `caching` is set to `None`.
        """
        pulumi.set(__self__, "caching", caching)
        pulumi.set(__self__, "storage_account_type", storage_account_type)
        if diff_disk_settings is not None:
            pulumi.set(__self__, "diff_disk_settings", diff_disk_settings)
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secure_vm_disk_encryption_set_id is not None:
            pulumi.set(__self__, "secure_vm_disk_encryption_set_id", secure_vm_disk_encryption_set_id)
        if security_encryption_type is not None:
            pulumi.set(__self__, "security_encryption_type", security_encryption_type)
        if write_accelerator_enabled is not None:
            pulumi.set(__self__, "write_accelerator_enabled", write_accelerator_enabled)

    @_builtins.property
    @pulumi.getter
    def caching(self) -> _builtins.str:
        """
        The Type of Caching which should be used for the Internal OS Disk. Possible values are `None`, `ReadOnly` and `ReadWrite`.
        """
        return pulumi.get(self, "caching")

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> _builtins.str:
        """
        The Type of Storage Account which should back this the Internal OS Disk. Possible values are `Standard_LRS`, `StandardSSD_LRS`, `Premium_LRS`, `StandardSSD_ZRS` and `Premium_ZRS`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_type")

    @_builtins.property
    @pulumi.getter(name="diffDiskSettings")
    def diff_disk_settings(self) -> Optional['outputs.WindowsVirtualMachineOsDiskDiffDiskSettings']:
        """
        A `diff_disk_settings` block as defined above. Changing this forces a new resource to be created.

        > **NOTE:** `diff_disk_settings` can only be set when `caching` is set to `ReadOnly`. More information can be found [here](https://docs.microsoft.com/azure/virtual-machines/ephemeral-os-disks-deploy#vm-template-deployment)
        """
        return pulumi.get(self, "diff_disk_settings")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Disk Encryption Set which should be used to Encrypt this OS Disk. Conflicts with `secure_vm_disk_encryption_set_id`.

        > **NOTE:** The Disk Encryption Set must have the `Reader` Role Assignment scoped on the Key Vault - in addition to an Access Policy to the Key Vault
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[_builtins.int]:
        """
        The Size of the Internal OS Disk in GB, if you wish to vary from the size used in the image this Virtual Machine is sourced from.

        > **NOTE:** If specified this must be equal to or larger than the size of the Image the Virtual Machine is based on. When creating a larger disk than exists in the image you'll need to repartition the disk to use the remaining space.
        """
        return pulumi.get(self, "disk_size_gb")

    @_builtins.property
    @pulumi.getter
    def id(self) -> Optional[_builtins.str]:
        """
        The ID of the OS disk.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name which should be used for the Internal OS Disk. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="secureVmDiskEncryptionSetId")
    def secure_vm_disk_encryption_set_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Disk Encryption Set which should be used to Encrypt this OS Disk when the Virtual Machine is a Confidential VM. Conflicts with `disk_encryption_set_id`. Changing this forces a new resource to be created.

        > **NOTE:** `secure_vm_disk_encryption_set_id` can only be specified when `security_encryption_type` is set to `DiskWithVMGuestState`.
        """
        return pulumi.get(self, "secure_vm_disk_encryption_set_id")

    @_builtins.property
    @pulumi.getter(name="securityEncryptionType")
    def security_encryption_type(self) -> Optional[_builtins.str]:
        """
        Encryption Type when the Virtual Machine is a Confidential VM. Possible values are `VMGuestStateOnly` and `DiskWithVMGuestState`. Changing this forces a new resource to be created.

        > **NOTE:** `vtpm_enabled` must be set to `true` when `security_encryption_type` is specified.

        > **NOTE:** `encryption_at_host_enabled` cannot be set to `true` when `security_encryption_type` is set to `DiskWithVMGuestState`.
        """
        return pulumi.get(self, "security_encryption_type")

    @_builtins.property
    @pulumi.getter(name="writeAcceleratorEnabled")
    def write_accelerator_enabled(self) -> Optional[_builtins.bool]:
        """
        Should Write Accelerator be Enabled for this OS Disk? Defaults to `false`.

        > **NOTE:** This requires that the `storage_account_type` is set to `Premium_LRS` and that `caching` is set to `None`.
        """
        return pulumi.get(self, "write_accelerator_enabled")


@pulumi.output_type
class WindowsVirtualMachineOsDiskDiffDiskSettings(dict):
    def __init__(__self__, *,
                 option: _builtins.str,
                 placement: Optional[_builtins.str] = None):
        """
        :param _builtins.str option: Specifies the Ephemeral Disk Settings for the OS Disk. At this time the only possible value is `Local`. Changing this forces a new resource to be created.
        :param _builtins.str placement: Specifies where to store the Ephemeral Disk. Possible values are `CacheDisk`, `ResourceDisk` and `NvmeDisk`. Defaults to `CacheDisk`. Changing this forces a new resource to be created.
               
               > **Note:** `NvmeDisk` can only be used for v6 VMs in combination with a supported `source_image_reference`. More information can be found [here](https://learn.microsoft.com/en-us/azure/virtual-machines/ephemeral-os-disks)
        """
        pulumi.set(__self__, "option", option)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)

    @_builtins.property
    @pulumi.getter
    def option(self) -> _builtins.str:
        """
        Specifies the Ephemeral Disk Settings for the OS Disk. At this time the only possible value is `Local`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "option")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Specifies where to store the Ephemeral Disk. Possible values are `CacheDisk`, `ResourceDisk` and `NvmeDisk`. Defaults to `CacheDisk`. Changing this forces a new resource to be created.

        > **Note:** `NvmeDisk` can only be used for v6 VMs in combination with a supported `source_image_reference`. More information can be found [here](https://learn.microsoft.com/en-us/azure/virtual-machines/ephemeral-os-disks)
        """
        return pulumi.get(self, "placement")


@pulumi.output_type
class WindowsVirtualMachineOsImageNotification(dict):
    def __init__(__self__, *,
                 timeout: Optional[_builtins.str] = None):
        """
        :param _builtins.str timeout: Length of time a notification to be sent to the VM on the instance metadata server till the VM gets OS upgraded. The only possible value is `PT15M`. Defaults to `PT15M`.
        """
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.str]:
        """
        Length of time a notification to be sent to the VM on the instance metadata server till the VM gets OS upgraded. The only possible value is `PT15M`. Defaults to `PT15M`.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class WindowsVirtualMachinePlan(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 product: _builtins.str,
                 publisher: _builtins.str):
        """
        :param _builtins.str name: Specifies the Name of the Marketplace Image this Virtual Machine should be created from. Changing this forces a new resource to be created.
        :param _builtins.str product: Specifies the Product of the Marketplace Image this Virtual Machine should be created from. Changing this forces a new resource to be created.
        :param _builtins.str publisher: Specifies the Publisher of the Marketplace Image this Virtual Machine should be created from. Changing this forces a new resource to be created.
               
               > **NOTE:** If you use the `plan` block with one of Microsoft's marketplace images (e.g. `publisher = "MicrosoftWindowsServer"`). This may prevent the purchase of the offer. An example Azure API error: `The Offer: 'WindowsServer' cannot be purchased by subscription: '12345678-12234-5678-9012-123456789012' as it is not to be sold in market: 'US'. Please choose a subscription which is associated with a different market.`
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "publisher", publisher)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the Name of the Marketplace Image this Virtual Machine should be created from. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def product(self) -> _builtins.str:
        """
        Specifies the Product of the Marketplace Image this Virtual Machine should be created from. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "product")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        """
        Specifies the Publisher of the Marketplace Image this Virtual Machine should be created from. Changing this forces a new resource to be created.

        > **NOTE:** If you use the `plan` block with one of Microsoft's marketplace images (e.g. `publisher = "MicrosoftWindowsServer"`). This may prevent the purchase of the offer. An example Azure API error: `The Offer: 'WindowsServer' cannot be purchased by subscription: '12345678-12234-5678-9012-123456789012' as it is not to be sold in market: 'US'. Please choose a subscription which is associated with a different market.`
        """
        return pulumi.get(self, "publisher")


@pulumi.output_type
class WindowsVirtualMachineScaleSetAdditionalCapabilities(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ultraSsdEnabled":
            suggest = "ultra_ssd_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsVirtualMachineScaleSetAdditionalCapabilities. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsVirtualMachineScaleSetAdditionalCapabilities.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsVirtualMachineScaleSetAdditionalCapabilities.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ultra_ssd_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool ultra_ssd_enabled: Should the capacity to enable Data Disks of the `UltraSSD_LRS` storage account type be supported on this Virtual Machine Scale Set? Possible values are `true` or `false`. Defaults to `false`. Changing this forces a new resource to be created.
        """
        if ultra_ssd_enabled is not None:
            pulumi.set(__self__, "ultra_ssd_enabled", ultra_ssd_enabled)

    @_builtins.property
    @pulumi.getter(name="ultraSsdEnabled")
    def ultra_ssd_enabled(self) -> Optional[_builtins.bool]:
        """
        Should the capacity to enable Data Disks of the `UltraSSD_LRS` storage account type be supported on this Virtual Machine Scale Set? Possible values are `true` or `false`. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "ultra_ssd_enabled")


@pulumi.output_type
class WindowsVirtualMachineScaleSetAdditionalUnattendContent(dict):
    def __init__(__self__, *,
                 content: _builtins.str,
                 setting: _builtins.str):
        """
        :param _builtins.str content: The XML formatted content that is added to the unattend.xml file for the specified path and component. Changing this forces a new resource to be created.
        :param _builtins.str setting: The name of the setting to which the content applies. Possible values are `AutoLogon` and `FirstLogonCommands`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "content", content)
        pulumi.set(__self__, "setting", setting)

    @_builtins.property
    @pulumi.getter
    def content(self) -> _builtins.str:
        """
        The XML formatted content that is added to the unattend.xml file for the specified path and component. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def setting(self) -> _builtins.str:
        """
        The name of the setting to which the content applies. Possible values are `AutoLogon` and `FirstLogonCommands`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "setting")


@pulumi.output_type
class WindowsVirtualMachineScaleSetAutomaticInstanceRepair(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gracePeriod":
            suggest = "grace_period"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsVirtualMachineScaleSetAutomaticInstanceRepair. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsVirtualMachineScaleSetAutomaticInstanceRepair.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsVirtualMachineScaleSetAutomaticInstanceRepair.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 action: Optional[_builtins.str] = None,
                 grace_period: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Should the automatic instance repair be enabled on this Virtual Machine Scale Set?
        :param _builtins.str action: The repair action that will be used for repairing unhealthy virtual machines in the scale set. Possible values include `Replace`, `Restart`, `Reimage`.
               
               > **Note:** Once the `action` field has been set it will always return the last value it was assigned if it is removed from the configuration file.
               
               > **Note:** If you wish to update the repair `action` of an existing `automatic_instance_repair` policy, you must first `disable` the `automatic_instance_repair` policy before you can re-enable the `automatic_instance_repair` policy with the new repair `action` defined.
        :param _builtins.str grace_period: Amount of time for which automatic repairs will be delayed. The grace period starts right after the VM is found unhealthy. Possible values are between `10` and `90` minutes. The time duration should be specified in `ISO 8601` format (e.g. `PT10M` to `PT90M`).
               
               > **Note:** Once the `grace_period` field has been set it will always return the last value it was assigned if it is removed from the configuration file.
        """
        pulumi.set(__self__, "enabled", enabled)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if grace_period is not None:
            pulumi.set(__self__, "grace_period", grace_period)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Should the automatic instance repair be enabled on this Virtual Machine Scale Set?
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        """
        The repair action that will be used for repairing unhealthy virtual machines in the scale set. Possible values include `Replace`, `Restart`, `Reimage`.

        > **Note:** Once the `action` field has been set it will always return the last value it was assigned if it is removed from the configuration file.

        > **Note:** If you wish to update the repair `action` of an existing `automatic_instance_repair` policy, you must first `disable` the `automatic_instance_repair` policy before you can re-enable the `automatic_instance_repair` policy with the new repair `action` defined.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="gracePeriod")
    def grace_period(self) -> Optional[_builtins.str]:
        """
        Amount of time for which automatic repairs will be delayed. The grace period starts right after the VM is found unhealthy. Possible values are between `10` and `90` minutes. The time duration should be specified in `ISO 8601` format (e.g. `PT10M` to `PT90M`).

        > **Note:** Once the `grace_period` field has been set it will always return the last value it was assigned if it is removed from the configuration file.
        """
        return pulumi.get(self, "grace_period")


@pulumi.output_type
class WindowsVirtualMachineScaleSetAutomaticOsUpgradePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "disableAutomaticRollback":
            suggest = "disable_automatic_rollback"
        elif key == "enableAutomaticOsUpgrade":
            suggest = "enable_automatic_os_upgrade"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsVirtualMachineScaleSetAutomaticOsUpgradePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsVirtualMachineScaleSetAutomaticOsUpgradePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsVirtualMachineScaleSetAutomaticOsUpgradePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disable_automatic_rollback: _builtins.bool,
                 enable_automatic_os_upgrade: _builtins.bool):
        """
        :param _builtins.bool disable_automatic_rollback: Should automatic rollbacks be disabled?
        :param _builtins.bool enable_automatic_os_upgrade: Should OS Upgrades automatically be applied to Scale Set instances in a rolling fashion when a newer version of the OS Image becomes available?
        """
        pulumi.set(__self__, "disable_automatic_rollback", disable_automatic_rollback)
        pulumi.set(__self__, "enable_automatic_os_upgrade", enable_automatic_os_upgrade)

    @_builtins.property
    @pulumi.getter(name="disableAutomaticRollback")
    def disable_automatic_rollback(self) -> _builtins.bool:
        """
        Should automatic rollbacks be disabled?
        """
        return pulumi.get(self, "disable_automatic_rollback")

    @_builtins.property
    @pulumi.getter(name="enableAutomaticOsUpgrade")
    def enable_automatic_os_upgrade(self) -> _builtins.bool:
        """
        Should OS Upgrades automatically be applied to Scale Set instances in a rolling fashion when a newer version of the OS Image becomes available?
        """
        return pulumi.get(self, "enable_automatic_os_upgrade")


@pulumi.output_type
class WindowsVirtualMachineScaleSetBootDiagnostics(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageAccountUri":
            suggest = "storage_account_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsVirtualMachineScaleSetBootDiagnostics. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsVirtualMachineScaleSetBootDiagnostics.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsVirtualMachineScaleSetBootDiagnostics.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 storage_account_uri: Optional[_builtins.str] = None):
        """
        :param _builtins.str storage_account_uri: The Primary/Secondary Endpoint for the Azure Storage Account which should be used to store Boot Diagnostics, including Console Output and Screenshots from the Hypervisor.
               
               > **Note:** Passing a null value will utilize a Managed Storage Account to store Boot Diagnostics
        """
        if storage_account_uri is not None:
            pulumi.set(__self__, "storage_account_uri", storage_account_uri)

    @_builtins.property
    @pulumi.getter(name="storageAccountUri")
    def storage_account_uri(self) -> Optional[_builtins.str]:
        """
        The Primary/Secondary Endpoint for the Azure Storage Account which should be used to store Boot Diagnostics, including Console Output and Screenshots from the Hypervisor.

        > **Note:** Passing a null value will utilize a Managed Storage Account to store Boot Diagnostics
        """
        return pulumi.get(self, "storage_account_uri")


@pulumi.output_type
class WindowsVirtualMachineScaleSetDataDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "storageAccountType":
            suggest = "storage_account_type"
        elif key == "createOption":
            suggest = "create_option"
        elif key == "diskEncryptionSetId":
            suggest = "disk_encryption_set_id"
        elif key == "ultraSsdDiskIopsReadWrite":
            suggest = "ultra_ssd_disk_iops_read_write"
        elif key == "ultraSsdDiskMbpsReadWrite":
            suggest = "ultra_ssd_disk_mbps_read_write"
        elif key == "writeAcceleratorEnabled":
            suggest = "write_accelerator_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsVirtualMachineScaleSetDataDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsVirtualMachineScaleSetDataDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsVirtualMachineScaleSetDataDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 caching: _builtins.str,
                 disk_size_gb: _builtins.int,
                 lun: _builtins.int,
                 storage_account_type: _builtins.str,
                 create_option: Optional[_builtins.str] = None,
                 disk_encryption_set_id: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 ultra_ssd_disk_iops_read_write: Optional[_builtins.int] = None,
                 ultra_ssd_disk_mbps_read_write: Optional[_builtins.int] = None,
                 write_accelerator_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str caching: The type of Caching which should be used for this Data Disk. Possible values are `None`, `ReadOnly` and `ReadWrite`.
        :param _builtins.int disk_size_gb: The size of the Data Disk which should be created.
        :param _builtins.int lun: The Logical Unit Number of the Data Disk, which must be unique within the Virtual Machine.
        :param _builtins.str storage_account_type: The Type of Storage Account which should back this Data Disk. Possible values include `Standard_LRS`, `StandardSSD_LRS`, `StandardSSD_ZRS`, `Premium_LRS`, `PremiumV2_LRS`, `Premium_ZRS` and `UltraSSD_LRS`.
               
               > **Note:** `UltraSSD_LRS` is only supported when `ultra_ssd_enabled` within the `additional_capabilities` block is enabled.
        :param _builtins.str create_option: The create option which should be used for this Data Disk. Possible values are `Empty` and `FromImage`. Defaults to `Empty`. (`FromImage` should only be used if the source image includes data disks).
        :param _builtins.str disk_encryption_set_id: The ID of the Disk Encryption Set which should be used to encrypt this Data Disk. Changing this forces a new resource to be created.
               
               > **Note:** The Disk Encryption Set must have the `Reader` Role Assignment scoped on the Key Vault - in addition to an Access Policy to the Key Vault
               
               > **Note:** Disk Encryption Sets are in Public Preview in a limited set of regions
        :param _builtins.str name: The name of the Data Disk.
        :param _builtins.int ultra_ssd_disk_iops_read_write: Specifies the Read-Write IOPS for this Data Disk. Only settable when `storage_account_type` is `PremiumV2_LRS` or `UltraSSD_LRS`.
        :param _builtins.int ultra_ssd_disk_mbps_read_write: Specifies the bandwidth in MB per second for this Data Disk. Only settable when `storage_account_type` is `PremiumV2_LRS` or `UltraSSD_LRS`.
        :param _builtins.bool write_accelerator_enabled: Should Write Accelerator be enabled for this Data Disk? Defaults to `false`.
               
               > **Note:** This requires that the `storage_account_type` is set to `Premium_LRS` and that `caching` is set to `None`.
        """
        pulumi.set(__self__, "caching", caching)
        pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        pulumi.set(__self__, "lun", lun)
        pulumi.set(__self__, "storage_account_type", storage_account_type)
        if create_option is not None:
            pulumi.set(__self__, "create_option", create_option)
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if ultra_ssd_disk_iops_read_write is not None:
            pulumi.set(__self__, "ultra_ssd_disk_iops_read_write", ultra_ssd_disk_iops_read_write)
        if ultra_ssd_disk_mbps_read_write is not None:
            pulumi.set(__self__, "ultra_ssd_disk_mbps_read_write", ultra_ssd_disk_mbps_read_write)
        if write_accelerator_enabled is not None:
            pulumi.set(__self__, "write_accelerator_enabled", write_accelerator_enabled)

    @_builtins.property
    @pulumi.getter
    def caching(self) -> _builtins.str:
        """
        The type of Caching which should be used for this Data Disk. Possible values are `None`, `ReadOnly` and `ReadWrite`.
        """
        return pulumi.get(self, "caching")

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> _builtins.int:
        """
        The size of the Data Disk which should be created.
        """
        return pulumi.get(self, "disk_size_gb")

    @_builtins.property
    @pulumi.getter
    def lun(self) -> _builtins.int:
        """
        The Logical Unit Number of the Data Disk, which must be unique within the Virtual Machine.
        """
        return pulumi.get(self, "lun")

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> _builtins.str:
        """
        The Type of Storage Account which should back this Data Disk. Possible values include `Standard_LRS`, `StandardSSD_LRS`, `StandardSSD_ZRS`, `Premium_LRS`, `PremiumV2_LRS`, `Premium_ZRS` and `UltraSSD_LRS`.

        > **Note:** `UltraSSD_LRS` is only supported when `ultra_ssd_enabled` within the `additional_capabilities` block is enabled.
        """
        return pulumi.get(self, "storage_account_type")

    @_builtins.property
    @pulumi.getter(name="createOption")
    def create_option(self) -> Optional[_builtins.str]:
        """
        The create option which should be used for this Data Disk. Possible values are `Empty` and `FromImage`. Defaults to `Empty`. (`FromImage` should only be used if the source image includes data disks).
        """
        return pulumi.get(self, "create_option")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Disk Encryption Set which should be used to encrypt this Data Disk. Changing this forces a new resource to be created.

        > **Note:** The Disk Encryption Set must have the `Reader` Role Assignment scoped on the Key Vault - in addition to an Access Policy to the Key Vault

        > **Note:** Disk Encryption Sets are in Public Preview in a limited set of regions
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name of the Data Disk.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="ultraSsdDiskIopsReadWrite")
    def ultra_ssd_disk_iops_read_write(self) -> Optional[_builtins.int]:
        """
        Specifies the Read-Write IOPS for this Data Disk. Only settable when `storage_account_type` is `PremiumV2_LRS` or `UltraSSD_LRS`.
        """
        return pulumi.get(self, "ultra_ssd_disk_iops_read_write")

    @_builtins.property
    @pulumi.getter(name="ultraSsdDiskMbpsReadWrite")
    def ultra_ssd_disk_mbps_read_write(self) -> Optional[_builtins.int]:
        """
        Specifies the bandwidth in MB per second for this Data Disk. Only settable when `storage_account_type` is `PremiumV2_LRS` or `UltraSSD_LRS`.
        """
        return pulumi.get(self, "ultra_ssd_disk_mbps_read_write")

    @_builtins.property
    @pulumi.getter(name="writeAcceleratorEnabled")
    def write_accelerator_enabled(self) -> Optional[_builtins.bool]:
        """
        Should Write Accelerator be enabled for this Data Disk? Defaults to `false`.

        > **Note:** This requires that the `storage_account_type` is set to `Premium_LRS` and that `caching` is set to `None`.
        """
        return pulumi.get(self, "write_accelerator_enabled")


@pulumi.output_type
class WindowsVirtualMachineScaleSetExtension(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "typeHandlerVersion":
            suggest = "type_handler_version"
        elif key == "autoUpgradeMinorVersion":
            suggest = "auto_upgrade_minor_version"
        elif key == "automaticUpgradeEnabled":
            suggest = "automatic_upgrade_enabled"
        elif key == "forceUpdateTag":
            suggest = "force_update_tag"
        elif key == "protectedSettings":
            suggest = "protected_settings"
        elif key == "protectedSettingsFromKeyVault":
            suggest = "protected_settings_from_key_vault"
        elif key == "provisionAfterExtensions":
            suggest = "provision_after_extensions"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsVirtualMachineScaleSetExtension. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsVirtualMachineScaleSetExtension.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsVirtualMachineScaleSetExtension.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 publisher: _builtins.str,
                 type: _builtins.str,
                 type_handler_version: _builtins.str,
                 auto_upgrade_minor_version: Optional[_builtins.bool] = None,
                 automatic_upgrade_enabled: Optional[_builtins.bool] = None,
                 force_update_tag: Optional[_builtins.str] = None,
                 protected_settings: Optional[_builtins.str] = None,
                 protected_settings_from_key_vault: Optional['outputs.WindowsVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault'] = None,
                 provision_after_extensions: Optional[Sequence[_builtins.str]] = None,
                 settings: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name for the Virtual Machine Scale Set Extension.
        :param _builtins.str publisher: Specifies the Publisher of the Extension.
        :param _builtins.str type: Specifies the Type of the Extension.
        :param _builtins.str type_handler_version: Specifies the version of the extension to use, available versions can be found using the Azure CLI.
        :param _builtins.bool auto_upgrade_minor_version: Should the latest version of the Extension be used at Deployment Time, if one is available? This won't auto-update the extension on existing installation. Defaults to `true`.
        :param _builtins.bool automatic_upgrade_enabled: Should the Extension be automatically updated whenever the Publisher releases a new version of this VM Extension?
        :param _builtins.str force_update_tag: A value which, when different to the previous value can be used to force-run the Extension even if the Extension Configuration hasn't changed.
        :param _builtins.str protected_settings: A JSON String which specifies Sensitive Settings (such as Passwords) for the Extension.
               
               > **Note:** Keys within the `protected_settings` block are notoriously case-sensitive, where the casing required (e.g. TitleCase vs snakeCase) depends on the Extension being used. Please refer to the documentation for the specific Virtual Machine Extension you're looking to use for more information.
        :param 'WindowsVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVaultArgs' protected_settings_from_key_vault: A `protected_settings_from_key_vault` block as defined below.
               
               > **Note:** `protected_settings_from_key_vault` cannot be used with `protected_settings`
        :param Sequence[_builtins.str] provision_after_extensions: An ordered list of Extension names which this should be provisioned after.
        :param _builtins.str settings: A JSON String which specifies Settings for the Extension.
               
               > **Note:** Keys within the `settings` block are notoriously case-sensitive, where the casing required (e.g. TitleCase vs snakeCase) depends on the Extension being used. Please refer to the documentation for the specific Virtual Machine Extension you're looking to use for more information.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "type_handler_version", type_handler_version)
        if auto_upgrade_minor_version is not None:
            pulumi.set(__self__, "auto_upgrade_minor_version", auto_upgrade_minor_version)
        if automatic_upgrade_enabled is not None:
            pulumi.set(__self__, "automatic_upgrade_enabled", automatic_upgrade_enabled)
        if force_update_tag is not None:
            pulumi.set(__self__, "force_update_tag", force_update_tag)
        if protected_settings is not None:
            pulumi.set(__self__, "protected_settings", protected_settings)
        if protected_settings_from_key_vault is not None:
            pulumi.set(__self__, "protected_settings_from_key_vault", protected_settings_from_key_vault)
        if provision_after_extensions is not None:
            pulumi.set(__self__, "provision_after_extensions", provision_after_extensions)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name for the Virtual Machine Scale Set Extension.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        """
        Specifies the Publisher of the Extension.
        """
        return pulumi.get(self, "publisher")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the Type of the Extension.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="typeHandlerVersion")
    def type_handler_version(self) -> _builtins.str:
        """
        Specifies the version of the extension to use, available versions can be found using the Azure CLI.
        """
        return pulumi.get(self, "type_handler_version")

    @_builtins.property
    @pulumi.getter(name="autoUpgradeMinorVersion")
    def auto_upgrade_minor_version(self) -> Optional[_builtins.bool]:
        """
        Should the latest version of the Extension be used at Deployment Time, if one is available? This won't auto-update the extension on existing installation. Defaults to `true`.
        """
        return pulumi.get(self, "auto_upgrade_minor_version")

    @_builtins.property
    @pulumi.getter(name="automaticUpgradeEnabled")
    def automatic_upgrade_enabled(self) -> Optional[_builtins.bool]:
        """
        Should the Extension be automatically updated whenever the Publisher releases a new version of this VM Extension?
        """
        return pulumi.get(self, "automatic_upgrade_enabled")

    @_builtins.property
    @pulumi.getter(name="forceUpdateTag")
    def force_update_tag(self) -> Optional[_builtins.str]:
        """
        A value which, when different to the previous value can be used to force-run the Extension even if the Extension Configuration hasn't changed.
        """
        return pulumi.get(self, "force_update_tag")

    @_builtins.property
    @pulumi.getter(name="protectedSettings")
    def protected_settings(self) -> Optional[_builtins.str]:
        """
        A JSON String which specifies Sensitive Settings (such as Passwords) for the Extension.

        > **Note:** Keys within the `protected_settings` block are notoriously case-sensitive, where the casing required (e.g. TitleCase vs snakeCase) depends on the Extension being used. Please refer to the documentation for the specific Virtual Machine Extension you're looking to use for more information.
        """
        return pulumi.get(self, "protected_settings")

    @_builtins.property
    @pulumi.getter(name="protectedSettingsFromKeyVault")
    def protected_settings_from_key_vault(self) -> Optional['outputs.WindowsVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault']:
        """
        A `protected_settings_from_key_vault` block as defined below.

        > **Note:** `protected_settings_from_key_vault` cannot be used with `protected_settings`
        """
        return pulumi.get(self, "protected_settings_from_key_vault")

    @_builtins.property
    @pulumi.getter(name="provisionAfterExtensions")
    def provision_after_extensions(self) -> Optional[Sequence[_builtins.str]]:
        """
        An ordered list of Extension names which this should be provisioned after.
        """
        return pulumi.get(self, "provision_after_extensions")

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[_builtins.str]:
        """
        A JSON String which specifies Settings for the Extension.

        > **Note:** Keys within the `settings` block are notoriously case-sensitive, where the casing required (e.g. TitleCase vs snakeCase) depends on the Extension being used. Please refer to the documentation for the specific Virtual Machine Extension you're looking to use for more information.
        """
        return pulumi.get(self, "settings")


@pulumi.output_type
class WindowsVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "secretUrl":
            suggest = "secret_url"
        elif key == "sourceVaultId":
            suggest = "source_vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsVirtualMachineScaleSetExtensionProtectedSettingsFromKeyVault.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 secret_url: _builtins.str,
                 source_vault_id: _builtins.str):
        """
        :param _builtins.str secret_url: The URL to the Key Vault Secret which stores the protected settings.
        :param _builtins.str source_vault_id: The ID of the source Key Vault.
        """
        pulumi.set(__self__, "secret_url", secret_url)
        pulumi.set(__self__, "source_vault_id", source_vault_id)

    @_builtins.property
    @pulumi.getter(name="secretUrl")
    def secret_url(self) -> _builtins.str:
        """
        The URL to the Key Vault Secret which stores the protected settings.
        """
        return pulumi.get(self, "secret_url")

    @_builtins.property
    @pulumi.getter(name="sourceVaultId")
    def source_vault_id(self) -> _builtins.str:
        """
        The ID of the source Key Vault.
        """
        return pulumi.get(self, "source_vault_id")


@pulumi.output_type
class WindowsVirtualMachineScaleSetGalleryApplication(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "versionId":
            suggest = "version_id"
        elif key == "configurationBlobUri":
            suggest = "configuration_blob_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsVirtualMachineScaleSetGalleryApplication. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsVirtualMachineScaleSetGalleryApplication.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsVirtualMachineScaleSetGalleryApplication.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 version_id: _builtins.str,
                 configuration_blob_uri: Optional[_builtins.str] = None,
                 order: Optional[_builtins.int] = None,
                 tag: Optional[_builtins.str] = None):
        """
        :param _builtins.str version_id: Specifies the Gallery Application Version resource ID. Changing this forces a new resource to be created.
        :param _builtins.str configuration_blob_uri: Specifies the URI to an Azure Blob that will replace the default configuration for the package if provided. Changing this forces a new resource to be created.
        :param _builtins.int order: Specifies the order in which the packages have to be installed. Possible values are between `0` and `2147483647`. Defaults to `0`. Changing this forces a new resource to be created.
        :param _builtins.str tag: Specifies a passthrough value for more generic context. This field can be any valid `string` value. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "version_id", version_id)
        if configuration_blob_uri is not None:
            pulumi.set(__self__, "configuration_blob_uri", configuration_blob_uri)
        if order is not None:
            pulumi.set(__self__, "order", order)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @_builtins.property
    @pulumi.getter(name="versionId")
    def version_id(self) -> _builtins.str:
        """
        Specifies the Gallery Application Version resource ID. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "version_id")

    @_builtins.property
    @pulumi.getter(name="configurationBlobUri")
    def configuration_blob_uri(self) -> Optional[_builtins.str]:
        """
        Specifies the URI to an Azure Blob that will replace the default configuration for the package if provided. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "configuration_blob_uri")

    @_builtins.property
    @pulumi.getter
    def order(self) -> Optional[_builtins.int]:
        """
        Specifies the order in which the packages have to be installed. Possible values are between `0` and `2147483647`. Defaults to `0`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "order")

    @_builtins.property
    @pulumi.getter
    def tag(self) -> Optional[_builtins.str]:
        """
        Specifies a passthrough value for more generic context. This field can be any valid `string` value. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class WindowsVirtualMachineScaleSetIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsVirtualMachineScaleSetIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsVirtualMachineScaleSetIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsVirtualMachineScaleSetIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Windows Virtual Machine Scale Set. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        :param Sequence[_builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Windows Virtual Machine Scale Set.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param _builtins.str principal_id: The Principal ID associated with this Managed Service Identity.
        :param _builtins.str tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Windows Virtual Machine Scale Set. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Windows Virtual Machine Scale Set.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class WindowsVirtualMachineScaleSetNetworkInterface(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipConfigurations":
            suggest = "ip_configurations"
        elif key == "auxiliaryMode":
            suggest = "auxiliary_mode"
        elif key == "auxiliarySku":
            suggest = "auxiliary_sku"
        elif key == "dnsServers":
            suggest = "dns_servers"
        elif key == "enableAcceleratedNetworking":
            suggest = "enable_accelerated_networking"
        elif key == "enableIpForwarding":
            suggest = "enable_ip_forwarding"
        elif key == "networkSecurityGroupId":
            suggest = "network_security_group_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsVirtualMachineScaleSetNetworkInterface. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsVirtualMachineScaleSetNetworkInterface.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsVirtualMachineScaleSetNetworkInterface.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_configurations: Sequence['outputs.WindowsVirtualMachineScaleSetNetworkInterfaceIpConfiguration'],
                 name: _builtins.str,
                 auxiliary_mode: Optional[_builtins.str] = None,
                 auxiliary_sku: Optional[_builtins.str] = None,
                 dns_servers: Optional[Sequence[_builtins.str]] = None,
                 enable_accelerated_networking: Optional[_builtins.bool] = None,
                 enable_ip_forwarding: Optional[_builtins.bool] = None,
                 network_security_group_id: Optional[_builtins.str] = None,
                 primary: Optional[_builtins.bool] = None):
        """
        :param Sequence['WindowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationArgs'] ip_configurations: One or more `ip_configuration` blocks as defined above.
        :param _builtins.str name: The Name which should be used for this Network Interface. Changing this forces a new resource to be created.
        :param _builtins.str auxiliary_mode: Specifies the auxiliary mode used to enable network high-performance feature on Network Virtual Appliances (NVAs). This feature offers competitive performance in Connections Per Second (CPS) optimization, along with improvements to handling large amounts of simultaneous connections. Possible values are `AcceleratedConnections` and `Floating`.
               
               > **Note:** `auxiliary_mode` is in **Preview** and requires that the prerequisites are enabled - [more information can be found in the Azure documentation](https://learn.microsoft.com/azure/networking/nva-accelerated-connections#prerequisites).
        :param _builtins.str auxiliary_sku: Specifies the SKU used for the network high-performance feature on Network Virtual Appliances (NVAs). Possible values are `A1`, `A2`, `A4` and `A8`.
               
               > **Note:** `auxiliary_sku` is in **Preview** and requires that the prerequisites are enabled - [more information can be found in the Azure documentation](https://learn.microsoft.com/azure/networking/nva-accelerated-connections#prerequisites).
        :param Sequence[_builtins.str] dns_servers: A list of IP Addresses of DNS Servers which should be assigned to the Network Interface.
        :param _builtins.bool enable_accelerated_networking: Does this Network Interface support Accelerated Networking? Defaults to `false`.
        :param _builtins.bool enable_ip_forwarding: Does this Network Interface support IP Forwarding? Defaults to `false`.
        :param _builtins.str network_security_group_id: The ID of a Network Security Group which should be assigned to this Network Interface.
        :param _builtins.bool primary: Is this the Primary IP Configuration?
               
               > **Note:** If multiple `network_interface` blocks are specified, one must be set to `primary`.
        """
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        pulumi.set(__self__, "name", name)
        if auxiliary_mode is not None:
            pulumi.set(__self__, "auxiliary_mode", auxiliary_mode)
        if auxiliary_sku is not None:
            pulumi.set(__self__, "auxiliary_sku", auxiliary_sku)
        if dns_servers is not None:
            pulumi.set(__self__, "dns_servers", dns_servers)
        if enable_accelerated_networking is not None:
            pulumi.set(__self__, "enable_accelerated_networking", enable_accelerated_networking)
        if enable_ip_forwarding is not None:
            pulumi.set(__self__, "enable_ip_forwarding", enable_ip_forwarding)
        if network_security_group_id is not None:
            pulumi.set(__self__, "network_security_group_id", network_security_group_id)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)

    @_builtins.property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Sequence['outputs.WindowsVirtualMachineScaleSetNetworkInterfaceIpConfiguration']:
        """
        One or more `ip_configuration` blocks as defined above.
        """
        return pulumi.get(self, "ip_configurations")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The Name which should be used for this Network Interface. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="auxiliaryMode")
    def auxiliary_mode(self) -> Optional[_builtins.str]:
        """
        Specifies the auxiliary mode used to enable network high-performance feature on Network Virtual Appliances (NVAs). This feature offers competitive performance in Connections Per Second (CPS) optimization, along with improvements to handling large amounts of simultaneous connections. Possible values are `AcceleratedConnections` and `Floating`.

        > **Note:** `auxiliary_mode` is in **Preview** and requires that the prerequisites are enabled - [more information can be found in the Azure documentation](https://learn.microsoft.com/azure/networking/nva-accelerated-connections#prerequisites).
        """
        return pulumi.get(self, "auxiliary_mode")

    @_builtins.property
    @pulumi.getter(name="auxiliarySku")
    def auxiliary_sku(self) -> Optional[_builtins.str]:
        """
        Specifies the SKU used for the network high-performance feature on Network Virtual Appliances (NVAs). Possible values are `A1`, `A2`, `A4` and `A8`.

        > **Note:** `auxiliary_sku` is in **Preview** and requires that the prerequisites are enabled - [more information can be found in the Azure documentation](https://learn.microsoft.com/azure/networking/nva-accelerated-connections#prerequisites).
        """
        return pulumi.get(self, "auxiliary_sku")

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of IP Addresses of DNS Servers which should be assigned to the Network Interface.
        """
        return pulumi.get(self, "dns_servers")

    @_builtins.property
    @pulumi.getter(name="enableAcceleratedNetworking")
    def enable_accelerated_networking(self) -> Optional[_builtins.bool]:
        """
        Does this Network Interface support Accelerated Networking? Defaults to `false`.
        """
        return pulumi.get(self, "enable_accelerated_networking")

    @_builtins.property
    @pulumi.getter(name="enableIpForwarding")
    def enable_ip_forwarding(self) -> Optional[_builtins.bool]:
        """
        Does this Network Interface support IP Forwarding? Defaults to `false`.
        """
        return pulumi.get(self, "enable_ip_forwarding")

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupId")
    def network_security_group_id(self) -> Optional[_builtins.str]:
        """
        The ID of a Network Security Group which should be assigned to this Network Interface.
        """
        return pulumi.get(self, "network_security_group_id")

    @_builtins.property
    @pulumi.getter
    def primary(self) -> Optional[_builtins.bool]:
        """
        Is this the Primary IP Configuration?

        > **Note:** If multiple `network_interface` blocks are specified, one must be set to `primary`.
        """
        return pulumi.get(self, "primary")


@pulumi.output_type
class WindowsVirtualMachineScaleSetNetworkInterfaceIpConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationGatewayBackendAddressPoolIds":
            suggest = "application_gateway_backend_address_pool_ids"
        elif key == "applicationSecurityGroupIds":
            suggest = "application_security_group_ids"
        elif key == "loadBalancerBackendAddressPoolIds":
            suggest = "load_balancer_backend_address_pool_ids"
        elif key == "loadBalancerInboundNatRulesIds":
            suggest = "load_balancer_inbound_nat_rules_ids"
        elif key == "publicIpAddresses":
            suggest = "public_ip_addresses"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsVirtualMachineScaleSetNetworkInterfaceIpConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsVirtualMachineScaleSetNetworkInterfaceIpConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsVirtualMachineScaleSetNetworkInterfaceIpConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 application_gateway_backend_address_pool_ids: Optional[Sequence[_builtins.str]] = None,
                 application_security_group_ids: Optional[Sequence[_builtins.str]] = None,
                 load_balancer_backend_address_pool_ids: Optional[Sequence[_builtins.str]] = None,
                 load_balancer_inbound_nat_rules_ids: Optional[Sequence[_builtins.str]] = None,
                 primary: Optional[_builtins.bool] = None,
                 public_ip_addresses: Optional[Sequence['outputs.WindowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress']] = None,
                 subnet_id: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The Name which should be used for this IP Configuration.
        :param Sequence[_builtins.str] application_gateway_backend_address_pool_ids: A list of Backend Address Pools ID's from a Application Gateway which this Virtual Machine Scale Set should be connected to.
        :param Sequence[_builtins.str] application_security_group_ids: A list of Application Security Group ID's which this Virtual Machine Scale Set should be connected to.
        :param Sequence[_builtins.str] load_balancer_backend_address_pool_ids: A list of Backend Address Pools ID's from a Load Balancer which this Virtual Machine Scale Set should be connected to.
               
               > **Note:** When the Virtual Machine Scale Set is configured to have public IPs per instance are created with a load balancer, the SKU of the Virtual Machine instance IPs is determined by the SKU of the Virtual Machine Scale Sets Load Balancer (e.g. `Basic` or `Standard`). Alternatively, you may use the `public_ip_prefix_id` field to generate instance-level IPs in a virtual machine scale set as well. The zonal properties of the prefix will be passed to the Virtual Machine instance IPs, though they will not be shown in the output. To view the public IP addresses assigned to the Virtual Machine Scale Sets Virtual Machine instances use the **az vmss list-instance-public-ips --resource-group `ResourceGroupName` --name `VirtualMachineScaleSetName`** CLI command.
               
               > **Note:** When using this field you'll also need to configure a Rule for the Load Balancer, and use a `depends_on` between this resource and the Load Balancer Rule.
        :param Sequence[_builtins.str] load_balancer_inbound_nat_rules_ids: A list of NAT Rule ID's from a Load Balancer which this Virtual Machine Scale Set should be connected to.
               
               > **Note:** When using this field you'll also need to configure a Rule for the Load Balancer, and use a `depends_on` between this resource and the Load Balancer Rule.
        :param _builtins.bool primary: Is this the Primary IP Configuration for this Network Interface? Defaults to `false`.
               
               > **Note:** One `ip_configuration` block must be marked as Primary for each Network Interface.
        :param Sequence['WindowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressArgs'] public_ip_addresses: A `public_ip_address` block as defined below.
        :param _builtins.str subnet_id: The ID of the Subnet which this IP Configuration should be connected to.
               
               > **Note:** `subnet_id` is required if `version` is set to `IPv4`.
        :param _builtins.str version: The Internet Protocol Version which should be used for this IP Configuration. Possible values are `IPv4` and `IPv6`. Defaults to `IPv4`.
        """
        pulumi.set(__self__, "name", name)
        if application_gateway_backend_address_pool_ids is not None:
            pulumi.set(__self__, "application_gateway_backend_address_pool_ids", application_gateway_backend_address_pool_ids)
        if application_security_group_ids is not None:
            pulumi.set(__self__, "application_security_group_ids", application_security_group_ids)
        if load_balancer_backend_address_pool_ids is not None:
            pulumi.set(__self__, "load_balancer_backend_address_pool_ids", load_balancer_backend_address_pool_ids)
        if load_balancer_inbound_nat_rules_ids is not None:
            pulumi.set(__self__, "load_balancer_inbound_nat_rules_ids", load_balancer_inbound_nat_rules_ids)
        if primary is not None:
            pulumi.set(__self__, "primary", primary)
        if public_ip_addresses is not None:
            pulumi.set(__self__, "public_ip_addresses", public_ip_addresses)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The Name which should be used for this IP Configuration.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="applicationGatewayBackendAddressPoolIds")
    def application_gateway_backend_address_pool_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of Backend Address Pools ID's from a Application Gateway which this Virtual Machine Scale Set should be connected to.
        """
        return pulumi.get(self, "application_gateway_backend_address_pool_ids")

    @_builtins.property
    @pulumi.getter(name="applicationSecurityGroupIds")
    def application_security_group_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of Application Security Group ID's which this Virtual Machine Scale Set should be connected to.
        """
        return pulumi.get(self, "application_security_group_ids")

    @_builtins.property
    @pulumi.getter(name="loadBalancerBackendAddressPoolIds")
    def load_balancer_backend_address_pool_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of Backend Address Pools ID's from a Load Balancer which this Virtual Machine Scale Set should be connected to.

        > **Note:** When the Virtual Machine Scale Set is configured to have public IPs per instance are created with a load balancer, the SKU of the Virtual Machine instance IPs is determined by the SKU of the Virtual Machine Scale Sets Load Balancer (e.g. `Basic` or `Standard`). Alternatively, you may use the `public_ip_prefix_id` field to generate instance-level IPs in a virtual machine scale set as well. The zonal properties of the prefix will be passed to the Virtual Machine instance IPs, though they will not be shown in the output. To view the public IP addresses assigned to the Virtual Machine Scale Sets Virtual Machine instances use the **az vmss list-instance-public-ips --resource-group `ResourceGroupName` --name `VirtualMachineScaleSetName`** CLI command.

        > **Note:** When using this field you'll also need to configure a Rule for the Load Balancer, and use a `depends_on` between this resource and the Load Balancer Rule.
        """
        return pulumi.get(self, "load_balancer_backend_address_pool_ids")

    @_builtins.property
    @pulumi.getter(name="loadBalancerInboundNatRulesIds")
    def load_balancer_inbound_nat_rules_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of NAT Rule ID's from a Load Balancer which this Virtual Machine Scale Set should be connected to.

        > **Note:** When using this field you'll also need to configure a Rule for the Load Balancer, and use a `depends_on` between this resource and the Load Balancer Rule.
        """
        return pulumi.get(self, "load_balancer_inbound_nat_rules_ids")

    @_builtins.property
    @pulumi.getter
    def primary(self) -> Optional[_builtins.bool]:
        """
        Is this the Primary IP Configuration for this Network Interface? Defaults to `false`.

        > **Note:** One `ip_configuration` block must be marked as Primary for each Network Interface.
        """
        return pulumi.get(self, "primary")

    @_builtins.property
    @pulumi.getter(name="publicIpAddresses")
    def public_ip_addresses(self) -> Optional[Sequence['outputs.WindowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress']]:
        """
        A `public_ip_address` block as defined below.
        """
        return pulumi.get(self, "public_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Subnet which this IP Configuration should be connected to.

        > **Note:** `subnet_id` is required if `version` is set to `IPv4`.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The Internet Protocol Version which should be used for this IP Configuration. Possible values are `IPv4` and `IPv6`. Defaults to `IPv4`.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class WindowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainNameLabel":
            suggest = "domain_name_label"
        elif key == "idleTimeoutInMinutes":
            suggest = "idle_timeout_in_minutes"
        elif key == "ipTags":
            suggest = "ip_tags"
        elif key == "publicIpPrefixId":
            suggest = "public_ip_prefix_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 domain_name_label: Optional[_builtins.str] = None,
                 idle_timeout_in_minutes: Optional[_builtins.int] = None,
                 ip_tags: Optional[Sequence['outputs.WindowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag']] = None,
                 public_ip_prefix_id: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The Name of the Public IP Address Configuration.
        :param _builtins.str domain_name_label: The Prefix which should be used for the Domain Name Label for each Virtual Machine Instance. Azure concatenates the Domain Name Label and Virtual Machine Index to create a unique Domain Name Label for each Virtual Machine.
        :param _builtins.int idle_timeout_in_minutes: The Idle Timeout in Minutes for the Public IP Address. Possible values are in the range `4` to `32`.
        :param Sequence['WindowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagArgs'] ip_tags: One or more `ip_tag` blocks as defined above. Changing this forces a new resource to be created.
        :param _builtins.str public_ip_prefix_id: The ID of the Public IP Address Prefix from where Public IP Addresses should be allocated. Changing this forces a new resource to be created.
               
               > **Note:** This functionality is in Preview and must be opted into via `az feature register --namespace Microsoft.Network --name AllowBringYourOwnPublicIpAddress` and then `az provider register -n Microsoft.Network`.
        :param _builtins.str version: The Internet Protocol Version which should be used for this public IP address. Possible values are `IPv4` and `IPv6`. Defaults to `IPv4`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "name", name)
        if domain_name_label is not None:
            pulumi.set(__self__, "domain_name_label", domain_name_label)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if ip_tags is not None:
            pulumi.set(__self__, "ip_tags", ip_tags)
        if public_ip_prefix_id is not None:
            pulumi.set(__self__, "public_ip_prefix_id", public_ip_prefix_id)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The Name of the Public IP Address Configuration.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="domainNameLabel")
    def domain_name_label(self) -> Optional[_builtins.str]:
        """
        The Prefix which should be used for the Domain Name Label for each Virtual Machine Instance. Azure concatenates the Domain Name Label and Virtual Machine Index to create a unique Domain Name Label for each Virtual Machine.
        """
        return pulumi.get(self, "domain_name_label")

    @_builtins.property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[_builtins.int]:
        """
        The Idle Timeout in Minutes for the Public IP Address. Possible values are in the range `4` to `32`.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @_builtins.property
    @pulumi.getter(name="ipTags")
    def ip_tags(self) -> Optional[Sequence['outputs.WindowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag']]:
        """
        One or more `ip_tag` blocks as defined above. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "ip_tags")

    @_builtins.property
    @pulumi.getter(name="publicIpPrefixId")
    def public_ip_prefix_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Public IP Address Prefix from where Public IP Addresses should be allocated. Changing this forces a new resource to be created.

        > **Note:** This functionality is in Preview and must be opted into via `az feature register --namespace Microsoft.Network --name AllowBringYourOwnPublicIpAddress` and then `az provider register -n Microsoft.Network`.
        """
        return pulumi.get(self, "public_ip_prefix_id")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        The Internet Protocol Version which should be used for this public IP address. Possible values are `IPv4` and `IPv6`. Defaults to `IPv4`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class WindowsVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTag(dict):
    def __init__(__self__, *,
                 tag: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str tag: The IP Tag associated with the Public IP, such as `SQL` or `Storage`. Changing this forces a new resource to be created.
        :param _builtins.str type: The Type of IP Tag, such as `FirstPartyUsage`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def tag(self) -> _builtins.str:
        """
        The IP Tag associated with the Public IP, such as `SQL` or `Storage`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The Type of IP Tag, such as `FirstPartyUsage`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class WindowsVirtualMachineScaleSetOsDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageAccountType":
            suggest = "storage_account_type"
        elif key == "diffDiskSettings":
            suggest = "diff_disk_settings"
        elif key == "diskEncryptionSetId":
            suggest = "disk_encryption_set_id"
        elif key == "diskSizeGb":
            suggest = "disk_size_gb"
        elif key == "secureVmDiskEncryptionSetId":
            suggest = "secure_vm_disk_encryption_set_id"
        elif key == "securityEncryptionType":
            suggest = "security_encryption_type"
        elif key == "writeAcceleratorEnabled":
            suggest = "write_accelerator_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsVirtualMachineScaleSetOsDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsVirtualMachineScaleSetOsDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsVirtualMachineScaleSetOsDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 caching: _builtins.str,
                 storage_account_type: _builtins.str,
                 diff_disk_settings: Optional['outputs.WindowsVirtualMachineScaleSetOsDiskDiffDiskSettings'] = None,
                 disk_encryption_set_id: Optional[_builtins.str] = None,
                 disk_size_gb: Optional[_builtins.int] = None,
                 secure_vm_disk_encryption_set_id: Optional[_builtins.str] = None,
                 security_encryption_type: Optional[_builtins.str] = None,
                 write_accelerator_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.str caching: The Type of Caching which should be used for the Internal OS Disk. Possible values are `None`, `ReadOnly` and `ReadWrite`.
        :param _builtins.str storage_account_type: The Type of Storage Account which should back this the Internal OS Disk. Possible values include `Standard_LRS`, `StandardSSD_LRS`, `StandardSSD_ZRS`, `Premium_LRS` and `Premium_ZRS`. Changing this forces a new resource to be created.
        :param 'WindowsVirtualMachineScaleSetOsDiskDiffDiskSettingsArgs' diff_disk_settings: A `diff_disk_settings` block as defined above. Changing this forces a new resource to be created.
        :param _builtins.str disk_encryption_set_id: The ID of the Disk Encryption Set which should be used to encrypt this OS Disk. Conflicts with `secure_vm_disk_encryption_set_id`. Changing this forces a new resource to be created.
               
               > **Note:** The Disk Encryption Set must have the `Reader` Role Assignment scoped on the Key Vault - in addition to an Access Policy to the Key Vault
               
               > **Note:** Disk Encryption Sets are in Public Preview in a limited set of regions
        :param _builtins.int disk_size_gb: The Size of the Internal OS Disk in GB, if you wish to vary from the size used in the image this Virtual Machine Scale Set is sourced from.
               
               > **Note:** If specified this must be equal to or larger than the size of the Image the VM Scale Set is based on. When creating a larger disk than exists in the image you'll need to repartition the disk to use the remaining space.
        :param _builtins.str secure_vm_disk_encryption_set_id: The ID of the Disk Encryption Set which should be used to Encrypt the OS Disk when the Virtual Machine Scale Set is Confidential VMSS. Conflicts with `disk_encryption_set_id`. Changing this forces a new resource to be created.
               
               > **Note:** `secure_vm_disk_encryption_set_id` can only be specified when `security_encryption_type` is set to `DiskWithVMGuestState`.
        :param _builtins.str security_encryption_type: Encryption Type when the Virtual Machine Scale Set is Confidential VMSS. Possible values are `VMGuestStateOnly` and `DiskWithVMGuestState`. Changing this forces a new resource to be created.
               
               > **Note:** `vtpm_enabled` must be set to `true` when `security_encryption_type` is specified.
               
               > **Note:** `encryption_at_host_enabled` cannot be set to `true` when `security_encryption_type` is set to `DiskWithVMGuestState`.
        :param _builtins.bool write_accelerator_enabled: Should Write Accelerator be Enabled for this OS Disk? Defaults to `false`.
               
               > **Note:** This requires that the `storage_account_type` is set to `Premium_LRS` and that `caching` is set to `None`.
        """
        pulumi.set(__self__, "caching", caching)
        pulumi.set(__self__, "storage_account_type", storage_account_type)
        if diff_disk_settings is not None:
            pulumi.set(__self__, "diff_disk_settings", diff_disk_settings)
        if disk_encryption_set_id is not None:
            pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if secure_vm_disk_encryption_set_id is not None:
            pulumi.set(__self__, "secure_vm_disk_encryption_set_id", secure_vm_disk_encryption_set_id)
        if security_encryption_type is not None:
            pulumi.set(__self__, "security_encryption_type", security_encryption_type)
        if write_accelerator_enabled is not None:
            pulumi.set(__self__, "write_accelerator_enabled", write_accelerator_enabled)

    @_builtins.property
    @pulumi.getter
    def caching(self) -> _builtins.str:
        """
        The Type of Caching which should be used for the Internal OS Disk. Possible values are `None`, `ReadOnly` and `ReadWrite`.
        """
        return pulumi.get(self, "caching")

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> _builtins.str:
        """
        The Type of Storage Account which should back this the Internal OS Disk. Possible values include `Standard_LRS`, `StandardSSD_LRS`, `StandardSSD_ZRS`, `Premium_LRS` and `Premium_ZRS`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_type")

    @_builtins.property
    @pulumi.getter(name="diffDiskSettings")
    def diff_disk_settings(self) -> Optional['outputs.WindowsVirtualMachineScaleSetOsDiskDiffDiskSettings']:
        """
        A `diff_disk_settings` block as defined above. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "diff_disk_settings")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Disk Encryption Set which should be used to encrypt this OS Disk. Conflicts with `secure_vm_disk_encryption_set_id`. Changing this forces a new resource to be created.

        > **Note:** The Disk Encryption Set must have the `Reader` Role Assignment scoped on the Key Vault - in addition to an Access Policy to the Key Vault

        > **Note:** Disk Encryption Sets are in Public Preview in a limited set of regions
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @_builtins.property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[_builtins.int]:
        """
        The Size of the Internal OS Disk in GB, if you wish to vary from the size used in the image this Virtual Machine Scale Set is sourced from.

        > **Note:** If specified this must be equal to or larger than the size of the Image the VM Scale Set is based on. When creating a larger disk than exists in the image you'll need to repartition the disk to use the remaining space.
        """
        return pulumi.get(self, "disk_size_gb")

    @_builtins.property
    @pulumi.getter(name="secureVmDiskEncryptionSetId")
    def secure_vm_disk_encryption_set_id(self) -> Optional[_builtins.str]:
        """
        The ID of the Disk Encryption Set which should be used to Encrypt the OS Disk when the Virtual Machine Scale Set is Confidential VMSS. Conflicts with `disk_encryption_set_id`. Changing this forces a new resource to be created.

        > **Note:** `secure_vm_disk_encryption_set_id` can only be specified when `security_encryption_type` is set to `DiskWithVMGuestState`.
        """
        return pulumi.get(self, "secure_vm_disk_encryption_set_id")

    @_builtins.property
    @pulumi.getter(name="securityEncryptionType")
    def security_encryption_type(self) -> Optional[_builtins.str]:
        """
        Encryption Type when the Virtual Machine Scale Set is Confidential VMSS. Possible values are `VMGuestStateOnly` and `DiskWithVMGuestState`. Changing this forces a new resource to be created.

        > **Note:** `vtpm_enabled` must be set to `true` when `security_encryption_type` is specified.

        > **Note:** `encryption_at_host_enabled` cannot be set to `true` when `security_encryption_type` is set to `DiskWithVMGuestState`.
        """
        return pulumi.get(self, "security_encryption_type")

    @_builtins.property
    @pulumi.getter(name="writeAcceleratorEnabled")
    def write_accelerator_enabled(self) -> Optional[_builtins.bool]:
        """
        Should Write Accelerator be Enabled for this OS Disk? Defaults to `false`.

        > **Note:** This requires that the `storage_account_type` is set to `Premium_LRS` and that `caching` is set to `None`.
        """
        return pulumi.get(self, "write_accelerator_enabled")


@pulumi.output_type
class WindowsVirtualMachineScaleSetOsDiskDiffDiskSettings(dict):
    def __init__(__self__, *,
                 option: _builtins.str,
                 placement: Optional[_builtins.str] = None):
        """
        :param _builtins.str option: Specifies the Ephemeral Disk Settings for the OS Disk. At this time the only possible value is `Local`. Changing this forces a new resource to be created.
        :param _builtins.str placement: Specifies where to store the Ephemeral Disk. Possible values are `CacheDisk` and `ResourceDisk`. Defaults to `CacheDisk`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "option", option)
        if placement is not None:
            pulumi.set(__self__, "placement", placement)

    @_builtins.property
    @pulumi.getter
    def option(self) -> _builtins.str:
        """
        Specifies the Ephemeral Disk Settings for the OS Disk. At this time the only possible value is `Local`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "option")

    @_builtins.property
    @pulumi.getter
    def placement(self) -> Optional[_builtins.str]:
        """
        Specifies where to store the Ephemeral Disk. Possible values are `CacheDisk` and `ResourceDisk`. Defaults to `CacheDisk`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "placement")


@pulumi.output_type
class WindowsVirtualMachineScaleSetPlan(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 product: _builtins.str,
                 publisher: _builtins.str):
        """
        :param _builtins.str name: Specifies the name of the image from the marketplace. Changing this forces a new resource to be created.
        :param _builtins.str product: Specifies the product of the image from the marketplace. Changing this forces a new resource to be created.
        :param _builtins.str publisher: Specifies the publisher of the image. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "publisher", publisher)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Specifies the name of the image from the marketplace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def product(self) -> _builtins.str:
        """
        Specifies the product of the image from the marketplace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "product")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        """
        Specifies the publisher of the image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher")


@pulumi.output_type
class WindowsVirtualMachineScaleSetRollingUpgradePolicy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxBatchInstancePercent":
            suggest = "max_batch_instance_percent"
        elif key == "maxUnhealthyInstancePercent":
            suggest = "max_unhealthy_instance_percent"
        elif key == "maxUnhealthyUpgradedInstancePercent":
            suggest = "max_unhealthy_upgraded_instance_percent"
        elif key == "pauseTimeBetweenBatches":
            suggest = "pause_time_between_batches"
        elif key == "crossZoneUpgradesEnabled":
            suggest = "cross_zone_upgrades_enabled"
        elif key == "maximumSurgeInstancesEnabled":
            suggest = "maximum_surge_instances_enabled"
        elif key == "prioritizeUnhealthyInstancesEnabled":
            suggest = "prioritize_unhealthy_instances_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsVirtualMachineScaleSetRollingUpgradePolicy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsVirtualMachineScaleSetRollingUpgradePolicy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsVirtualMachineScaleSetRollingUpgradePolicy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_batch_instance_percent: _builtins.int,
                 max_unhealthy_instance_percent: _builtins.int,
                 max_unhealthy_upgraded_instance_percent: _builtins.int,
                 pause_time_between_batches: _builtins.str,
                 cross_zone_upgrades_enabled: Optional[_builtins.bool] = None,
                 maximum_surge_instances_enabled: Optional[_builtins.bool] = None,
                 prioritize_unhealthy_instances_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.int max_batch_instance_percent: The maximum percent of total virtual machine instances that will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum, unhealthy instances in previous or future batches can cause the percentage of instances in a batch to decrease to ensure higher reliability.
        :param _builtins.int max_unhealthy_instance_percent: The maximum percentage of the total virtual machine instances in the scale set that can be simultaneously unhealthy, either as a result of being upgraded, or by being found in an unhealthy state by the virtual machine health checks before the rolling upgrade aborts. This constraint will be checked prior to starting any batch.
        :param _builtins.int max_unhealthy_upgraded_instance_percent: The maximum percentage of upgraded virtual machine instances that can be found to be in an unhealthy state. This check will happen after each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts.
        :param _builtins.str pause_time_between_batches: The wait time between completing the update for all virtual machines in one batch and starting the next batch. The time duration should be specified in ISO 8601 format.
        :param _builtins.bool cross_zone_upgrades_enabled: Should the Virtual Machine Scale Set ignore the Azure Zone boundaries when constructing upgrade batches? Possible values are `true` or `false`.
        :param _builtins.bool maximum_surge_instances_enabled: Create new virtual machines to upgrade the scale set, rather than updating the existing virtual machines. Existing virtual machines will be deleted once the new virtual machines are created for each batch. Possible values are `true` or `false`.
               
               > **Note:** `overprovision` must be set to `false` when `maximum_surge_instances_enabled` is specified.
        :param _builtins.bool prioritize_unhealthy_instances_enabled: Upgrade all unhealthy instances in a scale set before any healthy instances. Possible values are `true` or `false`.
        """
        pulumi.set(__self__, "max_batch_instance_percent", max_batch_instance_percent)
        pulumi.set(__self__, "max_unhealthy_instance_percent", max_unhealthy_instance_percent)
        pulumi.set(__self__, "max_unhealthy_upgraded_instance_percent", max_unhealthy_upgraded_instance_percent)
        pulumi.set(__self__, "pause_time_between_batches", pause_time_between_batches)
        if cross_zone_upgrades_enabled is not None:
            pulumi.set(__self__, "cross_zone_upgrades_enabled", cross_zone_upgrades_enabled)
        if maximum_surge_instances_enabled is not None:
            pulumi.set(__self__, "maximum_surge_instances_enabled", maximum_surge_instances_enabled)
        if prioritize_unhealthy_instances_enabled is not None:
            pulumi.set(__self__, "prioritize_unhealthy_instances_enabled", prioritize_unhealthy_instances_enabled)

    @_builtins.property
    @pulumi.getter(name="maxBatchInstancePercent")
    def max_batch_instance_percent(self) -> _builtins.int:
        """
        The maximum percent of total virtual machine instances that will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum, unhealthy instances in previous or future batches can cause the percentage of instances in a batch to decrease to ensure higher reliability.
        """
        return pulumi.get(self, "max_batch_instance_percent")

    @_builtins.property
    @pulumi.getter(name="maxUnhealthyInstancePercent")
    def max_unhealthy_instance_percent(self) -> _builtins.int:
        """
        The maximum percentage of the total virtual machine instances in the scale set that can be simultaneously unhealthy, either as a result of being upgraded, or by being found in an unhealthy state by the virtual machine health checks before the rolling upgrade aborts. This constraint will be checked prior to starting any batch.
        """
        return pulumi.get(self, "max_unhealthy_instance_percent")

    @_builtins.property
    @pulumi.getter(name="maxUnhealthyUpgradedInstancePercent")
    def max_unhealthy_upgraded_instance_percent(self) -> _builtins.int:
        """
        The maximum percentage of upgraded virtual machine instances that can be found to be in an unhealthy state. This check will happen after each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts.
        """
        return pulumi.get(self, "max_unhealthy_upgraded_instance_percent")

    @_builtins.property
    @pulumi.getter(name="pauseTimeBetweenBatches")
    def pause_time_between_batches(self) -> _builtins.str:
        """
        The wait time between completing the update for all virtual machines in one batch and starting the next batch. The time duration should be specified in ISO 8601 format.
        """
        return pulumi.get(self, "pause_time_between_batches")

    @_builtins.property
    @pulumi.getter(name="crossZoneUpgradesEnabled")
    def cross_zone_upgrades_enabled(self) -> Optional[_builtins.bool]:
        """
        Should the Virtual Machine Scale Set ignore the Azure Zone boundaries when constructing upgrade batches? Possible values are `true` or `false`.
        """
        return pulumi.get(self, "cross_zone_upgrades_enabled")

    @_builtins.property
    @pulumi.getter(name="maximumSurgeInstancesEnabled")
    def maximum_surge_instances_enabled(self) -> Optional[_builtins.bool]:
        """
        Create new virtual machines to upgrade the scale set, rather than updating the existing virtual machines. Existing virtual machines will be deleted once the new virtual machines are created for each batch. Possible values are `true` or `false`.

        > **Note:** `overprovision` must be set to `false` when `maximum_surge_instances_enabled` is specified.
        """
        return pulumi.get(self, "maximum_surge_instances_enabled")

    @_builtins.property
    @pulumi.getter(name="prioritizeUnhealthyInstancesEnabled")
    def prioritize_unhealthy_instances_enabled(self) -> Optional[_builtins.bool]:
        """
        Upgrade all unhealthy instances in a scale set before any healthy instances. Possible values are `true` or `false`.
        """
        return pulumi.get(self, "prioritize_unhealthy_instances_enabled")


@pulumi.output_type
class WindowsVirtualMachineScaleSetScaleIn(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forceDeletionEnabled":
            suggest = "force_deletion_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsVirtualMachineScaleSetScaleIn. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsVirtualMachineScaleSetScaleIn.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsVirtualMachineScaleSetScaleIn.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 force_deletion_enabled: Optional[_builtins.bool] = None,
                 rule: Optional[_builtins.str] = None):
        """
        :param _builtins.bool force_deletion_enabled: Should the virtual machines chosen for removal be force deleted when the virtual machine scale set is being scaled-in? Possible values are `true` or `false`. Defaults to `false`.
        :param _builtins.str rule: The scale-in policy rule that decides which virtual machines are chosen for removal when a Virtual Machine Scale Set is scaled in. Possible values for the scale-in policy rules are `Default`, `NewestVM` and `OldestVM`, defaults to `Default`. For more information about scale in policy, please [refer to this doc](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-scale-in-policy).
        """
        if force_deletion_enabled is not None:
            pulumi.set(__self__, "force_deletion_enabled", force_deletion_enabled)
        if rule is not None:
            pulumi.set(__self__, "rule", rule)

    @_builtins.property
    @pulumi.getter(name="forceDeletionEnabled")
    def force_deletion_enabled(self) -> Optional[_builtins.bool]:
        """
        Should the virtual machines chosen for removal be force deleted when the virtual machine scale set is being scaled-in? Possible values are `true` or `false`. Defaults to `false`.
        """
        return pulumi.get(self, "force_deletion_enabled")

    @_builtins.property
    @pulumi.getter
    def rule(self) -> Optional[_builtins.str]:
        """
        The scale-in policy rule that decides which virtual machines are chosen for removal when a Virtual Machine Scale Set is scaled in. Possible values for the scale-in policy rules are `Default`, `NewestVM` and `OldestVM`, defaults to `Default`. For more information about scale in policy, please [refer to this doc](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-scale-in-policy).
        """
        return pulumi.get(self, "rule")


@pulumi.output_type
class WindowsVirtualMachineScaleSetSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultId":
            suggest = "key_vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsVirtualMachineScaleSetSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsVirtualMachineScaleSetSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsVirtualMachineScaleSetSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificates: Sequence['outputs.WindowsVirtualMachineScaleSetSecretCertificate'],
                 key_vault_id: _builtins.str):
        """
        :param Sequence['WindowsVirtualMachineScaleSetSecretCertificateArgs'] certificates: One or more `certificate` blocks as defined above.
        :param _builtins.str key_vault_id: The ID of the Key Vault from which all Secrets should be sourced.
        """
        pulumi.set(__self__, "certificates", certificates)
        pulumi.set(__self__, "key_vault_id", key_vault_id)

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Sequence['outputs.WindowsVirtualMachineScaleSetSecretCertificate']:
        """
        One or more `certificate` blocks as defined above.
        """
        return pulumi.get(self, "certificates")

    @_builtins.property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> _builtins.str:
        """
        The ID of the Key Vault from which all Secrets should be sourced.
        """
        return pulumi.get(self, "key_vault_id")


@pulumi.output_type
class WindowsVirtualMachineScaleSetSecretCertificate(dict):
    def __init__(__self__, *,
                 store: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.str store: The certificate store on the Virtual Machine where the certificate should be added.
        :param _builtins.str url: The Secret URL of a Key Vault Certificate.
               
               > **Note:** This can be sourced from the `secret_id` field within the `keyvault.Certificate` Resource.
        """
        pulumi.set(__self__, "store", store)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def store(self) -> _builtins.str:
        """
        The certificate store on the Virtual Machine where the certificate should be added.
        """
        return pulumi.get(self, "store")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The Secret URL of a Key Vault Certificate.

        > **Note:** This can be sourced from the `secret_id` field within the `keyvault.Certificate` Resource.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class WindowsVirtualMachineScaleSetSourceImageReference(dict):
    def __init__(__self__, *,
                 offer: _builtins.str,
                 publisher: _builtins.str,
                 sku: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str offer: Specifies the offer of the image used to create the virtual machines. Changing this forces a new resource to be created.
        :param _builtins.str publisher: Specifies the publisher of the image used to create the virtual machines. Changing this forces a new resource to be created.
        :param _builtins.str sku: Specifies the SKU of the image used to create the virtual machines.
        :param _builtins.str version: Specifies the version of the image used to create the virtual machines.
        """
        pulumi.set(__self__, "offer", offer)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "sku", sku)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def offer(self) -> _builtins.str:
        """
        Specifies the offer of the image used to create the virtual machines. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "offer")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        """
        Specifies the publisher of the image used to create the virtual machines. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> _builtins.str:
        """
        Specifies the SKU of the image used to create the virtual machines.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Specifies the version of the image used to create the virtual machines.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class WindowsVirtualMachineScaleSetSpotRestore(dict):
    def __init__(__self__, *,
                 enabled: Optional[_builtins.bool] = None,
                 timeout: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Should the Spot-Try-Restore feature be enabled? The Spot-Try-Restore feature will attempt to automatically restore the evicted Spot Virtual Machine Scale Set VM instances opportunistically based on capacity availability and pricing constraints. Possible values are `true` or `false`. Defaults to `false`. Changing this forces a new resource to be created.
        :param _builtins.str timeout: The length of time that the Virtual Machine Scale Set should attempt to restore the Spot VM instances which have been evicted. The time duration should be between `15` minutes and `120` minutes (inclusive). The time duration should be specified in the ISO 8601 format. Defaults to `PT1H`. Changing this forces a new resource to be created.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Should the Spot-Try-Restore feature be enabled? The Spot-Try-Restore feature will attempt to automatically restore the evicted Spot Virtual Machine Scale Set VM instances opportunistically based on capacity availability and pricing constraints. Possible values are `true` or `false`. Defaults to `false`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.str]:
        """
        The length of time that the Virtual Machine Scale Set should attempt to restore the Spot VM instances which have been evicted. The time duration should be between `15` minutes and `120` minutes (inclusive). The time duration should be specified in the ISO 8601 format. Defaults to `PT1H`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class WindowsVirtualMachineScaleSetTerminationNotification(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 timeout: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Should the termination notification be enabled on this Virtual Machine Scale Set?
        :param _builtins.str timeout: Length of time (in minutes, between 5 and 15) a notification to be sent to the VM on the instance metadata server till the VM gets deleted. The time duration should be specified in ISO 8601 format. Defaults to `PT5M`.
               
               > **Note:** For more information about the termination notification, please [refer to this doc](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-terminate-notification).
        """
        pulumi.set(__self__, "enabled", enabled)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Should the termination notification be enabled on this Virtual Machine Scale Set?
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.str]:
        """
        Length of time (in minutes, between 5 and 15) a notification to be sent to the VM on the instance metadata server till the VM gets deleted. The time duration should be specified in ISO 8601 format. Defaults to `PT5M`.

        > **Note:** For more information about the termination notification, please [refer to this doc](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-terminate-notification).
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class WindowsVirtualMachineScaleSetWinrmListener(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateUrl":
            suggest = "certificate_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsVirtualMachineScaleSetWinrmListener. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsVirtualMachineScaleSetWinrmListener.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsVirtualMachineScaleSetWinrmListener.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protocol: _builtins.str,
                 certificate_url: Optional[_builtins.str] = None):
        """
        :param _builtins.str protocol: The Protocol of the WinRM Listener. Possible values are `Http` and `Https`. Changing this forces a new resource to be created.
        :param _builtins.str certificate_url: The Secret URL of a Key Vault Certificate, which must be specified when `protocol` is set to `Https`. Changing this forces a new resource to be created.
               
               > **Note:** This can be sourced from the `secret_id` field within the `keyvault.Certificate` Resource.
        """
        pulumi.set(__self__, "protocol", protocol)
        if certificate_url is not None:
            pulumi.set(__self__, "certificate_url", certificate_url)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        The Protocol of the WinRM Listener. Possible values are `Http` and `Https`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="certificateUrl")
    def certificate_url(self) -> Optional[_builtins.str]:
        """
        The Secret URL of a Key Vault Certificate, which must be specified when `protocol` is set to `Https`. Changing this forces a new resource to be created.

        > **Note:** This can be sourced from the `secret_id` field within the `keyvault.Certificate` Resource.
        """
        return pulumi.get(self, "certificate_url")


@pulumi.output_type
class WindowsVirtualMachineSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyVaultId":
            suggest = "key_vault_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsVirtualMachineSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsVirtualMachineSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsVirtualMachineSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 certificates: Sequence['outputs.WindowsVirtualMachineSecretCertificate'],
                 key_vault_id: _builtins.str):
        """
        :param Sequence['WindowsVirtualMachineSecretCertificateArgs'] certificates: One or more `certificate` blocks as defined above.
        :param _builtins.str key_vault_id: The ID of the Key Vault from which all Secrets should be sourced.
        """
        pulumi.set(__self__, "certificates", certificates)
        pulumi.set(__self__, "key_vault_id", key_vault_id)

    @_builtins.property
    @pulumi.getter
    def certificates(self) -> Sequence['outputs.WindowsVirtualMachineSecretCertificate']:
        """
        One or more `certificate` blocks as defined above.
        """
        return pulumi.get(self, "certificates")

    @_builtins.property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> _builtins.str:
        """
        The ID of the Key Vault from which all Secrets should be sourced.
        """
        return pulumi.get(self, "key_vault_id")


@pulumi.output_type
class WindowsVirtualMachineSecretCertificate(dict):
    def __init__(__self__, *,
                 store: _builtins.str,
                 url: _builtins.str):
        """
        :param _builtins.str store: The certificate store on the Virtual Machine where the certificate should be added.
        :param _builtins.str url: The Secret URL of a Key Vault Certificate.
               
               > **NOTE:** This can be sourced from the `secret_id` field within the `keyvault.Certificate` Resource.
        """
        pulumi.set(__self__, "store", store)
        pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def store(self) -> _builtins.str:
        """
        The certificate store on the Virtual Machine where the certificate should be added.
        """
        return pulumi.get(self, "store")

    @_builtins.property
    @pulumi.getter
    def url(self) -> _builtins.str:
        """
        The Secret URL of a Key Vault Certificate.

        > **NOTE:** This can be sourced from the `secret_id` field within the `keyvault.Certificate` Resource.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class WindowsVirtualMachineSourceImageReference(dict):
    def __init__(__self__, *,
                 offer: _builtins.str,
                 publisher: _builtins.str,
                 sku: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str offer: Specifies the offer of the image used to create the virtual machines. Changing this forces a new resource to be created.
        :param _builtins.str publisher: Specifies the publisher of the image used to create the virtual machines. Changing this forces a new resource to be created.
        :param _builtins.str sku: Specifies the SKU of the image used to create the virtual machines. Changing this forces a new resource to be created.
        :param _builtins.str version: Specifies the version of the image used to create the virtual machines. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "offer", offer)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "sku", sku)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def offer(self) -> _builtins.str:
        """
        Specifies the offer of the image used to create the virtual machines. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "offer")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        """
        Specifies the publisher of the image used to create the virtual machines. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "publisher")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> _builtins.str:
        """
        Specifies the SKU of the image used to create the virtual machines. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        Specifies the version of the image used to create the virtual machines. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class WindowsVirtualMachineTerminationNotification(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 timeout: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Should the termination notification be enabled on this Virtual Machine?
        :param _builtins.str timeout: Length of time (in minutes, between `5` and `15`) a notification to be sent to the VM on the instance metadata server till the VM gets deleted. The time duration should be specified in ISO 8601 format. Defaults to `PT5M`.
               
               > **NOTE:** For more information about the termination notification, please [refer to this doc](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-terminate-notification).
        """
        pulumi.set(__self__, "enabled", enabled)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Should the termination notification be enabled on this Virtual Machine?
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.str]:
        """
        Length of time (in minutes, between `5` and `15`) a notification to be sent to the VM on the instance metadata server till the VM gets deleted. The time duration should be specified in ISO 8601 format. Defaults to `PT5M`.

        > **NOTE:** For more information about the termination notification, please [refer to this doc](https://docs.microsoft.com/azure/virtual-machine-scale-sets/virtual-machine-scale-sets-terminate-notification).
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class WindowsVirtualMachineWinrmListener(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "certificateUrl":
            suggest = "certificate_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WindowsVirtualMachineWinrmListener. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WindowsVirtualMachineWinrmListener.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WindowsVirtualMachineWinrmListener.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protocol: _builtins.str,
                 certificate_url: Optional[_builtins.str] = None):
        """
        :param _builtins.str protocol: Specifies the protocol of listener. Possible values are `Http` or `Https`. Changing this forces a new resource to be created.
        :param _builtins.str certificate_url: The Secret URL of a Key Vault Certificate, which must be specified when `protocol` is set to `Https`. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "protocol", protocol)
        if certificate_url is not None:
            pulumi.set(__self__, "certificate_url", certificate_url)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> _builtins.str:
        """
        Specifies the protocol of listener. Possible values are `Http` or `Https`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "protocol")

    @_builtins.property
    @pulumi.getter(name="certificateUrl")
    def certificate_url(self) -> Optional[_builtins.str]:
        """
        The Secret URL of a Key Vault Certificate, which must be specified when `protocol` is set to `Https`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "certificate_url")


@pulumi.output_type
class GetBastionHostIpConfigurationResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 public_ip_address_id: _builtins.str,
                 subnet_id: _builtins.str):
        """
        :param _builtins.str name: The name of the Bastion Host.
        :param _builtins.str public_ip_address_id: Reference to a Public IP Address associated to this Bastion Host.
        :param _builtins.str subnet_id: Reference to the subnet in which this Bastion Host has been created.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "public_ip_address_id", public_ip_address_id)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Bastion Host.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="publicIpAddressId")
    def public_ip_address_id(self) -> _builtins.str:
        """
        Reference to a Public IP Address associated to this Bastion Host.
        """
        return pulumi.get(self, "public_ip_address_id")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        Reference to the subnet in which this Bastion Host has been created.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetConfidentialLedgerAzureadBasedServicePrincipalResult(dict):
    def __init__(__self__, *,
                 ledger_role_name: _builtins.str,
                 principal_id: _builtins.str,
                 tenant_id: _builtins.str):
        """
        :param _builtins.str ledger_role_name: The Ledger Role to grant this Certificate Security Principal.
        :param _builtins.str principal_id: The Principal ID of the AzureAD Service Principal.
        :param _builtins.str tenant_id: The Tenant ID for this AzureAD Service Principal.
        """
        pulumi.set(__self__, "ledger_role_name", ledger_role_name)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter(name="ledgerRoleName")
    def ledger_role_name(self) -> _builtins.str:
        """
        The Ledger Role to grant this Certificate Security Principal.
        """
        return pulumi.get(self, "ledger_role_name")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        """
        The Principal ID of the AzureAD Service Principal.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        The Tenant ID for this AzureAD Service Principal.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class GetConfidentialLedgerCertificateBasedSecurityPrincipalResult(dict):
    def __init__(__self__, *,
                 ledger_role_name: _builtins.str,
                 pem_public_key: _builtins.str):
        """
        :param _builtins.str ledger_role_name: The Ledger Role to grant this Certificate Security Principal.
        :param _builtins.str pem_public_key: The public key, in PEM format, of the certificate used by this identity to authenticate with the Confidential Ledger.
        """
        pulumi.set(__self__, "ledger_role_name", ledger_role_name)
        pulumi.set(__self__, "pem_public_key", pem_public_key)

    @_builtins.property
    @pulumi.getter(name="ledgerRoleName")
    def ledger_role_name(self) -> _builtins.str:
        """
        The Ledger Role to grant this Certificate Security Principal.
        """
        return pulumi.get(self, "ledger_role_name")

    @_builtins.property
    @pulumi.getter(name="pemPublicKey")
    def pem_public_key(self) -> _builtins.str:
        """
        The public key, in PEM format, of the certificate used by this identity to authenticate with the Confidential Ledger.
        """
        return pulumi.get(self, "pem_public_key")


@pulumi.output_type
class GetDiskEncryptionSetIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[_builtins.str],
                 principal_id: _builtins.str,
                 tenant_id: _builtins.str,
                 type: _builtins.str):
        """
        :param Sequence[_builtins.str] identity_ids: A list of User Assigned Managed Identity IDs assigned to this Disk Encryption Set.
        :param _builtins.str principal_id: The (Client) ID of the Service Principal.
        :param _builtins.str tenant_id: The ID of the Tenant the Service Principal is assigned in.
        :param _builtins.str type: The type of Managed Service Identity that is configured on this Disk Encryption Set.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[_builtins.str]:
        """
        A list of User Assigned Managed Identity IDs assigned to this Disk Encryption Set.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        """
        The (Client) ID of the Service Principal.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        The ID of the Tenant the Service Principal is assigned in.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of Managed Service Identity that is configured on this Disk Encryption Set.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetImageDataDiskResult(dict):
    def __init__(__self__, *,
                 blob_uri: _builtins.str,
                 caching: _builtins.str,
                 lun: _builtins.int,
                 managed_disk_id: _builtins.str,
                 size_gb: _builtins.int):
        """
        :param _builtins.str blob_uri: the URI in Azure storage of the blob used to create the image.
        :param _builtins.str caching: the caching mode for the Data Disk, such as `ReadWrite`, `ReadOnly`, or `None`.
        :param _builtins.int lun: the logical unit number of the data disk.
        :param _builtins.str managed_disk_id: the ID of the Managed Disk used as the Data Disk Image.
        :param _builtins.int size_gb: the size of this Data Disk in GB.
        """
        pulumi.set(__self__, "blob_uri", blob_uri)
        pulumi.set(__self__, "caching", caching)
        pulumi.set(__self__, "lun", lun)
        pulumi.set(__self__, "managed_disk_id", managed_disk_id)
        pulumi.set(__self__, "size_gb", size_gb)

    @_builtins.property
    @pulumi.getter(name="blobUri")
    def blob_uri(self) -> _builtins.str:
        """
        the URI in Azure storage of the blob used to create the image.
        """
        return pulumi.get(self, "blob_uri")

    @_builtins.property
    @pulumi.getter
    def caching(self) -> _builtins.str:
        """
        the caching mode for the Data Disk, such as `ReadWrite`, `ReadOnly`, or `None`.
        """
        return pulumi.get(self, "caching")

    @_builtins.property
    @pulumi.getter
    def lun(self) -> _builtins.int:
        """
        the logical unit number of the data disk.
        """
        return pulumi.get(self, "lun")

    @_builtins.property
    @pulumi.getter(name="managedDiskId")
    def managed_disk_id(self) -> _builtins.str:
        """
        the ID of the Managed Disk used as the Data Disk Image.
        """
        return pulumi.get(self, "managed_disk_id")

    @_builtins.property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> _builtins.int:
        """
        the size of this Data Disk in GB.
        """
        return pulumi.get(self, "size_gb")


@pulumi.output_type
class GetImageOsDiskResult(dict):
    def __init__(__self__, *,
                 blob_uri: _builtins.str,
                 caching: _builtins.str,
                 managed_disk_id: _builtins.str,
                 os_state: _builtins.str,
                 os_type: _builtins.str,
                 size_gb: _builtins.int):
        """
        :param _builtins.str blob_uri: the URI in Azure storage of the blob used to create the image.
        :param _builtins.str caching: the caching mode for the Data Disk, such as `ReadWrite`, `ReadOnly`, or `None`.
        :param _builtins.str managed_disk_id: the ID of the Managed Disk used as the Data Disk Image.
        :param _builtins.str os_state: the State of the OS used in the Image, such as `Generalized`.
        :param _builtins.str os_type: the type of Operating System used on the OS Disk. such as `Linux` or `Windows`.
        :param _builtins.int size_gb: the size of this Data Disk in GB.
        """
        pulumi.set(__self__, "blob_uri", blob_uri)
        pulumi.set(__self__, "caching", caching)
        pulumi.set(__self__, "managed_disk_id", managed_disk_id)
        pulumi.set(__self__, "os_state", os_state)
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "size_gb", size_gb)

    @_builtins.property
    @pulumi.getter(name="blobUri")
    def blob_uri(self) -> _builtins.str:
        """
        the URI in Azure storage of the blob used to create the image.
        """
        return pulumi.get(self, "blob_uri")

    @_builtins.property
    @pulumi.getter
    def caching(self) -> _builtins.str:
        """
        the caching mode for the Data Disk, such as `ReadWrite`, `ReadOnly`, or `None`.
        """
        return pulumi.get(self, "caching")

    @_builtins.property
    @pulumi.getter(name="managedDiskId")
    def managed_disk_id(self) -> _builtins.str:
        """
        the ID of the Managed Disk used as the Data Disk Image.
        """
        return pulumi.get(self, "managed_disk_id")

    @_builtins.property
    @pulumi.getter(name="osState")
    def os_state(self) -> _builtins.str:
        """
        the State of the OS used in the Image, such as `Generalized`.
        """
        return pulumi.get(self, "os_state")

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> _builtins.str:
        """
        the type of Operating System used on the OS Disk. such as `Linux` or `Windows`.
        """
        return pulumi.get(self, "os_type")

    @_builtins.property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> _builtins.int:
        """
        the size of this Data Disk in GB.
        """
        return pulumi.get(self, "size_gb")


@pulumi.output_type
class GetImagesImageResult(dict):
    def __init__(__self__, *,
                 data_disks: Sequence['outputs.GetImagesImageDataDiskResult'],
                 location: _builtins.str,
                 name: _builtins.str,
                 os_disks: Sequence['outputs.GetImagesImageOsDiskResult'],
                 tags: Mapping[str, _builtins.str],
                 zone_resilient: _builtins.bool):
        """
        :param Sequence['GetImagesImageDataDiskArgs'] data_disks: One or more `data_disk` blocks as defined below.
        :param _builtins.str location: The supported Azure location where the Image exists.
        :param _builtins.str name: The name of the Image.
        :param Sequence['GetImagesImageOsDiskArgs'] os_disks: An `os_disk` block as defined below.
        :param Mapping[str, _builtins.str] tags: A mapping of tags assigned to the Image.
        :param _builtins.bool zone_resilient: Is zone resiliency enabled?
        """
        pulumi.set(__self__, "data_disks", data_disks)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "os_disks", os_disks)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "zone_resilient", zone_resilient)

    @_builtins.property
    @pulumi.getter(name="dataDisks")
    def data_disks(self) -> Sequence['outputs.GetImagesImageDataDiskResult']:
        """
        One or more `data_disk` blocks as defined below.
        """
        return pulumi.get(self, "data_disks")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The supported Azure location where the Image exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Image.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="osDisks")
    def os_disks(self) -> Sequence['outputs.GetImagesImageOsDiskResult']:
        """
        An `os_disk` block as defined below.
        """
        return pulumi.get(self, "os_disks")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the Image.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="zoneResilient")
    def zone_resilient(self) -> _builtins.bool:
        """
        Is zone resiliency enabled?
        """
        return pulumi.get(self, "zone_resilient")


@pulumi.output_type
class GetImagesImageDataDiskResult(dict):
    def __init__(__self__, *,
                 blob_uri: _builtins.str,
                 caching: _builtins.str,
                 lun: _builtins.int,
                 managed_disk_id: _builtins.str,
                 size_gb: _builtins.int):
        """
        :param _builtins.str blob_uri: the URI in Azure storage of the blob used to create the image.
        :param _builtins.str caching: the caching mode for the Data Disk.
        :param _builtins.int lun: the logical unit number of the data disk.
        :param _builtins.str managed_disk_id: the ID of the Managed Disk used as the Data Disk Image.
        :param _builtins.int size_gb: the size of this Data Disk in GB.
        """
        pulumi.set(__self__, "blob_uri", blob_uri)
        pulumi.set(__self__, "caching", caching)
        pulumi.set(__self__, "lun", lun)
        pulumi.set(__self__, "managed_disk_id", managed_disk_id)
        pulumi.set(__self__, "size_gb", size_gb)

    @_builtins.property
    @pulumi.getter(name="blobUri")
    def blob_uri(self) -> _builtins.str:
        """
        the URI in Azure storage of the blob used to create the image.
        """
        return pulumi.get(self, "blob_uri")

    @_builtins.property
    @pulumi.getter
    def caching(self) -> _builtins.str:
        """
        the caching mode for the Data Disk.
        """
        return pulumi.get(self, "caching")

    @_builtins.property
    @pulumi.getter
    def lun(self) -> _builtins.int:
        """
        the logical unit number of the data disk.
        """
        return pulumi.get(self, "lun")

    @_builtins.property
    @pulumi.getter(name="managedDiskId")
    def managed_disk_id(self) -> _builtins.str:
        """
        the ID of the Managed Disk used as the Data Disk Image.
        """
        return pulumi.get(self, "managed_disk_id")

    @_builtins.property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> _builtins.int:
        """
        the size of this Data Disk in GB.
        """
        return pulumi.get(self, "size_gb")


@pulumi.output_type
class GetImagesImageOsDiskResult(dict):
    def __init__(__self__, *,
                 blob_uri: _builtins.str,
                 caching: _builtins.str,
                 disk_encryption_set_id: _builtins.str,
                 managed_disk_id: _builtins.str,
                 os_state: _builtins.str,
                 os_type: _builtins.str,
                 size_gb: _builtins.int):
        """
        :param _builtins.str blob_uri: the URI in Azure storage of the blob used to create the image.
        :param _builtins.str caching: the caching mode for the Data Disk.
        :param _builtins.str disk_encryption_set_id: the ID of the Disk Encryption Set used to encrypt this image.
        :param _builtins.str managed_disk_id: the ID of the Managed Disk used as the Data Disk Image.
        :param _builtins.str os_state: the State of the OS used in the Image.
        :param _builtins.str os_type: the type of Operating System used on the OS Disk.
        :param _builtins.int size_gb: the size of this Data Disk in GB.
        """
        pulumi.set(__self__, "blob_uri", blob_uri)
        pulumi.set(__self__, "caching", caching)
        pulumi.set(__self__, "disk_encryption_set_id", disk_encryption_set_id)
        pulumi.set(__self__, "managed_disk_id", managed_disk_id)
        pulumi.set(__self__, "os_state", os_state)
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "size_gb", size_gb)

    @_builtins.property
    @pulumi.getter(name="blobUri")
    def blob_uri(self) -> _builtins.str:
        """
        the URI in Azure storage of the blob used to create the image.
        """
        return pulumi.get(self, "blob_uri")

    @_builtins.property
    @pulumi.getter
    def caching(self) -> _builtins.str:
        """
        the caching mode for the Data Disk.
        """
        return pulumi.get(self, "caching")

    @_builtins.property
    @pulumi.getter(name="diskEncryptionSetId")
    def disk_encryption_set_id(self) -> _builtins.str:
        """
        the ID of the Disk Encryption Set used to encrypt this image.
        """
        return pulumi.get(self, "disk_encryption_set_id")

    @_builtins.property
    @pulumi.getter(name="managedDiskId")
    def managed_disk_id(self) -> _builtins.str:
        """
        the ID of the Managed Disk used as the Data Disk Image.
        """
        return pulumi.get(self, "managed_disk_id")

    @_builtins.property
    @pulumi.getter(name="osState")
    def os_state(self) -> _builtins.str:
        """
        the State of the OS used in the Image.
        """
        return pulumi.get(self, "os_state")

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> _builtins.str:
        """
        the type of Operating System used on the OS Disk.
        """
        return pulumi.get(self, "os_type")

    @_builtins.property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> _builtins.int:
        """
        the size of this Data Disk in GB.
        """
        return pulumi.get(self, "size_gb")


@pulumi.output_type
class GetManagedDiskEncryptionSettingResult(dict):
    def __init__(__self__, *,
                 disk_encryption_keys: Sequence['outputs.GetManagedDiskEncryptionSettingDiskEncryptionKeyResult'],
                 enabled: _builtins.bool,
                 key_encryption_keys: Sequence['outputs.GetManagedDiskEncryptionSettingKeyEncryptionKeyResult']):
        """
        :param Sequence['GetManagedDiskEncryptionSettingDiskEncryptionKeyArgs'] disk_encryption_keys: A `disk_encryption_key` block as defined above.
        :param Sequence['GetManagedDiskEncryptionSettingKeyEncryptionKeyArgs'] key_encryption_keys: A `key_encryption_key` block as defined below.
        """
        pulumi.set(__self__, "disk_encryption_keys", disk_encryption_keys)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "key_encryption_keys", key_encryption_keys)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionKeys")
    def disk_encryption_keys(self) -> Sequence['outputs.GetManagedDiskEncryptionSettingDiskEncryptionKeyResult']:
        """
        A `disk_encryption_key` block as defined above.
        """
        return pulumi.get(self, "disk_encryption_keys")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="keyEncryptionKeys")
    def key_encryption_keys(self) -> Sequence['outputs.GetManagedDiskEncryptionSettingKeyEncryptionKeyResult']:
        """
        A `key_encryption_key` block as defined below.
        """
        return pulumi.get(self, "key_encryption_keys")


@pulumi.output_type
class GetManagedDiskEncryptionSettingDiskEncryptionKeyResult(dict):
    def __init__(__self__, *,
                 secret_url: _builtins.str,
                 source_vault_id: _builtins.str):
        """
        :param _builtins.str secret_url: The URL to the Key Vault Secret used as the Disk Encryption Key.
        :param _builtins.str source_vault_id: The ID of the source Key Vault.
        """
        pulumi.set(__self__, "secret_url", secret_url)
        pulumi.set(__self__, "source_vault_id", source_vault_id)

    @_builtins.property
    @pulumi.getter(name="secretUrl")
    def secret_url(self) -> _builtins.str:
        """
        The URL to the Key Vault Secret used as the Disk Encryption Key.
        """
        return pulumi.get(self, "secret_url")

    @_builtins.property
    @pulumi.getter(name="sourceVaultId")
    def source_vault_id(self) -> _builtins.str:
        """
        The ID of the source Key Vault.
        """
        return pulumi.get(self, "source_vault_id")


@pulumi.output_type
class GetManagedDiskEncryptionSettingKeyEncryptionKeyResult(dict):
    def __init__(__self__, *,
                 key_url: _builtins.str,
                 source_vault_id: _builtins.str):
        """
        :param _builtins.str key_url: The URL to the Key Vault Key used as the Key Encryption Key.
        :param _builtins.str source_vault_id: The ID of the source Key Vault.
        """
        pulumi.set(__self__, "key_url", key_url)
        pulumi.set(__self__, "source_vault_id", source_vault_id)

    @_builtins.property
    @pulumi.getter(name="keyUrl")
    def key_url(self) -> _builtins.str:
        """
        The URL to the Key Vault Key used as the Key Encryption Key.
        """
        return pulumi.get(self, "key_url")

    @_builtins.property
    @pulumi.getter(name="sourceVaultId")
    def source_vault_id(self) -> _builtins.str:
        """
        The ID of the source Key Vault.
        """
        return pulumi.get(self, "source_vault_id")


@pulumi.output_type
class GetOrchestratedVirtualMachineScaleSetIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[_builtins.str],
                 principal_id: _builtins.str,
                 tenant_id: _builtins.str,
                 type: _builtins.str):
        """
        :param Sequence[_builtins.str] identity_ids: The list of User Assigned Managed Identity IDs assigned to this Orchestrated Virtual Machine Scale Set.
        :param _builtins.str principal_id: The Principal ID of the System Assigned Managed Service Identity that is configured on this Orchestrated Virtual Machine Scale Set.
        :param _builtins.str tenant_id: The Tenant ID of the System Assigned Managed Service Identity that is configured on this Orchestrated Virtual Machine Scale Set.
        :param _builtins.str type: The Type of IP Tag.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[_builtins.str]:
        """
        The list of User Assigned Managed Identity IDs assigned to this Orchestrated Virtual Machine Scale Set.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        """
        The Principal ID of the System Assigned Managed Service Identity that is configured on this Orchestrated Virtual Machine Scale Set.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        The Tenant ID of the System Assigned Managed Service Identity that is configured on this Orchestrated Virtual Machine Scale Set.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The Type of IP Tag.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetOrchestratedVirtualMachineScaleSetNetworkInterfaceResult(dict):
    def __init__(__self__, *,
                 accelerated_networking_enabled: _builtins.bool,
                 dns_servers: Sequence[_builtins.str],
                 ip_configurations: Sequence['outputs.GetOrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationResult'],
                 ip_forwarding_enabled: _builtins.bool,
                 name: _builtins.str,
                 network_security_group_id: _builtins.str,
                 primary: _builtins.bool):
        """
        :param _builtins.bool accelerated_networking_enabled: Is accelerated networking enabled?
        :param Sequence[_builtins.str] dns_servers: An array of the DNS servers in use.
        :param Sequence['GetOrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationArgs'] ip_configurations: An `ip_configuration` block as documented below.
        :param _builtins.bool ip_forwarding_enabled: Is IP forwarding enabled?
        :param _builtins.str name: The name of this Orchestrated Virtual Machine Scale Set.
        :param _builtins.str network_security_group_id: The identifier for the network security group.
        :param _builtins.bool primary: If this ip_configuration is the primary one.
        """
        pulumi.set(__self__, "accelerated_networking_enabled", accelerated_networking_enabled)
        pulumi.set(__self__, "dns_servers", dns_servers)
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        pulumi.set(__self__, "ip_forwarding_enabled", ip_forwarding_enabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_security_group_id", network_security_group_id)
        pulumi.set(__self__, "primary", primary)

    @_builtins.property
    @pulumi.getter(name="acceleratedNetworkingEnabled")
    def accelerated_networking_enabled(self) -> _builtins.bool:
        """
        Is accelerated networking enabled?
        """
        return pulumi.get(self, "accelerated_networking_enabled")

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Sequence[_builtins.str]:
        """
        An array of the DNS servers in use.
        """
        return pulumi.get(self, "dns_servers")

    @_builtins.property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Sequence['outputs.GetOrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationResult']:
        """
        An `ip_configuration` block as documented below.
        """
        return pulumi.get(self, "ip_configurations")

    @_builtins.property
    @pulumi.getter(name="ipForwardingEnabled")
    def ip_forwarding_enabled(self) -> _builtins.bool:
        """
        Is IP forwarding enabled?
        """
        return pulumi.get(self, "ip_forwarding_enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of this Orchestrated Virtual Machine Scale Set.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupId")
    def network_security_group_id(self) -> _builtins.str:
        """
        The identifier for the network security group.
        """
        return pulumi.get(self, "network_security_group_id")

    @_builtins.property
    @pulumi.getter
    def primary(self) -> _builtins.bool:
        """
        If this ip_configuration is the primary one.
        """
        return pulumi.get(self, "primary")


@pulumi.output_type
class GetOrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationResult(dict):
    def __init__(__self__, *,
                 application_gateway_backend_address_pool_ids: Sequence[_builtins.str],
                 application_security_group_ids: Sequence[_builtins.str],
                 load_balancer_backend_address_pool_ids: Sequence[_builtins.str],
                 load_balancer_inbound_nat_rules_ids: Sequence[_builtins.str],
                 name: _builtins.str,
                 primary: _builtins.bool,
                 public_ip_addresses: Sequence['outputs.GetOrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressResult'],
                 subnet_id: _builtins.str,
                 version: _builtins.str):
        """
        :param Sequence[_builtins.str] application_gateway_backend_address_pool_ids: An array of references to backend address pools of application gateways.
        :param Sequence[_builtins.str] application_security_group_ids: The application security group IDs to use.
        :param Sequence[_builtins.str] load_balancer_backend_address_pool_ids: An array of references to backend address pools of load balancers.
        :param Sequence[_builtins.str] load_balancer_inbound_nat_rules_ids: An array of references to inbound NAT pools for load balancers.
        :param _builtins.str name: The name of this Orchestrated Virtual Machine Scale Set.
        :param _builtins.bool primary: If this ip_configuration is the primary one.
        :param Sequence['GetOrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressArgs'] public_ip_addresses: The virtual machines scale set IP Configuration's PublicIPAddress configuration. The `public_ip_address` is documented below.
        :param _builtins.str subnet_id: The identifier of the subnet.
        :param _builtins.str version: The Internet Protocol Version of the public IP address.
        """
        pulumi.set(__self__, "application_gateway_backend_address_pool_ids", application_gateway_backend_address_pool_ids)
        pulumi.set(__self__, "application_security_group_ids", application_security_group_ids)
        pulumi.set(__self__, "load_balancer_backend_address_pool_ids", load_balancer_backend_address_pool_ids)
        pulumi.set(__self__, "load_balancer_inbound_nat_rules_ids", load_balancer_inbound_nat_rules_ids)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "primary", primary)
        pulumi.set(__self__, "public_ip_addresses", public_ip_addresses)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="applicationGatewayBackendAddressPoolIds")
    def application_gateway_backend_address_pool_ids(self) -> Sequence[_builtins.str]:
        """
        An array of references to backend address pools of application gateways.
        """
        return pulumi.get(self, "application_gateway_backend_address_pool_ids")

    @_builtins.property
    @pulumi.getter(name="applicationSecurityGroupIds")
    def application_security_group_ids(self) -> Sequence[_builtins.str]:
        """
        The application security group IDs to use.
        """
        return pulumi.get(self, "application_security_group_ids")

    @_builtins.property
    @pulumi.getter(name="loadBalancerBackendAddressPoolIds")
    def load_balancer_backend_address_pool_ids(self) -> Sequence[_builtins.str]:
        """
        An array of references to backend address pools of load balancers.
        """
        return pulumi.get(self, "load_balancer_backend_address_pool_ids")

    @_builtins.property
    @pulumi.getter(name="loadBalancerInboundNatRulesIds")
    def load_balancer_inbound_nat_rules_ids(self) -> Sequence[_builtins.str]:
        """
        An array of references to inbound NAT pools for load balancers.
        """
        return pulumi.get(self, "load_balancer_inbound_nat_rules_ids")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of this Orchestrated Virtual Machine Scale Set.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def primary(self) -> _builtins.bool:
        """
        If this ip_configuration is the primary one.
        """
        return pulumi.get(self, "primary")

    @_builtins.property
    @pulumi.getter(name="publicIpAddresses")
    def public_ip_addresses(self) -> Sequence['outputs.GetOrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressResult']:
        """
        The virtual machines scale set IP Configuration's PublicIPAddress configuration. The `public_ip_address` is documented below.
        """
        return pulumi.get(self, "public_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The identifier of the subnet.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The Internet Protocol Version of the public IP address.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetOrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressResult(dict):
    def __init__(__self__, *,
                 domain_name_label: _builtins.str,
                 idle_timeout_in_minutes: _builtins.int,
                 ip_tags: Sequence['outputs.GetOrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagResult'],
                 name: _builtins.str,
                 public_ip_prefix_id: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str domain_name_label: The domain name label for the DNS settings.
        :param _builtins.int idle_timeout_in_minutes: The idle timeout in minutes.
        :param Sequence['GetOrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagArgs'] ip_tags: A list of `ip_tag` blocks as defined below.
        :param _builtins.str name: The name of this Orchestrated Virtual Machine Scale Set.
        :param _builtins.str public_ip_prefix_id: The ID of the public IP prefix.
        :param _builtins.str version: The Internet Protocol Version of the public IP address.
        """
        pulumi.set(__self__, "domain_name_label", domain_name_label)
        pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        pulumi.set(__self__, "ip_tags", ip_tags)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "public_ip_prefix_id", public_ip_prefix_id)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="domainNameLabel")
    def domain_name_label(self) -> _builtins.str:
        """
        The domain name label for the DNS settings.
        """
        return pulumi.get(self, "domain_name_label")

    @_builtins.property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> _builtins.int:
        """
        The idle timeout in minutes.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @_builtins.property
    @pulumi.getter(name="ipTags")
    def ip_tags(self) -> Sequence['outputs.GetOrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagResult']:
        """
        A list of `ip_tag` blocks as defined below.
        """
        return pulumi.get(self, "ip_tags")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of this Orchestrated Virtual Machine Scale Set.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="publicIpPrefixId")
    def public_ip_prefix_id(self) -> _builtins.str:
        """
        The ID of the public IP prefix.
        """
        return pulumi.get(self, "public_ip_prefix_id")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The Internet Protocol Version of the public IP address.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetOrchestratedVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagResult(dict):
    def __init__(__self__, *,
                 tag: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str tag: The IP Tag associated with the Public IP.
        :param _builtins.str type: The Type of IP Tag.
        """
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def tag(self) -> _builtins.str:
        """
        The IP Tag associated with the Public IP.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The Type of IP Tag.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetSharedImageIdentifierResult(dict):
    def __init__(__self__, *,
                 offer: _builtins.str,
                 publisher: _builtins.str,
                 sku: _builtins.str):
        """
        :param _builtins.str offer: The Offer Name for this Shared Image.
        :param _builtins.str publisher: (Optional) The Purchase Plan Publisher for this Gallery Image.
        :param _builtins.str sku: The Name of the SKU for this Gallery Image.
        """
        pulumi.set(__self__, "offer", offer)
        pulumi.set(__self__, "publisher", publisher)
        pulumi.set(__self__, "sku", sku)

    @_builtins.property
    @pulumi.getter
    def offer(self) -> _builtins.str:
        """
        The Offer Name for this Shared Image.
        """
        return pulumi.get(self, "offer")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        """
        (Optional) The Purchase Plan Publisher for this Gallery Image.
        """
        return pulumi.get(self, "publisher")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> _builtins.str:
        """
        The Name of the SKU for this Gallery Image.
        """
        return pulumi.get(self, "sku")


@pulumi.output_type
class GetSharedImagePurchasePlanResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 product: _builtins.str,
                 publisher: _builtins.str):
        """
        :param _builtins.str name: The name of the Shared Image.
        :param _builtins.str product: (Optional) The Purchase Plan Product for this Gallery Image.
        :param _builtins.str publisher: (Optional) The Purchase Plan Publisher for this Gallery Image.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "product", product)
        pulumi.set(__self__, "publisher", publisher)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Shared Image.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def product(self) -> _builtins.str:
        """
        (Optional) The Purchase Plan Product for this Gallery Image.
        """
        return pulumi.get(self, "product")

    @_builtins.property
    @pulumi.getter
    def publisher(self) -> _builtins.str:
        """
        (Optional) The Purchase Plan Publisher for this Gallery Image.
        """
        return pulumi.get(self, "publisher")


@pulumi.output_type
class GetSharedImageVersionTargetRegionResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 regional_replica_count: _builtins.int,
                 storage_account_type: _builtins.str):
        """
        :param _builtins.str name: The name of the Image Version.
               
               > **Note:** You may specify `latest` to obtain the latest version or `recent` to obtain the most recently updated version.
               
               > **Note:** In 3.0, `latest` may return an image version with `exclude_from_latest` set to `true`. Starting from 4.0 onwards `latest` will not return image versions with `exlude_from_latest` set to `true`.
        :param _builtins.int regional_replica_count: The number of replicas of the Image Version to be created per region.
        :param _builtins.str storage_account_type: The storage account type for the image version.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "regional_replica_count", regional_replica_count)
        pulumi.set(__self__, "storage_account_type", storage_account_type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Image Version.

        > **Note:** You may specify `latest` to obtain the latest version or `recent` to obtain the most recently updated version.

        > **Note:** In 3.0, `latest` may return an image version with `exclude_from_latest` set to `true`. Starting from 4.0 onwards `latest` will not return image versions with `exlude_from_latest` set to `true`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="regionalReplicaCount")
    def regional_replica_count(self) -> _builtins.int:
        """
        The number of replicas of the Image Version to be created per region.
        """
        return pulumi.get(self, "regional_replica_count")

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> _builtins.str:
        """
        The storage account type for the image version.
        """
        return pulumi.get(self, "storage_account_type")


@pulumi.output_type
class GetSharedImageVersionsImageResult(dict):
    def __init__(__self__, *,
                 exclude_from_latest: _builtins.bool,
                 id: _builtins.str,
                 location: _builtins.str,
                 managed_image_id: _builtins.str,
                 name: _builtins.str,
                 tags: Mapping[str, _builtins.str],
                 target_regions: Sequence['outputs.GetSharedImageVersionsImageTargetRegionResult']):
        """
        :param _builtins.bool exclude_from_latest: Is this Image Version excluded from the `latest` filter?
        :param _builtins.str id: The ID of this Shared Image Version.
        :param _builtins.str location: The supported Azure location where the Shared Image Gallery exists.
        :param _builtins.str managed_image_id: The ID of the Managed Image which was the source of this Shared Image Version.
        :param _builtins.str name: The Azure Region in which this Image Version exists.
        :param Mapping[str, _builtins.str] tags: A mapping of tags assigned to the Shared Image.
        :param Sequence['GetSharedImageVersionsImageTargetRegionArgs'] target_regions: One or more `target_region` blocks as documented below.
        """
        pulumi.set(__self__, "exclude_from_latest", exclude_from_latest)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "managed_image_id", managed_image_id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "target_regions", target_regions)

    @_builtins.property
    @pulumi.getter(name="excludeFromLatest")
    def exclude_from_latest(self) -> _builtins.bool:
        """
        Is this Image Version excluded from the `latest` filter?
        """
        return pulumi.get(self, "exclude_from_latest")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The ID of this Shared Image Version.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The supported Azure location where the Shared Image Gallery exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="managedImageId")
    def managed_image_id(self) -> _builtins.str:
        """
        The ID of the Managed Image which was the source of this Shared Image Version.
        """
        return pulumi.get(self, "managed_image_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The Azure Region in which this Image Version exists.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the Shared Image.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="targetRegions")
    def target_regions(self) -> Sequence['outputs.GetSharedImageVersionsImageTargetRegionResult']:
        """
        One or more `target_region` blocks as documented below.
        """
        return pulumi.get(self, "target_regions")


@pulumi.output_type
class GetSharedImageVersionsImageTargetRegionResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 regional_replica_count: _builtins.int,
                 storage_account_type: _builtins.str):
        """
        :param _builtins.str name: The Azure Region in which this Image Version exists.
        :param _builtins.int regional_replica_count: The number of replicas of the Image Version to be created per region.
        :param _builtins.str storage_account_type: The storage account type for the image version.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "regional_replica_count", regional_replica_count)
        pulumi.set(__self__, "storage_account_type", storage_account_type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The Azure Region in which this Image Version exists.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="regionalReplicaCount")
    def regional_replica_count(self) -> _builtins.int:
        """
        The number of replicas of the Image Version to be created per region.
        """
        return pulumi.get(self, "regional_replica_count")

    @_builtins.property
    @pulumi.getter(name="storageAccountType")
    def storage_account_type(self) -> _builtins.str:
        """
        The storage account type for the image version.
        """
        return pulumi.get(self, "storage_account_type")


@pulumi.output_type
class GetSnapshotEncryptionSettingResult(dict):
    def __init__(__self__, *,
                 disk_encryption_keys: Sequence['outputs.GetSnapshotEncryptionSettingDiskEncryptionKeyResult'],
                 enabled: _builtins.bool,
                 key_encryption_keys: Sequence['outputs.GetSnapshotEncryptionSettingKeyEncryptionKeyResult']):
        pulumi.set(__self__, "disk_encryption_keys", disk_encryption_keys)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "key_encryption_keys", key_encryption_keys)

    @_builtins.property
    @pulumi.getter(name="diskEncryptionKeys")
    def disk_encryption_keys(self) -> Sequence['outputs.GetSnapshotEncryptionSettingDiskEncryptionKeyResult']:
        return pulumi.get(self, "disk_encryption_keys")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="keyEncryptionKeys")
    def key_encryption_keys(self) -> Sequence['outputs.GetSnapshotEncryptionSettingKeyEncryptionKeyResult']:
        return pulumi.get(self, "key_encryption_keys")


@pulumi.output_type
class GetSnapshotEncryptionSettingDiskEncryptionKeyResult(dict):
    def __init__(__self__, *,
                 secret_url: _builtins.str,
                 source_vault_id: _builtins.str):
        pulumi.set(__self__, "secret_url", secret_url)
        pulumi.set(__self__, "source_vault_id", source_vault_id)

    @_builtins.property
    @pulumi.getter(name="secretUrl")
    def secret_url(self) -> _builtins.str:
        return pulumi.get(self, "secret_url")

    @_builtins.property
    @pulumi.getter(name="sourceVaultId")
    def source_vault_id(self) -> _builtins.str:
        return pulumi.get(self, "source_vault_id")


@pulumi.output_type
class GetSnapshotEncryptionSettingKeyEncryptionKeyResult(dict):
    def __init__(__self__, *,
                 key_url: _builtins.str,
                 source_vault_id: _builtins.str):
        pulumi.set(__self__, "key_url", key_url)
        pulumi.set(__self__, "source_vault_id", source_vault_id)

    @_builtins.property
    @pulumi.getter(name="keyUrl")
    def key_url(self) -> _builtins.str:
        return pulumi.get(self, "key_url")

    @_builtins.property
    @pulumi.getter(name="sourceVaultId")
    def source_vault_id(self) -> _builtins.str:
        return pulumi.get(self, "source_vault_id")


@pulumi.output_type
class GetVirtualMachineIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[_builtins.str],
                 principal_id: _builtins.str,
                 tenant_id: _builtins.str,
                 type: _builtins.str):
        """
        :param Sequence[_builtins.str] identity_ids: The list of User Managed Identity IDs which are assigned to the Virtual Machine.
        :param _builtins.str principal_id: The ID of the System Managed Service Principal assigned to the Virtual Machine.
        :param _builtins.str tenant_id: The ID of the Tenant of the System Managed Service Principal assigned to the Virtual Machine.
        :param _builtins.str type: The identity type of the Managed Identity assigned to the Virtual Machine.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[_builtins.str]:
        """
        The list of User Managed Identity IDs which are assigned to the Virtual Machine.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        """
        The ID of the System Managed Service Principal assigned to the Virtual Machine.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        The ID of the Tenant of the System Managed Service Principal assigned to the Virtual Machine.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The identity type of the Managed Identity assigned to the Virtual Machine.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetVirtualMachineScaleSetIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[_builtins.str],
                 principal_id: _builtins.str,
                 tenant_id: _builtins.str,
                 type: _builtins.str):
        """
        :param Sequence[_builtins.str] identity_ids: The list of User Assigned Managed Identity IDs assigned to this Virtual Machine Scale Set.
        :param _builtins.str principal_id: The Principal ID of the System Assigned Managed Service Identity that is configured on this Virtual Machine Scale Set.
        :param _builtins.str tenant_id: The Tenant ID of the System Assigned Managed Service Identity that is configured on this Virtual Machine Scale Set.
        :param _builtins.str type: The Type of IP Tag.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[_builtins.str]:
        """
        The list of User Assigned Managed Identity IDs assigned to this Virtual Machine Scale Set.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        """
        The Principal ID of the System Assigned Managed Service Identity that is configured on this Virtual Machine Scale Set.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        The Tenant ID of the System Assigned Managed Service Identity that is configured on this Virtual Machine Scale Set.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The Type of IP Tag.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetVirtualMachineScaleSetInstanceResult(dict):
    def __init__(__self__, *,
                 computer_name: _builtins.str,
                 instance_id: _builtins.str,
                 latest_model_applied: _builtins.bool,
                 name: _builtins.str,
                 power_state: _builtins.str,
                 private_ip_address: _builtins.str,
                 private_ip_addresses: Sequence[_builtins.str],
                 public_ip_address: _builtins.str,
                 public_ip_addresses: Sequence[_builtins.str],
                 virtual_machine_id: _builtins.str,
                 zone: _builtins.str):
        """
        :param _builtins.str computer_name: The Hostname of this Virtual Machine.
        :param _builtins.str instance_id: The Instance ID of this Virtual Machine.
        :param _builtins.bool latest_model_applied: Whether the latest model has been applied to this Virtual Machine.
        :param _builtins.str name: The name of this Virtual Machine Scale Set.
        :param _builtins.str power_state: The power state of the virtual machine.
        :param _builtins.str private_ip_address: The Primary Private IP Address assigned to this Virtual Machine.
        :param Sequence[_builtins.str] private_ip_addresses: A list of Private IP Addresses assigned to this Virtual Machine.
        :param _builtins.str public_ip_address: A `public_ip_address` block as defined below.
        :param Sequence[_builtins.str] public_ip_addresses: A list of the Public IP Addresses assigned to this Virtual Machine.
        :param _builtins.str virtual_machine_id: The unique ID of the virtual machine.
        :param _builtins.str zone: The zones of the virtual machine.
        """
        pulumi.set(__self__, "computer_name", computer_name)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "latest_model_applied", latest_model_applied)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "power_state", power_state)
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        pulumi.set(__self__, "private_ip_addresses", private_ip_addresses)
        pulumi.set(__self__, "public_ip_address", public_ip_address)
        pulumi.set(__self__, "public_ip_addresses", public_ip_addresses)
        pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="computerName")
    def computer_name(self) -> _builtins.str:
        """
        The Hostname of this Virtual Machine.
        """
        return pulumi.get(self, "computer_name")

    @_builtins.property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> _builtins.str:
        """
        The Instance ID of this Virtual Machine.
        """
        return pulumi.get(self, "instance_id")

    @_builtins.property
    @pulumi.getter(name="latestModelApplied")
    def latest_model_applied(self) -> _builtins.bool:
        """
        Whether the latest model has been applied to this Virtual Machine.
        """
        return pulumi.get(self, "latest_model_applied")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of this Virtual Machine Scale Set.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="powerState")
    def power_state(self) -> _builtins.str:
        """
        The power state of the virtual machine.
        """
        return pulumi.get(self, "power_state")

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> _builtins.str:
        """
        The Primary Private IP Address assigned to this Virtual Machine.
        """
        return pulumi.get(self, "private_ip_address")

    @_builtins.property
    @pulumi.getter(name="privateIpAddresses")
    def private_ip_addresses(self) -> Sequence[_builtins.str]:
        """
        A list of Private IP Addresses assigned to this Virtual Machine.
        """
        return pulumi.get(self, "private_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="publicIpAddress")
    def public_ip_address(self) -> _builtins.str:
        """
        A `public_ip_address` block as defined below.
        """
        return pulumi.get(self, "public_ip_address")

    @_builtins.property
    @pulumi.getter(name="publicIpAddresses")
    def public_ip_addresses(self) -> Sequence[_builtins.str]:
        """
        A list of the Public IP Addresses assigned to this Virtual Machine.
        """
        return pulumi.get(self, "public_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> _builtins.str:
        """
        The unique ID of the virtual machine.
        """
        return pulumi.get(self, "virtual_machine_id")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> _builtins.str:
        """
        The zones of the virtual machine.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetVirtualMachineScaleSetNetworkInterfaceResult(dict):
    def __init__(__self__, *,
                 auxiliary_mode: _builtins.str,
                 auxiliary_sku: _builtins.str,
                 dns_servers: Sequence[_builtins.str],
                 enable_accelerated_networking: _builtins.bool,
                 enable_ip_forwarding: _builtins.bool,
                 ip_configurations: Sequence['outputs.GetVirtualMachineScaleSetNetworkInterfaceIpConfigurationResult'],
                 name: _builtins.str,
                 network_security_group_id: _builtins.str,
                 primary: _builtins.bool):
        """
        :param _builtins.str auxiliary_mode: The auxiliary mode for the network interface.
        :param _builtins.str auxiliary_sku: The auxiliary SKU for the network interface.
        :param Sequence[_builtins.str] dns_servers: An array of the DNS servers in use.
        :param _builtins.bool enable_accelerated_networking: Whether accelerated networking is enabled.
        :param _builtins.bool enable_ip_forwarding: Whether IP forwarding is enabled on this NIC.
        :param Sequence['GetVirtualMachineScaleSetNetworkInterfaceIpConfigurationArgs'] ip_configurations: An `ip_configuration` block as defined below.
        :param _builtins.str name: The name of this Virtual Machine Scale Set.
        :param _builtins.str network_security_group_id: The identifier for the network security group.
        :param _builtins.bool primary: If this ip_configuration is the primary one.
        """
        pulumi.set(__self__, "auxiliary_mode", auxiliary_mode)
        pulumi.set(__self__, "auxiliary_sku", auxiliary_sku)
        pulumi.set(__self__, "dns_servers", dns_servers)
        pulumi.set(__self__, "enable_accelerated_networking", enable_accelerated_networking)
        pulumi.set(__self__, "enable_ip_forwarding", enable_ip_forwarding)
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_security_group_id", network_security_group_id)
        pulumi.set(__self__, "primary", primary)

    @_builtins.property
    @pulumi.getter(name="auxiliaryMode")
    def auxiliary_mode(self) -> _builtins.str:
        """
        The auxiliary mode for the network interface.
        """
        return pulumi.get(self, "auxiliary_mode")

    @_builtins.property
    @pulumi.getter(name="auxiliarySku")
    def auxiliary_sku(self) -> _builtins.str:
        """
        The auxiliary SKU for the network interface.
        """
        return pulumi.get(self, "auxiliary_sku")

    @_builtins.property
    @pulumi.getter(name="dnsServers")
    def dns_servers(self) -> Sequence[_builtins.str]:
        """
        An array of the DNS servers in use.
        """
        return pulumi.get(self, "dns_servers")

    @_builtins.property
    @pulumi.getter(name="enableAcceleratedNetworking")
    def enable_accelerated_networking(self) -> _builtins.bool:
        """
        Whether accelerated networking is enabled.
        """
        return pulumi.get(self, "enable_accelerated_networking")

    @_builtins.property
    @pulumi.getter(name="enableIpForwarding")
    def enable_ip_forwarding(self) -> _builtins.bool:
        """
        Whether IP forwarding is enabled on this NIC.
        """
        return pulumi.get(self, "enable_ip_forwarding")

    @_builtins.property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Sequence['outputs.GetVirtualMachineScaleSetNetworkInterfaceIpConfigurationResult']:
        """
        An `ip_configuration` block as defined below.
        """
        return pulumi.get(self, "ip_configurations")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of this Virtual Machine Scale Set.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkSecurityGroupId")
    def network_security_group_id(self) -> _builtins.str:
        """
        The identifier for the network security group.
        """
        return pulumi.get(self, "network_security_group_id")

    @_builtins.property
    @pulumi.getter
    def primary(self) -> _builtins.bool:
        """
        If this ip_configuration is the primary one.
        """
        return pulumi.get(self, "primary")


@pulumi.output_type
class GetVirtualMachineScaleSetNetworkInterfaceIpConfigurationResult(dict):
    def __init__(__self__, *,
                 application_gateway_backend_address_pool_ids: Sequence[_builtins.str],
                 application_security_group_ids: Sequence[_builtins.str],
                 load_balancer_backend_address_pool_ids: Sequence[_builtins.str],
                 load_balancer_inbound_nat_rules_ids: Sequence[_builtins.str],
                 name: _builtins.str,
                 primary: _builtins.bool,
                 public_ip_addresses: Sequence['outputs.GetVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressResult'],
                 subnet_id: _builtins.str,
                 version: _builtins.str):
        """
        :param Sequence[_builtins.str] application_gateway_backend_address_pool_ids: An array of references to backend address pools of application gateways.
        :param Sequence[_builtins.str] application_security_group_ids: The application security group IDs to use.
        :param Sequence[_builtins.str] load_balancer_backend_address_pool_ids: An array of references to backend address pools of load balancers.
        :param Sequence[_builtins.str] load_balancer_inbound_nat_rules_ids: An array of references to inbound NAT pools for load balancers.
        :param _builtins.str name: The name of this Virtual Machine Scale Set.
        :param _builtins.bool primary: If this ip_configuration is the primary one.
        :param Sequence['GetVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressArgs'] public_ip_addresses: A `public_ip_address` block as defined below.
        :param _builtins.str subnet_id: The identifier of the subnet.
        :param _builtins.str version: The Internet Protocol Version of the public IP address.
        """
        pulumi.set(__self__, "application_gateway_backend_address_pool_ids", application_gateway_backend_address_pool_ids)
        pulumi.set(__self__, "application_security_group_ids", application_security_group_ids)
        pulumi.set(__self__, "load_balancer_backend_address_pool_ids", load_balancer_backend_address_pool_ids)
        pulumi.set(__self__, "load_balancer_inbound_nat_rules_ids", load_balancer_inbound_nat_rules_ids)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "primary", primary)
        pulumi.set(__self__, "public_ip_addresses", public_ip_addresses)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="applicationGatewayBackendAddressPoolIds")
    def application_gateway_backend_address_pool_ids(self) -> Sequence[_builtins.str]:
        """
        An array of references to backend address pools of application gateways.
        """
        return pulumi.get(self, "application_gateway_backend_address_pool_ids")

    @_builtins.property
    @pulumi.getter(name="applicationSecurityGroupIds")
    def application_security_group_ids(self) -> Sequence[_builtins.str]:
        """
        The application security group IDs to use.
        """
        return pulumi.get(self, "application_security_group_ids")

    @_builtins.property
    @pulumi.getter(name="loadBalancerBackendAddressPoolIds")
    def load_balancer_backend_address_pool_ids(self) -> Sequence[_builtins.str]:
        """
        An array of references to backend address pools of load balancers.
        """
        return pulumi.get(self, "load_balancer_backend_address_pool_ids")

    @_builtins.property
    @pulumi.getter(name="loadBalancerInboundNatRulesIds")
    def load_balancer_inbound_nat_rules_ids(self) -> Sequence[_builtins.str]:
        """
        An array of references to inbound NAT pools for load balancers.
        """
        return pulumi.get(self, "load_balancer_inbound_nat_rules_ids")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of this Virtual Machine Scale Set.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def primary(self) -> _builtins.bool:
        """
        If this ip_configuration is the primary one.
        """
        return pulumi.get(self, "primary")

    @_builtins.property
    @pulumi.getter(name="publicIpAddresses")
    def public_ip_addresses(self) -> Sequence['outputs.GetVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressResult']:
        """
        A `public_ip_address` block as defined below.
        """
        return pulumi.get(self, "public_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The identifier of the subnet.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The Internet Protocol Version of the public IP address.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressResult(dict):
    def __init__(__self__, *,
                 domain_name_label: _builtins.str,
                 idle_timeout_in_minutes: _builtins.int,
                 ip_tags: Sequence['outputs.GetVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagResult'],
                 name: _builtins.str,
                 public_ip_prefix_id: _builtins.str,
                 version: _builtins.str):
        """
        :param _builtins.str domain_name_label: The domain name label for the DNS settings.
        :param _builtins.int idle_timeout_in_minutes: The idle timeout in minutes.
        :param Sequence['GetVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagArgs'] ip_tags: A list of `ip_tag` blocks as defined below.
        :param _builtins.str name: The name of this Virtual Machine Scale Set.
        :param _builtins.str public_ip_prefix_id: The ID of the public IP prefix.
        :param _builtins.str version: The Internet Protocol Version of the public IP address.
        """
        pulumi.set(__self__, "domain_name_label", domain_name_label)
        pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        pulumi.set(__self__, "ip_tags", ip_tags)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "public_ip_prefix_id", public_ip_prefix_id)
        pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter(name="domainNameLabel")
    def domain_name_label(self) -> _builtins.str:
        """
        The domain name label for the DNS settings.
        """
        return pulumi.get(self, "domain_name_label")

    @_builtins.property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> _builtins.int:
        """
        The idle timeout in minutes.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @_builtins.property
    @pulumi.getter(name="ipTags")
    def ip_tags(self) -> Sequence['outputs.GetVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagResult']:
        """
        A list of `ip_tag` blocks as defined below.
        """
        return pulumi.get(self, "ip_tags")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of this Virtual Machine Scale Set.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="publicIpPrefixId")
    def public_ip_prefix_id(self) -> _builtins.str:
        """
        The ID of the public IP prefix.
        """
        return pulumi.get(self, "public_ip_prefix_id")

    @_builtins.property
    @pulumi.getter
    def version(self) -> _builtins.str:
        """
        The Internet Protocol Version of the public IP address.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetVirtualMachineScaleSetNetworkInterfaceIpConfigurationPublicIpAddressIpTagResult(dict):
    def __init__(__self__, *,
                 tag: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str tag: The IP Tag associated with the Public IP.
        :param _builtins.str type: The Type of IP Tag.
        """
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def tag(self) -> _builtins.str:
        """
        The IP Tag associated with the Public IP.
        """
        return pulumi.get(self, "tag")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The Type of IP Tag.
        """
        return pulumi.get(self, "type")


