# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['PacketCaptureArgs', 'PacketCapture']

@pulumi.input_type
class PacketCaptureArgs:
    def __init__(__self__, *,
                 network_watcher_id: pulumi.Input[_builtins.str],
                 storage_location: pulumi.Input['PacketCaptureStorageLocationArgs'],
                 virtual_machine_id: pulumi.Input[_builtins.str],
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input['PacketCaptureFilterArgs']]]] = None,
                 maximum_bytes_per_packet: Optional[pulumi.Input[_builtins.int]] = None,
                 maximum_bytes_per_session: Optional[pulumi.Input[_builtins.int]] = None,
                 maximum_capture_duration_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a PacketCapture resource.
        :param pulumi.Input[_builtins.str] network_watcher_id: The resource ID of the Network Watcher. Changing this forces a new resource to be created.
        :param pulumi.Input['PacketCaptureStorageLocationArgs'] storage_location: A `storage_location` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_machine_id: The resource ID of the target Virtual Machine to capture packets from. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['PacketCaptureFilterArgs']]] filters: One or more `filter` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] maximum_bytes_per_packet: The number of bytes captured per packet. The remaining bytes are truncated. Defaults to `0` (Entire Packet Captured). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] maximum_bytes_per_session: Maximum size of the capture in Bytes. Defaults to `1073741824` (1GB). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] maximum_capture_duration_in_seconds: The maximum duration of the capture session in seconds. Defaults to `18000` (5 hours). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name to use for this Network Packet Capture. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "network_watcher_id", network_watcher_id)
        pulumi.set(__self__, "storage_location", storage_location)
        pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if maximum_bytes_per_packet is not None:
            pulumi.set(__self__, "maximum_bytes_per_packet", maximum_bytes_per_packet)
        if maximum_bytes_per_session is not None:
            pulumi.set(__self__, "maximum_bytes_per_session", maximum_bytes_per_session)
        if maximum_capture_duration_in_seconds is not None:
            pulumi.set(__self__, "maximum_capture_duration_in_seconds", maximum_capture_duration_in_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="networkWatcherId")
    def network_watcher_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource ID of the Network Watcher. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network_watcher_id")

    @network_watcher_id.setter
    def network_watcher_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "network_watcher_id", value)

    @_builtins.property
    @pulumi.getter(name="storageLocation")
    def storage_location(self) -> pulumi.Input['PacketCaptureStorageLocationArgs']:
        """
        A `storage_location` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_location")

    @storage_location.setter
    def storage_location(self, value: pulumi.Input['PacketCaptureStorageLocationArgs']):
        pulumi.set(self, "storage_location", value)

    @_builtins.property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource ID of the target Virtual Machine to capture packets from. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "virtual_machine_id", value)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PacketCaptureFilterArgs']]]]:
        """
        One or more `filter` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PacketCaptureFilterArgs']]]]):
        pulumi.set(self, "filters", value)

    @_builtins.property
    @pulumi.getter(name="maximumBytesPerPacket")
    def maximum_bytes_per_packet(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of bytes captured per packet. The remaining bytes are truncated. Defaults to `0` (Entire Packet Captured). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "maximum_bytes_per_packet")

    @maximum_bytes_per_packet.setter
    def maximum_bytes_per_packet(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_bytes_per_packet", value)

    @_builtins.property
    @pulumi.getter(name="maximumBytesPerSession")
    def maximum_bytes_per_session(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum size of the capture in Bytes. Defaults to `1073741824` (1GB). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "maximum_bytes_per_session")

    @maximum_bytes_per_session.setter
    def maximum_bytes_per_session(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_bytes_per_session", value)

    @_builtins.property
    @pulumi.getter(name="maximumCaptureDurationInSeconds")
    def maximum_capture_duration_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum duration of the capture session in seconds. Defaults to `18000` (5 hours). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "maximum_capture_duration_in_seconds")

    @maximum_capture_duration_in_seconds.setter
    def maximum_capture_duration_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_capture_duration_in_seconds", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name to use for this Network Packet Capture. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _PacketCaptureState:
    def __init__(__self__, *,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input['PacketCaptureFilterArgs']]]] = None,
                 maximum_bytes_per_packet: Optional[pulumi.Input[_builtins.int]] = None,
                 maximum_bytes_per_session: Optional[pulumi.Input[_builtins.int]] = None,
                 maximum_capture_duration_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_watcher_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_location: Optional[pulumi.Input['PacketCaptureStorageLocationArgs']] = None,
                 virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering PacketCapture resources.
        :param pulumi.Input[Sequence[pulumi.Input['PacketCaptureFilterArgs']]] filters: One or more `filter` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] maximum_bytes_per_packet: The number of bytes captured per packet. The remaining bytes are truncated. Defaults to `0` (Entire Packet Captured). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] maximum_bytes_per_session: Maximum size of the capture in Bytes. Defaults to `1073741824` (1GB). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] maximum_capture_duration_in_seconds: The maximum duration of the capture session in seconds. Defaults to `18000` (5 hours). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name to use for this Network Packet Capture. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] network_watcher_id: The resource ID of the Network Watcher. Changing this forces a new resource to be created.
        :param pulumi.Input['PacketCaptureStorageLocationArgs'] storage_location: A `storage_location` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_machine_id: The resource ID of the target Virtual Machine to capture packets from. Changing this forces a new resource to be created.
        """
        if filters is not None:
            pulumi.set(__self__, "filters", filters)
        if maximum_bytes_per_packet is not None:
            pulumi.set(__self__, "maximum_bytes_per_packet", maximum_bytes_per_packet)
        if maximum_bytes_per_session is not None:
            pulumi.set(__self__, "maximum_bytes_per_session", maximum_bytes_per_session)
        if maximum_capture_duration_in_seconds is not None:
            pulumi.set(__self__, "maximum_capture_duration_in_seconds", maximum_capture_duration_in_seconds)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if network_watcher_id is not None:
            pulumi.set(__self__, "network_watcher_id", network_watcher_id)
        if storage_location is not None:
            pulumi.set(__self__, "storage_location", storage_location)
        if virtual_machine_id is not None:
            pulumi.set(__self__, "virtual_machine_id", virtual_machine_id)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['PacketCaptureFilterArgs']]]]:
        """
        One or more `filter` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "filters")

    @filters.setter
    def filters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['PacketCaptureFilterArgs']]]]):
        pulumi.set(self, "filters", value)

    @_builtins.property
    @pulumi.getter(name="maximumBytesPerPacket")
    def maximum_bytes_per_packet(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of bytes captured per packet. The remaining bytes are truncated. Defaults to `0` (Entire Packet Captured). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "maximum_bytes_per_packet")

    @maximum_bytes_per_packet.setter
    def maximum_bytes_per_packet(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_bytes_per_packet", value)

    @_builtins.property
    @pulumi.getter(name="maximumBytesPerSession")
    def maximum_bytes_per_session(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum size of the capture in Bytes. Defaults to `1073741824` (1GB). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "maximum_bytes_per_session")

    @maximum_bytes_per_session.setter
    def maximum_bytes_per_session(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_bytes_per_session", value)

    @_builtins.property
    @pulumi.getter(name="maximumCaptureDurationInSeconds")
    def maximum_capture_duration_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum duration of the capture session in seconds. Defaults to `18000` (5 hours). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "maximum_capture_duration_in_seconds")

    @maximum_capture_duration_in_seconds.setter
    def maximum_capture_duration_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_capture_duration_in_seconds", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name to use for this Network Packet Capture. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="networkWatcherId")
    def network_watcher_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the Network Watcher. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network_watcher_id")

    @network_watcher_id.setter
    def network_watcher_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "network_watcher_id", value)

    @_builtins.property
    @pulumi.getter(name="storageLocation")
    def storage_location(self) -> Optional[pulumi.Input['PacketCaptureStorageLocationArgs']]:
        """
        A `storage_location` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_location")

    @storage_location.setter
    def storage_location(self, value: Optional[pulumi.Input['PacketCaptureStorageLocationArgs']]):
        pulumi.set(self, "storage_location", value)

    @_builtins.property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the target Virtual Machine to capture packets from. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_machine_id")

    @virtual_machine_id.setter
    def virtual_machine_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_machine_id", value)


@pulumi.type_token("azure:compute/packetCapture:PacketCapture")
class PacketCapture(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PacketCaptureFilterArgs', 'PacketCaptureFilterArgsDict']]]]] = None,
                 maximum_bytes_per_packet: Optional[pulumi.Input[_builtins.int]] = None,
                 maximum_bytes_per_session: Optional[pulumi.Input[_builtins.int]] = None,
                 maximum_capture_duration_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_watcher_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_location: Optional[pulumi.Input[Union['PacketCaptureStorageLocationArgs', 'PacketCaptureStorageLocationArgsDict']]] = None,
                 virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Configures Network Packet Capturing against a Virtual Machine using a Network Watcher.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_network_watcher = azure.network.NetworkWatcher("example",
            name="example-nw",
            location=example.location,
            resource_group_name=example.name)
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="example-nic",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "testconfiguration1",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_virtual_machine = azure.compute.VirtualMachine("example",
            name="example-vm",
            location=example.location,
            resource_group_name=example.name,
            network_interface_ids=[example_network_interface.id],
            vm_size="Standard_F2",
            storage_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            },
            storage_os_disk={
                "name": "osdisk",
                "caching": "ReadWrite",
                "create_option": "FromImage",
                "managed_disk_type": "Standard_LRS",
            },
            os_profile={
                "computer_name": "pctest-vm",
                "admin_username": "testadmin",
                "admin_password": "Password1234!",
            },
            os_profile_linux_config={
                "disable_password_authentication": False,
            })
        example_extension = azure.compute.Extension("example",
            name="network-watcher",
            virtual_machine_id=example_virtual_machine.id,
            publisher="Microsoft.Azure.NetworkWatcher",
            type="NetworkWatcherAgentLinux",
            type_handler_version="1.4",
            auto_upgrade_minor_version=True)
        example_account = azure.storage.Account("example",
            name="examplesa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_packet_capture = azure.compute.PacketCapture("example",
            name="example-pc",
            network_watcher_id=example_network_watcher.id,
            virtual_machine_id=example_virtual_machine.id,
            storage_location={
                "storage_account_id": example_account.id,
            },
            opts = pulumi.ResourceOptions(depends_on=[example_extension]))
        ```

        > **Note:** This Resource requires that [the Network Watcher Virtual Machine Extension](https://docs.microsoft.com/azure/network-watcher/network-watcher-packet-capture-manage-portal#before-you-begin) is installed on the Virtual Machine before capturing can be enabled which can be installed via the `compute.Extension` resource.

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2024-05-01

        ## Import

        Virtual Machine Packet Captures can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/packetCapture:PacketCapture capture1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/networkWatchers/watcher1/packetCaptures/capture1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PacketCaptureFilterArgs', 'PacketCaptureFilterArgsDict']]]] filters: One or more `filter` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] maximum_bytes_per_packet: The number of bytes captured per packet. The remaining bytes are truncated. Defaults to `0` (Entire Packet Captured). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] maximum_bytes_per_session: Maximum size of the capture in Bytes. Defaults to `1073741824` (1GB). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] maximum_capture_duration_in_seconds: The maximum duration of the capture session in seconds. Defaults to `18000` (5 hours). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name to use for this Network Packet Capture. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] network_watcher_id: The resource ID of the Network Watcher. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['PacketCaptureStorageLocationArgs', 'PacketCaptureStorageLocationArgsDict']] storage_location: A `storage_location` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_machine_id: The resource ID of the target Virtual Machine to capture packets from. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PacketCaptureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Configures Network Packet Capturing against a Virtual Machine using a Network Watcher.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_network_watcher = azure.network.NetworkWatcher("example",
            name="example-nw",
            location=example.location,
            resource_group_name=example.name)
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-network",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="internal",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="example-nic",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "testconfiguration1",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_virtual_machine = azure.compute.VirtualMachine("example",
            name="example-vm",
            location=example.location,
            resource_group_name=example.name,
            network_interface_ids=[example_network_interface.id],
            vm_size="Standard_F2",
            storage_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            },
            storage_os_disk={
                "name": "osdisk",
                "caching": "ReadWrite",
                "create_option": "FromImage",
                "managed_disk_type": "Standard_LRS",
            },
            os_profile={
                "computer_name": "pctest-vm",
                "admin_username": "testadmin",
                "admin_password": "Password1234!",
            },
            os_profile_linux_config={
                "disable_password_authentication": False,
            })
        example_extension = azure.compute.Extension("example",
            name="network-watcher",
            virtual_machine_id=example_virtual_machine.id,
            publisher="Microsoft.Azure.NetworkWatcher",
            type="NetworkWatcherAgentLinux",
            type_handler_version="1.4",
            auto_upgrade_minor_version=True)
        example_account = azure.storage.Account("example",
            name="examplesa",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_packet_capture = azure.compute.PacketCapture("example",
            name="example-pc",
            network_watcher_id=example_network_watcher.id,
            virtual_machine_id=example_virtual_machine.id,
            storage_location={
                "storage_account_id": example_account.id,
            },
            opts = pulumi.ResourceOptions(depends_on=[example_extension]))
        ```

        > **Note:** This Resource requires that [the Network Watcher Virtual Machine Extension](https://docs.microsoft.com/azure/network-watcher/network-watcher-packet-capture-manage-portal#before-you-begin) is installed on the Virtual Machine before capturing can be enabled which can be installed via the `compute.Extension` resource.

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2024-05-01

        ## Import

        Virtual Machine Packet Captures can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/packetCapture:PacketCapture capture1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Network/networkWatchers/watcher1/packetCaptures/capture1
        ```

        :param str resource_name: The name of the resource.
        :param PacketCaptureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PacketCaptureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PacketCaptureFilterArgs', 'PacketCaptureFilterArgsDict']]]]] = None,
                 maximum_bytes_per_packet: Optional[pulumi.Input[_builtins.int]] = None,
                 maximum_bytes_per_session: Optional[pulumi.Input[_builtins.int]] = None,
                 maximum_capture_duration_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 network_watcher_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_location: Optional[pulumi.Input[Union['PacketCaptureStorageLocationArgs', 'PacketCaptureStorageLocationArgsDict']]] = None,
                 virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PacketCaptureArgs.__new__(PacketCaptureArgs)

            __props__.__dict__["filters"] = filters
            __props__.__dict__["maximum_bytes_per_packet"] = maximum_bytes_per_packet
            __props__.__dict__["maximum_bytes_per_session"] = maximum_bytes_per_session
            __props__.__dict__["maximum_capture_duration_in_seconds"] = maximum_capture_duration_in_seconds
            __props__.__dict__["name"] = name
            if network_watcher_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_watcher_id'")
            __props__.__dict__["network_watcher_id"] = network_watcher_id
            if storage_location is None and not opts.urn:
                raise TypeError("Missing required property 'storage_location'")
            __props__.__dict__["storage_location"] = storage_location
            if virtual_machine_id is None and not opts.urn:
                raise TypeError("Missing required property 'virtual_machine_id'")
            __props__.__dict__["virtual_machine_id"] = virtual_machine_id
        super(PacketCapture, __self__).__init__(
            'azure:compute/packetCapture:PacketCapture',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            filters: Optional[pulumi.Input[Sequence[pulumi.Input[Union['PacketCaptureFilterArgs', 'PacketCaptureFilterArgsDict']]]]] = None,
            maximum_bytes_per_packet: Optional[pulumi.Input[_builtins.int]] = None,
            maximum_bytes_per_session: Optional[pulumi.Input[_builtins.int]] = None,
            maximum_capture_duration_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            network_watcher_id: Optional[pulumi.Input[_builtins.str]] = None,
            storage_location: Optional[pulumi.Input[Union['PacketCaptureStorageLocationArgs', 'PacketCaptureStorageLocationArgsDict']]] = None,
            virtual_machine_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'PacketCapture':
        """
        Get an existing PacketCapture resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['PacketCaptureFilterArgs', 'PacketCaptureFilterArgsDict']]]] filters: One or more `filter` blocks as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] maximum_bytes_per_packet: The number of bytes captured per packet. The remaining bytes are truncated. Defaults to `0` (Entire Packet Captured). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] maximum_bytes_per_session: Maximum size of the capture in Bytes. Defaults to `1073741824` (1GB). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] maximum_capture_duration_in_seconds: The maximum duration of the capture session in seconds. Defaults to `18000` (5 hours). Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name to use for this Network Packet Capture. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] network_watcher_id: The resource ID of the Network Watcher. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['PacketCaptureStorageLocationArgs', 'PacketCaptureStorageLocationArgsDict']] storage_location: A `storage_location` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] virtual_machine_id: The resource ID of the target Virtual Machine to capture packets from. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PacketCaptureState.__new__(_PacketCaptureState)

        __props__.__dict__["filters"] = filters
        __props__.__dict__["maximum_bytes_per_packet"] = maximum_bytes_per_packet
        __props__.__dict__["maximum_bytes_per_session"] = maximum_bytes_per_session
        __props__.__dict__["maximum_capture_duration_in_seconds"] = maximum_capture_duration_in_seconds
        __props__.__dict__["name"] = name
        __props__.__dict__["network_watcher_id"] = network_watcher_id
        __props__.__dict__["storage_location"] = storage_location
        __props__.__dict__["virtual_machine_id"] = virtual_machine_id
        return PacketCapture(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def filters(self) -> pulumi.Output[Optional[Sequence['outputs.PacketCaptureFilter']]]:
        """
        One or more `filter` blocks as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "filters")

    @_builtins.property
    @pulumi.getter(name="maximumBytesPerPacket")
    def maximum_bytes_per_packet(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of bytes captured per packet. The remaining bytes are truncated. Defaults to `0` (Entire Packet Captured). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "maximum_bytes_per_packet")

    @_builtins.property
    @pulumi.getter(name="maximumBytesPerSession")
    def maximum_bytes_per_session(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Maximum size of the capture in Bytes. Defaults to `1073741824` (1GB). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "maximum_bytes_per_session")

    @_builtins.property
    @pulumi.getter(name="maximumCaptureDurationInSeconds")
    def maximum_capture_duration_in_seconds(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The maximum duration of the capture session in seconds. Defaults to `18000` (5 hours). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "maximum_capture_duration_in_seconds")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name to use for this Network Packet Capture. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkWatcherId")
    def network_watcher_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource ID of the Network Watcher. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "network_watcher_id")

    @_builtins.property
    @pulumi.getter(name="storageLocation")
    def storage_location(self) -> pulumi.Output['outputs.PacketCaptureStorageLocation']:
        """
        A `storage_location` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_location")

    @_builtins.property
    @pulumi.getter(name="virtualMachineId")
    def virtual_machine_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource ID of the target Virtual Machine to capture packets from. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "virtual_machine_id")

