# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SharedImageArgs', 'SharedImage']

@pulumi.input_type
class SharedImageArgs:
    def __init__(__self__, *,
                 gallery_name: pulumi.Input[_builtins.str],
                 identifier: pulumi.Input['SharedImageIdentifierArgs'],
                 os_type: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 accelerated_network_support_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 confidential_vm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 confidential_vm_supported: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_controller_type_nvme_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 disk_types_not_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 end_of_life_date: Optional[pulumi.Input[_builtins.str]] = None,
                 eula: Optional[pulumi.Input[_builtins.str]] = None,
                 hibernation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hyper_v_generation: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 max_recommended_memory_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 max_recommended_vcpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 min_recommended_memory_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 min_recommended_vcpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 privacy_statement_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 purchase_plan: Optional[pulumi.Input['SharedImagePurchasePlanArgs']] = None,
                 release_note_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 specialized: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 trusted_launch_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 trusted_launch_supported: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a SharedImage resource.
        :param pulumi.Input[_builtins.str] gallery_name: Specifies the name of the Shared Image Gallery in which this Shared Image should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['SharedImageIdentifierArgs'] identifier: An `identifier` block as defined below.
        :param pulumi.Input[_builtins.str] os_type: The type of Operating System present in this Shared Image. Possible values are `Linux` and `Windows`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Shared Image Gallery exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] accelerated_network_support_enabled: Specifies if the Shared Image supports Accelerated Network. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] architecture: CPU architecture supported by an OS. Possible values are `x64` and `Arm64`. Defaults to `x64`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] confidential_vm_enabled: Specifies if Confidential Virtual Machines enabled. It will enable all the features of trusted, with higher confidentiality features for isolate machines or encrypted data. Available for Gen2 machines. Changing this forces a new resource to be created.
               
               > **Note:** Only one of `trusted_launch_supported`, `trusted_launch_enabled`, `confidential_vm_supported` and `confidential_vm_enabled` can be specified.
        :param pulumi.Input[_builtins.bool] confidential_vm_supported: Specifies if supports creation of both Confidential virtual machines and Gen2 virtual machines with standard security from a compatible Gen2 OS disk VHD or Gen2 Managed image. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: A description of this Shared Image.
        :param pulumi.Input[_builtins.bool] disk_controller_type_nvme_enabled: Specifies if the Shared Image supports NVMe disks. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disk_types_not_alloweds: One or more Disk Types not allowed for the Image. Possible values include `Standard_LRS` and `Premium_LRS`.
        :param pulumi.Input[_builtins.str] end_of_life_date: The end of life date in RFC3339 format of the Image.
        :param pulumi.Input[_builtins.str] eula: The End User Licence Agreement for the Shared Image. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] hibernation_enabled: Specifies if the Shared Image supports hibernation. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] hyper_v_generation: The generation of HyperV that the Virtual Machine used to create the Shared Image is based on. Possible values are `V1` and `V2`. Defaults to `V1`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the Shared Image Gallery exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] max_recommended_memory_in_gb: Maximum memory in GB recommended for the Image.
        :param pulumi.Input[_builtins.int] max_recommended_vcpu_count: Maximum count of vCPUs recommended for the Image.
        :param pulumi.Input[_builtins.int] min_recommended_memory_in_gb: Minimum memory in GB recommended for the Image.
        :param pulumi.Input[_builtins.int] min_recommended_vcpu_count: Minimum count of vCPUs recommended for the Image.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Shared Image. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] privacy_statement_uri: The URI containing the Privacy Statement associated with this Shared Image. Changing this forces a new resource to be created.
        :param pulumi.Input['SharedImagePurchasePlanArgs'] purchase_plan: A `purchase_plan` block as defined below.
        :param pulumi.Input[_builtins.str] release_note_uri: The URI containing the Release Notes associated with this Shared Image.
        :param pulumi.Input[_builtins.bool] specialized: Specifies that the Operating System used inside this Image has not been Generalized (for example, `sysprep` on Windows has not been run). Changing this forces a new resource to be created.
               
               !> **Note:** It's recommended to Generalize images where possible - Specialized Images reuse the same UUID internally within each Virtual Machine, which can have unintended side-effects.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Shared Image.
        :param pulumi.Input[_builtins.bool] trusted_launch_enabled: Specifies if Trusted Launch has to be enabled for the Virtual Machine created from the Shared Image. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] trusted_launch_supported: Specifies if supports creation of both Trusted Launch virtual machines and Gen2 virtual machines with standard security created from the Shared Image. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "gallery_name", gallery_name)
        pulumi.set(__self__, "identifier", identifier)
        pulumi.set(__self__, "os_type", os_type)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if accelerated_network_support_enabled is not None:
            pulumi.set(__self__, "accelerated_network_support_enabled", accelerated_network_support_enabled)
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if confidential_vm_enabled is not None:
            pulumi.set(__self__, "confidential_vm_enabled", confidential_vm_enabled)
        if confidential_vm_supported is not None:
            pulumi.set(__self__, "confidential_vm_supported", confidential_vm_supported)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_controller_type_nvme_enabled is not None:
            pulumi.set(__self__, "disk_controller_type_nvme_enabled", disk_controller_type_nvme_enabled)
        if disk_types_not_alloweds is not None:
            pulumi.set(__self__, "disk_types_not_alloweds", disk_types_not_alloweds)
        if end_of_life_date is not None:
            pulumi.set(__self__, "end_of_life_date", end_of_life_date)
        if eula is not None:
            pulumi.set(__self__, "eula", eula)
        if hibernation_enabled is not None:
            pulumi.set(__self__, "hibernation_enabled", hibernation_enabled)
        if hyper_v_generation is not None:
            pulumi.set(__self__, "hyper_v_generation", hyper_v_generation)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if max_recommended_memory_in_gb is not None:
            pulumi.set(__self__, "max_recommended_memory_in_gb", max_recommended_memory_in_gb)
        if max_recommended_vcpu_count is not None:
            pulumi.set(__self__, "max_recommended_vcpu_count", max_recommended_vcpu_count)
        if min_recommended_memory_in_gb is not None:
            pulumi.set(__self__, "min_recommended_memory_in_gb", min_recommended_memory_in_gb)
        if min_recommended_vcpu_count is not None:
            pulumi.set(__self__, "min_recommended_vcpu_count", min_recommended_vcpu_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if privacy_statement_uri is not None:
            pulumi.set(__self__, "privacy_statement_uri", privacy_statement_uri)
        if purchase_plan is not None:
            pulumi.set(__self__, "purchase_plan", purchase_plan)
        if release_note_uri is not None:
            pulumi.set(__self__, "release_note_uri", release_note_uri)
        if specialized is not None:
            pulumi.set(__self__, "specialized", specialized)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if trusted_launch_enabled is not None:
            pulumi.set(__self__, "trusted_launch_enabled", trusted_launch_enabled)
        if trusted_launch_supported is not None:
            pulumi.set(__self__, "trusted_launch_supported", trusted_launch_supported)

    @_builtins.property
    @pulumi.getter(name="galleryName")
    def gallery_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Shared Image Gallery in which this Shared Image should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "gallery_name")

    @gallery_name.setter
    def gallery_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "gallery_name", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Input['SharedImageIdentifierArgs']:
        """
        An `identifier` block as defined below.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: pulumi.Input['SharedImageIdentifierArgs']):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of Operating System present in this Shared Image. Possible values are `Linux` and `Windows`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "os_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which the Shared Image Gallery exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="acceleratedNetworkSupportEnabled")
    def accelerated_network_support_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the Shared Image supports Accelerated Network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "accelerated_network_support_enabled")

    @accelerated_network_support_enabled.setter
    def accelerated_network_support_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "accelerated_network_support_enabled", value)

    @_builtins.property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CPU architecture supported by an OS. Possible values are `x64` and `Arm64`. Defaults to `x64`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "architecture", value)

    @_builtins.property
    @pulumi.getter(name="confidentialVmEnabled")
    def confidential_vm_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if Confidential Virtual Machines enabled. It will enable all the features of trusted, with higher confidentiality features for isolate machines or encrypted data. Available for Gen2 machines. Changing this forces a new resource to be created.

        > **Note:** Only one of `trusted_launch_supported`, `trusted_launch_enabled`, `confidential_vm_supported` and `confidential_vm_enabled` can be specified.
        """
        return pulumi.get(self, "confidential_vm_enabled")

    @confidential_vm_enabled.setter
    def confidential_vm_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "confidential_vm_enabled", value)

    @_builtins.property
    @pulumi.getter(name="confidentialVmSupported")
    def confidential_vm_supported(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if supports creation of both Confidential virtual machines and Gen2 virtual machines with standard security from a compatible Gen2 OS disk VHD or Gen2 Managed image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "confidential_vm_supported")

    @confidential_vm_supported.setter
    def confidential_vm_supported(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "confidential_vm_supported", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of this Shared Image.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskControllerTypeNvmeEnabled")
    def disk_controller_type_nvme_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the Shared Image supports NVMe disks. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "disk_controller_type_nvme_enabled")

    @disk_controller_type_nvme_enabled.setter
    def disk_controller_type_nvme_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disk_controller_type_nvme_enabled", value)

    @_builtins.property
    @pulumi.getter(name="diskTypesNotAlloweds")
    def disk_types_not_alloweds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        One or more Disk Types not allowed for the Image. Possible values include `Standard_LRS` and `Premium_LRS`.
        """
        return pulumi.get(self, "disk_types_not_alloweds")

    @disk_types_not_alloweds.setter
    def disk_types_not_alloweds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "disk_types_not_alloweds", value)

    @_builtins.property
    @pulumi.getter(name="endOfLifeDate")
    def end_of_life_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end of life date in RFC3339 format of the Image.
        """
        return pulumi.get(self, "end_of_life_date")

    @end_of_life_date.setter
    def end_of_life_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_of_life_date", value)

    @_builtins.property
    @pulumi.getter
    def eula(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The End User Licence Agreement for the Shared Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "eula")

    @eula.setter
    def eula(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eula", value)

    @_builtins.property
    @pulumi.getter(name="hibernationEnabled")
    def hibernation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the Shared Image supports hibernation. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "hibernation_enabled")

    @hibernation_enabled.setter
    def hibernation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hibernation_enabled", value)

    @_builtins.property
    @pulumi.getter(name="hyperVGeneration")
    def hyper_v_generation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The generation of HyperV that the Virtual Machine used to create the Shared Image is based on. Possible values are `V1` and `V2`. Defaults to `V1`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "hyper_v_generation")

    @hyper_v_generation.setter
    def hyper_v_generation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hyper_v_generation", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the Shared Image Gallery exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maxRecommendedMemoryInGb")
    def max_recommended_memory_in_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum memory in GB recommended for the Image.
        """
        return pulumi.get(self, "max_recommended_memory_in_gb")

    @max_recommended_memory_in_gb.setter
    def max_recommended_memory_in_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_recommended_memory_in_gb", value)

    @_builtins.property
    @pulumi.getter(name="maxRecommendedVcpuCount")
    def max_recommended_vcpu_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum count of vCPUs recommended for the Image.
        """
        return pulumi.get(self, "max_recommended_vcpu_count")

    @max_recommended_vcpu_count.setter
    def max_recommended_vcpu_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_recommended_vcpu_count", value)

    @_builtins.property
    @pulumi.getter(name="minRecommendedMemoryInGb")
    def min_recommended_memory_in_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum memory in GB recommended for the Image.
        """
        return pulumi.get(self, "min_recommended_memory_in_gb")

    @min_recommended_memory_in_gb.setter
    def min_recommended_memory_in_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_recommended_memory_in_gb", value)

    @_builtins.property
    @pulumi.getter(name="minRecommendedVcpuCount")
    def min_recommended_vcpu_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum count of vCPUs recommended for the Image.
        """
        return pulumi.get(self, "min_recommended_vcpu_count")

    @min_recommended_vcpu_count.setter
    def min_recommended_vcpu_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_recommended_vcpu_count", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Shared Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="privacyStatementUri")
    def privacy_statement_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI containing the Privacy Statement associated with this Shared Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "privacy_statement_uri")

    @privacy_statement_uri.setter
    def privacy_statement_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "privacy_statement_uri", value)

    @_builtins.property
    @pulumi.getter(name="purchasePlan")
    def purchase_plan(self) -> Optional[pulumi.Input['SharedImagePurchasePlanArgs']]:
        """
        A `purchase_plan` block as defined below.
        """
        return pulumi.get(self, "purchase_plan")

    @purchase_plan.setter
    def purchase_plan(self, value: Optional[pulumi.Input['SharedImagePurchasePlanArgs']]):
        pulumi.set(self, "purchase_plan", value)

    @_builtins.property
    @pulumi.getter(name="releaseNoteUri")
    def release_note_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI containing the Release Notes associated with this Shared Image.
        """
        return pulumi.get(self, "release_note_uri")

    @release_note_uri.setter
    def release_note_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "release_note_uri", value)

    @_builtins.property
    @pulumi.getter
    def specialized(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies that the Operating System used inside this Image has not been Generalized (for example, `sysprep` on Windows has not been run). Changing this forces a new resource to be created.

        !> **Note:** It's recommended to Generalize images where possible - Specialized Images reuse the same UUID internally within each Virtual Machine, which can have unintended side-effects.
        """
        return pulumi.get(self, "specialized")

    @specialized.setter
    def specialized(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "specialized", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the Shared Image.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="trustedLaunchEnabled")
    def trusted_launch_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if Trusted Launch has to be enabled for the Virtual Machine created from the Shared Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "trusted_launch_enabled")

    @trusted_launch_enabled.setter
    def trusted_launch_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "trusted_launch_enabled", value)

    @_builtins.property
    @pulumi.getter(name="trustedLaunchSupported")
    def trusted_launch_supported(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if supports creation of both Trusted Launch virtual machines and Gen2 virtual machines with standard security created from the Shared Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "trusted_launch_supported")

    @trusted_launch_supported.setter
    def trusted_launch_supported(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "trusted_launch_supported", value)


@pulumi.input_type
class _SharedImageState:
    def __init__(__self__, *,
                 accelerated_network_support_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 confidential_vm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 confidential_vm_supported: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_controller_type_nvme_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 disk_types_not_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 end_of_life_date: Optional[pulumi.Input[_builtins.str]] = None,
                 eula: Optional[pulumi.Input[_builtins.str]] = None,
                 gallery_name: Optional[pulumi.Input[_builtins.str]] = None,
                 hibernation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hyper_v_generation: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input['SharedImageIdentifierArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 max_recommended_memory_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 max_recommended_vcpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 min_recommended_memory_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 min_recommended_vcpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 privacy_statement_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 purchase_plan: Optional[pulumi.Input['SharedImagePurchasePlanArgs']] = None,
                 release_note_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 specialized: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 trusted_launch_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 trusted_launch_supported: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering SharedImage resources.
        :param pulumi.Input[_builtins.bool] accelerated_network_support_enabled: Specifies if the Shared Image supports Accelerated Network. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] architecture: CPU architecture supported by an OS. Possible values are `x64` and `Arm64`. Defaults to `x64`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] confidential_vm_enabled: Specifies if Confidential Virtual Machines enabled. It will enable all the features of trusted, with higher confidentiality features for isolate machines or encrypted data. Available for Gen2 machines. Changing this forces a new resource to be created.
               
               > **Note:** Only one of `trusted_launch_supported`, `trusted_launch_enabled`, `confidential_vm_supported` and `confidential_vm_enabled` can be specified.
        :param pulumi.Input[_builtins.bool] confidential_vm_supported: Specifies if supports creation of both Confidential virtual machines and Gen2 virtual machines with standard security from a compatible Gen2 OS disk VHD or Gen2 Managed image. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: A description of this Shared Image.
        :param pulumi.Input[_builtins.bool] disk_controller_type_nvme_enabled: Specifies if the Shared Image supports NVMe disks. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disk_types_not_alloweds: One or more Disk Types not allowed for the Image. Possible values include `Standard_LRS` and `Premium_LRS`.
        :param pulumi.Input[_builtins.str] end_of_life_date: The end of life date in RFC3339 format of the Image.
        :param pulumi.Input[_builtins.str] eula: The End User Licence Agreement for the Shared Image. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] gallery_name: Specifies the name of the Shared Image Gallery in which this Shared Image should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] hibernation_enabled: Specifies if the Shared Image supports hibernation. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] hyper_v_generation: The generation of HyperV that the Virtual Machine used to create the Shared Image is based on. Possible values are `V1` and `V2`. Defaults to `V1`. Changing this forces a new resource to be created.
        :param pulumi.Input['SharedImageIdentifierArgs'] identifier: An `identifier` block as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the Shared Image Gallery exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] max_recommended_memory_in_gb: Maximum memory in GB recommended for the Image.
        :param pulumi.Input[_builtins.int] max_recommended_vcpu_count: Maximum count of vCPUs recommended for the Image.
        :param pulumi.Input[_builtins.int] min_recommended_memory_in_gb: Minimum memory in GB recommended for the Image.
        :param pulumi.Input[_builtins.int] min_recommended_vcpu_count: Minimum count of vCPUs recommended for the Image.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Shared Image. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] os_type: The type of Operating System present in this Shared Image. Possible values are `Linux` and `Windows`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] privacy_statement_uri: The URI containing the Privacy Statement associated with this Shared Image. Changing this forces a new resource to be created.
        :param pulumi.Input['SharedImagePurchasePlanArgs'] purchase_plan: A `purchase_plan` block as defined below.
        :param pulumi.Input[_builtins.str] release_note_uri: The URI containing the Release Notes associated with this Shared Image.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Shared Image Gallery exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] specialized: Specifies that the Operating System used inside this Image has not been Generalized (for example, `sysprep` on Windows has not been run). Changing this forces a new resource to be created.
               
               !> **Note:** It's recommended to Generalize images where possible - Specialized Images reuse the same UUID internally within each Virtual Machine, which can have unintended side-effects.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Shared Image.
        :param pulumi.Input[_builtins.bool] trusted_launch_enabled: Specifies if Trusted Launch has to be enabled for the Virtual Machine created from the Shared Image. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] trusted_launch_supported: Specifies if supports creation of both Trusted Launch virtual machines and Gen2 virtual machines with standard security created from the Shared Image. Changing this forces a new resource to be created.
        """
        if accelerated_network_support_enabled is not None:
            pulumi.set(__self__, "accelerated_network_support_enabled", accelerated_network_support_enabled)
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if confidential_vm_enabled is not None:
            pulumi.set(__self__, "confidential_vm_enabled", confidential_vm_enabled)
        if confidential_vm_supported is not None:
            pulumi.set(__self__, "confidential_vm_supported", confidential_vm_supported)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disk_controller_type_nvme_enabled is not None:
            pulumi.set(__self__, "disk_controller_type_nvme_enabled", disk_controller_type_nvme_enabled)
        if disk_types_not_alloweds is not None:
            pulumi.set(__self__, "disk_types_not_alloweds", disk_types_not_alloweds)
        if end_of_life_date is not None:
            pulumi.set(__self__, "end_of_life_date", end_of_life_date)
        if eula is not None:
            pulumi.set(__self__, "eula", eula)
        if gallery_name is not None:
            pulumi.set(__self__, "gallery_name", gallery_name)
        if hibernation_enabled is not None:
            pulumi.set(__self__, "hibernation_enabled", hibernation_enabled)
        if hyper_v_generation is not None:
            pulumi.set(__self__, "hyper_v_generation", hyper_v_generation)
        if identifier is not None:
            pulumi.set(__self__, "identifier", identifier)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if max_recommended_memory_in_gb is not None:
            pulumi.set(__self__, "max_recommended_memory_in_gb", max_recommended_memory_in_gb)
        if max_recommended_vcpu_count is not None:
            pulumi.set(__self__, "max_recommended_vcpu_count", max_recommended_vcpu_count)
        if min_recommended_memory_in_gb is not None:
            pulumi.set(__self__, "min_recommended_memory_in_gb", min_recommended_memory_in_gb)
        if min_recommended_vcpu_count is not None:
            pulumi.set(__self__, "min_recommended_vcpu_count", min_recommended_vcpu_count)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if os_type is not None:
            pulumi.set(__self__, "os_type", os_type)
        if privacy_statement_uri is not None:
            pulumi.set(__self__, "privacy_statement_uri", privacy_statement_uri)
        if purchase_plan is not None:
            pulumi.set(__self__, "purchase_plan", purchase_plan)
        if release_note_uri is not None:
            pulumi.set(__self__, "release_note_uri", release_note_uri)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if specialized is not None:
            pulumi.set(__self__, "specialized", specialized)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if trusted_launch_enabled is not None:
            pulumi.set(__self__, "trusted_launch_enabled", trusted_launch_enabled)
        if trusted_launch_supported is not None:
            pulumi.set(__self__, "trusted_launch_supported", trusted_launch_supported)

    @_builtins.property
    @pulumi.getter(name="acceleratedNetworkSupportEnabled")
    def accelerated_network_support_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the Shared Image supports Accelerated Network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "accelerated_network_support_enabled")

    @accelerated_network_support_enabled.setter
    def accelerated_network_support_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "accelerated_network_support_enabled", value)

    @_builtins.property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        CPU architecture supported by an OS. Possible values are `x64` and `Arm64`. Defaults to `x64`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "architecture", value)

    @_builtins.property
    @pulumi.getter(name="confidentialVmEnabled")
    def confidential_vm_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if Confidential Virtual Machines enabled. It will enable all the features of trusted, with higher confidentiality features for isolate machines or encrypted data. Available for Gen2 machines. Changing this forces a new resource to be created.

        > **Note:** Only one of `trusted_launch_supported`, `trusted_launch_enabled`, `confidential_vm_supported` and `confidential_vm_enabled` can be specified.
        """
        return pulumi.get(self, "confidential_vm_enabled")

    @confidential_vm_enabled.setter
    def confidential_vm_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "confidential_vm_enabled", value)

    @_builtins.property
    @pulumi.getter(name="confidentialVmSupported")
    def confidential_vm_supported(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if supports creation of both Confidential virtual machines and Gen2 virtual machines with standard security from a compatible Gen2 OS disk VHD or Gen2 Managed image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "confidential_vm_supported")

    @confidential_vm_supported.setter
    def confidential_vm_supported(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "confidential_vm_supported", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description of this Shared Image.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="diskControllerTypeNvmeEnabled")
    def disk_controller_type_nvme_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the Shared Image supports NVMe disks. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "disk_controller_type_nvme_enabled")

    @disk_controller_type_nvme_enabled.setter
    def disk_controller_type_nvme_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disk_controller_type_nvme_enabled", value)

    @_builtins.property
    @pulumi.getter(name="diskTypesNotAlloweds")
    def disk_types_not_alloweds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        One or more Disk Types not allowed for the Image. Possible values include `Standard_LRS` and `Premium_LRS`.
        """
        return pulumi.get(self, "disk_types_not_alloweds")

    @disk_types_not_alloweds.setter
    def disk_types_not_alloweds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "disk_types_not_alloweds", value)

    @_builtins.property
    @pulumi.getter(name="endOfLifeDate")
    def end_of_life_date(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The end of life date in RFC3339 format of the Image.
        """
        return pulumi.get(self, "end_of_life_date")

    @end_of_life_date.setter
    def end_of_life_date(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "end_of_life_date", value)

    @_builtins.property
    @pulumi.getter
    def eula(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The End User Licence Agreement for the Shared Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "eula")

    @eula.setter
    def eula(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "eula", value)

    @_builtins.property
    @pulumi.getter(name="galleryName")
    def gallery_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Shared Image Gallery in which this Shared Image should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "gallery_name")

    @gallery_name.setter
    def gallery_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "gallery_name", value)

    @_builtins.property
    @pulumi.getter(name="hibernationEnabled")
    def hibernation_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if the Shared Image supports hibernation. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "hibernation_enabled")

    @hibernation_enabled.setter
    def hibernation_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "hibernation_enabled", value)

    @_builtins.property
    @pulumi.getter(name="hyperVGeneration")
    def hyper_v_generation(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The generation of HyperV that the Virtual Machine used to create the Shared Image is based on. Possible values are `V1` and `V2`. Defaults to `V1`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "hyper_v_generation")

    @hyper_v_generation.setter
    def hyper_v_generation(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hyper_v_generation", value)

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> Optional[pulumi.Input['SharedImageIdentifierArgs']]:
        """
        An `identifier` block as defined below.
        """
        return pulumi.get(self, "identifier")

    @identifier.setter
    def identifier(self, value: Optional[pulumi.Input['SharedImageIdentifierArgs']]):
        pulumi.set(self, "identifier", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the Shared Image Gallery exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maxRecommendedMemoryInGb")
    def max_recommended_memory_in_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum memory in GB recommended for the Image.
        """
        return pulumi.get(self, "max_recommended_memory_in_gb")

    @max_recommended_memory_in_gb.setter
    def max_recommended_memory_in_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_recommended_memory_in_gb", value)

    @_builtins.property
    @pulumi.getter(name="maxRecommendedVcpuCount")
    def max_recommended_vcpu_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum count of vCPUs recommended for the Image.
        """
        return pulumi.get(self, "max_recommended_vcpu_count")

    @max_recommended_vcpu_count.setter
    def max_recommended_vcpu_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_recommended_vcpu_count", value)

    @_builtins.property
    @pulumi.getter(name="minRecommendedMemoryInGb")
    def min_recommended_memory_in_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum memory in GB recommended for the Image.
        """
        return pulumi.get(self, "min_recommended_memory_in_gb")

    @min_recommended_memory_in_gb.setter
    def min_recommended_memory_in_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_recommended_memory_in_gb", value)

    @_builtins.property
    @pulumi.getter(name="minRecommendedVcpuCount")
    def min_recommended_vcpu_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum count of vCPUs recommended for the Image.
        """
        return pulumi.get(self, "min_recommended_vcpu_count")

    @min_recommended_vcpu_count.setter
    def min_recommended_vcpu_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_recommended_vcpu_count", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Shared Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of Operating System present in this Shared Image. Possible values are `Linux` and `Windows`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "os_type")

    @os_type.setter
    def os_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "os_type", value)

    @_builtins.property
    @pulumi.getter(name="privacyStatementUri")
    def privacy_statement_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI containing the Privacy Statement associated with this Shared Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "privacy_statement_uri")

    @privacy_statement_uri.setter
    def privacy_statement_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "privacy_statement_uri", value)

    @_builtins.property
    @pulumi.getter(name="purchasePlan")
    def purchase_plan(self) -> Optional[pulumi.Input['SharedImagePurchasePlanArgs']]:
        """
        A `purchase_plan` block as defined below.
        """
        return pulumi.get(self, "purchase_plan")

    @purchase_plan.setter
    def purchase_plan(self, value: Optional[pulumi.Input['SharedImagePurchasePlanArgs']]):
        pulumi.set(self, "purchase_plan", value)

    @_builtins.property
    @pulumi.getter(name="releaseNoteUri")
    def release_note_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The URI containing the Release Notes associated with this Shared Image.
        """
        return pulumi.get(self, "release_note_uri")

    @release_note_uri.setter
    def release_note_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "release_note_uri", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which the Shared Image Gallery exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def specialized(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies that the Operating System used inside this Image has not been Generalized (for example, `sysprep` on Windows has not been run). Changing this forces a new resource to be created.

        !> **Note:** It's recommended to Generalize images where possible - Specialized Images reuse the same UUID internally within each Virtual Machine, which can have unintended side-effects.
        """
        return pulumi.get(self, "specialized")

    @specialized.setter
    def specialized(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "specialized", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the Shared Image.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="trustedLaunchEnabled")
    def trusted_launch_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if Trusted Launch has to be enabled for the Virtual Machine created from the Shared Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "trusted_launch_enabled")

    @trusted_launch_enabled.setter
    def trusted_launch_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "trusted_launch_enabled", value)

    @_builtins.property
    @pulumi.getter(name="trustedLaunchSupported")
    def trusted_launch_supported(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies if supports creation of both Trusted Launch virtual machines and Gen2 virtual machines with standard security created from the Shared Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "trusted_launch_supported")

    @trusted_launch_supported.setter
    def trusted_launch_supported(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "trusted_launch_supported", value)


@pulumi.type_token("azure:compute/sharedImage:SharedImage")
class SharedImage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerated_network_support_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 confidential_vm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 confidential_vm_supported: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_controller_type_nvme_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 disk_types_not_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 end_of_life_date: Optional[pulumi.Input[_builtins.str]] = None,
                 eula: Optional[pulumi.Input[_builtins.str]] = None,
                 gallery_name: Optional[pulumi.Input[_builtins.str]] = None,
                 hibernation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hyper_v_generation: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[Union['SharedImageIdentifierArgs', 'SharedImageIdentifierArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 max_recommended_memory_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 max_recommended_vcpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 min_recommended_memory_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 min_recommended_vcpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 privacy_statement_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 purchase_plan: Optional[pulumi.Input[Union['SharedImagePurchasePlanArgs', 'SharedImagePurchasePlanArgsDict']]] = None,
                 release_note_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 specialized: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 trusted_launch_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 trusted_launch_supported: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages a Shared Image within a Shared Image Gallery.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_shared_image_gallery = azure.compute.SharedImageGallery("example",
            name="example_image_gallery",
            resource_group_name=example.name,
            location=example.location,
            description="Shared images and things.",
            tags={
                "Hello": "There",
                "World": "Example",
            })
        example_shared_image = azure.compute.SharedImage("example",
            name="my-image",
            gallery_name=example_shared_image_gallery.name,
            resource_group_name=example.name,
            location=example.location,
            os_type="Linux",
            identifier={
                "publisher": "PublisherName",
                "offer": "OfferName",
                "sku": "ExampleSku",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute` - 2022-03-03

        ## Import

        Shared Images can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/sharedImage:SharedImage image1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Compute/galleries/gallery1/images/image1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] accelerated_network_support_enabled: Specifies if the Shared Image supports Accelerated Network. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] architecture: CPU architecture supported by an OS. Possible values are `x64` and `Arm64`. Defaults to `x64`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] confidential_vm_enabled: Specifies if Confidential Virtual Machines enabled. It will enable all the features of trusted, with higher confidentiality features for isolate machines or encrypted data. Available for Gen2 machines. Changing this forces a new resource to be created.
               
               > **Note:** Only one of `trusted_launch_supported`, `trusted_launch_enabled`, `confidential_vm_supported` and `confidential_vm_enabled` can be specified.
        :param pulumi.Input[_builtins.bool] confidential_vm_supported: Specifies if supports creation of both Confidential virtual machines and Gen2 virtual machines with standard security from a compatible Gen2 OS disk VHD or Gen2 Managed image. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: A description of this Shared Image.
        :param pulumi.Input[_builtins.bool] disk_controller_type_nvme_enabled: Specifies if the Shared Image supports NVMe disks. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disk_types_not_alloweds: One or more Disk Types not allowed for the Image. Possible values include `Standard_LRS` and `Premium_LRS`.
        :param pulumi.Input[_builtins.str] end_of_life_date: The end of life date in RFC3339 format of the Image.
        :param pulumi.Input[_builtins.str] eula: The End User Licence Agreement for the Shared Image. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] gallery_name: Specifies the name of the Shared Image Gallery in which this Shared Image should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] hibernation_enabled: Specifies if the Shared Image supports hibernation. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] hyper_v_generation: The generation of HyperV that the Virtual Machine used to create the Shared Image is based on. Possible values are `V1` and `V2`. Defaults to `V1`. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['SharedImageIdentifierArgs', 'SharedImageIdentifierArgsDict']] identifier: An `identifier` block as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the Shared Image Gallery exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] max_recommended_memory_in_gb: Maximum memory in GB recommended for the Image.
        :param pulumi.Input[_builtins.int] max_recommended_vcpu_count: Maximum count of vCPUs recommended for the Image.
        :param pulumi.Input[_builtins.int] min_recommended_memory_in_gb: Minimum memory in GB recommended for the Image.
        :param pulumi.Input[_builtins.int] min_recommended_vcpu_count: Minimum count of vCPUs recommended for the Image.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Shared Image. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] os_type: The type of Operating System present in this Shared Image. Possible values are `Linux` and `Windows`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] privacy_statement_uri: The URI containing the Privacy Statement associated with this Shared Image. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['SharedImagePurchasePlanArgs', 'SharedImagePurchasePlanArgsDict']] purchase_plan: A `purchase_plan` block as defined below.
        :param pulumi.Input[_builtins.str] release_note_uri: The URI containing the Release Notes associated with this Shared Image.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Shared Image Gallery exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] specialized: Specifies that the Operating System used inside this Image has not been Generalized (for example, `sysprep` on Windows has not been run). Changing this forces a new resource to be created.
               
               !> **Note:** It's recommended to Generalize images where possible - Specialized Images reuse the same UUID internally within each Virtual Machine, which can have unintended side-effects.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Shared Image.
        :param pulumi.Input[_builtins.bool] trusted_launch_enabled: Specifies if Trusted Launch has to be enabled for the Virtual Machine created from the Shared Image. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] trusted_launch_supported: Specifies if supports creation of both Trusted Launch virtual machines and Gen2 virtual machines with standard security created from the Shared Image. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SharedImageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Shared Image within a Shared Image Gallery.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_shared_image_gallery = azure.compute.SharedImageGallery("example",
            name="example_image_gallery",
            resource_group_name=example.name,
            location=example.location,
            description="Shared images and things.",
            tags={
                "Hello": "There",
                "World": "Example",
            })
        example_shared_image = azure.compute.SharedImage("example",
            name="my-image",
            gallery_name=example_shared_image_gallery.name,
            resource_group_name=example.name,
            location=example.location,
            os_type="Linux",
            identifier={
                "publisher": "PublisherName",
                "offer": "OfferName",
                "sku": "ExampleSku",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Compute` - 2022-03-03

        ## Import

        Shared Images can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:compute/sharedImage:SharedImage image1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Compute/galleries/gallery1/images/image1
        ```

        :param str resource_name: The name of the resource.
        :param SharedImageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SharedImageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 accelerated_network_support_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 architecture: Optional[pulumi.Input[_builtins.str]] = None,
                 confidential_vm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 confidential_vm_supported: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 disk_controller_type_nvme_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 disk_types_not_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 end_of_life_date: Optional[pulumi.Input[_builtins.str]] = None,
                 eula: Optional[pulumi.Input[_builtins.str]] = None,
                 gallery_name: Optional[pulumi.Input[_builtins.str]] = None,
                 hibernation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hyper_v_generation: Optional[pulumi.Input[_builtins.str]] = None,
                 identifier: Optional[pulumi.Input[Union['SharedImageIdentifierArgs', 'SharedImageIdentifierArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 max_recommended_memory_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 max_recommended_vcpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 min_recommended_memory_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
                 min_recommended_vcpu_count: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 os_type: Optional[pulumi.Input[_builtins.str]] = None,
                 privacy_statement_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 purchase_plan: Optional[pulumi.Input[Union['SharedImagePurchasePlanArgs', 'SharedImagePurchasePlanArgsDict']]] = None,
                 release_note_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 specialized: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 trusted_launch_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 trusted_launch_supported: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SharedImageArgs.__new__(SharedImageArgs)

            __props__.__dict__["accelerated_network_support_enabled"] = accelerated_network_support_enabled
            __props__.__dict__["architecture"] = architecture
            __props__.__dict__["confidential_vm_enabled"] = confidential_vm_enabled
            __props__.__dict__["confidential_vm_supported"] = confidential_vm_supported
            __props__.__dict__["description"] = description
            __props__.__dict__["disk_controller_type_nvme_enabled"] = disk_controller_type_nvme_enabled
            __props__.__dict__["disk_types_not_alloweds"] = disk_types_not_alloweds
            __props__.__dict__["end_of_life_date"] = end_of_life_date
            __props__.__dict__["eula"] = eula
            if gallery_name is None and not opts.urn:
                raise TypeError("Missing required property 'gallery_name'")
            __props__.__dict__["gallery_name"] = gallery_name
            __props__.__dict__["hibernation_enabled"] = hibernation_enabled
            __props__.__dict__["hyper_v_generation"] = hyper_v_generation
            if identifier is None and not opts.urn:
                raise TypeError("Missing required property 'identifier'")
            __props__.__dict__["identifier"] = identifier
            __props__.__dict__["location"] = location
            __props__.__dict__["max_recommended_memory_in_gb"] = max_recommended_memory_in_gb
            __props__.__dict__["max_recommended_vcpu_count"] = max_recommended_vcpu_count
            __props__.__dict__["min_recommended_memory_in_gb"] = min_recommended_memory_in_gb
            __props__.__dict__["min_recommended_vcpu_count"] = min_recommended_vcpu_count
            __props__.__dict__["name"] = name
            if os_type is None and not opts.urn:
                raise TypeError("Missing required property 'os_type'")
            __props__.__dict__["os_type"] = os_type
            __props__.__dict__["privacy_statement_uri"] = privacy_statement_uri
            __props__.__dict__["purchase_plan"] = purchase_plan
            __props__.__dict__["release_note_uri"] = release_note_uri
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["specialized"] = specialized
            __props__.__dict__["tags"] = tags
            __props__.__dict__["trusted_launch_enabled"] = trusted_launch_enabled
            __props__.__dict__["trusted_launch_supported"] = trusted_launch_supported
        super(SharedImage, __self__).__init__(
            'azure:compute/sharedImage:SharedImage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accelerated_network_support_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            architecture: Optional[pulumi.Input[_builtins.str]] = None,
            confidential_vm_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            confidential_vm_supported: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            disk_controller_type_nvme_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            disk_types_not_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            end_of_life_date: Optional[pulumi.Input[_builtins.str]] = None,
            eula: Optional[pulumi.Input[_builtins.str]] = None,
            gallery_name: Optional[pulumi.Input[_builtins.str]] = None,
            hibernation_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            hyper_v_generation: Optional[pulumi.Input[_builtins.str]] = None,
            identifier: Optional[pulumi.Input[Union['SharedImageIdentifierArgs', 'SharedImageIdentifierArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            max_recommended_memory_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
            max_recommended_vcpu_count: Optional[pulumi.Input[_builtins.int]] = None,
            min_recommended_memory_in_gb: Optional[pulumi.Input[_builtins.int]] = None,
            min_recommended_vcpu_count: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            os_type: Optional[pulumi.Input[_builtins.str]] = None,
            privacy_statement_uri: Optional[pulumi.Input[_builtins.str]] = None,
            purchase_plan: Optional[pulumi.Input[Union['SharedImagePurchasePlanArgs', 'SharedImagePurchasePlanArgsDict']]] = None,
            release_note_uri: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            specialized: Optional[pulumi.Input[_builtins.bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            trusted_launch_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            trusted_launch_supported: Optional[pulumi.Input[_builtins.bool]] = None) -> 'SharedImage':
        """
        Get an existing SharedImage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] accelerated_network_support_enabled: Specifies if the Shared Image supports Accelerated Network. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] architecture: CPU architecture supported by an OS. Possible values are `x64` and `Arm64`. Defaults to `x64`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] confidential_vm_enabled: Specifies if Confidential Virtual Machines enabled. It will enable all the features of trusted, with higher confidentiality features for isolate machines or encrypted data. Available for Gen2 machines. Changing this forces a new resource to be created.
               
               > **Note:** Only one of `trusted_launch_supported`, `trusted_launch_enabled`, `confidential_vm_supported` and `confidential_vm_enabled` can be specified.
        :param pulumi.Input[_builtins.bool] confidential_vm_supported: Specifies if supports creation of both Confidential virtual machines and Gen2 virtual machines with standard security from a compatible Gen2 OS disk VHD or Gen2 Managed image. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: A description of this Shared Image.
        :param pulumi.Input[_builtins.bool] disk_controller_type_nvme_enabled: Specifies if the Shared Image supports NVMe disks. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] disk_types_not_alloweds: One or more Disk Types not allowed for the Image. Possible values include `Standard_LRS` and `Premium_LRS`.
        :param pulumi.Input[_builtins.str] end_of_life_date: The end of life date in RFC3339 format of the Image.
        :param pulumi.Input[_builtins.str] eula: The End User Licence Agreement for the Shared Image. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] gallery_name: Specifies the name of the Shared Image Gallery in which this Shared Image should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] hibernation_enabled: Specifies if the Shared Image supports hibernation. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] hyper_v_generation: The generation of HyperV that the Virtual Machine used to create the Shared Image is based on. Possible values are `V1` and `V2`. Defaults to `V1`. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['SharedImageIdentifierArgs', 'SharedImageIdentifierArgsDict']] identifier: An `identifier` block as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the Shared Image Gallery exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] max_recommended_memory_in_gb: Maximum memory in GB recommended for the Image.
        :param pulumi.Input[_builtins.int] max_recommended_vcpu_count: Maximum count of vCPUs recommended for the Image.
        :param pulumi.Input[_builtins.int] min_recommended_memory_in_gb: Minimum memory in GB recommended for the Image.
        :param pulumi.Input[_builtins.int] min_recommended_vcpu_count: Minimum count of vCPUs recommended for the Image.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Shared Image. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] os_type: The type of Operating System present in this Shared Image. Possible values are `Linux` and `Windows`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] privacy_statement_uri: The URI containing the Privacy Statement associated with this Shared Image. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['SharedImagePurchasePlanArgs', 'SharedImagePurchasePlanArgsDict']] purchase_plan: A `purchase_plan` block as defined below.
        :param pulumi.Input[_builtins.str] release_note_uri: The URI containing the Release Notes associated with this Shared Image.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Shared Image Gallery exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] specialized: Specifies that the Operating System used inside this Image has not been Generalized (for example, `sysprep` on Windows has not been run). Changing this forces a new resource to be created.
               
               !> **Note:** It's recommended to Generalize images where possible - Specialized Images reuse the same UUID internally within each Virtual Machine, which can have unintended side-effects.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the Shared Image.
        :param pulumi.Input[_builtins.bool] trusted_launch_enabled: Specifies if Trusted Launch has to be enabled for the Virtual Machine created from the Shared Image. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] trusted_launch_supported: Specifies if supports creation of both Trusted Launch virtual machines and Gen2 virtual machines with standard security created from the Shared Image. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SharedImageState.__new__(_SharedImageState)

        __props__.__dict__["accelerated_network_support_enabled"] = accelerated_network_support_enabled
        __props__.__dict__["architecture"] = architecture
        __props__.__dict__["confidential_vm_enabled"] = confidential_vm_enabled
        __props__.__dict__["confidential_vm_supported"] = confidential_vm_supported
        __props__.__dict__["description"] = description
        __props__.__dict__["disk_controller_type_nvme_enabled"] = disk_controller_type_nvme_enabled
        __props__.__dict__["disk_types_not_alloweds"] = disk_types_not_alloweds
        __props__.__dict__["end_of_life_date"] = end_of_life_date
        __props__.__dict__["eula"] = eula
        __props__.__dict__["gallery_name"] = gallery_name
        __props__.__dict__["hibernation_enabled"] = hibernation_enabled
        __props__.__dict__["hyper_v_generation"] = hyper_v_generation
        __props__.__dict__["identifier"] = identifier
        __props__.__dict__["location"] = location
        __props__.__dict__["max_recommended_memory_in_gb"] = max_recommended_memory_in_gb
        __props__.__dict__["max_recommended_vcpu_count"] = max_recommended_vcpu_count
        __props__.__dict__["min_recommended_memory_in_gb"] = min_recommended_memory_in_gb
        __props__.__dict__["min_recommended_vcpu_count"] = min_recommended_vcpu_count
        __props__.__dict__["name"] = name
        __props__.__dict__["os_type"] = os_type
        __props__.__dict__["privacy_statement_uri"] = privacy_statement_uri
        __props__.__dict__["purchase_plan"] = purchase_plan
        __props__.__dict__["release_note_uri"] = release_note_uri
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["specialized"] = specialized
        __props__.__dict__["tags"] = tags
        __props__.__dict__["trusted_launch_enabled"] = trusted_launch_enabled
        __props__.__dict__["trusted_launch_supported"] = trusted_launch_supported
        return SharedImage(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="acceleratedNetworkSupportEnabled")
    def accelerated_network_support_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if the Shared Image supports Accelerated Network. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "accelerated_network_support_enabled")

    @_builtins.property
    @pulumi.getter
    def architecture(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        CPU architecture supported by an OS. Possible values are `x64` and `Arm64`. Defaults to `x64`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "architecture")

    @_builtins.property
    @pulumi.getter(name="confidentialVmEnabled")
    def confidential_vm_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if Confidential Virtual Machines enabled. It will enable all the features of trusted, with higher confidentiality features for isolate machines or encrypted data. Available for Gen2 machines. Changing this forces a new resource to be created.

        > **Note:** Only one of `trusted_launch_supported`, `trusted_launch_enabled`, `confidential_vm_supported` and `confidential_vm_enabled` can be specified.
        """
        return pulumi.get(self, "confidential_vm_enabled")

    @_builtins.property
    @pulumi.getter(name="confidentialVmSupported")
    def confidential_vm_supported(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if supports creation of both Confidential virtual machines and Gen2 virtual machines with standard security from a compatible Gen2 OS disk VHD or Gen2 Managed image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "confidential_vm_supported")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description of this Shared Image.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="diskControllerTypeNvmeEnabled")
    def disk_controller_type_nvme_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if the Shared Image supports NVMe disks. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "disk_controller_type_nvme_enabled")

    @_builtins.property
    @pulumi.getter(name="diskTypesNotAlloweds")
    def disk_types_not_alloweds(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        One or more Disk Types not allowed for the Image. Possible values include `Standard_LRS` and `Premium_LRS`.
        """
        return pulumi.get(self, "disk_types_not_alloweds")

    @_builtins.property
    @pulumi.getter(name="endOfLifeDate")
    def end_of_life_date(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The end of life date in RFC3339 format of the Image.
        """
        return pulumi.get(self, "end_of_life_date")

    @_builtins.property
    @pulumi.getter
    def eula(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The End User Licence Agreement for the Shared Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "eula")

    @_builtins.property
    @pulumi.getter(name="galleryName")
    def gallery_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Shared Image Gallery in which this Shared Image should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "gallery_name")

    @_builtins.property
    @pulumi.getter(name="hibernationEnabled")
    def hibernation_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if the Shared Image supports hibernation. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "hibernation_enabled")

    @_builtins.property
    @pulumi.getter(name="hyperVGeneration")
    def hyper_v_generation(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The generation of HyperV that the Virtual Machine used to create the Shared Image is based on. Possible values are `V1` and `V2`. Defaults to `V1`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "hyper_v_generation")

    @_builtins.property
    @pulumi.getter
    def identifier(self) -> pulumi.Output['outputs.SharedImageIdentifier']:
        """
        An `identifier` block as defined below.
        """
        return pulumi.get(self, "identifier")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the Shared Image Gallery exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="maxRecommendedMemoryInGb")
    def max_recommended_memory_in_gb(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Maximum memory in GB recommended for the Image.
        """
        return pulumi.get(self, "max_recommended_memory_in_gb")

    @_builtins.property
    @pulumi.getter(name="maxRecommendedVcpuCount")
    def max_recommended_vcpu_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Maximum count of vCPUs recommended for the Image.
        """
        return pulumi.get(self, "max_recommended_vcpu_count")

    @_builtins.property
    @pulumi.getter(name="minRecommendedMemoryInGb")
    def min_recommended_memory_in_gb(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Minimum memory in GB recommended for the Image.
        """
        return pulumi.get(self, "min_recommended_memory_in_gb")

    @_builtins.property
    @pulumi.getter(name="minRecommendedVcpuCount")
    def min_recommended_vcpu_count(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Minimum count of vCPUs recommended for the Image.
        """
        return pulumi.get(self, "min_recommended_vcpu_count")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Shared Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="osType")
    def os_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of Operating System present in this Shared Image. Possible values are `Linux` and `Windows`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "os_type")

    @_builtins.property
    @pulumi.getter(name="privacyStatementUri")
    def privacy_statement_uri(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The URI containing the Privacy Statement associated with this Shared Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "privacy_statement_uri")

    @_builtins.property
    @pulumi.getter(name="purchasePlan")
    def purchase_plan(self) -> pulumi.Output[Optional['outputs.SharedImagePurchasePlan']]:
        """
        A `purchase_plan` block as defined below.
        """
        return pulumi.get(self, "purchase_plan")

    @_builtins.property
    @pulumi.getter(name="releaseNoteUri")
    def release_note_uri(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The URI containing the Release Notes associated with this Shared Image.
        """
        return pulumi.get(self, "release_note_uri")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which the Shared Image Gallery exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def specialized(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies that the Operating System used inside this Image has not been Generalized (for example, `sysprep` on Windows has not been run). Changing this forces a new resource to be created.

        !> **Note:** It's recommended to Generalize images where possible - Specialized Images reuse the same UUID internally within each Virtual Machine, which can have unintended side-effects.
        """
        return pulumi.get(self, "specialized")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the Shared Image.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="trustedLaunchEnabled")
    def trusted_launch_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if Trusted Launch has to be enabled for the Virtual Machine created from the Shared Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "trusted_launch_enabled")

    @_builtins.property
    @pulumi.getter(name="trustedLaunchSupported")
    def trusted_launch_supported(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies if supports creation of both Trusted Launch virtual machines and Gen2 virtual machines with standard security created from the Shared Image. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "trusted_launch_supported")

