# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'BudgetManagementGroupFilter',
    'BudgetManagementGroupFilterDimension',
    'BudgetManagementGroupFilterTag',
    'BudgetManagementGroupNotification',
    'BudgetManagementGroupTimePeriod',
    'BudgetResourceGroupFilter',
    'BudgetResourceGroupFilterDimension',
    'BudgetResourceGroupFilterTag',
    'BudgetResourceGroupNotification',
    'BudgetResourceGroupTimePeriod',
    'BudgetSubscriptionFilter',
    'BudgetSubscriptionFilterDimension',
    'BudgetSubscriptionFilterTag',
    'BudgetSubscriptionNotification',
    'BudgetSubscriptionTimePeriod',
    'GetBudgetResourceGroupFilterResult',
    'GetBudgetResourceGroupFilterDimensionResult',
    'GetBudgetResourceGroupFilterNotResult',
    'GetBudgetResourceGroupFilterNotDimensionResult',
    'GetBudgetResourceGroupFilterNotTagResult',
    'GetBudgetResourceGroupFilterTagResult',
    'GetBudgetResourceGroupNotificationResult',
    'GetBudgetResourceGroupTimePeriodResult',
    'GetBudgetSubscriptionFilterResult',
    'GetBudgetSubscriptionFilterDimensionResult',
    'GetBudgetSubscriptionFilterNotResult',
    'GetBudgetSubscriptionFilterNotDimensionResult',
    'GetBudgetSubscriptionFilterNotTagResult',
    'GetBudgetSubscriptionFilterTagResult',
    'GetBudgetSubscriptionNotificationResult',
    'GetBudgetSubscriptionTimePeriodResult',
]

@pulumi.output_type
class BudgetManagementGroupFilter(dict):
    def __init__(__self__, *,
                 dimensions: Optional[Sequence['outputs.BudgetManagementGroupFilterDimension']] = None,
                 tags: Optional[Sequence['outputs.BudgetManagementGroupFilterTag']] = None):
        """
        :param Sequence['BudgetManagementGroupFilterDimensionArgs'] dimensions: One or more `dimension` blocks as defined below to filter the budget on.
        :param Sequence['BudgetManagementGroupFilterTagArgs'] tags: One or more `tag` blocks as defined below to filter the budget on.
        """
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.BudgetManagementGroupFilterDimension']]:
        """
        One or more `dimension` blocks as defined below to filter the budget on.
        """
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.BudgetManagementGroupFilterTag']]:
        """
        One or more `tag` blocks as defined below to filter the budget on.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class BudgetManagementGroupFilterDimension(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 operator: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the column to use for the filter. The allowed values are `ChargeType`, `Frequency`, `InvoiceId`, `Meter`, `MeterCategory`, `MeterSubCategory`, `PartNumber`, `PricingModel`, `Product`, `ProductOrderId`, `ProductOrderName`, `PublisherType`, `ReservationId`, `ReservationName`, `ResourceGroupName`, `ResourceGuid`, `ResourceId`, `ResourceLocation`, `ResourceType`, `ServiceFamily`, `ServiceName`, `SubscriptionID`, `SubscriptionName`, `UnitOfMeasure`.
        :param Sequence[_builtins.str] values: Specifies a list of values for the column.
        :param _builtins.str operator: The operator to use for comparison. The allowed values are `In`. Defaults to `In`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the column to use for the filter. The allowed values are `ChargeType`, `Frequency`, `InvoiceId`, `Meter`, `MeterCategory`, `MeterSubCategory`, `PartNumber`, `PricingModel`, `Product`, `ProductOrderId`, `ProductOrderName`, `PublisherType`, `ReservationId`, `ReservationName`, `ResourceGroupName`, `ResourceGuid`, `ResourceId`, `ResourceLocation`, `ResourceType`, `ServiceFamily`, `ServiceName`, `SubscriptionID`, `SubscriptionName`, `UnitOfMeasure`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        Specifies a list of values for the column.
        """
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> Optional[_builtins.str]:
        """
        The operator to use for comparison. The allowed values are `In`. Defaults to `In`.
        """
        return pulumi.get(self, "operator")


@pulumi.output_type
class BudgetManagementGroupFilterTag(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 operator: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the tag to use for the filter.
        :param Sequence[_builtins.str] values: Specifies a list of values for the tag.
        :param _builtins.str operator: The operator to use for comparison. The allowed values are `In`. Defaults to `In`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the tag to use for the filter.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        Specifies a list of values for the tag.
        """
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> Optional[_builtins.str]:
        """
        The operator to use for comparison. The allowed values are `In`. Defaults to `In`.
        """
        return pulumi.get(self, "operator")


@pulumi.output_type
class BudgetManagementGroupNotification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contactEmails":
            suggest = "contact_emails"
        elif key == "thresholdType":
            suggest = "threshold_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BudgetManagementGroupNotification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BudgetManagementGroupNotification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BudgetManagementGroupNotification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 contact_emails: Sequence[_builtins.str],
                 operator: _builtins.str,
                 threshold: _builtins.int,
                 enabled: Optional[_builtins.bool] = None,
                 threshold_type: Optional[_builtins.str] = None):
        """
        :param Sequence[_builtins.str] contact_emails: Specifies a list of email addresses to send the budget notification to when the threshold is exceeded.
        :param _builtins.str operator: The comparison operator for the notification. Must be one of `EqualTo`, `GreaterThan`, or `GreaterThanOrEqualTo`.
        :param _builtins.int threshold: Threshold value associated with a notification. Notification is sent when the cost exceeded the threshold. It is always percent and has to be between 0 and 1000.
        :param _builtins.bool enabled: Should the notification be enabled? Defaults to `true`.
        :param _builtins.str threshold_type: The type of threshold for the notification. This determines whether the notification is triggered by forecasted costs or actual costs. The allowed values are `Actual` and `Forecasted`. Default is `Actual`.
        """
        pulumi.set(__self__, "contact_emails", contact_emails)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "threshold", threshold)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if threshold_type is not None:
            pulumi.set(__self__, "threshold_type", threshold_type)

    @_builtins.property
    @pulumi.getter(name="contactEmails")
    def contact_emails(self) -> Sequence[_builtins.str]:
        """
        Specifies a list of email addresses to send the budget notification to when the threshold is exceeded.
        """
        return pulumi.get(self, "contact_emails")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        The comparison operator for the notification. Must be one of `EqualTo`, `GreaterThan`, or `GreaterThanOrEqualTo`.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> _builtins.int:
        """
        Threshold value associated with a notification. Notification is sent when the cost exceeded the threshold. It is always percent and has to be between 0 and 1000.
        """
        return pulumi.get(self, "threshold")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Should the notification be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="thresholdType")
    def threshold_type(self) -> Optional[_builtins.str]:
        """
        The type of threshold for the notification. This determines whether the notification is triggered by forecasted costs or actual costs. The allowed values are `Actual` and `Forecasted`. Default is `Actual`.
        """
        return pulumi.get(self, "threshold_type")


@pulumi.output_type
class BudgetManagementGroupTimePeriod(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startDate":
            suggest = "start_date"
        elif key == "endDate":
            suggest = "end_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BudgetManagementGroupTimePeriod. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BudgetManagementGroupTimePeriod.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BudgetManagementGroupTimePeriod.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_date: _builtins.str,
                 end_date: Optional[_builtins.str] = None):
        """
        :param _builtins.str start_date: The start date for the budget. The start date must be first of the month and should be less than the end date. Budget start date must be on or after June 1, 2017. Future start date should not be more than twelve months. Past start date should be selected within the timegrain period. Changing this forces a new resource to be created.
        :param _builtins.str end_date: The end date for the budget. If not set this will be 10 years after the start date.
        """
        pulumi.set(__self__, "start_date", start_date)
        if end_date is not None:
            pulumi.set(__self__, "end_date", end_date)

    @_builtins.property
    @pulumi.getter(name="startDate")
    def start_date(self) -> _builtins.str:
        """
        The start date for the budget. The start date must be first of the month and should be less than the end date. Budget start date must be on or after June 1, 2017. Future start date should not be more than twelve months. Past start date should be selected within the timegrain period. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "start_date")

    @_builtins.property
    @pulumi.getter(name="endDate")
    def end_date(self) -> Optional[_builtins.str]:
        """
        The end date for the budget. If not set this will be 10 years after the start date.
        """
        return pulumi.get(self, "end_date")


@pulumi.output_type
class BudgetResourceGroupFilter(dict):
    def __init__(__self__, *,
                 dimensions: Optional[Sequence['outputs.BudgetResourceGroupFilterDimension']] = None,
                 tags: Optional[Sequence['outputs.BudgetResourceGroupFilterTag']] = None):
        """
        :param Sequence['BudgetResourceGroupFilterDimensionArgs'] dimensions: One or more `dimension` blocks as defined below to filter the budget on.
        :param Sequence['BudgetResourceGroupFilterTagArgs'] tags: One or more `tag` blocks as defined below to filter the budget on.
        """
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.BudgetResourceGroupFilterDimension']]:
        """
        One or more `dimension` blocks as defined below to filter the budget on.
        """
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.BudgetResourceGroupFilterTag']]:
        """
        One or more `tag` blocks as defined below to filter the budget on.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class BudgetResourceGroupFilterDimension(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 operator: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the column to use for the filter. The allowed values are `ChargeType`, `Frequency`, `InvoiceId`, `Meter`, `MeterCategory`, `MeterSubCategory`, `PartNumber`, `PricingModel`, `Product`, `ProductOrderId`, `ProductOrderName`, `PublisherType`, `ReservationId`, `ReservationName`, `ResourceGroupName`, `ResourceGuid`, `ResourceId`, `ResourceLocation`, `ResourceType`, `ServiceFamily`, `ServiceName`, `SubscriptionID`, `SubscriptionName`, `UnitOfMeasure`.
        :param Sequence[_builtins.str] values: Specifies a list of values for the column.
        :param _builtins.str operator: The operator to use for comparison. The allowed values are `In`. Defaults to `In`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the column to use for the filter. The allowed values are `ChargeType`, `Frequency`, `InvoiceId`, `Meter`, `MeterCategory`, `MeterSubCategory`, `PartNumber`, `PricingModel`, `Product`, `ProductOrderId`, `ProductOrderName`, `PublisherType`, `ReservationId`, `ReservationName`, `ResourceGroupName`, `ResourceGuid`, `ResourceId`, `ResourceLocation`, `ResourceType`, `ServiceFamily`, `ServiceName`, `SubscriptionID`, `SubscriptionName`, `UnitOfMeasure`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        Specifies a list of values for the column.
        """
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> Optional[_builtins.str]:
        """
        The operator to use for comparison. The allowed values are `In`. Defaults to `In`.
        """
        return pulumi.get(self, "operator")


@pulumi.output_type
class BudgetResourceGroupFilterTag(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 operator: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the tag to use for the filter.
        :param Sequence[_builtins.str] values: Specifies a list of values for the tag.
        :param _builtins.str operator: The operator to use for comparison. The allowed values are `In`. Defaults to `In`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the tag to use for the filter.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        Specifies a list of values for the tag.
        """
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> Optional[_builtins.str]:
        """
        The operator to use for comparison. The allowed values are `In`. Defaults to `In`.
        """
        return pulumi.get(self, "operator")


@pulumi.output_type
class BudgetResourceGroupNotification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contactEmails":
            suggest = "contact_emails"
        elif key == "contactGroups":
            suggest = "contact_groups"
        elif key == "contactRoles":
            suggest = "contact_roles"
        elif key == "thresholdType":
            suggest = "threshold_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BudgetResourceGroupNotification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BudgetResourceGroupNotification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BudgetResourceGroupNotification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator: _builtins.str,
                 threshold: _builtins.int,
                 contact_emails: Optional[Sequence[_builtins.str]] = None,
                 contact_groups: Optional[Sequence[_builtins.str]] = None,
                 contact_roles: Optional[Sequence[_builtins.str]] = None,
                 enabled: Optional[_builtins.bool] = None,
                 threshold_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str operator: The comparison operator for the notification. Must be one of `EqualTo`, `GreaterThan`, or `GreaterThanOrEqualTo`.
        :param _builtins.int threshold: Threshold value associated with a notification. Notification is sent when the cost exceeded the threshold. It is always percent and has to be between 0 and 1000.
        :param Sequence[_builtins.str] contact_emails: Specifies a list of email addresses to send the budget notification to when the threshold is exceeded.
        :param Sequence[_builtins.str] contact_groups: Specifies a list of Action Group IDs to send the budget notification to when the threshold is exceeded.
        :param Sequence[_builtins.str] contact_roles: Specifies a list of contact roles to send the budget notification to when the threshold is exceeded.
        :param _builtins.bool enabled: Should the notification be enabled? Defaults to `true`.
               
               > **Note:** A `notification` block cannot have all of `contact_emails`, `contact_roles`, and `contact_groups` empty. This means that at least one of the three must be specified.
        :param _builtins.str threshold_type: The type of threshold for the notification. This determines whether the notification is triggered by forecasted costs or actual costs. The allowed values are `Actual` and `Forecasted`. Default is `Actual`.
        """
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "threshold", threshold)
        if contact_emails is not None:
            pulumi.set(__self__, "contact_emails", contact_emails)
        if contact_groups is not None:
            pulumi.set(__self__, "contact_groups", contact_groups)
        if contact_roles is not None:
            pulumi.set(__self__, "contact_roles", contact_roles)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if threshold_type is not None:
            pulumi.set(__self__, "threshold_type", threshold_type)

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        The comparison operator for the notification. Must be one of `EqualTo`, `GreaterThan`, or `GreaterThanOrEqualTo`.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> _builtins.int:
        """
        Threshold value associated with a notification. Notification is sent when the cost exceeded the threshold. It is always percent and has to be between 0 and 1000.
        """
        return pulumi.get(self, "threshold")

    @_builtins.property
    @pulumi.getter(name="contactEmails")
    def contact_emails(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of email addresses to send the budget notification to when the threshold is exceeded.
        """
        return pulumi.get(self, "contact_emails")

    @_builtins.property
    @pulumi.getter(name="contactGroups")
    def contact_groups(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of Action Group IDs to send the budget notification to when the threshold is exceeded.
        """
        return pulumi.get(self, "contact_groups")

    @_builtins.property
    @pulumi.getter(name="contactRoles")
    def contact_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of contact roles to send the budget notification to when the threshold is exceeded.
        """
        return pulumi.get(self, "contact_roles")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Should the notification be enabled? Defaults to `true`.

        > **Note:** A `notification` block cannot have all of `contact_emails`, `contact_roles`, and `contact_groups` empty. This means that at least one of the three must be specified.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="thresholdType")
    def threshold_type(self) -> Optional[_builtins.str]:
        """
        The type of threshold for the notification. This determines whether the notification is triggered by forecasted costs or actual costs. The allowed values are `Actual` and `Forecasted`. Default is `Actual`.
        """
        return pulumi.get(self, "threshold_type")


@pulumi.output_type
class BudgetResourceGroupTimePeriod(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startDate":
            suggest = "start_date"
        elif key == "endDate":
            suggest = "end_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BudgetResourceGroupTimePeriod. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BudgetResourceGroupTimePeriod.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BudgetResourceGroupTimePeriod.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_date: _builtins.str,
                 end_date: Optional[_builtins.str] = None):
        """
        :param _builtins.str start_date: The start date for the budget. The start date must be first of the month and should be less than the end date. Budget start date must be on or after June 1, 2017. Future start date should not be more than twelve months. Past start date should be selected within the timegrain period. Changing this forces a new Resource Group Consumption Budget to be created.
        :param _builtins.str end_date: The end date for the budget. If not set this will be 10 years after the start date.
        """
        pulumi.set(__self__, "start_date", start_date)
        if end_date is not None:
            pulumi.set(__self__, "end_date", end_date)

    @_builtins.property
    @pulumi.getter(name="startDate")
    def start_date(self) -> _builtins.str:
        """
        The start date for the budget. The start date must be first of the month and should be less than the end date. Budget start date must be on or after June 1, 2017. Future start date should not be more than twelve months. Past start date should be selected within the timegrain period. Changing this forces a new Resource Group Consumption Budget to be created.
        """
        return pulumi.get(self, "start_date")

    @_builtins.property
    @pulumi.getter(name="endDate")
    def end_date(self) -> Optional[_builtins.str]:
        """
        The end date for the budget. If not set this will be 10 years after the start date.
        """
        return pulumi.get(self, "end_date")


@pulumi.output_type
class BudgetSubscriptionFilter(dict):
    def __init__(__self__, *,
                 dimensions: Optional[Sequence['outputs.BudgetSubscriptionFilterDimension']] = None,
                 tags: Optional[Sequence['outputs.BudgetSubscriptionFilterTag']] = None):
        """
        :param Sequence['BudgetSubscriptionFilterDimensionArgs'] dimensions: One or more `dimension` blocks as defined below to filter the budget on.
        :param Sequence['BudgetSubscriptionFilterTagArgs'] tags: One or more `tag` blocks as defined below to filter the budget on.
        """
        if dimensions is not None:
            pulumi.set(__self__, "dimensions", dimensions)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Optional[Sequence['outputs.BudgetSubscriptionFilterDimension']]:
        """
        One or more `dimension` blocks as defined below to filter the budget on.
        """
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.BudgetSubscriptionFilterTag']]:
        """
        One or more `tag` blocks as defined below to filter the budget on.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class BudgetSubscriptionFilterDimension(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 operator: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the column to use for the filter. The allowed values are `ChargeType`, `Frequency`, `InvoiceId`, `Meter`, `MeterCategory`, `MeterSubCategory`, `PartNumber`, `PricingModel`, `Product`, `ProductOrderId`, `ProductOrderName`, `PublisherType`, `ReservationId`, `ReservationName`, `ResourceGroupName`, `ResourceGuid`, `ResourceId`, `ResourceLocation`, `ResourceType`, `ServiceFamily`, `ServiceName`, `SubscriptionID`, `SubscriptionName`, `UnitOfMeasure`.
        :param Sequence[_builtins.str] values: Specifies a list of values for the column.
        :param _builtins.str operator: The operator to use for comparison. The allowed values are `In`. Defaults to `In`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the column to use for the filter. The allowed values are `ChargeType`, `Frequency`, `InvoiceId`, `Meter`, `MeterCategory`, `MeterSubCategory`, `PartNumber`, `PricingModel`, `Product`, `ProductOrderId`, `ProductOrderName`, `PublisherType`, `ReservationId`, `ReservationName`, `ResourceGroupName`, `ResourceGuid`, `ResourceId`, `ResourceLocation`, `ResourceType`, `ServiceFamily`, `ServiceName`, `SubscriptionID`, `SubscriptionName`, `UnitOfMeasure`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        Specifies a list of values for the column.
        """
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> Optional[_builtins.str]:
        """
        The operator to use for comparison. The allowed values are `In`. Defaults to `In`.
        """
        return pulumi.get(self, "operator")


@pulumi.output_type
class BudgetSubscriptionFilterTag(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 values: Sequence[_builtins.str],
                 operator: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The name of the tag to use for the filter.
        :param Sequence[_builtins.str] values: Specifies a list of values for the tag.
        :param _builtins.str operator: The operator to use for comparison. The allowed values are `In`. Defaults to `In`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "values", values)
        if operator is not None:
            pulumi.set(__self__, "operator", operator)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the tag to use for the filter.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        Specifies a list of values for the tag.
        """
        return pulumi.get(self, "values")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> Optional[_builtins.str]:
        """
        The operator to use for comparison. The allowed values are `In`. Defaults to `In`.
        """
        return pulumi.get(self, "operator")


@pulumi.output_type
class BudgetSubscriptionNotification(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "contactEmails":
            suggest = "contact_emails"
        elif key == "contactGroups":
            suggest = "contact_groups"
        elif key == "contactRoles":
            suggest = "contact_roles"
        elif key == "thresholdType":
            suggest = "threshold_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BudgetSubscriptionNotification. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BudgetSubscriptionNotification.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BudgetSubscriptionNotification.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operator: _builtins.str,
                 threshold: _builtins.int,
                 contact_emails: Optional[Sequence[_builtins.str]] = None,
                 contact_groups: Optional[Sequence[_builtins.str]] = None,
                 contact_roles: Optional[Sequence[_builtins.str]] = None,
                 enabled: Optional[_builtins.bool] = None,
                 threshold_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str operator: The comparison operator for the notification. Must be one of `EqualTo`, `GreaterThan`, or `GreaterThanOrEqualTo`.
        :param _builtins.int threshold: Threshold value associated with a notification. Notification is sent when the cost exceeded the threshold. It is always percent and has to be between 0 and 1000.
        :param Sequence[_builtins.str] contact_emails: Specifies a list of email addresses to send the budget notification to when the threshold is exceeded.
        :param Sequence[_builtins.str] contact_groups: Specifies a list of Action Group IDs to send the budget notification to when the threshold is exceeded.
        :param Sequence[_builtins.str] contact_roles: Specifies a list of contact roles to send the budget notification to when the threshold is exceeded.
        :param _builtins.bool enabled: Should the notification be enabled? Defaults to `true`.
               
               > **Note:** A `notification` block cannot have all of `contact_emails`, `contact_roles`, and `contact_groups` empty. This means that at least one of the three must be specified.
        :param _builtins.str threshold_type: The type of threshold for the notification. This determines whether the notification is triggered by forecasted costs or actual costs. The allowed values are `Actual` and `Forecasted`. Default is `Actual`.
        """
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "threshold", threshold)
        if contact_emails is not None:
            pulumi.set(__self__, "contact_emails", contact_emails)
        if contact_groups is not None:
            pulumi.set(__self__, "contact_groups", contact_groups)
        if contact_roles is not None:
            pulumi.set(__self__, "contact_roles", contact_roles)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if threshold_type is not None:
            pulumi.set(__self__, "threshold_type", threshold_type)

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        The comparison operator for the notification. Must be one of `EqualTo`, `GreaterThan`, or `GreaterThanOrEqualTo`.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> _builtins.int:
        """
        Threshold value associated with a notification. Notification is sent when the cost exceeded the threshold. It is always percent and has to be between 0 and 1000.
        """
        return pulumi.get(self, "threshold")

    @_builtins.property
    @pulumi.getter(name="contactEmails")
    def contact_emails(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of email addresses to send the budget notification to when the threshold is exceeded.
        """
        return pulumi.get(self, "contact_emails")

    @_builtins.property
    @pulumi.getter(name="contactGroups")
    def contact_groups(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of Action Group IDs to send the budget notification to when the threshold is exceeded.
        """
        return pulumi.get(self, "contact_groups")

    @_builtins.property
    @pulumi.getter(name="contactRoles")
    def contact_roles(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of contact roles to send the budget notification to when the threshold is exceeded.
        """
        return pulumi.get(self, "contact_roles")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        Should the notification be enabled? Defaults to `true`.

        > **Note:** A `notification` block cannot have all of `contact_emails`, `contact_roles`, and `contact_groups` empty. This means that at least one of the three must be specified.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="thresholdType")
    def threshold_type(self) -> Optional[_builtins.str]:
        """
        The type of threshold for the notification. This determines whether the notification is triggered by forecasted costs or actual costs. The allowed values are `Actual` and `Forecasted`. Default is `Actual`.
        """
        return pulumi.get(self, "threshold_type")


@pulumi.output_type
class BudgetSubscriptionTimePeriod(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "startDate":
            suggest = "start_date"
        elif key == "endDate":
            suggest = "end_date"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BudgetSubscriptionTimePeriod. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BudgetSubscriptionTimePeriod.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BudgetSubscriptionTimePeriod.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 start_date: _builtins.str,
                 end_date: Optional[_builtins.str] = None):
        """
        :param _builtins.str start_date: The start date for the budget. The start date must be first of the month and should be less than the end date. Budget start date must be on or after June 1, 2017. Future start date should not be more than twelve months. Past start date should be selected within the timegrain period. Changing this forces a new Subscription Consumption Budget to be created.
        :param _builtins.str end_date: The end date for the budget. If not set this will be 10 years after the start date.
        """
        pulumi.set(__self__, "start_date", start_date)
        if end_date is not None:
            pulumi.set(__self__, "end_date", end_date)

    @_builtins.property
    @pulumi.getter(name="startDate")
    def start_date(self) -> _builtins.str:
        """
        The start date for the budget. The start date must be first of the month and should be less than the end date. Budget start date must be on or after June 1, 2017. Future start date should not be more than twelve months. Past start date should be selected within the timegrain period. Changing this forces a new Subscription Consumption Budget to be created.
        """
        return pulumi.get(self, "start_date")

    @_builtins.property
    @pulumi.getter(name="endDate")
    def end_date(self) -> Optional[_builtins.str]:
        """
        The end date for the budget. If not set this will be 10 years after the start date.
        """
        return pulumi.get(self, "end_date")


@pulumi.output_type
class GetBudgetResourceGroupFilterResult(dict):
    def __init__(__self__, *,
                 dimensions: Sequence['outputs.GetBudgetResourceGroupFilterDimensionResult'],
                 nots: Sequence['outputs.GetBudgetResourceGroupFilterNotResult'],
                 tags: Sequence['outputs.GetBudgetResourceGroupFilterTagResult']):
        """
        :param Sequence['GetBudgetResourceGroupFilterDimensionArgs'] dimensions: A `dimension` block as defined below.
        :param Sequence['GetBudgetResourceGroupFilterNotArgs'] nots: A `not` block as defined below.
        :param Sequence['GetBudgetResourceGroupFilterTagArgs'] tags: A `tag` block as defined below.
        """
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "nots", nots)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Sequence['outputs.GetBudgetResourceGroupFilterDimensionResult']:
        """
        A `dimension` block as defined below.
        """
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter
    def nots(self) -> Sequence['outputs.GetBudgetResourceGroupFilterNotResult']:
        """
        A `not` block as defined below.
        """
        return pulumi.get(self, "nots")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetBudgetResourceGroupFilterTagResult']:
        """
        A `tag` block as defined below.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetBudgetResourceGroupFilterDimensionResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 operator: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: The name of this Consumption Budget.
        :param _builtins.str operator: The operator used for comparison.
        :param Sequence[_builtins.str] values: A list of values for the tag.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of this Consumption Budget.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        The operator used for comparison.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        A list of values for the tag.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetBudgetResourceGroupFilterNotResult(dict):
    def __init__(__self__, *,
                 dimensions: Sequence['outputs.GetBudgetResourceGroupFilterNotDimensionResult'],
                 tags: Sequence['outputs.GetBudgetResourceGroupFilterNotTagResult']):
        """
        :param Sequence['GetBudgetResourceGroupFilterNotDimensionArgs'] dimensions: A `dimension` block as defined below.
        :param Sequence['GetBudgetResourceGroupFilterNotTagArgs'] tags: A `tag` block as defined below.
        """
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Sequence['outputs.GetBudgetResourceGroupFilterNotDimensionResult']:
        """
        A `dimension` block as defined below.
        """
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetBudgetResourceGroupFilterNotTagResult']:
        """
        A `tag` block as defined below.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetBudgetResourceGroupFilterNotDimensionResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 operator: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: The name of this Consumption Budget.
        :param _builtins.str operator: The operator used for comparison.
        :param Sequence[_builtins.str] values: A list of values for the tag.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of this Consumption Budget.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        The operator used for comparison.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        A list of values for the tag.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetBudgetResourceGroupFilterNotTagResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 operator: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: The name of this Consumption Budget.
        :param _builtins.str operator: The operator used for comparison.
        :param Sequence[_builtins.str] values: A list of values for the tag.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of this Consumption Budget.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        The operator used for comparison.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        A list of values for the tag.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetBudgetResourceGroupFilterTagResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 operator: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: The name of this Consumption Budget.
        :param _builtins.str operator: The operator used for comparison.
        :param Sequence[_builtins.str] values: A list of values for the tag.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of this Consumption Budget.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        The operator used for comparison.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        A list of values for the tag.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetBudgetResourceGroupNotificationResult(dict):
    def __init__(__self__, *,
                 contact_emails: Sequence[_builtins.str],
                 contact_groups: Sequence[_builtins.str],
                 contact_roles: Sequence[_builtins.str],
                 enabled: _builtins.bool,
                 operator: _builtins.str,
                 threshold: _builtins.int,
                 threshold_type: _builtins.str):
        """
        :param Sequence[_builtins.str] contact_emails: A list of email addresses to send the budget notification to when the threshold is exceeded.
        :param Sequence[_builtins.str] contact_groups: A list of Action Group IDs to send the budget notification to when the threshold is exceeded.
        :param Sequence[_builtins.str] contact_roles: A list of contact roles to send the budget notification to when the threshold is exceeded.
        :param _builtins.bool enabled: Whether the notification is enabled.
        :param _builtins.str operator: The operator used for comparison.
        :param _builtins.int threshold: Threshold value associated with the notification.
        """
        pulumi.set(__self__, "contact_emails", contact_emails)
        pulumi.set(__self__, "contact_groups", contact_groups)
        pulumi.set(__self__, "contact_roles", contact_roles)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "threshold_type", threshold_type)

    @_builtins.property
    @pulumi.getter(name="contactEmails")
    def contact_emails(self) -> Sequence[_builtins.str]:
        """
        A list of email addresses to send the budget notification to when the threshold is exceeded.
        """
        return pulumi.get(self, "contact_emails")

    @_builtins.property
    @pulumi.getter(name="contactGroups")
    def contact_groups(self) -> Sequence[_builtins.str]:
        """
        A list of Action Group IDs to send the budget notification to when the threshold is exceeded.
        """
        return pulumi.get(self, "contact_groups")

    @_builtins.property
    @pulumi.getter(name="contactRoles")
    def contact_roles(self) -> Sequence[_builtins.str]:
        """
        A list of contact roles to send the budget notification to when the threshold is exceeded.
        """
        return pulumi.get(self, "contact_roles")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether the notification is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        The operator used for comparison.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> _builtins.int:
        """
        Threshold value associated with the notification.
        """
        return pulumi.get(self, "threshold")

    @_builtins.property
    @pulumi.getter(name="thresholdType")
    def threshold_type(self) -> _builtins.str:
        return pulumi.get(self, "threshold_type")


@pulumi.output_type
class GetBudgetResourceGroupTimePeriodResult(dict):
    def __init__(__self__, *,
                 end_date: _builtins.str,
                 start_date: _builtins.str):
        """
        :param _builtins.str end_date: The end date for the budget.
        :param _builtins.str start_date: The start date for the budget.
        """
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "start_date", start_date)

    @_builtins.property
    @pulumi.getter(name="endDate")
    def end_date(self) -> _builtins.str:
        """
        The end date for the budget.
        """
        return pulumi.get(self, "end_date")

    @_builtins.property
    @pulumi.getter(name="startDate")
    def start_date(self) -> _builtins.str:
        """
        The start date for the budget.
        """
        return pulumi.get(self, "start_date")


@pulumi.output_type
class GetBudgetSubscriptionFilterResult(dict):
    def __init__(__self__, *,
                 dimensions: Sequence['outputs.GetBudgetSubscriptionFilterDimensionResult'],
                 nots: Sequence['outputs.GetBudgetSubscriptionFilterNotResult'],
                 tags: Sequence['outputs.GetBudgetSubscriptionFilterTagResult']):
        """
        :param Sequence['GetBudgetSubscriptionFilterDimensionArgs'] dimensions: A `dimension` block as defined above.
        :param Sequence['GetBudgetSubscriptionFilterNotArgs'] nots: A `not` block as defined below.
        :param Sequence['GetBudgetSubscriptionFilterTagArgs'] tags: A `tag` block as defined below.
        """
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "nots", nots)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Sequence['outputs.GetBudgetSubscriptionFilterDimensionResult']:
        """
        A `dimension` block as defined above.
        """
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter
    def nots(self) -> Sequence['outputs.GetBudgetSubscriptionFilterNotResult']:
        """
        A `not` block as defined below.
        """
        return pulumi.get(self, "nots")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetBudgetSubscriptionFilterTagResult']:
        """
        A `tag` block as defined below.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetBudgetSubscriptionFilterDimensionResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 operator: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: The name of this Consumption Budget.
        :param _builtins.str operator: The operator to used for comparison.
        :param Sequence[_builtins.str] values: A list of values for the tag.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of this Consumption Budget.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        The operator to used for comparison.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        A list of values for the tag.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetBudgetSubscriptionFilterNotResult(dict):
    def __init__(__self__, *,
                 dimensions: Sequence['outputs.GetBudgetSubscriptionFilterNotDimensionResult'],
                 tags: Sequence['outputs.GetBudgetSubscriptionFilterNotTagResult']):
        """
        :param Sequence['GetBudgetSubscriptionFilterNotDimensionArgs'] dimensions: A `dimension` block as defined above.
        :param Sequence['GetBudgetSubscriptionFilterNotTagArgs'] tags: A `tag` block as defined below.
        """
        pulumi.set(__self__, "dimensions", dimensions)
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def dimensions(self) -> Sequence['outputs.GetBudgetSubscriptionFilterNotDimensionResult']:
        """
        A `dimension` block as defined above.
        """
        return pulumi.get(self, "dimensions")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.GetBudgetSubscriptionFilterNotTagResult']:
        """
        A `tag` block as defined below.
        """
        return pulumi.get(self, "tags")


@pulumi.output_type
class GetBudgetSubscriptionFilterNotDimensionResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 operator: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: The name of this Consumption Budget.
        :param _builtins.str operator: The operator to used for comparison.
        :param Sequence[_builtins.str] values: A list of values for the tag.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of this Consumption Budget.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        The operator to used for comparison.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        A list of values for the tag.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetBudgetSubscriptionFilterNotTagResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 operator: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: The name of this Consumption Budget.
        :param _builtins.str operator: The operator to used for comparison.
        :param Sequence[_builtins.str] values: A list of values for the tag.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of this Consumption Budget.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        The operator to used for comparison.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        A list of values for the tag.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetBudgetSubscriptionFilterTagResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 operator: _builtins.str,
                 values: Sequence[_builtins.str]):
        """
        :param _builtins.str name: The name of this Consumption Budget.
        :param _builtins.str operator: The operator to used for comparison.
        :param Sequence[_builtins.str] values: A list of values for the tag.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "values", values)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of this Consumption Budget.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        The operator to used for comparison.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def values(self) -> Sequence[_builtins.str]:
        """
        A list of values for the tag.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class GetBudgetSubscriptionNotificationResult(dict):
    def __init__(__self__, *,
                 contact_emails: Sequence[_builtins.str],
                 contact_groups: Sequence[_builtins.str],
                 contact_roles: Sequence[_builtins.str],
                 enabled: _builtins.bool,
                 operator: _builtins.str,
                 threshold: _builtins.int,
                 threshold_type: _builtins.str):
        """
        :param Sequence[_builtins.str] contact_emails: A list of email addresses to send the budget notification to when the threshold is exceeded.
        :param Sequence[_builtins.str] contact_groups: A list of Action Group IDs to send the budget notification to when the threshold is exceeded.
        :param Sequence[_builtins.str] contact_roles: A list of contact roles to send the budget notification to when the threshold is exceeded.
        :param _builtins.bool enabled: Whether the notification is enabled.
        :param _builtins.str operator: The operator to used for comparison.
        :param _builtins.int threshold: Threshold value associated with the notification.
        """
        pulumi.set(__self__, "contact_emails", contact_emails)
        pulumi.set(__self__, "contact_groups", contact_groups)
        pulumi.set(__self__, "contact_roles", contact_roles)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "operator", operator)
        pulumi.set(__self__, "threshold", threshold)
        pulumi.set(__self__, "threshold_type", threshold_type)

    @_builtins.property
    @pulumi.getter(name="contactEmails")
    def contact_emails(self) -> Sequence[_builtins.str]:
        """
        A list of email addresses to send the budget notification to when the threshold is exceeded.
        """
        return pulumi.get(self, "contact_emails")

    @_builtins.property
    @pulumi.getter(name="contactGroups")
    def contact_groups(self) -> Sequence[_builtins.str]:
        """
        A list of Action Group IDs to send the budget notification to when the threshold is exceeded.
        """
        return pulumi.get(self, "contact_groups")

    @_builtins.property
    @pulumi.getter(name="contactRoles")
    def contact_roles(self) -> Sequence[_builtins.str]:
        """
        A list of contact roles to send the budget notification to when the threshold is exceeded.
        """
        return pulumi.get(self, "contact_roles")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Whether the notification is enabled.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def operator(self) -> _builtins.str:
        """
        The operator to used for comparison.
        """
        return pulumi.get(self, "operator")

    @_builtins.property
    @pulumi.getter
    def threshold(self) -> _builtins.int:
        """
        Threshold value associated with the notification.
        """
        return pulumi.get(self, "threshold")

    @_builtins.property
    @pulumi.getter(name="thresholdType")
    def threshold_type(self) -> _builtins.str:
        return pulumi.get(self, "threshold_type")


@pulumi.output_type
class GetBudgetSubscriptionTimePeriodResult(dict):
    def __init__(__self__, *,
                 end_date: _builtins.str,
                 start_date: _builtins.str):
        """
        :param _builtins.str end_date: The end date for the budget.
        :param _builtins.str start_date: The start date for the budget.
        """
        pulumi.set(__self__, "end_date", end_date)
        pulumi.set(__self__, "start_date", start_date)

    @_builtins.property
    @pulumi.getter(name="endDate")
    def end_date(self) -> _builtins.str:
        """
        The end date for the budget.
        """
        return pulumi.get(self, "end_date")

    @_builtins.property
    @pulumi.getter(name="startDate")
    def start_date(self) -> _builtins.str:
        """
        The start date for the budget.
        """
        return pulumi.get(self, "start_date")


