# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['FleetMemberArgs', 'FleetMember']

@pulumi.input_type
class FleetMemberArgs:
    def __init__(__self__, *,
                 kubernetes_cluster_id: pulumi.Input[_builtins.str],
                 kubernetes_fleet_id: pulumi.Input[_builtins.str],
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FleetMember resource.
        :param pulumi.Input[_builtins.str] kubernetes_cluster_id: The ARM resource ID of the cluster that joins the Fleet. Changing this forces a new Kubernetes Fleet Member to be created.
        :param pulumi.Input[_builtins.str] kubernetes_fleet_id: Specifies the Kubernetes Fleet Id within which this Kubernetes Fleet Member should exist. Changing this forces a new Kubernetes Fleet Member to be created.
        :param pulumi.Input[_builtins.str] group: The group this member belongs to for multi-cluster update management.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Kubernetes Fleet Member. Changing this forces a new Kubernetes Fleet Member to be created.
        """
        pulumi.set(__self__, "kubernetes_cluster_id", kubernetes_cluster_id)
        pulumi.set(__self__, "kubernetes_fleet_id", kubernetes_fleet_id)
        if group is not None:
            pulumi.set(__self__, "group", group)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="kubernetesClusterId")
    def kubernetes_cluster_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ARM resource ID of the cluster that joins the Fleet. Changing this forces a new Kubernetes Fleet Member to be created.
        """
        return pulumi.get(self, "kubernetes_cluster_id")

    @kubernetes_cluster_id.setter
    def kubernetes_cluster_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kubernetes_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="kubernetesFleetId")
    def kubernetes_fleet_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Kubernetes Fleet Id within which this Kubernetes Fleet Member should exist. Changing this forces a new Kubernetes Fleet Member to be created.
        """
        return pulumi.get(self, "kubernetes_fleet_id")

    @kubernetes_fleet_id.setter
    def kubernetes_fleet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "kubernetes_fleet_id", value)

    @_builtins.property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The group this member belongs to for multi-cluster update management.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Kubernetes Fleet Member. Changing this forces a new Kubernetes Fleet Member to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _FleetMemberState:
    def __init__(__self__, *,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FleetMember resources.
        :param pulumi.Input[_builtins.str] group: The group this member belongs to for multi-cluster update management.
        :param pulumi.Input[_builtins.str] kubernetes_cluster_id: The ARM resource ID of the cluster that joins the Fleet. Changing this forces a new Kubernetes Fleet Member to be created.
        :param pulumi.Input[_builtins.str] kubernetes_fleet_id: Specifies the Kubernetes Fleet Id within which this Kubernetes Fleet Member should exist. Changing this forces a new Kubernetes Fleet Member to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Kubernetes Fleet Member. Changing this forces a new Kubernetes Fleet Member to be created.
        """
        if group is not None:
            pulumi.set(__self__, "group", group)
        if kubernetes_cluster_id is not None:
            pulumi.set(__self__, "kubernetes_cluster_id", kubernetes_cluster_id)
        if kubernetes_fleet_id is not None:
            pulumi.set(__self__, "kubernetes_fleet_id", kubernetes_fleet_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def group(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The group this member belongs to for multi-cluster update management.
        """
        return pulumi.get(self, "group")

    @group.setter
    def group(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "group", value)

    @_builtins.property
    @pulumi.getter(name="kubernetesClusterId")
    def kubernetes_cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ARM resource ID of the cluster that joins the Fleet. Changing this forces a new Kubernetes Fleet Member to be created.
        """
        return pulumi.get(self, "kubernetes_cluster_id")

    @kubernetes_cluster_id.setter
    def kubernetes_cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kubernetes_cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="kubernetesFleetId")
    def kubernetes_fleet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Kubernetes Fleet Id within which this Kubernetes Fleet Member should exist. Changing this forces a new Kubernetes Fleet Member to be created.
        """
        return pulumi.get(self, "kubernetes_fleet_id")

    @kubernetes_fleet_id.setter
    def kubernetes_fleet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kubernetes_fleet_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of this Kubernetes Fleet Member. Changing this forces a new Kubernetes Fleet Member to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("azure:containerservice/fleetMember:FleetMember")
class FleetMember(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        <!-- Note: This documentation is generated. Any manual changes will be overwritten -->

        Manages a Kubernetes Fleet Member.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example = azure.containerservice.KubernetesCluster("example",
            name="example",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            dns_prefix="acctestaksexample",
            default_node_pool={
                "name": "example-value",
                "node_count": "example-value",
                "vm_size": "example-value",
                "upgrade_settings": {
                    "max_surge": "example-value",
                },
            },
            identity={
                "type": "example-value",
            })
        example_kubernetes_fleet_manager = azure.containerservice.KubernetesFleetManager("example",
            name="example",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name)
        example_fleet_member = azure.containerservice.FleetMember("example",
            kubernetes_cluster_id=example.id,
            kubernetes_fleet_id=example_kubernetes_fleet_manager.id,
            name="example")
        ```

        ## Import

        An existing Kubernetes Fleet Member can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/fleetMember:FleetMember example /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/fleets/{fleetName}/members/{memberName}
        ```

        * Where `{subscriptionId}` is the ID of the Azure Subscription where the Kubernetes Fleet Member exists. For example `12345678-1234-9876-4563-123456789012`.

        * Where `{resourceGroupName}` is the name of Resource Group where this Kubernetes Fleet Member exists. For example `example-resource-group`.

        * Where `{fleetName}` is the name of the Fleet. For example `fleetValue`.

        * Where `{memberName}` is the name of the Member. For example `memberValue`.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group: The group this member belongs to for multi-cluster update management.
        :param pulumi.Input[_builtins.str] kubernetes_cluster_id: The ARM resource ID of the cluster that joins the Fleet. Changing this forces a new Kubernetes Fleet Member to be created.
        :param pulumi.Input[_builtins.str] kubernetes_fleet_id: Specifies the Kubernetes Fleet Id within which this Kubernetes Fleet Member should exist. Changing this forces a new Kubernetes Fleet Member to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Kubernetes Fleet Member. Changing this forces a new Kubernetes Fleet Member to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FleetMemberArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        <!-- Note: This documentation is generated. Any manual changes will be overwritten -->

        Manages a Kubernetes Fleet Member.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example = azure.containerservice.KubernetesCluster("example",
            name="example",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name,
            dns_prefix="acctestaksexample",
            default_node_pool={
                "name": "example-value",
                "node_count": "example-value",
                "vm_size": "example-value",
                "upgrade_settings": {
                    "max_surge": "example-value",
                },
            },
            identity={
                "type": "example-value",
            })
        example_kubernetes_fleet_manager = azure.containerservice.KubernetesFleetManager("example",
            name="example",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name)
        example_fleet_member = azure.containerservice.FleetMember("example",
            kubernetes_cluster_id=example.id,
            kubernetes_fleet_id=example_kubernetes_fleet_manager.id,
            name="example")
        ```

        ## Import

        An existing Kubernetes Fleet Member can be imported into Pulumi using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:containerservice/fleetMember:FleetMember example /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ContainerService/fleets/{fleetName}/members/{memberName}
        ```

        * Where `{subscriptionId}` is the ID of the Azure Subscription where the Kubernetes Fleet Member exists. For example `12345678-1234-9876-4563-123456789012`.

        * Where `{resourceGroupName}` is the name of Resource Group where this Kubernetes Fleet Member exists. For example `example-resource-group`.

        * Where `{fleetName}` is the name of the Fleet. For example `fleetValue`.

        * Where `{memberName}` is the name of the Member. For example `memberValue`.

        :param str resource_name: The name of the resource.
        :param FleetMemberArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FleetMemberArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 group: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kubernetes_fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FleetMemberArgs.__new__(FleetMemberArgs)

            __props__.__dict__["group"] = group
            if kubernetes_cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'kubernetes_cluster_id'")
            __props__.__dict__["kubernetes_cluster_id"] = kubernetes_cluster_id
            if kubernetes_fleet_id is None and not opts.urn:
                raise TypeError("Missing required property 'kubernetes_fleet_id'")
            __props__.__dict__["kubernetes_fleet_id"] = kubernetes_fleet_id
            __props__.__dict__["name"] = name
        super(FleetMember, __self__).__init__(
            'azure:containerservice/fleetMember:FleetMember',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            group: Optional[pulumi.Input[_builtins.str]] = None,
            kubernetes_cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            kubernetes_fleet_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'FleetMember':
        """
        Get an existing FleetMember resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] group: The group this member belongs to for multi-cluster update management.
        :param pulumi.Input[_builtins.str] kubernetes_cluster_id: The ARM resource ID of the cluster that joins the Fleet. Changing this forces a new Kubernetes Fleet Member to be created.
        :param pulumi.Input[_builtins.str] kubernetes_fleet_id: Specifies the Kubernetes Fleet Id within which this Kubernetes Fleet Member should exist. Changing this forces a new Kubernetes Fleet Member to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of this Kubernetes Fleet Member. Changing this forces a new Kubernetes Fleet Member to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FleetMemberState.__new__(_FleetMemberState)

        __props__.__dict__["group"] = group
        __props__.__dict__["kubernetes_cluster_id"] = kubernetes_cluster_id
        __props__.__dict__["kubernetes_fleet_id"] = kubernetes_fleet_id
        __props__.__dict__["name"] = name
        return FleetMember(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def group(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The group this member belongs to for multi-cluster update management.
        """
        return pulumi.get(self, "group")

    @_builtins.property
    @pulumi.getter(name="kubernetesClusterId")
    def kubernetes_cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ARM resource ID of the cluster that joins the Fleet. Changing this forces a new Kubernetes Fleet Member to be created.
        """
        return pulumi.get(self, "kubernetes_cluster_id")

    @_builtins.property
    @pulumi.getter(name="kubernetesFleetId")
    def kubernetes_fleet_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Kubernetes Fleet Id within which this Kubernetes Fleet Member should exist. Changing this forces a new Kubernetes Fleet Member to be created.
        """
        return pulumi.get(self, "kubernetes_fleet_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of this Kubernetes Fleet Member. Changing this forces a new Kubernetes Fleet Member to be created.
        """
        return pulumi.get(self, "name")

