# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetKubernetesServiceVersionsResult',
    'AwaitableGetKubernetesServiceVersionsResult',
    'get_kubernetes_service_versions',
    'get_kubernetes_service_versions_output',
]

@pulumi.output_type
class GetKubernetesServiceVersionsResult:
    """
    A collection of values returned by getKubernetesServiceVersions.
    """
    def __init__(__self__, default_version=None, id=None, include_preview=None, latest_version=None, location=None, version_prefix=None, versions=None):
        if default_version and not isinstance(default_version, str):
            raise TypeError("Expected argument 'default_version' to be a str")
        pulumi.set(__self__, "default_version", default_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if include_preview and not isinstance(include_preview, bool):
            raise TypeError("Expected argument 'include_preview' to be a bool")
        pulumi.set(__self__, "include_preview", include_preview)
        if latest_version and not isinstance(latest_version, str):
            raise TypeError("Expected argument 'latest_version' to be a str")
        pulumi.set(__self__, "latest_version", latest_version)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if version_prefix and not isinstance(version_prefix, str):
            raise TypeError("Expected argument 'version_prefix' to be a str")
        pulumi.set(__self__, "version_prefix", version_prefix)
        if versions and not isinstance(versions, list):
            raise TypeError("Expected argument 'versions' to be a list")
        pulumi.set(__self__, "versions", versions)

    @_builtins.property
    @pulumi.getter(name="defaultVersion")
    def default_version(self) -> _builtins.str:
        """
        The N-1 minor non-preview version and latest patch.
        """
        return pulumi.get(self, "default_version")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="includePreview")
    def include_preview(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "include_preview")

    @_builtins.property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> _builtins.str:
        """
        The most recent version available. If `include_preview == false`, this is the most recent non-preview version available.
        """
        return pulumi.get(self, "latest_version")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="versionPrefix")
    def version_prefix(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "version_prefix")

    @_builtins.property
    @pulumi.getter
    def versions(self) -> Sequence[_builtins.str]:
        """
        The list of all supported versions.
        """
        return pulumi.get(self, "versions")


class AwaitableGetKubernetesServiceVersionsResult(GetKubernetesServiceVersionsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetKubernetesServiceVersionsResult(
            default_version=self.default_version,
            id=self.id,
            include_preview=self.include_preview,
            latest_version=self.latest_version,
            location=self.location,
            version_prefix=self.version_prefix,
            versions=self.versions)


def get_kubernetes_service_versions(include_preview: Optional[_builtins.bool] = None,
                                    location: Optional[_builtins.str] = None,
                                    version_prefix: Optional[_builtins.str] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetKubernetesServiceVersionsResult:
    """
    Use this data source to retrieve the version of Kubernetes supported by Azure Kubernetes Service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    current = azure.containerservice.get_kubernetes_service_versions(location="West Europe")
    pulumi.export("versions", current.versions)
    pulumi.export("latestVersion", current.latest_version)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ContainerService` - 2019-08-01


    :param _builtins.bool include_preview: Should Preview versions of Kubernetes in AKS be included? Defaults to `true`
    :param _builtins.str location: Specifies the location in which to query for versions.
    :param _builtins.str version_prefix: A prefix filter for the versions of Kubernetes which should be returned; for example `1.` will return `1.9` to `1.14`, whereas `1.12` will return `1.12.2`.
    """
    __args__ = dict()
    __args__['includePreview'] = include_preview
    __args__['location'] = location
    __args__['versionPrefix'] = version_prefix
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:containerservice/getKubernetesServiceVersions:getKubernetesServiceVersions', __args__, opts=opts, typ=GetKubernetesServiceVersionsResult).value

    return AwaitableGetKubernetesServiceVersionsResult(
        default_version=pulumi.get(__ret__, 'default_version'),
        id=pulumi.get(__ret__, 'id'),
        include_preview=pulumi.get(__ret__, 'include_preview'),
        latest_version=pulumi.get(__ret__, 'latest_version'),
        location=pulumi.get(__ret__, 'location'),
        version_prefix=pulumi.get(__ret__, 'version_prefix'),
        versions=pulumi.get(__ret__, 'versions'))
def get_kubernetes_service_versions_output(include_preview: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                                           location: Optional[pulumi.Input[_builtins.str]] = None,
                                           version_prefix: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                           opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetKubernetesServiceVersionsResult]:
    """
    Use this data source to retrieve the version of Kubernetes supported by Azure Kubernetes Service.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    current = azure.containerservice.get_kubernetes_service_versions(location="West Europe")
    pulumi.export("versions", current.versions)
    pulumi.export("latestVersion", current.latest_version)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.ContainerService` - 2019-08-01


    :param _builtins.bool include_preview: Should Preview versions of Kubernetes in AKS be included? Defaults to `true`
    :param _builtins.str location: Specifies the location in which to query for versions.
    :param _builtins.str version_prefix: A prefix filter for the versions of Kubernetes which should be returned; for example `1.` will return `1.9` to `1.14`, whereas `1.12` will return `1.12.2`.
    """
    __args__ = dict()
    __args__['includePreview'] = include_preview
    __args__['location'] = location
    __args__['versionPrefix'] = version_prefix
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:containerservice/getKubernetesServiceVersions:getKubernetesServiceVersions', __args__, opts=opts, typ=GetKubernetesServiceVersionsResult)
    return __ret__.apply(lambda __response__: GetKubernetesServiceVersionsResult(
        default_version=pulumi.get(__response__, 'default_version'),
        id=pulumi.get(__response__, 'id'),
        include_preview=pulumi.get(__response__, 'include_preview'),
        latest_version=pulumi.get(__response__, 'latest_version'),
        location=pulumi.get(__response__, 'location'),
        version_prefix=pulumi.get(__response__, 'version_prefix'),
        versions=pulumi.get(__response__, 'versions')))
