# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['SqlStoredProcedureArgs', 'SqlStoredProcedure']

@pulumi.input_type
class SqlStoredProcedureArgs:
    def __init__(__self__, *,
                 account_name: pulumi.Input[_builtins.str],
                 body: pulumi.Input[_builtins.str],
                 container_name: pulumi.Input[_builtins.str],
                 database_name: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SqlStoredProcedure resource.
        :param pulumi.Input[_builtins.str] account_name: The name of the Cosmos DB Account to create the stored procedure within. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] body: The body of the stored procedure.
        :param pulumi.Input[_builtins.str] container_name: The name of the Cosmos DB SQL Container to create the stored procedure within. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] database_name: The name of the Cosmos DB SQL Database to create the stored procedure within. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Cosmos DB SQL Database is created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Cosmos DB SQL Stored Procedure. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "body", body)
        pulumi.set(__self__, "container_name", container_name)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Cosmos DB Account to create the stored procedure within. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter
    def body(self) -> pulumi.Input[_builtins.str]:
        """
        The body of the stored procedure.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "body", value)

    @_builtins.property
    @pulumi.getter(name="containerName")
    def container_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Cosmos DB SQL Container to create the stored procedure within. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "container_name", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Cosmos DB SQL Database to create the stored procedure within. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which the Cosmos DB SQL Database is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Cosmos DB SQL Stored Procedure. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _SqlStoredProcedureState:
    def __init__(__self__, *,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 body: Optional[pulumi.Input[_builtins.str]] = None,
                 container_name: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SqlStoredProcedure resources.
        :param pulumi.Input[_builtins.str] account_name: The name of the Cosmos DB Account to create the stored procedure within. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] body: The body of the stored procedure.
        :param pulumi.Input[_builtins.str] container_name: The name of the Cosmos DB SQL Container to create the stored procedure within. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] database_name: The name of the Cosmos DB SQL Database to create the stored procedure within. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Cosmos DB SQL Stored Procedure. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Cosmos DB SQL Database is created. Changing this forces a new resource to be created.
        """
        if account_name is not None:
            pulumi.set(__self__, "account_name", account_name)
        if body is not None:
            pulumi.set(__self__, "body", body)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Cosmos DB Account to create the stored procedure within. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @account_name.setter
    def account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "account_name", value)

    @_builtins.property
    @pulumi.getter
    def body(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The body of the stored procedure.
        """
        return pulumi.get(self, "body")

    @body.setter
    def body(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "body", value)

    @_builtins.property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Cosmos DB SQL Container to create the stored procedure within. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_name", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Cosmos DB SQL Database to create the stored procedure within. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Cosmos DB SQL Stored Procedure. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which the Cosmos DB SQL Database is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)


@pulumi.type_token("azure:cosmosdb/sqlStoredProcedure:SqlStoredProcedure")
class SqlStoredProcedure(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 body: Optional[pulumi.Input[_builtins.str]] = None,
                 container_name: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a SQL Stored Procedure within a Cosmos DB Account SQL Database.

        ## Import

        CosmosDB SQL Stored Procedures can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cosmosdb/sqlStoredProcedure:SqlStoredProcedure db1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DocumentDB/databaseAccounts/account1/sqlDatabases/db1/containers/c1/storedProcedures/sp1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_name: The name of the Cosmos DB Account to create the stored procedure within. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] body: The body of the stored procedure.
        :param pulumi.Input[_builtins.str] container_name: The name of the Cosmos DB SQL Container to create the stored procedure within. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] database_name: The name of the Cosmos DB SQL Database to create the stored procedure within. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Cosmos DB SQL Stored Procedure. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Cosmos DB SQL Database is created. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SqlStoredProcedureArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a SQL Stored Procedure within a Cosmos DB Account SQL Database.

        ## Import

        CosmosDB SQL Stored Procedures can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:cosmosdb/sqlStoredProcedure:SqlStoredProcedure db1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/rg1/providers/Microsoft.DocumentDB/databaseAccounts/account1/sqlDatabases/db1/containers/c1/storedProcedures/sp1
        ```

        :param str resource_name: The name of the resource.
        :param SqlStoredProcedureArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SqlStoredProcedureArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 body: Optional[pulumi.Input[_builtins.str]] = None,
                 container_name: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SqlStoredProcedureArgs.__new__(SqlStoredProcedureArgs)

            if account_name is None and not opts.urn:
                raise TypeError("Missing required property 'account_name'")
            __props__.__dict__["account_name"] = account_name
            if body is None and not opts.urn:
                raise TypeError("Missing required property 'body'")
            __props__.__dict__["body"] = body
            if container_name is None and not opts.urn:
                raise TypeError("Missing required property 'container_name'")
            __props__.__dict__["container_name"] = container_name
            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
        super(SqlStoredProcedure, __self__).__init__(
            'azure:cosmosdb/sqlStoredProcedure:SqlStoredProcedure',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_name: Optional[pulumi.Input[_builtins.str]] = None,
            body: Optional[pulumi.Input[_builtins.str]] = None,
            container_name: Optional[pulumi.Input[_builtins.str]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None) -> 'SqlStoredProcedure':
        """
        Get an existing SqlStoredProcedure resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] account_name: The name of the Cosmos DB Account to create the stored procedure within. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] body: The body of the stored procedure.
        :param pulumi.Input[_builtins.str] container_name: The name of the Cosmos DB SQL Container to create the stored procedure within. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] database_name: The name of the Cosmos DB SQL Database to create the stored procedure within. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Cosmos DB SQL Stored Procedure. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Cosmos DB SQL Database is created. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SqlStoredProcedureState.__new__(_SqlStoredProcedureState)

        __props__.__dict__["account_name"] = account_name
        __props__.__dict__["body"] = body
        __props__.__dict__["container_name"] = container_name
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        return SqlStoredProcedure(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accountName")
    def account_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Cosmos DB Account to create the stored procedure within. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "account_name")

    @_builtins.property
    @pulumi.getter
    def body(self) -> pulumi.Output[_builtins.str]:
        """
        The body of the stored procedure.
        """
        return pulumi.get(self, "body")

    @_builtins.property
    @pulumi.getter(name="containerName")
    def container_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Cosmos DB SQL Container to create the stored procedure within. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "container_name")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Cosmos DB SQL Database to create the stored procedure within. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Cosmos DB SQL Stored Procedure. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which the Cosmos DB SQL Database is created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

