# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'DeviceDeviceProperty',
    'GetDeviceDevicePropertyResult',
]

@pulumi.output_type
class DeviceDeviceProperty(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configuredRoleTypes":
            suggest = "configured_role_types"
        elif key == "hcsVersion":
            suggest = "hcs_version"
        elif key == "nodeCount":
            suggest = "node_count"
        elif key == "serialNumber":
            suggest = "serial_number"
        elif key == "softwareVersion":
            suggest = "software_version"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DeviceDeviceProperty. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DeviceDeviceProperty.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DeviceDeviceProperty.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity: Optional[_builtins.int] = None,
                 configured_role_types: Optional[Sequence[_builtins.str]] = None,
                 culture: Optional[_builtins.str] = None,
                 hcs_version: Optional[_builtins.str] = None,
                 model: Optional[_builtins.str] = None,
                 node_count: Optional[_builtins.int] = None,
                 serial_number: Optional[_builtins.str] = None,
                 software_version: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 time_zone: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.int capacity: The Data Box Edge/Gateway device local capacity in MB.
        :param Sequence[_builtins.str] configured_role_types: Type of compute roles configured.
        :param _builtins.str culture: The Data Box Edge/Gateway device culture.
        :param _builtins.str hcs_version: The device software version number of the device (e.g. 1.2.18105.6).
        :param _builtins.str model: The Data Box Edge/Gateway device model.
        :param _builtins.int node_count: The number of nodes in the cluster.
        :param _builtins.str serial_number: The Serial Number of Data Box Edge/Gateway device.
        :param _builtins.str software_version: The Data Box Edge/Gateway device software version.
        :param _builtins.str status: The status of the Data Box Edge/Gateway device.
        :param _builtins.str time_zone: The Data Box Edge/Gateway device timezone.
        :param _builtins.str type: The type of the Data Box Edge/Gateway device.
        """
        if capacity is not None:
            pulumi.set(__self__, "capacity", capacity)
        if configured_role_types is not None:
            pulumi.set(__self__, "configured_role_types", configured_role_types)
        if culture is not None:
            pulumi.set(__self__, "culture", culture)
        if hcs_version is not None:
            pulumi.set(__self__, "hcs_version", hcs_version)
        if model is not None:
            pulumi.set(__self__, "model", model)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if software_version is not None:
            pulumi.set(__self__, "software_version", software_version)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> Optional[_builtins.int]:
        """
        The Data Box Edge/Gateway device local capacity in MB.
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter(name="configuredRoleTypes")
    def configured_role_types(self) -> Optional[Sequence[_builtins.str]]:
        """
        Type of compute roles configured.
        """
        return pulumi.get(self, "configured_role_types")

    @_builtins.property
    @pulumi.getter
    def culture(self) -> Optional[_builtins.str]:
        """
        The Data Box Edge/Gateway device culture.
        """
        return pulumi.get(self, "culture")

    @_builtins.property
    @pulumi.getter(name="hcsVersion")
    def hcs_version(self) -> Optional[_builtins.str]:
        """
        The device software version number of the device (e.g. 1.2.18105.6).
        """
        return pulumi.get(self, "hcs_version")

    @_builtins.property
    @pulumi.getter
    def model(self) -> Optional[_builtins.str]:
        """
        The Data Box Edge/Gateway device model.
        """
        return pulumi.get(self, "model")

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[_builtins.int]:
        """
        The number of nodes in the cluster.
        """
        return pulumi.get(self, "node_count")

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[_builtins.str]:
        """
        The Serial Number of Data Box Edge/Gateway device.
        """
        return pulumi.get(self, "serial_number")

    @_builtins.property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> Optional[_builtins.str]:
        """
        The Data Box Edge/Gateway device software version.
        """
        return pulumi.get(self, "software_version")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The status of the Data Box Edge/Gateway device.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[_builtins.str]:
        """
        The Data Box Edge/Gateway device timezone.
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        The type of the Data Box Edge/Gateway device.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDeviceDevicePropertyResult(dict):
    def __init__(__self__, *,
                 capacity: _builtins.int,
                 configured_role_types: Sequence[_builtins.str],
                 culture: _builtins.str,
                 hcs_version: _builtins.str,
                 model: _builtins.str,
                 node_count: _builtins.int,
                 serial_number: _builtins.str,
                 software_version: _builtins.str,
                 status: _builtins.str,
                 time_zone: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.int capacity: The Data Box Edge/Gateway device local capacity in MB.
        :param Sequence[_builtins.str] configured_role_types: Type of compute roles configured.
        :param _builtins.str culture: The Data Box Edge/Gateway device culture.
        :param _builtins.str hcs_version: The device software version number of the device (e.g. 1.2.18105.6).
        :param _builtins.str model: The Data Box Edge/Gateway device model.
        :param _builtins.int node_count: The number of nodes in the cluster.
        :param _builtins.str serial_number: The Serial Number of Data Box Edge/Gateway device.
        :param _builtins.str software_version: The Data Box Edge/Gateway device software version.
        :param _builtins.str status: The status of the Data Box Edge/Gateway device.
        :param _builtins.str time_zone: The Data Box Edge/Gateway device timezone.
        :param _builtins.str type: The type of the Data Box Edge/Gateway device.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "configured_role_types", configured_role_types)
        pulumi.set(__self__, "culture", culture)
        pulumi.set(__self__, "hcs_version", hcs_version)
        pulumi.set(__self__, "model", model)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "serial_number", serial_number)
        pulumi.set(__self__, "software_version", software_version)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> _builtins.int:
        """
        The Data Box Edge/Gateway device local capacity in MB.
        """
        return pulumi.get(self, "capacity")

    @_builtins.property
    @pulumi.getter(name="configuredRoleTypes")
    def configured_role_types(self) -> Sequence[_builtins.str]:
        """
        Type of compute roles configured.
        """
        return pulumi.get(self, "configured_role_types")

    @_builtins.property
    @pulumi.getter
    def culture(self) -> _builtins.str:
        """
        The Data Box Edge/Gateway device culture.
        """
        return pulumi.get(self, "culture")

    @_builtins.property
    @pulumi.getter(name="hcsVersion")
    def hcs_version(self) -> _builtins.str:
        """
        The device software version number of the device (e.g. 1.2.18105.6).
        """
        return pulumi.get(self, "hcs_version")

    @_builtins.property
    @pulumi.getter
    def model(self) -> _builtins.str:
        """
        The Data Box Edge/Gateway device model.
        """
        return pulumi.get(self, "model")

    @_builtins.property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> _builtins.int:
        """
        The number of nodes in the cluster.
        """
        return pulumi.get(self, "node_count")

    @_builtins.property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> _builtins.str:
        """
        The Serial Number of Data Box Edge/Gateway device.
        """
        return pulumi.get(self, "serial_number")

    @_builtins.property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> _builtins.str:
        """
        The Data Box Edge/Gateway device software version.
        """
        return pulumi.get(self, "software_version")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The status of the Data Box Edge/Gateway device.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> _builtins.str:
        """
        The Data Box Edge/Gateway device timezone.
        """
        return pulumi.get(self, "time_zone")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the Data Box Edge/Gateway device.
        """
        return pulumi.get(self, "type")


