# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CustomDatasetArgs', 'CustomDataset']

@pulumi.input_type
class CustomDatasetArgs:
    def __init__(__self__, *,
                 data_factory_id: pulumi.Input[_builtins.str],
                 linked_service: pulumi.Input['CustomDatasetLinkedServiceArgs'],
                 type: pulumi.Input[_builtins.str],
                 type_properties_json: pulumi.Input[_builtins.str],
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 schema_json: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a CustomDataset resource.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Dataset with. Changing this forces a new resource.
        :param pulumi.Input['CustomDatasetLinkedServiceArgs'] linked_service: A `linked_service` block as defined below.
        :param pulumi.Input[_builtins.str] type: The type of dataset that will be associated with Data Factory. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type_properties_json: A JSON object that contains the properties of the Data Factory Dataset.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Dataset.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Dataset.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Dataset.
        :param pulumi.Input[_builtins.str] folder: The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Dataset. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Dataset.
        :param pulumi.Input[_builtins.str] schema_json: A JSON object that contains the schema of the Data Factory Dataset.
        """
        pulumi.set(__self__, "data_factory_id", data_factory_id)
        pulumi.set(__self__, "linked_service", linked_service)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "type_properties_json", type_properties_json)
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if schema_json is not None:
            pulumi.set(__self__, "schema_json", schema_json)

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Data Factory ID in which to associate the Dataset with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_factory_id", value)

    @_builtins.property
    @pulumi.getter(name="linkedService")
    def linked_service(self) -> pulumi.Input['CustomDatasetLinkedServiceArgs']:
        """
        A `linked_service` block as defined below.
        """
        return pulumi.get(self, "linked_service")

    @linked_service.setter
    def linked_service(self, value: pulumi.Input['CustomDatasetLinkedServiceArgs']):
        pulumi.set(self, "linked_service", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of dataset that will be associated with Data Factory. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="typePropertiesJson")
    def type_properties_json(self) -> pulumi.Input[_builtins.str]:
        """
        A JSON object that contains the properties of the Data Factory Dataset.
        """
        return pulumi.get(self, "type_properties_json")

    @type_properties_json.setter
    def type_properties_json(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type_properties_json", value)

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of additional properties to associate with the Data Factory Dataset.
        """
        return pulumi.get(self, "additional_properties")

    @additional_properties.setter
    def additional_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_properties", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags that can be used for describing the Data Factory Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the Data Factory Dataset.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Data Factory Dataset. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of parameters to associate with the Data Factory Dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="schemaJson")
    def schema_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A JSON object that contains the schema of the Data Factory Dataset.
        """
        return pulumi.get(self, "schema_json")

    @schema_json.setter
    def schema_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_json", value)


@pulumi.input_type
class _CustomDatasetState:
    def __init__(__self__, *,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 linked_service: Optional[pulumi.Input['CustomDatasetLinkedServiceArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 schema_json: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 type_properties_json: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering CustomDataset resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Dataset.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Dataset.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Dataset with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Dataset.
        :param pulumi.Input[_builtins.str] folder: The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        :param pulumi.Input['CustomDatasetLinkedServiceArgs'] linked_service: A `linked_service` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Dataset. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Dataset.
        :param pulumi.Input[_builtins.str] schema_json: A JSON object that contains the schema of the Data Factory Dataset.
        :param pulumi.Input[_builtins.str] type: The type of dataset that will be associated with Data Factory. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type_properties_json: A JSON object that contains the properties of the Data Factory Dataset.
        """
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if data_factory_id is not None:
            pulumi.set(__self__, "data_factory_id", data_factory_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if folder is not None:
            pulumi.set(__self__, "folder", folder)
        if linked_service is not None:
            pulumi.set(__self__, "linked_service", linked_service)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if schema_json is not None:
            pulumi.set(__self__, "schema_json", schema_json)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if type_properties_json is not None:
            pulumi.set(__self__, "type_properties_json", type_properties_json)

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of additional properties to associate with the Data Factory Dataset.
        """
        return pulumi.get(self, "additional_properties")

    @additional_properties.setter
    def additional_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_properties", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags that can be used for describing the Data Factory Dataset.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Data Factory ID in which to associate the Dataset with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_factory_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the Data Factory Dataset.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def folder(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        """
        return pulumi.get(self, "folder")

    @folder.setter
    def folder(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "folder", value)

    @_builtins.property
    @pulumi.getter(name="linkedService")
    def linked_service(self) -> Optional[pulumi.Input['CustomDatasetLinkedServiceArgs']]:
        """
        A `linked_service` block as defined below.
        """
        return pulumi.get(self, "linked_service")

    @linked_service.setter
    def linked_service(self, value: Optional[pulumi.Input['CustomDatasetLinkedServiceArgs']]):
        pulumi.set(self, "linked_service", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Data Factory Dataset. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of parameters to associate with the Data Factory Dataset.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="schemaJson")
    def schema_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A JSON object that contains the schema of the Data Factory Dataset.
        """
        return pulumi.get(self, "schema_json")

    @schema_json.setter
    def schema_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_json", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of dataset that will be associated with Data Factory. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="typePropertiesJson")
    def type_properties_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A JSON object that contains the properties of the Data Factory Dataset.
        """
        return pulumi.get(self, "type_properties_json")

    @type_properties_json.setter
    def type_properties_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type_properties_json", value)


@pulumi.type_token("azure:datafactory/customDataset:CustomDataset")
class CustomDataset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 linked_service: Optional[pulumi.Input[Union['CustomDatasetLinkedServiceArgs', 'CustomDatasetLinkedServiceArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 schema_json: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 type_properties_json: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Dataset inside an Azure Data Factory. This is a generic resource that supports all different Dataset Types.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_factory = azure.datafactory.Factory("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            identity={
                "type": "SystemAssigned",
            })
        example_account = azure.storage.Account("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            account_kind="BlobStorage",
            account_tier="Standard",
            account_replication_type="LRS")
        example_linked_custom_service = azure.datafactory.LinkedCustomService("example",
            name="example",
            data_factory_id=example_factory.id,
            type="AzureBlobStorage",
            type_properties_json=example_account.primary_connection_string.apply(lambda primary_connection_string: f\"\"\"{{
          "connectionString":"{primary_connection_string}"
        }}
        \"\"\"))
        example_container = azure.storage.Container("example",
            name="content",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_custom_dataset = azure.datafactory.CustomDataset("example",
            name="example",
            data_factory_id=example_factory.id,
            type="Json",
            linked_service={
                "name": example_linked_custom_service.name,
                "parameters": {
                    "key1": "value1",
                },
            },
            type_properties_json=example_container.name.apply(lambda name: f\"\"\"{{
          "location": {{
            "container":"{name}",
            "fileName":"foo.txt",
            "folderPath": "foo/bar/",
            "type":"AzureBlobStorageLocation"
          }},
          "encodingName":"UTF-8"
        }}
        \"\"\"),
            description="test description",
            annotations=[
                "test1",
                "test2",
                "test3",
            ],
            folder="testFolder",
            parameters={
                "foo": "test1",
                "Bar": "Test2",
            },
            additional_properties={
                "foo": "test1",
                "bar": "test2",
            },
            schema_json=\"\"\"{
          "type": "object",
          "properties": {
            "name": {
              "type": "object",
              "properties": {
                "firstName": {
                  "type": "string"
                },
                "lastName": {
                  "type": "string"
                }
              }
            },
            "age": {
              "type": "integer"
            }
          }
        }
        \"\"\")
        ```

        ## Import

        Data Factory Datasets can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/customDataset:CustomDataset example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example/datasets/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Dataset.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Dataset.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Dataset with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Dataset.
        :param pulumi.Input[_builtins.str] folder: The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        :param pulumi.Input[Union['CustomDatasetLinkedServiceArgs', 'CustomDatasetLinkedServiceArgsDict']] linked_service: A `linked_service` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Dataset. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Dataset.
        :param pulumi.Input[_builtins.str] schema_json: A JSON object that contains the schema of the Data Factory Dataset.
        :param pulumi.Input[_builtins.str] type: The type of dataset that will be associated with Data Factory. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type_properties_json: A JSON object that contains the properties of the Data Factory Dataset.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CustomDatasetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Dataset inside an Azure Data Factory. This is a generic resource that supports all different Dataset Types.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_factory = azure.datafactory.Factory("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            identity={
                "type": "SystemAssigned",
            })
        example_account = azure.storage.Account("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            account_kind="BlobStorage",
            account_tier="Standard",
            account_replication_type="LRS")
        example_linked_custom_service = azure.datafactory.LinkedCustomService("example",
            name="example",
            data_factory_id=example_factory.id,
            type="AzureBlobStorage",
            type_properties_json=example_account.primary_connection_string.apply(lambda primary_connection_string: f\"\"\"{{
          "connectionString":"{primary_connection_string}"
        }}
        \"\"\"))
        example_container = azure.storage.Container("example",
            name="content",
            storage_account_name=example_account.name,
            container_access_type="private")
        example_custom_dataset = azure.datafactory.CustomDataset("example",
            name="example",
            data_factory_id=example_factory.id,
            type="Json",
            linked_service={
                "name": example_linked_custom_service.name,
                "parameters": {
                    "key1": "value1",
                },
            },
            type_properties_json=example_container.name.apply(lambda name: f\"\"\"{{
          "location": {{
            "container":"{name}",
            "fileName":"foo.txt",
            "folderPath": "foo/bar/",
            "type":"AzureBlobStorageLocation"
          }},
          "encodingName":"UTF-8"
        }}
        \"\"\"),
            description="test description",
            annotations=[
                "test1",
                "test2",
                "test3",
            ],
            folder="testFolder",
            parameters={
                "foo": "test1",
                "Bar": "Test2",
            },
            additional_properties={
                "foo": "test1",
                "bar": "test2",
            },
            schema_json=\"\"\"{
          "type": "object",
          "properties": {
            "name": {
              "type": "object",
              "properties": {
                "firstName": {
                  "type": "string"
                },
                "lastName": {
                  "type": "string"
                }
              }
            },
            "age": {
              "type": "integer"
            }
          }
        }
        \"\"\")
        ```

        ## Import

        Data Factory Datasets can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/customDataset:CustomDataset example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example/datasets/example
        ```

        :param str resource_name: The name of the resource.
        :param CustomDatasetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CustomDatasetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 folder: Optional[pulumi.Input[_builtins.str]] = None,
                 linked_service: Optional[pulumi.Input[Union['CustomDatasetLinkedServiceArgs', 'CustomDatasetLinkedServiceArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 schema_json: Optional[pulumi.Input[_builtins.str]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 type_properties_json: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CustomDatasetArgs.__new__(CustomDatasetArgs)

            __props__.__dict__["additional_properties"] = additional_properties
            __props__.__dict__["annotations"] = annotations
            if data_factory_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_factory_id'")
            __props__.__dict__["data_factory_id"] = data_factory_id
            __props__.__dict__["description"] = description
            __props__.__dict__["folder"] = folder
            if linked_service is None and not opts.urn:
                raise TypeError("Missing required property 'linked_service'")
            __props__.__dict__["linked_service"] = linked_service
            __props__.__dict__["name"] = name
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["schema_json"] = schema_json
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if type_properties_json is None and not opts.urn:
                raise TypeError("Missing required property 'type_properties_json'")
            __props__.__dict__["type_properties_json"] = type_properties_json
        super(CustomDataset, __self__).__init__(
            'azure:datafactory/customDataset:CustomDataset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            folder: Optional[pulumi.Input[_builtins.str]] = None,
            linked_service: Optional[pulumi.Input[Union['CustomDatasetLinkedServiceArgs', 'CustomDatasetLinkedServiceArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            schema_json: Optional[pulumi.Input[_builtins.str]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            type_properties_json: Optional[pulumi.Input[_builtins.str]] = None) -> 'CustomDataset':
        """
        Get an existing CustomDataset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Dataset.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Dataset.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Dataset with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Dataset.
        :param pulumi.Input[_builtins.str] folder: The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        :param pulumi.Input[Union['CustomDatasetLinkedServiceArgs', 'CustomDatasetLinkedServiceArgsDict']] linked_service: A `linked_service` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Dataset. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Dataset.
        :param pulumi.Input[_builtins.str] schema_json: A JSON object that contains the schema of the Data Factory Dataset.
        :param pulumi.Input[_builtins.str] type: The type of dataset that will be associated with Data Factory. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type_properties_json: A JSON object that contains the properties of the Data Factory Dataset.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CustomDatasetState.__new__(_CustomDatasetState)

        __props__.__dict__["additional_properties"] = additional_properties
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["data_factory_id"] = data_factory_id
        __props__.__dict__["description"] = description
        __props__.__dict__["folder"] = folder
        __props__.__dict__["linked_service"] = linked_service
        __props__.__dict__["name"] = name
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["schema_json"] = schema_json
        __props__.__dict__["type"] = type
        __props__.__dict__["type_properties_json"] = type_properties_json
        return CustomDataset(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of additional properties to associate with the Data Factory Dataset.
        """
        return pulumi.get(self, "additional_properties")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of tags that can be used for describing the Data Factory Dataset.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Data Factory ID in which to associate the Dataset with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description for the Data Factory Dataset.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def folder(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The folder that this Dataset is in. If not specified, the Dataset will appear at the root level.
        """
        return pulumi.get(self, "folder")

    @_builtins.property
    @pulumi.getter(name="linkedService")
    def linked_service(self) -> pulumi.Output['outputs.CustomDatasetLinkedService']:
        """
        A `linked_service` block as defined below.
        """
        return pulumi.get(self, "linked_service")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Data Factory Dataset. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of parameters to associate with the Data Factory Dataset.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="schemaJson")
    def schema_json(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A JSON object that contains the schema of the Data Factory Dataset.
        """
        return pulumi.get(self, "schema_json")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of dataset that will be associated with Data Factory. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="typePropertiesJson")
    def type_properties_json(self) -> pulumi.Output[_builtins.str]:
        """
        A JSON object that contains the properties of the Data Factory Dataset.
        """
        return pulumi.get(self, "type_properties_json")

