# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IntegrationRuntimeSsisArgs', 'IntegrationRuntimeSsis']

@pulumi.input_type
class IntegrationRuntimeSsisArgs:
    def __init__(__self__, *,
                 data_factory_id: pulumi.Input[_builtins.str],
                 node_size: pulumi.Input[_builtins.str],
                 catalog_info: Optional[pulumi.Input['IntegrationRuntimeSsisCatalogInfoArgs']] = None,
                 copy_compute_scale: Optional[pulumi.Input['IntegrationRuntimeSsisCopyComputeScaleArgs']] = None,
                 credential_name: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_setup_script: Optional[pulumi.Input['IntegrationRuntimeSsisCustomSetupScriptArgs']] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 edition: Optional[pulumi.Input[_builtins.str]] = None,
                 express_custom_setup: Optional[pulumi.Input['IntegrationRuntimeSsisExpressCustomSetupArgs']] = None,
                 express_vnet_integration: Optional[pulumi.Input['IntegrationRuntimeSsisExpressVnetIntegrationArgs']] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 max_parallel_executions_per_node: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 package_stores: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationRuntimeSsisPackageStoreArgs']]]] = None,
                 pipeline_external_compute_scale: Optional[pulumi.Input['IntegrationRuntimeSsisPipelineExternalComputeScaleArgs']] = None,
                 proxy: Optional[pulumi.Input['IntegrationRuntimeSsisProxyArgs']] = None,
                 vnet_integration: Optional[pulumi.Input['IntegrationRuntimeSsisVnetIntegrationArgs']] = None):
        """
        The set of arguments for constructing a IntegrationRuntimeSsis resource.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] node_size: The size of the nodes on which the Azure-SSIS Integration Runtime runs. Valid values are: `Standard_D2_v3`, `Standard_D4_v3`, `Standard_D8_v3`, `Standard_D16_v3`, `Standard_D32_v3`, `Standard_D64_v3`, `Standard_E2_v3`, `Standard_E4_v3`, `Standard_E8_v3`, `Standard_E16_v3`, `Standard_E32_v3`, `Standard_E64_v3`, `Standard_D1_v2`, `Standard_D2_v2`, `Standard_D3_v2`, `Standard_D4_v2`, `Standard_A4_v2` and `Standard_A8_v2`
        :param pulumi.Input['IntegrationRuntimeSsisCatalogInfoArgs'] catalog_info: A `catalog_info` block as defined below.
        :param pulumi.Input['IntegrationRuntimeSsisCopyComputeScaleArgs'] copy_compute_scale: One `copy_compute_scale` block as defined below.
        :param pulumi.Input[_builtins.str] credential_name: The name of a Data Factory Credential that the SSIS integration will use to access data sources. For example, `datafactory.CredentialUserManagedIdentity`
               
               > **Note:** If `credential_name` is omitted, the integration runtime will use the Data Factory assigned identity.
        :param pulumi.Input['IntegrationRuntimeSsisCustomSetupScriptArgs'] custom_setup_script: A `custom_setup_script` block as defined below.
        :param pulumi.Input[_builtins.str] description: Integration runtime description.
        :param pulumi.Input[_builtins.str] edition: The Azure-SSIS Integration Runtime edition. Valid values are `Standard` and `Enterprise`. Defaults to `Standard`.
        :param pulumi.Input['IntegrationRuntimeSsisExpressCustomSetupArgs'] express_custom_setup: An `express_custom_setup` block as defined below.
        :param pulumi.Input['IntegrationRuntimeSsisExpressVnetIntegrationArgs'] express_vnet_integration: A `express_vnet_integration` block as defined below.
        :param pulumi.Input[_builtins.str] license_type: The type of the license that is used. Valid values are `LicenseIncluded` and `BasePrice`. Defaults to `LicenseIncluded`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] max_parallel_executions_per_node: Defines the maximum parallel executions per node. Defaults to `1`. Max is `1`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Azure-SSIS Integration Runtime. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[_builtins.int] number_of_nodes: Number of nodes for the Azure-SSIS Integration Runtime. Max is `10`. Defaults to `1`.
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationRuntimeSsisPackageStoreArgs']]] package_stores: One or more `package_store` block as defined below.
        :param pulumi.Input['IntegrationRuntimeSsisPipelineExternalComputeScaleArgs'] pipeline_external_compute_scale: One `pipeline_external_compute_scale` block as defined below.
        :param pulumi.Input['IntegrationRuntimeSsisProxyArgs'] proxy: A `proxy` block as defined below.
        :param pulumi.Input['IntegrationRuntimeSsisVnetIntegrationArgs'] vnet_integration: A `vnet_integration` block as defined below.
        """
        pulumi.set(__self__, "data_factory_id", data_factory_id)
        pulumi.set(__self__, "node_size", node_size)
        if catalog_info is not None:
            pulumi.set(__self__, "catalog_info", catalog_info)
        if copy_compute_scale is not None:
            pulumi.set(__self__, "copy_compute_scale", copy_compute_scale)
        if credential_name is not None:
            pulumi.set(__self__, "credential_name", credential_name)
        if custom_setup_script is not None:
            pulumi.set(__self__, "custom_setup_script", custom_setup_script)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if express_custom_setup is not None:
            pulumi.set(__self__, "express_custom_setup", express_custom_setup)
        if express_vnet_integration is not None:
            pulumi.set(__self__, "express_vnet_integration", express_vnet_integration)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if max_parallel_executions_per_node is not None:
            pulumi.set(__self__, "max_parallel_executions_per_node", max_parallel_executions_per_node)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if number_of_nodes is not None:
            pulumi.set(__self__, "number_of_nodes", number_of_nodes)
        if package_stores is not None:
            pulumi.set(__self__, "package_stores", package_stores)
        if pipeline_external_compute_scale is not None:
            pulumi.set(__self__, "pipeline_external_compute_scale", pipeline_external_compute_scale)
        if proxy is not None:
            pulumi.set(__self__, "proxy", proxy)
        if vnet_integration is not None:
            pulumi.set(__self__, "vnet_integration", vnet_integration)

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_factory_id", value)

    @_builtins.property
    @pulumi.getter(name="nodeSize")
    def node_size(self) -> pulumi.Input[_builtins.str]:
        """
        The size of the nodes on which the Azure-SSIS Integration Runtime runs. Valid values are: `Standard_D2_v3`, `Standard_D4_v3`, `Standard_D8_v3`, `Standard_D16_v3`, `Standard_D32_v3`, `Standard_D64_v3`, `Standard_E2_v3`, `Standard_E4_v3`, `Standard_E8_v3`, `Standard_E16_v3`, `Standard_E32_v3`, `Standard_E64_v3`, `Standard_D1_v2`, `Standard_D2_v2`, `Standard_D3_v2`, `Standard_D4_v2`, `Standard_A4_v2` and `Standard_A8_v2`
        """
        return pulumi.get(self, "node_size")

    @node_size.setter
    def node_size(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "node_size", value)

    @_builtins.property
    @pulumi.getter(name="catalogInfo")
    def catalog_info(self) -> Optional[pulumi.Input['IntegrationRuntimeSsisCatalogInfoArgs']]:
        """
        A `catalog_info` block as defined below.
        """
        return pulumi.get(self, "catalog_info")

    @catalog_info.setter
    def catalog_info(self, value: Optional[pulumi.Input['IntegrationRuntimeSsisCatalogInfoArgs']]):
        pulumi.set(self, "catalog_info", value)

    @_builtins.property
    @pulumi.getter(name="copyComputeScale")
    def copy_compute_scale(self) -> Optional[pulumi.Input['IntegrationRuntimeSsisCopyComputeScaleArgs']]:
        """
        One `copy_compute_scale` block as defined below.
        """
        return pulumi.get(self, "copy_compute_scale")

    @copy_compute_scale.setter
    def copy_compute_scale(self, value: Optional[pulumi.Input['IntegrationRuntimeSsisCopyComputeScaleArgs']]):
        pulumi.set(self, "copy_compute_scale", value)

    @_builtins.property
    @pulumi.getter(name="credentialName")
    def credential_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of a Data Factory Credential that the SSIS integration will use to access data sources. For example, `datafactory.CredentialUserManagedIdentity`

        > **Note:** If `credential_name` is omitted, the integration runtime will use the Data Factory assigned identity.
        """
        return pulumi.get(self, "credential_name")

    @credential_name.setter
    def credential_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credential_name", value)

    @_builtins.property
    @pulumi.getter(name="customSetupScript")
    def custom_setup_script(self) -> Optional[pulumi.Input['IntegrationRuntimeSsisCustomSetupScriptArgs']]:
        """
        A `custom_setup_script` block as defined below.
        """
        return pulumi.get(self, "custom_setup_script")

    @custom_setup_script.setter
    def custom_setup_script(self, value: Optional[pulumi.Input['IntegrationRuntimeSsisCustomSetupScriptArgs']]):
        pulumi.set(self, "custom_setup_script", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Integration runtime description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def edition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure-SSIS Integration Runtime edition. Valid values are `Standard` and `Enterprise`. Defaults to `Standard`.
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edition", value)

    @_builtins.property
    @pulumi.getter(name="expressCustomSetup")
    def express_custom_setup(self) -> Optional[pulumi.Input['IntegrationRuntimeSsisExpressCustomSetupArgs']]:
        """
        An `express_custom_setup` block as defined below.
        """
        return pulumi.get(self, "express_custom_setup")

    @express_custom_setup.setter
    def express_custom_setup(self, value: Optional[pulumi.Input['IntegrationRuntimeSsisExpressCustomSetupArgs']]):
        pulumi.set(self, "express_custom_setup", value)

    @_builtins.property
    @pulumi.getter(name="expressVnetIntegration")
    def express_vnet_integration(self) -> Optional[pulumi.Input['IntegrationRuntimeSsisExpressVnetIntegrationArgs']]:
        """
        A `express_vnet_integration` block as defined below.
        """
        return pulumi.get(self, "express_vnet_integration")

    @express_vnet_integration.setter
    def express_vnet_integration(self, value: Optional[pulumi.Input['IntegrationRuntimeSsisExpressVnetIntegrationArgs']]):
        pulumi.set(self, "express_vnet_integration", value)

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the license that is used. Valid values are `LicenseIncluded` and `BasePrice`. Defaults to `LicenseIncluded`.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_type", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maxParallelExecutionsPerNode")
    def max_parallel_executions_per_node(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Defines the maximum parallel executions per node. Defaults to `1`. Max is `1`.
        """
        return pulumi.get(self, "max_parallel_executions_per_node")

    @max_parallel_executions_per_node.setter
    def max_parallel_executions_per_node(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_parallel_executions_per_node", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Azure-SSIS Integration Runtime. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="numberOfNodes")
    def number_of_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of nodes for the Azure-SSIS Integration Runtime. Max is `10`. Defaults to `1`.
        """
        return pulumi.get(self, "number_of_nodes")

    @number_of_nodes.setter
    def number_of_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "number_of_nodes", value)

    @_builtins.property
    @pulumi.getter(name="packageStores")
    def package_stores(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationRuntimeSsisPackageStoreArgs']]]]:
        """
        One or more `package_store` block as defined below.
        """
        return pulumi.get(self, "package_stores")

    @package_stores.setter
    def package_stores(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationRuntimeSsisPackageStoreArgs']]]]):
        pulumi.set(self, "package_stores", value)

    @_builtins.property
    @pulumi.getter(name="pipelineExternalComputeScale")
    def pipeline_external_compute_scale(self) -> Optional[pulumi.Input['IntegrationRuntimeSsisPipelineExternalComputeScaleArgs']]:
        """
        One `pipeline_external_compute_scale` block as defined below.
        """
        return pulumi.get(self, "pipeline_external_compute_scale")

    @pipeline_external_compute_scale.setter
    def pipeline_external_compute_scale(self, value: Optional[pulumi.Input['IntegrationRuntimeSsisPipelineExternalComputeScaleArgs']]):
        pulumi.set(self, "pipeline_external_compute_scale", value)

    @_builtins.property
    @pulumi.getter
    def proxy(self) -> Optional[pulumi.Input['IntegrationRuntimeSsisProxyArgs']]:
        """
        A `proxy` block as defined below.
        """
        return pulumi.get(self, "proxy")

    @proxy.setter
    def proxy(self, value: Optional[pulumi.Input['IntegrationRuntimeSsisProxyArgs']]):
        pulumi.set(self, "proxy", value)

    @_builtins.property
    @pulumi.getter(name="vnetIntegration")
    def vnet_integration(self) -> Optional[pulumi.Input['IntegrationRuntimeSsisVnetIntegrationArgs']]:
        """
        A `vnet_integration` block as defined below.
        """
        return pulumi.get(self, "vnet_integration")

    @vnet_integration.setter
    def vnet_integration(self, value: Optional[pulumi.Input['IntegrationRuntimeSsisVnetIntegrationArgs']]):
        pulumi.set(self, "vnet_integration", value)


@pulumi.input_type
class _IntegrationRuntimeSsisState:
    def __init__(__self__, *,
                 catalog_info: Optional[pulumi.Input['IntegrationRuntimeSsisCatalogInfoArgs']] = None,
                 copy_compute_scale: Optional[pulumi.Input['IntegrationRuntimeSsisCopyComputeScaleArgs']] = None,
                 credential_name: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_setup_script: Optional[pulumi.Input['IntegrationRuntimeSsisCustomSetupScriptArgs']] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 edition: Optional[pulumi.Input[_builtins.str]] = None,
                 express_custom_setup: Optional[pulumi.Input['IntegrationRuntimeSsisExpressCustomSetupArgs']] = None,
                 express_vnet_integration: Optional[pulumi.Input['IntegrationRuntimeSsisExpressVnetIntegrationArgs']] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 max_parallel_executions_per_node: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_size: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 package_stores: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationRuntimeSsisPackageStoreArgs']]]] = None,
                 pipeline_external_compute_scale: Optional[pulumi.Input['IntegrationRuntimeSsisPipelineExternalComputeScaleArgs']] = None,
                 proxy: Optional[pulumi.Input['IntegrationRuntimeSsisProxyArgs']] = None,
                 vnet_integration: Optional[pulumi.Input['IntegrationRuntimeSsisVnetIntegrationArgs']] = None):
        """
        Input properties used for looking up and filtering IntegrationRuntimeSsis resources.
        :param pulumi.Input['IntegrationRuntimeSsisCatalogInfoArgs'] catalog_info: A `catalog_info` block as defined below.
        :param pulumi.Input['IntegrationRuntimeSsisCopyComputeScaleArgs'] copy_compute_scale: One `copy_compute_scale` block as defined below.
        :param pulumi.Input[_builtins.str] credential_name: The name of a Data Factory Credential that the SSIS integration will use to access data sources. For example, `datafactory.CredentialUserManagedIdentity`
               
               > **Note:** If `credential_name` is omitted, the integration runtime will use the Data Factory assigned identity.
        :param pulumi.Input['IntegrationRuntimeSsisCustomSetupScriptArgs'] custom_setup_script: A `custom_setup_script` block as defined below.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: Integration runtime description.
        :param pulumi.Input[_builtins.str] edition: The Azure-SSIS Integration Runtime edition. Valid values are `Standard` and `Enterprise`. Defaults to `Standard`.
        :param pulumi.Input['IntegrationRuntimeSsisExpressCustomSetupArgs'] express_custom_setup: An `express_custom_setup` block as defined below.
        :param pulumi.Input['IntegrationRuntimeSsisExpressVnetIntegrationArgs'] express_vnet_integration: A `express_vnet_integration` block as defined below.
        :param pulumi.Input[_builtins.str] license_type: The type of the license that is used. Valid values are `LicenseIncluded` and `BasePrice`. Defaults to `LicenseIncluded`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] max_parallel_executions_per_node: Defines the maximum parallel executions per node. Defaults to `1`. Max is `1`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Azure-SSIS Integration Runtime. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[_builtins.str] node_size: The size of the nodes on which the Azure-SSIS Integration Runtime runs. Valid values are: `Standard_D2_v3`, `Standard_D4_v3`, `Standard_D8_v3`, `Standard_D16_v3`, `Standard_D32_v3`, `Standard_D64_v3`, `Standard_E2_v3`, `Standard_E4_v3`, `Standard_E8_v3`, `Standard_E16_v3`, `Standard_E32_v3`, `Standard_E64_v3`, `Standard_D1_v2`, `Standard_D2_v2`, `Standard_D3_v2`, `Standard_D4_v2`, `Standard_A4_v2` and `Standard_A8_v2`
        :param pulumi.Input[_builtins.int] number_of_nodes: Number of nodes for the Azure-SSIS Integration Runtime. Max is `10`. Defaults to `1`.
        :param pulumi.Input[Sequence[pulumi.Input['IntegrationRuntimeSsisPackageStoreArgs']]] package_stores: One or more `package_store` block as defined below.
        :param pulumi.Input['IntegrationRuntimeSsisPipelineExternalComputeScaleArgs'] pipeline_external_compute_scale: One `pipeline_external_compute_scale` block as defined below.
        :param pulumi.Input['IntegrationRuntimeSsisProxyArgs'] proxy: A `proxy` block as defined below.
        :param pulumi.Input['IntegrationRuntimeSsisVnetIntegrationArgs'] vnet_integration: A `vnet_integration` block as defined below.
        """
        if catalog_info is not None:
            pulumi.set(__self__, "catalog_info", catalog_info)
        if copy_compute_scale is not None:
            pulumi.set(__self__, "copy_compute_scale", copy_compute_scale)
        if credential_name is not None:
            pulumi.set(__self__, "credential_name", credential_name)
        if custom_setup_script is not None:
            pulumi.set(__self__, "custom_setup_script", custom_setup_script)
        if data_factory_id is not None:
            pulumi.set(__self__, "data_factory_id", data_factory_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if edition is not None:
            pulumi.set(__self__, "edition", edition)
        if express_custom_setup is not None:
            pulumi.set(__self__, "express_custom_setup", express_custom_setup)
        if express_vnet_integration is not None:
            pulumi.set(__self__, "express_vnet_integration", express_vnet_integration)
        if license_type is not None:
            pulumi.set(__self__, "license_type", license_type)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if max_parallel_executions_per_node is not None:
            pulumi.set(__self__, "max_parallel_executions_per_node", max_parallel_executions_per_node)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_size is not None:
            pulumi.set(__self__, "node_size", node_size)
        if number_of_nodes is not None:
            pulumi.set(__self__, "number_of_nodes", number_of_nodes)
        if package_stores is not None:
            pulumi.set(__self__, "package_stores", package_stores)
        if pipeline_external_compute_scale is not None:
            pulumi.set(__self__, "pipeline_external_compute_scale", pipeline_external_compute_scale)
        if proxy is not None:
            pulumi.set(__self__, "proxy", proxy)
        if vnet_integration is not None:
            pulumi.set(__self__, "vnet_integration", vnet_integration)

    @_builtins.property
    @pulumi.getter(name="catalogInfo")
    def catalog_info(self) -> Optional[pulumi.Input['IntegrationRuntimeSsisCatalogInfoArgs']]:
        """
        A `catalog_info` block as defined below.
        """
        return pulumi.get(self, "catalog_info")

    @catalog_info.setter
    def catalog_info(self, value: Optional[pulumi.Input['IntegrationRuntimeSsisCatalogInfoArgs']]):
        pulumi.set(self, "catalog_info", value)

    @_builtins.property
    @pulumi.getter(name="copyComputeScale")
    def copy_compute_scale(self) -> Optional[pulumi.Input['IntegrationRuntimeSsisCopyComputeScaleArgs']]:
        """
        One `copy_compute_scale` block as defined below.
        """
        return pulumi.get(self, "copy_compute_scale")

    @copy_compute_scale.setter
    def copy_compute_scale(self, value: Optional[pulumi.Input['IntegrationRuntimeSsisCopyComputeScaleArgs']]):
        pulumi.set(self, "copy_compute_scale", value)

    @_builtins.property
    @pulumi.getter(name="credentialName")
    def credential_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of a Data Factory Credential that the SSIS integration will use to access data sources. For example, `datafactory.CredentialUserManagedIdentity`

        > **Note:** If `credential_name` is omitted, the integration runtime will use the Data Factory assigned identity.
        """
        return pulumi.get(self, "credential_name")

    @credential_name.setter
    def credential_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "credential_name", value)

    @_builtins.property
    @pulumi.getter(name="customSetupScript")
    def custom_setup_script(self) -> Optional[pulumi.Input['IntegrationRuntimeSsisCustomSetupScriptArgs']]:
        """
        A `custom_setup_script` block as defined below.
        """
        return pulumi.get(self, "custom_setup_script")

    @custom_setup_script.setter
    def custom_setup_script(self, value: Optional[pulumi.Input['IntegrationRuntimeSsisCustomSetupScriptArgs']]):
        pulumi.set(self, "custom_setup_script", value)

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_factory_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Integration runtime description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def edition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure-SSIS Integration Runtime edition. Valid values are `Standard` and `Enterprise`. Defaults to `Standard`.
        """
        return pulumi.get(self, "edition")

    @edition.setter
    def edition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "edition", value)

    @_builtins.property
    @pulumi.getter(name="expressCustomSetup")
    def express_custom_setup(self) -> Optional[pulumi.Input['IntegrationRuntimeSsisExpressCustomSetupArgs']]:
        """
        An `express_custom_setup` block as defined below.
        """
        return pulumi.get(self, "express_custom_setup")

    @express_custom_setup.setter
    def express_custom_setup(self, value: Optional[pulumi.Input['IntegrationRuntimeSsisExpressCustomSetupArgs']]):
        pulumi.set(self, "express_custom_setup", value)

    @_builtins.property
    @pulumi.getter(name="expressVnetIntegration")
    def express_vnet_integration(self) -> Optional[pulumi.Input['IntegrationRuntimeSsisExpressVnetIntegrationArgs']]:
        """
        A `express_vnet_integration` block as defined below.
        """
        return pulumi.get(self, "express_vnet_integration")

    @express_vnet_integration.setter
    def express_vnet_integration(self, value: Optional[pulumi.Input['IntegrationRuntimeSsisExpressVnetIntegrationArgs']]):
        pulumi.set(self, "express_vnet_integration", value)

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the license that is used. Valid values are `LicenseIncluded` and `BasePrice`. Defaults to `LicenseIncluded`.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_type", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maxParallelExecutionsPerNode")
    def max_parallel_executions_per_node(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Defines the maximum parallel executions per node. Defaults to `1`. Max is `1`.
        """
        return pulumi.get(self, "max_parallel_executions_per_node")

    @max_parallel_executions_per_node.setter
    def max_parallel_executions_per_node(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_parallel_executions_per_node", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Azure-SSIS Integration Runtime. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodeSize")
    def node_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The size of the nodes on which the Azure-SSIS Integration Runtime runs. Valid values are: `Standard_D2_v3`, `Standard_D4_v3`, `Standard_D8_v3`, `Standard_D16_v3`, `Standard_D32_v3`, `Standard_D64_v3`, `Standard_E2_v3`, `Standard_E4_v3`, `Standard_E8_v3`, `Standard_E16_v3`, `Standard_E32_v3`, `Standard_E64_v3`, `Standard_D1_v2`, `Standard_D2_v2`, `Standard_D3_v2`, `Standard_D4_v2`, `Standard_A4_v2` and `Standard_A8_v2`
        """
        return pulumi.get(self, "node_size")

    @node_size.setter
    def node_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "node_size", value)

    @_builtins.property
    @pulumi.getter(name="numberOfNodes")
    def number_of_nodes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Number of nodes for the Azure-SSIS Integration Runtime. Max is `10`. Defaults to `1`.
        """
        return pulumi.get(self, "number_of_nodes")

    @number_of_nodes.setter
    def number_of_nodes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "number_of_nodes", value)

    @_builtins.property
    @pulumi.getter(name="packageStores")
    def package_stores(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationRuntimeSsisPackageStoreArgs']]]]:
        """
        One or more `package_store` block as defined below.
        """
        return pulumi.get(self, "package_stores")

    @package_stores.setter
    def package_stores(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IntegrationRuntimeSsisPackageStoreArgs']]]]):
        pulumi.set(self, "package_stores", value)

    @_builtins.property
    @pulumi.getter(name="pipelineExternalComputeScale")
    def pipeline_external_compute_scale(self) -> Optional[pulumi.Input['IntegrationRuntimeSsisPipelineExternalComputeScaleArgs']]:
        """
        One `pipeline_external_compute_scale` block as defined below.
        """
        return pulumi.get(self, "pipeline_external_compute_scale")

    @pipeline_external_compute_scale.setter
    def pipeline_external_compute_scale(self, value: Optional[pulumi.Input['IntegrationRuntimeSsisPipelineExternalComputeScaleArgs']]):
        pulumi.set(self, "pipeline_external_compute_scale", value)

    @_builtins.property
    @pulumi.getter
    def proxy(self) -> Optional[pulumi.Input['IntegrationRuntimeSsisProxyArgs']]:
        """
        A `proxy` block as defined below.
        """
        return pulumi.get(self, "proxy")

    @proxy.setter
    def proxy(self, value: Optional[pulumi.Input['IntegrationRuntimeSsisProxyArgs']]):
        pulumi.set(self, "proxy", value)

    @_builtins.property
    @pulumi.getter(name="vnetIntegration")
    def vnet_integration(self) -> Optional[pulumi.Input['IntegrationRuntimeSsisVnetIntegrationArgs']]:
        """
        A `vnet_integration` block as defined below.
        """
        return pulumi.get(self, "vnet_integration")

    @vnet_integration.setter
    def vnet_integration(self, value: Optional[pulumi.Input['IntegrationRuntimeSsisVnetIntegrationArgs']]):
        pulumi.set(self, "vnet_integration", value)


@pulumi.type_token("azure:datafactory/integrationRuntimeSsis:IntegrationRuntimeSsis")
class IntegrationRuntimeSsis(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_info: Optional[pulumi.Input[Union['IntegrationRuntimeSsisCatalogInfoArgs', 'IntegrationRuntimeSsisCatalogInfoArgsDict']]] = None,
                 copy_compute_scale: Optional[pulumi.Input[Union['IntegrationRuntimeSsisCopyComputeScaleArgs', 'IntegrationRuntimeSsisCopyComputeScaleArgsDict']]] = None,
                 credential_name: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_setup_script: Optional[pulumi.Input[Union['IntegrationRuntimeSsisCustomSetupScriptArgs', 'IntegrationRuntimeSsisCustomSetupScriptArgsDict']]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 edition: Optional[pulumi.Input[_builtins.str]] = None,
                 express_custom_setup: Optional[pulumi.Input[Union['IntegrationRuntimeSsisExpressCustomSetupArgs', 'IntegrationRuntimeSsisExpressCustomSetupArgsDict']]] = None,
                 express_vnet_integration: Optional[pulumi.Input[Union['IntegrationRuntimeSsisExpressVnetIntegrationArgs', 'IntegrationRuntimeSsisExpressVnetIntegrationArgsDict']]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 max_parallel_executions_per_node: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_size: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 package_stores: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationRuntimeSsisPackageStoreArgs', 'IntegrationRuntimeSsisPackageStoreArgsDict']]]]] = None,
                 pipeline_external_compute_scale: Optional[pulumi.Input[Union['IntegrationRuntimeSsisPipelineExternalComputeScaleArgs', 'IntegrationRuntimeSsisPipelineExternalComputeScaleArgsDict']]] = None,
                 proxy: Optional[pulumi.Input[Union['IntegrationRuntimeSsisProxyArgs', 'IntegrationRuntimeSsisProxyArgsDict']]] = None,
                 vnet_integration: Optional[pulumi.Input[Union['IntegrationRuntimeSsisVnetIntegrationArgs', 'IntegrationRuntimeSsisVnetIntegrationArgsDict']]] = None,
                 __props__=None):
        """
        Manages a Data Factory Azure-SSIS Integration Runtime.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_factory = azure.datafactory.Factory("example",
            name="example",
            location=example.location,
            resource_group_name=example.name)
        example_integration_runtime_ssis = azure.datafactory.IntegrationRuntimeSsis("example",
            name="example",
            data_factory_id=example_factory.id,
            location=example.location,
            node_size="Standard_D8_v3")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DataFactory` - 2018-06-01

        ## Import

        Data Factory Azure-SSIS Integration Runtimes can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/integrationRuntimeSsis:IntegrationRuntimeSsis example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example/integrationRuntimes/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['IntegrationRuntimeSsisCatalogInfoArgs', 'IntegrationRuntimeSsisCatalogInfoArgsDict']] catalog_info: A `catalog_info` block as defined below.
        :param pulumi.Input[Union['IntegrationRuntimeSsisCopyComputeScaleArgs', 'IntegrationRuntimeSsisCopyComputeScaleArgsDict']] copy_compute_scale: One `copy_compute_scale` block as defined below.
        :param pulumi.Input[_builtins.str] credential_name: The name of a Data Factory Credential that the SSIS integration will use to access data sources. For example, `datafactory.CredentialUserManagedIdentity`
               
               > **Note:** If `credential_name` is omitted, the integration runtime will use the Data Factory assigned identity.
        :param pulumi.Input[Union['IntegrationRuntimeSsisCustomSetupScriptArgs', 'IntegrationRuntimeSsisCustomSetupScriptArgsDict']] custom_setup_script: A `custom_setup_script` block as defined below.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: Integration runtime description.
        :param pulumi.Input[_builtins.str] edition: The Azure-SSIS Integration Runtime edition. Valid values are `Standard` and `Enterprise`. Defaults to `Standard`.
        :param pulumi.Input[Union['IntegrationRuntimeSsisExpressCustomSetupArgs', 'IntegrationRuntimeSsisExpressCustomSetupArgsDict']] express_custom_setup: An `express_custom_setup` block as defined below.
        :param pulumi.Input[Union['IntegrationRuntimeSsisExpressVnetIntegrationArgs', 'IntegrationRuntimeSsisExpressVnetIntegrationArgsDict']] express_vnet_integration: A `express_vnet_integration` block as defined below.
        :param pulumi.Input[_builtins.str] license_type: The type of the license that is used. Valid values are `LicenseIncluded` and `BasePrice`. Defaults to `LicenseIncluded`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] max_parallel_executions_per_node: Defines the maximum parallel executions per node. Defaults to `1`. Max is `1`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Azure-SSIS Integration Runtime. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[_builtins.str] node_size: The size of the nodes on which the Azure-SSIS Integration Runtime runs. Valid values are: `Standard_D2_v3`, `Standard_D4_v3`, `Standard_D8_v3`, `Standard_D16_v3`, `Standard_D32_v3`, `Standard_D64_v3`, `Standard_E2_v3`, `Standard_E4_v3`, `Standard_E8_v3`, `Standard_E16_v3`, `Standard_E32_v3`, `Standard_E64_v3`, `Standard_D1_v2`, `Standard_D2_v2`, `Standard_D3_v2`, `Standard_D4_v2`, `Standard_A4_v2` and `Standard_A8_v2`
        :param pulumi.Input[_builtins.int] number_of_nodes: Number of nodes for the Azure-SSIS Integration Runtime. Max is `10`. Defaults to `1`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationRuntimeSsisPackageStoreArgs', 'IntegrationRuntimeSsisPackageStoreArgsDict']]]] package_stores: One or more `package_store` block as defined below.
        :param pulumi.Input[Union['IntegrationRuntimeSsisPipelineExternalComputeScaleArgs', 'IntegrationRuntimeSsisPipelineExternalComputeScaleArgsDict']] pipeline_external_compute_scale: One `pipeline_external_compute_scale` block as defined below.
        :param pulumi.Input[Union['IntegrationRuntimeSsisProxyArgs', 'IntegrationRuntimeSsisProxyArgsDict']] proxy: A `proxy` block as defined below.
        :param pulumi.Input[Union['IntegrationRuntimeSsisVnetIntegrationArgs', 'IntegrationRuntimeSsisVnetIntegrationArgsDict']] vnet_integration: A `vnet_integration` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IntegrationRuntimeSsisArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Data Factory Azure-SSIS Integration Runtime.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_factory = azure.datafactory.Factory("example",
            name="example",
            location=example.location,
            resource_group_name=example.name)
        example_integration_runtime_ssis = azure.datafactory.IntegrationRuntimeSsis("example",
            name="example",
            data_factory_id=example_factory.id,
            location=example.location,
            node_size="Standard_D8_v3")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DataFactory` - 2018-06-01

        ## Import

        Data Factory Azure-SSIS Integration Runtimes can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/integrationRuntimeSsis:IntegrationRuntimeSsis example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example/integrationRuntimes/example
        ```

        :param str resource_name: The name of the resource.
        :param IntegrationRuntimeSsisArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IntegrationRuntimeSsisArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 catalog_info: Optional[pulumi.Input[Union['IntegrationRuntimeSsisCatalogInfoArgs', 'IntegrationRuntimeSsisCatalogInfoArgsDict']]] = None,
                 copy_compute_scale: Optional[pulumi.Input[Union['IntegrationRuntimeSsisCopyComputeScaleArgs', 'IntegrationRuntimeSsisCopyComputeScaleArgsDict']]] = None,
                 credential_name: Optional[pulumi.Input[_builtins.str]] = None,
                 custom_setup_script: Optional[pulumi.Input[Union['IntegrationRuntimeSsisCustomSetupScriptArgs', 'IntegrationRuntimeSsisCustomSetupScriptArgsDict']]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 edition: Optional[pulumi.Input[_builtins.str]] = None,
                 express_custom_setup: Optional[pulumi.Input[Union['IntegrationRuntimeSsisExpressCustomSetupArgs', 'IntegrationRuntimeSsisExpressCustomSetupArgsDict']]] = None,
                 express_vnet_integration: Optional[pulumi.Input[Union['IntegrationRuntimeSsisExpressVnetIntegrationArgs', 'IntegrationRuntimeSsisExpressVnetIntegrationArgsDict']]] = None,
                 license_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 max_parallel_executions_per_node: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_size: Optional[pulumi.Input[_builtins.str]] = None,
                 number_of_nodes: Optional[pulumi.Input[_builtins.int]] = None,
                 package_stores: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationRuntimeSsisPackageStoreArgs', 'IntegrationRuntimeSsisPackageStoreArgsDict']]]]] = None,
                 pipeline_external_compute_scale: Optional[pulumi.Input[Union['IntegrationRuntimeSsisPipelineExternalComputeScaleArgs', 'IntegrationRuntimeSsisPipelineExternalComputeScaleArgsDict']]] = None,
                 proxy: Optional[pulumi.Input[Union['IntegrationRuntimeSsisProxyArgs', 'IntegrationRuntimeSsisProxyArgsDict']]] = None,
                 vnet_integration: Optional[pulumi.Input[Union['IntegrationRuntimeSsisVnetIntegrationArgs', 'IntegrationRuntimeSsisVnetIntegrationArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IntegrationRuntimeSsisArgs.__new__(IntegrationRuntimeSsisArgs)

            __props__.__dict__["catalog_info"] = catalog_info
            __props__.__dict__["copy_compute_scale"] = copy_compute_scale
            __props__.__dict__["credential_name"] = credential_name
            __props__.__dict__["custom_setup_script"] = custom_setup_script
            if data_factory_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_factory_id'")
            __props__.__dict__["data_factory_id"] = data_factory_id
            __props__.__dict__["description"] = description
            __props__.__dict__["edition"] = edition
            __props__.__dict__["express_custom_setup"] = express_custom_setup
            __props__.__dict__["express_vnet_integration"] = express_vnet_integration
            __props__.__dict__["license_type"] = license_type
            __props__.__dict__["location"] = location
            __props__.__dict__["max_parallel_executions_per_node"] = max_parallel_executions_per_node
            __props__.__dict__["name"] = name
            if node_size is None and not opts.urn:
                raise TypeError("Missing required property 'node_size'")
            __props__.__dict__["node_size"] = node_size
            __props__.__dict__["number_of_nodes"] = number_of_nodes
            __props__.__dict__["package_stores"] = package_stores
            __props__.__dict__["pipeline_external_compute_scale"] = pipeline_external_compute_scale
            __props__.__dict__["proxy"] = proxy
            __props__.__dict__["vnet_integration"] = vnet_integration
        alias_opts = pulumi.ResourceOptions(aliases=[pulumi.Alias(type_="azure:datafactory/integrationRuntimeManaged:IntegrationRuntimeManaged")])
        opts = pulumi.ResourceOptions.merge(opts, alias_opts)
        super(IntegrationRuntimeSsis, __self__).__init__(
            'azure:datafactory/integrationRuntimeSsis:IntegrationRuntimeSsis',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            catalog_info: Optional[pulumi.Input[Union['IntegrationRuntimeSsisCatalogInfoArgs', 'IntegrationRuntimeSsisCatalogInfoArgsDict']]] = None,
            copy_compute_scale: Optional[pulumi.Input[Union['IntegrationRuntimeSsisCopyComputeScaleArgs', 'IntegrationRuntimeSsisCopyComputeScaleArgsDict']]] = None,
            credential_name: Optional[pulumi.Input[_builtins.str]] = None,
            custom_setup_script: Optional[pulumi.Input[Union['IntegrationRuntimeSsisCustomSetupScriptArgs', 'IntegrationRuntimeSsisCustomSetupScriptArgsDict']]] = None,
            data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            edition: Optional[pulumi.Input[_builtins.str]] = None,
            express_custom_setup: Optional[pulumi.Input[Union['IntegrationRuntimeSsisExpressCustomSetupArgs', 'IntegrationRuntimeSsisExpressCustomSetupArgsDict']]] = None,
            express_vnet_integration: Optional[pulumi.Input[Union['IntegrationRuntimeSsisExpressVnetIntegrationArgs', 'IntegrationRuntimeSsisExpressVnetIntegrationArgsDict']]] = None,
            license_type: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            max_parallel_executions_per_node: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            node_size: Optional[pulumi.Input[_builtins.str]] = None,
            number_of_nodes: Optional[pulumi.Input[_builtins.int]] = None,
            package_stores: Optional[pulumi.Input[Sequence[pulumi.Input[Union['IntegrationRuntimeSsisPackageStoreArgs', 'IntegrationRuntimeSsisPackageStoreArgsDict']]]]] = None,
            pipeline_external_compute_scale: Optional[pulumi.Input[Union['IntegrationRuntimeSsisPipelineExternalComputeScaleArgs', 'IntegrationRuntimeSsisPipelineExternalComputeScaleArgsDict']]] = None,
            proxy: Optional[pulumi.Input[Union['IntegrationRuntimeSsisProxyArgs', 'IntegrationRuntimeSsisProxyArgsDict']]] = None,
            vnet_integration: Optional[pulumi.Input[Union['IntegrationRuntimeSsisVnetIntegrationArgs', 'IntegrationRuntimeSsisVnetIntegrationArgsDict']]] = None) -> 'IntegrationRuntimeSsis':
        """
        Get an existing IntegrationRuntimeSsis resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['IntegrationRuntimeSsisCatalogInfoArgs', 'IntegrationRuntimeSsisCatalogInfoArgsDict']] catalog_info: A `catalog_info` block as defined below.
        :param pulumi.Input[Union['IntegrationRuntimeSsisCopyComputeScaleArgs', 'IntegrationRuntimeSsisCopyComputeScaleArgsDict']] copy_compute_scale: One `copy_compute_scale` block as defined below.
        :param pulumi.Input[_builtins.str] credential_name: The name of a Data Factory Credential that the SSIS integration will use to access data sources. For example, `datafactory.CredentialUserManagedIdentity`
               
               > **Note:** If `credential_name` is omitted, the integration runtime will use the Data Factory assigned identity.
        :param pulumi.Input[Union['IntegrationRuntimeSsisCustomSetupScriptArgs', 'IntegrationRuntimeSsisCustomSetupScriptArgsDict']] custom_setup_script: A `custom_setup_script` block as defined below.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: Integration runtime description.
        :param pulumi.Input[_builtins.str] edition: The Azure-SSIS Integration Runtime edition. Valid values are `Standard` and `Enterprise`. Defaults to `Standard`.
        :param pulumi.Input[Union['IntegrationRuntimeSsisExpressCustomSetupArgs', 'IntegrationRuntimeSsisExpressCustomSetupArgsDict']] express_custom_setup: An `express_custom_setup` block as defined below.
        :param pulumi.Input[Union['IntegrationRuntimeSsisExpressVnetIntegrationArgs', 'IntegrationRuntimeSsisExpressVnetIntegrationArgsDict']] express_vnet_integration: A `express_vnet_integration` block as defined below.
        :param pulumi.Input[_builtins.str] license_type: The type of the license that is used. Valid values are `LicenseIncluded` and `BasePrice`. Defaults to `LicenseIncluded`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] max_parallel_executions_per_node: Defines the maximum parallel executions per node. Defaults to `1`. Max is `1`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Azure-SSIS Integration Runtime. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[_builtins.str] node_size: The size of the nodes on which the Azure-SSIS Integration Runtime runs. Valid values are: `Standard_D2_v3`, `Standard_D4_v3`, `Standard_D8_v3`, `Standard_D16_v3`, `Standard_D32_v3`, `Standard_D64_v3`, `Standard_E2_v3`, `Standard_E4_v3`, `Standard_E8_v3`, `Standard_E16_v3`, `Standard_E32_v3`, `Standard_E64_v3`, `Standard_D1_v2`, `Standard_D2_v2`, `Standard_D3_v2`, `Standard_D4_v2`, `Standard_A4_v2` and `Standard_A8_v2`
        :param pulumi.Input[_builtins.int] number_of_nodes: Number of nodes for the Azure-SSIS Integration Runtime. Max is `10`. Defaults to `1`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['IntegrationRuntimeSsisPackageStoreArgs', 'IntegrationRuntimeSsisPackageStoreArgsDict']]]] package_stores: One or more `package_store` block as defined below.
        :param pulumi.Input[Union['IntegrationRuntimeSsisPipelineExternalComputeScaleArgs', 'IntegrationRuntimeSsisPipelineExternalComputeScaleArgsDict']] pipeline_external_compute_scale: One `pipeline_external_compute_scale` block as defined below.
        :param pulumi.Input[Union['IntegrationRuntimeSsisProxyArgs', 'IntegrationRuntimeSsisProxyArgsDict']] proxy: A `proxy` block as defined below.
        :param pulumi.Input[Union['IntegrationRuntimeSsisVnetIntegrationArgs', 'IntegrationRuntimeSsisVnetIntegrationArgsDict']] vnet_integration: A `vnet_integration` block as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IntegrationRuntimeSsisState.__new__(_IntegrationRuntimeSsisState)

        __props__.__dict__["catalog_info"] = catalog_info
        __props__.__dict__["copy_compute_scale"] = copy_compute_scale
        __props__.__dict__["credential_name"] = credential_name
        __props__.__dict__["custom_setup_script"] = custom_setup_script
        __props__.__dict__["data_factory_id"] = data_factory_id
        __props__.__dict__["description"] = description
        __props__.__dict__["edition"] = edition
        __props__.__dict__["express_custom_setup"] = express_custom_setup
        __props__.__dict__["express_vnet_integration"] = express_vnet_integration
        __props__.__dict__["license_type"] = license_type
        __props__.__dict__["location"] = location
        __props__.__dict__["max_parallel_executions_per_node"] = max_parallel_executions_per_node
        __props__.__dict__["name"] = name
        __props__.__dict__["node_size"] = node_size
        __props__.__dict__["number_of_nodes"] = number_of_nodes
        __props__.__dict__["package_stores"] = package_stores
        __props__.__dict__["pipeline_external_compute_scale"] = pipeline_external_compute_scale
        __props__.__dict__["proxy"] = proxy
        __props__.__dict__["vnet_integration"] = vnet_integration
        return IntegrationRuntimeSsis(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="catalogInfo")
    def catalog_info(self) -> pulumi.Output[Optional['outputs.IntegrationRuntimeSsisCatalogInfo']]:
        """
        A `catalog_info` block as defined below.
        """
        return pulumi.get(self, "catalog_info")

    @_builtins.property
    @pulumi.getter(name="copyComputeScale")
    def copy_compute_scale(self) -> pulumi.Output[Optional['outputs.IntegrationRuntimeSsisCopyComputeScale']]:
        """
        One `copy_compute_scale` block as defined below.
        """
        return pulumi.get(self, "copy_compute_scale")

    @_builtins.property
    @pulumi.getter(name="credentialName")
    def credential_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of a Data Factory Credential that the SSIS integration will use to access data sources. For example, `datafactory.CredentialUserManagedIdentity`

        > **Note:** If `credential_name` is omitted, the integration runtime will use the Data Factory assigned identity.
        """
        return pulumi.get(self, "credential_name")

    @_builtins.property
    @pulumi.getter(name="customSetupScript")
    def custom_setup_script(self) -> pulumi.Output[Optional['outputs.IntegrationRuntimeSsisCustomSetupScript']]:
        """
        A `custom_setup_script` block as defined below.
        """
        return pulumi.get(self, "custom_setup_script")

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Integration runtime description.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def edition(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Azure-SSIS Integration Runtime edition. Valid values are `Standard` and `Enterprise`. Defaults to `Standard`.
        """
        return pulumi.get(self, "edition")

    @_builtins.property
    @pulumi.getter(name="expressCustomSetup")
    def express_custom_setup(self) -> pulumi.Output[Optional['outputs.IntegrationRuntimeSsisExpressCustomSetup']]:
        """
        An `express_custom_setup` block as defined below.
        """
        return pulumi.get(self, "express_custom_setup")

    @_builtins.property
    @pulumi.getter(name="expressVnetIntegration")
    def express_vnet_integration(self) -> pulumi.Output[Optional['outputs.IntegrationRuntimeSsisExpressVnetIntegration']]:
        """
        A `express_vnet_integration` block as defined below.
        """
        return pulumi.get(self, "express_vnet_integration")

    @_builtins.property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the license that is used. Valid values are `LicenseIncluded` and `BasePrice`. Defaults to `LicenseIncluded`.
        """
        return pulumi.get(self, "license_type")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="maxParallelExecutionsPerNode")
    def max_parallel_executions_per_node(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Defines the maximum parallel executions per node. Defaults to `1`. Max is `1`.
        """
        return pulumi.get(self, "max_parallel_executions_per_node")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Azure-SSIS Integration Runtime. Changing this forces a new resource to be created. Must be globally unique. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodeSize")
    def node_size(self) -> pulumi.Output[_builtins.str]:
        """
        The size of the nodes on which the Azure-SSIS Integration Runtime runs. Valid values are: `Standard_D2_v3`, `Standard_D4_v3`, `Standard_D8_v3`, `Standard_D16_v3`, `Standard_D32_v3`, `Standard_D64_v3`, `Standard_E2_v3`, `Standard_E4_v3`, `Standard_E8_v3`, `Standard_E16_v3`, `Standard_E32_v3`, `Standard_E64_v3`, `Standard_D1_v2`, `Standard_D2_v2`, `Standard_D3_v2`, `Standard_D4_v2`, `Standard_A4_v2` and `Standard_A8_v2`
        """
        return pulumi.get(self, "node_size")

    @_builtins.property
    @pulumi.getter(name="numberOfNodes")
    def number_of_nodes(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        Number of nodes for the Azure-SSIS Integration Runtime. Max is `10`. Defaults to `1`.
        """
        return pulumi.get(self, "number_of_nodes")

    @_builtins.property
    @pulumi.getter(name="packageStores")
    def package_stores(self) -> pulumi.Output[Optional[Sequence['outputs.IntegrationRuntimeSsisPackageStore']]]:
        """
        One or more `package_store` block as defined below.
        """
        return pulumi.get(self, "package_stores")

    @_builtins.property
    @pulumi.getter(name="pipelineExternalComputeScale")
    def pipeline_external_compute_scale(self) -> pulumi.Output[Optional['outputs.IntegrationRuntimeSsisPipelineExternalComputeScale']]:
        """
        One `pipeline_external_compute_scale` block as defined below.
        """
        return pulumi.get(self, "pipeline_external_compute_scale")

    @_builtins.property
    @pulumi.getter
    def proxy(self) -> pulumi.Output[Optional['outputs.IntegrationRuntimeSsisProxy']]:
        """
        A `proxy` block as defined below.
        """
        return pulumi.get(self, "proxy")

    @_builtins.property
    @pulumi.getter(name="vnetIntegration")
    def vnet_integration(self) -> pulumi.Output[Optional['outputs.IntegrationRuntimeSsisVnetIntegration']]:
        """
        A `vnet_integration` block as defined below.
        """
        return pulumi.get(self, "vnet_integration")

