# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['LinkedServiceAzureBlobStorageArgs', 'LinkedServiceAzureBlobStorage']

@pulumi.input_type
class LinkedServiceAzureBlobStorageArgs:
    def __init__(__self__, *,
                 data_factory_id: pulumi.Input[_builtins.str],
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string_insecure: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 integration_runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_sas_token: Optional[pulumi.Input['LinkedServiceAzureBlobStorageKeyVaultSasTokenArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 sas_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 service_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_key: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_linked_key_vault_key: Optional[pulumi.Input['LinkedServiceAzureBlobStorageServicePrincipalLinkedKeyVaultKeyArgs']] = None,
                 storage_kind: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 use_managed_identity: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a LinkedServiceAzureBlobStorage resource.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Linked Service.
               
               The following supported arguments are specific to Azure Blob Storage Linked Service:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] connection_string: The connection string. Conflicts with `connection_string_insecure`, `sas_uri` and `service_endpoint`.
        :param pulumi.Input[_builtins.str] connection_string_insecure: The connection string sent insecurely. Conflicts with `connection_string`, `sas_uri` and `service_endpoint`.
               
               > **Note:** `connection_string` uses the Azure [SecureString](https://learn.microsoft.com/en-us/dotnet/api/microsoft.azure.management.datafactory.models.securestring) to encrypt the contents within the REST payload sent to Azure whilst the `connection_string_insecure` is sent as a regular string. Both properties are still sent using SSL/HTTPS. At this time the portal will not decrypt Secure Strings so the `connection_string` property in the portal will show as `******` whilst `connection_string_insecure` will be viewable in the portal.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] integration_runtime_name: The integration runtime reference to associate with the Data Factory Linked Service.
        :param pulumi.Input['LinkedServiceAzureBlobStorageKeyVaultSasTokenArgs'] key_vault_sas_token: A `key_vault_sas_token` block as defined below. Use this argument to store SAS Token in an existing Key Vault. It needs an existing Key Vault Data Factory Linked Service. A `sas_uri` is required.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] sas_uri: The SAS URI. Conflicts with `connection_string_insecure`, `connection_string` and `service_endpoint`.
        """
        pulumi.set(__self__, "data_factory_id", data_factory_id)
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if connection_string_insecure is not None:
            pulumi.set(__self__, "connection_string_insecure", connection_string_insecure)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if integration_runtime_name is not None:
            pulumi.set(__self__, "integration_runtime_name", integration_runtime_name)
        if key_vault_sas_token is not None:
            pulumi.set(__self__, "key_vault_sas_token", key_vault_sas_token)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if sas_uri is not None:
            pulumi.set(__self__, "sas_uri", sas_uri)
        if service_endpoint is not None:
            pulumi.set(__self__, "service_endpoint", service_endpoint)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)
        if service_principal_key is not None:
            pulumi.set(__self__, "service_principal_key", service_principal_key)
        if service_principal_linked_key_vault_key is not None:
            pulumi.set(__self__, "service_principal_linked_key_vault_key", service_principal_linked_key_vault_key)
        if storage_kind is not None:
            pulumi.set(__self__, "storage_kind", storage_kind)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if use_managed_identity is not None:
            pulumi.set(__self__, "use_managed_identity", use_managed_identity)

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Input[_builtins.str]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_factory_id", value)

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of additional properties to associate with the Data Factory Linked Service.

        The following supported arguments are specific to Azure Blob Storage Linked Service:
        """
        return pulumi.get(self, "additional_properties")

    @additional_properties.setter
    def additional_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_properties", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags that can be used for describing the Data Factory Linked Service.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection string. Conflicts with `connection_string_insecure`, `sas_uri` and `service_endpoint`.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter(name="connectionStringInsecure")
    def connection_string_insecure(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection string sent insecurely. Conflicts with `connection_string`, `sas_uri` and `service_endpoint`.

        > **Note:** `connection_string` uses the Azure [SecureString](https://learn.microsoft.com/en-us/dotnet/api/microsoft.azure.management.datafactory.models.securestring) to encrypt the contents within the REST payload sent to Azure whilst the `connection_string_insecure` is sent as a regular string. Both properties are still sent using SSL/HTTPS. At this time the portal will not decrypt Secure Strings so the `connection_string` property in the portal will show as `******` whilst `connection_string_insecure` will be viewable in the portal.
        """
        return pulumi.get(self, "connection_string_insecure")

    @connection_string_insecure.setter
    def connection_string_insecure(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string_insecure", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the Data Factory Linked Service.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="integrationRuntimeName")
    def integration_runtime_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The integration runtime reference to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "integration_runtime_name")

    @integration_runtime_name.setter
    def integration_runtime_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "integration_runtime_name", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultSasToken")
    def key_vault_sas_token(self) -> Optional[pulumi.Input['LinkedServiceAzureBlobStorageKeyVaultSasTokenArgs']]:
        """
        A `key_vault_sas_token` block as defined below. Use this argument to store SAS Token in an existing Key Vault. It needs an existing Key Vault Data Factory Linked Service. A `sas_uri` is required.
        """
        return pulumi.get(self, "key_vault_sas_token")

    @key_vault_sas_token.setter
    def key_vault_sas_token(self, value: Optional[pulumi.Input['LinkedServiceAzureBlobStorageKeyVaultSasTokenArgs']]):
        pulumi.set(self, "key_vault_sas_token", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of parameters to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="sasUri")
    def sas_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SAS URI. Conflicts with `connection_string_insecure`, `connection_string` and `service_endpoint`.
        """
        return pulumi.get(self, "sas_uri")

    @sas_uri.setter
    def sas_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sas_uri", value)

    @_builtins.property
    @pulumi.getter(name="serviceEndpoint")
    def service_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "service_endpoint")

    @service_endpoint.setter
    def service_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_principal_id", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipalKey")
    def service_principal_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "service_principal_key")

    @service_principal_key.setter
    def service_principal_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_principal_key", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipalLinkedKeyVaultKey")
    def service_principal_linked_key_vault_key(self) -> Optional[pulumi.Input['LinkedServiceAzureBlobStorageServicePrincipalLinkedKeyVaultKeyArgs']]:
        return pulumi.get(self, "service_principal_linked_key_vault_key")

    @service_principal_linked_key_vault_key.setter
    def service_principal_linked_key_vault_key(self, value: Optional[pulumi.Input['LinkedServiceAzureBlobStorageServicePrincipalLinkedKeyVaultKeyArgs']]):
        pulumi.set(self, "service_principal_linked_key_vault_key", value)

    @_builtins.property
    @pulumi.getter(name="storageKind")
    def storage_kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "storage_kind")

    @storage_kind.setter
    def storage_kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_kind", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="useManagedIdentity")
    def use_managed_identity(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "use_managed_identity")

    @use_managed_identity.setter
    def use_managed_identity(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_managed_identity", value)


@pulumi.input_type
class _LinkedServiceAzureBlobStorageState:
    def __init__(__self__, *,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string_insecure: Optional[pulumi.Input[_builtins.str]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 integration_runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_sas_token: Optional[pulumi.Input['LinkedServiceAzureBlobStorageKeyVaultSasTokenArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 sas_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 service_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_key: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_linked_key_vault_key: Optional[pulumi.Input['LinkedServiceAzureBlobStorageServicePrincipalLinkedKeyVaultKeyArgs']] = None,
                 storage_kind: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 use_managed_identity: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering LinkedServiceAzureBlobStorage resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Linked Service.
               
               The following supported arguments are specific to Azure Blob Storage Linked Service:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] connection_string: The connection string. Conflicts with `connection_string_insecure`, `sas_uri` and `service_endpoint`.
        :param pulumi.Input[_builtins.str] connection_string_insecure: The connection string sent insecurely. Conflicts with `connection_string`, `sas_uri` and `service_endpoint`.
               
               > **Note:** `connection_string` uses the Azure [SecureString](https://learn.microsoft.com/en-us/dotnet/api/microsoft.azure.management.datafactory.models.securestring) to encrypt the contents within the REST payload sent to Azure whilst the `connection_string_insecure` is sent as a regular string. Both properties are still sent using SSL/HTTPS. At this time the portal will not decrypt Secure Strings so the `connection_string` property in the portal will show as `******` whilst `connection_string_insecure` will be viewable in the portal.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] integration_runtime_name: The integration runtime reference to associate with the Data Factory Linked Service.
        :param pulumi.Input['LinkedServiceAzureBlobStorageKeyVaultSasTokenArgs'] key_vault_sas_token: A `key_vault_sas_token` block as defined below. Use this argument to store SAS Token in an existing Key Vault. It needs an existing Key Vault Data Factory Linked Service. A `sas_uri` is required.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] sas_uri: The SAS URI. Conflicts with `connection_string_insecure`, `connection_string` and `service_endpoint`.
        """
        if additional_properties is not None:
            pulumi.set(__self__, "additional_properties", additional_properties)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if connection_string_insecure is not None:
            pulumi.set(__self__, "connection_string_insecure", connection_string_insecure)
        if data_factory_id is not None:
            pulumi.set(__self__, "data_factory_id", data_factory_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if integration_runtime_name is not None:
            pulumi.set(__self__, "integration_runtime_name", integration_runtime_name)
        if key_vault_sas_token is not None:
            pulumi.set(__self__, "key_vault_sas_token", key_vault_sas_token)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if sas_uri is not None:
            pulumi.set(__self__, "sas_uri", sas_uri)
        if service_endpoint is not None:
            pulumi.set(__self__, "service_endpoint", service_endpoint)
        if service_principal_id is not None:
            pulumi.set(__self__, "service_principal_id", service_principal_id)
        if service_principal_key is not None:
            pulumi.set(__self__, "service_principal_key", service_principal_key)
        if service_principal_linked_key_vault_key is not None:
            pulumi.set(__self__, "service_principal_linked_key_vault_key", service_principal_linked_key_vault_key)
        if storage_kind is not None:
            pulumi.set(__self__, "storage_kind", storage_kind)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)
        if use_managed_identity is not None:
            pulumi.set(__self__, "use_managed_identity", use_managed_identity)

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of additional properties to associate with the Data Factory Linked Service.

        The following supported arguments are specific to Azure Blob Storage Linked Service:
        """
        return pulumi.get(self, "additional_properties")

    @additional_properties.setter
    def additional_properties(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "additional_properties", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        List of tags that can be used for describing the Data Factory Linked Service.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection string. Conflicts with `connection_string_insecure`, `sas_uri` and `service_endpoint`.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter(name="connectionStringInsecure")
    def connection_string_insecure(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection string sent insecurely. Conflicts with `connection_string`, `sas_uri` and `service_endpoint`.

        > **Note:** `connection_string` uses the Azure [SecureString](https://learn.microsoft.com/en-us/dotnet/api/microsoft.azure.management.datafactory.models.securestring) to encrypt the contents within the REST payload sent to Azure whilst the `connection_string_insecure` is sent as a regular string. Both properties are still sent using SSL/HTTPS. At this time the portal will not decrypt Secure Strings so the `connection_string` property in the portal will show as `******` whilst `connection_string_insecure` will be viewable in the portal.
        """
        return pulumi.get(self, "connection_string_insecure")

    @connection_string_insecure.setter
    def connection_string_insecure(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string_insecure", value)

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @data_factory_id.setter
    def data_factory_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_factory_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description for the Data Factory Linked Service.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="integrationRuntimeName")
    def integration_runtime_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The integration runtime reference to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "integration_runtime_name")

    @integration_runtime_name.setter
    def integration_runtime_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "integration_runtime_name", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultSasToken")
    def key_vault_sas_token(self) -> Optional[pulumi.Input['LinkedServiceAzureBlobStorageKeyVaultSasTokenArgs']]:
        """
        A `key_vault_sas_token` block as defined below. Use this argument to store SAS Token in an existing Key Vault. It needs an existing Key Vault Data Factory Linked Service. A `sas_uri` is required.
        """
        return pulumi.get(self, "key_vault_sas_token")

    @key_vault_sas_token.setter
    def key_vault_sas_token(self, value: Optional[pulumi.Input['LinkedServiceAzureBlobStorageKeyVaultSasTokenArgs']]):
        pulumi.set(self, "key_vault_sas_token", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of parameters to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "parameters", value)

    @_builtins.property
    @pulumi.getter(name="sasUri")
    def sas_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SAS URI. Conflicts with `connection_string_insecure`, `connection_string` and `service_endpoint`.
        """
        return pulumi.get(self, "sas_uri")

    @sas_uri.setter
    def sas_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sas_uri", value)

    @_builtins.property
    @pulumi.getter(name="serviceEndpoint")
    def service_endpoint(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "service_endpoint")

    @service_endpoint.setter
    def service_endpoint(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "service_principal_id")

    @service_principal_id.setter
    def service_principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_principal_id", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipalKey")
    def service_principal_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "service_principal_key")

    @service_principal_key.setter
    def service_principal_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_principal_key", value)

    @_builtins.property
    @pulumi.getter(name="servicePrincipalLinkedKeyVaultKey")
    def service_principal_linked_key_vault_key(self) -> Optional[pulumi.Input['LinkedServiceAzureBlobStorageServicePrincipalLinkedKeyVaultKeyArgs']]:
        return pulumi.get(self, "service_principal_linked_key_vault_key")

    @service_principal_linked_key_vault_key.setter
    def service_principal_linked_key_vault_key(self, value: Optional[pulumi.Input['LinkedServiceAzureBlobStorageServicePrincipalLinkedKeyVaultKeyArgs']]):
        pulumi.set(self, "service_principal_linked_key_vault_key", value)

    @_builtins.property
    @pulumi.getter(name="storageKind")
    def storage_kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "storage_kind")

    @storage_kind.setter
    def storage_kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_kind", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)

    @_builtins.property
    @pulumi.getter(name="useManagedIdentity")
    def use_managed_identity(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "use_managed_identity")

    @use_managed_identity.setter
    def use_managed_identity(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_managed_identity", value)


@pulumi.type_token("azure:datafactory/linkedServiceAzureBlobStorage:LinkedServiceAzureBlobStorage")
class LinkedServiceAzureBlobStorage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string_insecure: Optional[pulumi.Input[_builtins.str]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 integration_runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_sas_token: Optional[pulumi.Input[Union['LinkedServiceAzureBlobStorageKeyVaultSasTokenArgs', 'LinkedServiceAzureBlobStorageKeyVaultSasTokenArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 sas_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 service_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_key: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_linked_key_vault_key: Optional[pulumi.Input[Union['LinkedServiceAzureBlobStorageServicePrincipalLinkedKeyVaultKeyArgs', 'LinkedServiceAzureBlobStorageServicePrincipalLinkedKeyVaultKeyArgsDict']]] = None,
                 storage_kind: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 use_managed_identity: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages a Linked Service (connection) between an Azure Blob Storage Account and Azure Data Factory.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example = azure.storage.get_account_output(name="storageaccountname",
            resource_group_name=example_resource_group.name)
        example_factory = azure.datafactory.Factory("example",
            name="example",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name)
        example_linked_service_azure_blob_storage = azure.datafactory.LinkedServiceAzureBlobStorage("example",
            name="example",
            data_factory_id=example_factory.id,
            connection_string=example.primary_connection_string)
        ```

        ## Import

        Data Factory Linked Service's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/linkedServiceAzureBlobStorage:LinkedServiceAzureBlobStorage example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example/linkedservices/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Linked Service.
               
               The following supported arguments are specific to Azure Blob Storage Linked Service:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] connection_string: The connection string. Conflicts with `connection_string_insecure`, `sas_uri` and `service_endpoint`.
        :param pulumi.Input[_builtins.str] connection_string_insecure: The connection string sent insecurely. Conflicts with `connection_string`, `sas_uri` and `service_endpoint`.
               
               > **Note:** `connection_string` uses the Azure [SecureString](https://learn.microsoft.com/en-us/dotnet/api/microsoft.azure.management.datafactory.models.securestring) to encrypt the contents within the REST payload sent to Azure whilst the `connection_string_insecure` is sent as a regular string. Both properties are still sent using SSL/HTTPS. At this time the portal will not decrypt Secure Strings so the `connection_string` property in the portal will show as `******` whilst `connection_string_insecure` will be viewable in the portal.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] integration_runtime_name: The integration runtime reference to associate with the Data Factory Linked Service.
        :param pulumi.Input[Union['LinkedServiceAzureBlobStorageKeyVaultSasTokenArgs', 'LinkedServiceAzureBlobStorageKeyVaultSasTokenArgsDict']] key_vault_sas_token: A `key_vault_sas_token` block as defined below. Use this argument to store SAS Token in an existing Key Vault. It needs an existing Key Vault Data Factory Linked Service. A `sas_uri` is required.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] sas_uri: The SAS URI. Conflicts with `connection_string_insecure`, `connection_string` and `service_endpoint`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LinkedServiceAzureBlobStorageArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Linked Service (connection) between an Azure Blob Storage Account and Azure Data Factory.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example_resource_group = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example = azure.storage.get_account_output(name="storageaccountname",
            resource_group_name=example_resource_group.name)
        example_factory = azure.datafactory.Factory("example",
            name="example",
            location=example_resource_group.location,
            resource_group_name=example_resource_group.name)
        example_linked_service_azure_blob_storage = azure.datafactory.LinkedServiceAzureBlobStorage("example",
            name="example",
            data_factory_id=example_factory.id,
            connection_string=example.primary_connection_string)
        ```

        ## Import

        Data Factory Linked Service's can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:datafactory/linkedServiceAzureBlobStorage:LinkedServiceAzureBlobStorage example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/example/providers/Microsoft.DataFactory/factories/example/linkedservices/example
        ```

        :param str resource_name: The name of the resource.
        :param LinkedServiceAzureBlobStorageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LinkedServiceAzureBlobStorageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_string_insecure: Optional[pulumi.Input[_builtins.str]] = None,
                 data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 integration_runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_sas_token: Optional[pulumi.Input[Union['LinkedServiceAzureBlobStorageKeyVaultSasTokenArgs', 'LinkedServiceAzureBlobStorageKeyVaultSasTokenArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 sas_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 service_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_key: Optional[pulumi.Input[_builtins.str]] = None,
                 service_principal_linked_key_vault_key: Optional[pulumi.Input[Union['LinkedServiceAzureBlobStorageServicePrincipalLinkedKeyVaultKeyArgs', 'LinkedServiceAzureBlobStorageServicePrincipalLinkedKeyVaultKeyArgsDict']]] = None,
                 storage_kind: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
                 use_managed_identity: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LinkedServiceAzureBlobStorageArgs.__new__(LinkedServiceAzureBlobStorageArgs)

            __props__.__dict__["additional_properties"] = additional_properties
            __props__.__dict__["annotations"] = annotations
            __props__.__dict__["connection_string"] = None if connection_string is None else pulumi.Output.secret(connection_string)
            __props__.__dict__["connection_string_insecure"] = connection_string_insecure
            if data_factory_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_factory_id'")
            __props__.__dict__["data_factory_id"] = data_factory_id
            __props__.__dict__["description"] = description
            __props__.__dict__["integration_runtime_name"] = integration_runtime_name
            __props__.__dict__["key_vault_sas_token"] = key_vault_sas_token
            __props__.__dict__["name"] = name
            __props__.__dict__["parameters"] = parameters
            __props__.__dict__["sas_uri"] = None if sas_uri is None else pulumi.Output.secret(sas_uri)
            __props__.__dict__["service_endpoint"] = None if service_endpoint is None else pulumi.Output.secret(service_endpoint)
            __props__.__dict__["service_principal_id"] = service_principal_id
            __props__.__dict__["service_principal_key"] = service_principal_key
            __props__.__dict__["service_principal_linked_key_vault_key"] = service_principal_linked_key_vault_key
            __props__.__dict__["storage_kind"] = storage_kind
            __props__.__dict__["tenant_id"] = tenant_id
            __props__.__dict__["use_managed_identity"] = use_managed_identity
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["connectionString", "sasUri", "serviceEndpoint"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(LinkedServiceAzureBlobStorage, __self__).__init__(
            'azure:datafactory/linkedServiceAzureBlobStorage:LinkedServiceAzureBlobStorage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_properties: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            annotations: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            connection_string: Optional[pulumi.Input[_builtins.str]] = None,
            connection_string_insecure: Optional[pulumi.Input[_builtins.str]] = None,
            data_factory_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            integration_runtime_name: Optional[pulumi.Input[_builtins.str]] = None,
            key_vault_sas_token: Optional[pulumi.Input[Union['LinkedServiceAzureBlobStorageKeyVaultSasTokenArgs', 'LinkedServiceAzureBlobStorageKeyVaultSasTokenArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            parameters: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            sas_uri: Optional[pulumi.Input[_builtins.str]] = None,
            service_endpoint: Optional[pulumi.Input[_builtins.str]] = None,
            service_principal_id: Optional[pulumi.Input[_builtins.str]] = None,
            service_principal_key: Optional[pulumi.Input[_builtins.str]] = None,
            service_principal_linked_key_vault_key: Optional[pulumi.Input[Union['LinkedServiceAzureBlobStorageServicePrincipalLinkedKeyVaultKeyArgs', 'LinkedServiceAzureBlobStorageServicePrincipalLinkedKeyVaultKeyArgsDict']]] = None,
            storage_kind: Optional[pulumi.Input[_builtins.str]] = None,
            tenant_id: Optional[pulumi.Input[_builtins.str]] = None,
            use_managed_identity: Optional[pulumi.Input[_builtins.bool]] = None) -> 'LinkedServiceAzureBlobStorage':
        """
        Get an existing LinkedServiceAzureBlobStorage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] additional_properties: A map of additional properties to associate with the Data Factory Linked Service.
               
               The following supported arguments are specific to Azure Blob Storage Linked Service:
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] annotations: List of tags that can be used for describing the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] connection_string: The connection string. Conflicts with `connection_string_insecure`, `sas_uri` and `service_endpoint`.
        :param pulumi.Input[_builtins.str] connection_string_insecure: The connection string sent insecurely. Conflicts with `connection_string`, `sas_uri` and `service_endpoint`.
               
               > **Note:** `connection_string` uses the Azure [SecureString](https://learn.microsoft.com/en-us/dotnet/api/microsoft.azure.management.datafactory.models.securestring) to encrypt the contents within the REST payload sent to Azure whilst the `connection_string_insecure` is sent as a regular string. Both properties are still sent using SSL/HTTPS. At this time the portal will not decrypt Secure Strings so the `connection_string` property in the portal will show as `******` whilst `connection_string_insecure` will be viewable in the portal.
        :param pulumi.Input[_builtins.str] data_factory_id: The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        :param pulumi.Input[_builtins.str] description: The description for the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] integration_runtime_name: The integration runtime reference to associate with the Data Factory Linked Service.
        :param pulumi.Input[Union['LinkedServiceAzureBlobStorageKeyVaultSasTokenArgs', 'LinkedServiceAzureBlobStorageKeyVaultSasTokenArgsDict']] key_vault_sas_token: A `key_vault_sas_token` block as defined below. Use this argument to store SAS Token in an existing Key Vault. It needs an existing Key Vault Data Factory Linked Service. A `sas_uri` is required.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] parameters: A map of parameters to associate with the Data Factory Linked Service.
        :param pulumi.Input[_builtins.str] sas_uri: The SAS URI. Conflicts with `connection_string_insecure`, `connection_string` and `service_endpoint`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LinkedServiceAzureBlobStorageState.__new__(_LinkedServiceAzureBlobStorageState)

        __props__.__dict__["additional_properties"] = additional_properties
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["connection_string"] = connection_string
        __props__.__dict__["connection_string_insecure"] = connection_string_insecure
        __props__.__dict__["data_factory_id"] = data_factory_id
        __props__.__dict__["description"] = description
        __props__.__dict__["integration_runtime_name"] = integration_runtime_name
        __props__.__dict__["key_vault_sas_token"] = key_vault_sas_token
        __props__.__dict__["name"] = name
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["sas_uri"] = sas_uri
        __props__.__dict__["service_endpoint"] = service_endpoint
        __props__.__dict__["service_principal_id"] = service_principal_id
        __props__.__dict__["service_principal_key"] = service_principal_key
        __props__.__dict__["service_principal_linked_key_vault_key"] = service_principal_linked_key_vault_key
        __props__.__dict__["storage_kind"] = storage_kind
        __props__.__dict__["tenant_id"] = tenant_id
        __props__.__dict__["use_managed_identity"] = use_managed_identity
        return LinkedServiceAzureBlobStorage(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="additionalProperties")
    def additional_properties(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of additional properties to associate with the Data Factory Linked Service.

        The following supported arguments are specific to Azure Blob Storage Linked Service:
        """
        return pulumi.get(self, "additional_properties")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        List of tags that can be used for describing the Data Factory Linked Service.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The connection string. Conflicts with `connection_string_insecure`, `sas_uri` and `service_endpoint`.
        """
        return pulumi.get(self, "connection_string")

    @_builtins.property
    @pulumi.getter(name="connectionStringInsecure")
    def connection_string_insecure(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The connection string sent insecurely. Conflicts with `connection_string`, `sas_uri` and `service_endpoint`.

        > **Note:** `connection_string` uses the Azure [SecureString](https://learn.microsoft.com/en-us/dotnet/api/microsoft.azure.management.datafactory.models.securestring) to encrypt the contents within the REST payload sent to Azure whilst the `connection_string_insecure` is sent as a regular string. Both properties are still sent using SSL/HTTPS. At this time the portal will not decrypt Secure Strings so the `connection_string` property in the portal will show as `******` whilst `connection_string_insecure` will be viewable in the portal.
        """
        return pulumi.get(self, "connection_string_insecure")

    @_builtins.property
    @pulumi.getter(name="dataFactoryId")
    def data_factory_id(self) -> pulumi.Output[_builtins.str]:
        """
        The Data Factory ID in which to associate the Linked Service with. Changing this forces a new resource.
        """
        return pulumi.get(self, "data_factory_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description for the Data Factory Linked Service.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="integrationRuntimeName")
    def integration_runtime_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The integration runtime reference to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "integration_runtime_name")

    @_builtins.property
    @pulumi.getter(name="keyVaultSasToken")
    def key_vault_sas_token(self) -> pulumi.Output[Optional['outputs.LinkedServiceAzureBlobStorageKeyVaultSasToken']]:
        """
        A `key_vault_sas_token` block as defined below. Use this argument to store SAS Token in an existing Key Vault. It needs an existing Key Vault Data Factory Linked Service. A `sas_uri` is required.
        """
        return pulumi.get(self, "key_vault_sas_token")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Data Factory Linked Service. Changing this forces a new resource to be created. Must be unique within a data factory. See the [Microsoft documentation](https://docs.microsoft.com/azure/data-factory/naming-rules) for all restrictions.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A map of parameters to associate with the Data Factory Linked Service.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="sasUri")
    def sas_uri(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The SAS URI. Conflicts with `connection_string_insecure`, `connection_string` and `service_endpoint`.
        """
        return pulumi.get(self, "sas_uri")

    @_builtins.property
    @pulumi.getter(name="serviceEndpoint")
    def service_endpoint(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "service_endpoint")

    @_builtins.property
    @pulumi.getter(name="servicePrincipalId")
    def service_principal_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "service_principal_id")

    @_builtins.property
    @pulumi.getter(name="servicePrincipalKey")
    def service_principal_key(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "service_principal_key")

    @_builtins.property
    @pulumi.getter(name="servicePrincipalLinkedKeyVaultKey")
    def service_principal_linked_key_vault_key(self) -> pulumi.Output[Optional['outputs.LinkedServiceAzureBlobStorageServicePrincipalLinkedKeyVaultKey']]:
        return pulumi.get(self, "service_principal_linked_key_vault_key")

    @_builtins.property
    @pulumi.getter(name="storageKind")
    def storage_kind(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "storage_kind")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter(name="useManagedIdentity")
    def use_managed_identity(self) -> pulumi.Output[Optional[_builtins.bool]]:
        return pulumi.get(self, "use_managed_identity")

