# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['HostPoolArgs', 'HostPool']

@pulumi.input_type
class HostPoolArgs:
    def __init__(__self__, *,
                 load_balancer_type: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 custom_rdp_properties: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_sessions_allowed: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 personal_desktop_assignment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_app_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_agent_updates: Optional[pulumi.Input['HostPoolScheduledAgentUpdatesArgs']] = None,
                 start_vm_on_connect: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 validate_environment: Optional[pulumi.Input[_builtins.bool]] = None,
                 vm_template: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a HostPool resource.
        :param pulumi.Input[_builtins.str] load_balancer_type: `BreadthFirst` load balancing distributes new user sessions across all available session hosts in the host pool. Possible values are `BreadthFirst`, `DepthFirst` and `Persistent`.
               `DepthFirst` load balancing distributes new user sessions to an available session host with the highest number of connections but has not reached its maximum session limit threshold.
               `Persistent` should be used if the host pool type is `Personal`
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Virtual Desktop Host Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] type: The type of the Virtual Desktop Host Pool. Valid options are `Personal` or `Pooled`. Changing the type forces a new resource to be created.
        :param pulumi.Input[_builtins.str] custom_rdp_properties: A valid custom RDP properties string for the Virtual Desktop Host Pool, available properties can be [found in this article](https://docs.microsoft.com/windows-server/remote/remote-desktop-services/clients/rdp-files).
        :param pulumi.Input[_builtins.str] description: A description for the Virtual Desktop Host Pool.
        :param pulumi.Input[_builtins.str] friendly_name: A friendly name for the Virtual Desktop Host Pool.
        :param pulumi.Input[_builtins.str] location: The location/region where the Virtual Desktop Host Pool is located. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] maximum_sessions_allowed: A valid integer value from 0 to 999999 for the maximum number of users that have concurrent sessions on a session host.
               Should only be set if the `type` of your Virtual Desktop Host Pool is `Pooled`.
        :param pulumi.Input[_builtins.str] name: The name of the Virtual Desktop Host Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] personal_desktop_assignment_type: `Automatic` assignment – The service will select an available host and assign it to an user. Possible values are `Automatic` and `Direct`. `Direct` Assignment – Admin selects a specific host to assign to an user. Changing this forces a new resource to be created.
               
               > **Note:** `personal_desktop_assignment_type` is required if the `type` of your Virtual Desktop Host Pool is `Personal`
        :param pulumi.Input[_builtins.str] preferred_app_group_type: Option to specify the preferred Application Group type for the Virtual Desktop Host Pool. Valid options are `None`, `Desktop` or `RailApplications`. Default is `Desktop`.
        :param pulumi.Input[_builtins.str] public_network_access: Whether public network access is allowed for the Virtual Desktop Host Pool. Possible values are `Enabled`, `Disabled`, `EnabledForClientsOnly` and `EnabledForSessionHostsOnly`. Defaults to `Enabled`.
        :param pulumi.Input['HostPoolScheduledAgentUpdatesArgs'] scheduled_agent_updates: A `scheduled_agent_updates` block as defined below. This enables control of when Agent Updates will be applied to Session Hosts.
        :param pulumi.Input[_builtins.bool] start_vm_on_connect: Enables or disables the Start VM on Connection Feature. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.bool] validate_environment: Allows you to test service changes before they are deployed to production. Defaults to `false`.
        :param pulumi.Input[_builtins.str] vm_template: A VM template for session hosts configuration within hostpool. This is a JSON string.
        """
        pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "type", type)
        if custom_rdp_properties is not None:
            pulumi.set(__self__, "custom_rdp_properties", custom_rdp_properties)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maximum_sessions_allowed is not None:
            pulumi.set(__self__, "maximum_sessions_allowed", maximum_sessions_allowed)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if personal_desktop_assignment_type is not None:
            pulumi.set(__self__, "personal_desktop_assignment_type", personal_desktop_assignment_type)
        if preferred_app_group_type is not None:
            pulumi.set(__self__, "preferred_app_group_type", preferred_app_group_type)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if scheduled_agent_updates is not None:
            pulumi.set(__self__, "scheduled_agent_updates", scheduled_agent_updates)
        if start_vm_on_connect is not None:
            pulumi.set(__self__, "start_vm_on_connect", start_vm_on_connect)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if validate_environment is not None:
            pulumi.set(__self__, "validate_environment", validate_environment)
        if vm_template is not None:
            pulumi.set(__self__, "vm_template", vm_template)

    @_builtins.property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> pulumi.Input[_builtins.str]:
        """
        `BreadthFirst` load balancing distributes new user sessions across all available session hosts in the host pool. Possible values are `BreadthFirst`, `DepthFirst` and `Persistent`.
        `DepthFirst` load balancing distributes new user sessions to an available session host with the highest number of connections but has not reached its maximum session limit threshold.
        `Persistent` should be used if the host pool type is `Personal`
        """
        return pulumi.get(self, "load_balancer_type")

    @load_balancer_type.setter
    def load_balancer_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "load_balancer_type", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the Virtual Desktop Host Pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the Virtual Desktop Host Pool. Valid options are `Personal` or `Pooled`. Changing the type forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="customRdpProperties")
    def custom_rdp_properties(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A valid custom RDP properties string for the Virtual Desktop Host Pool, available properties can be [found in this article](https://docs.microsoft.com/windows-server/remote/remote-desktop-services/clients/rdp-files).
        """
        return pulumi.get(self, "custom_rdp_properties")

    @custom_rdp_properties.setter
    def custom_rdp_properties(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_rdp_properties", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for the Virtual Desktop Host Pool.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A friendly name for the Virtual Desktop Host Pool.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "friendly_name", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location/region where the Virtual Desktop Host Pool is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maximumSessionsAllowed")
    def maximum_sessions_allowed(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        A valid integer value from 0 to 999999 for the maximum number of users that have concurrent sessions on a session host.
        Should only be set if the `type` of your Virtual Desktop Host Pool is `Pooled`.
        """
        return pulumi.get(self, "maximum_sessions_allowed")

    @maximum_sessions_allowed.setter
    def maximum_sessions_allowed(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_sessions_allowed", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Virtual Desktop Host Pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="personalDesktopAssignmentType")
    def personal_desktop_assignment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `Automatic` assignment – The service will select an available host and assign it to an user. Possible values are `Automatic` and `Direct`. `Direct` Assignment – Admin selects a specific host to assign to an user. Changing this forces a new resource to be created.

        > **Note:** `personal_desktop_assignment_type` is required if the `type` of your Virtual Desktop Host Pool is `Personal`
        """
        return pulumi.get(self, "personal_desktop_assignment_type")

    @personal_desktop_assignment_type.setter
    def personal_desktop_assignment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "personal_desktop_assignment_type", value)

    @_builtins.property
    @pulumi.getter(name="preferredAppGroupType")
    def preferred_app_group_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Option to specify the preferred Application Group type for the Virtual Desktop Host Pool. Valid options are `None`, `Desktop` or `RailApplications`. Default is `Desktop`.
        """
        return pulumi.get(self, "preferred_app_group_type")

    @preferred_app_group_type.setter
    def preferred_app_group_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_app_group_type", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether public network access is allowed for the Virtual Desktop Host Pool. Possible values are `Enabled`, `Disabled`, `EnabledForClientsOnly` and `EnabledForSessionHostsOnly`. Defaults to `Enabled`.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_network_access", value)

    @_builtins.property
    @pulumi.getter(name="scheduledAgentUpdates")
    def scheduled_agent_updates(self) -> Optional[pulumi.Input['HostPoolScheduledAgentUpdatesArgs']]:
        """
        A `scheduled_agent_updates` block as defined below. This enables control of when Agent Updates will be applied to Session Hosts.
        """
        return pulumi.get(self, "scheduled_agent_updates")

    @scheduled_agent_updates.setter
    def scheduled_agent_updates(self, value: Optional[pulumi.Input['HostPoolScheduledAgentUpdatesArgs']]):
        pulumi.set(self, "scheduled_agent_updates", value)

    @_builtins.property
    @pulumi.getter(name="startVmOnConnect")
    def start_vm_on_connect(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables or disables the Start VM on Connection Feature. Defaults to `false`.
        """
        return pulumi.get(self, "start_vm_on_connect")

    @start_vm_on_connect.setter
    def start_vm_on_connect(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "start_vm_on_connect", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="validateEnvironment")
    def validate_environment(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allows you to test service changes before they are deployed to production. Defaults to `false`.
        """
        return pulumi.get(self, "validate_environment")

    @validate_environment.setter
    def validate_environment(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "validate_environment", value)

    @_builtins.property
    @pulumi.getter(name="vmTemplate")
    def vm_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A VM template for session hosts configuration within hostpool. This is a JSON string.
        """
        return pulumi.get(self, "vm_template")

    @vm_template.setter
    def vm_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_template", value)


@pulumi.input_type
class _HostPoolState:
    def __init__(__self__, *,
                 custom_rdp_properties: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_sessions_allowed: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 personal_desktop_assignment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_app_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_agent_updates: Optional[pulumi.Input['HostPoolScheduledAgentUpdatesArgs']] = None,
                 start_vm_on_connect: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 validate_environment: Optional[pulumi.Input[_builtins.bool]] = None,
                 vm_template: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering HostPool resources.
        :param pulumi.Input[_builtins.str] custom_rdp_properties: A valid custom RDP properties string for the Virtual Desktop Host Pool, available properties can be [found in this article](https://docs.microsoft.com/windows-server/remote/remote-desktop-services/clients/rdp-files).
        :param pulumi.Input[_builtins.str] description: A description for the Virtual Desktop Host Pool.
        :param pulumi.Input[_builtins.str] friendly_name: A friendly name for the Virtual Desktop Host Pool.
        :param pulumi.Input[_builtins.str] load_balancer_type: `BreadthFirst` load balancing distributes new user sessions across all available session hosts in the host pool. Possible values are `BreadthFirst`, `DepthFirst` and `Persistent`.
               `DepthFirst` load balancing distributes new user sessions to an available session host with the highest number of connections but has not reached its maximum session limit threshold.
               `Persistent` should be used if the host pool type is `Personal`
        :param pulumi.Input[_builtins.str] location: The location/region where the Virtual Desktop Host Pool is located. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] maximum_sessions_allowed: A valid integer value from 0 to 999999 for the maximum number of users that have concurrent sessions on a session host.
               Should only be set if the `type` of your Virtual Desktop Host Pool is `Pooled`.
        :param pulumi.Input[_builtins.str] name: The name of the Virtual Desktop Host Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] personal_desktop_assignment_type: `Automatic` assignment – The service will select an available host and assign it to an user. Possible values are `Automatic` and `Direct`. `Direct` Assignment – Admin selects a specific host to assign to an user. Changing this forces a new resource to be created.
               
               > **Note:** `personal_desktop_assignment_type` is required if the `type` of your Virtual Desktop Host Pool is `Personal`
        :param pulumi.Input[_builtins.str] preferred_app_group_type: Option to specify the preferred Application Group type for the Virtual Desktop Host Pool. Valid options are `None`, `Desktop` or `RailApplications`. Default is `Desktop`.
        :param pulumi.Input[_builtins.str] public_network_access: Whether public network access is allowed for the Virtual Desktop Host Pool. Possible values are `Enabled`, `Disabled`, `EnabledForClientsOnly` and `EnabledForSessionHostsOnly`. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Virtual Desktop Host Pool. Changing this forces a new resource to be created.
        :param pulumi.Input['HostPoolScheduledAgentUpdatesArgs'] scheduled_agent_updates: A `scheduled_agent_updates` block as defined below. This enables control of when Agent Updates will be applied to Session Hosts.
        :param pulumi.Input[_builtins.bool] start_vm_on_connect: Enables or disables the Start VM on Connection Feature. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] type: The type of the Virtual Desktop Host Pool. Valid options are `Personal` or `Pooled`. Changing the type forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] validate_environment: Allows you to test service changes before they are deployed to production. Defaults to `false`.
        :param pulumi.Input[_builtins.str] vm_template: A VM template for session hosts configuration within hostpool. This is a JSON string.
        """
        if custom_rdp_properties is not None:
            pulumi.set(__self__, "custom_rdp_properties", custom_rdp_properties)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if load_balancer_type is not None:
            pulumi.set(__self__, "load_balancer_type", load_balancer_type)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maximum_sessions_allowed is not None:
            pulumi.set(__self__, "maximum_sessions_allowed", maximum_sessions_allowed)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if personal_desktop_assignment_type is not None:
            pulumi.set(__self__, "personal_desktop_assignment_type", personal_desktop_assignment_type)
        if preferred_app_group_type is not None:
            pulumi.set(__self__, "preferred_app_group_type", preferred_app_group_type)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if scheduled_agent_updates is not None:
            pulumi.set(__self__, "scheduled_agent_updates", scheduled_agent_updates)
        if start_vm_on_connect is not None:
            pulumi.set(__self__, "start_vm_on_connect", start_vm_on_connect)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if validate_environment is not None:
            pulumi.set(__self__, "validate_environment", validate_environment)
        if vm_template is not None:
            pulumi.set(__self__, "vm_template", vm_template)

    @_builtins.property
    @pulumi.getter(name="customRdpProperties")
    def custom_rdp_properties(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A valid custom RDP properties string for the Virtual Desktop Host Pool, available properties can be [found in this article](https://docs.microsoft.com/windows-server/remote/remote-desktop-services/clients/rdp-files).
        """
        return pulumi.get(self, "custom_rdp_properties")

    @custom_rdp_properties.setter
    def custom_rdp_properties(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_rdp_properties", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A description for the Virtual Desktop Host Pool.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A friendly name for the Virtual Desktop Host Pool.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "friendly_name", value)

    @_builtins.property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `BreadthFirst` load balancing distributes new user sessions across all available session hosts in the host pool. Possible values are `BreadthFirst`, `DepthFirst` and `Persistent`.
        `DepthFirst` load balancing distributes new user sessions to an available session host with the highest number of connections but has not reached its maximum session limit threshold.
        `Persistent` should be used if the host pool type is `Personal`
        """
        return pulumi.get(self, "load_balancer_type")

    @load_balancer_type.setter
    def load_balancer_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "load_balancer_type", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The location/region where the Virtual Desktop Host Pool is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maximumSessionsAllowed")
    def maximum_sessions_allowed(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        A valid integer value from 0 to 999999 for the maximum number of users that have concurrent sessions on a session host.
        Should only be set if the `type` of your Virtual Desktop Host Pool is `Pooled`.
        """
        return pulumi.get(self, "maximum_sessions_allowed")

    @maximum_sessions_allowed.setter
    def maximum_sessions_allowed(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "maximum_sessions_allowed", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Virtual Desktop Host Pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="personalDesktopAssignmentType")
    def personal_desktop_assignment_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        `Automatic` assignment – The service will select an available host and assign it to an user. Possible values are `Automatic` and `Direct`. `Direct` Assignment – Admin selects a specific host to assign to an user. Changing this forces a new resource to be created.

        > **Note:** `personal_desktop_assignment_type` is required if the `type` of your Virtual Desktop Host Pool is `Personal`
        """
        return pulumi.get(self, "personal_desktop_assignment_type")

    @personal_desktop_assignment_type.setter
    def personal_desktop_assignment_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "personal_desktop_assignment_type", value)

    @_builtins.property
    @pulumi.getter(name="preferredAppGroupType")
    def preferred_app_group_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Option to specify the preferred Application Group type for the Virtual Desktop Host Pool. Valid options are `None`, `Desktop` or `RailApplications`. Default is `Desktop`.
        """
        return pulumi.get(self, "preferred_app_group_type")

    @preferred_app_group_type.setter
    def preferred_app_group_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "preferred_app_group_type", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether public network access is allowed for the Virtual Desktop Host Pool. Possible values are `Enabled`, `Disabled`, `EnabledForClientsOnly` and `EnabledForSessionHostsOnly`. Defaults to `Enabled`.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_network_access", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the Virtual Desktop Host Pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="scheduledAgentUpdates")
    def scheduled_agent_updates(self) -> Optional[pulumi.Input['HostPoolScheduledAgentUpdatesArgs']]:
        """
        A `scheduled_agent_updates` block as defined below. This enables control of when Agent Updates will be applied to Session Hosts.
        """
        return pulumi.get(self, "scheduled_agent_updates")

    @scheduled_agent_updates.setter
    def scheduled_agent_updates(self, value: Optional[pulumi.Input['HostPoolScheduledAgentUpdatesArgs']]):
        pulumi.set(self, "scheduled_agent_updates", value)

    @_builtins.property
    @pulumi.getter(name="startVmOnConnect")
    def start_vm_on_connect(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enables or disables the Start VM on Connection Feature. Defaults to `false`.
        """
        return pulumi.get(self, "start_vm_on_connect")

    @start_vm_on_connect.setter
    def start_vm_on_connect(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "start_vm_on_connect", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the Virtual Desktop Host Pool. Valid options are `Personal` or `Pooled`. Changing the type forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="validateEnvironment")
    def validate_environment(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allows you to test service changes before they are deployed to production. Defaults to `false`.
        """
        return pulumi.get(self, "validate_environment")

    @validate_environment.setter
    def validate_environment(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "validate_environment", value)

    @_builtins.property
    @pulumi.getter(name="vmTemplate")
    def vm_template(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A VM template for session hosts configuration within hostpool. This is a JSON string.
        """
        return pulumi.get(self, "vm_template")

    @vm_template.setter
    def vm_template(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_template", value)


@pulumi.type_token("azure:desktopvirtualization/hostPool:HostPool")
class HostPool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_rdp_properties: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_sessions_allowed: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 personal_desktop_assignment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_app_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_agent_updates: Optional[pulumi.Input[Union['HostPoolScheduledAgentUpdatesArgs', 'HostPoolScheduledAgentUpdatesArgsDict']]] = None,
                 start_vm_on_connect: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 validate_environment: Optional[pulumi.Input[_builtins.bool]] = None,
                 vm_template: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Virtual Desktop Host Pool.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_host_pool = azure.desktopvirtualization.HostPool("example",
            location=example.location,
            resource_group_name=example.name,
            name="pooleddepthfirst",
            friendly_name="pooleddepthfirst",
            validate_environment=True,
            start_vm_on_connect=True,
            custom_rdp_properties="audiocapturemode:i:1;audiomode:i:0;",
            description="Acceptance Test: A pooled host pool - pooleddepthfirst",
            type="Pooled",
            maximum_sessions_allowed=50,
            load_balancer_type="DepthFirst",
            scheduled_agent_updates={
                "enabled": True,
                "schedules": [{
                    "day_of_week": "Saturday",
                    "hour_of_day": 2,
                }],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DesktopVirtualization` - 2024-04-03

        ## Import

        Virtual Desktop Host Pools can be imported using the `resource id`, e.g.

        text

        ```sh
        $ pulumi import azure:desktopvirtualization/hostPool:HostPool example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myGroup1/providers/Microsoft.DesktopVirtualization/hostPools/myhostpool
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_rdp_properties: A valid custom RDP properties string for the Virtual Desktop Host Pool, available properties can be [found in this article](https://docs.microsoft.com/windows-server/remote/remote-desktop-services/clients/rdp-files).
        :param pulumi.Input[_builtins.str] description: A description for the Virtual Desktop Host Pool.
        :param pulumi.Input[_builtins.str] friendly_name: A friendly name for the Virtual Desktop Host Pool.
        :param pulumi.Input[_builtins.str] load_balancer_type: `BreadthFirst` load balancing distributes new user sessions across all available session hosts in the host pool. Possible values are `BreadthFirst`, `DepthFirst` and `Persistent`.
               `DepthFirst` load balancing distributes new user sessions to an available session host with the highest number of connections but has not reached its maximum session limit threshold.
               `Persistent` should be used if the host pool type is `Personal`
        :param pulumi.Input[_builtins.str] location: The location/region where the Virtual Desktop Host Pool is located. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] maximum_sessions_allowed: A valid integer value from 0 to 999999 for the maximum number of users that have concurrent sessions on a session host.
               Should only be set if the `type` of your Virtual Desktop Host Pool is `Pooled`.
        :param pulumi.Input[_builtins.str] name: The name of the Virtual Desktop Host Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] personal_desktop_assignment_type: `Automatic` assignment – The service will select an available host and assign it to an user. Possible values are `Automatic` and `Direct`. `Direct` Assignment – Admin selects a specific host to assign to an user. Changing this forces a new resource to be created.
               
               > **Note:** `personal_desktop_assignment_type` is required if the `type` of your Virtual Desktop Host Pool is `Personal`
        :param pulumi.Input[_builtins.str] preferred_app_group_type: Option to specify the preferred Application Group type for the Virtual Desktop Host Pool. Valid options are `None`, `Desktop` or `RailApplications`. Default is `Desktop`.
        :param pulumi.Input[_builtins.str] public_network_access: Whether public network access is allowed for the Virtual Desktop Host Pool. Possible values are `Enabled`, `Disabled`, `EnabledForClientsOnly` and `EnabledForSessionHostsOnly`. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Virtual Desktop Host Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['HostPoolScheduledAgentUpdatesArgs', 'HostPoolScheduledAgentUpdatesArgsDict']] scheduled_agent_updates: A `scheduled_agent_updates` block as defined below. This enables control of when Agent Updates will be applied to Session Hosts.
        :param pulumi.Input[_builtins.bool] start_vm_on_connect: Enables or disables the Start VM on Connection Feature. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] type: The type of the Virtual Desktop Host Pool. Valid options are `Personal` or `Pooled`. Changing the type forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] validate_environment: Allows you to test service changes before they are deployed to production. Defaults to `false`.
        :param pulumi.Input[_builtins.str] vm_template: A VM template for session hosts configuration within hostpool. This is a JSON string.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HostPoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Virtual Desktop Host Pool.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_host_pool = azure.desktopvirtualization.HostPool("example",
            location=example.location,
            resource_group_name=example.name,
            name="pooleddepthfirst",
            friendly_name="pooleddepthfirst",
            validate_environment=True,
            start_vm_on_connect=True,
            custom_rdp_properties="audiocapturemode:i:1;audiomode:i:0;",
            description="Acceptance Test: A pooled host pool - pooleddepthfirst",
            type="Pooled",
            maximum_sessions_allowed=50,
            load_balancer_type="DepthFirst",
            scheduled_agent_updates={
                "enabled": True,
                "schedules": [{
                    "day_of_week": "Saturday",
                    "hour_of_day": 2,
                }],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DesktopVirtualization` - 2024-04-03

        ## Import

        Virtual Desktop Host Pools can be imported using the `resource id`, e.g.

        text

        ```sh
        $ pulumi import azure:desktopvirtualization/hostPool:HostPool example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/myGroup1/providers/Microsoft.DesktopVirtualization/hostPools/myhostpool
        ```

        :param str resource_name: The name of the resource.
        :param HostPoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HostPoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_rdp_properties: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
                 load_balancer_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maximum_sessions_allowed: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 personal_desktop_assignment_type: Optional[pulumi.Input[_builtins.str]] = None,
                 preferred_app_group_type: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scheduled_agent_updates: Optional[pulumi.Input[Union['HostPoolScheduledAgentUpdatesArgs', 'HostPoolScheduledAgentUpdatesArgsDict']]] = None,
                 start_vm_on_connect: Optional[pulumi.Input[_builtins.bool]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 type: Optional[pulumi.Input[_builtins.str]] = None,
                 validate_environment: Optional[pulumi.Input[_builtins.bool]] = None,
                 vm_template: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HostPoolArgs.__new__(HostPoolArgs)

            __props__.__dict__["custom_rdp_properties"] = custom_rdp_properties
            __props__.__dict__["description"] = description
            __props__.__dict__["friendly_name"] = friendly_name
            if load_balancer_type is None and not opts.urn:
                raise TypeError("Missing required property 'load_balancer_type'")
            __props__.__dict__["load_balancer_type"] = load_balancer_type
            __props__.__dict__["location"] = location
            __props__.__dict__["maximum_sessions_allowed"] = maximum_sessions_allowed
            __props__.__dict__["name"] = name
            __props__.__dict__["personal_desktop_assignment_type"] = personal_desktop_assignment_type
            __props__.__dict__["preferred_app_group_type"] = preferred_app_group_type
            __props__.__dict__["public_network_access"] = public_network_access
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["scheduled_agent_updates"] = scheduled_agent_updates
            __props__.__dict__["start_vm_on_connect"] = start_vm_on_connect
            __props__.__dict__["tags"] = tags
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["validate_environment"] = validate_environment
            __props__.__dict__["vm_template"] = vm_template
        super(HostPool, __self__).__init__(
            'azure:desktopvirtualization/hostPool:HostPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_rdp_properties: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
            load_balancer_type: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            maximum_sessions_allowed: Optional[pulumi.Input[_builtins.int]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            personal_desktop_assignment_type: Optional[pulumi.Input[_builtins.str]] = None,
            preferred_app_group_type: Optional[pulumi.Input[_builtins.str]] = None,
            public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            scheduled_agent_updates: Optional[pulumi.Input[Union['HostPoolScheduledAgentUpdatesArgs', 'HostPoolScheduledAgentUpdatesArgsDict']]] = None,
            start_vm_on_connect: Optional[pulumi.Input[_builtins.bool]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            type: Optional[pulumi.Input[_builtins.str]] = None,
            validate_environment: Optional[pulumi.Input[_builtins.bool]] = None,
            vm_template: Optional[pulumi.Input[_builtins.str]] = None) -> 'HostPool':
        """
        Get an existing HostPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] custom_rdp_properties: A valid custom RDP properties string for the Virtual Desktop Host Pool, available properties can be [found in this article](https://docs.microsoft.com/windows-server/remote/remote-desktop-services/clients/rdp-files).
        :param pulumi.Input[_builtins.str] description: A description for the Virtual Desktop Host Pool.
        :param pulumi.Input[_builtins.str] friendly_name: A friendly name for the Virtual Desktop Host Pool.
        :param pulumi.Input[_builtins.str] load_balancer_type: `BreadthFirst` load balancing distributes new user sessions across all available session hosts in the host pool. Possible values are `BreadthFirst`, `DepthFirst` and `Persistent`.
               `DepthFirst` load balancing distributes new user sessions to an available session host with the highest number of connections but has not reached its maximum session limit threshold.
               `Persistent` should be used if the host pool type is `Personal`
        :param pulumi.Input[_builtins.str] location: The location/region where the Virtual Desktop Host Pool is located. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.int] maximum_sessions_allowed: A valid integer value from 0 to 999999 for the maximum number of users that have concurrent sessions on a session host.
               Should only be set if the `type` of your Virtual Desktop Host Pool is `Pooled`.
        :param pulumi.Input[_builtins.str] name: The name of the Virtual Desktop Host Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] personal_desktop_assignment_type: `Automatic` assignment – The service will select an available host and assign it to an user. Possible values are `Automatic` and `Direct`. `Direct` Assignment – Admin selects a specific host to assign to an user. Changing this forces a new resource to be created.
               
               > **Note:** `personal_desktop_assignment_type` is required if the `type` of your Virtual Desktop Host Pool is `Personal`
        :param pulumi.Input[_builtins.str] preferred_app_group_type: Option to specify the preferred Application Group type for the Virtual Desktop Host Pool. Valid options are `None`, `Desktop` or `RailApplications`. Default is `Desktop`.
        :param pulumi.Input[_builtins.str] public_network_access: Whether public network access is allowed for the Virtual Desktop Host Pool. Possible values are `Enabled`, `Disabled`, `EnabledForClientsOnly` and `EnabledForSessionHostsOnly`. Defaults to `Enabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Virtual Desktop Host Pool. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['HostPoolScheduledAgentUpdatesArgs', 'HostPoolScheduledAgentUpdatesArgsDict']] scheduled_agent_updates: A `scheduled_agent_updates` block as defined below. This enables control of when Agent Updates will be applied to Session Hosts.
        :param pulumi.Input[_builtins.bool] start_vm_on_connect: Enables or disables the Start VM on Connection Feature. Defaults to `false`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] type: The type of the Virtual Desktop Host Pool. Valid options are `Personal` or `Pooled`. Changing the type forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] validate_environment: Allows you to test service changes before they are deployed to production. Defaults to `false`.
        :param pulumi.Input[_builtins.str] vm_template: A VM template for session hosts configuration within hostpool. This is a JSON string.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HostPoolState.__new__(_HostPoolState)

        __props__.__dict__["custom_rdp_properties"] = custom_rdp_properties
        __props__.__dict__["description"] = description
        __props__.__dict__["friendly_name"] = friendly_name
        __props__.__dict__["load_balancer_type"] = load_balancer_type
        __props__.__dict__["location"] = location
        __props__.__dict__["maximum_sessions_allowed"] = maximum_sessions_allowed
        __props__.__dict__["name"] = name
        __props__.__dict__["personal_desktop_assignment_type"] = personal_desktop_assignment_type
        __props__.__dict__["preferred_app_group_type"] = preferred_app_group_type
        __props__.__dict__["public_network_access"] = public_network_access
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["scheduled_agent_updates"] = scheduled_agent_updates
        __props__.__dict__["start_vm_on_connect"] = start_vm_on_connect
        __props__.__dict__["tags"] = tags
        __props__.__dict__["type"] = type
        __props__.__dict__["validate_environment"] = validate_environment
        __props__.__dict__["vm_template"] = vm_template
        return HostPool(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="customRdpProperties")
    def custom_rdp_properties(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A valid custom RDP properties string for the Virtual Desktop Host Pool, available properties can be [found in this article](https://docs.microsoft.com/windows-server/remote/remote-desktop-services/clients/rdp-files).
        """
        return pulumi.get(self, "custom_rdp_properties")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A description for the Virtual Desktop Host Pool.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A friendly name for the Virtual Desktop Host Pool.
        """
        return pulumi.get(self, "friendly_name")

    @_builtins.property
    @pulumi.getter(name="loadBalancerType")
    def load_balancer_type(self) -> pulumi.Output[_builtins.str]:
        """
        `BreadthFirst` load balancing distributes new user sessions across all available session hosts in the host pool. Possible values are `BreadthFirst`, `DepthFirst` and `Persistent`.
        `DepthFirst` load balancing distributes new user sessions to an available session host with the highest number of connections but has not reached its maximum session limit threshold.
        `Persistent` should be used if the host pool type is `Personal`
        """
        return pulumi.get(self, "load_balancer_type")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The location/region where the Virtual Desktop Host Pool is located. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="maximumSessionsAllowed")
    def maximum_sessions_allowed(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        A valid integer value from 0 to 999999 for the maximum number of users that have concurrent sessions on a session host.
        Should only be set if the `type` of your Virtual Desktop Host Pool is `Pooled`.
        """
        return pulumi.get(self, "maximum_sessions_allowed")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Virtual Desktop Host Pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="personalDesktopAssignmentType")
    def personal_desktop_assignment_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        `Automatic` assignment – The service will select an available host and assign it to an user. Possible values are `Automatic` and `Direct`. `Direct` Assignment – Admin selects a specific host to assign to an user. Changing this forces a new resource to be created.

        > **Note:** `personal_desktop_assignment_type` is required if the `type` of your Virtual Desktop Host Pool is `Personal`
        """
        return pulumi.get(self, "personal_desktop_assignment_type")

    @_builtins.property
    @pulumi.getter(name="preferredAppGroupType")
    def preferred_app_group_type(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Option to specify the preferred Application Group type for the Virtual Desktop Host Pool. Valid options are `None`, `Desktop` or `RailApplications`. Default is `Desktop`.
        """
        return pulumi.get(self, "preferred_app_group_type")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Whether public network access is allowed for the Virtual Desktop Host Pool. Possible values are `Enabled`, `Disabled`, `EnabledForClientsOnly` and `EnabledForSessionHostsOnly`. Defaults to `Enabled`.
        """
        return pulumi.get(self, "public_network_access")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the Virtual Desktop Host Pool. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="scheduledAgentUpdates")
    def scheduled_agent_updates(self) -> pulumi.Output[Optional['outputs.HostPoolScheduledAgentUpdates']]:
        """
        A `scheduled_agent_updates` block as defined below. This enables control of when Agent Updates will be applied to Session Hosts.
        """
        return pulumi.get(self, "scheduled_agent_updates")

    @_builtins.property
    @pulumi.getter(name="startVmOnConnect")
    def start_vm_on_connect(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enables or disables the Start VM on Connection Feature. Defaults to `false`.
        """
        return pulumi.get(self, "start_vm_on_connect")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of the Virtual Desktop Host Pool. Valid options are `Personal` or `Pooled`. Changing the type forces a new resource to be created.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="validateEnvironment")
    def validate_environment(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Allows you to test service changes before they are deployed to production. Defaults to `false`.
        """
        return pulumi.get(self, "validate_environment")

    @_builtins.property
    @pulumi.getter(name="vmTemplate")
    def vm_template(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        A VM template for session hosts configuration within hostpool. This is a JSON string.
        """
        return pulumi.get(self, "vm_template")

