# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetResult',
    'AwaitableGetResult',
    'get',
    'get_output',
]

@pulumi.output_type
class GetResult:
    """
    A collection of values returned by get.
    """
    def __init__(__self__, dev_center_uri=None, id=None, identities=None, location=None, name=None, resource_group_name=None, tags=None):
        if dev_center_uri and not isinstance(dev_center_uri, str):
            raise TypeError("Expected argument 'dev_center_uri' to be a str")
        pulumi.set(__self__, "dev_center_uri", dev_center_uri)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="devCenterUri")
    def dev_center_uri(self) -> _builtins.str:
        """
        The URI of the Dev Center.
        """
        return pulumi.get(self, "dev_center_uri")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetIdentityResult']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Dev Center exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the Dev Center.
        """
        return pulumi.get(self, "tags")


class AwaitableGetResult(GetResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetResult(
            dev_center_uri=self.dev_center_uri,
            id=self.id,
            identities=self.identities,
            location=self.location,
            name=self.name,
            resource_group_name=self.resource_group_name,
            tags=self.tags)


def get(name: Optional[_builtins.str] = None,
        resource_group_name: Optional[_builtins.str] = None,
        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetResult:
    """
    Use this data source to access information about an existing Dev Center.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.devcenter.get(name="example",
        resource_group_name="example-resource-group")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DevCenter` - 2025-02-01


    :param _builtins.str name: The name of this Dev Center.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Dev Center exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:devcenter/get:get', __args__, opts=opts, typ=GetResult).value

    return AwaitableGetResult(
        dev_center_uri=pulumi.get(__ret__, 'dev_center_uri'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        tags=pulumi.get(__ret__, 'tags'))
def get_output(name: Optional[pulumi.Input[_builtins.str]] = None,
               resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetResult]:
    """
    Use this data source to access information about an existing Dev Center.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.devcenter.get(name="example",
        resource_group_name="example-resource-group")
    pulumi.export("id", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.DevCenter` - 2025-02-01


    :param _builtins.str name: The name of this Dev Center.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Dev Center exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:devcenter/get:get', __args__, opts=opts, typ=GetResult)
    return __ret__.apply(lambda __response__: GetResult(
        dev_center_uri=pulumi.get(__response__, 'dev_center_uri'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        tags=pulumi.get(__response__, 'tags')))
