# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WindowsVirtualMachineArgs', 'WindowsVirtualMachine']

@pulumi.input_type
class WindowsVirtualMachineArgs:
    def __init__(__self__, *,
                 gallery_image_reference: pulumi.Input['WindowsVirtualMachineGalleryImageReferenceArgs'],
                 lab_name: pulumi.Input[_builtins.str],
                 lab_subnet_name: pulumi.Input[_builtins.str],
                 lab_virtual_network_id: pulumi.Input[_builtins.str],
                 password: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 size: pulumi.Input[_builtins.str],
                 storage_type: pulumi.Input[_builtins.str],
                 username: pulumi.Input[_builtins.str],
                 allow_claim: Optional[pulumi.Input[_builtins.bool]] = None,
                 disallow_public_ip_address: Optional[pulumi.Input[_builtins.bool]] = None,
                 inbound_nat_rules: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineInboundNatRuleArgs']]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a WindowsVirtualMachine resource.
        :param pulumi.Input['WindowsVirtualMachineGalleryImageReferenceArgs'] gallery_image_reference: A `gallery_image_reference` block as defined below.
        :param pulumi.Input[_builtins.str] lab_name: Specifies the name of the Dev Test Lab in which the Virtual Machine should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] lab_subnet_name: The name of a Subnet within the Dev Test Virtual Network where this machine should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] lab_virtual_network_id: The ID of the Dev Test Virtual Network where this Virtual Machine should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] password: The Password associated with the `username` used to login to this Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Dev Test Lab resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] size: The Machine Size to use for this Virtual Machine, such as `Standard_F2`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_type: The type of Storage to use on this Virtual Machine. Possible values are `Standard` and `Premium`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] username: The Username associated with the local administrator on this Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] allow_claim: Can this Virtual Machine be claimed by users? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] disallow_public_ip_address: Should the Virtual Machine be created without a Public IP Address? Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineInboundNatRuleArgs']]] inbound_nat_rules: One or more `inbound_nat_rule` blocks as defined below. Changing this forces a new resource to be created.
               
               > **Note:** If any `inbound_nat_rule` blocks are specified then `disallow_public_ip_address` must be set to `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the Dev Test Lab exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Dev Test Machine. Changing this forces a new resource to be created.
               
               > **Note:** The validation requirements for the Name change based on the `os_type` used in this Virtual Machine. For a Linux VM the name must be between 1-62 characters, and for a Windows VM the name must be between 1-15 characters. It must begin and end with a letter or number, and cannot be all numbers.
        :param pulumi.Input[_builtins.str] notes: Any notes about the Virtual Machine.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "gallery_image_reference", gallery_image_reference)
        pulumi.set(__self__, "lab_name", lab_name)
        pulumi.set(__self__, "lab_subnet_name", lab_subnet_name)
        pulumi.set(__self__, "lab_virtual_network_id", lab_virtual_network_id)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "storage_type", storage_type)
        pulumi.set(__self__, "username", username)
        if allow_claim is not None:
            pulumi.set(__self__, "allow_claim", allow_claim)
        if disallow_public_ip_address is not None:
            pulumi.set(__self__, "disallow_public_ip_address", disallow_public_ip_address)
        if inbound_nat_rules is not None:
            pulumi.set(__self__, "inbound_nat_rules", inbound_nat_rules)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="galleryImageReference")
    def gallery_image_reference(self) -> pulumi.Input['WindowsVirtualMachineGalleryImageReferenceArgs']:
        """
        A `gallery_image_reference` block as defined below.
        """
        return pulumi.get(self, "gallery_image_reference")

    @gallery_image_reference.setter
    def gallery_image_reference(self, value: pulumi.Input['WindowsVirtualMachineGalleryImageReferenceArgs']):
        pulumi.set(self, "gallery_image_reference", value)

    @_builtins.property
    @pulumi.getter(name="labName")
    def lab_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Dev Test Lab in which the Virtual Machine should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "lab_name")

    @lab_name.setter
    def lab_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "lab_name", value)

    @_builtins.property
    @pulumi.getter(name="labSubnetName")
    def lab_subnet_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of a Subnet within the Dev Test Virtual Network where this machine should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "lab_subnet_name")

    @lab_subnet_name.setter
    def lab_subnet_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "lab_subnet_name", value)

    @_builtins.property
    @pulumi.getter(name="labVirtualNetworkId")
    def lab_virtual_network_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Dev Test Virtual Network where this Virtual Machine should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "lab_virtual_network_id")

    @lab_virtual_network_id.setter
    def lab_virtual_network_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "lab_virtual_network_id", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Input[_builtins.str]:
        """
        The Password associated with the `username` used to login to this Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which the Dev Test Lab resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Input[_builtins.str]:
        """
        The Machine Size to use for this Virtual Machine, such as `Standard_F2`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of Storage to use on this Virtual Machine. Possible values are `Standard` and `Premium`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_type", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Input[_builtins.str]:
        """
        The Username associated with the local administrator on this Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "username", value)

    @_builtins.property
    @pulumi.getter(name="allowClaim")
    def allow_claim(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Can this Virtual Machine be claimed by users? Defaults to `true`.
        """
        return pulumi.get(self, "allow_claim")

    @allow_claim.setter
    def allow_claim(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_claim", value)

    @_builtins.property
    @pulumi.getter(name="disallowPublicIpAddress")
    def disallow_public_ip_address(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Virtual Machine be created without a Public IP Address? Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "disallow_public_ip_address")

    @disallow_public_ip_address.setter
    def disallow_public_ip_address(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disallow_public_ip_address", value)

    @_builtins.property
    @pulumi.getter(name="inboundNatRules")
    def inbound_nat_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineInboundNatRuleArgs']]]]:
        """
        One or more `inbound_nat_rule` blocks as defined below. Changing this forces a new resource to be created.

        > **Note:** If any `inbound_nat_rule` blocks are specified then `disallow_public_ip_address` must be set to `true`.
        """
        return pulumi.get(self, "inbound_nat_rules")

    @inbound_nat_rules.setter
    def inbound_nat_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineInboundNatRuleArgs']]]]):
        pulumi.set(self, "inbound_nat_rules", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the Dev Test Lab exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Dev Test Machine. Changing this forces a new resource to be created.

        > **Note:** The validation requirements for the Name change based on the `os_type` used in this Virtual Machine. For a Linux VM the name must be between 1-62 characters, and for a Windows VM the name must be between 1-15 characters. It must begin and end with a letter or number, and cannot be all numbers.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Any notes about the Virtual Machine.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notes", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _WindowsVirtualMachineState:
    def __init__(__self__, *,
                 allow_claim: Optional[pulumi.Input[_builtins.bool]] = None,
                 disallow_public_ip_address: Optional[pulumi.Input[_builtins.bool]] = None,
                 fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 gallery_image_reference: Optional[pulumi.Input['WindowsVirtualMachineGalleryImageReferenceArgs']] = None,
                 inbound_nat_rules: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineInboundNatRuleArgs']]]] = None,
                 lab_name: Optional[pulumi.Input[_builtins.str]] = None,
                 lab_subnet_name: Optional[pulumi.Input[_builtins.str]] = None,
                 lab_virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 unique_identifier: Optional[pulumi.Input[_builtins.str]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering WindowsVirtualMachine resources.
        :param pulumi.Input[_builtins.bool] allow_claim: Can this Virtual Machine be claimed by users? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] disallow_public_ip_address: Should the Virtual Machine be created without a Public IP Address? Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] fqdn: The FQDN of the Virtual Machine.
        :param pulumi.Input['WindowsVirtualMachineGalleryImageReferenceArgs'] gallery_image_reference: A `gallery_image_reference` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineInboundNatRuleArgs']]] inbound_nat_rules: One or more `inbound_nat_rule` blocks as defined below. Changing this forces a new resource to be created.
               
               > **Note:** If any `inbound_nat_rule` blocks are specified then `disallow_public_ip_address` must be set to `true`.
        :param pulumi.Input[_builtins.str] lab_name: Specifies the name of the Dev Test Lab in which the Virtual Machine should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] lab_subnet_name: The name of a Subnet within the Dev Test Virtual Network where this machine should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] lab_virtual_network_id: The ID of the Dev Test Virtual Network where this Virtual Machine should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the Dev Test Lab exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Dev Test Machine. Changing this forces a new resource to be created.
               
               > **Note:** The validation requirements for the Name change based on the `os_type` used in this Virtual Machine. For a Linux VM the name must be between 1-62 characters, and for a Windows VM the name must be between 1-15 characters. It must begin and end with a letter or number, and cannot be all numbers.
        :param pulumi.Input[_builtins.str] notes: Any notes about the Virtual Machine.
        :param pulumi.Input[_builtins.str] password: The Password associated with the `username` used to login to this Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Dev Test Lab resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] size: The Machine Size to use for this Virtual Machine, such as `Standard_F2`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_type: The type of Storage to use on this Virtual Machine. Possible values are `Standard` and `Premium`. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] unique_identifier: The unique immutable identifier of the Virtual Machine.
        :param pulumi.Input[_builtins.str] username: The Username associated with the local administrator on this Virtual Machine. Changing this forces a new resource to be created.
        """
        if allow_claim is not None:
            pulumi.set(__self__, "allow_claim", allow_claim)
        if disallow_public_ip_address is not None:
            pulumi.set(__self__, "disallow_public_ip_address", disallow_public_ip_address)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if gallery_image_reference is not None:
            pulumi.set(__self__, "gallery_image_reference", gallery_image_reference)
        if inbound_nat_rules is not None:
            pulumi.set(__self__, "inbound_nat_rules", inbound_nat_rules)
        if lab_name is not None:
            pulumi.set(__self__, "lab_name", lab_name)
        if lab_subnet_name is not None:
            pulumi.set(__self__, "lab_subnet_name", lab_subnet_name)
        if lab_virtual_network_id is not None:
            pulumi.set(__self__, "lab_virtual_network_id", lab_virtual_network_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if unique_identifier is not None:
            pulumi.set(__self__, "unique_identifier", unique_identifier)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter(name="allowClaim")
    def allow_claim(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Can this Virtual Machine be claimed by users? Defaults to `true`.
        """
        return pulumi.get(self, "allow_claim")

    @allow_claim.setter
    def allow_claim(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_claim", value)

    @_builtins.property
    @pulumi.getter(name="disallowPublicIpAddress")
    def disallow_public_ip_address(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Virtual Machine be created without a Public IP Address? Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "disallow_public_ip_address")

    @disallow_public_ip_address.setter
    def disallow_public_ip_address(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "disallow_public_ip_address", value)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The FQDN of the Virtual Machine.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fqdn", value)

    @_builtins.property
    @pulumi.getter(name="galleryImageReference")
    def gallery_image_reference(self) -> Optional[pulumi.Input['WindowsVirtualMachineGalleryImageReferenceArgs']]:
        """
        A `gallery_image_reference` block as defined below.
        """
        return pulumi.get(self, "gallery_image_reference")

    @gallery_image_reference.setter
    def gallery_image_reference(self, value: Optional[pulumi.Input['WindowsVirtualMachineGalleryImageReferenceArgs']]):
        pulumi.set(self, "gallery_image_reference", value)

    @_builtins.property
    @pulumi.getter(name="inboundNatRules")
    def inbound_nat_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineInboundNatRuleArgs']]]]:
        """
        One or more `inbound_nat_rule` blocks as defined below. Changing this forces a new resource to be created.

        > **Note:** If any `inbound_nat_rule` blocks are specified then `disallow_public_ip_address` must be set to `true`.
        """
        return pulumi.get(self, "inbound_nat_rules")

    @inbound_nat_rules.setter
    def inbound_nat_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsVirtualMachineInboundNatRuleArgs']]]]):
        pulumi.set(self, "inbound_nat_rules", value)

    @_builtins.property
    @pulumi.getter(name="labName")
    def lab_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Dev Test Lab in which the Virtual Machine should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "lab_name")

    @lab_name.setter
    def lab_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lab_name", value)

    @_builtins.property
    @pulumi.getter(name="labSubnetName")
    def lab_subnet_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of a Subnet within the Dev Test Virtual Network where this machine should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "lab_subnet_name")

    @lab_subnet_name.setter
    def lab_subnet_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lab_subnet_name", value)

    @_builtins.property
    @pulumi.getter(name="labVirtualNetworkId")
    def lab_virtual_network_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Dev Test Virtual Network where this Virtual Machine should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "lab_virtual_network_id")

    @lab_virtual_network_id.setter
    def lab_virtual_network_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lab_virtual_network_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the Dev Test Lab exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Dev Test Machine. Changing this forces a new resource to be created.

        > **Note:** The validation requirements for the Name change based on the `os_type` used in this Virtual Machine. For a Linux VM the name must be between 1-62 characters, and for a Windows VM the name must be between 1-15 characters. It must begin and end with a letter or number, and cannot be all numbers.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Any notes about the Virtual Machine.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notes", value)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Password associated with the `username` used to login to this Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "password", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which the Dev Test Lab resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Machine Size to use for this Virtual Machine, such as `Standard_F2`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "size", value)

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of Storage to use on this Virtual Machine. Possible values are `Standard` and `Premium`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_type", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="uniqueIdentifier")
    def unique_identifier(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique immutable identifier of the Virtual Machine.
        """
        return pulumi.get(self, "unique_identifier")

    @unique_identifier.setter
    def unique_identifier(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "unique_identifier", value)

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Username associated with the local administrator on this Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "username", value)


@pulumi.type_token("azure:devtest/windowsVirtualMachine:WindowsVirtualMachine")
class WindowsVirtualMachine(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_claim: Optional[pulumi.Input[_builtins.bool]] = None,
                 disallow_public_ip_address: Optional[pulumi.Input[_builtins.bool]] = None,
                 gallery_image_reference: Optional[pulumi.Input[Union['WindowsVirtualMachineGalleryImageReferenceArgs', 'WindowsVirtualMachineGalleryImageReferenceArgsDict']]] = None,
                 inbound_nat_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WindowsVirtualMachineInboundNatRuleArgs', 'WindowsVirtualMachineInboundNatRuleArgsDict']]]]] = None,
                 lab_name: Optional[pulumi.Input[_builtins.str]] = None,
                 lab_subnet_name: Optional[pulumi.Input[_builtins.str]] = None,
                 lab_virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Windows Virtual Machine within a Dev Test Lab.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_lab = azure.devtest.Lab("example",
            name="example-devtestlab",
            location=example.location,
            resource_group_name=example.name,
            tags={
                "Sydney": "Australia",
            })
        example_virtual_network = azure.devtest.VirtualNetwork("example",
            name="example-network",
            lab_name=example_lab.name,
            resource_group_name=example.name,
            subnet={
                "use_public_ip_address": "Allow",
                "use_in_virtual_machine_creation": "Allow",
            })
        example_windows_virtual_machine = azure.devtest.WindowsVirtualMachine("example",
            name="example-vm03",
            lab_name=example_lab.name,
            resource_group_name=example.name,
            location=example.location,
            size="Standard_DS2",
            username="exampleuser99",
            password="Pa$w0rd1234!",
            lab_virtual_network_id=example_virtual_network.id,
            lab_subnet_name=example_virtual_network.subnet.name,
            storage_type="Premium",
            notes="Some notes about this Virtual Machine.",
            gallery_image_reference={
                "offer": "WindowsServer",
                "publisher": "MicrosoftWindowsServer",
                "sku": "2019-Datacenter",
                "version": "latest",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DevTestLab` - 2018-09-15

        ## Import

        DevTest Windows Virtual Machines can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:devtest/windowsVirtualMachine:WindowsVirtualMachine machine1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DevTestLab/labs/lab1/virtualMachines/machine1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_claim: Can this Virtual Machine be claimed by users? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] disallow_public_ip_address: Should the Virtual Machine be created without a Public IP Address? Changing this forces a new resource to be created.
        :param pulumi.Input[Union['WindowsVirtualMachineGalleryImageReferenceArgs', 'WindowsVirtualMachineGalleryImageReferenceArgsDict']] gallery_image_reference: A `gallery_image_reference` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WindowsVirtualMachineInboundNatRuleArgs', 'WindowsVirtualMachineInboundNatRuleArgsDict']]]] inbound_nat_rules: One or more `inbound_nat_rule` blocks as defined below. Changing this forces a new resource to be created.
               
               > **Note:** If any `inbound_nat_rule` blocks are specified then `disallow_public_ip_address` must be set to `true`.
        :param pulumi.Input[_builtins.str] lab_name: Specifies the name of the Dev Test Lab in which the Virtual Machine should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] lab_subnet_name: The name of a Subnet within the Dev Test Virtual Network where this machine should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] lab_virtual_network_id: The ID of the Dev Test Virtual Network where this Virtual Machine should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the Dev Test Lab exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Dev Test Machine. Changing this forces a new resource to be created.
               
               > **Note:** The validation requirements for the Name change based on the `os_type` used in this Virtual Machine. For a Linux VM the name must be between 1-62 characters, and for a Windows VM the name must be between 1-15 characters. It must begin and end with a letter or number, and cannot be all numbers.
        :param pulumi.Input[_builtins.str] notes: Any notes about the Virtual Machine.
        :param pulumi.Input[_builtins.str] password: The Password associated with the `username` used to login to this Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Dev Test Lab resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] size: The Machine Size to use for this Virtual Machine, such as `Standard_F2`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_type: The type of Storage to use on this Virtual Machine. Possible values are `Standard` and `Premium`. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] username: The Username associated with the local administrator on this Virtual Machine. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WindowsVirtualMachineArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Windows Virtual Machine within a Dev Test Lab.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_lab = azure.devtest.Lab("example",
            name="example-devtestlab",
            location=example.location,
            resource_group_name=example.name,
            tags={
                "Sydney": "Australia",
            })
        example_virtual_network = azure.devtest.VirtualNetwork("example",
            name="example-network",
            lab_name=example_lab.name,
            resource_group_name=example.name,
            subnet={
                "use_public_ip_address": "Allow",
                "use_in_virtual_machine_creation": "Allow",
            })
        example_windows_virtual_machine = azure.devtest.WindowsVirtualMachine("example",
            name="example-vm03",
            lab_name=example_lab.name,
            resource_group_name=example.name,
            location=example.location,
            size="Standard_DS2",
            username="exampleuser99",
            password="Pa$w0rd1234!",
            lab_virtual_network_id=example_virtual_network.id,
            lab_subnet_name=example_virtual_network.subnet.name,
            storage_type="Premium",
            notes="Some notes about this Virtual Machine.",
            gallery_image_reference={
                "offer": "WindowsServer",
                "publisher": "MicrosoftWindowsServer",
                "sku": "2019-Datacenter",
                "version": "latest",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DevTestLab` - 2018-09-15

        ## Import

        DevTest Windows Virtual Machines can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:devtest/windowsVirtualMachine:WindowsVirtualMachine machine1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DevTestLab/labs/lab1/virtualMachines/machine1
        ```

        :param str resource_name: The name of the resource.
        :param WindowsVirtualMachineArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WindowsVirtualMachineArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_claim: Optional[pulumi.Input[_builtins.bool]] = None,
                 disallow_public_ip_address: Optional[pulumi.Input[_builtins.bool]] = None,
                 gallery_image_reference: Optional[pulumi.Input[Union['WindowsVirtualMachineGalleryImageReferenceArgs', 'WindowsVirtualMachineGalleryImageReferenceArgsDict']]] = None,
                 inbound_nat_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WindowsVirtualMachineInboundNatRuleArgs', 'WindowsVirtualMachineInboundNatRuleArgsDict']]]]] = None,
                 lab_name: Optional[pulumi.Input[_builtins.str]] = None,
                 lab_subnet_name: Optional[pulumi.Input[_builtins.str]] = None,
                 lab_virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None,
                 password: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 size: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_type: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 username: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WindowsVirtualMachineArgs.__new__(WindowsVirtualMachineArgs)

            __props__.__dict__["allow_claim"] = allow_claim
            __props__.__dict__["disallow_public_ip_address"] = disallow_public_ip_address
            if gallery_image_reference is None and not opts.urn:
                raise TypeError("Missing required property 'gallery_image_reference'")
            __props__.__dict__["gallery_image_reference"] = gallery_image_reference
            __props__.__dict__["inbound_nat_rules"] = inbound_nat_rules
            if lab_name is None and not opts.urn:
                raise TypeError("Missing required property 'lab_name'")
            __props__.__dict__["lab_name"] = lab_name
            if lab_subnet_name is None and not opts.urn:
                raise TypeError("Missing required property 'lab_subnet_name'")
            __props__.__dict__["lab_subnet_name"] = lab_subnet_name
            if lab_virtual_network_id is None and not opts.urn:
                raise TypeError("Missing required property 'lab_virtual_network_id'")
            __props__.__dict__["lab_virtual_network_id"] = lab_virtual_network_id
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["notes"] = notes
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            if storage_type is None and not opts.urn:
                raise TypeError("Missing required property 'storage_type'")
            __props__.__dict__["storage_type"] = storage_type
            __props__.__dict__["tags"] = tags
            if username is None and not opts.urn:
                raise TypeError("Missing required property 'username'")
            __props__.__dict__["username"] = username
            __props__.__dict__["fqdn"] = None
            __props__.__dict__["unique_identifier"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(WindowsVirtualMachine, __self__).__init__(
            'azure:devtest/windowsVirtualMachine:WindowsVirtualMachine',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_claim: Optional[pulumi.Input[_builtins.bool]] = None,
            disallow_public_ip_address: Optional[pulumi.Input[_builtins.bool]] = None,
            fqdn: Optional[pulumi.Input[_builtins.str]] = None,
            gallery_image_reference: Optional[pulumi.Input[Union['WindowsVirtualMachineGalleryImageReferenceArgs', 'WindowsVirtualMachineGalleryImageReferenceArgsDict']]] = None,
            inbound_nat_rules: Optional[pulumi.Input[Sequence[pulumi.Input[Union['WindowsVirtualMachineInboundNatRuleArgs', 'WindowsVirtualMachineInboundNatRuleArgsDict']]]]] = None,
            lab_name: Optional[pulumi.Input[_builtins.str]] = None,
            lab_subnet_name: Optional[pulumi.Input[_builtins.str]] = None,
            lab_virtual_network_id: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            notes: Optional[pulumi.Input[_builtins.str]] = None,
            password: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            size: Optional[pulumi.Input[_builtins.str]] = None,
            storage_type: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            unique_identifier: Optional[pulumi.Input[_builtins.str]] = None,
            username: Optional[pulumi.Input[_builtins.str]] = None) -> 'WindowsVirtualMachine':
        """
        Get an existing WindowsVirtualMachine resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] allow_claim: Can this Virtual Machine be claimed by users? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] disallow_public_ip_address: Should the Virtual Machine be created without a Public IP Address? Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] fqdn: The FQDN of the Virtual Machine.
        :param pulumi.Input[Union['WindowsVirtualMachineGalleryImageReferenceArgs', 'WindowsVirtualMachineGalleryImageReferenceArgsDict']] gallery_image_reference: A `gallery_image_reference` block as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['WindowsVirtualMachineInboundNatRuleArgs', 'WindowsVirtualMachineInboundNatRuleArgsDict']]]] inbound_nat_rules: One or more `inbound_nat_rule` blocks as defined below. Changing this forces a new resource to be created.
               
               > **Note:** If any `inbound_nat_rule` blocks are specified then `disallow_public_ip_address` must be set to `true`.
        :param pulumi.Input[_builtins.str] lab_name: Specifies the name of the Dev Test Lab in which the Virtual Machine should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] lab_subnet_name: The name of a Subnet within the Dev Test Virtual Network where this machine should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] lab_virtual_network_id: The ID of the Dev Test Virtual Network where this Virtual Machine should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the Dev Test Lab exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Dev Test Machine. Changing this forces a new resource to be created.
               
               > **Note:** The validation requirements for the Name change based on the `os_type` used in this Virtual Machine. For a Linux VM the name must be between 1-62 characters, and for a Windows VM the name must be between 1-15 characters. It must begin and end with a letter or number, and cannot be all numbers.
        :param pulumi.Input[_builtins.str] notes: Any notes about the Virtual Machine.
        :param pulumi.Input[_builtins.str] password: The Password associated with the `username` used to login to this Virtual Machine. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which the Dev Test Lab resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] size: The Machine Size to use for this Virtual Machine, such as `Standard_F2`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_type: The type of Storage to use on this Virtual Machine. Possible values are `Standard` and `Premium`. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.str] unique_identifier: The unique immutable identifier of the Virtual Machine.
        :param pulumi.Input[_builtins.str] username: The Username associated with the local administrator on this Virtual Machine. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WindowsVirtualMachineState.__new__(_WindowsVirtualMachineState)

        __props__.__dict__["allow_claim"] = allow_claim
        __props__.__dict__["disallow_public_ip_address"] = disallow_public_ip_address
        __props__.__dict__["fqdn"] = fqdn
        __props__.__dict__["gallery_image_reference"] = gallery_image_reference
        __props__.__dict__["inbound_nat_rules"] = inbound_nat_rules
        __props__.__dict__["lab_name"] = lab_name
        __props__.__dict__["lab_subnet_name"] = lab_subnet_name
        __props__.__dict__["lab_virtual_network_id"] = lab_virtual_network_id
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["notes"] = notes
        __props__.__dict__["password"] = password
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["size"] = size
        __props__.__dict__["storage_type"] = storage_type
        __props__.__dict__["tags"] = tags
        __props__.__dict__["unique_identifier"] = unique_identifier
        __props__.__dict__["username"] = username
        return WindowsVirtualMachine(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowClaim")
    def allow_claim(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Can this Virtual Machine be claimed by users? Defaults to `true`.
        """
        return pulumi.get(self, "allow_claim")

    @_builtins.property
    @pulumi.getter(name="disallowPublicIpAddress")
    def disallow_public_ip_address(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the Virtual Machine be created without a Public IP Address? Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "disallow_public_ip_address")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[_builtins.str]:
        """
        The FQDN of the Virtual Machine.
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter(name="galleryImageReference")
    def gallery_image_reference(self) -> pulumi.Output['outputs.WindowsVirtualMachineGalleryImageReference']:
        """
        A `gallery_image_reference` block as defined below.
        """
        return pulumi.get(self, "gallery_image_reference")

    @_builtins.property
    @pulumi.getter(name="inboundNatRules")
    def inbound_nat_rules(self) -> pulumi.Output[Optional[Sequence['outputs.WindowsVirtualMachineInboundNatRule']]]:
        """
        One or more `inbound_nat_rule` blocks as defined below. Changing this forces a new resource to be created.

        > **Note:** If any `inbound_nat_rule` blocks are specified then `disallow_public_ip_address` must be set to `true`.
        """
        return pulumi.get(self, "inbound_nat_rules")

    @_builtins.property
    @pulumi.getter(name="labName")
    def lab_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Dev Test Lab in which the Virtual Machine should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "lab_name")

    @_builtins.property
    @pulumi.getter(name="labSubnetName")
    def lab_subnet_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of a Subnet within the Dev Test Virtual Network where this machine should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "lab_subnet_name")

    @_builtins.property
    @pulumi.getter(name="labVirtualNetworkId")
    def lab_virtual_network_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Dev Test Virtual Network where this Virtual Machine should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "lab_virtual_network_id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the Dev Test Lab exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Dev Test Machine. Changing this forces a new resource to be created.

        > **Note:** The validation requirements for the Name change based on the `os_type` used in this Virtual Machine. For a Linux VM the name must be between 1-62 characters, and for a Windows VM the name must be between 1-15 characters. It must begin and end with a letter or number, and cannot be all numbers.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def notes(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Any notes about the Virtual Machine.
        """
        return pulumi.get(self, "notes")

    @_builtins.property
    @pulumi.getter
    def password(self) -> pulumi.Output[_builtins.str]:
        """
        The Password associated with the `username` used to login to this Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which the Dev Test Lab resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def size(self) -> pulumi.Output[_builtins.str]:
        """
        The Machine Size to use for this Virtual Machine, such as `Standard_F2`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "size")

    @_builtins.property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[_builtins.str]:
        """
        The type of Storage to use on this Virtual Machine. Possible values are `Standard` and `Premium`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_type")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="uniqueIdentifier")
    def unique_identifier(self) -> pulumi.Output[_builtins.str]:
        """
        The unique immutable identifier of the Virtual Machine.
        """
        return pulumi.get(self, "unique_identifier")

    @_builtins.property
    @pulumi.getter
    def username(self) -> pulumi.Output[_builtins.str]:
        """
        The Username associated with the local administrator on this Virtual Machine. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "username")

