# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetDicomServiceResult',
    'AwaitableGetDicomServiceResult',
    'get_dicom_service',
    'get_dicom_service_output',
]

@pulumi.output_type
class GetDicomServiceResult:
    """
    A collection of values returned by getDicomService.
    """
    def __init__(__self__, authentications=None, cors=None, data_partitions_enabled=None, encryption_key_url=None, id=None, identities=None, location=None, name=None, private_endpoints=None, service_url=None, storages=None, tags=None, workspace_id=None):
        if authentications and not isinstance(authentications, list):
            raise TypeError("Expected argument 'authentications' to be a list")
        pulumi.set(__self__, "authentications", authentications)
        if cors and not isinstance(cors, list):
            raise TypeError("Expected argument 'cors' to be a list")
        pulumi.set(__self__, "cors", cors)
        if data_partitions_enabled and not isinstance(data_partitions_enabled, bool):
            raise TypeError("Expected argument 'data_partitions_enabled' to be a bool")
        pulumi.set(__self__, "data_partitions_enabled", data_partitions_enabled)
        if encryption_key_url and not isinstance(encryption_key_url, str):
            raise TypeError("Expected argument 'encryption_key_url' to be a str")
        pulumi.set(__self__, "encryption_key_url", encryption_key_url)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if private_endpoints and not isinstance(private_endpoints, list):
            raise TypeError("Expected argument 'private_endpoints' to be a list")
        pulumi.set(__self__, "private_endpoints", private_endpoints)
        if service_url and not isinstance(service_url, str):
            raise TypeError("Expected argument 'service_url' to be a str")
        pulumi.set(__self__, "service_url", service_url)
        if storages and not isinstance(storages, list):
            raise TypeError("Expected argument 'storages' to be a list")
        pulumi.set(__self__, "storages", storages)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter
    def authentications(self) -> Sequence['outputs.GetDicomServiceAuthenticationResult']:
        """
        The `authentication` block as defined below.
        """
        return pulumi.get(self, "authentications")

    @_builtins.property
    @pulumi.getter
    def cors(self) -> Sequence['outputs.GetDicomServiceCorResult']:
        """
        The `cors` block as defined below.
        """
        return pulumi.get(self, "cors")

    @_builtins.property
    @pulumi.getter(name="dataPartitionsEnabled")
    def data_partitions_enabled(self) -> _builtins.bool:
        """
        If data partitions are enabled or not.
        """
        return pulumi.get(self, "data_partitions_enabled")

    @_builtins.property
    @pulumi.getter(name="encryptionKeyUrl")
    def encryption_key_url(self) -> _builtins.str:
        """
        The URL of the key to use for encryption as part of the customer-managed key encryption settings.
        """
        return pulumi.get(self, "encryption_key_url")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetDicomServiceIdentityResult']:
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Healthcare DICOM Service is located.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateEndpoints")
    def private_endpoints(self) -> Sequence['outputs.GetDicomServicePrivateEndpointResult']:
        return pulumi.get(self, "private_endpoints")

    @_builtins.property
    @pulumi.getter(name="serviceUrl")
    def service_url(self) -> _builtins.str:
        """
        The url of the Healthcare DICOM Services.
        """
        return pulumi.get(self, "service_url")

    @_builtins.property
    @pulumi.getter
    def storages(self) -> Sequence['outputs.GetDicomServiceStorageResult']:
        """
        The `storage` block as defined below.
        """
        return pulumi.get(self, "storages")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A map of tags assigned to the Healthcare DICOM Service.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> _builtins.str:
        return pulumi.get(self, "workspace_id")


class AwaitableGetDicomServiceResult(GetDicomServiceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDicomServiceResult(
            authentications=self.authentications,
            cors=self.cors,
            data_partitions_enabled=self.data_partitions_enabled,
            encryption_key_url=self.encryption_key_url,
            id=self.id,
            identities=self.identities,
            location=self.location,
            name=self.name,
            private_endpoints=self.private_endpoints,
            service_url=self.service_url,
            storages=self.storages,
            tags=self.tags,
            workspace_id=self.workspace_id)


def get_dicom_service(name: Optional[_builtins.str] = None,
                      workspace_id: Optional[_builtins.str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDicomServiceResult:
    """
    Use this data source to access information about an existing Healthcare DICOM Service

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.healthcare.get_dicom_service(name="example-healthcare_dicom_service",
        workspace_id=example_azurerm_healthcare_workspace["id"])
    pulumi.export("azurermHealthcareDicomService", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.HealthcareApis` - 2024-03-31


    :param _builtins.str name: The name of the Healthcare DICOM Service
    :param _builtins.str workspace_id: The ID of the Healthcare Workspace in which the Healthcare DICOM Service exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:healthcare/getDicomService:getDicomService', __args__, opts=opts, typ=GetDicomServiceResult).value

    return AwaitableGetDicomServiceResult(
        authentications=pulumi.get(__ret__, 'authentications'),
        cors=pulumi.get(__ret__, 'cors'),
        data_partitions_enabled=pulumi.get(__ret__, 'data_partitions_enabled'),
        encryption_key_url=pulumi.get(__ret__, 'encryption_key_url'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        private_endpoints=pulumi.get(__ret__, 'private_endpoints'),
        service_url=pulumi.get(__ret__, 'service_url'),
        storages=pulumi.get(__ret__, 'storages'),
        tags=pulumi.get(__ret__, 'tags'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))
def get_dicom_service_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                             workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDicomServiceResult]:
    """
    Use this data source to access information about an existing Healthcare DICOM Service

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.healthcare.get_dicom_service(name="example-healthcare_dicom_service",
        workspace_id=example_azurerm_healthcare_workspace["id"])
    pulumi.export("azurermHealthcareDicomService", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.HealthcareApis` - 2024-03-31


    :param _builtins.str name: The name of the Healthcare DICOM Service
    :param _builtins.str workspace_id: The ID of the Healthcare Workspace in which the Healthcare DICOM Service exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:healthcare/getDicomService:getDicomService', __args__, opts=opts, typ=GetDicomServiceResult)
    return __ret__.apply(lambda __response__: GetDicomServiceResult(
        authentications=pulumi.get(__response__, 'authentications'),
        cors=pulumi.get(__response__, 'cors'),
        data_partitions_enabled=pulumi.get(__response__, 'data_partitions_enabled'),
        encryption_key_url=pulumi.get(__response__, 'encryption_key_url'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        private_endpoints=pulumi.get(__response__, 'private_endpoints'),
        service_url=pulumi.get(__response__, 'service_url'),
        storages=pulumi.get(__response__, 'storages'),
        tags=pulumi.get(__response__, 'tags'),
        workspace_id=pulumi.get(__response__, 'workspace_id')))
