# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['MedtechServiceFhirDestinationArgs', 'MedtechServiceFhirDestination']

@pulumi.input_type
class MedtechServiceFhirDestinationArgs:
    def __init__(__self__, *,
                 destination_fhir_mapping_json: pulumi.Input[_builtins.str],
                 destination_fhir_service_id: pulumi.Input[_builtins.str],
                 destination_identity_resolution_type: pulumi.Input[_builtins.str],
                 medtech_service_id: pulumi.Input[_builtins.str],
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a MedtechServiceFhirDestination resource.
        :param pulumi.Input[_builtins.str] destination_fhir_mapping_json: Specifies the destination Fhir mappings of the Med Tech Service Fhir Destination.
        :param pulumi.Input[_builtins.str] destination_fhir_service_id: Specifies the destination fhir service id of the Med Tech Service Fhir Destination.
        :param pulumi.Input[_builtins.str] destination_identity_resolution_type: Specifies the destination identity resolution type where the Healthcare Med Tech Service Fhir Destination should be created. Possible values are `Create`, `Lookup`.
        :param pulumi.Input[_builtins.str] medtech_service_id: Specifies the name of the Healthcare Med Tech Service where the Healthcare Med Tech Service Fhir Destination should exist. Changing this forces a new Healthcare Med Tech Service Fhir Destination to be created.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Healthcare Med Tech Service Fhir Destination should be created. Changing this forces a new Healthcare Med Tech Service Fhir Destination to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Healthcare Med Tech Service Fhir Destination. Changing this forces a new Healthcare Med Tech Service Fhir Destination to be created.
        """
        pulumi.set(__self__, "destination_fhir_mapping_json", destination_fhir_mapping_json)
        pulumi.set(__self__, "destination_fhir_service_id", destination_fhir_service_id)
        pulumi.set(__self__, "destination_identity_resolution_type", destination_identity_resolution_type)
        pulumi.set(__self__, "medtech_service_id", medtech_service_id)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="destinationFhirMappingJson")
    def destination_fhir_mapping_json(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the destination Fhir mappings of the Med Tech Service Fhir Destination.
        """
        return pulumi.get(self, "destination_fhir_mapping_json")

    @destination_fhir_mapping_json.setter
    def destination_fhir_mapping_json(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination_fhir_mapping_json", value)

    @_builtins.property
    @pulumi.getter(name="destinationFhirServiceId")
    def destination_fhir_service_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the destination fhir service id of the Med Tech Service Fhir Destination.
        """
        return pulumi.get(self, "destination_fhir_service_id")

    @destination_fhir_service_id.setter
    def destination_fhir_service_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination_fhir_service_id", value)

    @_builtins.property
    @pulumi.getter(name="destinationIdentityResolutionType")
    def destination_identity_resolution_type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the destination identity resolution type where the Healthcare Med Tech Service Fhir Destination should be created. Possible values are `Create`, `Lookup`.
        """
        return pulumi.get(self, "destination_identity_resolution_type")

    @destination_identity_resolution_type.setter
    def destination_identity_resolution_type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "destination_identity_resolution_type", value)

    @_builtins.property
    @pulumi.getter(name="medtechServiceId")
    def medtech_service_id(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Healthcare Med Tech Service where the Healthcare Med Tech Service Fhir Destination should exist. Changing this forces a new Healthcare Med Tech Service Fhir Destination to be created.
        """
        return pulumi.get(self, "medtech_service_id")

    @medtech_service_id.setter
    def medtech_service_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "medtech_service_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Healthcare Med Tech Service Fhir Destination should be created. Changing this forces a new Healthcare Med Tech Service Fhir Destination to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Healthcare Med Tech Service Fhir Destination. Changing this forces a new Healthcare Med Tech Service Fhir Destination to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _MedtechServiceFhirDestinationState:
    def __init__(__self__, *,
                 destination_fhir_mapping_json: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_fhir_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_identity_resolution_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 medtech_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering MedtechServiceFhirDestination resources.
        :param pulumi.Input[_builtins.str] destination_fhir_mapping_json: Specifies the destination Fhir mappings of the Med Tech Service Fhir Destination.
        :param pulumi.Input[_builtins.str] destination_fhir_service_id: Specifies the destination fhir service id of the Med Tech Service Fhir Destination.
        :param pulumi.Input[_builtins.str] destination_identity_resolution_type: Specifies the destination identity resolution type where the Healthcare Med Tech Service Fhir Destination should be created. Possible values are `Create`, `Lookup`.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Healthcare Med Tech Service Fhir Destination should be created. Changing this forces a new Healthcare Med Tech Service Fhir Destination to be created.
        :param pulumi.Input[_builtins.str] medtech_service_id: Specifies the name of the Healthcare Med Tech Service where the Healthcare Med Tech Service Fhir Destination should exist. Changing this forces a new Healthcare Med Tech Service Fhir Destination to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Healthcare Med Tech Service Fhir Destination. Changing this forces a new Healthcare Med Tech Service Fhir Destination to be created.
        """
        if destination_fhir_mapping_json is not None:
            pulumi.set(__self__, "destination_fhir_mapping_json", destination_fhir_mapping_json)
        if destination_fhir_service_id is not None:
            pulumi.set(__self__, "destination_fhir_service_id", destination_fhir_service_id)
        if destination_identity_resolution_type is not None:
            pulumi.set(__self__, "destination_identity_resolution_type", destination_identity_resolution_type)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if medtech_service_id is not None:
            pulumi.set(__self__, "medtech_service_id", medtech_service_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="destinationFhirMappingJson")
    def destination_fhir_mapping_json(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the destination Fhir mappings of the Med Tech Service Fhir Destination.
        """
        return pulumi.get(self, "destination_fhir_mapping_json")

    @destination_fhir_mapping_json.setter
    def destination_fhir_mapping_json(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_fhir_mapping_json", value)

    @_builtins.property
    @pulumi.getter(name="destinationFhirServiceId")
    def destination_fhir_service_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the destination fhir service id of the Med Tech Service Fhir Destination.
        """
        return pulumi.get(self, "destination_fhir_service_id")

    @destination_fhir_service_id.setter
    def destination_fhir_service_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_fhir_service_id", value)

    @_builtins.property
    @pulumi.getter(name="destinationIdentityResolutionType")
    def destination_identity_resolution_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the destination identity resolution type where the Healthcare Med Tech Service Fhir Destination should be created. Possible values are `Create`, `Lookup`.
        """
        return pulumi.get(self, "destination_identity_resolution_type")

    @destination_identity_resolution_type.setter
    def destination_identity_resolution_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "destination_identity_resolution_type", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the Healthcare Med Tech Service Fhir Destination should be created. Changing this forces a new Healthcare Med Tech Service Fhir Destination to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="medtechServiceId")
    def medtech_service_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Healthcare Med Tech Service where the Healthcare Med Tech Service Fhir Destination should exist. Changing this forces a new Healthcare Med Tech Service Fhir Destination to be created.
        """
        return pulumi.get(self, "medtech_service_id")

    @medtech_service_id.setter
    def medtech_service_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "medtech_service_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Healthcare Med Tech Service Fhir Destination. Changing this forces a new Healthcare Med Tech Service Fhir Destination to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.type_token("azure:healthcare/medtechServiceFhirDestination:MedtechServiceFhirDestination")
class MedtechServiceFhirDestination(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_fhir_mapping_json: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_fhir_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_identity_resolution_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 medtech_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Healthcare Med Tech Service Fhir Destination.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        current = azure.core.get_client_config()
        example_workspace = azure.healthcare.Workspace("example",
            name="exampleworkspace",
            location=example.location,
            resource_group_name=example.name)
        example_event_hub_namespace = azure.eventhub.EventHubNamespace("example",
            name="example-ehn",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard")
        example_event_hub = azure.eventhub.EventHub("example",
            name="example-eh",
            namespace_name=example_event_hub_namespace.name,
            resource_group_name=example.name,
            partition_count=1,
            message_retention=1)
        example_consumer_group = azure.eventhub.ConsumerGroup("example",
            name="$default",
            namespace_name=example_event_hub_namespace.name,
            eventhub_name=example_event_hub.name,
            resource_group_name=example.name)
        example_fhir_service = azure.healthcare.FhirService("example",
            name="examplefhir",
            location=example.location,
            resource_group_name=example.name,
            workspace_id=example_workspace.id,
            kind="fhir-R4",
            authentication={
                "authority": "https://login.microsoftonline.com/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx",
                "audience": "https://examplefhir.fhir.azurehealthcareapis.com",
            })
        example_medtech_service = azure.healthcare.MedtechService("example",
            name="examplemt",
            workspace_id=example_workspace.id,
            location=example.location,
            eventhub_namespace_name=example_event_hub_namespace.name,
            eventhub_name=example_event_hub.name,
            eventhub_consumer_group_name=example_consumer_group.name,
            device_mapping_json=json.dumps({
                "templateType": "CollectionContent",
                "template": [],
            }))
        example_medtech_service_fhir_destination = azure.healthcare.MedtechServiceFhirDestination("example",
            name="examplemtdes",
            location="east us",
            medtech_service_id=example_medtech_service.id,
            destination_fhir_service_id=example_fhir_service.id,
            destination_identity_resolution_type="Create",
            destination_fhir_mapping_json=json.dumps({
                "templateType": "CollectionFhirTemplate",
                "template": [{
                    "templateType": "CodeValueFhir",
                    "template": {
                        "codes": [{
                            "code": "8867-4",
                            "system": "http://loinc.org",
                            "display": "Heart rate",
                        }],
                        "periodInterval": 60,
                        "typeName": "heartrate",
                        "value": {
                            "defaultPeriod": 5000,
                            "unit": "count/min",
                            "valueName": "hr",
                            "valueType": "SampledData",
                        },
                    },
                }],
            }))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.HealthcareApis` - 2022-12-01

        ## Import

        Healthcare Med Tech Service Fhir Destination can be imported using the resource`id`, e.g.

        ```sh
        $ pulumi import azure:healthcare/medtechServiceFhirDestination:MedtechServiceFhirDestination example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.HealthcareApis/workspaces/workspace1/iotConnectors/iotconnector1/fhirDestinations/destination1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] destination_fhir_mapping_json: Specifies the destination Fhir mappings of the Med Tech Service Fhir Destination.
        :param pulumi.Input[_builtins.str] destination_fhir_service_id: Specifies the destination fhir service id of the Med Tech Service Fhir Destination.
        :param pulumi.Input[_builtins.str] destination_identity_resolution_type: Specifies the destination identity resolution type where the Healthcare Med Tech Service Fhir Destination should be created. Possible values are `Create`, `Lookup`.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Healthcare Med Tech Service Fhir Destination should be created. Changing this forces a new Healthcare Med Tech Service Fhir Destination to be created.
        :param pulumi.Input[_builtins.str] medtech_service_id: Specifies the name of the Healthcare Med Tech Service where the Healthcare Med Tech Service Fhir Destination should exist. Changing this forces a new Healthcare Med Tech Service Fhir Destination to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Healthcare Med Tech Service Fhir Destination. Changing this forces a new Healthcare Med Tech Service Fhir Destination to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MedtechServiceFhirDestinationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Healthcare Med Tech Service Fhir Destination.

        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="West Europe")
        current = azure.core.get_client_config()
        example_workspace = azure.healthcare.Workspace("example",
            name="exampleworkspace",
            location=example.location,
            resource_group_name=example.name)
        example_event_hub_namespace = azure.eventhub.EventHubNamespace("example",
            name="example-ehn",
            location=example.location,
            resource_group_name=example.name,
            sku="Standard")
        example_event_hub = azure.eventhub.EventHub("example",
            name="example-eh",
            namespace_name=example_event_hub_namespace.name,
            resource_group_name=example.name,
            partition_count=1,
            message_retention=1)
        example_consumer_group = azure.eventhub.ConsumerGroup("example",
            name="$default",
            namespace_name=example_event_hub_namespace.name,
            eventhub_name=example_event_hub.name,
            resource_group_name=example.name)
        example_fhir_service = azure.healthcare.FhirService("example",
            name="examplefhir",
            location=example.location,
            resource_group_name=example.name,
            workspace_id=example_workspace.id,
            kind="fhir-R4",
            authentication={
                "authority": "https://login.microsoftonline.com/xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx",
                "audience": "https://examplefhir.fhir.azurehealthcareapis.com",
            })
        example_medtech_service = azure.healthcare.MedtechService("example",
            name="examplemt",
            workspace_id=example_workspace.id,
            location=example.location,
            eventhub_namespace_name=example_event_hub_namespace.name,
            eventhub_name=example_event_hub.name,
            eventhub_consumer_group_name=example_consumer_group.name,
            device_mapping_json=json.dumps({
                "templateType": "CollectionContent",
                "template": [],
            }))
        example_medtech_service_fhir_destination = azure.healthcare.MedtechServiceFhirDestination("example",
            name="examplemtdes",
            location="east us",
            medtech_service_id=example_medtech_service.id,
            destination_fhir_service_id=example_fhir_service.id,
            destination_identity_resolution_type="Create",
            destination_fhir_mapping_json=json.dumps({
                "templateType": "CollectionFhirTemplate",
                "template": [{
                    "templateType": "CodeValueFhir",
                    "template": {
                        "codes": [{
                            "code": "8867-4",
                            "system": "http://loinc.org",
                            "display": "Heart rate",
                        }],
                        "periodInterval": 60,
                        "typeName": "heartrate",
                        "value": {
                            "defaultPeriod": 5000,
                            "unit": "count/min",
                            "valueName": "hr",
                            "valueType": "SampledData",
                        },
                    },
                }],
            }))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.HealthcareApis` - 2022-12-01

        ## Import

        Healthcare Med Tech Service Fhir Destination can be imported using the resource`id`, e.g.

        ```sh
        $ pulumi import azure:healthcare/medtechServiceFhirDestination:MedtechServiceFhirDestination example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/group1/providers/Microsoft.HealthcareApis/workspaces/workspace1/iotConnectors/iotconnector1/fhirDestinations/destination1
        ```

        :param str resource_name: The name of the resource.
        :param MedtechServiceFhirDestinationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MedtechServiceFhirDestinationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 destination_fhir_mapping_json: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_fhir_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 destination_identity_resolution_type: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 medtech_service_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MedtechServiceFhirDestinationArgs.__new__(MedtechServiceFhirDestinationArgs)

            if destination_fhir_mapping_json is None and not opts.urn:
                raise TypeError("Missing required property 'destination_fhir_mapping_json'")
            __props__.__dict__["destination_fhir_mapping_json"] = destination_fhir_mapping_json
            if destination_fhir_service_id is None and not opts.urn:
                raise TypeError("Missing required property 'destination_fhir_service_id'")
            __props__.__dict__["destination_fhir_service_id"] = destination_fhir_service_id
            if destination_identity_resolution_type is None and not opts.urn:
                raise TypeError("Missing required property 'destination_identity_resolution_type'")
            __props__.__dict__["destination_identity_resolution_type"] = destination_identity_resolution_type
            __props__.__dict__["location"] = location
            if medtech_service_id is None and not opts.urn:
                raise TypeError("Missing required property 'medtech_service_id'")
            __props__.__dict__["medtech_service_id"] = medtech_service_id
            __props__.__dict__["name"] = name
        super(MedtechServiceFhirDestination, __self__).__init__(
            'azure:healthcare/medtechServiceFhirDestination:MedtechServiceFhirDestination',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            destination_fhir_mapping_json: Optional[pulumi.Input[_builtins.str]] = None,
            destination_fhir_service_id: Optional[pulumi.Input[_builtins.str]] = None,
            destination_identity_resolution_type: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            medtech_service_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None) -> 'MedtechServiceFhirDestination':
        """
        Get an existing MedtechServiceFhirDestination resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] destination_fhir_mapping_json: Specifies the destination Fhir mappings of the Med Tech Service Fhir Destination.
        :param pulumi.Input[_builtins.str] destination_fhir_service_id: Specifies the destination fhir service id of the Med Tech Service Fhir Destination.
        :param pulumi.Input[_builtins.str] destination_identity_resolution_type: Specifies the destination identity resolution type where the Healthcare Med Tech Service Fhir Destination should be created. Possible values are `Create`, `Lookup`.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the Healthcare Med Tech Service Fhir Destination should be created. Changing this forces a new Healthcare Med Tech Service Fhir Destination to be created.
        :param pulumi.Input[_builtins.str] medtech_service_id: Specifies the name of the Healthcare Med Tech Service where the Healthcare Med Tech Service Fhir Destination should exist. Changing this forces a new Healthcare Med Tech Service Fhir Destination to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Healthcare Med Tech Service Fhir Destination. Changing this forces a new Healthcare Med Tech Service Fhir Destination to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MedtechServiceFhirDestinationState.__new__(_MedtechServiceFhirDestinationState)

        __props__.__dict__["destination_fhir_mapping_json"] = destination_fhir_mapping_json
        __props__.__dict__["destination_fhir_service_id"] = destination_fhir_service_id
        __props__.__dict__["destination_identity_resolution_type"] = destination_identity_resolution_type
        __props__.__dict__["location"] = location
        __props__.__dict__["medtech_service_id"] = medtech_service_id
        __props__.__dict__["name"] = name
        return MedtechServiceFhirDestination(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="destinationFhirMappingJson")
    def destination_fhir_mapping_json(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the destination Fhir mappings of the Med Tech Service Fhir Destination.
        """
        return pulumi.get(self, "destination_fhir_mapping_json")

    @_builtins.property
    @pulumi.getter(name="destinationFhirServiceId")
    def destination_fhir_service_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the destination fhir service id of the Med Tech Service Fhir Destination.
        """
        return pulumi.get(self, "destination_fhir_service_id")

    @_builtins.property
    @pulumi.getter(name="destinationIdentityResolutionType")
    def destination_identity_resolution_type(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the destination identity resolution type where the Healthcare Med Tech Service Fhir Destination should be created. Possible values are `Create`, `Lookup`.
        """
        return pulumi.get(self, "destination_identity_resolution_type")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Azure Region where the Healthcare Med Tech Service Fhir Destination should be created. Changing this forces a new Healthcare Med Tech Service Fhir Destination to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="medtechServiceId")
    def medtech_service_id(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Healthcare Med Tech Service where the Healthcare Med Tech Service Fhir Destination should exist. Changing this forces a new Healthcare Med Tech Service Fhir Destination to be created.
        """
        return pulumi.get(self, "medtech_service_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Healthcare Med Tech Service Fhir Destination. Changing this forces a new Healthcare Med Tech Service Fhir Destination to be created.
        """
        return pulumi.get(self, "name")

