# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'IoTHubCloudToDeviceArgs',
    'IoTHubCloudToDeviceArgsDict',
    'IoTHubCloudToDeviceFeedbackArgs',
    'IoTHubCloudToDeviceFeedbackArgsDict',
    'IoTHubEndpointArgs',
    'IoTHubEndpointArgsDict',
    'IoTHubEnrichmentArgs',
    'IoTHubEnrichmentArgsDict',
    'IoTHubFallbackRouteArgs',
    'IoTHubFallbackRouteArgsDict',
    'IoTHubFileUploadArgs',
    'IoTHubFileUploadArgsDict',
    'IoTHubIdentityArgs',
    'IoTHubIdentityArgsDict',
    'IoTHubNetworkRuleSetArgs',
    'IoTHubNetworkRuleSetArgsDict',
    'IoTHubNetworkRuleSetIpRuleArgs',
    'IoTHubNetworkRuleSetIpRuleArgsDict',
    'IoTHubRouteArgs',
    'IoTHubRouteArgsDict',
    'IoTHubSharedAccessPolicyArgs',
    'IoTHubSharedAccessPolicyArgsDict',
    'IoTHubSkuArgs',
    'IoTHubSkuArgsDict',
    'IotHubDeviceUpdateAccountIdentityArgs',
    'IotHubDeviceUpdateAccountIdentityArgsDict',
    'IotHubDeviceUpdateInstanceDiagnosticStorageAccountArgs',
    'IotHubDeviceUpdateInstanceDiagnosticStorageAccountArgsDict',
    'IotHubDpsIpFilterRuleArgs',
    'IotHubDpsIpFilterRuleArgsDict',
    'IotHubDpsLinkedHubArgs',
    'IotHubDpsLinkedHubArgsDict',
    'IotHubDpsSkuArgs',
    'IotHubDpsSkuArgsDict',
    'SecurityDeviceGroupAllowRuleArgs',
    'SecurityDeviceGroupAllowRuleArgsDict',
    'SecurityDeviceGroupRangeRuleArgs',
    'SecurityDeviceGroupRangeRuleArgsDict',
    'SecuritySolutionAdditionalWorkspaceArgs',
    'SecuritySolutionAdditionalWorkspaceArgsDict',
    'SecuritySolutionRecommendationsEnabledArgs',
    'SecuritySolutionRecommendationsEnabledArgsDict',
]

MYPY = False

if not MYPY:
    class IoTHubCloudToDeviceArgsDict(TypedDict):
        default_ttl: NotRequired[pulumi.Input[_builtins.str]]
        """
        The default time to live for cloud-to-device messages, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 48 hours. Defaults to `PT1H`.
        """
        feedbacks: NotRequired[pulumi.Input[Sequence[pulumi.Input['IoTHubCloudToDeviceFeedbackArgsDict']]]]
        """
        A `feedback` block as defined below.
        """
        max_delivery_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        The maximum delivery count for cloud-to-device per-device queues. This value must be between `1` and `100`. Defaults to `10`.
        """
elif False:
    IoTHubCloudToDeviceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IoTHubCloudToDeviceArgs:
    def __init__(__self__, *,
                 default_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 feedbacks: Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubCloudToDeviceFeedbackArgs']]]] = None,
                 max_delivery_count: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.str] default_ttl: The default time to live for cloud-to-device messages, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 48 hours. Defaults to `PT1H`.
        :param pulumi.Input[Sequence[pulumi.Input['IoTHubCloudToDeviceFeedbackArgs']]] feedbacks: A `feedback` block as defined below.
        :param pulumi.Input[_builtins.int] max_delivery_count: The maximum delivery count for cloud-to-device per-device queues. This value must be between `1` and `100`. Defaults to `10`.
        """
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if feedbacks is not None:
            pulumi.set(__self__, "feedbacks", feedbacks)
        if max_delivery_count is not None:
            pulumi.set(__self__, "max_delivery_count", max_delivery_count)

    @_builtins.property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default time to live for cloud-to-device messages, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 48 hours. Defaults to `PT1H`.
        """
        return pulumi.get(self, "default_ttl")

    @default_ttl.setter
    def default_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_ttl", value)

    @_builtins.property
    @pulumi.getter
    def feedbacks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubCloudToDeviceFeedbackArgs']]]]:
        """
        A `feedback` block as defined below.
        """
        return pulumi.get(self, "feedbacks")

    @feedbacks.setter
    def feedbacks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubCloudToDeviceFeedbackArgs']]]]):
        pulumi.set(self, "feedbacks", value)

    @_builtins.property
    @pulumi.getter(name="maxDeliveryCount")
    def max_delivery_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum delivery count for cloud-to-device per-device queues. This value must be between `1` and `100`. Defaults to `10`.
        """
        return pulumi.get(self, "max_delivery_count")

    @max_delivery_count.setter
    def max_delivery_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_delivery_count", value)


if not MYPY:
    class IoTHubCloudToDeviceFeedbackArgsDict(TypedDict):
        lock_duration: NotRequired[pulumi.Input[_builtins.str]]
        """
        The lock duration for the feedback queue, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 5 and 300 seconds. Defaults to `PT60S`.
        """
        max_delivery_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        The maximum delivery count for the feedback queue. This value must be between `1` and `100`. Defaults to `10`.
        """
        time_to_live: NotRequired[pulumi.Input[_builtins.str]]
        """
        The retention time for service-bound feedback messages, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 48 hours. Defaults to `PT1H`.
        """
elif False:
    IoTHubCloudToDeviceFeedbackArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IoTHubCloudToDeviceFeedbackArgs:
    def __init__(__self__, *,
                 lock_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 max_delivery_count: Optional[pulumi.Input[_builtins.int]] = None,
                 time_to_live: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] lock_duration: The lock duration for the feedback queue, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 5 and 300 seconds. Defaults to `PT60S`.
        :param pulumi.Input[_builtins.int] max_delivery_count: The maximum delivery count for the feedback queue. This value must be between `1` and `100`. Defaults to `10`.
        :param pulumi.Input[_builtins.str] time_to_live: The retention time for service-bound feedback messages, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 48 hours. Defaults to `PT1H`.
        """
        if lock_duration is not None:
            pulumi.set(__self__, "lock_duration", lock_duration)
        if max_delivery_count is not None:
            pulumi.set(__self__, "max_delivery_count", max_delivery_count)
        if time_to_live is not None:
            pulumi.set(__self__, "time_to_live", time_to_live)

    @_builtins.property
    @pulumi.getter(name="lockDuration")
    def lock_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lock duration for the feedback queue, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 5 and 300 seconds. Defaults to `PT60S`.
        """
        return pulumi.get(self, "lock_duration")

    @lock_duration.setter
    def lock_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lock_duration", value)

    @_builtins.property
    @pulumi.getter(name="maxDeliveryCount")
    def max_delivery_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum delivery count for the feedback queue. This value must be between `1` and `100`. Defaults to `10`.
        """
        return pulumi.get(self, "max_delivery_count")

    @max_delivery_count.setter
    def max_delivery_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_delivery_count", value)

    @_builtins.property
    @pulumi.getter(name="timeToLive")
    def time_to_live(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The retention time for service-bound feedback messages, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 48 hours. Defaults to `PT1H`.
        """
        return pulumi.get(self, "time_to_live")

    @time_to_live.setter
    def time_to_live(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "time_to_live", value)


if not MYPY:
    class IoTHubEndpointArgsDict(TypedDict):
        name: pulumi.Input[_builtins.str]
        """
        The name of the endpoint. The name must be unique across endpoint types. The following names are reserved: `events`, `operationsMonitoringEvents`, `fileNotifications` and `$default`.
        """
        type: pulumi.Input[_builtins.str]
        """
        The type of the endpoint. Possible values are `AzureIotHub.StorageContainer`, `AzureIotHub.ServiceBusQueue`, `AzureIotHub.ServiceBusTopic` or `AzureIotHub.EventHub`.
        """
        authentication_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type used to authenticate against the endpoint. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        """
        batch_frequency_in_seconds: NotRequired[pulumi.Input[_builtins.int]]
        """
        Time interval at which blobs are written to storage. Value should be between 60 and 720 seconds. Default value is 300 seconds. This attribute is applicable for endpoint type `AzureIotHub.StorageContainer`.
        """
        connection_string: NotRequired[pulumi.Input[_builtins.str]]
        """
        The connection string for the endpoint. This attribute is mandatory and can only be specified when `authentication_type` is `keyBased`.
        """
        container_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of storage container in the storage account. This attribute is mandatory for endpoint type `AzureIotHub.StorageContainer`.
        """
        encoding: NotRequired[pulumi.Input[_builtins.str]]
        """
        Encoding that is used to serialize messages to blobs. Supported values are `Avro`, `AvroDeflate` and `JSON`. Default value is `Avro`. This attribute is applicable for endpoint type `AzureIotHub.StorageContainer`. Changing this forces a new resource to be created.
        """
        endpoint_uri: NotRequired[pulumi.Input[_builtins.str]]
        """
        URI of the Service Bus or Event Hubs Namespace endpoint. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased` for endpoint type `AzureIotHub.ServiceBusQueue`, `AzureIotHub.ServiceBusTopic` or `AzureIotHub.EventHub`.
        """
        entity_path: NotRequired[pulumi.Input[_builtins.str]]
        """
        Name of the Service Bus Queue/Topic or Event Hub. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased` for endpoint type `AzureIotHub.ServiceBusQueue`, `AzureIotHub.ServiceBusTopic` or `AzureIotHub.EventHub`.
        """
        file_name_format: NotRequired[pulumi.Input[_builtins.str]]
        """
        File name format for the blob. All parameters are mandatory but can be reordered. This attribute is applicable for endpoint type `AzureIotHub.StorageContainer`. Defaults to `{iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}`.
        """
        identity_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the User Managed Identity used to authenticate against the endpoint.

        > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the IoT Hub. If `identity_id` is omitted when `authentication_type` is `identityBased`, then the System-Assigned Managed Identity of the IoT Hub will be used.

        > **Note:** An IoT Hub can only be updated to use the System-Assigned Managed Identity for `endpoint` since it is not possible to grant access to the endpoint until after creation. The extracted resources `azurerm_iothub_endpoint_*` can be used to configure Endpoints with the IoT Hub's System-Assigned Managed Identity without the need for an update.
        """
        max_chunk_size_in_bytes: NotRequired[pulumi.Input[_builtins.int]]
        """
        Maximum number of bytes for each blob written to storage. Value should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB). This attribute is applicable for endpoint type `AzureIotHub.StorageContainer`.
        """
        resource_group_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The resource group in which the endpoint will be created.
        """
elif False:
    IoTHubEndpointArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IoTHubEndpointArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[_builtins.str],
                 type: pulumi.Input[_builtins.str],
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 batch_frequency_in_seconds: Optional[pulumi.Input[_builtins.int]] = None,
                 connection_string: Optional[pulumi.Input[_builtins.str]] = None,
                 container_name: Optional[pulumi.Input[_builtins.str]] = None,
                 encoding: Optional[pulumi.Input[_builtins.str]] = None,
                 endpoint_uri: Optional[pulumi.Input[_builtins.str]] = None,
                 entity_path: Optional[pulumi.Input[_builtins.str]] = None,
                 file_name_format: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 max_chunk_size_in_bytes: Optional[pulumi.Input[_builtins.int]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] name: The name of the endpoint. The name must be unique across endpoint types. The following names are reserved: `events`, `operationsMonitoringEvents`, `fileNotifications` and `$default`.
        :param pulumi.Input[_builtins.str] type: The type of the endpoint. Possible values are `AzureIotHub.StorageContainer`, `AzureIotHub.ServiceBusQueue`, `AzureIotHub.ServiceBusTopic` or `AzureIotHub.EventHub`.
        :param pulumi.Input[_builtins.str] authentication_type: The type used to authenticate against the endpoint. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        :param pulumi.Input[_builtins.int] batch_frequency_in_seconds: Time interval at which blobs are written to storage. Value should be between 60 and 720 seconds. Default value is 300 seconds. This attribute is applicable for endpoint type `AzureIotHub.StorageContainer`.
        :param pulumi.Input[_builtins.str] connection_string: The connection string for the endpoint. This attribute is mandatory and can only be specified when `authentication_type` is `keyBased`.
        :param pulumi.Input[_builtins.str] container_name: The name of storage container in the storage account. This attribute is mandatory for endpoint type `AzureIotHub.StorageContainer`.
        :param pulumi.Input[_builtins.str] encoding: Encoding that is used to serialize messages to blobs. Supported values are `Avro`, `AvroDeflate` and `JSON`. Default value is `Avro`. This attribute is applicable for endpoint type `AzureIotHub.StorageContainer`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] endpoint_uri: URI of the Service Bus or Event Hubs Namespace endpoint. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased` for endpoint type `AzureIotHub.ServiceBusQueue`, `AzureIotHub.ServiceBusTopic` or `AzureIotHub.EventHub`.
        :param pulumi.Input[_builtins.str] entity_path: Name of the Service Bus Queue/Topic or Event Hub. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased` for endpoint type `AzureIotHub.ServiceBusQueue`, `AzureIotHub.ServiceBusTopic` or `AzureIotHub.EventHub`.
        :param pulumi.Input[_builtins.str] file_name_format: File name format for the blob. All parameters are mandatory but can be reordered. This attribute is applicable for endpoint type `AzureIotHub.StorageContainer`. Defaults to `{iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}`.
        :param pulumi.Input[_builtins.str] identity_id: The ID of the User Managed Identity used to authenticate against the endpoint.
               
               > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the IoT Hub. If `identity_id` is omitted when `authentication_type` is `identityBased`, then the System-Assigned Managed Identity of the IoT Hub will be used.
               
               > **Note:** An IoT Hub can only be updated to use the System-Assigned Managed Identity for `endpoint` since it is not possible to grant access to the endpoint until after creation. The extracted resources `azurerm_iothub_endpoint_*` can be used to configure Endpoints with the IoT Hub's System-Assigned Managed Identity without the need for an update.
        :param pulumi.Input[_builtins.int] max_chunk_size_in_bytes: Maximum number of bytes for each blob written to storage. Value should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB). This attribute is applicable for endpoint type `AzureIotHub.StorageContainer`.
        :param pulumi.Input[_builtins.str] resource_group_name: The resource group in which the endpoint will be created.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if batch_frequency_in_seconds is not None:
            pulumi.set(__self__, "batch_frequency_in_seconds", batch_frequency_in_seconds)
        if connection_string is not None:
            pulumi.set(__self__, "connection_string", connection_string)
        if container_name is not None:
            pulumi.set(__self__, "container_name", container_name)
        if encoding is not None:
            pulumi.set(__self__, "encoding", encoding)
        if endpoint_uri is not None:
            pulumi.set(__self__, "endpoint_uri", endpoint_uri)
        if entity_path is not None:
            pulumi.set(__self__, "entity_path", entity_path)
        if file_name_format is not None:
            pulumi.set(__self__, "file_name_format", file_name_format)
        if identity_id is not None:
            pulumi.set(__self__, "identity_id", identity_id)
        if max_chunk_size_in_bytes is not None:
            pulumi.set(__self__, "max_chunk_size_in_bytes", max_chunk_size_in_bytes)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the endpoint. The name must be unique across endpoint types. The following names are reserved: `events`, `operationsMonitoringEvents`, `fileNotifications` and `$default`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of the endpoint. Possible values are `AzureIotHub.StorageContainer`, `AzureIotHub.ServiceBusQueue`, `AzureIotHub.ServiceBusTopic` or `AzureIotHub.EventHub`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type used to authenticate against the endpoint. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_type", value)

    @_builtins.property
    @pulumi.getter(name="batchFrequencyInSeconds")
    def batch_frequency_in_seconds(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Time interval at which blobs are written to storage. Value should be between 60 and 720 seconds. Default value is 300 seconds. This attribute is applicable for endpoint type `AzureIotHub.StorageContainer`.
        """
        return pulumi.get(self, "batch_frequency_in_seconds")

    @batch_frequency_in_seconds.setter
    def batch_frequency_in_seconds(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "batch_frequency_in_seconds", value)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The connection string for the endpoint. This attribute is mandatory and can only be specified when `authentication_type` is `keyBased`.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter(name="containerName")
    def container_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of storage container in the storage account. This attribute is mandatory for endpoint type `AzureIotHub.StorageContainer`.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_name", value)

    @_builtins.property
    @pulumi.getter
    def encoding(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Encoding that is used to serialize messages to blobs. Supported values are `Avro`, `AvroDeflate` and `JSON`. Default value is `Avro`. This attribute is applicable for endpoint type `AzureIotHub.StorageContainer`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encoding")

    @encoding.setter
    def encoding(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "encoding", value)

    @_builtins.property
    @pulumi.getter(name="endpointUri")
    def endpoint_uri(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        URI of the Service Bus or Event Hubs Namespace endpoint. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased` for endpoint type `AzureIotHub.ServiceBusQueue`, `AzureIotHub.ServiceBusTopic` or `AzureIotHub.EventHub`.
        """
        return pulumi.get(self, "endpoint_uri")

    @endpoint_uri.setter
    def endpoint_uri(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "endpoint_uri", value)

    @_builtins.property
    @pulumi.getter(name="entityPath")
    def entity_path(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Name of the Service Bus Queue/Topic or Event Hub. This attribute can only be specified and is mandatory when `authentication_type` is `identityBased` for endpoint type `AzureIotHub.ServiceBusQueue`, `AzureIotHub.ServiceBusTopic` or `AzureIotHub.EventHub`.
        """
        return pulumi.get(self, "entity_path")

    @entity_path.setter
    def entity_path(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "entity_path", value)

    @_builtins.property
    @pulumi.getter(name="fileNameFormat")
    def file_name_format(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        File name format for the blob. All parameters are mandatory but can be reordered. This attribute is applicable for endpoint type `AzureIotHub.StorageContainer`. Defaults to `{iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}`.
        """
        return pulumi.get(self, "file_name_format")

    @file_name_format.setter
    def file_name_format(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "file_name_format", value)

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the User Managed Identity used to authenticate against the endpoint.

        > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the IoT Hub. If `identity_id` is omitted when `authentication_type` is `identityBased`, then the System-Assigned Managed Identity of the IoT Hub will be used.

        > **Note:** An IoT Hub can only be updated to use the System-Assigned Managed Identity for `endpoint` since it is not possible to grant access to the endpoint until after creation. The extracted resources `azurerm_iothub_endpoint_*` can be used to configure Endpoints with the IoT Hub's System-Assigned Managed Identity without the need for an update.
        """
        return pulumi.get(self, "identity_id")

    @identity_id.setter
    def identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_id", value)

    @_builtins.property
    @pulumi.getter(name="maxChunkSizeInBytes")
    def max_chunk_size_in_bytes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Maximum number of bytes for each blob written to storage. Value should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB). This attribute is applicable for endpoint type `AzureIotHub.StorageContainer`.
        """
        return pulumi.get(self, "max_chunk_size_in_bytes")

    @max_chunk_size_in_bytes.setter
    def max_chunk_size_in_bytes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_chunk_size_in_bytes", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource group in which the endpoint will be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)


if not MYPY:
    class IoTHubEnrichmentArgsDict(TypedDict):
        endpoint_names: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        The list of endpoints which will be enriched.
        """
        key: pulumi.Input[_builtins.str]
        """
        The key of the enrichment.
        """
        value: pulumi.Input[_builtins.str]
        """
        The value of the enrichment. Value can be any static string, the name of the IoT Hub sending the message (use `$iothubname`) or information from the device twin (ex: `$twin.tags.latitude`)
        """
elif False:
    IoTHubEnrichmentArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IoTHubEnrichmentArgs:
    def __init__(__self__, *,
                 endpoint_names: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 key: pulumi.Input[_builtins.str],
                 value: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] endpoint_names: The list of endpoints which will be enriched.
        :param pulumi.Input[_builtins.str] key: The key of the enrichment.
        :param pulumi.Input[_builtins.str] value: The value of the enrichment. Value can be any static string, the name of the IoT Hub sending the message (use `$iothubname`) or information from the device twin (ex: `$twin.tags.latitude`)
        """
        pulumi.set(__self__, "endpoint_names", endpoint_names)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter(name="endpointNames")
    def endpoint_names(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of endpoints which will be enriched.
        """
        return pulumi.get(self, "endpoint_names")

    @endpoint_names.setter
    def endpoint_names(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "endpoint_names", value)

    @_builtins.property
    @pulumi.getter
    def key(self) -> pulumi.Input[_builtins.str]:
        """
        The key of the enrichment.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key", value)

    @_builtins.property
    @pulumi.getter
    def value(self) -> pulumi.Input[_builtins.str]:
        """
        The value of the enrichment. Value can be any static string, the name of the IoT Hub sending the message (use `$iothubname`) or information from the device twin (ex: `$twin.tags.latitude`)
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "value", value)


if not MYPY:
    class IoTHubFallbackRouteArgsDict(TypedDict):
        condition: NotRequired[pulumi.Input[_builtins.str]]
        """
        The condition that is evaluated to apply the routing rule. Defaults to `true`. For grammar, see: <https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language>.
        """
        enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Used to specify whether the fallback route is enabled. Defaults to `true`.
        """
        endpoint_names: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        The endpoints to which messages that satisfy the condition are routed. Currently only 1 endpoint is allowed.
        """
        source: NotRequired[pulumi.Input[_builtins.str]]
        """
        The source that the routing rule is to be applied to, such as `DeviceMessages`. Possible values include: `Invalid`, `DeviceMessages`, `TwinChangeEvents`, `DeviceLifecycleEvents`, `DeviceConnectionStateEvents`, `DeviceJobLifecycleEvents` and `DigitalTwinChangeEvents`. Defaults to `DeviceMessages`.
        """
elif False:
    IoTHubFallbackRouteArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IoTHubFallbackRouteArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 endpoint_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 source: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] condition: The condition that is evaluated to apply the routing rule. Defaults to `true`. For grammar, see: <https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language>.
        :param pulumi.Input[_builtins.bool] enabled: Used to specify whether the fallback route is enabled. Defaults to `true`.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] endpoint_names: The endpoints to which messages that satisfy the condition are routed. Currently only 1 endpoint is allowed.
        :param pulumi.Input[_builtins.str] source: The source that the routing rule is to be applied to, such as `DeviceMessages`. Possible values include: `Invalid`, `DeviceMessages`, `TwinChangeEvents`, `DeviceLifecycleEvents`, `DeviceConnectionStateEvents`, `DeviceJobLifecycleEvents` and `DigitalTwinChangeEvents`. Defaults to `DeviceMessages`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if endpoint_names is not None:
            pulumi.set(__self__, "endpoint_names", endpoint_names)
        if source is not None:
            pulumi.set(__self__, "source", source)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The condition that is evaluated to apply the routing rule. Defaults to `true`. For grammar, see: <https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language>.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Used to specify whether the fallback route is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="endpointNames")
    def endpoint_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The endpoints to which messages that satisfy the condition are routed. Currently only 1 endpoint is allowed.
        """
        return pulumi.get(self, "endpoint_names")

    @endpoint_names.setter
    def endpoint_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "endpoint_names", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The source that the routing rule is to be applied to, such as `DeviceMessages`. Possible values include: `Invalid`, `DeviceMessages`, `TwinChangeEvents`, `DeviceLifecycleEvents`, `DeviceConnectionStateEvents`, `DeviceJobLifecycleEvents` and `DigitalTwinChangeEvents`. Defaults to `DeviceMessages`.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source", value)


if not MYPY:
    class IoTHubFileUploadArgsDict(TypedDict):
        connection_string: pulumi.Input[_builtins.str]
        """
        The connection string for the Azure Storage account to which files are uploaded.
        """
        container_name: pulumi.Input[_builtins.str]
        """
        The name of the root container where the files should be uploaded to. The container need not exist but should be creatable using the connection_string specified.
        """
        authentication_type: NotRequired[pulumi.Input[_builtins.str]]
        """
        The type used to authenticate against the storage account. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        """
        default_ttl: NotRequired[pulumi.Input[_builtins.str]]
        """
        The period of time for which a file upload notification message is available to consume before it expires, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 48 hours. Defaults to `PT1H`.
        """
        identity_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the User Managed Identity used to authenticate against the storage account.

        > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the IoT Hub. If `identity_id` is omitted when `authentication_type` is `identityBased`, then the System-Assigned Managed Identity of the IoT Hub will be used.

        > **Note:** An IoT Hub can only be updated to use the System-Assigned Managed Identity for `file_upload` since it is not possible to grant access to the endpoint until after creation.
        """
        lock_duration: NotRequired[pulumi.Input[_builtins.str]]
        """
        The lock duration for the file upload notifications queue, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 5 and 300 seconds. Defaults to `PT1M`.
        """
        max_delivery_count: NotRequired[pulumi.Input[_builtins.int]]
        """
        The number of times the IoT Hub attempts to deliver a file upload notification message. Defaults to `10`.
        """
        notifications: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Used to specify whether file notifications are sent to IoT Hub on upload. Defaults to `false`.
        """
        sas_ttl: NotRequired[pulumi.Input[_builtins.str]]
        """
        The period of time for which the SAS URI generated by IoT Hub for file upload is valid, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 24 hours. Defaults to `PT1H`.
        """
elif False:
    IoTHubFileUploadArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IoTHubFileUploadArgs:
    def __init__(__self__, *,
                 connection_string: pulumi.Input[_builtins.str],
                 container_name: pulumi.Input[_builtins.str],
                 authentication_type: Optional[pulumi.Input[_builtins.str]] = None,
                 default_ttl: Optional[pulumi.Input[_builtins.str]] = None,
                 identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 lock_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 max_delivery_count: Optional[pulumi.Input[_builtins.int]] = None,
                 notifications: Optional[pulumi.Input[_builtins.bool]] = None,
                 sas_ttl: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] connection_string: The connection string for the Azure Storage account to which files are uploaded.
        :param pulumi.Input[_builtins.str] container_name: The name of the root container where the files should be uploaded to. The container need not exist but should be creatable using the connection_string specified.
        :param pulumi.Input[_builtins.str] authentication_type: The type used to authenticate against the storage account. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        :param pulumi.Input[_builtins.str] default_ttl: The period of time for which a file upload notification message is available to consume before it expires, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 48 hours. Defaults to `PT1H`.
        :param pulumi.Input[_builtins.str] identity_id: The ID of the User Managed Identity used to authenticate against the storage account.
               
               > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the IoT Hub. If `identity_id` is omitted when `authentication_type` is `identityBased`, then the System-Assigned Managed Identity of the IoT Hub will be used.
               
               > **Note:** An IoT Hub can only be updated to use the System-Assigned Managed Identity for `file_upload` since it is not possible to grant access to the endpoint until after creation.
        :param pulumi.Input[_builtins.str] lock_duration: The lock duration for the file upload notifications queue, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 5 and 300 seconds. Defaults to `PT1M`.
        :param pulumi.Input[_builtins.int] max_delivery_count: The number of times the IoT Hub attempts to deliver a file upload notification message. Defaults to `10`.
        :param pulumi.Input[_builtins.bool] notifications: Used to specify whether file notifications are sent to IoT Hub on upload. Defaults to `false`.
        :param pulumi.Input[_builtins.str] sas_ttl: The period of time for which the SAS URI generated by IoT Hub for file upload is valid, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 24 hours. Defaults to `PT1H`.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "container_name", container_name)
        if authentication_type is not None:
            pulumi.set(__self__, "authentication_type", authentication_type)
        if default_ttl is not None:
            pulumi.set(__self__, "default_ttl", default_ttl)
        if identity_id is not None:
            pulumi.set(__self__, "identity_id", identity_id)
        if lock_duration is not None:
            pulumi.set(__self__, "lock_duration", lock_duration)
        if max_delivery_count is not None:
            pulumi.set(__self__, "max_delivery_count", max_delivery_count)
        if notifications is not None:
            pulumi.set(__self__, "notifications", notifications)
        if sas_ttl is not None:
            pulumi.set(__self__, "sas_ttl", sas_ttl)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Input[_builtins.str]:
        """
        The connection string for the Azure Storage account to which files are uploaded.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter(name="containerName")
    def container_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the root container where the files should be uploaded to. The container need not exist but should be creatable using the connection_string specified.
        """
        return pulumi.get(self, "container_name")

    @container_name.setter
    def container_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "container_name", value)

    @_builtins.property
    @pulumi.getter(name="authenticationType")
    def authentication_type(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type used to authenticate against the storage account. Possible values are `keyBased` and `identityBased`. Defaults to `keyBased`.
        """
        return pulumi.get(self, "authentication_type")

    @authentication_type.setter
    def authentication_type(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "authentication_type", value)

    @_builtins.property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The period of time for which a file upload notification message is available to consume before it expires, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 48 hours. Defaults to `PT1H`.
        """
        return pulumi.get(self, "default_ttl")

    @default_ttl.setter
    def default_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_ttl", value)

    @_builtins.property
    @pulumi.getter(name="identityId")
    def identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the User Managed Identity used to authenticate against the storage account.

        > **Note:** `identity_id` can only be specified when `authentication_type` is `identityBased`. It must be one of the `identity_ids` of the IoT Hub. If `identity_id` is omitted when `authentication_type` is `identityBased`, then the System-Assigned Managed Identity of the IoT Hub will be used.

        > **Note:** An IoT Hub can only be updated to use the System-Assigned Managed Identity for `file_upload` since it is not possible to grant access to the endpoint until after creation.
        """
        return pulumi.get(self, "identity_id")

    @identity_id.setter
    def identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "identity_id", value)

    @_builtins.property
    @pulumi.getter(name="lockDuration")
    def lock_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The lock duration for the file upload notifications queue, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 5 and 300 seconds. Defaults to `PT1M`.
        """
        return pulumi.get(self, "lock_duration")

    @lock_duration.setter
    def lock_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lock_duration", value)

    @_builtins.property
    @pulumi.getter(name="maxDeliveryCount")
    def max_delivery_count(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of times the IoT Hub attempts to deliver a file upload notification message. Defaults to `10`.
        """
        return pulumi.get(self, "max_delivery_count")

    @max_delivery_count.setter
    def max_delivery_count(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "max_delivery_count", value)

    @_builtins.property
    @pulumi.getter
    def notifications(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Used to specify whether file notifications are sent to IoT Hub on upload. Defaults to `false`.
        """
        return pulumi.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "notifications", value)

    @_builtins.property
    @pulumi.getter(name="sasTtl")
    def sas_ttl(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The period of time for which the SAS URI generated by IoT Hub for file upload is valid, specified as an [ISO 8601 timespan duration](https://en.wikipedia.org/wiki/ISO_8601#Durations). This value must be between 1 minute and 24 hours. Defaults to `PT1H`.
        """
        return pulumi.get(self, "sas_ttl")

    @sas_ttl.setter
    def sas_ttl(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sas_ttl", value)


if not MYPY:
    class IoTHubIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this IoT Hub. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this IoT Hub.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Principal ID associated with this Managed Service Identity.
        """
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Tenant ID associated with this Managed Service Identity.
        """
elif False:
    IoTHubIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IoTHubIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this IoT Hub. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this IoT Hub.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param pulumi.Input[_builtins.str] principal_id: The Principal ID associated with this Managed Service Identity.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID associated with this Managed Service Identity.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this IoT Hub. Possible values are `SystemAssigned`, `UserAssigned`, `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this IoT Hub.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Principal ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID associated with this Managed Service Identity.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class IoTHubNetworkRuleSetArgsDict(TypedDict):
        apply_to_builtin_eventhub_endpoint: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Determines if Network Rule Set is also applied to the BuiltIn EventHub EndPoint of the IotHub. Defaults to `false`.
        """
        default_action: NotRequired[pulumi.Input[_builtins.str]]
        """
        Default Action for Network Rule Set. Possible values are `DefaultActionDeny`, `DefaultActionAllow`. Defaults to `DefaultActionDeny`.
        """
        ip_rules: NotRequired[pulumi.Input[Sequence[pulumi.Input['IoTHubNetworkRuleSetIpRuleArgsDict']]]]
        """
        One or more `ip_rule` blocks as defined below.
        """
elif False:
    IoTHubNetworkRuleSetArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IoTHubNetworkRuleSetArgs:
    def __init__(__self__, *,
                 apply_to_builtin_eventhub_endpoint: Optional[pulumi.Input[_builtins.bool]] = None,
                 default_action: Optional[pulumi.Input[_builtins.str]] = None,
                 ip_rules: Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubNetworkRuleSetIpRuleArgs']]]] = None):
        """
        :param pulumi.Input[_builtins.bool] apply_to_builtin_eventhub_endpoint: Determines if Network Rule Set is also applied to the BuiltIn EventHub EndPoint of the IotHub. Defaults to `false`.
        :param pulumi.Input[_builtins.str] default_action: Default Action for Network Rule Set. Possible values are `DefaultActionDeny`, `DefaultActionAllow`. Defaults to `DefaultActionDeny`.
        :param pulumi.Input[Sequence[pulumi.Input['IoTHubNetworkRuleSetIpRuleArgs']]] ip_rules: One or more `ip_rule` blocks as defined below.
        """
        if apply_to_builtin_eventhub_endpoint is not None:
            pulumi.set(__self__, "apply_to_builtin_eventhub_endpoint", apply_to_builtin_eventhub_endpoint)
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if ip_rules is not None:
            pulumi.set(__self__, "ip_rules", ip_rules)

    @_builtins.property
    @pulumi.getter(name="applyToBuiltinEventhubEndpoint")
    def apply_to_builtin_eventhub_endpoint(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines if Network Rule Set is also applied to the BuiltIn EventHub EndPoint of the IotHub. Defaults to `false`.
        """
        return pulumi.get(self, "apply_to_builtin_eventhub_endpoint")

    @apply_to_builtin_eventhub_endpoint.setter
    def apply_to_builtin_eventhub_endpoint(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "apply_to_builtin_eventhub_endpoint", value)

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Default Action for Network Rule Set. Possible values are `DefaultActionDeny`, `DefaultActionAllow`. Defaults to `DefaultActionDeny`.
        """
        return pulumi.get(self, "default_action")

    @default_action.setter
    def default_action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_action", value)

    @_builtins.property
    @pulumi.getter(name="ipRules")
    def ip_rules(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubNetworkRuleSetIpRuleArgs']]]]:
        """
        One or more `ip_rule` blocks as defined below.
        """
        return pulumi.get(self, "ip_rules")

    @ip_rules.setter
    def ip_rules(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IoTHubNetworkRuleSetIpRuleArgs']]]]):
        pulumi.set(self, "ip_rules", value)


if not MYPY:
    class IoTHubNetworkRuleSetIpRuleArgsDict(TypedDict):
        ip_mask: pulumi.Input[_builtins.str]
        """
        The IP address range in CIDR notation for the ip rule.
        """
        name: pulumi.Input[_builtins.str]
        """
        The name of the ip rule.
        """
        action: NotRequired[pulumi.Input[_builtins.str]]
        """
        The desired action for requests captured by this rule. Possible values are `Allow`. Defaults to `Allow`.
        """
elif False:
    IoTHubNetworkRuleSetIpRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IoTHubNetworkRuleSetIpRuleArgs:
    def __init__(__self__, *,
                 ip_mask: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 action: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] ip_mask: The IP address range in CIDR notation for the ip rule.
        :param pulumi.Input[_builtins.str] name: The name of the ip rule.
        :param pulumi.Input[_builtins.str] action: The desired action for requests captured by this rule. Possible values are `Allow`. Defaults to `Allow`.
        """
        pulumi.set(__self__, "ip_mask", ip_mask)
        pulumi.set(__self__, "name", name)
        if action is not None:
            pulumi.set(__self__, "action", action)

    @_builtins.property
    @pulumi.getter(name="ipMask")
    def ip_mask(self) -> pulumi.Input[_builtins.str]:
        """
        The IP address range in CIDR notation for the ip rule.
        """
        return pulumi.get(self, "ip_mask")

    @ip_mask.setter
    def ip_mask(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ip_mask", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the ip rule.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The desired action for requests captured by this rule. Possible values are `Allow`. Defaults to `Allow`.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "action", value)


if not MYPY:
    class IoTHubRouteArgsDict(TypedDict):
        enabled: pulumi.Input[_builtins.bool]
        """
        Used to specify whether a route is enabled.
        """
        endpoint_names: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        The list of endpoints to which messages that satisfy the condition are routed.
        """
        name: pulumi.Input[_builtins.str]
        """
        The name of the route.
        """
        source: pulumi.Input[_builtins.str]
        """
        The source that the routing rule is to be applied to, such as `DeviceMessages`. Possible values include: `Invalid`, `DeviceMessages`, `TwinChangeEvents`, `DeviceLifecycleEvents`, `DeviceConnectionStateEvents`, `DeviceJobLifecycleEvents` and `DigitalTwinChangeEvents`.
        """
        condition: NotRequired[pulumi.Input[_builtins.str]]
        """
        The condition that is evaluated to apply the routing rule. Defaults to `true`. For grammar, see: <https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language>.
        """
elif False:
    IoTHubRouteArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IoTHubRouteArgs:
    def __init__(__self__, *,
                 enabled: pulumi.Input[_builtins.bool],
                 endpoint_names: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 name: pulumi.Input[_builtins.str],
                 source: pulumi.Input[_builtins.str],
                 condition: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.bool] enabled: Used to specify whether a route is enabled.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] endpoint_names: The list of endpoints to which messages that satisfy the condition are routed.
        :param pulumi.Input[_builtins.str] name: The name of the route.
        :param pulumi.Input[_builtins.str] source: The source that the routing rule is to be applied to, such as `DeviceMessages`. Possible values include: `Invalid`, `DeviceMessages`, `TwinChangeEvents`, `DeviceLifecycleEvents`, `DeviceConnectionStateEvents`, `DeviceJobLifecycleEvents` and `DigitalTwinChangeEvents`.
        :param pulumi.Input[_builtins.str] condition: The condition that is evaluated to apply the routing rule. Defaults to `true`. For grammar, see: <https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language>.
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "endpoint_names", endpoint_names)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "source", source)
        if condition is not None:
            pulumi.set(__self__, "condition", condition)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Input[_builtins.bool]:
        """
        Used to specify whether a route is enabled.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: pulumi.Input[_builtins.bool]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="endpointNames")
    def endpoint_names(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        The list of endpoints to which messages that satisfy the condition are routed.
        """
        return pulumi.get(self, "endpoint_names")

    @endpoint_names.setter
    def endpoint_names(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "endpoint_names", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the route.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def source(self) -> pulumi.Input[_builtins.str]:
        """
        The source that the routing rule is to be applied to, such as `DeviceMessages`. Possible values include: `Invalid`, `DeviceMessages`, `TwinChangeEvents`, `DeviceLifecycleEvents`, `DeviceConnectionStateEvents`, `DeviceJobLifecycleEvents` and `DigitalTwinChangeEvents`.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "source", value)

    @_builtins.property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The condition that is evaluated to apply the routing rule. Defaults to `true`. For grammar, see: <https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language>.
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "condition", value)


if not MYPY:
    class IoTHubSharedAccessPolicyArgsDict(TypedDict):
        key_name: NotRequired[pulumi.Input[_builtins.str]]
        """
        The name of the shared access policy.
        """
        permissions: NotRequired[pulumi.Input[_builtins.str]]
        """
        The permissions assigned to the shared access policy.
        """
        primary_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        The primary key.
        """
        secondary_key: NotRequired[pulumi.Input[_builtins.str]]
        """
        The secondary key.
        """
elif False:
    IoTHubSharedAccessPolicyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IoTHubSharedAccessPolicyArgs:
    def __init__(__self__, *,
                 key_name: Optional[pulumi.Input[_builtins.str]] = None,
                 permissions: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_key: Optional[pulumi.Input[_builtins.str]] = None,
                 secondary_key: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] key_name: The name of the shared access policy.
        :param pulumi.Input[_builtins.str] permissions: The permissions assigned to the shared access policy.
        :param pulumi.Input[_builtins.str] primary_key: The primary key.
        :param pulumi.Input[_builtins.str] secondary_key: The secondary key.
        """
        if key_name is not None:
            pulumi.set(__self__, "key_name", key_name)
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if primary_key is not None:
            pulumi.set(__self__, "primary_key", primary_key)
        if secondary_key is not None:
            pulumi.set(__self__, "secondary_key", secondary_key)

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the shared access policy.
        """
        return pulumi.get(self, "key_name")

    @key_name.setter
    def key_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_name", value)

    @_builtins.property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The permissions assigned to the shared access policy.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "permissions", value)

    @_builtins.property
    @pulumi.getter(name="primaryKey")
    def primary_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The primary key.
        """
        return pulumi.get(self, "primary_key")

    @primary_key.setter
    def primary_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_key", value)

    @_builtins.property
    @pulumi.getter(name="secondaryKey")
    def secondary_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The secondary key.
        """
        return pulumi.get(self, "secondary_key")

    @secondary_key.setter
    def secondary_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "secondary_key", value)


if not MYPY:
    class IoTHubSkuArgsDict(TypedDict):
        capacity: pulumi.Input[_builtins.int]
        """
        The number of provisioned IoT Hub units.

        > **Note:** Only one IotHub can be on the `Free` tier per subscription.
        """
        name: pulumi.Input[_builtins.str]
        """
        The name of the sku. Possible values are `B1`, `B2`, `B3`, `F1`, `S1`, `S2`, and `S3`.

        > **Note:** The `F1` sku is on `Free` tier.
        """
elif False:
    IoTHubSkuArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IoTHubSkuArgs:
    def __init__(__self__, *,
                 capacity: pulumi.Input[_builtins.int],
                 name: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.int] capacity: The number of provisioned IoT Hub units.
               
               > **Note:** Only one IotHub can be on the `Free` tier per subscription.
        :param pulumi.Input[_builtins.str] name: The name of the sku. Possible values are `B1`, `B2`, `B3`, `F1`, `S1`, `S2`, and `S3`.
               
               > **Note:** The `F1` sku is on `Free` tier.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> pulumi.Input[_builtins.int]:
        """
        The number of provisioned IoT Hub units.

        > **Note:** Only one IotHub can be on the `Free` tier per subscription.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the sku. Possible values are `B1`, `B2`, `B3`, `F1`, `S1`, `S2`, and `S3`.

        > **Note:** The `F1` sku is on `Free` tier.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)


if not MYPY:
    class IotHubDeviceUpdateAccountIdentityArgsDict(TypedDict):
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this IoT Hub Device Update Account. Possible values are `SystemAssigned`, `UserAssigned` and `SystemAssigned, UserAssigned` (to enable both).
        """
        identity_ids: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        A list of User Assigned Managed Identity IDs to be assigned to this IoT Hub Device Update Account.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        principal_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Principal ID for the Service Principal associated with the Managed Service Identity of this IoT Hub Device Update Account.
        """
        tenant_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The Tenant ID for the Service Principal associated with the Managed Service Identity of this IoT Hub Device Update Account.
        """
elif False:
    IotHubDeviceUpdateAccountIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IotHubDeviceUpdateAccountIdentityArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[_builtins.str],
                 identity_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 principal_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tenant_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this IoT Hub Device Update Account. Possible values are `SystemAssigned`, `UserAssigned` and `SystemAssigned, UserAssigned` (to enable both).
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: A list of User Assigned Managed Identity IDs to be assigned to this IoT Hub Device Update Account.
               
               > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param pulumi.Input[_builtins.str] principal_id: The Principal ID for the Service Principal associated with the Managed Service Identity of this IoT Hub Device Update Account.
        :param pulumi.Input[_builtins.str] tenant_id: The Tenant ID for the Service Principal associated with the Managed Service Identity of this IoT Hub Device Update Account.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this IoT Hub Device Update Account. Possible values are `SystemAssigned`, `UserAssigned` and `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of User Assigned Managed Identity IDs to be assigned to this IoT Hub Device Update Account.

        > **Note:** This is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Principal ID for the Service Principal associated with the Managed Service Identity of this IoT Hub Device Update Account.
        """
        return pulumi.get(self, "principal_id")

    @principal_id.setter
    def principal_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "principal_id", value)

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Tenant ID for the Service Principal associated with the Managed Service Identity of this IoT Hub Device Update Account.
        """
        return pulumi.get(self, "tenant_id")

    @tenant_id.setter
    def tenant_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "tenant_id", value)


if not MYPY:
    class IotHubDeviceUpdateInstanceDiagnosticStorageAccountArgsDict(TypedDict):
        connection_string: pulumi.Input[_builtins.str]
        """
        Connection String of the Diagnostic Storage Account.
        """
        id: pulumi.Input[_builtins.str]
        """
        Resource ID of the Diagnostic Storage Account.
        """
elif False:
    IotHubDeviceUpdateInstanceDiagnosticStorageAccountArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IotHubDeviceUpdateInstanceDiagnosticStorageAccountArgs:
    def __init__(__self__, *,
                 connection_string: pulumi.Input[_builtins.str],
                 id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] connection_string: Connection String of the Diagnostic Storage Account.
        :param pulumi.Input[_builtins.str] id: Resource ID of the Diagnostic Storage Account.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Input[_builtins.str]:
        """
        Connection String of the Diagnostic Storage Account.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter
    def id(self) -> pulumi.Input[_builtins.str]:
        """
        Resource ID of the Diagnostic Storage Account.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "id", value)


if not MYPY:
    class IotHubDpsIpFilterRuleArgsDict(TypedDict):
        action: pulumi.Input[_builtins.str]
        """
        The desired action for requests captured by this rule. Possible values are `Accept`, `Reject`
        """
        ip_mask: pulumi.Input[_builtins.str]
        """
        The IP address range in CIDR notation for the rule.
        """
        name: pulumi.Input[_builtins.str]
        """
        The name of the filter.
        """
        target: NotRequired[pulumi.Input[_builtins.str]]
        """
        Target for requests captured by this rule. Possible values are `all`, `deviceApi` and `serviceApi`.
        """
elif False:
    IotHubDpsIpFilterRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IotHubDpsIpFilterRuleArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[_builtins.str],
                 ip_mask: pulumi.Input[_builtins.str],
                 name: pulumi.Input[_builtins.str],
                 target: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] action: The desired action for requests captured by this rule. Possible values are `Accept`, `Reject`
        :param pulumi.Input[_builtins.str] ip_mask: The IP address range in CIDR notation for the rule.
        :param pulumi.Input[_builtins.str] name: The name of the filter.
        :param pulumi.Input[_builtins.str] target: Target for requests captured by this rule. Possible values are `all`, `deviceApi` and `serviceApi`.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "ip_mask", ip_mask)
        pulumi.set(__self__, "name", name)
        if target is not None:
            pulumi.set(__self__, "target", target)

    @_builtins.property
    @pulumi.getter
    def action(self) -> pulumi.Input[_builtins.str]:
        """
        The desired action for requests captured by this rule. Possible values are `Accept`, `Reject`
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "action", value)

    @_builtins.property
    @pulumi.getter(name="ipMask")
    def ip_mask(self) -> pulumi.Input[_builtins.str]:
        """
        The IP address range in CIDR notation for the rule.
        """
        return pulumi.get(self, "ip_mask")

    @ip_mask.setter
    def ip_mask(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "ip_mask", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the filter.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def target(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Target for requests captured by this rule. Possible values are `all`, `deviceApi` and `serviceApi`.
        """
        return pulumi.get(self, "target")

    @target.setter
    def target(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target", value)


if not MYPY:
    class IotHubDpsLinkedHubArgsDict(TypedDict):
        connection_string: pulumi.Input[_builtins.str]
        """
        The connection string to connect to the IoT Hub.
        """
        location: pulumi.Input[_builtins.str]
        """
        The location of the IoT hub.
        """
        allocation_weight: NotRequired[pulumi.Input[_builtins.int]]
        """
        The weight applied to the IoT Hub. Defaults to `1`.
        """
        apply_allocation_policy: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Determines whether to apply allocation policies to the IoT Hub. Defaults to `true`.
        """
        hostname: NotRequired[pulumi.Input[_builtins.str]]
        """
        The IoT Hub hostname.
        """
elif False:
    IotHubDpsLinkedHubArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IotHubDpsLinkedHubArgs:
    def __init__(__self__, *,
                 connection_string: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 allocation_weight: Optional[pulumi.Input[_builtins.int]] = None,
                 apply_allocation_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 hostname: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] connection_string: The connection string to connect to the IoT Hub.
        :param pulumi.Input[_builtins.str] location: The location of the IoT hub.
        :param pulumi.Input[_builtins.int] allocation_weight: The weight applied to the IoT Hub. Defaults to `1`.
        :param pulumi.Input[_builtins.bool] apply_allocation_policy: Determines whether to apply allocation policies to the IoT Hub. Defaults to `true`.
        :param pulumi.Input[_builtins.str] hostname: The IoT Hub hostname.
        """
        pulumi.set(__self__, "connection_string", connection_string)
        pulumi.set(__self__, "location", location)
        if allocation_weight is not None:
            pulumi.set(__self__, "allocation_weight", allocation_weight)
        if apply_allocation_policy is not None:
            pulumi.set(__self__, "apply_allocation_policy", apply_allocation_policy)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)

    @_builtins.property
    @pulumi.getter(name="connectionString")
    def connection_string(self) -> pulumi.Input[_builtins.str]:
        """
        The connection string to connect to the IoT Hub.
        """
        return pulumi.get(self, "connection_string")

    @connection_string.setter
    def connection_string(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "connection_string", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The location of the IoT hub.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="allocationWeight")
    def allocation_weight(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The weight applied to the IoT Hub. Defaults to `1`.
        """
        return pulumi.get(self, "allocation_weight")

    @allocation_weight.setter
    def allocation_weight(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "allocation_weight", value)

    @_builtins.property
    @pulumi.getter(name="applyAllocationPolicy")
    def apply_allocation_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Determines whether to apply allocation policies to the IoT Hub. Defaults to `true`.
        """
        return pulumi.get(self, "apply_allocation_policy")

    @apply_allocation_policy.setter
    def apply_allocation_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "apply_allocation_policy", value)

    @_builtins.property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The IoT Hub hostname.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hostname", value)


if not MYPY:
    class IotHubDpsSkuArgsDict(TypedDict):
        capacity: pulumi.Input[_builtins.int]
        """
        The number of provisioned IoT Device Provisioning Service units.
        """
        name: pulumi.Input[_builtins.str]
        """
        The name of the sku. Currently can only be set to `S1`.
        """
elif False:
    IotHubDpsSkuArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class IotHubDpsSkuArgs:
    def __init__(__self__, *,
                 capacity: pulumi.Input[_builtins.int],
                 name: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.int] capacity: The number of provisioned IoT Device Provisioning Service units.
        :param pulumi.Input[_builtins.str] name: The name of the sku. Currently can only be set to `S1`.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def capacity(self) -> pulumi.Input[_builtins.int]:
        """
        The number of provisioned IoT Device Provisioning Service units.
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "capacity", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the sku. Currently can only be set to `S1`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "name", value)


if not MYPY:
    class SecurityDeviceGroupAllowRuleArgsDict(TypedDict):
        connection_from_ips_not_alloweds: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies which IP is not allowed to be connected to in current device group for inbound connection.
        """
        connection_to_ips_not_alloweds: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies which IP is not allowed to be connected to in current device group for outbound connection.
        """
        local_users_not_alloweds: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies which local user is not allowed to login in current device group.
        """
        processes_not_alloweds: NotRequired[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]
        """
        Specifies which process is not allowed to be executed in current device group.
        """
elif False:
    SecurityDeviceGroupAllowRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityDeviceGroupAllowRuleArgs:
    def __init__(__self__, *,
                 connection_from_ips_not_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 connection_to_ips_not_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 local_users_not_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 processes_not_alloweds: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] connection_from_ips_not_alloweds: Specifies which IP is not allowed to be connected to in current device group for inbound connection.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] connection_to_ips_not_alloweds: Specifies which IP is not allowed to be connected to in current device group for outbound connection.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] local_users_not_alloweds: Specifies which local user is not allowed to login in current device group.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] processes_not_alloweds: Specifies which process is not allowed to be executed in current device group.
        """
        if connection_from_ips_not_alloweds is not None:
            pulumi.set(__self__, "connection_from_ips_not_alloweds", connection_from_ips_not_alloweds)
        if connection_to_ips_not_alloweds is not None:
            pulumi.set(__self__, "connection_to_ips_not_alloweds", connection_to_ips_not_alloweds)
        if local_users_not_alloweds is not None:
            pulumi.set(__self__, "local_users_not_alloweds", local_users_not_alloweds)
        if processes_not_alloweds is not None:
            pulumi.set(__self__, "processes_not_alloweds", processes_not_alloweds)

    @_builtins.property
    @pulumi.getter(name="connectionFromIpsNotAlloweds")
    def connection_from_ips_not_alloweds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies which IP is not allowed to be connected to in current device group for inbound connection.
        """
        return pulumi.get(self, "connection_from_ips_not_alloweds")

    @connection_from_ips_not_alloweds.setter
    def connection_from_ips_not_alloweds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "connection_from_ips_not_alloweds", value)

    @_builtins.property
    @pulumi.getter(name="connectionToIpsNotAlloweds")
    def connection_to_ips_not_alloweds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies which IP is not allowed to be connected to in current device group for outbound connection.
        """
        return pulumi.get(self, "connection_to_ips_not_alloweds")

    @connection_to_ips_not_alloweds.setter
    def connection_to_ips_not_alloweds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "connection_to_ips_not_alloweds", value)

    @_builtins.property
    @pulumi.getter(name="localUsersNotAlloweds")
    def local_users_not_alloweds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies which local user is not allowed to login in current device group.
        """
        return pulumi.get(self, "local_users_not_alloweds")

    @local_users_not_alloweds.setter
    def local_users_not_alloweds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "local_users_not_alloweds", value)

    @_builtins.property
    @pulumi.getter(name="processesNotAlloweds")
    def processes_not_alloweds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        Specifies which process is not allowed to be executed in current device group.
        """
        return pulumi.get(self, "processes_not_alloweds")

    @processes_not_alloweds.setter
    def processes_not_alloweds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "processes_not_alloweds", value)


if not MYPY:
    class SecurityDeviceGroupRangeRuleArgsDict(TypedDict):
        duration: pulumi.Input[_builtins.str]
        """
        Specifies the time range. represented in ISO 8601 duration format.
        """
        max: pulumi.Input[_builtins.int]
        """
        The maximum threshold in the given time window.
        """
        min: pulumi.Input[_builtins.int]
        """
        The minimum threshold in the given time window.
        """
        type: pulumi.Input[_builtins.str]
        """
        The type of supported rule type. Possible Values are `ActiveConnectionsNotInAllowedRange`, `AmqpC2DMessagesNotInAllowedRange`, `MqttC2DMessagesNotInAllowedRange`, `HttpC2DMessagesNotInAllowedRange`, `AmqpC2DRejectedMessagesNotInAllowedRange`, `MqttC2DRejectedMessagesNotInAllowedRange`, `HttpC2DRejectedMessagesNotInAllowedRange`, `AmqpD2CMessagesNotInAllowedRange`, `MqttD2CMessagesNotInAllowedRange`, `HttpD2CMessagesNotInAllowedRange`, `DirectMethodInvokesNotInAllowedRange`, `FailedLocalLoginsNotInAllowedRange`, `FileUploadsNotInAllowedRange`, `QueuePurgesNotInAllowedRange`, `TwinUpdatesNotInAllowedRange` and `UnauthorizedOperationsNotInAllowedRange`.
        """
elif False:
    SecurityDeviceGroupRangeRuleArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecurityDeviceGroupRangeRuleArgs:
    def __init__(__self__, *,
                 duration: pulumi.Input[_builtins.str],
                 max: pulumi.Input[_builtins.int],
                 min: pulumi.Input[_builtins.int],
                 type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[_builtins.str] duration: Specifies the time range. represented in ISO 8601 duration format.
        :param pulumi.Input[_builtins.int] max: The maximum threshold in the given time window.
        :param pulumi.Input[_builtins.int] min: The minimum threshold in the given time window.
        :param pulumi.Input[_builtins.str] type: The type of supported rule type. Possible Values are `ActiveConnectionsNotInAllowedRange`, `AmqpC2DMessagesNotInAllowedRange`, `MqttC2DMessagesNotInAllowedRange`, `HttpC2DMessagesNotInAllowedRange`, `AmqpC2DRejectedMessagesNotInAllowedRange`, `MqttC2DRejectedMessagesNotInAllowedRange`, `HttpC2DRejectedMessagesNotInAllowedRange`, `AmqpD2CMessagesNotInAllowedRange`, `MqttD2CMessagesNotInAllowedRange`, `HttpD2CMessagesNotInAllowedRange`, `DirectMethodInvokesNotInAllowedRange`, `FailedLocalLoginsNotInAllowedRange`, `FileUploadsNotInAllowedRange`, `QueuePurgesNotInAllowedRange`, `TwinUpdatesNotInAllowedRange` and `UnauthorizedOperationsNotInAllowedRange`.
        """
        pulumi.set(__self__, "duration", duration)
        pulumi.set(__self__, "max", max)
        pulumi.set(__self__, "min", min)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def duration(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the time range. represented in ISO 8601 duration format.
        """
        return pulumi.get(self, "duration")

    @duration.setter
    def duration(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "duration", value)

    @_builtins.property
    @pulumi.getter
    def max(self) -> pulumi.Input[_builtins.int]:
        """
        The maximum threshold in the given time window.
        """
        return pulumi.get(self, "max")

    @max.setter
    def max(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "max", value)

    @_builtins.property
    @pulumi.getter
    def min(self) -> pulumi.Input[_builtins.int]:
        """
        The minimum threshold in the given time window.
        """
        return pulumi.get(self, "min")

    @min.setter
    def min(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "min", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        The type of supported rule type. Possible Values are `ActiveConnectionsNotInAllowedRange`, `AmqpC2DMessagesNotInAllowedRange`, `MqttC2DMessagesNotInAllowedRange`, `HttpC2DMessagesNotInAllowedRange`, `AmqpC2DRejectedMessagesNotInAllowedRange`, `MqttC2DRejectedMessagesNotInAllowedRange`, `HttpC2DRejectedMessagesNotInAllowedRange`, `AmqpD2CMessagesNotInAllowedRange`, `MqttD2CMessagesNotInAllowedRange`, `HttpD2CMessagesNotInAllowedRange`, `DirectMethodInvokesNotInAllowedRange`, `FailedLocalLoginsNotInAllowedRange`, `FileUploadsNotInAllowedRange`, `QueuePurgesNotInAllowedRange`, `TwinUpdatesNotInAllowedRange` and `UnauthorizedOperationsNotInAllowedRange`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class SecuritySolutionAdditionalWorkspaceArgsDict(TypedDict):
        data_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        A list of data types which sent to workspace. Possible values are `Alerts` and `RawEvents`.
        """
        workspace_id: pulumi.Input[_builtins.str]
        """
        The resource ID of the Log Analytics Workspace.
        """
elif False:
    SecuritySolutionAdditionalWorkspaceArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecuritySolutionAdditionalWorkspaceArgs:
    def __init__(__self__, *,
                 data_types: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 workspace_id: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] data_types: A list of data types which sent to workspace. Possible values are `Alerts` and `RawEvents`.
        :param pulumi.Input[_builtins.str] workspace_id: The resource ID of the Log Analytics Workspace.
        """
        pulumi.set(__self__, "data_types", data_types)
        pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="dataTypes")
    def data_types(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of data types which sent to workspace. Possible values are `Alerts` and `RawEvents`.
        """
        return pulumi.get(self, "data_types")

    @data_types.setter
    def data_types(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "data_types", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource ID of the Log Analytics Workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "workspace_id", value)


if not MYPY:
    class SecuritySolutionRecommendationsEnabledArgsDict(TypedDict):
        acr_authentication: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Is Principal Authentication enabled for the ACR repository? Defaults to `true`.
        """
        agent_send_unutilized_msg: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Is Agent send underutilized messages enabled? Defaults to `true`.
        """
        baseline: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Is Security related system configuration issues identified? Defaults to `true`.
        """
        edge_hub_mem_optimize: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Is IoT Edge Hub memory optimized? Defaults to `true`.
        """
        edge_logging_option: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Is logging configured for IoT Edge module? Defaults to `true`.
        """
        inconsistent_module_settings: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Is inconsistent module settings enabled for SecurityGroup? Defaults to `true`.
        """
        install_agent: NotRequired[pulumi.Input[_builtins.bool]]
        """
        is Azure IoT Security agent installed? Defaults to `true`.
        """
        ip_filter_deny_all: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Is Default IP filter policy denied? Defaults to `true`.
        """
        ip_filter_permissive_rule: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Is IP filter rule source allowable IP range too large? Defaults to `true`.
        """
        open_ports: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Is any ports open on the device? Defaults to `true`.
        """
        permissive_firewall_policy: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Does firewall policy exist which allow necessary communication to/from the device? Defaults to `true`.
        """
        permissive_input_firewall_rules: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Is only necessary addresses or ports are permitted in? Defaults to `true`.
        """
        permissive_output_firewall_rules: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Is only necessary addresses or ports are permitted out? Defaults to `true`.
        """
        privileged_docker_options: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Is high level permissions are needed for the module? Defaults to `true`.
        """
        shared_credentials: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Is any credentials shared among devices? Defaults to `true`.
        """
        vulnerable_tls_cipher_suite: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Does TLS cipher suite need to be updated? Defaults to `true`.
        """
elif False:
    SecuritySolutionRecommendationsEnabledArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class SecuritySolutionRecommendationsEnabledArgs:
    def __init__(__self__, *,
                 acr_authentication: Optional[pulumi.Input[_builtins.bool]] = None,
                 agent_send_unutilized_msg: Optional[pulumi.Input[_builtins.bool]] = None,
                 baseline: Optional[pulumi.Input[_builtins.bool]] = None,
                 edge_hub_mem_optimize: Optional[pulumi.Input[_builtins.bool]] = None,
                 edge_logging_option: Optional[pulumi.Input[_builtins.bool]] = None,
                 inconsistent_module_settings: Optional[pulumi.Input[_builtins.bool]] = None,
                 install_agent: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_filter_deny_all: Optional[pulumi.Input[_builtins.bool]] = None,
                 ip_filter_permissive_rule: Optional[pulumi.Input[_builtins.bool]] = None,
                 open_ports: Optional[pulumi.Input[_builtins.bool]] = None,
                 permissive_firewall_policy: Optional[pulumi.Input[_builtins.bool]] = None,
                 permissive_input_firewall_rules: Optional[pulumi.Input[_builtins.bool]] = None,
                 permissive_output_firewall_rules: Optional[pulumi.Input[_builtins.bool]] = None,
                 privileged_docker_options: Optional[pulumi.Input[_builtins.bool]] = None,
                 shared_credentials: Optional[pulumi.Input[_builtins.bool]] = None,
                 vulnerable_tls_cipher_suite: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        :param pulumi.Input[_builtins.bool] acr_authentication: Is Principal Authentication enabled for the ACR repository? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] agent_send_unutilized_msg: Is Agent send underutilized messages enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] baseline: Is Security related system configuration issues identified? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] edge_hub_mem_optimize: Is IoT Edge Hub memory optimized? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] edge_logging_option: Is logging configured for IoT Edge module? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] inconsistent_module_settings: Is inconsistent module settings enabled for SecurityGroup? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] install_agent: is Azure IoT Security agent installed? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] ip_filter_deny_all: Is Default IP filter policy denied? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] ip_filter_permissive_rule: Is IP filter rule source allowable IP range too large? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] open_ports: Is any ports open on the device? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] permissive_firewall_policy: Does firewall policy exist which allow necessary communication to/from the device? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] permissive_input_firewall_rules: Is only necessary addresses or ports are permitted in? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] permissive_output_firewall_rules: Is only necessary addresses or ports are permitted out? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] privileged_docker_options: Is high level permissions are needed for the module? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] shared_credentials: Is any credentials shared among devices? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] vulnerable_tls_cipher_suite: Does TLS cipher suite need to be updated? Defaults to `true`.
        """
        if acr_authentication is not None:
            pulumi.set(__self__, "acr_authentication", acr_authentication)
        if agent_send_unutilized_msg is not None:
            pulumi.set(__self__, "agent_send_unutilized_msg", agent_send_unutilized_msg)
        if baseline is not None:
            pulumi.set(__self__, "baseline", baseline)
        if edge_hub_mem_optimize is not None:
            pulumi.set(__self__, "edge_hub_mem_optimize", edge_hub_mem_optimize)
        if edge_logging_option is not None:
            pulumi.set(__self__, "edge_logging_option", edge_logging_option)
        if inconsistent_module_settings is not None:
            pulumi.set(__self__, "inconsistent_module_settings", inconsistent_module_settings)
        if install_agent is not None:
            pulumi.set(__self__, "install_agent", install_agent)
        if ip_filter_deny_all is not None:
            pulumi.set(__self__, "ip_filter_deny_all", ip_filter_deny_all)
        if ip_filter_permissive_rule is not None:
            pulumi.set(__self__, "ip_filter_permissive_rule", ip_filter_permissive_rule)
        if open_ports is not None:
            pulumi.set(__self__, "open_ports", open_ports)
        if permissive_firewall_policy is not None:
            pulumi.set(__self__, "permissive_firewall_policy", permissive_firewall_policy)
        if permissive_input_firewall_rules is not None:
            pulumi.set(__self__, "permissive_input_firewall_rules", permissive_input_firewall_rules)
        if permissive_output_firewall_rules is not None:
            pulumi.set(__self__, "permissive_output_firewall_rules", permissive_output_firewall_rules)
        if privileged_docker_options is not None:
            pulumi.set(__self__, "privileged_docker_options", privileged_docker_options)
        if shared_credentials is not None:
            pulumi.set(__self__, "shared_credentials", shared_credentials)
        if vulnerable_tls_cipher_suite is not None:
            pulumi.set(__self__, "vulnerable_tls_cipher_suite", vulnerable_tls_cipher_suite)

    @_builtins.property
    @pulumi.getter(name="acrAuthentication")
    def acr_authentication(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Principal Authentication enabled for the ACR repository? Defaults to `true`.
        """
        return pulumi.get(self, "acr_authentication")

    @acr_authentication.setter
    def acr_authentication(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "acr_authentication", value)

    @_builtins.property
    @pulumi.getter(name="agentSendUnutilizedMsg")
    def agent_send_unutilized_msg(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Agent send underutilized messages enabled? Defaults to `true`.
        """
        return pulumi.get(self, "agent_send_unutilized_msg")

    @agent_send_unutilized_msg.setter
    def agent_send_unutilized_msg(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "agent_send_unutilized_msg", value)

    @_builtins.property
    @pulumi.getter
    def baseline(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Security related system configuration issues identified? Defaults to `true`.
        """
        return pulumi.get(self, "baseline")

    @baseline.setter
    def baseline(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "baseline", value)

    @_builtins.property
    @pulumi.getter(name="edgeHubMemOptimize")
    def edge_hub_mem_optimize(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is IoT Edge Hub memory optimized? Defaults to `true`.
        """
        return pulumi.get(self, "edge_hub_mem_optimize")

    @edge_hub_mem_optimize.setter
    def edge_hub_mem_optimize(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "edge_hub_mem_optimize", value)

    @_builtins.property
    @pulumi.getter(name="edgeLoggingOption")
    def edge_logging_option(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is logging configured for IoT Edge module? Defaults to `true`.
        """
        return pulumi.get(self, "edge_logging_option")

    @edge_logging_option.setter
    def edge_logging_option(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "edge_logging_option", value)

    @_builtins.property
    @pulumi.getter(name="inconsistentModuleSettings")
    def inconsistent_module_settings(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is inconsistent module settings enabled for SecurityGroup? Defaults to `true`.
        """
        return pulumi.get(self, "inconsistent_module_settings")

    @inconsistent_module_settings.setter
    def inconsistent_module_settings(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "inconsistent_module_settings", value)

    @_builtins.property
    @pulumi.getter(name="installAgent")
    def install_agent(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        is Azure IoT Security agent installed? Defaults to `true`.
        """
        return pulumi.get(self, "install_agent")

    @install_agent.setter
    def install_agent(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "install_agent", value)

    @_builtins.property
    @pulumi.getter(name="ipFilterDenyAll")
    def ip_filter_deny_all(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is Default IP filter policy denied? Defaults to `true`.
        """
        return pulumi.get(self, "ip_filter_deny_all")

    @ip_filter_deny_all.setter
    def ip_filter_deny_all(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ip_filter_deny_all", value)

    @_builtins.property
    @pulumi.getter(name="ipFilterPermissiveRule")
    def ip_filter_permissive_rule(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is IP filter rule source allowable IP range too large? Defaults to `true`.
        """
        return pulumi.get(self, "ip_filter_permissive_rule")

    @ip_filter_permissive_rule.setter
    def ip_filter_permissive_rule(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ip_filter_permissive_rule", value)

    @_builtins.property
    @pulumi.getter(name="openPorts")
    def open_ports(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is any ports open on the device? Defaults to `true`.
        """
        return pulumi.get(self, "open_ports")

    @open_ports.setter
    def open_ports(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "open_ports", value)

    @_builtins.property
    @pulumi.getter(name="permissiveFirewallPolicy")
    def permissive_firewall_policy(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Does firewall policy exist which allow necessary communication to/from the device? Defaults to `true`.
        """
        return pulumi.get(self, "permissive_firewall_policy")

    @permissive_firewall_policy.setter
    def permissive_firewall_policy(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "permissive_firewall_policy", value)

    @_builtins.property
    @pulumi.getter(name="permissiveInputFirewallRules")
    def permissive_input_firewall_rules(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is only necessary addresses or ports are permitted in? Defaults to `true`.
        """
        return pulumi.get(self, "permissive_input_firewall_rules")

    @permissive_input_firewall_rules.setter
    def permissive_input_firewall_rules(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "permissive_input_firewall_rules", value)

    @_builtins.property
    @pulumi.getter(name="permissiveOutputFirewallRules")
    def permissive_output_firewall_rules(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is only necessary addresses or ports are permitted out? Defaults to `true`.
        """
        return pulumi.get(self, "permissive_output_firewall_rules")

    @permissive_output_firewall_rules.setter
    def permissive_output_firewall_rules(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "permissive_output_firewall_rules", value)

    @_builtins.property
    @pulumi.getter(name="privilegedDockerOptions")
    def privileged_docker_options(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is high level permissions are needed for the module? Defaults to `true`.
        """
        return pulumi.get(self, "privileged_docker_options")

    @privileged_docker_options.setter
    def privileged_docker_options(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "privileged_docker_options", value)

    @_builtins.property
    @pulumi.getter(name="sharedCredentials")
    def shared_credentials(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is any credentials shared among devices? Defaults to `true`.
        """
        return pulumi.get(self, "shared_credentials")

    @shared_credentials.setter
    def shared_credentials(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "shared_credentials", value)

    @_builtins.property
    @pulumi.getter(name="vulnerableTlsCipherSuite")
    def vulnerable_tls_cipher_suite(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Does TLS cipher suite need to be updated? Defaults to `true`.
        """
        return pulumi.get(self, "vulnerable_tls_cipher_suite")

    @vulnerable_tls_cipher_suite.setter
    def vulnerable_tls_cipher_suite(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "vulnerable_tls_cipher_suite", value)


