# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['OrganizationArgs', 'Organization']

@pulumi.input_type
class OrganizationArgs:
    def __init__(__self__, *,
                 display_name: pulumi.Input[_builtins.str],
                 iotcentral_application_id: pulumi.Input[_builtins.str],
                 organization_id: pulumi.Input[_builtins.str],
                 parent_organization_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a Organization resource.
        :param pulumi.Input[_builtins.str] display_name: Custom `display_name` for the organization.
        :param pulumi.Input[_builtins.str] iotcentral_application_id: The application `id`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] organization_id: The ID of the organization. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] parent_organization_id: The `organization_id` of the parent organization. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "iotcentral_application_id", iotcentral_application_id)
        pulumi.set(__self__, "organization_id", organization_id)
        if parent_organization_id is not None:
            pulumi.set(__self__, "parent_organization_id", parent_organization_id)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[_builtins.str]:
        """
        Custom `display_name` for the organization.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="iotcentralApplicationId")
    def iotcentral_application_id(self) -> pulumi.Input[_builtins.str]:
        """
        The application `id`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iotcentral_application_id")

    @iotcentral_application_id.setter
    def iotcentral_application_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "iotcentral_application_id", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the organization. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="parentOrganizationId")
    def parent_organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `organization_id` of the parent organization. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "parent_organization_id")

    @parent_organization_id.setter
    def parent_organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_organization_id", value)


@pulumi.input_type
class _OrganizationState:
    def __init__(__self__, *,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 iotcentral_application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_organization_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Organization resources.
        :param pulumi.Input[_builtins.str] display_name: Custom `display_name` for the organization.
        :param pulumi.Input[_builtins.str] iotcentral_application_id: The application `id`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] organization_id: The ID of the organization. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] parent_organization_id: The `organization_id` of the parent organization. Changing this forces a new resource to be created.
        """
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if iotcentral_application_id is not None:
            pulumi.set(__self__, "iotcentral_application_id", iotcentral_application_id)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if parent_organization_id is not None:
            pulumi.set(__self__, "parent_organization_id", parent_organization_id)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Custom `display_name` for the organization.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "display_name", value)

    @_builtins.property
    @pulumi.getter(name="iotcentralApplicationId")
    def iotcentral_application_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The application `id`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iotcentral_application_id")

    @iotcentral_application_id.setter
    def iotcentral_application_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "iotcentral_application_id", value)

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the organization. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "organization_id", value)

    @_builtins.property
    @pulumi.getter(name="parentOrganizationId")
    def parent_organization_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The `organization_id` of the parent organization. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "parent_organization_id")

    @parent_organization_id.setter
    def parent_organization_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "parent_organization_id", value)


@pulumi.type_token("azure:iotcentral/organization:Organization")
class Organization(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 iotcentral_application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages an IoT Central Organization

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resource",
            location="West Europe")
        example_application = azure.iotcentral.Application("example",
            name="example-iotcentral-app",
            resource_group_name=example.name,
            location=example.location,
            sub_domain="example-iotcentral-app-subdomain",
            display_name="example-iotcentral-app-display-name",
            sku="ST1",
            template="iotc-default@1.0.0",
            tags={
                "Foo": "Bar",
            })
        example_parent = azure.iotcentral.Organization("example_parent",
            iotcentral_application_id=example_application.id,
            organization_id="example-parent-organization-id",
            display_name="Org example parent")
        example_organization = azure.iotcentral.Organization("example",
            iotcentral_application_id=example_application.id,
            organization_id="example-child-organization-id",
            display_name="Org example",
            parent_organization_id=example_parent.organization_id)
        ```

        ## Import

        The IoT Central Organization can be imported using the `id`, e.g.

        ```sh
        $ pulumi import azure:iotcentral/organization:Organization example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.IoTCentral/iotApps/example/organizations/example
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: Custom `display_name` for the organization.
        :param pulumi.Input[_builtins.str] iotcentral_application_id: The application `id`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] organization_id: The ID of the organization. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] parent_organization_id: The `organization_id` of the parent organization. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OrganizationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an IoT Central Organization

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resource",
            location="West Europe")
        example_application = azure.iotcentral.Application("example",
            name="example-iotcentral-app",
            resource_group_name=example.name,
            location=example.location,
            sub_domain="example-iotcentral-app-subdomain",
            display_name="example-iotcentral-app-display-name",
            sku="ST1",
            template="iotc-default@1.0.0",
            tags={
                "Foo": "Bar",
            })
        example_parent = azure.iotcentral.Organization("example_parent",
            iotcentral_application_id=example_application.id,
            organization_id="example-parent-organization-id",
            display_name="Org example parent")
        example_organization = azure.iotcentral.Organization("example",
            iotcentral_application_id=example_application.id,
            organization_id="example-child-organization-id",
            display_name="Org example",
            parent_organization_id=example_parent.organization_id)
        ```

        ## Import

        The IoT Central Organization can be imported using the `id`, e.g.

        ```sh
        $ pulumi import azure:iotcentral/organization:Organization example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.IoTCentral/iotApps/example/organizations/example
        ```

        :param str resource_name: The name of the resource.
        :param OrganizationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OrganizationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[_builtins.str]] = None,
                 iotcentral_application_id: Optional[pulumi.Input[_builtins.str]] = None,
                 organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 parent_organization_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OrganizationArgs.__new__(OrganizationArgs)

            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            if iotcentral_application_id is None and not opts.urn:
                raise TypeError("Missing required property 'iotcentral_application_id'")
            __props__.__dict__["iotcentral_application_id"] = iotcentral_application_id
            if organization_id is None and not opts.urn:
                raise TypeError("Missing required property 'organization_id'")
            __props__.__dict__["organization_id"] = organization_id
            __props__.__dict__["parent_organization_id"] = parent_organization_id
        super(Organization, __self__).__init__(
            'azure:iotcentral/organization:Organization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            display_name: Optional[pulumi.Input[_builtins.str]] = None,
            iotcentral_application_id: Optional[pulumi.Input[_builtins.str]] = None,
            organization_id: Optional[pulumi.Input[_builtins.str]] = None,
            parent_organization_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Organization':
        """
        Get an existing Organization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] display_name: Custom `display_name` for the organization.
        :param pulumi.Input[_builtins.str] iotcentral_application_id: The application `id`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] organization_id: The ID of the organization. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] parent_organization_id: The `organization_id` of the parent organization. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OrganizationState.__new__(_OrganizationState)

        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["iotcentral_application_id"] = iotcentral_application_id
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["parent_organization_id"] = parent_organization_id
        return Organization(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[_builtins.str]:
        """
        Custom `display_name` for the organization.
        """
        return pulumi.get(self, "display_name")

    @_builtins.property
    @pulumi.getter(name="iotcentralApplicationId")
    def iotcentral_application_id(self) -> pulumi.Output[_builtins.str]:
        """
        The application `id`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "iotcentral_application_id")

    @_builtins.property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the organization. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "organization_id")

    @_builtins.property
    @pulumi.getter(name="parentOrganizationId")
    def parent_organization_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The `organization_id` of the parent organization. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "parent_organization_id")

