# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AttachedDatabaseConfigurationArgs', 'AttachedDatabaseConfiguration']

@pulumi.input_type
class AttachedDatabaseConfigurationArgs:
    def __init__(__self__, *,
                 cluster_name: pulumi.Input[_builtins.str],
                 database_name: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_principal_modification_kind: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 sharing: Optional[pulumi.Input['AttachedDatabaseConfigurationSharingArgs']] = None):
        """
        The set of arguments for constructing a AttachedDatabaseConfiguration resource.
        :param pulumi.Input[_builtins.str] cluster_name: Specifies the name of the Kusto Cluster for which the configuration will be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] database_name: The name of the database which you would like to attach, use * if you want to follow all current and future databases. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the resource group of the Kusto Cluster for which the configuration will be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] cluster_id: The resource id of the cluster where the databases you would like to attach reside. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] default_principal_modification_kind: The default principals modification kind. Valid values are: `None` (default), `Replace` and `Union`. Defaults to `None`.
        :param pulumi.Input[_builtins.str] location: Specifies the location of the Kusto Cluster for which the configuration will be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Kusto Attached Database Configuration to create. Changing this forces a new resource to be created.
        :param pulumi.Input['AttachedDatabaseConfigurationSharingArgs'] sharing: A `sharing` block as defined below.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "database_name", database_name)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_resource_id is not None:
            warnings.warn("""`cluster_resource_id` has been deprecated in favour of the `cluster_id` property and will be removed in v5.0 of the AzureRM Provider.""", DeprecationWarning)
            pulumi.log.warn("""cluster_resource_id is deprecated: `cluster_resource_id` has been deprecated in favour of the `cluster_id` property and will be removed in v5.0 of the AzureRM Provider.""")
        if cluster_resource_id is not None:
            pulumi.set(__self__, "cluster_resource_id", cluster_resource_id)
        if default_principal_modification_kind is not None:
            pulumi.set(__self__, "default_principal_modification_kind", default_principal_modification_kind)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if sharing is not None:
            pulumi.set(__self__, "sharing", sharing)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Kusto Cluster for which the configuration will be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the database which you would like to attach, use * if you want to follow all current and future databases. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the resource group of the Kusto Cluster for which the configuration will be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource id of the cluster where the databases you would like to attach reside. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterResourceId")
    @_utilities.deprecated("""`cluster_resource_id` has been deprecated in favour of the `cluster_id` property and will be removed in v5.0 of the AzureRM Provider.""")
    def cluster_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cluster_resource_id")

    @cluster_resource_id.setter
    def cluster_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultPrincipalModificationKind")
    def default_principal_modification_kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default principals modification kind. Valid values are: `None` (default), `Replace` and `Union`. Defaults to `None`.
        """
        return pulumi.get(self, "default_principal_modification_kind")

    @default_principal_modification_kind.setter
    def default_principal_modification_kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_principal_modification_kind", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the location of the Kusto Cluster for which the configuration will be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Kusto Attached Database Configuration to create. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def sharing(self) -> Optional[pulumi.Input['AttachedDatabaseConfigurationSharingArgs']]:
        """
        A `sharing` block as defined below.
        """
        return pulumi.get(self, "sharing")

    @sharing.setter
    def sharing(self, value: Optional[pulumi.Input['AttachedDatabaseConfigurationSharingArgs']]):
        pulumi.set(self, "sharing", value)


@pulumi.input_type
class _AttachedDatabaseConfigurationState:
    def __init__(__self__, *,
                 attached_database_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 default_principal_modification_kind: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sharing: Optional[pulumi.Input['AttachedDatabaseConfigurationSharingArgs']] = None):
        """
        Input properties used for looking up and filtering AttachedDatabaseConfiguration resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] attached_database_names: The list of databases from the `cluster_resource_id` which are currently attached to the cluster.
        :param pulumi.Input[_builtins.str] cluster_id: The resource id of the cluster where the databases you would like to attach reside. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] cluster_name: Specifies the name of the Kusto Cluster for which the configuration will be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] database_name: The name of the database which you would like to attach, use * if you want to follow all current and future databases. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] default_principal_modification_kind: The default principals modification kind. Valid values are: `None` (default), `Replace` and `Union`. Defaults to `None`.
        :param pulumi.Input[_builtins.str] location: Specifies the location of the Kusto Cluster for which the configuration will be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Kusto Attached Database Configuration to create. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the resource group of the Kusto Cluster for which the configuration will be created. Changing this forces a new resource to be created.
        :param pulumi.Input['AttachedDatabaseConfigurationSharingArgs'] sharing: A `sharing` block as defined below.
        """
        if attached_database_names is not None:
            pulumi.set(__self__, "attached_database_names", attached_database_names)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if cluster_resource_id is not None:
            warnings.warn("""`cluster_resource_id` has been deprecated in favour of the `cluster_id` property and will be removed in v5.0 of the AzureRM Provider.""", DeprecationWarning)
            pulumi.log.warn("""cluster_resource_id is deprecated: `cluster_resource_id` has been deprecated in favour of the `cluster_id` property and will be removed in v5.0 of the AzureRM Provider.""")
        if cluster_resource_id is not None:
            pulumi.set(__self__, "cluster_resource_id", cluster_resource_id)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if default_principal_modification_kind is not None:
            pulumi.set(__self__, "default_principal_modification_kind", default_principal_modification_kind)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sharing is not None:
            pulumi.set(__self__, "sharing", sharing)

    @_builtins.property
    @pulumi.getter(name="attachedDatabaseNames")
    def attached_database_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The list of databases from the `cluster_resource_id` which are currently attached to the cluster.
        """
        return pulumi.get(self, "attached_database_names")

    @attached_database_names.setter
    def attached_database_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "attached_database_names", value)

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource id of the cluster where the databases you would like to attach reside. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_id", value)

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Kusto Cluster for which the configuration will be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_name", value)

    @_builtins.property
    @pulumi.getter(name="clusterResourceId")
    @_utilities.deprecated("""`cluster_resource_id` has been deprecated in favour of the `cluster_id` property and will be removed in v5.0 of the AzureRM Provider.""")
    def cluster_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "cluster_resource_id")

    @cluster_resource_id.setter
    def cluster_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "cluster_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the database which you would like to attach, use * if you want to follow all current and future databases. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "database_name", value)

    @_builtins.property
    @pulumi.getter(name="defaultPrincipalModificationKind")
    def default_principal_modification_kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default principals modification kind. Valid values are: `None` (default), `Replace` and `Union`. Defaults to `None`.
        """
        return pulumi.get(self, "default_principal_modification_kind")

    @default_principal_modification_kind.setter
    def default_principal_modification_kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_principal_modification_kind", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the location of the Kusto Cluster for which the configuration will be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Kusto Attached Database Configuration to create. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the resource group of the Kusto Cluster for which the configuration will be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sharing(self) -> Optional[pulumi.Input['AttachedDatabaseConfigurationSharingArgs']]:
        """
        A `sharing` block as defined below.
        """
        return pulumi.get(self, "sharing")

    @sharing.setter
    def sharing(self, value: Optional[pulumi.Input['AttachedDatabaseConfigurationSharingArgs']]):
        pulumi.set(self, "sharing", value)


@pulumi.type_token("azure:kusto/attachedDatabaseConfiguration:AttachedDatabaseConfiguration")
class AttachedDatabaseConfiguration(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 default_principal_modification_kind: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sharing: Optional[pulumi.Input[Union['AttachedDatabaseConfigurationSharingArgs', 'AttachedDatabaseConfigurationSharingArgsDict']]] = None,
                 __props__=None):
        """
        Manages a Kusto (also known as Azure Data Explorer) Attached Database Configuration

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="my-kusto-rg",
            location="West Europe")
        follower_cluster = azure.kusto.Cluster("follower_cluster",
            name="cluster1",
            location=example.location,
            resource_group_name=example.name,
            sku={
                "name": "Dev(No SLA)_Standard_D11_v2",
                "capacity": 1,
            })
        followed_cluster = azure.kusto.Cluster("followed_cluster",
            name="cluster2",
            location=example.location,
            resource_group_name=example.name,
            sku={
                "name": "Dev(No SLA)_Standard_D11_v2",
                "capacity": 1,
            })
        followed_database = azure.kusto.Database("followed_database",
            name="my-followed-database",
            resource_group_name=example.name,
            location=example.location,
            cluster_name=follower_cluster.name)
        example_database = azure.kusto.Database("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            cluster_name=follower_cluster.name)
        example_attached_database_configuration = azure.kusto.AttachedDatabaseConfiguration("example",
            name="configuration1",
            resource_group_name=example.name,
            location=example.location,
            cluster_name=follower_cluster.name,
            cluster_resource_id=followed_cluster.id,
            database_name=example_database.name,
            sharing={
                "external_tables_to_excludes": ["ExternalTable2"],
                "external_tables_to_includes": ["ExternalTable1"],
                "materialized_views_to_excludes": ["MaterializedViewTable2"],
                "materialized_views_to_includes": ["MaterializedViewTable1"],
                "tables_to_excludes": ["Table2"],
                "tables_to_includes": ["Table1"],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Kusto` - 2024-04-13

        ## Import

        Kusto Attached Database Configurations can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:kusto/attachedDatabaseConfiguration:AttachedDatabaseConfiguration example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Kusto/clusters/cluster1/attachedDatabaseConfigurations/configuration1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] cluster_id: The resource id of the cluster where the databases you would like to attach reside. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] cluster_name: Specifies the name of the Kusto Cluster for which the configuration will be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] database_name: The name of the database which you would like to attach, use * if you want to follow all current and future databases. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] default_principal_modification_kind: The default principals modification kind. Valid values are: `None` (default), `Replace` and `Union`. Defaults to `None`.
        :param pulumi.Input[_builtins.str] location: Specifies the location of the Kusto Cluster for which the configuration will be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Kusto Attached Database Configuration to create. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the resource group of the Kusto Cluster for which the configuration will be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['AttachedDatabaseConfigurationSharingArgs', 'AttachedDatabaseConfigurationSharingArgsDict']] sharing: A `sharing` block as defined below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AttachedDatabaseConfigurationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Kusto (also known as Azure Data Explorer) Attached Database Configuration

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="my-kusto-rg",
            location="West Europe")
        follower_cluster = azure.kusto.Cluster("follower_cluster",
            name="cluster1",
            location=example.location,
            resource_group_name=example.name,
            sku={
                "name": "Dev(No SLA)_Standard_D11_v2",
                "capacity": 1,
            })
        followed_cluster = azure.kusto.Cluster("followed_cluster",
            name="cluster2",
            location=example.location,
            resource_group_name=example.name,
            sku={
                "name": "Dev(No SLA)_Standard_D11_v2",
                "capacity": 1,
            })
        followed_database = azure.kusto.Database("followed_database",
            name="my-followed-database",
            resource_group_name=example.name,
            location=example.location,
            cluster_name=follower_cluster.name)
        example_database = azure.kusto.Database("example",
            name="example",
            resource_group_name=example.name,
            location=example.location,
            cluster_name=follower_cluster.name)
        example_attached_database_configuration = azure.kusto.AttachedDatabaseConfiguration("example",
            name="configuration1",
            resource_group_name=example.name,
            location=example.location,
            cluster_name=follower_cluster.name,
            cluster_resource_id=followed_cluster.id,
            database_name=example_database.name,
            sharing={
                "external_tables_to_excludes": ["ExternalTable2"],
                "external_tables_to_includes": ["ExternalTable1"],
                "materialized_views_to_excludes": ["MaterializedViewTable2"],
                "materialized_views_to_includes": ["MaterializedViewTable1"],
                "tables_to_excludes": ["Table2"],
                "tables_to_includes": ["Table1"],
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Kusto` - 2024-04-13

        ## Import

        Kusto Attached Database Configurations can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:kusto/attachedDatabaseConfiguration:AttachedDatabaseConfiguration example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Kusto/clusters/cluster1/attachedDatabaseConfigurations/configuration1
        ```

        :param str resource_name: The name of the resource.
        :param AttachedDatabaseConfigurationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AttachedDatabaseConfigurationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
                 cluster_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 database_name: Optional[pulumi.Input[_builtins.str]] = None,
                 default_principal_modification_kind: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sharing: Optional[pulumi.Input[Union['AttachedDatabaseConfigurationSharingArgs', 'AttachedDatabaseConfigurationSharingArgsDict']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AttachedDatabaseConfigurationArgs.__new__(AttachedDatabaseConfigurationArgs)

            __props__.__dict__["cluster_id"] = cluster_id
            if cluster_name is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_name'")
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["cluster_resource_id"] = cluster_resource_id
            if database_name is None and not opts.urn:
                raise TypeError("Missing required property 'database_name'")
            __props__.__dict__["database_name"] = database_name
            __props__.__dict__["default_principal_modification_kind"] = default_principal_modification_kind
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["sharing"] = sharing
            __props__.__dict__["attached_database_names"] = None
        super(AttachedDatabaseConfiguration, __self__).__init__(
            'azure:kusto/attachedDatabaseConfiguration:AttachedDatabaseConfiguration',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            attached_database_names: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            cluster_id: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_name: Optional[pulumi.Input[_builtins.str]] = None,
            cluster_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            database_name: Optional[pulumi.Input[_builtins.str]] = None,
            default_principal_modification_kind: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            sharing: Optional[pulumi.Input[Union['AttachedDatabaseConfigurationSharingArgs', 'AttachedDatabaseConfigurationSharingArgsDict']]] = None) -> 'AttachedDatabaseConfiguration':
        """
        Get an existing AttachedDatabaseConfiguration resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] attached_database_names: The list of databases from the `cluster_resource_id` which are currently attached to the cluster.
        :param pulumi.Input[_builtins.str] cluster_id: The resource id of the cluster where the databases you would like to attach reside. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] cluster_name: Specifies the name of the Kusto Cluster for which the configuration will be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] database_name: The name of the database which you would like to attach, use * if you want to follow all current and future databases. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] default_principal_modification_kind: The default principals modification kind. Valid values are: `None` (default), `Replace` and `Union`. Defaults to `None`.
        :param pulumi.Input[_builtins.str] location: Specifies the location of the Kusto Cluster for which the configuration will be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Kusto Attached Database Configuration to create. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the resource group of the Kusto Cluster for which the configuration will be created. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['AttachedDatabaseConfigurationSharingArgs', 'AttachedDatabaseConfigurationSharingArgsDict']] sharing: A `sharing` block as defined below.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AttachedDatabaseConfigurationState.__new__(_AttachedDatabaseConfigurationState)

        __props__.__dict__["attached_database_names"] = attached_database_names
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["cluster_resource_id"] = cluster_resource_id
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["default_principal_modification_kind"] = default_principal_modification_kind
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sharing"] = sharing
        return AttachedDatabaseConfiguration(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="attachedDatabaseNames")
    def attached_database_names(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The list of databases from the `cluster_resource_id` which are currently attached to the cluster.
        """
        return pulumi.get(self, "attached_database_names")

    @_builtins.property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource id of the cluster where the databases you would like to attach reside. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_id")

    @_builtins.property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Kusto Cluster for which the configuration will be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "cluster_name")

    @_builtins.property
    @pulumi.getter(name="clusterResourceId")
    @_utilities.deprecated("""`cluster_resource_id` has been deprecated in favour of the `cluster_id` property and will be removed in v5.0 of the AzureRM Provider.""")
    def cluster_resource_id(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "cluster_resource_id")

    @_builtins.property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the database which you would like to attach, use * if you want to follow all current and future databases. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "database_name")

    @_builtins.property
    @pulumi.getter(name="defaultPrincipalModificationKind")
    def default_principal_modification_kind(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The default principals modification kind. Valid values are: `None` (default), `Replace` and `Union`. Defaults to `None`.
        """
        return pulumi.get(self, "default_principal_modification_kind")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the location of the Kusto Cluster for which the configuration will be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Kusto Attached Database Configuration to create. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the resource group of the Kusto Cluster for which the configuration will be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def sharing(self) -> pulumi.Output[Optional['outputs.AttachedDatabaseConfigurationSharing']]:
        """
        A `sharing` block as defined below.
        """
        return pulumi.get(self, "sharing")

