# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetLBResult',
    'AwaitableGetLBResult',
    'get_lb',
    'get_lb_output',
]

@pulumi.output_type
class GetLBResult:
    """
    A collection of values returned by getLB.
    """
    def __init__(__self__, frontend_ip_configurations=None, id=None, location=None, name=None, private_ip_address=None, private_ip_addresses=None, resource_group_name=None, sku=None, tags=None):
        if frontend_ip_configurations and not isinstance(frontend_ip_configurations, list):
            raise TypeError("Expected argument 'frontend_ip_configurations' to be a list")
        pulumi.set(__self__, "frontend_ip_configurations", frontend_ip_configurations)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if private_ip_address and not isinstance(private_ip_address, str):
            raise TypeError("Expected argument 'private_ip_address' to be a str")
        pulumi.set(__self__, "private_ip_address", private_ip_address)
        if private_ip_addresses and not isinstance(private_ip_addresses, list):
            raise TypeError("Expected argument 'private_ip_addresses' to be a list")
        pulumi.set(__self__, "private_ip_addresses", private_ip_addresses)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku and not isinstance(sku, str):
            raise TypeError("Expected argument 'sku' to be a str")
        pulumi.set(__self__, "sku", sku)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="frontendIpConfigurations")
    def frontend_ip_configurations(self) -> Sequence['outputs.GetLBFrontendIpConfigurationResult']:
        """
        A `frontend_ip_configuration` block as documented below.
        """
        return pulumi.get(self, "frontend_ip_configurations")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure location where the Load Balancer exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Frontend IP Configuration.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="privateIpAddress")
    def private_ip_address(self) -> _builtins.str:
        """
        Private IP Address to assign to the Load Balancer.
        """
        return pulumi.get(self, "private_ip_address")

    @_builtins.property
    @pulumi.getter(name="privateIpAddresses")
    def private_ip_addresses(self) -> Sequence[_builtins.str]:
        """
        The list of private IP address assigned to the load balancer in `frontend_ip_configuration` blocks, if any.
        """
        return pulumi.get(self, "private_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> _builtins.str:
        """
        The SKU of the Load Balancer.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the resource.
        """
        return pulumi.get(self, "tags")


class AwaitableGetLBResult(GetLBResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetLBResult(
            frontend_ip_configurations=self.frontend_ip_configurations,
            id=self.id,
            location=self.location,
            name=self.name,
            private_ip_address=self.private_ip_address,
            private_ip_addresses=self.private_ip_addresses,
            resource_group_name=self.resource_group_name,
            sku=self.sku,
            tags=self.tags)


def get_lb(name: Optional[_builtins.str] = None,
           resource_group_name: Optional[_builtins.str] = None,
           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetLBResult:
    """
    Use this data source to access information about an existing Load Balancer

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.lb.get_lb(name="example-lb",
        resource_group_name="example-resources")
    pulumi.export("loadbalancerId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2023-09-01


    :param _builtins.str name: Specifies the name of the Load Balancer.
    :param _builtins.str resource_group_name: The name of the Resource Group in which the Load Balancer exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:lb/getLB:getLB', __args__, opts=opts, typ=GetLBResult).value

    return AwaitableGetLBResult(
        frontend_ip_configurations=pulumi.get(__ret__, 'frontend_ip_configurations'),
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        private_ip_address=pulumi.get(__ret__, 'private_ip_address'),
        private_ip_addresses=pulumi.get(__ret__, 'private_ip_addresses'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        sku=pulumi.get(__ret__, 'sku'),
        tags=pulumi.get(__ret__, 'tags'))
def get_lb_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                  resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetLBResult]:
    """
    Use this data source to access information about an existing Load Balancer

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.lb.get_lb(name="example-lb",
        resource_group_name="example-resources")
    pulumi.export("loadbalancerId", example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2023-09-01


    :param _builtins.str name: Specifies the name of the Load Balancer.
    :param _builtins.str resource_group_name: The name of the Resource Group in which the Load Balancer exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:lb/getLB:getLB', __args__, opts=opts, typ=GetLBResult)
    return __ret__.apply(lambda __response__: GetLBResult(
        frontend_ip_configurations=pulumi.get(__response__, 'frontend_ip_configurations'),
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        private_ip_address=pulumi.get(__response__, 'private_ip_address'),
        private_ip_addresses=pulumi.get(__response__, 'private_ip_addresses'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        sku=pulumi.get(__response__, 'sku'),
        tags=pulumi.get(__response__, 'tags')))
