# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['OutboundRuleArgs', 'OutboundRule']

@pulumi.input_type
class OutboundRuleArgs:
    def __init__(__self__, *,
                 backend_address_pool_id: pulumi.Input[_builtins.str],
                 loadbalancer_id: pulumi.Input[_builtins.str],
                 protocol: pulumi.Input[_builtins.str],
                 allocated_outbound_ports: Optional[pulumi.Input[_builtins.int]] = None,
                 enable_tcp_reset: Optional[pulumi.Input[_builtins.bool]] = None,
                 frontend_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['OutboundRuleFrontendIpConfigurationArgs']]]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a OutboundRule resource.
        :param pulumi.Input[_builtins.str] backend_address_pool_id: The ID of the Backend Address Pool. Outbound traffic is randomly load balanced across IPs in the backend IPs.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The ID of the Load Balancer in which to create the Outbound Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] protocol: The transport protocol for the external endpoint. Possible values are `Udp`, `Tcp` or `All`.
        :param pulumi.Input[_builtins.int] allocated_outbound_ports: The number of outbound ports to be used for NAT. Defaults to `1024`.
        :param pulumi.Input[_builtins.bool] enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        :param pulumi.Input[Sequence[pulumi.Input['OutboundRuleFrontendIpConfigurationArgs']]] frontend_ip_configurations: One or more `frontend_ip_configuration` blocks as defined below.
        :param pulumi.Input[_builtins.int] idle_timeout_in_minutes: The timeout for the TCP idle connection Defaults to `4`.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Outbound Rule. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "backend_address_pool_id", backend_address_pool_id)
        pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        pulumi.set(__self__, "protocol", protocol)
        if allocated_outbound_ports is not None:
            pulumi.set(__self__, "allocated_outbound_ports", allocated_outbound_ports)
        if enable_tcp_reset is not None:
            pulumi.set(__self__, "enable_tcp_reset", enable_tcp_reset)
        if frontend_ip_configurations is not None:
            pulumi.set(__self__, "frontend_ip_configurations", frontend_ip_configurations)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="backendAddressPoolId")
    def backend_address_pool_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Backend Address Pool. Outbound traffic is randomly load balanced across IPs in the backend IPs.
        """
        return pulumi.get(self, "backend_address_pool_id")

    @backend_address_pool_id.setter
    def backend_address_pool_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backend_address_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Load Balancer in which to create the Outbound Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "loadbalancer_id")

    @loadbalancer_id.setter
    def loadbalancer_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "loadbalancer_id", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[_builtins.str]:
        """
        The transport protocol for the external endpoint. Possible values are `Udp`, `Tcp` or `All`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "protocol", value)

    @_builtins.property
    @pulumi.getter(name="allocatedOutboundPorts")
    def allocated_outbound_ports(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of outbound ports to be used for NAT. Defaults to `1024`.
        """
        return pulumi.get(self, "allocated_outbound_ports")

    @allocated_outbound_ports.setter
    def allocated_outbound_ports(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "allocated_outbound_ports", value)

    @_builtins.property
    @pulumi.getter(name="enableTcpReset")
    def enable_tcp_reset(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        """
        return pulumi.get(self, "enable_tcp_reset")

    @enable_tcp_reset.setter
    def enable_tcp_reset(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_tcp_reset", value)

    @_builtins.property
    @pulumi.getter(name="frontendIpConfigurations")
    def frontend_ip_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OutboundRuleFrontendIpConfigurationArgs']]]]:
        """
        One or more `frontend_ip_configuration` blocks as defined below.
        """
        return pulumi.get(self, "frontend_ip_configurations")

    @frontend_ip_configurations.setter
    def frontend_ip_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OutboundRuleFrontendIpConfigurationArgs']]]]):
        pulumi.set(self, "frontend_ip_configurations", value)

    @_builtins.property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout for the TCP idle connection Defaults to `4`.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @idle_timeout_in_minutes.setter
    def idle_timeout_in_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "idle_timeout_in_minutes", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Outbound Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _OutboundRuleState:
    def __init__(__self__, *,
                 allocated_outbound_ports: Optional[pulumi.Input[_builtins.int]] = None,
                 backend_address_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_tcp_reset: Optional[pulumi.Input[_builtins.bool]] = None,
                 frontend_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input['OutboundRuleFrontendIpConfigurationArgs']]]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering OutboundRule resources.
        :param pulumi.Input[_builtins.int] allocated_outbound_ports: The number of outbound ports to be used for NAT. Defaults to `1024`.
        :param pulumi.Input[_builtins.str] backend_address_pool_id: The ID of the Backend Address Pool. Outbound traffic is randomly load balanced across IPs in the backend IPs.
        :param pulumi.Input[_builtins.bool] enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        :param pulumi.Input[Sequence[pulumi.Input['OutboundRuleFrontendIpConfigurationArgs']]] frontend_ip_configurations: One or more `frontend_ip_configuration` blocks as defined below.
        :param pulumi.Input[_builtins.int] idle_timeout_in_minutes: The timeout for the TCP idle connection Defaults to `4`.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The ID of the Load Balancer in which to create the Outbound Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Outbound Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] protocol: The transport protocol for the external endpoint. Possible values are `Udp`, `Tcp` or `All`.
        """
        if allocated_outbound_ports is not None:
            pulumi.set(__self__, "allocated_outbound_ports", allocated_outbound_ports)
        if backend_address_pool_id is not None:
            pulumi.set(__self__, "backend_address_pool_id", backend_address_pool_id)
        if enable_tcp_reset is not None:
            pulumi.set(__self__, "enable_tcp_reset", enable_tcp_reset)
        if frontend_ip_configurations is not None:
            pulumi.set(__self__, "frontend_ip_configurations", frontend_ip_configurations)
        if idle_timeout_in_minutes is not None:
            pulumi.set(__self__, "idle_timeout_in_minutes", idle_timeout_in_minutes)
        if loadbalancer_id is not None:
            pulumi.set(__self__, "loadbalancer_id", loadbalancer_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if protocol is not None:
            pulumi.set(__self__, "protocol", protocol)

    @_builtins.property
    @pulumi.getter(name="allocatedOutboundPorts")
    def allocated_outbound_ports(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of outbound ports to be used for NAT. Defaults to `1024`.
        """
        return pulumi.get(self, "allocated_outbound_ports")

    @allocated_outbound_ports.setter
    def allocated_outbound_ports(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "allocated_outbound_ports", value)

    @_builtins.property
    @pulumi.getter(name="backendAddressPoolId")
    def backend_address_pool_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Backend Address Pool. Outbound traffic is randomly load balanced across IPs in the backend IPs.
        """
        return pulumi.get(self, "backend_address_pool_id")

    @backend_address_pool_id.setter
    def backend_address_pool_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backend_address_pool_id", value)

    @_builtins.property
    @pulumi.getter(name="enableTcpReset")
    def enable_tcp_reset(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        """
        return pulumi.get(self, "enable_tcp_reset")

    @enable_tcp_reset.setter
    def enable_tcp_reset(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enable_tcp_reset", value)

    @_builtins.property
    @pulumi.getter(name="frontendIpConfigurations")
    def frontend_ip_configurations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['OutboundRuleFrontendIpConfigurationArgs']]]]:
        """
        One or more `frontend_ip_configuration` blocks as defined below.
        """
        return pulumi.get(self, "frontend_ip_configurations")

    @frontend_ip_configurations.setter
    def frontend_ip_configurations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['OutboundRuleFrontendIpConfigurationArgs']]]]):
        pulumi.set(self, "frontend_ip_configurations", value)

    @_builtins.property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The timeout for the TCP idle connection Defaults to `4`.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @idle_timeout_in_minutes.setter
    def idle_timeout_in_minutes(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "idle_timeout_in_minutes", value)

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Load Balancer in which to create the Outbound Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "loadbalancer_id")

    @loadbalancer_id.setter
    def loadbalancer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "loadbalancer_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Outbound Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The transport protocol for the external endpoint. Possible values are `Udp`, `Tcp` or `All`.
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "protocol", value)


@pulumi.type_token("azure:lb/outboundRule:OutboundRule")
class OutboundRule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocated_outbound_ports: Optional[pulumi.Input[_builtins.int]] = None,
                 backend_address_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_tcp_reset: Optional[pulumi.Input[_builtins.bool]] = None,
                 frontend_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OutboundRuleFrontendIpConfigurationArgs', 'OutboundRuleFrontendIpConfigurationArgsDict']]]]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Load Balancer Outbound Rule.

        > **Note:** When using this resource, the Load Balancer needs to have a FrontEnd IP Configuration and a Backend Address Pool Attached.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="LoadBalancerRG",
            location="West Europe")
        example_public_ip = azure.network.PublicIp("example",
            name="PublicIPForLB",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static")
        example_load_balancer = azure.lb.LoadBalancer("example",
            name="TestLoadBalancer",
            location=example.location,
            resource_group_name=example.name,
            frontend_ip_configurations=[{
                "name": "PublicIPAddress",
                "public_ip_address_id": example_public_ip.id,
            }])
        example_backend_address_pool = azure.lb.BackendAddressPool("example",
            name="example",
            loadbalancer_id=example_load_balancer.id)
        example_outbound_rule = azure.lb.OutboundRule("example",
            name="OutboundRule",
            loadbalancer_id=example_load_balancer.id,
            protocol="Tcp",
            backend_address_pool_id=example_backend_address_pool.id,
            frontend_ip_configurations=[{
                "name": "PublicIPAddress",
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2023-09-01

        ## Import

        Load Balancer Outbound Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:lb/outboundRule:OutboundRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/loadBalancers/lb1/outboundRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] allocated_outbound_ports: The number of outbound ports to be used for NAT. Defaults to `1024`.
        :param pulumi.Input[_builtins.str] backend_address_pool_id: The ID of the Backend Address Pool. Outbound traffic is randomly load balanced across IPs in the backend IPs.
        :param pulumi.Input[_builtins.bool] enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OutboundRuleFrontendIpConfigurationArgs', 'OutboundRuleFrontendIpConfigurationArgsDict']]]] frontend_ip_configurations: One or more `frontend_ip_configuration` blocks as defined below.
        :param pulumi.Input[_builtins.int] idle_timeout_in_minutes: The timeout for the TCP idle connection Defaults to `4`.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The ID of the Load Balancer in which to create the Outbound Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Outbound Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] protocol: The transport protocol for the external endpoint. Possible values are `Udp`, `Tcp` or `All`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OutboundRuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Load Balancer Outbound Rule.

        > **Note:** When using this resource, the Load Balancer needs to have a FrontEnd IP Configuration and a Backend Address Pool Attached.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="LoadBalancerRG",
            location="West Europe")
        example_public_ip = azure.network.PublicIp("example",
            name="PublicIPForLB",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static")
        example_load_balancer = azure.lb.LoadBalancer("example",
            name="TestLoadBalancer",
            location=example.location,
            resource_group_name=example.name,
            frontend_ip_configurations=[{
                "name": "PublicIPAddress",
                "public_ip_address_id": example_public_ip.id,
            }])
        example_backend_address_pool = azure.lb.BackendAddressPool("example",
            name="example",
            loadbalancer_id=example_load_balancer.id)
        example_outbound_rule = azure.lb.OutboundRule("example",
            name="OutboundRule",
            loadbalancer_id=example_load_balancer.id,
            protocol="Tcp",
            backend_address_pool_id=example_backend_address_pool.id,
            frontend_ip_configurations=[{
                "name": "PublicIPAddress",
            }])
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2023-09-01

        ## Import

        Load Balancer Outbound Rules can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:lb/outboundRule:OutboundRule example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/loadBalancers/lb1/outboundRules/rule1
        ```

        :param str resource_name: The name of the resource.
        :param OutboundRuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OutboundRuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allocated_outbound_ports: Optional[pulumi.Input[_builtins.int]] = None,
                 backend_address_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
                 enable_tcp_reset: Optional[pulumi.Input[_builtins.bool]] = None,
                 frontend_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OutboundRuleFrontendIpConfigurationArgs', 'OutboundRuleFrontendIpConfigurationArgsDict']]]]] = None,
                 idle_timeout_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
                 loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 protocol: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OutboundRuleArgs.__new__(OutboundRuleArgs)

            __props__.__dict__["allocated_outbound_ports"] = allocated_outbound_ports
            if backend_address_pool_id is None and not opts.urn:
                raise TypeError("Missing required property 'backend_address_pool_id'")
            __props__.__dict__["backend_address_pool_id"] = backend_address_pool_id
            __props__.__dict__["enable_tcp_reset"] = enable_tcp_reset
            __props__.__dict__["frontend_ip_configurations"] = frontend_ip_configurations
            __props__.__dict__["idle_timeout_in_minutes"] = idle_timeout_in_minutes
            if loadbalancer_id is None and not opts.urn:
                raise TypeError("Missing required property 'loadbalancer_id'")
            __props__.__dict__["loadbalancer_id"] = loadbalancer_id
            __props__.__dict__["name"] = name
            if protocol is None and not opts.urn:
                raise TypeError("Missing required property 'protocol'")
            __props__.__dict__["protocol"] = protocol
        super(OutboundRule, __self__).__init__(
            'azure:lb/outboundRule:OutboundRule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocated_outbound_ports: Optional[pulumi.Input[_builtins.int]] = None,
            backend_address_pool_id: Optional[pulumi.Input[_builtins.str]] = None,
            enable_tcp_reset: Optional[pulumi.Input[_builtins.bool]] = None,
            frontend_ip_configurations: Optional[pulumi.Input[Sequence[pulumi.Input[Union['OutboundRuleFrontendIpConfigurationArgs', 'OutboundRuleFrontendIpConfigurationArgsDict']]]]] = None,
            idle_timeout_in_minutes: Optional[pulumi.Input[_builtins.int]] = None,
            loadbalancer_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            protocol: Optional[pulumi.Input[_builtins.str]] = None) -> 'OutboundRule':
        """
        Get an existing OutboundRule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.int] allocated_outbound_ports: The number of outbound ports to be used for NAT. Defaults to `1024`.
        :param pulumi.Input[_builtins.str] backend_address_pool_id: The ID of the Backend Address Pool. Outbound traffic is randomly load balanced across IPs in the backend IPs.
        :param pulumi.Input[_builtins.bool] enable_tcp_reset: Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        :param pulumi.Input[Sequence[pulumi.Input[Union['OutboundRuleFrontendIpConfigurationArgs', 'OutboundRuleFrontendIpConfigurationArgsDict']]]] frontend_ip_configurations: One or more `frontend_ip_configuration` blocks as defined below.
        :param pulumi.Input[_builtins.int] idle_timeout_in_minutes: The timeout for the TCP idle connection Defaults to `4`.
        :param pulumi.Input[_builtins.str] loadbalancer_id: The ID of the Load Balancer in which to create the Outbound Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Outbound Rule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] protocol: The transport protocol for the external endpoint. Possible values are `Udp`, `Tcp` or `All`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OutboundRuleState.__new__(_OutboundRuleState)

        __props__.__dict__["allocated_outbound_ports"] = allocated_outbound_ports
        __props__.__dict__["backend_address_pool_id"] = backend_address_pool_id
        __props__.__dict__["enable_tcp_reset"] = enable_tcp_reset
        __props__.__dict__["frontend_ip_configurations"] = frontend_ip_configurations
        __props__.__dict__["idle_timeout_in_minutes"] = idle_timeout_in_minutes
        __props__.__dict__["loadbalancer_id"] = loadbalancer_id
        __props__.__dict__["name"] = name
        __props__.__dict__["protocol"] = protocol
        return OutboundRule(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allocatedOutboundPorts")
    def allocated_outbound_ports(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The number of outbound ports to be used for NAT. Defaults to `1024`.
        """
        return pulumi.get(self, "allocated_outbound_ports")

    @_builtins.property
    @pulumi.getter(name="backendAddressPoolId")
    def backend_address_pool_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Backend Address Pool. Outbound traffic is randomly load balanced across IPs in the backend IPs.
        """
        return pulumi.get(self, "backend_address_pool_id")

    @_builtins.property
    @pulumi.getter(name="enableTcpReset")
    def enable_tcp_reset(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
        """
        return pulumi.get(self, "enable_tcp_reset")

    @_builtins.property
    @pulumi.getter(name="frontendIpConfigurations")
    def frontend_ip_configurations(self) -> pulumi.Output[Optional[Sequence['outputs.OutboundRuleFrontendIpConfiguration']]]:
        """
        One or more `frontend_ip_configuration` blocks as defined below.
        """
        return pulumi.get(self, "frontend_ip_configurations")

    @_builtins.property
    @pulumi.getter(name="idleTimeoutInMinutes")
    def idle_timeout_in_minutes(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The timeout for the TCP idle connection Defaults to `4`.
        """
        return pulumi.get(self, "idle_timeout_in_minutes")

    @_builtins.property
    @pulumi.getter(name="loadbalancerId")
    def loadbalancer_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Load Balancer in which to create the Outbound Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "loadbalancer_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Outbound Rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def protocol(self) -> pulumi.Output[_builtins.str]:
        """
        The transport protocol for the external endpoint. Possible values are `Udp`, `Tcp` or `All`.
        """
        return pulumi.get(self, "protocol")

