# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ActionHttpRunAfter',
    'IntegrationAccountAgreementGuestIdentity',
    'IntegrationAccountAgreementHostIdentity',
    'IntegrationAccountBatchConfigurationReleaseCriteria',
    'IntegrationAccountBatchConfigurationReleaseCriteriaRecurrence',
    'IntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceSchedule',
    'IntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceScheduleMonthly',
    'IntegrationAccountCertificateKeyVaultKey',
    'IntegrationAccountPartnerBusinessIdentity',
    'StandardConnectionString',
    'StandardIdentity',
    'StandardSiteConfig',
    'StandardSiteConfigCors',
    'StandardSiteConfigIpRestriction',
    'StandardSiteConfigIpRestrictionHeaders',
    'StandardSiteConfigScmIpRestriction',
    'StandardSiteConfigScmIpRestrictionHeaders',
    'StandardSiteCredential',
    'TriggerRecurrenceSchedule',
    'WorkflowAccessControl',
    'WorkflowAccessControlAction',
    'WorkflowAccessControlContent',
    'WorkflowAccessControlTrigger',
    'WorkflowAccessControlTriggerOpenAuthenticationPolicy',
    'WorkflowAccessControlTriggerOpenAuthenticationPolicyClaim',
    'WorkflowAccessControlWorkflowManagement',
    'WorkflowIdentity',
    'GetStandardConnectionStringResult',
    'GetStandardIdentityResult',
    'GetStandardSiteConfigResult',
    'GetStandardSiteConfigCorsResult',
    'GetStandardSiteConfigIpRestrictionResult',
    'GetStandardSiteConfigIpRestrictionHeadersResult',
    'GetStandardSiteConfigScmIpRestrictionResult',
    'GetStandardSiteConfigScmIpRestrictionHeadersResult',
    'GetStandardSiteCredentialResult',
    'GetWorkflowIdentityResult',
]

@pulumi.output_type
class ActionHttpRunAfter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actionName":
            suggest = "action_name"
        elif key == "actionResult":
            suggest = "action_result"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ActionHttpRunAfter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ActionHttpRunAfter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ActionHttpRunAfter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action_name: _builtins.str,
                 action_result: _builtins.str):
        """
        :param _builtins.str action_name: Specifies the name of the precedent HTTP Action.
        :param _builtins.str action_result: Specifies the expected result of the precedent HTTP Action, only after which the current HTTP Action will be triggered. Possible values include `Succeeded`, `Failed`, `Skipped` and `TimedOut`.
        """
        pulumi.set(__self__, "action_name", action_name)
        pulumi.set(__self__, "action_result", action_result)

    @_builtins.property
    @pulumi.getter(name="actionName")
    def action_name(self) -> _builtins.str:
        """
        Specifies the name of the precedent HTTP Action.
        """
        return pulumi.get(self, "action_name")

    @_builtins.property
    @pulumi.getter(name="actionResult")
    def action_result(self) -> _builtins.str:
        """
        Specifies the expected result of the precedent HTTP Action, only after which the current HTTP Action will be triggered. Possible values include `Succeeded`, `Failed`, `Skipped` and `TimedOut`.
        """
        return pulumi.get(self, "action_result")


@pulumi.output_type
class IntegrationAccountAgreementGuestIdentity(dict):
    def __init__(__self__, *,
                 qualifier: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str qualifier: The authenticating body that provides unique guest identities to organizations.
        :param _builtins.str value: The value that identifies the documents that your logic apps receive.
        """
        pulumi.set(__self__, "qualifier", qualifier)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def qualifier(self) -> _builtins.str:
        """
        The authenticating body that provides unique guest identities to organizations.
        """
        return pulumi.get(self, "qualifier")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value that identifies the documents that your logic apps receive.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class IntegrationAccountAgreementHostIdentity(dict):
    def __init__(__self__, *,
                 qualifier: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str qualifier: The authenticating body that provides unique host identities to organizations.
        :param _builtins.str value: The value that identifies the documents that your logic apps receive.
        """
        pulumi.set(__self__, "qualifier", qualifier)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def qualifier(self) -> _builtins.str:
        """
        The authenticating body that provides unique host identities to organizations.
        """
        return pulumi.get(self, "qualifier")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value that identifies the documents that your logic apps receive.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class IntegrationAccountBatchConfigurationReleaseCriteria(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "batchSize":
            suggest = "batch_size"
        elif key == "messageCount":
            suggest = "message_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationAccountBatchConfigurationReleaseCriteria. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationAccountBatchConfigurationReleaseCriteria.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationAccountBatchConfigurationReleaseCriteria.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 batch_size: Optional[_builtins.int] = None,
                 message_count: Optional[_builtins.int] = None,
                 recurrence: Optional['outputs.IntegrationAccountBatchConfigurationReleaseCriteriaRecurrence'] = None):
        """
        :param _builtins.int batch_size: The batch size in bytes for the Logic App Integration Batch Configuration.
        :param _builtins.int message_count: The message count for the Logic App Integration Batch Configuration.
        :param 'IntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceArgs' recurrence: A `recurrence` block as documented below.
        """
        if batch_size is not None:
            pulumi.set(__self__, "batch_size", batch_size)
        if message_count is not None:
            pulumi.set(__self__, "message_count", message_count)
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)

    @_builtins.property
    @pulumi.getter(name="batchSize")
    def batch_size(self) -> Optional[_builtins.int]:
        """
        The batch size in bytes for the Logic App Integration Batch Configuration.
        """
        return pulumi.get(self, "batch_size")

    @_builtins.property
    @pulumi.getter(name="messageCount")
    def message_count(self) -> Optional[_builtins.int]:
        """
        The message count for the Logic App Integration Batch Configuration.
        """
        return pulumi.get(self, "message_count")

    @_builtins.property
    @pulumi.getter
    def recurrence(self) -> Optional['outputs.IntegrationAccountBatchConfigurationReleaseCriteriaRecurrence']:
        """
        A `recurrence` block as documented below.
        """
        return pulumi.get(self, "recurrence")


@pulumi.output_type
class IntegrationAccountBatchConfigurationReleaseCriteriaRecurrence(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "timeZone":
            suggest = "time_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationAccountBatchConfigurationReleaseCriteriaRecurrence. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationAccountBatchConfigurationReleaseCriteriaRecurrence.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationAccountBatchConfigurationReleaseCriteriaRecurrence.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 frequency: _builtins.str,
                 interval: _builtins.int,
                 end_time: Optional[_builtins.str] = None,
                 schedule: Optional['outputs.IntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceSchedule'] = None,
                 start_time: Optional[_builtins.str] = None,
                 time_zone: Optional[_builtins.str] = None):
        """
        :param _builtins.str frequency: The frequency of the schedule. Possible values are `Day`, `Hour`, `Minute`, `Month`, `NotSpecified`, `Second`, `Week` and `Year`.
        :param _builtins.int interval: The number of `frequency`s between runs.
        :param _builtins.str end_time: The end time of the schedule, formatted as an RFC3339 string.
        :param 'IntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceScheduleArgs' schedule: A `schedule` block as documented below.
        :param _builtins.str start_time: The start time of the schedule, formatted as an RFC3339 string.
        :param _builtins.str time_zone: The timezone of the start/end time.
        """
        pulumi.set(__self__, "frequency", frequency)
        pulumi.set(__self__, "interval", interval)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if schedule is not None:
            pulumi.set(__self__, "schedule", schedule)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @_builtins.property
    @pulumi.getter
    def frequency(self) -> _builtins.str:
        """
        The frequency of the schedule. Possible values are `Day`, `Hour`, `Minute`, `Month`, `NotSpecified`, `Second`, `Week` and `Year`.
        """
        return pulumi.get(self, "frequency")

    @_builtins.property
    @pulumi.getter
    def interval(self) -> _builtins.int:
        """
        The number of `frequency`s between runs.
        """
        return pulumi.get(self, "interval")

    @_builtins.property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[_builtins.str]:
        """
        The end time of the schedule, formatted as an RFC3339 string.
        """
        return pulumi.get(self, "end_time")

    @_builtins.property
    @pulumi.getter
    def schedule(self) -> Optional['outputs.IntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceSchedule']:
        """
        A `schedule` block as documented below.
        """
        return pulumi.get(self, "schedule")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[_builtins.str]:
        """
        The start time of the schedule, formatted as an RFC3339 string.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[_builtins.str]:
        """
        The timezone of the start/end time.
        """
        return pulumi.get(self, "time_zone")


@pulumi.output_type
class IntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "monthDays":
            suggest = "month_days"
        elif key == "weekDays":
            suggest = "week_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hours: Optional[Sequence[_builtins.int]] = None,
                 minutes: Optional[Sequence[_builtins.int]] = None,
                 month_days: Optional[Sequence[_builtins.int]] = None,
                 monthlies: Optional[Sequence['outputs.IntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceScheduleMonthly']] = None,
                 week_days: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.int] hours: A list containing a single item, which specifies the Hour interval at which this recurrence should be triggered.
        :param Sequence[_builtins.int] minutes: A list containing a single item which specifies the Minute interval at which this recurrence should be triggered.
        :param Sequence[_builtins.int] month_days: A list of days of the month that the job should execute on.
        :param Sequence['IntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceScheduleMonthlyArgs'] monthlies: A `monthly` block as documented below.
        :param Sequence[_builtins.str] week_days: A list of days of the week that the job should execute on. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` and `Saturday`.
        """
        if hours is not None:
            pulumi.set(__self__, "hours", hours)
        if minutes is not None:
            pulumi.set(__self__, "minutes", minutes)
        if month_days is not None:
            pulumi.set(__self__, "month_days", month_days)
        if monthlies is not None:
            pulumi.set(__self__, "monthlies", monthlies)
        if week_days is not None:
            pulumi.set(__self__, "week_days", week_days)

    @_builtins.property
    @pulumi.getter
    def hours(self) -> Optional[Sequence[_builtins.int]]:
        """
        A list containing a single item, which specifies the Hour interval at which this recurrence should be triggered.
        """
        return pulumi.get(self, "hours")

    @_builtins.property
    @pulumi.getter
    def minutes(self) -> Optional[Sequence[_builtins.int]]:
        """
        A list containing a single item which specifies the Minute interval at which this recurrence should be triggered.
        """
        return pulumi.get(self, "minutes")

    @_builtins.property
    @pulumi.getter(name="monthDays")
    def month_days(self) -> Optional[Sequence[_builtins.int]]:
        """
        A list of days of the month that the job should execute on.
        """
        return pulumi.get(self, "month_days")

    @_builtins.property
    @pulumi.getter
    def monthlies(self) -> Optional[Sequence['outputs.IntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceScheduleMonthly']]:
        """
        A `monthly` block as documented below.
        """
        return pulumi.get(self, "monthlies")

    @_builtins.property
    @pulumi.getter(name="weekDays")
    def week_days(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of days of the week that the job should execute on. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` and `Saturday`.
        """
        return pulumi.get(self, "week_days")


@pulumi.output_type
class IntegrationAccountBatchConfigurationReleaseCriteriaRecurrenceScheduleMonthly(dict):
    def __init__(__self__, *,
                 week: _builtins.int,
                 weekday: _builtins.str):
        """
        :param _builtins.int week: The occurrence of the week within the month.
        :param _builtins.str weekday: The day of the occurrence. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` and `Saturday`.
        """
        pulumi.set(__self__, "week", week)
        pulumi.set(__self__, "weekday", weekday)

    @_builtins.property
    @pulumi.getter
    def week(self) -> _builtins.int:
        """
        The occurrence of the week within the month.
        """
        return pulumi.get(self, "week")

    @_builtins.property
    @pulumi.getter
    def weekday(self) -> _builtins.str:
        """
        The day of the occurrence. Possible values are `Sunday`, `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday` and `Saturday`.
        """
        return pulumi.get(self, "weekday")


@pulumi.output_type
class IntegrationAccountCertificateKeyVaultKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "keyName":
            suggest = "key_name"
        elif key == "keyVaultId":
            suggest = "key_vault_id"
        elif key == "keyVersion":
            suggest = "key_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationAccountCertificateKeyVaultKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationAccountCertificateKeyVaultKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationAccountCertificateKeyVaultKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key_name: _builtins.str,
                 key_vault_id: _builtins.str,
                 key_version: Optional[_builtins.str] = None):
        """
        :param _builtins.str key_name: The name of Key Vault Key.
        :param _builtins.str key_vault_id: The ID of the Key Vault.
        :param _builtins.str key_version: The version of Key Vault Key.
        """
        pulumi.set(__self__, "key_name", key_name)
        pulumi.set(__self__, "key_vault_id", key_vault_id)
        if key_version is not None:
            pulumi.set(__self__, "key_version", key_version)

    @_builtins.property
    @pulumi.getter(name="keyName")
    def key_name(self) -> _builtins.str:
        """
        The name of Key Vault Key.
        """
        return pulumi.get(self, "key_name")

    @_builtins.property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> _builtins.str:
        """
        The ID of the Key Vault.
        """
        return pulumi.get(self, "key_vault_id")

    @_builtins.property
    @pulumi.getter(name="keyVersion")
    def key_version(self) -> Optional[_builtins.str]:
        """
        The version of Key Vault Key.
        """
        return pulumi.get(self, "key_version")


@pulumi.output_type
class IntegrationAccountPartnerBusinessIdentity(dict):
    def __init__(__self__, *,
                 qualifier: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str qualifier: The authenticating body that provides unique business identities to organizations.
        :param _builtins.str value: The value that identifies the documents that your logic apps receive.
        """
        pulumi.set(__self__, "qualifier", qualifier)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def qualifier(self) -> _builtins.str:
        """
        The authenticating body that provides unique business identities to organizations.
        """
        return pulumi.get(self, "qualifier")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value that identifies the documents that your logic apps receive.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class StandardConnectionString(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the Connection String.
        :param _builtins.str type: The type of the Connection String. Possible values are `APIHub`, `Custom`, `DocDb`, `EventHub`, `MySQL`, `NotificationHub`, `PostgreSQL`, `RedisCache`, `ServiceBus`, `SQLAzure` and `SQLServer`.
        :param _builtins.str value: The value for the Connection String.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Connection String.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of the Connection String. Possible values are `APIHub`, `Custom`, `DocDb`, `EventHub`, `MySQL`, `NotificationHub`, `PostgreSQL`, `RedisCache`, `ServiceBus`, `SQLAzure` and `SQLServer`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value for the Connection String.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class StandardIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StandardIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StandardIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StandardIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Logic App Standard. Possible values are `SystemAssigned`, `UserAssigned` and `SystemAssigned, UserAssigned` (to enable both).
        :param Sequence[_builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Logic App Standard.
               
               > **Note:** When `type` is set to `SystemAssigned`, The assigned `principal_id` and `tenant_id` can be retrieved after the Logic App has been created. More details are available below.
               
               > **Note:** The `identity_ids` is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param _builtins.str principal_id: The Principal ID for the Service Principal associated with the Managed Service Identity of this App Service.
        :param _builtins.str tenant_id: The Tenant ID for the Service Principal associated with the Managed Service Identity of this App Service.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Logic App Standard. Possible values are `SystemAssigned`, `UserAssigned` and `SystemAssigned, UserAssigned` (to enable both).
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Logic App Standard.

        > **Note:** When `type` is set to `SystemAssigned`, The assigned `principal_id` and `tenant_id` can be retrieved after the Logic App has been created. More details are available below.

        > **Note:** The `identity_ids` is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID for the Service Principal associated with the Managed Service Identity of this App Service.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID for the Service Principal associated with the Managed Service Identity of this App Service.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class StandardSiteConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "alwaysOn":
            suggest = "always_on"
        elif key == "appScaleLimit":
            suggest = "app_scale_limit"
        elif key == "autoSwapSlotName":
            suggest = "auto_swap_slot_name"
        elif key == "dotnetFrameworkVersion":
            suggest = "dotnet_framework_version"
        elif key == "elasticInstanceMinimum":
            suggest = "elastic_instance_minimum"
        elif key == "ftpsState":
            suggest = "ftps_state"
        elif key == "healthCheckPath":
            suggest = "health_check_path"
        elif key == "http2Enabled":
            suggest = "http2_enabled"
        elif key == "ipRestrictions":
            suggest = "ip_restrictions"
        elif key == "linuxFxVersion":
            suggest = "linux_fx_version"
        elif key == "minTlsVersion":
            suggest = "min_tls_version"
        elif key == "preWarmedInstanceCount":
            suggest = "pre_warmed_instance_count"
        elif key == "publicNetworkAccessEnabled":
            suggest = "public_network_access_enabled"
        elif key == "runtimeScaleMonitoringEnabled":
            suggest = "runtime_scale_monitoring_enabled"
        elif key == "scmIpRestrictions":
            suggest = "scm_ip_restrictions"
        elif key == "scmMinTlsVersion":
            suggest = "scm_min_tls_version"
        elif key == "scmType":
            suggest = "scm_type"
        elif key == "scmUseMainIpRestriction":
            suggest = "scm_use_main_ip_restriction"
        elif key == "use32BitWorkerProcess":
            suggest = "use32_bit_worker_process"
        elif key == "vnetRouteAllEnabled":
            suggest = "vnet_route_all_enabled"
        elif key == "websocketsEnabled":
            suggest = "websockets_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StandardSiteConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StandardSiteConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StandardSiteConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 always_on: Optional[_builtins.bool] = None,
                 app_scale_limit: Optional[_builtins.int] = None,
                 auto_swap_slot_name: Optional[_builtins.str] = None,
                 cors: Optional['outputs.StandardSiteConfigCors'] = None,
                 dotnet_framework_version: Optional[_builtins.str] = None,
                 elastic_instance_minimum: Optional[_builtins.int] = None,
                 ftps_state: Optional[_builtins.str] = None,
                 health_check_path: Optional[_builtins.str] = None,
                 http2_enabled: Optional[_builtins.bool] = None,
                 ip_restrictions: Optional[Sequence['outputs.StandardSiteConfigIpRestriction']] = None,
                 linux_fx_version: Optional[_builtins.str] = None,
                 min_tls_version: Optional[_builtins.str] = None,
                 pre_warmed_instance_count: Optional[_builtins.int] = None,
                 public_network_access_enabled: Optional[_builtins.bool] = None,
                 runtime_scale_monitoring_enabled: Optional[_builtins.bool] = None,
                 scm_ip_restrictions: Optional[Sequence['outputs.StandardSiteConfigScmIpRestriction']] = None,
                 scm_min_tls_version: Optional[_builtins.str] = None,
                 scm_type: Optional[_builtins.str] = None,
                 scm_use_main_ip_restriction: Optional[_builtins.bool] = None,
                 use32_bit_worker_process: Optional[_builtins.bool] = None,
                 vnet_route_all_enabled: Optional[_builtins.bool] = None,
                 websockets_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.bool always_on: Should the Logic App be loaded at all times? Defaults to `false`.
        :param _builtins.int app_scale_limit: The number of workers this Logic App can scale out to. Only applicable to apps on the Consumption and Premium plan.
        :param _builtins.str auto_swap_slot_name: The Auto-swap slot name.
        :param 'StandardSiteConfigCorsArgs' cors: A `cors` block as defined below.
        :param _builtins.str dotnet_framework_version: The version of the .NET framework's CLR used in this Logic App Possible values are `v4.0` (including .NET Core 2.1 and 3.1), `v5.0`, `v6.0` and `v8.0`. [For more information on which .NET Framework version to use based on the runtime version you're targeting - please see this table](https://docs.microsoft.com/azure/azure-functions/functions-dotnet-class-library#supported-versions). Defaults to `v4.0`.
        :param _builtins.int elastic_instance_minimum: The number of minimum instances for this Logic App Only affects apps on the Premium plan.
        :param _builtins.str ftps_state: State of FTP / FTPS service for this Logic App. Possible values include: `AllAllowed`, `FtpsOnly` and `Disabled`. Defaults to `AllAllowed`.
        :param _builtins.str health_check_path: Path which will be checked for this Logic App health.
        :param _builtins.bool http2_enabled: Specifies whether the HTTP2 protocol should be enabled. Defaults to `false`.
        :param Sequence['StandardSiteConfigIpRestrictionArgs'] ip_restrictions: A list of `ip_restriction` objects representing IP restrictions as defined below.
               
               > **Note:** User has to explicitly set `ip_restriction` to empty slice (`[]`) to remove it.
        :param _builtins.str linux_fx_version: Linux App Framework and version for the App Service, e.g. `DOCKER|(golang:latest)`. Setting this value will also set the `kind` of application deployed to `functionapp,linux,container,workflowapp`.
               
               > **Note:** You must set `os_type` in `appservice.ServicePlan` to `Linux` when this property is set.
        :param _builtins.str min_tls_version: The minimum supported TLS version for the Logic App. Possible values are `1.0`, `1.1`, and `1.2`. Defaults to `1.2` for new Logic Apps.
               
               > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        :param _builtins.int pre_warmed_instance_count: The number of pre-warmed instances for this Logic App Only affects apps on the Premium plan.
        :param _builtins.bool runtime_scale_monitoring_enabled: Should Runtime Scale Monitoring be enabled?. Only applicable to apps on the Premium plan. Defaults to `false`.
        :param Sequence['StandardSiteConfigScmIpRestrictionArgs'] scm_ip_restrictions: A list of `scm_ip_restriction` objects representing SCM IP restrictions as defined below.
               
               > **Note:** User has to explicitly set `scm_ip_restriction` to empty slice (`[]`) to remove it.
        :param _builtins.str scm_min_tls_version: Configures the minimum version of TLS required for SSL requests to the SCM site. Possible values are `1.0`, `1.1` and `1.2`.
               
               > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        :param _builtins.str scm_type: The type of Source Control used by the Logic App in use by the Windows Function App. Defaults to `None`. Possible values are: `BitbucketGit`, `BitbucketHg`, `CodePlexGit`, `CodePlexHg`, `Dropbox`, `ExternalGit`, `ExternalHg`, `GitHub`, `LocalGit`, `None`, `OneDrive`, `Tfs`, `VSO`, and `VSTSRM`
        :param _builtins.bool scm_use_main_ip_restriction: Should the Logic App `ip_restriction` configuration be used for the SCM too. Defaults to `false`.
        :param _builtins.bool use32_bit_worker_process: Should the Logic App run in 32 bit mode, rather than 64 bit mode? Defaults to `true`.
               
               > **Note:** when using an App Service Plan in the `Free` or `Shared` Tiers `use_32_bit_worker_process` must be set to `true`.
        :param _builtins.bool vnet_route_all_enabled: Should all outbound traffic to have Virtual Network Security Groups and User Defined Routes applied.
        :param _builtins.bool websockets_enabled: Should WebSockets be enabled?
        """
        if always_on is not None:
            pulumi.set(__self__, "always_on", always_on)
        if app_scale_limit is not None:
            pulumi.set(__self__, "app_scale_limit", app_scale_limit)
        if auto_swap_slot_name is not None:
            pulumi.set(__self__, "auto_swap_slot_name", auto_swap_slot_name)
        if cors is not None:
            pulumi.set(__self__, "cors", cors)
        if dotnet_framework_version is not None:
            pulumi.set(__self__, "dotnet_framework_version", dotnet_framework_version)
        if elastic_instance_minimum is not None:
            pulumi.set(__self__, "elastic_instance_minimum", elastic_instance_minimum)
        if ftps_state is not None:
            pulumi.set(__self__, "ftps_state", ftps_state)
        if health_check_path is not None:
            pulumi.set(__self__, "health_check_path", health_check_path)
        if http2_enabled is not None:
            pulumi.set(__self__, "http2_enabled", http2_enabled)
        if ip_restrictions is not None:
            pulumi.set(__self__, "ip_restrictions", ip_restrictions)
        if linux_fx_version is not None:
            pulumi.set(__self__, "linux_fx_version", linux_fx_version)
        if min_tls_version is not None:
            pulumi.set(__self__, "min_tls_version", min_tls_version)
        if pre_warmed_instance_count is not None:
            pulumi.set(__self__, "pre_warmed_instance_count", pre_warmed_instance_count)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if runtime_scale_monitoring_enabled is not None:
            pulumi.set(__self__, "runtime_scale_monitoring_enabled", runtime_scale_monitoring_enabled)
        if scm_ip_restrictions is not None:
            pulumi.set(__self__, "scm_ip_restrictions", scm_ip_restrictions)
        if scm_min_tls_version is not None:
            pulumi.set(__self__, "scm_min_tls_version", scm_min_tls_version)
        if scm_type is not None:
            pulumi.set(__self__, "scm_type", scm_type)
        if scm_use_main_ip_restriction is not None:
            pulumi.set(__self__, "scm_use_main_ip_restriction", scm_use_main_ip_restriction)
        if use32_bit_worker_process is not None:
            pulumi.set(__self__, "use32_bit_worker_process", use32_bit_worker_process)
        if vnet_route_all_enabled is not None:
            pulumi.set(__self__, "vnet_route_all_enabled", vnet_route_all_enabled)
        if websockets_enabled is not None:
            pulumi.set(__self__, "websockets_enabled", websockets_enabled)

    @_builtins.property
    @pulumi.getter(name="alwaysOn")
    def always_on(self) -> Optional[_builtins.bool]:
        """
        Should the Logic App be loaded at all times? Defaults to `false`.
        """
        return pulumi.get(self, "always_on")

    @_builtins.property
    @pulumi.getter(name="appScaleLimit")
    def app_scale_limit(self) -> Optional[_builtins.int]:
        """
        The number of workers this Logic App can scale out to. Only applicable to apps on the Consumption and Premium plan.
        """
        return pulumi.get(self, "app_scale_limit")

    @_builtins.property
    @pulumi.getter(name="autoSwapSlotName")
    def auto_swap_slot_name(self) -> Optional[_builtins.str]:
        """
        The Auto-swap slot name.
        """
        return pulumi.get(self, "auto_swap_slot_name")

    @_builtins.property
    @pulumi.getter
    def cors(self) -> Optional['outputs.StandardSiteConfigCors']:
        """
        A `cors` block as defined below.
        """
        return pulumi.get(self, "cors")

    @_builtins.property
    @pulumi.getter(name="dotnetFrameworkVersion")
    def dotnet_framework_version(self) -> Optional[_builtins.str]:
        """
        The version of the .NET framework's CLR used in this Logic App Possible values are `v4.0` (including .NET Core 2.1 and 3.1), `v5.0`, `v6.0` and `v8.0`. [For more information on which .NET Framework version to use based on the runtime version you're targeting - please see this table](https://docs.microsoft.com/azure/azure-functions/functions-dotnet-class-library#supported-versions). Defaults to `v4.0`.
        """
        return pulumi.get(self, "dotnet_framework_version")

    @_builtins.property
    @pulumi.getter(name="elasticInstanceMinimum")
    def elastic_instance_minimum(self) -> Optional[_builtins.int]:
        """
        The number of minimum instances for this Logic App Only affects apps on the Premium plan.
        """
        return pulumi.get(self, "elastic_instance_minimum")

    @_builtins.property
    @pulumi.getter(name="ftpsState")
    def ftps_state(self) -> Optional[_builtins.str]:
        """
        State of FTP / FTPS service for this Logic App. Possible values include: `AllAllowed`, `FtpsOnly` and `Disabled`. Defaults to `AllAllowed`.
        """
        return pulumi.get(self, "ftps_state")

    @_builtins.property
    @pulumi.getter(name="healthCheckPath")
    def health_check_path(self) -> Optional[_builtins.str]:
        """
        Path which will be checked for this Logic App health.
        """
        return pulumi.get(self, "health_check_path")

    @_builtins.property
    @pulumi.getter(name="http2Enabled")
    def http2_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether the HTTP2 protocol should be enabled. Defaults to `false`.
        """
        return pulumi.get(self, "http2_enabled")

    @_builtins.property
    @pulumi.getter(name="ipRestrictions")
    def ip_restrictions(self) -> Optional[Sequence['outputs.StandardSiteConfigIpRestriction']]:
        """
        A list of `ip_restriction` objects representing IP restrictions as defined below.

        > **Note:** User has to explicitly set `ip_restriction` to empty slice (`[]`) to remove it.
        """
        return pulumi.get(self, "ip_restrictions")

    @_builtins.property
    @pulumi.getter(name="linuxFxVersion")
    def linux_fx_version(self) -> Optional[_builtins.str]:
        """
        Linux App Framework and version for the App Service, e.g. `DOCKER|(golang:latest)`. Setting this value will also set the `kind` of application deployed to `functionapp,linux,container,workflowapp`.

        > **Note:** You must set `os_type` in `appservice.ServicePlan` to `Linux` when this property is set.
        """
        return pulumi.get(self, "linux_fx_version")

    @_builtins.property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> Optional[_builtins.str]:
        """
        The minimum supported TLS version for the Logic App. Possible values are `1.0`, `1.1`, and `1.2`. Defaults to `1.2` for new Logic Apps.

        > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        """
        return pulumi.get(self, "min_tls_version")

    @_builtins.property
    @pulumi.getter(name="preWarmedInstanceCount")
    def pre_warmed_instance_count(self) -> Optional[_builtins.int]:
        """
        The number of pre-warmed instances for this Logic App Only affects apps on the Premium plan.
        """
        return pulumi.get(self, "pre_warmed_instance_count")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    @_utilities.deprecated("""the `site_config.public_network_access_enabled` property has been superseded by the `public_network_access` property and will be removed in v5.0 of the AzureRM Provider.""")
    def public_network_access_enabled(self) -> Optional[_builtins.bool]:
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="runtimeScaleMonitoringEnabled")
    def runtime_scale_monitoring_enabled(self) -> Optional[_builtins.bool]:
        """
        Should Runtime Scale Monitoring be enabled?. Only applicable to apps on the Premium plan. Defaults to `false`.
        """
        return pulumi.get(self, "runtime_scale_monitoring_enabled")

    @_builtins.property
    @pulumi.getter(name="scmIpRestrictions")
    def scm_ip_restrictions(self) -> Optional[Sequence['outputs.StandardSiteConfigScmIpRestriction']]:
        """
        A list of `scm_ip_restriction` objects representing SCM IP restrictions as defined below.

        > **Note:** User has to explicitly set `scm_ip_restriction` to empty slice (`[]`) to remove it.
        """
        return pulumi.get(self, "scm_ip_restrictions")

    @_builtins.property
    @pulumi.getter(name="scmMinTlsVersion")
    def scm_min_tls_version(self) -> Optional[_builtins.str]:
        """
        Configures the minimum version of TLS required for SSL requests to the SCM site. Possible values are `1.0`, `1.1` and `1.2`.

        > **Note:** Azure Services will require TLS 1.2+ by August 2025, please see this [announcement](https://azure.microsoft.com/en-us/updates/v2/update-retirement-tls1-0-tls1-1-versions-azure-services/) for more.
        """
        return pulumi.get(self, "scm_min_tls_version")

    @_builtins.property
    @pulumi.getter(name="scmType")
    def scm_type(self) -> Optional[_builtins.str]:
        """
        The type of Source Control used by the Logic App in use by the Windows Function App. Defaults to `None`. Possible values are: `BitbucketGit`, `BitbucketHg`, `CodePlexGit`, `CodePlexHg`, `Dropbox`, `ExternalGit`, `ExternalHg`, `GitHub`, `LocalGit`, `None`, `OneDrive`, `Tfs`, `VSO`, and `VSTSRM`
        """
        return pulumi.get(self, "scm_type")

    @_builtins.property
    @pulumi.getter(name="scmUseMainIpRestriction")
    def scm_use_main_ip_restriction(self) -> Optional[_builtins.bool]:
        """
        Should the Logic App `ip_restriction` configuration be used for the SCM too. Defaults to `false`.
        """
        return pulumi.get(self, "scm_use_main_ip_restriction")

    @_builtins.property
    @pulumi.getter(name="use32BitWorkerProcess")
    def use32_bit_worker_process(self) -> Optional[_builtins.bool]:
        """
        Should the Logic App run in 32 bit mode, rather than 64 bit mode? Defaults to `true`.

        > **Note:** when using an App Service Plan in the `Free` or `Shared` Tiers `use_32_bit_worker_process` must be set to `true`.
        """
        return pulumi.get(self, "use32_bit_worker_process")

    @_builtins.property
    @pulumi.getter(name="vnetRouteAllEnabled")
    def vnet_route_all_enabled(self) -> Optional[_builtins.bool]:
        """
        Should all outbound traffic to have Virtual Network Security Groups and User Defined Routes applied.
        """
        return pulumi.get(self, "vnet_route_all_enabled")

    @_builtins.property
    @pulumi.getter(name="websocketsEnabled")
    def websockets_enabled(self) -> Optional[_builtins.bool]:
        """
        Should WebSockets be enabled?
        """
        return pulumi.get(self, "websockets_enabled")


@pulumi.output_type
class StandardSiteConfigCors(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "supportCredentials":
            suggest = "support_credentials"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StandardSiteConfigCors. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StandardSiteConfigCors.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StandardSiteConfigCors.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_origins: Sequence[_builtins.str],
                 support_credentials: Optional[_builtins.bool] = None):
        """
        :param Sequence[_builtins.str] allowed_origins: A list of origins which should be able to make cross-origin calls. `*` can be used to allow all calls.
        :param _builtins.bool support_credentials: Are credentials supported?
        """
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if support_credentials is not None:
            pulumi.set(__self__, "support_credentials", support_credentials)

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[_builtins.str]:
        """
        A list of origins which should be able to make cross-origin calls. `*` can be used to allow all calls.
        """
        return pulumi.get(self, "allowed_origins")

    @_builtins.property
    @pulumi.getter(name="supportCredentials")
    def support_credentials(self) -> Optional[_builtins.bool]:
        """
        Are credentials supported?
        """
        return pulumi.get(self, "support_credentials")


@pulumi.output_type
class StandardSiteConfigIpRestriction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "serviceTag":
            suggest = "service_tag"
        elif key == "virtualNetworkSubnetId":
            suggest = "virtual_network_subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StandardSiteConfigIpRestriction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StandardSiteConfigIpRestriction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StandardSiteConfigIpRestriction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Optional[_builtins.str] = None,
                 headers: Optional['outputs.StandardSiteConfigIpRestrictionHeaders'] = None,
                 ip_address: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 priority: Optional[_builtins.int] = None,
                 service_tag: Optional[_builtins.str] = None,
                 virtual_network_subnet_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str action: Does this restriction `Allow` or `Deny` access for this IP range. Defaults to `Allow`.
        :param 'StandardSiteConfigIpRestrictionHeadersArgs' headers: The `headers` block for this specific as a `ip_restriction` block as defined below.
        :param _builtins.str ip_address: The IP Address used for this IP Restriction in CIDR notation.
        :param _builtins.str name: The name for this IP Restriction.
        :param _builtins.int priority: The priority for this IP Restriction. Restrictions are enforced in priority order. By default, the priority is set to 65000 if not specified.
        :param _builtins.str service_tag: The Service Tag used for this IP Restriction.
        :param _builtins.str virtual_network_subnet_id: The Virtual Network Subnet ID used for this IP Restriction.
               
               > **Note:** One of either `ip_address`, `service_tag` or `virtual_network_subnet_id` must be specified
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if service_tag is not None:
            pulumi.set(__self__, "service_tag", service_tag)
        if virtual_network_subnet_id is not None:
            pulumi.set(__self__, "virtual_network_subnet_id", virtual_network_subnet_id)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        """
        Does this restriction `Allow` or `Deny` access for this IP range. Defaults to `Allow`.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional['outputs.StandardSiteConfigIpRestrictionHeaders']:
        """
        The `headers` block for this specific as a `ip_restriction` block as defined below.
        """
        return pulumi.get(self, "headers")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        The IP Address used for this IP Restriction in CIDR notation.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name for this IP Restriction.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.int]:
        """
        The priority for this IP Restriction. Restrictions are enforced in priority order. By default, the priority is set to 65000 if not specified.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="serviceTag")
    def service_tag(self) -> Optional[_builtins.str]:
        """
        The Service Tag used for this IP Restriction.
        """
        return pulumi.get(self, "service_tag")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkSubnetId")
    def virtual_network_subnet_id(self) -> Optional[_builtins.str]:
        """
        The Virtual Network Subnet ID used for this IP Restriction.

        > **Note:** One of either `ip_address`, `service_tag` or `virtual_network_subnet_id` must be specified
        """
        return pulumi.get(self, "virtual_network_subnet_id")


@pulumi.output_type
class StandardSiteConfigIpRestrictionHeaders(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "xAzureFdids":
            suggest = "x_azure_fdids"
        elif key == "xFdHealthProbe":
            suggest = "x_fd_health_probe"
        elif key == "xForwardedFors":
            suggest = "x_forwarded_fors"
        elif key == "xForwardedHosts":
            suggest = "x_forwarded_hosts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StandardSiteConfigIpRestrictionHeaders. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StandardSiteConfigIpRestrictionHeaders.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StandardSiteConfigIpRestrictionHeaders.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 x_azure_fdids: Optional[Sequence[_builtins.str]] = None,
                 x_fd_health_probe: Optional[_builtins.str] = None,
                 x_forwarded_fors: Optional[Sequence[_builtins.str]] = None,
                 x_forwarded_hosts: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] x_azure_fdids: A list of allowed Azure FrontDoor IDs in UUID notation with a maximum of 8.
        :param _builtins.str x_fd_health_probe: A list to allow the Azure FrontDoor health probe header. Only allowed value is `1`.
        :param Sequence[_builtins.str] x_forwarded_fors: A list of allowed 'X-Forwarded-For' IPs in CIDR notation with a maximum of 8.
        :param Sequence[_builtins.str] x_forwarded_hosts: A list of allowed 'X-Forwarded-Host' domains with a maximum of 8.
        """
        if x_azure_fdids is not None:
            pulumi.set(__self__, "x_azure_fdids", x_azure_fdids)
        if x_fd_health_probe is not None:
            pulumi.set(__self__, "x_fd_health_probe", x_fd_health_probe)
        if x_forwarded_fors is not None:
            pulumi.set(__self__, "x_forwarded_fors", x_forwarded_fors)
        if x_forwarded_hosts is not None:
            pulumi.set(__self__, "x_forwarded_hosts", x_forwarded_hosts)

    @_builtins.property
    @pulumi.getter(name="xAzureFdids")
    def x_azure_fdids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of allowed Azure FrontDoor IDs in UUID notation with a maximum of 8.
        """
        return pulumi.get(self, "x_azure_fdids")

    @_builtins.property
    @pulumi.getter(name="xFdHealthProbe")
    def x_fd_health_probe(self) -> Optional[_builtins.str]:
        """
        A list to allow the Azure FrontDoor health probe header. Only allowed value is `1`.
        """
        return pulumi.get(self, "x_fd_health_probe")

    @_builtins.property
    @pulumi.getter(name="xForwardedFors")
    def x_forwarded_fors(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of allowed 'X-Forwarded-For' IPs in CIDR notation with a maximum of 8.
        """
        return pulumi.get(self, "x_forwarded_fors")

    @_builtins.property
    @pulumi.getter(name="xForwardedHosts")
    def x_forwarded_hosts(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of allowed 'X-Forwarded-Host' domains with a maximum of 8.
        """
        return pulumi.get(self, "x_forwarded_hosts")


@pulumi.output_type
class StandardSiteConfigScmIpRestriction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "serviceTag":
            suggest = "service_tag"
        elif key == "virtualNetworkSubnetId":
            suggest = "virtual_network_subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StandardSiteConfigScmIpRestriction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StandardSiteConfigScmIpRestriction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StandardSiteConfigScmIpRestriction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Optional[_builtins.str] = None,
                 headers: Optional['outputs.StandardSiteConfigScmIpRestrictionHeaders'] = None,
                 ip_address: Optional[_builtins.str] = None,
                 name: Optional[_builtins.str] = None,
                 priority: Optional[_builtins.int] = None,
                 service_tag: Optional[_builtins.str] = None,
                 virtual_network_subnet_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str action: Does this restriction `Allow` or `Deny` access for this IP range. Defaults to `Allow`.
        :param 'StandardSiteConfigScmIpRestrictionHeadersArgs' headers: The `headers` block for this specific `ip_restriction` as defined below.
        :param _builtins.str ip_address: The IP Address used for this IP Restriction in CIDR notation.
        :param _builtins.str name: The name for this IP Restriction.
        :param _builtins.int priority: The priority for this IP Restriction. Restrictions are enforced in priority order. By default, the priority is set to `65000` if not specified.
        :param _builtins.str service_tag: The Service Tag used for this IP Restriction.
        :param _builtins.str virtual_network_subnet_id: The Virtual Network Subnet ID used for this IP Restriction.
               
               > **Note:** One of either `ip_address`, `service_tag` or `virtual_network_subnet_id` must be specified.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if service_tag is not None:
            pulumi.set(__self__, "service_tag", service_tag)
        if virtual_network_subnet_id is not None:
            pulumi.set(__self__, "virtual_network_subnet_id", virtual_network_subnet_id)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        """
        Does this restriction `Allow` or `Deny` access for this IP range. Defaults to `Allow`.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def headers(self) -> Optional['outputs.StandardSiteConfigScmIpRestrictionHeaders']:
        """
        The `headers` block for this specific `ip_restriction` as defined below.
        """
        return pulumi.get(self, "headers")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        The IP Address used for this IP Restriction in CIDR notation.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        The name for this IP Restriction.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.int]:
        """
        The priority for this IP Restriction. Restrictions are enforced in priority order. By default, the priority is set to `65000` if not specified.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="serviceTag")
    def service_tag(self) -> Optional[_builtins.str]:
        """
        The Service Tag used for this IP Restriction.
        """
        return pulumi.get(self, "service_tag")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkSubnetId")
    def virtual_network_subnet_id(self) -> Optional[_builtins.str]:
        """
        The Virtual Network Subnet ID used for this IP Restriction.

        > **Note:** One of either `ip_address`, `service_tag` or `virtual_network_subnet_id` must be specified.
        """
        return pulumi.get(self, "virtual_network_subnet_id")


@pulumi.output_type
class StandardSiteConfigScmIpRestrictionHeaders(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "xAzureFdids":
            suggest = "x_azure_fdids"
        elif key == "xFdHealthProbe":
            suggest = "x_fd_health_probe"
        elif key == "xForwardedFors":
            suggest = "x_forwarded_fors"
        elif key == "xForwardedHosts":
            suggest = "x_forwarded_hosts"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StandardSiteConfigScmIpRestrictionHeaders. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StandardSiteConfigScmIpRestrictionHeaders.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StandardSiteConfigScmIpRestrictionHeaders.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 x_azure_fdids: Optional[Sequence[_builtins.str]] = None,
                 x_fd_health_probe: Optional[_builtins.str] = None,
                 x_forwarded_fors: Optional[Sequence[_builtins.str]] = None,
                 x_forwarded_hosts: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] x_azure_fdids: A list of allowed Azure FrontDoor IDs in UUID notation with a maximum of 8.
        :param _builtins.str x_fd_health_probe: A list to allow the Azure FrontDoor health probe header. Only allowed value is `1`.
        :param Sequence[_builtins.str] x_forwarded_fors: A list of allowed 'X-Forwarded-For' IPs in CIDR notation with a maximum of 8.
        :param Sequence[_builtins.str] x_forwarded_hosts: A list of allowed 'X-Forwarded-Host' domains with a maximum of 8.
        """
        if x_azure_fdids is not None:
            pulumi.set(__self__, "x_azure_fdids", x_azure_fdids)
        if x_fd_health_probe is not None:
            pulumi.set(__self__, "x_fd_health_probe", x_fd_health_probe)
        if x_forwarded_fors is not None:
            pulumi.set(__self__, "x_forwarded_fors", x_forwarded_fors)
        if x_forwarded_hosts is not None:
            pulumi.set(__self__, "x_forwarded_hosts", x_forwarded_hosts)

    @_builtins.property
    @pulumi.getter(name="xAzureFdids")
    def x_azure_fdids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of allowed Azure FrontDoor IDs in UUID notation with a maximum of 8.
        """
        return pulumi.get(self, "x_azure_fdids")

    @_builtins.property
    @pulumi.getter(name="xFdHealthProbe")
    def x_fd_health_probe(self) -> Optional[_builtins.str]:
        """
        A list to allow the Azure FrontDoor health probe header. Only allowed value is `1`.
        """
        return pulumi.get(self, "x_fd_health_probe")

    @_builtins.property
    @pulumi.getter(name="xForwardedFors")
    def x_forwarded_fors(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of allowed 'X-Forwarded-For' IPs in CIDR notation with a maximum of 8.
        """
        return pulumi.get(self, "x_forwarded_fors")

    @_builtins.property
    @pulumi.getter(name="xForwardedHosts")
    def x_forwarded_hosts(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of allowed 'X-Forwarded-Host' domains with a maximum of 8.
        """
        return pulumi.get(self, "x_forwarded_hosts")


@pulumi.output_type
class StandardSiteCredential(dict):
    def __init__(__self__, *,
                 password: Optional[_builtins.str] = None,
                 username: Optional[_builtins.str] = None):
        """
        :param _builtins.str password: The password associated with the username, which can be used to publish to this App Service.
        :param _builtins.str username: The username which can be used to publish to this App Service.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def password(self) -> Optional[_builtins.str]:
        """
        The password associated with the username, which can be used to publish to this App Service.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def username(self) -> Optional[_builtins.str]:
        """
        The username which can be used to publish to this App Service.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class TriggerRecurrenceSchedule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "atTheseHours":
            suggest = "at_these_hours"
        elif key == "atTheseMinutes":
            suggest = "at_these_minutes"
        elif key == "onTheseDays":
            suggest = "on_these_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TriggerRecurrenceSchedule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TriggerRecurrenceSchedule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TriggerRecurrenceSchedule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 at_these_hours: Optional[Sequence[_builtins.int]] = None,
                 at_these_minutes: Optional[Sequence[_builtins.int]] = None,
                 on_these_days: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.int] at_these_hours: Specifies a list of hours when the trigger should run. Valid values are between 0 and 23.
        :param Sequence[_builtins.int] at_these_minutes: Specifies a list of minutes when the trigger should run. Valid values are between 0 and 59.
        :param Sequence[_builtins.str] on_these_days: Specifies a list of days when the trigger should run. Valid values include `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, and `Sunday`.
        """
        if at_these_hours is not None:
            pulumi.set(__self__, "at_these_hours", at_these_hours)
        if at_these_minutes is not None:
            pulumi.set(__self__, "at_these_minutes", at_these_minutes)
        if on_these_days is not None:
            pulumi.set(__self__, "on_these_days", on_these_days)

    @_builtins.property
    @pulumi.getter(name="atTheseHours")
    def at_these_hours(self) -> Optional[Sequence[_builtins.int]]:
        """
        Specifies a list of hours when the trigger should run. Valid values are between 0 and 23.
        """
        return pulumi.get(self, "at_these_hours")

    @_builtins.property
    @pulumi.getter(name="atTheseMinutes")
    def at_these_minutes(self) -> Optional[Sequence[_builtins.int]]:
        """
        Specifies a list of minutes when the trigger should run. Valid values are between 0 and 59.
        """
        return pulumi.get(self, "at_these_minutes")

    @_builtins.property
    @pulumi.getter(name="onTheseDays")
    def on_these_days(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of days when the trigger should run. Valid values include `Monday`, `Tuesday`, `Wednesday`, `Thursday`, `Friday`, `Saturday`, and `Sunday`.
        """
        return pulumi.get(self, "on_these_days")


@pulumi.output_type
class WorkflowAccessControl(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "workflowManagement":
            suggest = "workflow_management"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowAccessControl. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowAccessControl.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowAccessControl.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 action: Optional['outputs.WorkflowAccessControlAction'] = None,
                 content: Optional['outputs.WorkflowAccessControlContent'] = None,
                 trigger: Optional['outputs.WorkflowAccessControlTrigger'] = None,
                 workflow_management: Optional['outputs.WorkflowAccessControlWorkflowManagement'] = None):
        """
        :param 'WorkflowAccessControlActionArgs' action: A `action` block as defined below.
        :param 'WorkflowAccessControlContentArgs' content: A `content` block as defined below.
        :param 'WorkflowAccessControlTriggerArgs' trigger: A `trigger` block as defined below.
        :param 'WorkflowAccessControlWorkflowManagementArgs' workflow_management: A `workflow_management` block as defined below.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if content is not None:
            pulumi.set(__self__, "content", content)
        if trigger is not None:
            pulumi.set(__self__, "trigger", trigger)
        if workflow_management is not None:
            pulumi.set(__self__, "workflow_management", workflow_management)

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional['outputs.WorkflowAccessControlAction']:
        """
        A `action` block as defined below.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter
    def content(self) -> Optional['outputs.WorkflowAccessControlContent']:
        """
        A `content` block as defined below.
        """
        return pulumi.get(self, "content")

    @_builtins.property
    @pulumi.getter
    def trigger(self) -> Optional['outputs.WorkflowAccessControlTrigger']:
        """
        A `trigger` block as defined below.
        """
        return pulumi.get(self, "trigger")

    @_builtins.property
    @pulumi.getter(name="workflowManagement")
    def workflow_management(self) -> Optional['outputs.WorkflowAccessControlWorkflowManagement']:
        """
        A `workflow_management` block as defined below.
        """
        return pulumi.get(self, "workflow_management")


@pulumi.output_type
class WorkflowAccessControlAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedCallerIpAddressRanges":
            suggest = "allowed_caller_ip_address_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowAccessControlAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowAccessControlAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowAccessControlAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_caller_ip_address_ranges: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] allowed_caller_ip_address_ranges: A list of the allowed caller IP address ranges.
        """
        pulumi.set(__self__, "allowed_caller_ip_address_ranges", allowed_caller_ip_address_ranges)

    @_builtins.property
    @pulumi.getter(name="allowedCallerIpAddressRanges")
    def allowed_caller_ip_address_ranges(self) -> Sequence[_builtins.str]:
        """
        A list of the allowed caller IP address ranges.
        """
        return pulumi.get(self, "allowed_caller_ip_address_ranges")


@pulumi.output_type
class WorkflowAccessControlContent(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedCallerIpAddressRanges":
            suggest = "allowed_caller_ip_address_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowAccessControlContent. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowAccessControlContent.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowAccessControlContent.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_caller_ip_address_ranges: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] allowed_caller_ip_address_ranges: A list of the allowed caller IP address ranges.
        """
        pulumi.set(__self__, "allowed_caller_ip_address_ranges", allowed_caller_ip_address_ranges)

    @_builtins.property
    @pulumi.getter(name="allowedCallerIpAddressRanges")
    def allowed_caller_ip_address_ranges(self) -> Sequence[_builtins.str]:
        """
        A list of the allowed caller IP address ranges.
        """
        return pulumi.get(self, "allowed_caller_ip_address_ranges")


@pulumi.output_type
class WorkflowAccessControlTrigger(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedCallerIpAddressRanges":
            suggest = "allowed_caller_ip_address_ranges"
        elif key == "openAuthenticationPolicies":
            suggest = "open_authentication_policies"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowAccessControlTrigger. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowAccessControlTrigger.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowAccessControlTrigger.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_caller_ip_address_ranges: Optional[Sequence[_builtins.str]] = None,
                 open_authentication_policies: Optional[Sequence['outputs.WorkflowAccessControlTriggerOpenAuthenticationPolicy']] = None):
        """
        :param Sequence[_builtins.str] allowed_caller_ip_address_ranges: A list of the allowed caller IP address ranges.
        :param Sequence['WorkflowAccessControlTriggerOpenAuthenticationPolicyArgs'] open_authentication_policies: A `open_authentication_policy` block as defined below.
        """
        if allowed_caller_ip_address_ranges is not None:
            pulumi.set(__self__, "allowed_caller_ip_address_ranges", allowed_caller_ip_address_ranges)
        if open_authentication_policies is not None:
            pulumi.set(__self__, "open_authentication_policies", open_authentication_policies)

    @_builtins.property
    @pulumi.getter(name="allowedCallerIpAddressRanges")
    def allowed_caller_ip_address_ranges(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of the allowed caller IP address ranges.
        """
        return pulumi.get(self, "allowed_caller_ip_address_ranges")

    @_builtins.property
    @pulumi.getter(name="openAuthenticationPolicies")
    def open_authentication_policies(self) -> Optional[Sequence['outputs.WorkflowAccessControlTriggerOpenAuthenticationPolicy']]:
        """
        A `open_authentication_policy` block as defined below.
        """
        return pulumi.get(self, "open_authentication_policies")


@pulumi.output_type
class WorkflowAccessControlTriggerOpenAuthenticationPolicy(dict):
    def __init__(__self__, *,
                 claims: Sequence['outputs.WorkflowAccessControlTriggerOpenAuthenticationPolicyClaim'],
                 name: _builtins.str):
        """
        :param Sequence['WorkflowAccessControlTriggerOpenAuthenticationPolicyClaimArgs'] claims: A `claim` block as defined below.
        :param _builtins.str name: The OAuth policy name for the Logic App Workflow.
        """
        pulumi.set(__self__, "claims", claims)
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def claims(self) -> Sequence['outputs.WorkflowAccessControlTriggerOpenAuthenticationPolicyClaim']:
        """
        A `claim` block as defined below.
        """
        return pulumi.get(self, "claims")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The OAuth policy name for the Logic App Workflow.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class WorkflowAccessControlTriggerOpenAuthenticationPolicyClaim(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the OAuth policy claim for the Logic App Workflow.
        :param _builtins.str value: The value of the OAuth policy claim for the Logic App Workflow.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the OAuth policy claim for the Logic App Workflow.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        """
        The value of the OAuth policy claim for the Logic App Workflow.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class WorkflowAccessControlWorkflowManagement(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedCallerIpAddressRanges":
            suggest = "allowed_caller_ip_address_ranges"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowAccessControlWorkflowManagement. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowAccessControlWorkflowManagement.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowAccessControlWorkflowManagement.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_caller_ip_address_ranges: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] allowed_caller_ip_address_ranges: A list of the allowed caller IP address ranges.
        """
        pulumi.set(__self__, "allowed_caller_ip_address_ranges", allowed_caller_ip_address_ranges)

    @_builtins.property
    @pulumi.getter(name="allowedCallerIpAddressRanges")
    def allowed_caller_ip_address_ranges(self) -> Sequence[_builtins.str]:
        """
        A list of the allowed caller IP address ranges.
        """
        return pulumi.get(self, "allowed_caller_ip_address_ranges")


@pulumi.output_type
class WorkflowIdentity(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityIds":
            suggest = "identity_ids"
        elif key == "principalId":
            suggest = "principal_id"
        elif key == "tenantId":
            suggest = "tenant_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowIdentity. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowIdentity.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowIdentity.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: _builtins.str,
                 identity_ids: Optional[Sequence[_builtins.str]] = None,
                 principal_id: Optional[_builtins.str] = None,
                 tenant_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str type: Specifies the type of Managed Service Identity that should be configured on this Logic App Workflow. Possible values are `SystemAssigned`, `UserAssigned`.
        :param Sequence[_builtins.str] identity_ids: Specifies a list of User Assigned Managed Identity IDs to be assigned to this Logic App Workflow.
               
               > **Note:** This is required when `type` is set to `UserAssigned`
        :param _builtins.str principal_id: The Principal ID for the Service Principal associated with the Managed Service Identity of this Logic App Workflow.
        :param _builtins.str tenant_id: The Tenant ID for the Service Principal associated with the Managed Service Identity of this Logic App Workflow.
        """
        pulumi.set(__self__, "type", type)
        if identity_ids is not None:
            pulumi.set(__self__, "identity_ids", identity_ids)
        if principal_id is not None:
            pulumi.set(__self__, "principal_id", principal_id)
        if tenant_id is not None:
            pulumi.set(__self__, "tenant_id", tenant_id)

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Specifies the type of Managed Service Identity that should be configured on this Logic App Workflow. Possible values are `SystemAssigned`, `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        Specifies a list of User Assigned Managed Identity IDs to be assigned to this Logic App Workflow.

        > **Note:** This is required when `type` is set to `UserAssigned`
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> Optional[_builtins.str]:
        """
        The Principal ID for the Service Principal associated with the Managed Service Identity of this Logic App Workflow.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> Optional[_builtins.str]:
        """
        The Tenant ID for the Service Principal associated with the Managed Service Identity of this Logic App Workflow.
        """
        return pulumi.get(self, "tenant_id")


@pulumi.output_type
class GetStandardConnectionStringResult(dict):
    def __init__(__self__, *,
                 name: _builtins.str,
                 type: _builtins.str,
                 value: _builtins.str):
        """
        :param _builtins.str name: The name of the Logic App.
        :param _builtins.str type: The Type of Managed Identity assigned to this Logic App Workflow.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Logic App.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The Type of Managed Identity assigned to this Logic App Workflow.
        """
        return pulumi.get(self, "type")

    @_builtins.property
    @pulumi.getter
    def value(self) -> _builtins.str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetStandardIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[_builtins.str],
                 principal_id: _builtins.str,
                 tenant_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str principal_id: The Principal ID for the Service Principal associated with the Managed Service Identity of this Logic App Workflow.
        :param _builtins.str tenant_id: The Tenant ID for the Service Principal associated with the Managed Service Identity of this Logic App Workflow.
        :param _builtins.str type: The Type of Managed Identity assigned to this Logic App Workflow.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        """
        The Principal ID for the Service Principal associated with the Managed Service Identity of this Logic App Workflow.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        The Tenant ID for the Service Principal associated with the Managed Service Identity of this Logic App Workflow.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The Type of Managed Identity assigned to this Logic App Workflow.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetStandardSiteConfigResult(dict):
    def __init__(__self__, *,
                 app_scale_limit: _builtins.int,
                 auto_swap_slot_name: _builtins.str,
                 cors: 'outputs.GetStandardSiteConfigCorsResult',
                 elastic_instance_minimum: _builtins.int,
                 ftps_state: _builtins.str,
                 ip_restrictions: Sequence['outputs.GetStandardSiteConfigIpRestrictionResult'],
                 linux_fx_version: _builtins.str,
                 min_tls_version: _builtins.str,
                 pre_warmed_instance_count: _builtins.int,
                 public_network_access_enabled: _builtins.bool,
                 scm_ip_restrictions: Sequence['outputs.GetStandardSiteConfigScmIpRestrictionResult'],
                 scm_min_tls_version: _builtins.str,
                 scm_type: _builtins.str,
                 vnet_route_all_enabled: _builtins.bool,
                 always_on: Optional[_builtins.bool] = None,
                 dotnet_framework_version: Optional[_builtins.str] = None,
                 health_check_path: Optional[_builtins.str] = None,
                 http2_enabled: Optional[_builtins.bool] = None,
                 runtime_scale_monitoring_enabled: Optional[_builtins.bool] = None,
                 scm_use_main_ip_restriction: Optional[_builtins.bool] = None,
                 use32_bit_worker_process: Optional[_builtins.bool] = None,
                 websockets_enabled: Optional[_builtins.bool] = None):
        """
        :param _builtins.int app_scale_limit: The number of workers this Logic App can scale out to. Only applicable to apps on the Consumption and Premium plan.
        :param _builtins.str auto_swap_slot_name: The Auto-swap slot name.
        :param 'GetStandardSiteConfigCorsArgs' cors: A `cors` block as defined below.
        :param _builtins.int elastic_instance_minimum: The number of minimum instances for this Logic App Only affects apps on the Premium plan.
        :param _builtins.str ftps_state: The state of FTP / FTPS service for this Logic App.
        :param Sequence['GetStandardSiteConfigIpRestrictionArgs'] ip_restrictions: A list of `ip_restriction` objects representing IP restrictions as defined below.
        :param _builtins.str linux_fx_version: Linux App Framework and version for the Logic App.
        :param _builtins.str min_tls_version: The minimum supported TLS version for the Logic App.
        :param _builtins.int pre_warmed_instance_count: The number of pre-warmed instances for this Logic App Only affects apps on the Premium plan.
        :param Sequence['GetStandardSiteConfigScmIpRestrictionArgs'] scm_ip_restrictions: A list of `scm_ip_restriction` objects representing SCM IP restrictions as defined below.
        :param _builtins.str scm_min_tls_version: The minimum version of TLS required for SSL requests to the SCM site.
        :param _builtins.str scm_type: The type of Source Control used by the Logic App in use by the Windows Function App.
        :param _builtins.bool vnet_route_all_enabled: Should all outbound traffic to have Virtual Network Security Groups and User Defined Routes applied.
        :param _builtins.bool always_on: Should the Logic App be loaded at all times?
        :param _builtins.str dotnet_framework_version: The version of the .NET framework's CLR used in this Logic App.
        :param _builtins.str health_check_path: Path which will be checked for this Logic App health.
        :param _builtins.bool http2_enabled: Specifies whether the HTTP2 protocol should be enabled.
        :param _builtins.bool runtime_scale_monitoring_enabled: Should Runtime Scale Monitoring be enabled?. Only applicable to apps on the Premium plan.
        :param _builtins.bool scm_use_main_ip_restriction: Should the Logic App `ip_restriction` configuration be used for the SCM too.
        :param _builtins.bool use32_bit_worker_process: Should the Logic App run in 32 bit mode, rather than 64 bit mode?
        :param _builtins.bool websockets_enabled: Should WebSockets be enabled?
        """
        pulumi.set(__self__, "app_scale_limit", app_scale_limit)
        pulumi.set(__self__, "auto_swap_slot_name", auto_swap_slot_name)
        pulumi.set(__self__, "cors", cors)
        pulumi.set(__self__, "elastic_instance_minimum", elastic_instance_minimum)
        pulumi.set(__self__, "ftps_state", ftps_state)
        pulumi.set(__self__, "ip_restrictions", ip_restrictions)
        pulumi.set(__self__, "linux_fx_version", linux_fx_version)
        pulumi.set(__self__, "min_tls_version", min_tls_version)
        pulumi.set(__self__, "pre_warmed_instance_count", pre_warmed_instance_count)
        pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        pulumi.set(__self__, "scm_ip_restrictions", scm_ip_restrictions)
        pulumi.set(__self__, "scm_min_tls_version", scm_min_tls_version)
        pulumi.set(__self__, "scm_type", scm_type)
        pulumi.set(__self__, "vnet_route_all_enabled", vnet_route_all_enabled)
        if always_on is not None:
            pulumi.set(__self__, "always_on", always_on)
        if dotnet_framework_version is not None:
            pulumi.set(__self__, "dotnet_framework_version", dotnet_framework_version)
        if health_check_path is not None:
            pulumi.set(__self__, "health_check_path", health_check_path)
        if http2_enabled is not None:
            pulumi.set(__self__, "http2_enabled", http2_enabled)
        if runtime_scale_monitoring_enabled is not None:
            pulumi.set(__self__, "runtime_scale_monitoring_enabled", runtime_scale_monitoring_enabled)
        if scm_use_main_ip_restriction is not None:
            pulumi.set(__self__, "scm_use_main_ip_restriction", scm_use_main_ip_restriction)
        if use32_bit_worker_process is not None:
            pulumi.set(__self__, "use32_bit_worker_process", use32_bit_worker_process)
        if websockets_enabled is not None:
            pulumi.set(__self__, "websockets_enabled", websockets_enabled)

    @_builtins.property
    @pulumi.getter(name="appScaleLimit")
    def app_scale_limit(self) -> _builtins.int:
        """
        The number of workers this Logic App can scale out to. Only applicable to apps on the Consumption and Premium plan.
        """
        return pulumi.get(self, "app_scale_limit")

    @_builtins.property
    @pulumi.getter(name="autoSwapSlotName")
    def auto_swap_slot_name(self) -> _builtins.str:
        """
        The Auto-swap slot name.
        """
        return pulumi.get(self, "auto_swap_slot_name")

    @_builtins.property
    @pulumi.getter
    def cors(self) -> 'outputs.GetStandardSiteConfigCorsResult':
        """
        A `cors` block as defined below.
        """
        return pulumi.get(self, "cors")

    @_builtins.property
    @pulumi.getter(name="elasticInstanceMinimum")
    def elastic_instance_minimum(self) -> _builtins.int:
        """
        The number of minimum instances for this Logic App Only affects apps on the Premium plan.
        """
        return pulumi.get(self, "elastic_instance_minimum")

    @_builtins.property
    @pulumi.getter(name="ftpsState")
    def ftps_state(self) -> _builtins.str:
        """
        The state of FTP / FTPS service for this Logic App.
        """
        return pulumi.get(self, "ftps_state")

    @_builtins.property
    @pulumi.getter(name="ipRestrictions")
    def ip_restrictions(self) -> Sequence['outputs.GetStandardSiteConfigIpRestrictionResult']:
        """
        A list of `ip_restriction` objects representing IP restrictions as defined below.
        """
        return pulumi.get(self, "ip_restrictions")

    @_builtins.property
    @pulumi.getter(name="linuxFxVersion")
    def linux_fx_version(self) -> _builtins.str:
        """
        Linux App Framework and version for the Logic App.
        """
        return pulumi.get(self, "linux_fx_version")

    @_builtins.property
    @pulumi.getter(name="minTlsVersion")
    def min_tls_version(self) -> _builtins.str:
        """
        The minimum supported TLS version for the Logic App.
        """
        return pulumi.get(self, "min_tls_version")

    @_builtins.property
    @pulumi.getter(name="preWarmedInstanceCount")
    def pre_warmed_instance_count(self) -> _builtins.int:
        """
        The number of pre-warmed instances for this Logic App Only affects apps on the Premium plan.
        """
        return pulumi.get(self, "pre_warmed_instance_count")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    @_utilities.deprecated("""the `site_config.public_network_access_enabled` property has been superseded by the `public_network_access` property and will be removed in v5.0 of the AzureRM Provider.""")
    def public_network_access_enabled(self) -> _builtins.bool:
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="scmIpRestrictions")
    def scm_ip_restrictions(self) -> Sequence['outputs.GetStandardSiteConfigScmIpRestrictionResult']:
        """
        A list of `scm_ip_restriction` objects representing SCM IP restrictions as defined below.
        """
        return pulumi.get(self, "scm_ip_restrictions")

    @_builtins.property
    @pulumi.getter(name="scmMinTlsVersion")
    def scm_min_tls_version(self) -> _builtins.str:
        """
        The minimum version of TLS required for SSL requests to the SCM site.
        """
        return pulumi.get(self, "scm_min_tls_version")

    @_builtins.property
    @pulumi.getter(name="scmType")
    def scm_type(self) -> _builtins.str:
        """
        The type of Source Control used by the Logic App in use by the Windows Function App.
        """
        return pulumi.get(self, "scm_type")

    @_builtins.property
    @pulumi.getter(name="vnetRouteAllEnabled")
    def vnet_route_all_enabled(self) -> _builtins.bool:
        """
        Should all outbound traffic to have Virtual Network Security Groups and User Defined Routes applied.
        """
        return pulumi.get(self, "vnet_route_all_enabled")

    @_builtins.property
    @pulumi.getter(name="alwaysOn")
    def always_on(self) -> Optional[_builtins.bool]:
        """
        Should the Logic App be loaded at all times?
        """
        return pulumi.get(self, "always_on")

    @_builtins.property
    @pulumi.getter(name="dotnetFrameworkVersion")
    def dotnet_framework_version(self) -> Optional[_builtins.str]:
        """
        The version of the .NET framework's CLR used in this Logic App.
        """
        return pulumi.get(self, "dotnet_framework_version")

    @_builtins.property
    @pulumi.getter(name="healthCheckPath")
    def health_check_path(self) -> Optional[_builtins.str]:
        """
        Path which will be checked for this Logic App health.
        """
        return pulumi.get(self, "health_check_path")

    @_builtins.property
    @pulumi.getter(name="http2Enabled")
    def http2_enabled(self) -> Optional[_builtins.bool]:
        """
        Specifies whether the HTTP2 protocol should be enabled.
        """
        return pulumi.get(self, "http2_enabled")

    @_builtins.property
    @pulumi.getter(name="runtimeScaleMonitoringEnabled")
    def runtime_scale_monitoring_enabled(self) -> Optional[_builtins.bool]:
        """
        Should Runtime Scale Monitoring be enabled?. Only applicable to apps on the Premium plan.
        """
        return pulumi.get(self, "runtime_scale_monitoring_enabled")

    @_builtins.property
    @pulumi.getter(name="scmUseMainIpRestriction")
    def scm_use_main_ip_restriction(self) -> Optional[_builtins.bool]:
        """
        Should the Logic App `ip_restriction` configuration be used for the SCM too.
        """
        return pulumi.get(self, "scm_use_main_ip_restriction")

    @_builtins.property
    @pulumi.getter(name="use32BitWorkerProcess")
    def use32_bit_worker_process(self) -> Optional[_builtins.bool]:
        """
        Should the Logic App run in 32 bit mode, rather than 64 bit mode?
        """
        return pulumi.get(self, "use32_bit_worker_process")

    @_builtins.property
    @pulumi.getter(name="websocketsEnabled")
    def websockets_enabled(self) -> Optional[_builtins.bool]:
        """
        Should WebSockets be enabled?
        """
        return pulumi.get(self, "websockets_enabled")


@pulumi.output_type
class GetStandardSiteConfigCorsResult(dict):
    def __init__(__self__, *,
                 allowed_origins: Sequence[_builtins.str],
                 support_credentials: Optional[_builtins.bool] = None):
        """
        :param Sequence[_builtins.str] allowed_origins: A list of origins which should be able to make cross-origin calls.
        :param _builtins.bool support_credentials: Are credentials supported?
        """
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if support_credentials is not None:
            pulumi.set(__self__, "support_credentials", support_credentials)

    @_builtins.property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[_builtins.str]:
        """
        A list of origins which should be able to make cross-origin calls.
        """
        return pulumi.get(self, "allowed_origins")

    @_builtins.property
    @pulumi.getter(name="supportCredentials")
    def support_credentials(self) -> Optional[_builtins.bool]:
        """
        Are credentials supported?
        """
        return pulumi.get(self, "support_credentials")


@pulumi.output_type
class GetStandardSiteConfigIpRestrictionResult(dict):
    def __init__(__self__, *,
                 headers: 'outputs.GetStandardSiteConfigIpRestrictionHeadersResult',
                 name: _builtins.str,
                 action: Optional[_builtins.str] = None,
                 ip_address: Optional[_builtins.str] = None,
                 priority: Optional[_builtins.int] = None,
                 service_tag: Optional[_builtins.str] = None,
                 virtual_network_subnet_id: Optional[_builtins.str] = None):
        """
        :param 'GetStandardSiteConfigIpRestrictionHeadersArgs' headers: The `headers` block for this specific `ip_restriction` as defined below.
        :param _builtins.str name: The name of the Logic App.
        :param _builtins.str action: Does this restriction `Allow` or `Deny` access for this IP range.
        :param _builtins.str ip_address: The IP Address used for this IP Restriction in CIDR notation.
        :param _builtins.int priority: The priority for this IP Restriction. Restrictions are enforced in priority order.
        :param _builtins.str service_tag: The Service Tag used for this IP Restriction.
        :param _builtins.str virtual_network_subnet_id: The Virtual Network Subnet ID used for this IP Restriction.
        """
        pulumi.set(__self__, "headers", headers)
        pulumi.set(__self__, "name", name)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if service_tag is not None:
            pulumi.set(__self__, "service_tag", service_tag)
        if virtual_network_subnet_id is not None:
            pulumi.set(__self__, "virtual_network_subnet_id", virtual_network_subnet_id)

    @_builtins.property
    @pulumi.getter
    def headers(self) -> 'outputs.GetStandardSiteConfigIpRestrictionHeadersResult':
        """
        The `headers` block for this specific `ip_restriction` as defined below.
        """
        return pulumi.get(self, "headers")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Logic App.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        """
        Does this restriction `Allow` or `Deny` access for this IP range.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        The IP Address used for this IP Restriction in CIDR notation.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.int]:
        """
        The priority for this IP Restriction. Restrictions are enforced in priority order.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="serviceTag")
    def service_tag(self) -> Optional[_builtins.str]:
        """
        The Service Tag used for this IP Restriction.
        """
        return pulumi.get(self, "service_tag")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkSubnetId")
    def virtual_network_subnet_id(self) -> Optional[_builtins.str]:
        """
        The Virtual Network Subnet ID used for this IP Restriction.
        """
        return pulumi.get(self, "virtual_network_subnet_id")


@pulumi.output_type
class GetStandardSiteConfigIpRestrictionHeadersResult(dict):
    def __init__(__self__, *,
                 x_azure_fdids: Optional[Sequence[_builtins.str]] = None,
                 x_fd_health_probe: Optional[_builtins.str] = None,
                 x_forwarded_fors: Optional[Sequence[_builtins.str]] = None,
                 x_forwarded_hosts: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] x_azure_fdids: A list of allowed Azure FrontDoor IDs in UUID notation.
        :param _builtins.str x_fd_health_probe: A list to allow the Azure FrontDoor health probe header.
        :param Sequence[_builtins.str] x_forwarded_fors: A list of allowed 'X-Forwarded-For' IPs in CIDR notation.
        :param Sequence[_builtins.str] x_forwarded_hosts: A list of allowed 'X-Forwarded-Host' domains.
        """
        if x_azure_fdids is not None:
            pulumi.set(__self__, "x_azure_fdids", x_azure_fdids)
        if x_fd_health_probe is not None:
            pulumi.set(__self__, "x_fd_health_probe", x_fd_health_probe)
        if x_forwarded_fors is not None:
            pulumi.set(__self__, "x_forwarded_fors", x_forwarded_fors)
        if x_forwarded_hosts is not None:
            pulumi.set(__self__, "x_forwarded_hosts", x_forwarded_hosts)

    @_builtins.property
    @pulumi.getter(name="xAzureFdids")
    def x_azure_fdids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of allowed Azure FrontDoor IDs in UUID notation.
        """
        return pulumi.get(self, "x_azure_fdids")

    @_builtins.property
    @pulumi.getter(name="xFdHealthProbe")
    def x_fd_health_probe(self) -> Optional[_builtins.str]:
        """
        A list to allow the Azure FrontDoor health probe header.
        """
        return pulumi.get(self, "x_fd_health_probe")

    @_builtins.property
    @pulumi.getter(name="xForwardedFors")
    def x_forwarded_fors(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of allowed 'X-Forwarded-For' IPs in CIDR notation.
        """
        return pulumi.get(self, "x_forwarded_fors")

    @_builtins.property
    @pulumi.getter(name="xForwardedHosts")
    def x_forwarded_hosts(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of allowed 'X-Forwarded-Host' domains.
        """
        return pulumi.get(self, "x_forwarded_hosts")


@pulumi.output_type
class GetStandardSiteConfigScmIpRestrictionResult(dict):
    def __init__(__self__, *,
                 headers: 'outputs.GetStandardSiteConfigScmIpRestrictionHeadersResult',
                 name: _builtins.str,
                 action: Optional[_builtins.str] = None,
                 ip_address: Optional[_builtins.str] = None,
                 priority: Optional[_builtins.int] = None,
                 service_tag: Optional[_builtins.str] = None,
                 virtual_network_subnet_id: Optional[_builtins.str] = None):
        """
        :param 'GetStandardSiteConfigScmIpRestrictionHeadersArgs' headers: The `headers` block for this specific `ip_restriction` as defined below.
        :param _builtins.str name: The name of the Logic App.
        :param _builtins.str action: Does this restriction `Allow` or `Deny` access for this IP range.
        :param _builtins.str ip_address: The IP Address used for this IP Restriction in CIDR notation.
        :param _builtins.int priority: The priority for this IP Restriction. Restrictions are enforced in priority order.
        :param _builtins.str service_tag: The Service Tag used for this IP Restriction.
        :param _builtins.str virtual_network_subnet_id: The Virtual Network Subnet ID used for this IP Restriction.
        """
        pulumi.set(__self__, "headers", headers)
        pulumi.set(__self__, "name", name)
        if action is not None:
            pulumi.set(__self__, "action", action)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if priority is not None:
            pulumi.set(__self__, "priority", priority)
        if service_tag is not None:
            pulumi.set(__self__, "service_tag", service_tag)
        if virtual_network_subnet_id is not None:
            pulumi.set(__self__, "virtual_network_subnet_id", virtual_network_subnet_id)

    @_builtins.property
    @pulumi.getter
    def headers(self) -> 'outputs.GetStandardSiteConfigScmIpRestrictionHeadersResult':
        """
        The `headers` block for this specific `ip_restriction` as defined below.
        """
        return pulumi.get(self, "headers")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The name of the Logic App.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def action(self) -> Optional[_builtins.str]:
        """
        Does this restriction `Allow` or `Deny` access for this IP range.
        """
        return pulumi.get(self, "action")

    @_builtins.property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[_builtins.str]:
        """
        The IP Address used for this IP Restriction in CIDR notation.
        """
        return pulumi.get(self, "ip_address")

    @_builtins.property
    @pulumi.getter
    def priority(self) -> Optional[_builtins.int]:
        """
        The priority for this IP Restriction. Restrictions are enforced in priority order.
        """
        return pulumi.get(self, "priority")

    @_builtins.property
    @pulumi.getter(name="serviceTag")
    def service_tag(self) -> Optional[_builtins.str]:
        """
        The Service Tag used for this IP Restriction.
        """
        return pulumi.get(self, "service_tag")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkSubnetId")
    def virtual_network_subnet_id(self) -> Optional[_builtins.str]:
        """
        The Virtual Network Subnet ID used for this IP Restriction.
        """
        return pulumi.get(self, "virtual_network_subnet_id")


@pulumi.output_type
class GetStandardSiteConfigScmIpRestrictionHeadersResult(dict):
    def __init__(__self__, *,
                 x_azure_fdids: Optional[Sequence[_builtins.str]] = None,
                 x_fd_health_probe: Optional[_builtins.str] = None,
                 x_forwarded_fors: Optional[Sequence[_builtins.str]] = None,
                 x_forwarded_hosts: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] x_azure_fdids: A list of allowed Azure FrontDoor IDs in UUID notation.
        :param _builtins.str x_fd_health_probe: A list to allow the Azure FrontDoor health probe header.
        :param Sequence[_builtins.str] x_forwarded_fors: A list of allowed 'X-Forwarded-For' IPs in CIDR notation.
        :param Sequence[_builtins.str] x_forwarded_hosts: A list of allowed 'X-Forwarded-Host' domains.
        """
        if x_azure_fdids is not None:
            pulumi.set(__self__, "x_azure_fdids", x_azure_fdids)
        if x_fd_health_probe is not None:
            pulumi.set(__self__, "x_fd_health_probe", x_fd_health_probe)
        if x_forwarded_fors is not None:
            pulumi.set(__self__, "x_forwarded_fors", x_forwarded_fors)
        if x_forwarded_hosts is not None:
            pulumi.set(__self__, "x_forwarded_hosts", x_forwarded_hosts)

    @_builtins.property
    @pulumi.getter(name="xAzureFdids")
    def x_azure_fdids(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of allowed Azure FrontDoor IDs in UUID notation.
        """
        return pulumi.get(self, "x_azure_fdids")

    @_builtins.property
    @pulumi.getter(name="xFdHealthProbe")
    def x_fd_health_probe(self) -> Optional[_builtins.str]:
        """
        A list to allow the Azure FrontDoor health probe header.
        """
        return pulumi.get(self, "x_fd_health_probe")

    @_builtins.property
    @pulumi.getter(name="xForwardedFors")
    def x_forwarded_fors(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of allowed 'X-Forwarded-For' IPs in CIDR notation.
        """
        return pulumi.get(self, "x_forwarded_fors")

    @_builtins.property
    @pulumi.getter(name="xForwardedHosts")
    def x_forwarded_hosts(self) -> Optional[Sequence[_builtins.str]]:
        """
        A list of allowed 'X-Forwarded-Host' domains.
        """
        return pulumi.get(self, "x_forwarded_hosts")


@pulumi.output_type
class GetStandardSiteCredentialResult(dict):
    def __init__(__self__, *,
                 password: _builtins.str,
                 username: _builtins.str):
        """
        :param _builtins.str password: The password associated with the username, which can be used to publish to this Logic App.
        :param _builtins.str username: The username which can be used to publish to this Logic App.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @_builtins.property
    @pulumi.getter
    def password(self) -> _builtins.str:
        """
        The password associated with the username, which can be used to publish to this Logic App.
        """
        return pulumi.get(self, "password")

    @_builtins.property
    @pulumi.getter
    def username(self) -> _builtins.str:
        """
        The username which can be used to publish to this Logic App.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class GetWorkflowIdentityResult(dict):
    def __init__(__self__, *,
                 identity_ids: Sequence[_builtins.str],
                 principal_id: _builtins.str,
                 tenant_id: _builtins.str,
                 type: _builtins.str):
        """
        :param Sequence[_builtins.str] identity_ids: The list of User Assigned Managed Identity IDs assigned to this Logic App Workflow.
        :param _builtins.str principal_id: The Principal ID of the System Assigned Managed Service Identity that is configured on this Logic App Workflow.
        :param _builtins.str tenant_id: The Tenant ID of the System Assigned Managed Service Identity that is configured on this Logic App Workflow.
        :param _builtins.str type: The type of Managed Service Identity that is configured on this Logic App Workflow.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "principal_id", principal_id)
        pulumi.set(__self__, "tenant_id", tenant_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> Sequence[_builtins.str]:
        """
        The list of User Assigned Managed Identity IDs assigned to this Logic App Workflow.
        """
        return pulumi.get(self, "identity_ids")

    @_builtins.property
    @pulumi.getter(name="principalId")
    def principal_id(self) -> _builtins.str:
        """
        The Principal ID of the System Assigned Managed Service Identity that is configured on this Logic App Workflow.
        """
        return pulumi.get(self, "principal_id")

    @_builtins.property
    @pulumi.getter(name="tenantId")
    def tenant_id(self) -> _builtins.str:
        """
        The Tenant ID of the System Assigned Managed Service Identity that is configured on this Logic App Workflow.
        """
        return pulumi.get(self, "tenant_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        The type of Managed Service Identity that is configured on this Logic App Workflow.
        """
        return pulumi.get(self, "type")


