# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['StandardArgs', 'Standard']

@pulumi.input_type
class StandardArgs:
    def __init__(__self__, *,
                 app_service_plan_id: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 storage_account_access_key: pulumi.Input[_builtins.str],
                 storage_account_name: pulumi.Input[_builtins.str],
                 app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 bundle_version: Optional[pulumi.Input[_builtins.str]] = None,
                 client_affinity_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_certificate_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input['StandardConnectionStringArgs']]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ftp_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 https_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['StandardIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 scm_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 site_config: Optional[pulumi.Input['StandardSiteConfigArgs']] = None,
                 storage_account_share_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 use_extension_bundle: Optional[pulumi.Input[_builtins.bool]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_network_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vnet_content_share_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Standard resource.
        :param pulumi.Input[_builtins.str] app_service_plan_id: The ID of the App Service Plan within which to create this Logic App.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Logic App. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_account_access_key: The access key which will be used to access the backend storage account for the Logic App.
        :param pulumi.Input[_builtins.str] storage_account_name: The backend storage account name which will be used by this Logic App (e.g. for Stateful workflows data). Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] app_settings: A map of key-value pairs for [App Settings](https://docs.microsoft.com/azure/azure-functions/functions-app-settings) and custom values.
               
               > **Note:** There are a number of application settings that will be managed for you by this resource type and *shouldn't* be configured separately as part of the app_settings you specify.  `AzureWebJobsStorage` is filled based on `storage_account_name` and `storage_account_access_key`. `WEBSITE_CONTENTSHARE` is detailed below. `FUNCTIONS_EXTENSION_VERSION` is filled based on `version`. `APP_KIND` is set to workflowApp and `AzureFunctionsJobHost__extensionBundle__id` and `AzureFunctionsJobHost__extensionBundle__version` are set as detailed below.
        :param pulumi.Input[_builtins.str] bundle_version: If `use_extension_bundle` is set to `true` this controls the allowed range for bundle versions. Defaults to `[1.*, 2.0.0)`.
        :param pulumi.Input[_builtins.bool] client_affinity_enabled: Should the Logic App send session affinity cookies, which route client requests in the same session to the same instance?
        :param pulumi.Input[_builtins.str] client_certificate_mode: The mode of the Logic App's client certificates requirement for incoming requests. Possible values are `Required` and `Optional`.
        :param pulumi.Input[Sequence[pulumi.Input['StandardConnectionStringArgs']]] connection_strings: A `connection_string` block as defined below.
        :param pulumi.Input[_builtins.bool] enabled: Is the Logic App enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] ftp_publish_basic_authentication_enabled: Whether the FTP basic authentication publishing profile is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] https_only: Can the Logic App only be accessed via HTTPS? Defaults to `false`.
        :param pulumi.Input['StandardIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Logic App. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] public_network_access: Whether Public Network Access should be enabled or not. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.
               
               > **Note:** Setting this property will also set it in the Site Config.
        :param pulumi.Input[_builtins.bool] scm_publish_basic_authentication_enabled: Whether the default SCM basic authentication publishing profile is enabled. Defaults to `true`.
        :param pulumi.Input['StandardSiteConfigArgs'] site_config: A `site_config` object as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.bool] use_extension_bundle: Should the logic app use the bundled extension package? If true, then application settings for `AzureFunctionsJobHost__extensionBundle__id` and `AzureFunctionsJobHost__extensionBundle__version` will be created. Defaults to `true`.
        :param pulumi.Input[_builtins.str] version: The runtime version associated with the Logic App. Defaults to `~4`.
        :param pulumi.Input[_builtins.bool] vnet_content_share_enabled: Specifies whether allow routing traffic between the Logic App and Storage Account content share through a virtual network. Defaults to `false`.
        """
        pulumi.set(__self__, "app_service_plan_id", app_service_plan_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "storage_account_access_key", storage_account_access_key)
        pulumi.set(__self__, "storage_account_name", storage_account_name)
        if app_settings is not None:
            pulumi.set(__self__, "app_settings", app_settings)
        if bundle_version is not None:
            pulumi.set(__self__, "bundle_version", bundle_version)
        if client_affinity_enabled is not None:
            pulumi.set(__self__, "client_affinity_enabled", client_affinity_enabled)
        if client_certificate_mode is not None:
            pulumi.set(__self__, "client_certificate_mode", client_certificate_mode)
        if connection_strings is not None:
            pulumi.set(__self__, "connection_strings", connection_strings)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ftp_publish_basic_authentication_enabled is not None:
            pulumi.set(__self__, "ftp_publish_basic_authentication_enabled", ftp_publish_basic_authentication_enabled)
        if https_only is not None:
            pulumi.set(__self__, "https_only", https_only)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if scm_publish_basic_authentication_enabled is not None:
            pulumi.set(__self__, "scm_publish_basic_authentication_enabled", scm_publish_basic_authentication_enabled)
        if site_config is not None:
            pulumi.set(__self__, "site_config", site_config)
        if storage_account_share_name is not None:
            pulumi.set(__self__, "storage_account_share_name", storage_account_share_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if use_extension_bundle is not None:
            pulumi.set(__self__, "use_extension_bundle", use_extension_bundle)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if virtual_network_subnet_id is not None:
            pulumi.set(__self__, "virtual_network_subnet_id", virtual_network_subnet_id)
        if vnet_content_share_enabled is not None:
            pulumi.set(__self__, "vnet_content_share_enabled", vnet_content_share_enabled)

    @_builtins.property
    @pulumi.getter(name="appServicePlanId")
    def app_service_plan_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the App Service Plan within which to create this Logic App.
        """
        return pulumi.get(self, "app_service_plan_id")

    @app_service_plan_id.setter
    def app_service_plan_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "app_service_plan_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the Logic App. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> pulumi.Input[_builtins.str]:
        """
        The access key which will be used to access the backend storage account for the Logic App.
        """
        return pulumi.get(self, "storage_account_access_key")

    @storage_account_access_key.setter
    def storage_account_access_key(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_account_access_key", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> pulumi.Input[_builtins.str]:
        """
        The backend storage account name which will be used by this Logic App (e.g. for Stateful workflows data). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_name")

    @storage_account_name.setter
    def storage_account_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_account_name", value)

    @_builtins.property
    @pulumi.getter(name="appSettings")
    def app_settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of key-value pairs for [App Settings](https://docs.microsoft.com/azure/azure-functions/functions-app-settings) and custom values.

        > **Note:** There are a number of application settings that will be managed for you by this resource type and *shouldn't* be configured separately as part of the app_settings you specify.  `AzureWebJobsStorage` is filled based on `storage_account_name` and `storage_account_access_key`. `WEBSITE_CONTENTSHARE` is detailed below. `FUNCTIONS_EXTENSION_VERSION` is filled based on `version`. `APP_KIND` is set to workflowApp and `AzureFunctionsJobHost__extensionBundle__id` and `AzureFunctionsJobHost__extensionBundle__version` are set as detailed below.
        """
        return pulumi.get(self, "app_settings")

    @app_settings.setter
    def app_settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "app_settings", value)

    @_builtins.property
    @pulumi.getter(name="bundleVersion")
    def bundle_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If `use_extension_bundle` is set to `true` this controls the allowed range for bundle versions. Defaults to `[1.*, 2.0.0)`.
        """
        return pulumi.get(self, "bundle_version")

    @bundle_version.setter
    def bundle_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bundle_version", value)

    @_builtins.property
    @pulumi.getter(name="clientAffinityEnabled")
    def client_affinity_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Logic App send session affinity cookies, which route client requests in the same session to the same instance?
        """
        return pulumi.get(self, "client_affinity_enabled")

    @client_affinity_enabled.setter
    def client_affinity_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "client_affinity_enabled", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificateMode")
    def client_certificate_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode of the Logic App's client certificates requirement for incoming requests. Possible values are `Required` and `Optional`.
        """
        return pulumi.get(self, "client_certificate_mode")

    @client_certificate_mode.setter
    def client_certificate_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_certificate_mode", value)

    @_builtins.property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StandardConnectionStringArgs']]]]:
        """
        A `connection_string` block as defined below.
        """
        return pulumi.get(self, "connection_strings")

    @connection_strings.setter
    def connection_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StandardConnectionStringArgs']]]]):
        pulumi.set(self, "connection_strings", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the Logic App enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="ftpPublishBasicAuthenticationEnabled")
    def ftp_publish_basic_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the FTP basic authentication publishing profile is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "ftp_publish_basic_authentication_enabled")

    @ftp_publish_basic_authentication_enabled.setter
    def ftp_publish_basic_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ftp_publish_basic_authentication_enabled", value)

    @_builtins.property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Can the Logic App only be accessed via HTTPS? Defaults to `false`.
        """
        return pulumi.get(self, "https_only")

    @https_only.setter
    def https_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "https_only", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['StandardIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['StandardIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Logic App. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether Public Network Access should be enabled or not. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.

        > **Note:** Setting this property will also set it in the Site Config.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_network_access", value)

    @_builtins.property
    @pulumi.getter(name="scmPublishBasicAuthenticationEnabled")
    def scm_publish_basic_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the default SCM basic authentication publishing profile is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "scm_publish_basic_authentication_enabled")

    @scm_publish_basic_authentication_enabled.setter
    def scm_publish_basic_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "scm_publish_basic_authentication_enabled", value)

    @_builtins.property
    @pulumi.getter(name="siteConfig")
    def site_config(self) -> Optional[pulumi.Input['StandardSiteConfigArgs']]:
        """
        A `site_config` object as defined below.
        """
        return pulumi.get(self, "site_config")

    @site_config.setter
    def site_config(self, value: Optional[pulumi.Input['StandardSiteConfigArgs']]):
        pulumi.set(self, "site_config", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountShareName")
    def storage_account_share_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "storage_account_share_name")

    @storage_account_share_name.setter
    def storage_account_share_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_share_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="useExtensionBundle")
    def use_extension_bundle(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the logic app use the bundled extension package? If true, then application settings for `AzureFunctionsJobHost__extensionBundle__id` and `AzureFunctionsJobHost__extensionBundle__version` will be created. Defaults to `true`.
        """
        return pulumi.get(self, "use_extension_bundle")

    @use_extension_bundle.setter
    def use_extension_bundle(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_extension_bundle", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The runtime version associated with the Logic App. Defaults to `~4`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkSubnetId")
    def virtual_network_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "virtual_network_subnet_id")

    @virtual_network_subnet_id.setter
    def virtual_network_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="vnetContentShareEnabled")
    def vnet_content_share_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether allow routing traffic between the Logic App and Storage Account content share through a virtual network. Defaults to `false`.
        """
        return pulumi.get(self, "vnet_content_share_enabled")

    @vnet_content_share_enabled.setter
    def vnet_content_share_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "vnet_content_share_enabled", value)


@pulumi.input_type
class _StandardState:
    def __init__(__self__, *,
                 app_service_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 bundle_version: Optional[pulumi.Input[_builtins.str]] = None,
                 client_affinity_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_certificate_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input['StandardConnectionStringArgs']]]] = None,
                 custom_domain_verification_id: Optional[pulumi.Input[_builtins.str]] = None,
                 default_hostname: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ftp_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 https_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['StandardIdentityArgs']] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 outbound_ip_addresses: Optional[pulumi.Input[_builtins.str]] = None,
                 possible_outbound_ip_addresses: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scm_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 site_config: Optional[pulumi.Input['StandardSiteConfigArgs']] = None,
                 site_credentials: Optional[pulumi.Input[Sequence[pulumi.Input['StandardSiteCredentialArgs']]]] = None,
                 storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_share_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 use_extension_bundle: Optional[pulumi.Input[_builtins.bool]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_network_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vnet_content_share_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering Standard resources.
        :param pulumi.Input[_builtins.str] app_service_plan_id: The ID of the App Service Plan within which to create this Logic App.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] app_settings: A map of key-value pairs for [App Settings](https://docs.microsoft.com/azure/azure-functions/functions-app-settings) and custom values.
               
               > **Note:** There are a number of application settings that will be managed for you by this resource type and *shouldn't* be configured separately as part of the app_settings you specify.  `AzureWebJobsStorage` is filled based on `storage_account_name` and `storage_account_access_key`. `WEBSITE_CONTENTSHARE` is detailed below. `FUNCTIONS_EXTENSION_VERSION` is filled based on `version`. `APP_KIND` is set to workflowApp and `AzureFunctionsJobHost__extensionBundle__id` and `AzureFunctionsJobHost__extensionBundle__version` are set as detailed below.
        :param pulumi.Input[_builtins.str] bundle_version: If `use_extension_bundle` is set to `true` this controls the allowed range for bundle versions. Defaults to `[1.*, 2.0.0)`.
        :param pulumi.Input[_builtins.bool] client_affinity_enabled: Should the Logic App send session affinity cookies, which route client requests in the same session to the same instance?
        :param pulumi.Input[_builtins.str] client_certificate_mode: The mode of the Logic App's client certificates requirement for incoming requests. Possible values are `Required` and `Optional`.
        :param pulumi.Input[Sequence[pulumi.Input['StandardConnectionStringArgs']]] connection_strings: A `connection_string` block as defined below.
        :param pulumi.Input[_builtins.str] custom_domain_verification_id: An identifier used by App Service to perform domain ownership verification via DNS TXT record.
        :param pulumi.Input[_builtins.str] default_hostname: The default hostname associated with the Logic App - such as `mysite.azurewebsites.net`.
        :param pulumi.Input[_builtins.bool] enabled: Is the Logic App enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] ftp_publish_basic_authentication_enabled: Whether the FTP basic authentication publishing profile is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] https_only: Can the Logic App only be accessed via HTTPS? Defaults to `false`.
        :param pulumi.Input['StandardIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] kind: The Logic App kind.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Logic App. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] outbound_ip_addresses: A comma separated list of outbound IP addresses - such as `52.23.25.3,52.143.43.12`.
        :param pulumi.Input[_builtins.str] possible_outbound_ip_addresses: A comma separated list of outbound IP addresses - such as `52.23.25.3,52.143.43.12,52.143.43.17` - not all of which are necessarily in use. Superset of `outbound_ip_addresses`.
        :param pulumi.Input[_builtins.str] public_network_access: Whether Public Network Access should be enabled or not. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.
               
               > **Note:** Setting this property will also set it in the Site Config.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Logic App. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] scm_publish_basic_authentication_enabled: Whether the default SCM basic authentication publishing profile is enabled. Defaults to `true`.
        :param pulumi.Input['StandardSiteConfigArgs'] site_config: A `site_config` object as defined below.
        :param pulumi.Input[Sequence[pulumi.Input['StandardSiteCredentialArgs']]] site_credentials: A `site_credential` block as defined below, which contains the site-level credentials used to publish to this App Service.
        :param pulumi.Input[_builtins.str] storage_account_access_key: The access key which will be used to access the backend storage account for the Logic App.
        :param pulumi.Input[_builtins.str] storage_account_name: The backend storage account name which will be used by this Logic App (e.g. for Stateful workflows data). Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.bool] use_extension_bundle: Should the logic app use the bundled extension package? If true, then application settings for `AzureFunctionsJobHost__extensionBundle__id` and `AzureFunctionsJobHost__extensionBundle__version` will be created. Defaults to `true`.
        :param pulumi.Input[_builtins.str] version: The runtime version associated with the Logic App. Defaults to `~4`.
        :param pulumi.Input[_builtins.bool] vnet_content_share_enabled: Specifies whether allow routing traffic between the Logic App and Storage Account content share through a virtual network. Defaults to `false`.
        """
        if app_service_plan_id is not None:
            pulumi.set(__self__, "app_service_plan_id", app_service_plan_id)
        if app_settings is not None:
            pulumi.set(__self__, "app_settings", app_settings)
        if bundle_version is not None:
            pulumi.set(__self__, "bundle_version", bundle_version)
        if client_affinity_enabled is not None:
            pulumi.set(__self__, "client_affinity_enabled", client_affinity_enabled)
        if client_certificate_mode is not None:
            pulumi.set(__self__, "client_certificate_mode", client_certificate_mode)
        if connection_strings is not None:
            pulumi.set(__self__, "connection_strings", connection_strings)
        if custom_domain_verification_id is not None:
            pulumi.set(__self__, "custom_domain_verification_id", custom_domain_verification_id)
        if default_hostname is not None:
            pulumi.set(__self__, "default_hostname", default_hostname)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if ftp_publish_basic_authentication_enabled is not None:
            pulumi.set(__self__, "ftp_publish_basic_authentication_enabled", ftp_publish_basic_authentication_enabled)
        if https_only is not None:
            pulumi.set(__self__, "https_only", https_only)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if outbound_ip_addresses is not None:
            pulumi.set(__self__, "outbound_ip_addresses", outbound_ip_addresses)
        if possible_outbound_ip_addresses is not None:
            pulumi.set(__self__, "possible_outbound_ip_addresses", possible_outbound_ip_addresses)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if scm_publish_basic_authentication_enabled is not None:
            pulumi.set(__self__, "scm_publish_basic_authentication_enabled", scm_publish_basic_authentication_enabled)
        if site_config is not None:
            pulumi.set(__self__, "site_config", site_config)
        if site_credentials is not None:
            pulumi.set(__self__, "site_credentials", site_credentials)
        if storage_account_access_key is not None:
            pulumi.set(__self__, "storage_account_access_key", storage_account_access_key)
        if storage_account_name is not None:
            pulumi.set(__self__, "storage_account_name", storage_account_name)
        if storage_account_share_name is not None:
            pulumi.set(__self__, "storage_account_share_name", storage_account_share_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if use_extension_bundle is not None:
            pulumi.set(__self__, "use_extension_bundle", use_extension_bundle)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if virtual_network_subnet_id is not None:
            pulumi.set(__self__, "virtual_network_subnet_id", virtual_network_subnet_id)
        if vnet_content_share_enabled is not None:
            pulumi.set(__self__, "vnet_content_share_enabled", vnet_content_share_enabled)

    @_builtins.property
    @pulumi.getter(name="appServicePlanId")
    def app_service_plan_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the App Service Plan within which to create this Logic App.
        """
        return pulumi.get(self, "app_service_plan_id")

    @app_service_plan_id.setter
    def app_service_plan_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "app_service_plan_id", value)

    @_builtins.property
    @pulumi.getter(name="appSettings")
    def app_settings(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A map of key-value pairs for [App Settings](https://docs.microsoft.com/azure/azure-functions/functions-app-settings) and custom values.

        > **Note:** There are a number of application settings that will be managed for you by this resource type and *shouldn't* be configured separately as part of the app_settings you specify.  `AzureWebJobsStorage` is filled based on `storage_account_name` and `storage_account_access_key`. `WEBSITE_CONTENTSHARE` is detailed below. `FUNCTIONS_EXTENSION_VERSION` is filled based on `version`. `APP_KIND` is set to workflowApp and `AzureFunctionsJobHost__extensionBundle__id` and `AzureFunctionsJobHost__extensionBundle__version` are set as detailed below.
        """
        return pulumi.get(self, "app_settings")

    @app_settings.setter
    def app_settings(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "app_settings", value)

    @_builtins.property
    @pulumi.getter(name="bundleVersion")
    def bundle_version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        If `use_extension_bundle` is set to `true` this controls the allowed range for bundle versions. Defaults to `[1.*, 2.0.0)`.
        """
        return pulumi.get(self, "bundle_version")

    @bundle_version.setter
    def bundle_version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bundle_version", value)

    @_builtins.property
    @pulumi.getter(name="clientAffinityEnabled")
    def client_affinity_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the Logic App send session affinity cookies, which route client requests in the same session to the same instance?
        """
        return pulumi.get(self, "client_affinity_enabled")

    @client_affinity_enabled.setter
    def client_affinity_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "client_affinity_enabled", value)

    @_builtins.property
    @pulumi.getter(name="clientCertificateMode")
    def client_certificate_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The mode of the Logic App's client certificates requirement for incoming requests. Possible values are `Required` and `Optional`.
        """
        return pulumi.get(self, "client_certificate_mode")

    @client_certificate_mode.setter
    def client_certificate_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "client_certificate_mode", value)

    @_builtins.property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StandardConnectionStringArgs']]]]:
        """
        A `connection_string` block as defined below.
        """
        return pulumi.get(self, "connection_strings")

    @connection_strings.setter
    def connection_strings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StandardConnectionStringArgs']]]]):
        pulumi.set(self, "connection_strings", value)

    @_builtins.property
    @pulumi.getter(name="customDomainVerificationId")
    def custom_domain_verification_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        An identifier used by App Service to perform domain ownership verification via DNS TXT record.
        """
        return pulumi.get(self, "custom_domain_verification_id")

    @custom_domain_verification_id.setter
    def custom_domain_verification_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "custom_domain_verification_id", value)

    @_builtins.property
    @pulumi.getter(name="defaultHostname")
    def default_hostname(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The default hostname associated with the Logic App - such as `mysite.azurewebsites.net`.
        """
        return pulumi.get(self, "default_hostname")

    @default_hostname.setter
    def default_hostname(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "default_hostname", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Is the Logic App enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter(name="ftpPublishBasicAuthenticationEnabled")
    def ftp_publish_basic_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the FTP basic authentication publishing profile is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "ftp_publish_basic_authentication_enabled")

    @ftp_publish_basic_authentication_enabled.setter
    def ftp_publish_basic_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ftp_publish_basic_authentication_enabled", value)

    @_builtins.property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Can the Logic App only be accessed via HTTPS? Defaults to `false`.
        """
        return pulumi.get(self, "https_only")

    @https_only.setter
    def https_only(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "https_only", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['StandardIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['StandardIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Logic App kind.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Logic App. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="outboundIpAddresses")
    def outbound_ip_addresses(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A comma separated list of outbound IP addresses - such as `52.23.25.3,52.143.43.12`.
        """
        return pulumi.get(self, "outbound_ip_addresses")

    @outbound_ip_addresses.setter
    def outbound_ip_addresses(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "outbound_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="possibleOutboundIpAddresses")
    def possible_outbound_ip_addresses(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A comma separated list of outbound IP addresses - such as `52.23.25.3,52.143.43.12,52.143.43.17` - not all of which are necessarily in use. Superset of `outbound_ip_addresses`.
        """
        return pulumi.get(self, "possible_outbound_ip_addresses")

    @possible_outbound_ip_addresses.setter
    def possible_outbound_ip_addresses(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "possible_outbound_ip_addresses", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether Public Network Access should be enabled or not. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.

        > **Note:** Setting this property will also set it in the Site Config.
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_network_access", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the Logic App. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="scmPublishBasicAuthenticationEnabled")
    def scm_publish_basic_authentication_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the default SCM basic authentication publishing profile is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "scm_publish_basic_authentication_enabled")

    @scm_publish_basic_authentication_enabled.setter
    def scm_publish_basic_authentication_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "scm_publish_basic_authentication_enabled", value)

    @_builtins.property
    @pulumi.getter(name="siteConfig")
    def site_config(self) -> Optional[pulumi.Input['StandardSiteConfigArgs']]:
        """
        A `site_config` object as defined below.
        """
        return pulumi.get(self, "site_config")

    @site_config.setter
    def site_config(self, value: Optional[pulumi.Input['StandardSiteConfigArgs']]):
        pulumi.set(self, "site_config", value)

    @_builtins.property
    @pulumi.getter(name="siteCredentials")
    def site_credentials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['StandardSiteCredentialArgs']]]]:
        """
        A `site_credential` block as defined below, which contains the site-level credentials used to publish to this App Service.
        """
        return pulumi.get(self, "site_credentials")

    @site_credentials.setter
    def site_credentials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['StandardSiteCredentialArgs']]]]):
        pulumi.set(self, "site_credentials", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The access key which will be used to access the backend storage account for the Logic App.
        """
        return pulumi.get(self, "storage_account_access_key")

    @storage_account_access_key.setter
    def storage_account_access_key(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_access_key", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The backend storage account name which will be used by this Logic App (e.g. for Stateful workflows data). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_name")

    @storage_account_name.setter
    def storage_account_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_name", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountShareName")
    def storage_account_share_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "storage_account_share_name")

    @storage_account_share_name.setter
    def storage_account_share_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_share_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="useExtensionBundle")
    def use_extension_bundle(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should the logic app use the bundled extension package? If true, then application settings for `AzureFunctionsJobHost__extensionBundle__id` and `AzureFunctionsJobHost__extensionBundle__version` will be created. Defaults to `true`.
        """
        return pulumi.get(self, "use_extension_bundle")

    @use_extension_bundle.setter
    def use_extension_bundle(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "use_extension_bundle", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The runtime version associated with the Logic App. Defaults to `~4`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter(name="virtualNetworkSubnetId")
    def virtual_network_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "virtual_network_subnet_id")

    @virtual_network_subnet_id.setter
    def virtual_network_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "virtual_network_subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="vnetContentShareEnabled")
    def vnet_content_share_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Specifies whether allow routing traffic between the Logic App and Storage Account content share through a virtual network. Defaults to `false`.
        """
        return pulumi.get(self, "vnet_content_share_enabled")

    @vnet_content_share_enabled.setter
    def vnet_content_share_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "vnet_content_share_enabled", value)


@pulumi.type_token("azure:logicapps/standard:Standard")
class Standard(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_service_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 bundle_version: Optional[pulumi.Input[_builtins.str]] = None,
                 client_affinity_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_certificate_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StandardConnectionStringArgs', 'StandardConnectionStringArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ftp_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 https_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['StandardIdentityArgs', 'StandardIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scm_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 site_config: Optional[pulumi.Input[Union['StandardSiteConfigArgs', 'StandardSiteConfigArgsDict']]] = None,
                 storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_share_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 use_extension_bundle: Optional[pulumi.Input[_builtins.bool]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_network_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vnet_content_share_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        Manages a Logic App (Standard / Single Tenant)

        ## Example Usage

        ### With App Service Plan)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorageaccount",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_service_plan = azure.appservice.ServicePlan("example",
            name="example-service-plan",
            location=example.location,
            resource_group_name=example.name,
            os_type="Windows",
            sku_name="WS1")
        example_standard = azure.logicapps.Standard("example",
            name="example-logic-app",
            location=example.location,
            resource_group_name=example.name,
            app_service_plan_id=example_azurerm_app_service_plan["id"],
            storage_account_name=example_account.name,
            storage_account_access_key=example_account.primary_access_key,
            app_settings={
                "FUNCTIONS_WORKER_RUNTIME": "node",
                "WEBSITE_NODE_DEFAULT_VERSION": "~18",
            })
        ```

        ### For Container Mode)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorageaccount",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_plan = azure.appservice.Plan("example",
            name="example-service-plan",
            location=example.location,
            resource_group_name=example.name,
            kind="Linux",
            reserved=True,
            sku={
                "tier": "WorkflowStandard",
                "size": "WS1",
            })
        example_standard = azure.logicapps.Standard("example",
            name="example-logic-app",
            location=example.location,
            resource_group_name=example.name,
            app_service_plan_id=example_plan.id,
            storage_account_name=example_account.name,
            storage_account_access_key=example_account.primary_access_key,
            site_config={
                "linux_fx_version": "DOCKER|mcr.microsoft.com/azure-functions/dotnet:3.0-appservice",
            },
            app_settings={
                "DOCKER_REGISTRY_SERVER_URL": "https://<server-name>.azurecr.io",
                "DOCKER_REGISTRY_SERVER_USERNAME": "username",
                "DOCKER_REGISTRY_SERVER_PASSWORD": "password",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Web` - 2023-12-01, 2023-01-01

        ## Import

        Logic Apps can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:logicapps/standard:Standard logicapp1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Web/sites/logicapp1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_service_plan_id: The ID of the App Service Plan within which to create this Logic App.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] app_settings: A map of key-value pairs for [App Settings](https://docs.microsoft.com/azure/azure-functions/functions-app-settings) and custom values.
               
               > **Note:** There are a number of application settings that will be managed for you by this resource type and *shouldn't* be configured separately as part of the app_settings you specify.  `AzureWebJobsStorage` is filled based on `storage_account_name` and `storage_account_access_key`. `WEBSITE_CONTENTSHARE` is detailed below. `FUNCTIONS_EXTENSION_VERSION` is filled based on `version`. `APP_KIND` is set to workflowApp and `AzureFunctionsJobHost__extensionBundle__id` and `AzureFunctionsJobHost__extensionBundle__version` are set as detailed below.
        :param pulumi.Input[_builtins.str] bundle_version: If `use_extension_bundle` is set to `true` this controls the allowed range for bundle versions. Defaults to `[1.*, 2.0.0)`.
        :param pulumi.Input[_builtins.bool] client_affinity_enabled: Should the Logic App send session affinity cookies, which route client requests in the same session to the same instance?
        :param pulumi.Input[_builtins.str] client_certificate_mode: The mode of the Logic App's client certificates requirement for incoming requests. Possible values are `Required` and `Optional`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StandardConnectionStringArgs', 'StandardConnectionStringArgsDict']]]] connection_strings: A `connection_string` block as defined below.
        :param pulumi.Input[_builtins.bool] enabled: Is the Logic App enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] ftp_publish_basic_authentication_enabled: Whether the FTP basic authentication publishing profile is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] https_only: Can the Logic App only be accessed via HTTPS? Defaults to `false`.
        :param pulumi.Input[Union['StandardIdentityArgs', 'StandardIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Logic App. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] public_network_access: Whether Public Network Access should be enabled or not. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.
               
               > **Note:** Setting this property will also set it in the Site Config.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Logic App. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] scm_publish_basic_authentication_enabled: Whether the default SCM basic authentication publishing profile is enabled. Defaults to `true`.
        :param pulumi.Input[Union['StandardSiteConfigArgs', 'StandardSiteConfigArgsDict']] site_config: A `site_config` object as defined below.
        :param pulumi.Input[_builtins.str] storage_account_access_key: The access key which will be used to access the backend storage account for the Logic App.
        :param pulumi.Input[_builtins.str] storage_account_name: The backend storage account name which will be used by this Logic App (e.g. for Stateful workflows data). Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.bool] use_extension_bundle: Should the logic app use the bundled extension package? If true, then application settings for `AzureFunctionsJobHost__extensionBundle__id` and `AzureFunctionsJobHost__extensionBundle__version` will be created. Defaults to `true`.
        :param pulumi.Input[_builtins.str] version: The runtime version associated with the Logic App. Defaults to `~4`.
        :param pulumi.Input[_builtins.bool] vnet_content_share_enabled: Specifies whether allow routing traffic between the Logic App and Storage Account content share through a virtual network. Defaults to `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: StandardArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Logic App (Standard / Single Tenant)

        ## Example Usage

        ### With App Service Plan)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorageaccount",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_service_plan = azure.appservice.ServicePlan("example",
            name="example-service-plan",
            location=example.location,
            resource_group_name=example.name,
            os_type="Windows",
            sku_name="WS1")
        example_standard = azure.logicapps.Standard("example",
            name="example-logic-app",
            location=example.location,
            resource_group_name=example.name,
            app_service_plan_id=example_azurerm_app_service_plan["id"],
            storage_account_name=example_account.name,
            storage_account_access_key=example_account.primary_access_key,
            app_settings={
                "FUNCTIONS_WORKER_RUNTIME": "node",
                "WEBSITE_NODE_DEFAULT_VERSION": "~18",
            })
        ```

        ### For Container Mode)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example",
            location="West Europe")
        example_account = azure.storage.Account("example",
            name="examplestorageaccount",
            resource_group_name=example.name,
            location=example.location,
            account_tier="Standard",
            account_replication_type="LRS")
        example_plan = azure.appservice.Plan("example",
            name="example-service-plan",
            location=example.location,
            resource_group_name=example.name,
            kind="Linux",
            reserved=True,
            sku={
                "tier": "WorkflowStandard",
                "size": "WS1",
            })
        example_standard = azure.logicapps.Standard("example",
            name="example-logic-app",
            location=example.location,
            resource_group_name=example.name,
            app_service_plan_id=example_plan.id,
            storage_account_name=example_account.name,
            storage_account_access_key=example_account.primary_access_key,
            site_config={
                "linux_fx_version": "DOCKER|mcr.microsoft.com/azure-functions/dotnet:3.0-appservice",
            },
            app_settings={
                "DOCKER_REGISTRY_SERVER_URL": "https://<server-name>.azurecr.io",
                "DOCKER_REGISTRY_SERVER_USERNAME": "username",
                "DOCKER_REGISTRY_SERVER_PASSWORD": "password",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Web` - 2023-12-01, 2023-01-01

        ## Import

        Logic Apps can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:logicapps/standard:Standard logicapp1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Web/sites/logicapp1
        ```

        :param str resource_name: The name of the resource.
        :param StandardArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(StandardArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_service_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
                 app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 bundle_version: Optional[pulumi.Input[_builtins.str]] = None,
                 client_affinity_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 client_certificate_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StandardConnectionStringArgs', 'StandardConnectionStringArgsDict']]]]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ftp_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 https_only: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['StandardIdentityArgs', 'StandardIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 scm_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 site_config: Optional[pulumi.Input[Union['StandardSiteConfigArgs', 'StandardSiteConfigArgsDict']]] = None,
                 storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_share_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 use_extension_bundle: Optional[pulumi.Input[_builtins.bool]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 virtual_network_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 vnet_content_share_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = StandardArgs.__new__(StandardArgs)

            if app_service_plan_id is None and not opts.urn:
                raise TypeError("Missing required property 'app_service_plan_id'")
            __props__.__dict__["app_service_plan_id"] = app_service_plan_id
            __props__.__dict__["app_settings"] = app_settings
            __props__.__dict__["bundle_version"] = bundle_version
            __props__.__dict__["client_affinity_enabled"] = client_affinity_enabled
            __props__.__dict__["client_certificate_mode"] = client_certificate_mode
            __props__.__dict__["connection_strings"] = connection_strings
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["ftp_publish_basic_authentication_enabled"] = ftp_publish_basic_authentication_enabled
            __props__.__dict__["https_only"] = https_only
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["public_network_access"] = public_network_access
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["scm_publish_basic_authentication_enabled"] = scm_publish_basic_authentication_enabled
            __props__.__dict__["site_config"] = site_config
            if storage_account_access_key is None and not opts.urn:
                raise TypeError("Missing required property 'storage_account_access_key'")
            __props__.__dict__["storage_account_access_key"] = None if storage_account_access_key is None else pulumi.Output.secret(storage_account_access_key)
            if storage_account_name is None and not opts.urn:
                raise TypeError("Missing required property 'storage_account_name'")
            __props__.__dict__["storage_account_name"] = storage_account_name
            __props__.__dict__["storage_account_share_name"] = storage_account_share_name
            __props__.__dict__["tags"] = tags
            __props__.__dict__["use_extension_bundle"] = use_extension_bundle
            __props__.__dict__["version"] = version
            __props__.__dict__["virtual_network_subnet_id"] = virtual_network_subnet_id
            __props__.__dict__["vnet_content_share_enabled"] = vnet_content_share_enabled
            __props__.__dict__["custom_domain_verification_id"] = None
            __props__.__dict__["default_hostname"] = None
            __props__.__dict__["kind"] = None
            __props__.__dict__["outbound_ip_addresses"] = None
            __props__.__dict__["possible_outbound_ip_addresses"] = None
            __props__.__dict__["site_credentials"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["storageAccountAccessKey"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Standard, __self__).__init__(
            'azure:logicapps/standard:Standard',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            app_service_plan_id: Optional[pulumi.Input[_builtins.str]] = None,
            app_settings: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            bundle_version: Optional[pulumi.Input[_builtins.str]] = None,
            client_affinity_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            client_certificate_mode: Optional[pulumi.Input[_builtins.str]] = None,
            connection_strings: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StandardConnectionStringArgs', 'StandardConnectionStringArgsDict']]]]] = None,
            custom_domain_verification_id: Optional[pulumi.Input[_builtins.str]] = None,
            default_hostname: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            ftp_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            https_only: Optional[pulumi.Input[_builtins.bool]] = None,
            identity: Optional[pulumi.Input[Union['StandardIdentityArgs', 'StandardIdentityArgsDict']]] = None,
            kind: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            outbound_ip_addresses: Optional[pulumi.Input[_builtins.str]] = None,
            possible_outbound_ip_addresses: Optional[pulumi.Input[_builtins.str]] = None,
            public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            scm_publish_basic_authentication_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            site_config: Optional[pulumi.Input[Union['StandardSiteConfigArgs', 'StandardSiteConfigArgsDict']]] = None,
            site_credentials: Optional[pulumi.Input[Sequence[pulumi.Input[Union['StandardSiteCredentialArgs', 'StandardSiteCredentialArgsDict']]]]] = None,
            storage_account_access_key: Optional[pulumi.Input[_builtins.str]] = None,
            storage_account_name: Optional[pulumi.Input[_builtins.str]] = None,
            storage_account_share_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            use_extension_bundle: Optional[pulumi.Input[_builtins.bool]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None,
            virtual_network_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            vnet_content_share_enabled: Optional[pulumi.Input[_builtins.bool]] = None) -> 'Standard':
        """
        Get an existing Standard resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] app_service_plan_id: The ID of the App Service Plan within which to create this Logic App.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] app_settings: A map of key-value pairs for [App Settings](https://docs.microsoft.com/azure/azure-functions/functions-app-settings) and custom values.
               
               > **Note:** There are a number of application settings that will be managed for you by this resource type and *shouldn't* be configured separately as part of the app_settings you specify.  `AzureWebJobsStorage` is filled based on `storage_account_name` and `storage_account_access_key`. `WEBSITE_CONTENTSHARE` is detailed below. `FUNCTIONS_EXTENSION_VERSION` is filled based on `version`. `APP_KIND` is set to workflowApp and `AzureFunctionsJobHost__extensionBundle__id` and `AzureFunctionsJobHost__extensionBundle__version` are set as detailed below.
        :param pulumi.Input[_builtins.str] bundle_version: If `use_extension_bundle` is set to `true` this controls the allowed range for bundle versions. Defaults to `[1.*, 2.0.0)`.
        :param pulumi.Input[_builtins.bool] client_affinity_enabled: Should the Logic App send session affinity cookies, which route client requests in the same session to the same instance?
        :param pulumi.Input[_builtins.str] client_certificate_mode: The mode of the Logic App's client certificates requirement for incoming requests. Possible values are `Required` and `Optional`.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StandardConnectionStringArgs', 'StandardConnectionStringArgsDict']]]] connection_strings: A `connection_string` block as defined below.
        :param pulumi.Input[_builtins.str] custom_domain_verification_id: An identifier used by App Service to perform domain ownership verification via DNS TXT record.
        :param pulumi.Input[_builtins.str] default_hostname: The default hostname associated with the Logic App - such as `mysite.azurewebsites.net`.
        :param pulumi.Input[_builtins.bool] enabled: Is the Logic App enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] ftp_publish_basic_authentication_enabled: Whether the FTP basic authentication publishing profile is enabled. Defaults to `true`.
        :param pulumi.Input[_builtins.bool] https_only: Can the Logic App only be accessed via HTTPS? Defaults to `false`.
        :param pulumi.Input[Union['StandardIdentityArgs', 'StandardIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] kind: The Logic App kind.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Logic App. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] outbound_ip_addresses: A comma separated list of outbound IP addresses - such as `52.23.25.3,52.143.43.12`.
        :param pulumi.Input[_builtins.str] possible_outbound_ip_addresses: A comma separated list of outbound IP addresses - such as `52.23.25.3,52.143.43.12,52.143.43.17` - not all of which are necessarily in use. Superset of `outbound_ip_addresses`.
        :param pulumi.Input[_builtins.str] public_network_access: Whether Public Network Access should be enabled or not. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.
               
               > **Note:** Setting this property will also set it in the Site Config.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the Logic App. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.bool] scm_publish_basic_authentication_enabled: Whether the default SCM basic authentication publishing profile is enabled. Defaults to `true`.
        :param pulumi.Input[Union['StandardSiteConfigArgs', 'StandardSiteConfigArgsDict']] site_config: A `site_config` object as defined below.
        :param pulumi.Input[Sequence[pulumi.Input[Union['StandardSiteCredentialArgs', 'StandardSiteCredentialArgsDict']]]] site_credentials: A `site_credential` block as defined below, which contains the site-level credentials used to publish to this App Service.
        :param pulumi.Input[_builtins.str] storage_account_access_key: The access key which will be used to access the backend storage account for the Logic App.
        :param pulumi.Input[_builtins.str] storage_account_name: The backend storage account name which will be used by this Logic App (e.g. for Stateful workflows data). Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.bool] use_extension_bundle: Should the logic app use the bundled extension package? If true, then application settings for `AzureFunctionsJobHost__extensionBundle__id` and `AzureFunctionsJobHost__extensionBundle__version` will be created. Defaults to `true`.
        :param pulumi.Input[_builtins.str] version: The runtime version associated with the Logic App. Defaults to `~4`.
        :param pulumi.Input[_builtins.bool] vnet_content_share_enabled: Specifies whether allow routing traffic between the Logic App and Storage Account content share through a virtual network. Defaults to `false`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _StandardState.__new__(_StandardState)

        __props__.__dict__["app_service_plan_id"] = app_service_plan_id
        __props__.__dict__["app_settings"] = app_settings
        __props__.__dict__["bundle_version"] = bundle_version
        __props__.__dict__["client_affinity_enabled"] = client_affinity_enabled
        __props__.__dict__["client_certificate_mode"] = client_certificate_mode
        __props__.__dict__["connection_strings"] = connection_strings
        __props__.__dict__["custom_domain_verification_id"] = custom_domain_verification_id
        __props__.__dict__["default_hostname"] = default_hostname
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["ftp_publish_basic_authentication_enabled"] = ftp_publish_basic_authentication_enabled
        __props__.__dict__["https_only"] = https_only
        __props__.__dict__["identity"] = identity
        __props__.__dict__["kind"] = kind
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["outbound_ip_addresses"] = outbound_ip_addresses
        __props__.__dict__["possible_outbound_ip_addresses"] = possible_outbound_ip_addresses
        __props__.__dict__["public_network_access"] = public_network_access
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["scm_publish_basic_authentication_enabled"] = scm_publish_basic_authentication_enabled
        __props__.__dict__["site_config"] = site_config
        __props__.__dict__["site_credentials"] = site_credentials
        __props__.__dict__["storage_account_access_key"] = storage_account_access_key
        __props__.__dict__["storage_account_name"] = storage_account_name
        __props__.__dict__["storage_account_share_name"] = storage_account_share_name
        __props__.__dict__["tags"] = tags
        __props__.__dict__["use_extension_bundle"] = use_extension_bundle
        __props__.__dict__["version"] = version
        __props__.__dict__["virtual_network_subnet_id"] = virtual_network_subnet_id
        __props__.__dict__["vnet_content_share_enabled"] = vnet_content_share_enabled
        return Standard(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="appServicePlanId")
    def app_service_plan_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the App Service Plan within which to create this Logic App.
        """
        return pulumi.get(self, "app_service_plan_id")

    @_builtins.property
    @pulumi.getter(name="appSettings")
    def app_settings(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        A map of key-value pairs for [App Settings](https://docs.microsoft.com/azure/azure-functions/functions-app-settings) and custom values.

        > **Note:** There are a number of application settings that will be managed for you by this resource type and *shouldn't* be configured separately as part of the app_settings you specify.  `AzureWebJobsStorage` is filled based on `storage_account_name` and `storage_account_access_key`. `WEBSITE_CONTENTSHARE` is detailed below. `FUNCTIONS_EXTENSION_VERSION` is filled based on `version`. `APP_KIND` is set to workflowApp and `AzureFunctionsJobHost__extensionBundle__id` and `AzureFunctionsJobHost__extensionBundle__version` are set as detailed below.
        """
        return pulumi.get(self, "app_settings")

    @_builtins.property
    @pulumi.getter(name="bundleVersion")
    def bundle_version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        If `use_extension_bundle` is set to `true` this controls the allowed range for bundle versions. Defaults to `[1.*, 2.0.0)`.
        """
        return pulumi.get(self, "bundle_version")

    @_builtins.property
    @pulumi.getter(name="clientAffinityEnabled")
    def client_affinity_enabled(self) -> pulumi.Output[_builtins.bool]:
        """
        Should the Logic App send session affinity cookies, which route client requests in the same session to the same instance?
        """
        return pulumi.get(self, "client_affinity_enabled")

    @_builtins.property
    @pulumi.getter(name="clientCertificateMode")
    def client_certificate_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The mode of the Logic App's client certificates requirement for incoming requests. Possible values are `Required` and `Optional`.
        """
        return pulumi.get(self, "client_certificate_mode")

    @_builtins.property
    @pulumi.getter(name="connectionStrings")
    def connection_strings(self) -> pulumi.Output[Sequence['outputs.StandardConnectionString']]:
        """
        A `connection_string` block as defined below.
        """
        return pulumi.get(self, "connection_strings")

    @_builtins.property
    @pulumi.getter(name="customDomainVerificationId")
    def custom_domain_verification_id(self) -> pulumi.Output[_builtins.str]:
        """
        An identifier used by App Service to perform domain ownership verification via DNS TXT record.
        """
        return pulumi.get(self, "custom_domain_verification_id")

    @_builtins.property
    @pulumi.getter(name="defaultHostname")
    def default_hostname(self) -> pulumi.Output[_builtins.str]:
        """
        The default hostname associated with the Logic App - such as `mysite.azurewebsites.net`.
        """
        return pulumi.get(self, "default_hostname")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Is the Logic App enabled? Defaults to `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="ftpPublishBasicAuthenticationEnabled")
    def ftp_publish_basic_authentication_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the FTP basic authentication publishing profile is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "ftp_publish_basic_authentication_enabled")

    @_builtins.property
    @pulumi.getter(name="httpsOnly")
    def https_only(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Can the Logic App only be accessed via HTTPS? Defaults to `false`.
        """
        return pulumi.get(self, "https_only")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.StandardIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> pulumi.Output[_builtins.str]:
        """
        The Logic App kind.
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the resource exists. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Logic App. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="outboundIpAddresses")
    def outbound_ip_addresses(self) -> pulumi.Output[_builtins.str]:
        """
        A comma separated list of outbound IP addresses - such as `52.23.25.3,52.143.43.12`.
        """
        return pulumi.get(self, "outbound_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="possibleOutboundIpAddresses")
    def possible_outbound_ip_addresses(self) -> pulumi.Output[_builtins.str]:
        """
        A comma separated list of outbound IP addresses - such as `52.23.25.3,52.143.43.12,52.143.43.17` - not all of which are necessarily in use. Superset of `outbound_ip_addresses`.
        """
        return pulumi.get(self, "possible_outbound_ip_addresses")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> pulumi.Output[_builtins.str]:
        """
        Whether Public Network Access should be enabled or not. Possible values are `Enabled` and `Disabled`. Defaults to `Enabled`.

        > **Note:** Setting this property will also set it in the Site Config.
        """
        return pulumi.get(self, "public_network_access")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the Logic App. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="scmPublishBasicAuthenticationEnabled")
    def scm_publish_basic_authentication_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the default SCM basic authentication publishing profile is enabled. Defaults to `true`.
        """
        return pulumi.get(self, "scm_publish_basic_authentication_enabled")

    @_builtins.property
    @pulumi.getter(name="siteConfig")
    def site_config(self) -> pulumi.Output['outputs.StandardSiteConfig']:
        """
        A `site_config` object as defined below.
        """
        return pulumi.get(self, "site_config")

    @_builtins.property
    @pulumi.getter(name="siteCredentials")
    def site_credentials(self) -> pulumi.Output[Sequence['outputs.StandardSiteCredential']]:
        """
        A `site_credential` block as defined below, which contains the site-level credentials used to publish to this App Service.
        """
        return pulumi.get(self, "site_credentials")

    @_builtins.property
    @pulumi.getter(name="storageAccountAccessKey")
    def storage_account_access_key(self) -> pulumi.Output[_builtins.str]:
        """
        The access key which will be used to access the backend storage account for the Logic App.
        """
        return pulumi.get(self, "storage_account_access_key")

    @_builtins.property
    @pulumi.getter(name="storageAccountName")
    def storage_account_name(self) -> pulumi.Output[_builtins.str]:
        """
        The backend storage account name which will be used by this Logic App (e.g. for Stateful workflows data). Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "storage_account_name")

    @_builtins.property
    @pulumi.getter(name="storageAccountShareName")
    def storage_account_share_name(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "storage_account_share_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="useExtensionBundle")
    def use_extension_bundle(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should the logic app use the bundled extension package? If true, then application settings for `AzureFunctionsJobHost__extensionBundle__id` and `AzureFunctionsJobHost__extensionBundle__version` will be created. Defaults to `true`.
        """
        return pulumi.get(self, "use_extension_bundle")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The runtime version associated with the Logic App. Defaults to `~4`.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter(name="virtualNetworkSubnetId")
    def virtual_network_subnet_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        return pulumi.get(self, "virtual_network_subnet_id")

    @_builtins.property
    @pulumi.getter(name="vnetContentShareEnabled")
    def vnet_content_share_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Specifies whether allow routing traffic between the Logic App and Storage Account content share through a virtual network. Defaults to `false`.
        """
        return pulumi.get(self, "vnet_content_share_enabled")

