# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ComputeClusterArgs', 'ComputeCluster']

@pulumi.input_type
class ComputeClusterArgs:
    def __init__(__self__, *,
                 machine_learning_workspace_id: pulumi.Input[_builtins.str],
                 scale_settings: pulumi.Input['ComputeClusterScaleSettingsArgs'],
                 vm_priority: pulumi.Input[_builtins.str],
                 vm_size: pulumi.Input[_builtins.str],
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['ComputeClusterIdentityArgs']] = None,
                 local_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_public_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 ssh: Optional[pulumi.Input['ComputeClusterSshArgs']] = None,
                 ssh_public_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 subnet_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ComputeCluster resource.
        :param pulumi.Input[_builtins.str] machine_learning_workspace_id: The ID of the Machine Learning Workspace. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input['ComputeClusterScaleSettingsArgs'] scale_settings: A `scale_settings` block as defined below.
        :param pulumi.Input[_builtins.str] vm_priority: The priority of the VM. Changing this forces a new Machine Learning Compute Cluster to be created. Accepted values are `Dedicated` and `LowPriority`.
        :param pulumi.Input[_builtins.str] vm_size: The size of the VM. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[_builtins.str] description: The description of the Machine Learning compute. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input['ComputeClusterIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] local_auth_enabled: Whether local authentication methods is enabled. Defaults to `true`. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Machine Learning Compute Cluster should exist. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Machine Learning Compute Cluster. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[_builtins.bool] node_public_ip_enabled: Whether the compute cluster will have a public ip. Defaults to `true`. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input['ComputeClusterSshArgs'] ssh: Credentials for an administrator user account that will be created on each compute node. A `ssh` block as defined below. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[_builtins.bool] ssh_public_access_enabled: A boolean value indicating whether enable the public SSH port. Defaults to `false`. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[_builtins.str] subnet_resource_id: The ID of the Subnet that the Compute Cluster should reside in. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Machine Learning Compute Cluster.
        """
        pulumi.set(__self__, "machine_learning_workspace_id", machine_learning_workspace_id)
        pulumi.set(__self__, "scale_settings", scale_settings)
        pulumi.set(__self__, "vm_priority", vm_priority)
        pulumi.set(__self__, "vm_size", vm_size)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if local_auth_enabled is not None:
            pulumi.set(__self__, "local_auth_enabled", local_auth_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_public_ip_enabled is not None:
            pulumi.set(__self__, "node_public_ip_enabled", node_public_ip_enabled)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)
        if ssh_public_access_enabled is not None:
            pulumi.set(__self__, "ssh_public_access_enabled", ssh_public_access_enabled)
        if subnet_resource_id is not None:
            pulumi.set(__self__, "subnet_resource_id", subnet_resource_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="machineLearningWorkspaceId")
    def machine_learning_workspace_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Machine Learning Workspace. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "machine_learning_workspace_id")

    @machine_learning_workspace_id.setter
    def machine_learning_workspace_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "machine_learning_workspace_id", value)

    @_builtins.property
    @pulumi.getter(name="scaleSettings")
    def scale_settings(self) -> pulumi.Input['ComputeClusterScaleSettingsArgs']:
        """
        A `scale_settings` block as defined below.
        """
        return pulumi.get(self, "scale_settings")

    @scale_settings.setter
    def scale_settings(self, value: pulumi.Input['ComputeClusterScaleSettingsArgs']):
        pulumi.set(self, "scale_settings", value)

    @_builtins.property
    @pulumi.getter(name="vmPriority")
    def vm_priority(self) -> pulumi.Input[_builtins.str]:
        """
        The priority of the VM. Changing this forces a new Machine Learning Compute Cluster to be created. Accepted values are `Dedicated` and `LowPriority`.
        """
        return pulumi.get(self, "vm_priority")

    @vm_priority.setter
    def vm_priority(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vm_priority", value)

    @_builtins.property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> pulumi.Input[_builtins.str]:
        """
        The size of the VM. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "vm_size", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Machine Learning compute. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ComputeClusterIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ComputeClusterIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="localAuthEnabled")
    def local_auth_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether local authentication methods is enabled. Defaults to `true`. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "local_auth_enabled")

    @local_auth_enabled.setter
    def local_auth_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_auth_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Machine Learning Compute Cluster should exist. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Machine Learning Compute Cluster. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodePublicIpEnabled")
    def node_public_ip_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the compute cluster will have a public ip. Defaults to `true`. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "node_public_ip_enabled")

    @node_public_ip_enabled.setter
    def node_public_ip_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "node_public_ip_enabled", value)

    @_builtins.property
    @pulumi.getter
    def ssh(self) -> Optional[pulumi.Input['ComputeClusterSshArgs']]:
        """
        Credentials for an administrator user account that will be created on each compute node. A `ssh` block as defined below. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "ssh")

    @ssh.setter
    def ssh(self, value: Optional[pulumi.Input['ComputeClusterSshArgs']]):
        pulumi.set(self, "ssh", value)

    @_builtins.property
    @pulumi.getter(name="sshPublicAccessEnabled")
    def ssh_public_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean value indicating whether enable the public SSH port. Defaults to `false`. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "ssh_public_access_enabled")

    @ssh_public_access_enabled.setter
    def ssh_public_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssh_public_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="subnetResourceId")
    def subnet_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Subnet that the Compute Cluster should reside in. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "subnet_resource_id")

    @subnet_resource_id.setter
    def subnet_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_resource_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Machine Learning Compute Cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ComputeClusterState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input['ComputeClusterIdentityArgs']] = None,
                 local_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 machine_learning_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_public_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 scale_settings: Optional[pulumi.Input['ComputeClusterScaleSettingsArgs']] = None,
                 ssh: Optional[pulumi.Input['ComputeClusterSshArgs']] = None,
                 ssh_public_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 subnet_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vm_priority: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_size: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ComputeCluster resources.
        :param pulumi.Input[_builtins.str] description: The description of the Machine Learning compute. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input['ComputeClusterIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] local_auth_enabled: Whether local authentication methods is enabled. Defaults to `true`. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Machine Learning Compute Cluster should exist. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[_builtins.str] machine_learning_workspace_id: The ID of the Machine Learning Workspace. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Machine Learning Compute Cluster. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[_builtins.bool] node_public_ip_enabled: Whether the compute cluster will have a public ip. Defaults to `true`. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input['ComputeClusterScaleSettingsArgs'] scale_settings: A `scale_settings` block as defined below.
        :param pulumi.Input['ComputeClusterSshArgs'] ssh: Credentials for an administrator user account that will be created on each compute node. A `ssh` block as defined below. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[_builtins.bool] ssh_public_access_enabled: A boolean value indicating whether enable the public SSH port. Defaults to `false`. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[_builtins.str] subnet_resource_id: The ID of the Subnet that the Compute Cluster should reside in. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Machine Learning Compute Cluster.
        :param pulumi.Input[_builtins.str] vm_priority: The priority of the VM. Changing this forces a new Machine Learning Compute Cluster to be created. Accepted values are `Dedicated` and `LowPriority`.
        :param pulumi.Input[_builtins.str] vm_size: The size of the VM. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if local_auth_enabled is not None:
            pulumi.set(__self__, "local_auth_enabled", local_auth_enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if machine_learning_workspace_id is not None:
            pulumi.set(__self__, "machine_learning_workspace_id", machine_learning_workspace_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_public_ip_enabled is not None:
            pulumi.set(__self__, "node_public_ip_enabled", node_public_ip_enabled)
        if scale_settings is not None:
            pulumi.set(__self__, "scale_settings", scale_settings)
        if ssh is not None:
            pulumi.set(__self__, "ssh", ssh)
        if ssh_public_access_enabled is not None:
            pulumi.set(__self__, "ssh_public_access_enabled", ssh_public_access_enabled)
        if subnet_resource_id is not None:
            pulumi.set(__self__, "subnet_resource_id", subnet_resource_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vm_priority is not None:
            pulumi.set(__self__, "vm_priority", vm_priority)
        if vm_size is not None:
            pulumi.set(__self__, "vm_size", vm_size)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Machine Learning compute. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['ComputeClusterIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['ComputeClusterIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="localAuthEnabled")
    def local_auth_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether local authentication methods is enabled. Defaults to `true`. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "local_auth_enabled")

    @local_auth_enabled.setter
    def local_auth_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "local_auth_enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the Machine Learning Compute Cluster should exist. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="machineLearningWorkspaceId")
    def machine_learning_workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Machine Learning Workspace. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "machine_learning_workspace_id")

    @machine_learning_workspace_id.setter
    def machine_learning_workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "machine_learning_workspace_id", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Machine Learning Compute Cluster. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="nodePublicIpEnabled")
    def node_public_ip_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the compute cluster will have a public ip. Defaults to `true`. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "node_public_ip_enabled")

    @node_public_ip_enabled.setter
    def node_public_ip_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "node_public_ip_enabled", value)

    @_builtins.property
    @pulumi.getter(name="scaleSettings")
    def scale_settings(self) -> Optional[pulumi.Input['ComputeClusterScaleSettingsArgs']]:
        """
        A `scale_settings` block as defined below.
        """
        return pulumi.get(self, "scale_settings")

    @scale_settings.setter
    def scale_settings(self, value: Optional[pulumi.Input['ComputeClusterScaleSettingsArgs']]):
        pulumi.set(self, "scale_settings", value)

    @_builtins.property
    @pulumi.getter
    def ssh(self) -> Optional[pulumi.Input['ComputeClusterSshArgs']]:
        """
        Credentials for an administrator user account that will be created on each compute node. A `ssh` block as defined below. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "ssh")

    @ssh.setter
    def ssh(self, value: Optional[pulumi.Input['ComputeClusterSshArgs']]):
        pulumi.set(self, "ssh", value)

    @_builtins.property
    @pulumi.getter(name="sshPublicAccessEnabled")
    def ssh_public_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        A boolean value indicating whether enable the public SSH port. Defaults to `false`. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "ssh_public_access_enabled")

    @ssh_public_access_enabled.setter
    def ssh_public_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ssh_public_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="subnetResourceId")
    def subnet_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Subnet that the Compute Cluster should reside in. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "subnet_resource_id")

    @subnet_resource_id.setter
    def subnet_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_resource_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the Machine Learning Compute Cluster.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="vmPriority")
    def vm_priority(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The priority of the VM. Changing this forces a new Machine Learning Compute Cluster to be created. Accepted values are `Dedicated` and `LowPriority`.
        """
        return pulumi.get(self, "vm_priority")

    @vm_priority.setter
    def vm_priority(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_priority", value)

    @_builtins.property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The size of the VM. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "vm_size")

    @vm_size.setter
    def vm_size(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "vm_size", value)


@pulumi.type_token("azure:machinelearning/computeCluster:ComputeCluster")
class ComputeCluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['ComputeClusterIdentityArgs', 'ComputeClusterIdentityArgsDict']]] = None,
                 local_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 machine_learning_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_public_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 scale_settings: Optional[pulumi.Input[Union['ComputeClusterScaleSettingsArgs', 'ComputeClusterScaleSettingsArgsDict']]] = None,
                 ssh: Optional[pulumi.Input[Union['ComputeClusterSshArgs', 'ComputeClusterSshArgsDict']]] = None,
                 ssh_public_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 subnet_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vm_priority: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_size: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Machine Learning Compute Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="west europe",
            tags={
                "stage": "example",
            })
        example_insights = azure.appinsights.Insights("example",
            name="example-ai",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example-kv",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            purge_protection_enabled=True)
        example_account = azure.storage.Account("example",
            name="examplesa",
            location=example.location,
            resource_group_name=example.name,
            account_tier="Standard",
            account_replication_type="LRS")
        example_workspace = azure.machinelearning.Workspace("example",
            name="example-mlw",
            location=example.location,
            resource_group_name=example.name,
            application_insights_id=example_insights.id,
            key_vault_id=example_key_vault.id,
            storage_account_id=example_account.id,
            identity={
                "type": "SystemAssigned",
            })
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.1.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.1.0.0/24"])
        test = azure.machinelearning.ComputeCluster("test",
            name="example",
            location=example.location,
            vm_priority="LowPriority",
            vm_size="Standard_DS2_v2",
            machine_learning_workspace_id=example_workspace.id,
            subnet_resource_id=example_subnet.id,
            scale_settings={
                "min_node_count": 0,
                "max_node_count": 1,
                "scale_down_nodes_after_idle_duration": "PT30S",
            },
            identity={
                "type": "SystemAssigned",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MachineLearningServices` - 2025-06-01

        ## Import

        Machine Learning Compute Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:machinelearning/computeCluster:ComputeCluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.MachineLearningServices/workspaces/workspace1/computes/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the Machine Learning compute. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[Union['ComputeClusterIdentityArgs', 'ComputeClusterIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] local_auth_enabled: Whether local authentication methods is enabled. Defaults to `true`. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Machine Learning Compute Cluster should exist. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[_builtins.str] machine_learning_workspace_id: The ID of the Machine Learning Workspace. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Machine Learning Compute Cluster. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[_builtins.bool] node_public_ip_enabled: Whether the compute cluster will have a public ip. Defaults to `true`. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[Union['ComputeClusterScaleSettingsArgs', 'ComputeClusterScaleSettingsArgsDict']] scale_settings: A `scale_settings` block as defined below.
        :param pulumi.Input[Union['ComputeClusterSshArgs', 'ComputeClusterSshArgsDict']] ssh: Credentials for an administrator user account that will be created on each compute node. A `ssh` block as defined below. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[_builtins.bool] ssh_public_access_enabled: A boolean value indicating whether enable the public SSH port. Defaults to `false`. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[_builtins.str] subnet_resource_id: The ID of the Subnet that the Compute Cluster should reside in. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Machine Learning Compute Cluster.
        :param pulumi.Input[_builtins.str] vm_priority: The priority of the VM. Changing this forces a new Machine Learning Compute Cluster to be created. Accepted values are `Dedicated` and `LowPriority`.
        :param pulumi.Input[_builtins.str] vm_size: The size of the VM. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ComputeClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Machine Learning Compute Cluster.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-rg",
            location="west europe",
            tags={
                "stage": "example",
            })
        example_insights = azure.appinsights.Insights("example",
            name="example-ai",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example-kv",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="standard",
            purge_protection_enabled=True)
        example_account = azure.storage.Account("example",
            name="examplesa",
            location=example.location,
            resource_group_name=example.name,
            account_tier="Standard",
            account_replication_type="LRS")
        example_workspace = azure.machinelearning.Workspace("example",
            name="example-mlw",
            location=example.location,
            resource_group_name=example.name,
            application_insights_id=example_insights.id,
            key_vault_id=example_key_vault.id,
            storage_account_id=example_account.id,
            identity={
                "type": "SystemAssigned",
            })
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vnet",
            address_spaces=["10.1.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="example-subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.1.0.0/24"])
        test = azure.machinelearning.ComputeCluster("test",
            name="example",
            location=example.location,
            vm_priority="LowPriority",
            vm_size="Standard_DS2_v2",
            machine_learning_workspace_id=example_workspace.id,
            subnet_resource_id=example_subnet.id,
            scale_settings={
                "min_node_count": 0,
                "max_node_count": 1,
                "scale_down_nodes_after_idle_duration": "PT30S",
            },
            identity={
                "type": "SystemAssigned",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MachineLearningServices` - 2025-06-01

        ## Import

        Machine Learning Compute Clusters can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:machinelearning/computeCluster:ComputeCluster example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resGroup1/providers/Microsoft.MachineLearningServices/workspaces/workspace1/computes/cluster1
        ```

        :param str resource_name: The name of the resource.
        :param ComputeClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ComputeClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 identity: Optional[pulumi.Input[Union['ComputeClusterIdentityArgs', 'ComputeClusterIdentityArgsDict']]] = None,
                 local_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 machine_learning_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 node_public_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 scale_settings: Optional[pulumi.Input[Union['ComputeClusterScaleSettingsArgs', 'ComputeClusterScaleSettingsArgsDict']]] = None,
                 ssh: Optional[pulumi.Input[Union['ComputeClusterSshArgs', 'ComputeClusterSshArgsDict']]] = None,
                 ssh_public_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 subnet_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 vm_priority: Optional[pulumi.Input[_builtins.str]] = None,
                 vm_size: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ComputeClusterArgs.__new__(ComputeClusterArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["identity"] = identity
            __props__.__dict__["local_auth_enabled"] = local_auth_enabled
            __props__.__dict__["location"] = location
            if machine_learning_workspace_id is None and not opts.urn:
                raise TypeError("Missing required property 'machine_learning_workspace_id'")
            __props__.__dict__["machine_learning_workspace_id"] = machine_learning_workspace_id
            __props__.__dict__["name"] = name
            __props__.__dict__["node_public_ip_enabled"] = node_public_ip_enabled
            if scale_settings is None and not opts.urn:
                raise TypeError("Missing required property 'scale_settings'")
            __props__.__dict__["scale_settings"] = scale_settings
            __props__.__dict__["ssh"] = ssh
            __props__.__dict__["ssh_public_access_enabled"] = ssh_public_access_enabled
            __props__.__dict__["subnet_resource_id"] = subnet_resource_id
            __props__.__dict__["tags"] = tags
            if vm_priority is None and not opts.urn:
                raise TypeError("Missing required property 'vm_priority'")
            __props__.__dict__["vm_priority"] = vm_priority
            if vm_size is None and not opts.urn:
                raise TypeError("Missing required property 'vm_size'")
            __props__.__dict__["vm_size"] = vm_size
        super(ComputeCluster, __self__).__init__(
            'azure:machinelearning/computeCluster:ComputeCluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            identity: Optional[pulumi.Input[Union['ComputeClusterIdentityArgs', 'ComputeClusterIdentityArgsDict']]] = None,
            local_auth_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            machine_learning_workspace_id: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            node_public_ip_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            scale_settings: Optional[pulumi.Input[Union['ComputeClusterScaleSettingsArgs', 'ComputeClusterScaleSettingsArgsDict']]] = None,
            ssh: Optional[pulumi.Input[Union['ComputeClusterSshArgs', 'ComputeClusterSshArgsDict']]] = None,
            ssh_public_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            subnet_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            vm_priority: Optional[pulumi.Input[_builtins.str]] = None,
            vm_size: Optional[pulumi.Input[_builtins.str]] = None) -> 'ComputeCluster':
        """
        Get an existing ComputeCluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] description: The description of the Machine Learning compute. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[Union['ComputeClusterIdentityArgs', 'ComputeClusterIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.bool] local_auth_enabled: Whether local authentication methods is enabled. Defaults to `true`. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the Machine Learning Compute Cluster should exist. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[_builtins.str] machine_learning_workspace_id: The ID of the Machine Learning Workspace. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Machine Learning Compute Cluster. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[_builtins.bool] node_public_ip_enabled: Whether the compute cluster will have a public ip. Defaults to `true`. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[Union['ComputeClusterScaleSettingsArgs', 'ComputeClusterScaleSettingsArgsDict']] scale_settings: A `scale_settings` block as defined below.
        :param pulumi.Input[Union['ComputeClusterSshArgs', 'ComputeClusterSshArgsDict']] ssh: Credentials for an administrator user account that will be created on each compute node. A `ssh` block as defined below. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[_builtins.bool] ssh_public_access_enabled: A boolean value indicating whether enable the public SSH port. Defaults to `false`. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[_builtins.str] subnet_resource_id: The ID of the Subnet that the Compute Cluster should reside in. Changing this forces a new Machine Learning Compute Cluster to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the Machine Learning Compute Cluster.
        :param pulumi.Input[_builtins.str] vm_priority: The priority of the VM. Changing this forces a new Machine Learning Compute Cluster to be created. Accepted values are `Dedicated` and `LowPriority`.
        :param pulumi.Input[_builtins.str] vm_size: The size of the VM. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ComputeClusterState.__new__(_ComputeClusterState)

        __props__.__dict__["description"] = description
        __props__.__dict__["identity"] = identity
        __props__.__dict__["local_auth_enabled"] = local_auth_enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["machine_learning_workspace_id"] = machine_learning_workspace_id
        __props__.__dict__["name"] = name
        __props__.__dict__["node_public_ip_enabled"] = node_public_ip_enabled
        __props__.__dict__["scale_settings"] = scale_settings
        __props__.__dict__["ssh"] = ssh
        __props__.__dict__["ssh_public_access_enabled"] = ssh_public_access_enabled
        __props__.__dict__["subnet_resource_id"] = subnet_resource_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vm_priority"] = vm_priority
        __props__.__dict__["vm_size"] = vm_size
        return ComputeCluster(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the Machine Learning compute. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.ComputeClusterIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="localAuthEnabled")
    def local_auth_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether local authentication methods is enabled. Defaults to `true`. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "local_auth_enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the Machine Learning Compute Cluster should exist. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="machineLearningWorkspaceId")
    def machine_learning_workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Machine Learning Workspace. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "machine_learning_workspace_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Machine Learning Compute Cluster. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="nodePublicIpEnabled")
    def node_public_ip_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether the compute cluster will have a public ip. Defaults to `true`. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "node_public_ip_enabled")

    @_builtins.property
    @pulumi.getter(name="scaleSettings")
    def scale_settings(self) -> pulumi.Output['outputs.ComputeClusterScaleSettings']:
        """
        A `scale_settings` block as defined below.
        """
        return pulumi.get(self, "scale_settings")

    @_builtins.property
    @pulumi.getter
    def ssh(self) -> pulumi.Output[Optional['outputs.ComputeClusterSsh']]:
        """
        Credentials for an administrator user account that will be created on each compute node. A `ssh` block as defined below. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "ssh")

    @_builtins.property
    @pulumi.getter(name="sshPublicAccessEnabled")
    def ssh_public_access_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        A boolean value indicating whether enable the public SSH port. Defaults to `false`. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "ssh_public_access_enabled")

    @_builtins.property
    @pulumi.getter(name="subnetResourceId")
    def subnet_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Subnet that the Compute Cluster should reside in. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "subnet_resource_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the Machine Learning Compute Cluster.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="vmPriority")
    def vm_priority(self) -> pulumi.Output[_builtins.str]:
        """
        The priority of the VM. Changing this forces a new Machine Learning Compute Cluster to be created. Accepted values are `Dedicated` and `LowPriority`.
        """
        return pulumi.get(self, "vm_priority")

    @_builtins.property
    @pulumi.getter(name="vmSize")
    def vm_size(self) -> pulumi.Output[_builtins.str]:
        """
        The size of the VM. Changing this forces a new Machine Learning Compute Cluster to be created.
        """
        return pulumi.get(self, "vm_size")

