# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['WorkspaceArgs', 'Workspace']

@pulumi.input_type
class WorkspaceArgs:
    def __init__(__self__, *,
                 application_insights_id: pulumi.Input[_builtins.str],
                 identity: pulumi.Input['WorkspaceIdentityArgs'],
                 key_vault_id: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 storage_account_id: pulumi.Input[_builtins.str],
                 container_registry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption: Optional[pulumi.Input['WorkspaceEncryptionArgs']] = None,
                 feature_store: Optional[pulumi.Input['WorkspaceFeatureStoreArgs']] = None,
                 friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
                 high_business_impact: Optional[pulumi.Input[_builtins.bool]] = None,
                 image_build_compute_name: Optional[pulumi.Input[_builtins.str]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_network: Optional[pulumi.Input['WorkspaceManagedNetworkArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_user_assigned_identity: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 serverless_compute: Optional[pulumi.Input['WorkspaceServerlessComputeArgs']] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 v1_legacy_mode_enabled: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a Workspace resource.
        :param pulumi.Input[_builtins.str] application_insights_id: The ID of the Application Insights associated with this Machine Learning Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input['WorkspaceIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] key_vault_id: The ID of key vault associated with this Machine Learning Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group in which the Machine Learning Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account associated with this Machine Learning Workspace. Changing this forces a new resource to be created.
               
               > **Note:** The `account_tier` cannot be `Premium` in order to associate the Storage Account to this Machine Learning Workspace.
        :param pulumi.Input[_builtins.str] container_registry_id: The ID of the container registry associated with this Machine Learning Workspace. Changing this forces a new resource to be created.
               
               > **Note:** The `admin_enabled` should be `true` in order to associate the Container Registry to this Machine Learning Workspace.
        :param pulumi.Input[_builtins.str] description: The description of this Machine Learning Workspace.
        :param pulumi.Input['WorkspaceEncryptionArgs'] encryption: An `encryption` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input['WorkspaceFeatureStoreArgs'] feature_store: A `feature_store` block as defined below.
        :param pulumi.Input[_builtins.str] friendly_name: Display name for this Machine Learning Workspace.
        :param pulumi.Input[_builtins.bool] high_business_impact: Flag to signal High Business Impact (HBI) data in the workspace and reduce diagnostic data collected by the service. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] image_build_compute_name: The compute name for image build of the Machine Learning Workspace.
        :param pulumi.Input[_builtins.str] kind: The type of the Workspace. Possible values are `Default`, `FeatureStore`. Defaults to `Default`
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the Machine Learning Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['WorkspaceManagedNetworkArgs'] managed_network: A `managed_network` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Machine Learning Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] primary_user_assigned_identity: The user assigned identity id that represents the workspace identity.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Enable public access when this Machine Learning Workspace is behind VNet. Defaults to `true`.
               
               > **Note:** `public_access_behind_virtual_network_enabled` is deprecated and will be removed in favour of the property `public_network_access_enabled`.
        :param pulumi.Input['WorkspaceServerlessComputeArgs'] serverless_compute: A `serverless_compute` block as defined below.
        :param pulumi.Input[_builtins.str] sku_name: SKU/edition of the Machine Learning Workspace, possible values are `Free`, `Basic`, `Standard` and `Premium`. Defaults to `Basic`.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.bool] v1_legacy_mode_enabled: Enable V1 API features, enabling `v1_legacy_mode` may prevent you from using features provided by the v2 API. Defaults to `false`.
        """
        pulumi.set(__self__, "application_insights_id", application_insights_id)
        pulumi.set(__self__, "identity", identity)
        pulumi.set(__self__, "key_vault_id", key_vault_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "storage_account_id", storage_account_id)
        if container_registry_id is not None:
            pulumi.set(__self__, "container_registry_id", container_registry_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if feature_store is not None:
            pulumi.set(__self__, "feature_store", feature_store)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if high_business_impact is not None:
            pulumi.set(__self__, "high_business_impact", high_business_impact)
        if image_build_compute_name is not None:
            pulumi.set(__self__, "image_build_compute_name", image_build_compute_name)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_network is not None:
            pulumi.set(__self__, "managed_network", managed_network)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_user_assigned_identity is not None:
            pulumi.set(__self__, "primary_user_assigned_identity", primary_user_assigned_identity)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if serverless_compute is not None:
            pulumi.set(__self__, "serverless_compute", serverless_compute)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if v1_legacy_mode_enabled is not None:
            pulumi.set(__self__, "v1_legacy_mode_enabled", v1_legacy_mode_enabled)

    @_builtins.property
    @pulumi.getter(name="applicationInsightsId")
    def application_insights_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Application Insights associated with this Machine Learning Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "application_insights_id")

    @application_insights_id.setter
    def application_insights_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "application_insights_id", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Input['WorkspaceIdentityArgs']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: pulumi.Input['WorkspaceIdentityArgs']):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of key vault associated with this Machine Learning Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_id")

    @key_vault_id.setter
    def key_vault_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "key_vault_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Resource Group in which the Machine Learning Workspace should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Storage Account associated with this Machine Learning Workspace. Changing this forces a new resource to be created.

        > **Note:** The `account_tier` cannot be `Premium` in order to associate the Storage Account to this Machine Learning Workspace.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "storage_account_id", value)

    @_builtins.property
    @pulumi.getter(name="containerRegistryId")
    def container_registry_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the container registry associated with this Machine Learning Workspace. Changing this forces a new resource to be created.

        > **Note:** The `admin_enabled` should be `true` in order to associate the Container Registry to this Machine Learning Workspace.
        """
        return pulumi.get(self, "container_registry_id")

    @container_registry_id.setter
    def container_registry_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_registry_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of this Machine Learning Workspace.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['WorkspaceEncryptionArgs']]:
        """
        An `encryption` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['WorkspaceEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @_builtins.property
    @pulumi.getter(name="featureStore")
    def feature_store(self) -> Optional[pulumi.Input['WorkspaceFeatureStoreArgs']]:
        """
        A `feature_store` block as defined below.
        """
        return pulumi.get(self, "feature_store")

    @feature_store.setter
    def feature_store(self, value: Optional[pulumi.Input['WorkspaceFeatureStoreArgs']]):
        pulumi.set(self, "feature_store", value)

    @_builtins.property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Display name for this Machine Learning Workspace.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "friendly_name", value)

    @_builtins.property
    @pulumi.getter(name="highBusinessImpact")
    def high_business_impact(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to signal High Business Impact (HBI) data in the workspace and reduce diagnostic data collected by the service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "high_business_impact")

    @high_business_impact.setter
    def high_business_impact(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "high_business_impact", value)

    @_builtins.property
    @pulumi.getter(name="imageBuildComputeName")
    def image_build_compute_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The compute name for image build of the Machine Learning Workspace.
        """
        return pulumi.get(self, "image_build_compute_name")

    @image_build_compute_name.setter
    def image_build_compute_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_build_compute_name", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the Workspace. Possible values are `Default`, `FeatureStore`. Defaults to `Default`
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the Machine Learning Workspace should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managedNetwork")
    def managed_network(self) -> Optional[pulumi.Input['WorkspaceManagedNetworkArgs']]:
        """
        A `managed_network` block as defined below.
        """
        return pulumi.get(self, "managed_network")

    @managed_network.setter
    def managed_network(self, value: Optional[pulumi.Input['WorkspaceManagedNetworkArgs']]):
        pulumi.set(self, "managed_network", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Machine Learning Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="primaryUserAssignedIdentity")
    def primary_user_assigned_identity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user assigned identity id that represents the workspace identity.
        """
        return pulumi.get(self, "primary_user_assigned_identity")

    @primary_user_assigned_identity.setter
    def primary_user_assigned_identity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_user_assigned_identity", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable public access when this Machine Learning Workspace is behind VNet. Defaults to `true`.

        > **Note:** `public_access_behind_virtual_network_enabled` is deprecated and will be removed in favour of the property `public_network_access_enabled`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="serverlessCompute")
    def serverless_compute(self) -> Optional[pulumi.Input['WorkspaceServerlessComputeArgs']]:
        """
        A `serverless_compute` block as defined below.
        """
        return pulumi.get(self, "serverless_compute")

    @serverless_compute.setter
    def serverless_compute(self, value: Optional[pulumi.Input['WorkspaceServerlessComputeArgs']]):
        pulumi.set(self, "serverless_compute", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SKU/edition of the Machine Learning Workspace, possible values are `Free`, `Basic`, `Standard` and `Premium`. Defaults to `Basic`.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="v1LegacyModeEnabled")
    def v1_legacy_mode_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable V1 API features, enabling `v1_legacy_mode` may prevent you from using features provided by the v2 API. Defaults to `false`.
        """
        return pulumi.get(self, "v1_legacy_mode_enabled")

    @v1_legacy_mode_enabled.setter
    def v1_legacy_mode_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "v1_legacy_mode_enabled", value)


@pulumi.input_type
class _WorkspaceState:
    def __init__(__self__, *,
                 application_insights_id: Optional[pulumi.Input[_builtins.str]] = None,
                 container_registry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 discovery_url: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption: Optional[pulumi.Input['WorkspaceEncryptionArgs']] = None,
                 feature_store: Optional[pulumi.Input['WorkspaceFeatureStoreArgs']] = None,
                 friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
                 high_business_impact: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input['WorkspaceIdentityArgs']] = None,
                 image_build_compute_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_network: Optional[pulumi.Input['WorkspaceManagedNetworkArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_user_assigned_identity: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 serverless_compute: Optional[pulumi.Input['WorkspaceServerlessComputeArgs']] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 v1_legacy_mode_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 workspace_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering Workspace resources.
        :param pulumi.Input[_builtins.str] application_insights_id: The ID of the Application Insights associated with this Machine Learning Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] container_registry_id: The ID of the container registry associated with this Machine Learning Workspace. Changing this forces a new resource to be created.
               
               > **Note:** The `admin_enabled` should be `true` in order to associate the Container Registry to this Machine Learning Workspace.
        :param pulumi.Input[_builtins.str] description: The description of this Machine Learning Workspace.
        :param pulumi.Input[_builtins.str] discovery_url: The url for the discovery service to identify regional endpoints for machine learning experimentation services.
        :param pulumi.Input['WorkspaceEncryptionArgs'] encryption: An `encryption` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input['WorkspaceFeatureStoreArgs'] feature_store: A `feature_store` block as defined below.
        :param pulumi.Input[_builtins.str] friendly_name: Display name for this Machine Learning Workspace.
        :param pulumi.Input[_builtins.bool] high_business_impact: Flag to signal High Business Impact (HBI) data in the workspace and reduce diagnostic data collected by the service. Changing this forces a new resource to be created.
        :param pulumi.Input['WorkspaceIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] image_build_compute_name: The compute name for image build of the Machine Learning Workspace.
        :param pulumi.Input[_builtins.str] key_vault_id: The ID of key vault associated with this Machine Learning Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] kind: The type of the Workspace. Possible values are `Default`, `FeatureStore`. Defaults to `Default`
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the Machine Learning Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['WorkspaceManagedNetworkArgs'] managed_network: A `managed_network` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Machine Learning Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] primary_user_assigned_identity: The user assigned identity id that represents the workspace identity.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Enable public access when this Machine Learning Workspace is behind VNet. Defaults to `true`.
               
               > **Note:** `public_access_behind_virtual_network_enabled` is deprecated and will be removed in favour of the property `public_network_access_enabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group in which the Machine Learning Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input['WorkspaceServerlessComputeArgs'] serverless_compute: A `serverless_compute` block as defined below.
        :param pulumi.Input[_builtins.str] sku_name: SKU/edition of the Machine Learning Workspace, possible values are `Free`, `Basic`, `Standard` and `Premium`. Defaults to `Basic`.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account associated with this Machine Learning Workspace. Changing this forces a new resource to be created.
               
               > **Note:** The `account_tier` cannot be `Premium` in order to associate the Storage Account to this Machine Learning Workspace.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.bool] v1_legacy_mode_enabled: Enable V1 API features, enabling `v1_legacy_mode` may prevent you from using features provided by the v2 API. Defaults to `false`.
        :param pulumi.Input[_builtins.str] workspace_id: The immutable id associated with this workspace.
        """
        if application_insights_id is not None:
            pulumi.set(__self__, "application_insights_id", application_insights_id)
        if container_registry_id is not None:
            pulumi.set(__self__, "container_registry_id", container_registry_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if discovery_url is not None:
            pulumi.set(__self__, "discovery_url", discovery_url)
        if encryption is not None:
            pulumi.set(__self__, "encryption", encryption)
        if feature_store is not None:
            pulumi.set(__self__, "feature_store", feature_store)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if high_business_impact is not None:
            pulumi.set(__self__, "high_business_impact", high_business_impact)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if image_build_compute_name is not None:
            pulumi.set(__self__, "image_build_compute_name", image_build_compute_name)
        if key_vault_id is not None:
            pulumi.set(__self__, "key_vault_id", key_vault_id)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if managed_network is not None:
            pulumi.set(__self__, "managed_network", managed_network)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if primary_user_assigned_identity is not None:
            pulumi.set(__self__, "primary_user_assigned_identity", primary_user_assigned_identity)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if serverless_compute is not None:
            pulumi.set(__self__, "serverless_compute", serverless_compute)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if storage_account_id is not None:
            pulumi.set(__self__, "storage_account_id", storage_account_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if v1_legacy_mode_enabled is not None:
            pulumi.set(__self__, "v1_legacy_mode_enabled", v1_legacy_mode_enabled)
        if workspace_id is not None:
            pulumi.set(__self__, "workspace_id", workspace_id)

    @_builtins.property
    @pulumi.getter(name="applicationInsightsId")
    def application_insights_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Application Insights associated with this Machine Learning Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "application_insights_id")

    @application_insights_id.setter
    def application_insights_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "application_insights_id", value)

    @_builtins.property
    @pulumi.getter(name="containerRegistryId")
    def container_registry_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the container registry associated with this Machine Learning Workspace. Changing this forces a new resource to be created.

        > **Note:** The `admin_enabled` should be `true` in order to associate the Container Registry to this Machine Learning Workspace.
        """
        return pulumi.get(self, "container_registry_id")

    @container_registry_id.setter
    def container_registry_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "container_registry_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of this Machine Learning Workspace.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="discoveryUrl")
    def discovery_url(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The url for the discovery service to identify regional endpoints for machine learning experimentation services.
        """
        return pulumi.get(self, "discovery_url")

    @discovery_url.setter
    def discovery_url(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "discovery_url", value)

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> Optional[pulumi.Input['WorkspaceEncryptionArgs']]:
        """
        An `encryption` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encryption")

    @encryption.setter
    def encryption(self, value: Optional[pulumi.Input['WorkspaceEncryptionArgs']]):
        pulumi.set(self, "encryption", value)

    @_builtins.property
    @pulumi.getter(name="featureStore")
    def feature_store(self) -> Optional[pulumi.Input['WorkspaceFeatureStoreArgs']]:
        """
        A `feature_store` block as defined below.
        """
        return pulumi.get(self, "feature_store")

    @feature_store.setter
    def feature_store(self, value: Optional[pulumi.Input['WorkspaceFeatureStoreArgs']]):
        pulumi.set(self, "feature_store", value)

    @_builtins.property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Display name for this Machine Learning Workspace.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "friendly_name", value)

    @_builtins.property
    @pulumi.getter(name="highBusinessImpact")
    def high_business_impact(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Flag to signal High Business Impact (HBI) data in the workspace and reduce diagnostic data collected by the service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "high_business_impact")

    @high_business_impact.setter
    def high_business_impact(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "high_business_impact", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['WorkspaceIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['WorkspaceIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter(name="imageBuildComputeName")
    def image_build_compute_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The compute name for image build of the Machine Learning Workspace.
        """
        return pulumi.get(self, "image_build_compute_name")

    @image_build_compute_name.setter
    def image_build_compute_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "image_build_compute_name", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of key vault associated with this Machine Learning Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_id")

    @key_vault_id.setter
    def key_vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_id", value)

    @_builtins.property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The type of the Workspace. Possible values are `Default`, `FeatureStore`. Defaults to `Default`
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "kind", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the Machine Learning Workspace should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="managedNetwork")
    def managed_network(self) -> Optional[pulumi.Input['WorkspaceManagedNetworkArgs']]:
        """
        A `managed_network` block as defined below.
        """
        return pulumi.get(self, "managed_network")

    @managed_network.setter
    def managed_network(self, value: Optional[pulumi.Input['WorkspaceManagedNetworkArgs']]):
        pulumi.set(self, "managed_network", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Machine Learning Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="primaryUserAssignedIdentity")
    def primary_user_assigned_identity(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The user assigned identity id that represents the workspace identity.
        """
        return pulumi.get(self, "primary_user_assigned_identity")

    @primary_user_assigned_identity.setter
    def primary_user_assigned_identity(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_user_assigned_identity", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable public access when this Machine Learning Workspace is behind VNet. Defaults to `true`.

        > **Note:** `public_access_behind_virtual_network_enabled` is deprecated and will be removed in favour of the property `public_network_access_enabled`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Resource Group in which the Machine Learning Workspace should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="serverlessCompute")
    def serverless_compute(self) -> Optional[pulumi.Input['WorkspaceServerlessComputeArgs']]:
        """
        A `serverless_compute` block as defined below.
        """
        return pulumi.get(self, "serverless_compute")

    @serverless_compute.setter
    def serverless_compute(self, value: Optional[pulumi.Input['WorkspaceServerlessComputeArgs']]):
        pulumi.set(self, "serverless_compute", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        SKU/edition of the Machine Learning Workspace, possible values are `Free`, `Basic`, `Standard` and `Premium`. Defaults to `Basic`.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Storage Account associated with this Machine Learning Workspace. Changing this forces a new resource to be created.

        > **Note:** The `account_tier` cannot be `Premium` in order to associate the Storage Account to this Machine Learning Workspace.
        """
        return pulumi.get(self, "storage_account_id")

    @storage_account_id.setter
    def storage_account_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "storage_account_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="v1LegacyModeEnabled")
    def v1_legacy_mode_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Enable V1 API features, enabling `v1_legacy_mode` may prevent you from using features provided by the v2 API. Defaults to `false`.
        """
        return pulumi.get(self, "v1_legacy_mode_enabled")

    @v1_legacy_mode_enabled.setter
    def v1_legacy_mode_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "v1_legacy_mode_enabled", value)

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The immutable id associated with this workspace.
        """
        return pulumi.get(self, "workspace_id")

    @workspace_id.setter
    def workspace_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "workspace_id", value)


@pulumi.type_token("azure:machinelearning/workspace:Workspace")
class Workspace(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_insights_id: Optional[pulumi.Input[_builtins.str]] = None,
                 container_registry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption: Optional[pulumi.Input[Union['WorkspaceEncryptionArgs', 'WorkspaceEncryptionArgsDict']]] = None,
                 feature_store: Optional[pulumi.Input[Union['WorkspaceFeatureStoreArgs', 'WorkspaceFeatureStoreArgsDict']]] = None,
                 friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
                 high_business_impact: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['WorkspaceIdentityArgs', 'WorkspaceIdentityArgsDict']]] = None,
                 image_build_compute_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_network: Optional[pulumi.Input[Union['WorkspaceManagedNetworkArgs', 'WorkspaceManagedNetworkArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_user_assigned_identity: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 serverless_compute: Optional[pulumi.Input[Union['WorkspaceServerlessComputeArgs', 'WorkspaceServerlessComputeArgsDict']]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 v1_legacy_mode_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="workspace-example-ai",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="workspaceexamplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium")
        example_account = azure.storage.Account("example",
            name="workspacestorageaccount",
            location=example.location,
            resource_group_name=example.name,
            account_tier="Standard",
            account_replication_type="GRS")
        example_workspace = azure.machinelearning.Workspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            application_insights_id=example_insights.id,
            key_vault_id=example_key_vault.id,
            storage_account_id=example_account.id,
            identity={
                "type": "SystemAssigned",
            })
        ```

        ### With Data Encryption

        > **Note:** The Key Vault must enable purge protection.

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="workspace-example-ai",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="workspaceexamplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium",
            purge_protection_enabled=True)
        example_access_policy = azure.keyvault.AccessPolicy("example",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            key_permissions=[
                "Create",
                "Get",
                "Delete",
                "Purge",
                "GetRotationPolicy",
            ])
        example_account = azure.storage.Account("example",
            name="workspacestorageaccount",
            location=example.location,
            resource_group_name=example.name,
            account_tier="Standard",
            account_replication_type="GRS")
        example_key = azure.keyvault.Key("example",
            name="workspaceexamplekeyvaultkey",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "decrypt",
                "encrypt",
                "sign",
                "unwrapKey",
                "verify",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    example_key_vault,
                    example_access_policy,
                ]))
        example_workspace = azure.machinelearning.Workspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            application_insights_id=example_insights.id,
            key_vault_id=example_key_vault.id,
            storage_account_id=example_account.id,
            identity={
                "type": "SystemAssigned",
            },
            encryption={
                "key_vault_id": example_key_vault.id,
                "key_id": example_key.id,
            })
        ```

        ### With User Assigned Identity And Data Encryption

        > **Note:** The Key Vault must enable purge protection.

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="example-ai",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_account = azure.storage.Account("example",
            name="examplestorageaccount",
            location=example.location,
            resource_group_name=example.name,
            account_tier="Standard",
            account_replication_type="GRS")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example-keyvalut",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium",
            purge_protection_enabled=True)
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="example-identity",
            location=example.location,
            resource_group_name=example.name)
        example_identity = azure.keyvault.AccessPolicy("example-identity",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=example_user_assigned_identity.principal_id,
            key_permissions=[
                "WrapKey",
                "UnwrapKey",
                "Get",
                "Recover",
            ],
            secret_permissions=[
                "Get",
                "List",
                "Set",
                "Delete",
                "Recover",
                "Backup",
                "Restore",
            ])
        example_sp = azure.keyvault.AccessPolicy("example-sp",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            key_permissions=[
                "Get",
                "Create",
                "Recover",
                "Delete",
                "Purge",
                "GetRotationPolicy",
            ])
        test = azuread.get_service_principal(display_name="Azure Cosmos DB")
        example_cosmosdb = azure.keyvault.AccessPolicy("example-cosmosdb",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=test.object_id,
            key_permissions=[
                "Get",
                "Recover",
                "UnwrapKey",
                "WrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    test,
                    current,
                ]))
        example_key = azure.keyvault.Key("example",
            name="example-keyvaultkey",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "decrypt",
                "encrypt",
                "sign",
                "unwrapKey",
                "verify",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    example_key_vault,
                    example_sp,
                ]))
        example_role1 = azure.authorization.Assignment("example-role1",
            scope=example_key_vault.id,
            role_definition_name="Contributor",
            principal_id=example_user_assigned_identity.principal_id)
        example_role2 = azure.authorization.Assignment("example-role2",
            scope=example_account.id,
            role_definition_name="Storage Blob Data Contributor",
            principal_id=example_user_assigned_identity.principal_id)
        example_role3 = azure.authorization.Assignment("example-role3",
            scope=example_account.id,
            role_definition_name="Contributor",
            principal_id=example_user_assigned_identity.principal_id)
        example_role4 = azure.authorization.Assignment("example-role4",
            scope=example_insights.id,
            role_definition_name="Contributor",
            principal_id=example_user_assigned_identity.principal_id)
        example_workspace = azure.machinelearning.Workspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            application_insights_id=example_insights.id,
            key_vault_id=example_key_vault.id,
            storage_account_id=example_account.id,
            high_business_impact=True,
            primary_user_assigned_identity=example_user_assigned_identity.id,
            identity={
                "type": "UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            },
            encryption={
                "user_assigned_identity_id": example_user_assigned_identity.id,
                "key_vault_id": example_key_vault.id,
                "key_id": example_key.id,
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    example_role1,
                    example_role2,
                    example_role3,
                    example_role4,
                    example_cosmosdb,
                ]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MachineLearningServices` - 2025-06-01

        ## Import

        Machine Learning Workspace can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:machinelearning/workspace:Workspace example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.MachineLearningServices/workspaces/workspace1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_insights_id: The ID of the Application Insights associated with this Machine Learning Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] container_registry_id: The ID of the container registry associated with this Machine Learning Workspace. Changing this forces a new resource to be created.
               
               > **Note:** The `admin_enabled` should be `true` in order to associate the Container Registry to this Machine Learning Workspace.
        :param pulumi.Input[_builtins.str] description: The description of this Machine Learning Workspace.
        :param pulumi.Input[Union['WorkspaceEncryptionArgs', 'WorkspaceEncryptionArgsDict']] encryption: An `encryption` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['WorkspaceFeatureStoreArgs', 'WorkspaceFeatureStoreArgsDict']] feature_store: A `feature_store` block as defined below.
        :param pulumi.Input[_builtins.str] friendly_name: Display name for this Machine Learning Workspace.
        :param pulumi.Input[_builtins.bool] high_business_impact: Flag to signal High Business Impact (HBI) data in the workspace and reduce diagnostic data collected by the service. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['WorkspaceIdentityArgs', 'WorkspaceIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] image_build_compute_name: The compute name for image build of the Machine Learning Workspace.
        :param pulumi.Input[_builtins.str] key_vault_id: The ID of key vault associated with this Machine Learning Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] kind: The type of the Workspace. Possible values are `Default`, `FeatureStore`. Defaults to `Default`
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the Machine Learning Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['WorkspaceManagedNetworkArgs', 'WorkspaceManagedNetworkArgsDict']] managed_network: A `managed_network` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Machine Learning Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] primary_user_assigned_identity: The user assigned identity id that represents the workspace identity.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Enable public access when this Machine Learning Workspace is behind VNet. Defaults to `true`.
               
               > **Note:** `public_access_behind_virtual_network_enabled` is deprecated and will be removed in favour of the property `public_network_access_enabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group in which the Machine Learning Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['WorkspaceServerlessComputeArgs', 'WorkspaceServerlessComputeArgsDict']] serverless_compute: A `serverless_compute` block as defined below.
        :param pulumi.Input[_builtins.str] sku_name: SKU/edition of the Machine Learning Workspace, possible values are `Free`, `Basic`, `Standard` and `Premium`. Defaults to `Basic`.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account associated with this Machine Learning Workspace. Changing this forces a new resource to be created.
               
               > **Note:** The `account_tier` cannot be `Premium` in order to associate the Storage Account to this Machine Learning Workspace.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.bool] v1_legacy_mode_enabled: Enable V1 API features, enabling `v1_legacy_mode` may prevent you from using features provided by the v2 API. Defaults to `false`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: WorkspaceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="workspace-example-ai",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="workspaceexamplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium")
        example_account = azure.storage.Account("example",
            name="workspacestorageaccount",
            location=example.location,
            resource_group_name=example.name,
            account_tier="Standard",
            account_replication_type="GRS")
        example_workspace = azure.machinelearning.Workspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            application_insights_id=example_insights.id,
            key_vault_id=example_key_vault.id,
            storage_account_id=example_account.id,
            identity={
                "type": "SystemAssigned",
            })
        ```

        ### With Data Encryption

        > **Note:** The Key Vault must enable purge protection.

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="workspace-example-ai",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="workspaceexamplekeyvault",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium",
            purge_protection_enabled=True)
        example_access_policy = azure.keyvault.AccessPolicy("example",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            key_permissions=[
                "Create",
                "Get",
                "Delete",
                "Purge",
                "GetRotationPolicy",
            ])
        example_account = azure.storage.Account("example",
            name="workspacestorageaccount",
            location=example.location,
            resource_group_name=example.name,
            account_tier="Standard",
            account_replication_type="GRS")
        example_key = azure.keyvault.Key("example",
            name="workspaceexamplekeyvaultkey",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "decrypt",
                "encrypt",
                "sign",
                "unwrapKey",
                "verify",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    example_key_vault,
                    example_access_policy,
                ]))
        example_workspace = azure.machinelearning.Workspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            application_insights_id=example_insights.id,
            key_vault_id=example_key_vault.id,
            storage_account_id=example_account.id,
            identity={
                "type": "SystemAssigned",
            },
            encryption={
                "key_vault_id": example_key_vault.id,
                "key_id": example_key.id,
            })
        ```

        ### With User Assigned Identity And Data Encryption

        > **Note:** The Key Vault must enable purge protection.

        ```python
        import pulumi
        import pulumi_azure as azure
        import pulumi_azuread as azuread

        current = azure.core.get_client_config()
        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_insights = azure.appinsights.Insights("example",
            name="example-ai",
            location=example.location,
            resource_group_name=example.name,
            application_type="web")
        example_account = azure.storage.Account("example",
            name="examplestorageaccount",
            location=example.location,
            resource_group_name=example.name,
            account_tier="Standard",
            account_replication_type="GRS")
        example_key_vault = azure.keyvault.KeyVault("example",
            name="example-keyvalut",
            location=example.location,
            resource_group_name=example.name,
            tenant_id=current.tenant_id,
            sku_name="premium",
            purge_protection_enabled=True)
        example_user_assigned_identity = azure.authorization.UserAssignedIdentity("example",
            name="example-identity",
            location=example.location,
            resource_group_name=example.name)
        example_identity = azure.keyvault.AccessPolicy("example-identity",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=example_user_assigned_identity.principal_id,
            key_permissions=[
                "WrapKey",
                "UnwrapKey",
                "Get",
                "Recover",
            ],
            secret_permissions=[
                "Get",
                "List",
                "Set",
                "Delete",
                "Recover",
                "Backup",
                "Restore",
            ])
        example_sp = azure.keyvault.AccessPolicy("example-sp",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=current.object_id,
            key_permissions=[
                "Get",
                "Create",
                "Recover",
                "Delete",
                "Purge",
                "GetRotationPolicy",
            ])
        test = azuread.get_service_principal(display_name="Azure Cosmos DB")
        example_cosmosdb = azure.keyvault.AccessPolicy("example-cosmosdb",
            key_vault_id=example_key_vault.id,
            tenant_id=current.tenant_id,
            object_id=test.object_id,
            key_permissions=[
                "Get",
                "Recover",
                "UnwrapKey",
                "WrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    test,
                    current,
                ]))
        example_key = azure.keyvault.Key("example",
            name="example-keyvaultkey",
            key_vault_id=example_key_vault.id,
            key_type="RSA",
            key_size=2048,
            key_opts=[
                "decrypt",
                "encrypt",
                "sign",
                "unwrapKey",
                "verify",
                "wrapKey",
            ],
            opts = pulumi.ResourceOptions(depends_on=[
                    example_key_vault,
                    example_sp,
                ]))
        example_role1 = azure.authorization.Assignment("example-role1",
            scope=example_key_vault.id,
            role_definition_name="Contributor",
            principal_id=example_user_assigned_identity.principal_id)
        example_role2 = azure.authorization.Assignment("example-role2",
            scope=example_account.id,
            role_definition_name="Storage Blob Data Contributor",
            principal_id=example_user_assigned_identity.principal_id)
        example_role3 = azure.authorization.Assignment("example-role3",
            scope=example_account.id,
            role_definition_name="Contributor",
            principal_id=example_user_assigned_identity.principal_id)
        example_role4 = azure.authorization.Assignment("example-role4",
            scope=example_insights.id,
            role_definition_name="Contributor",
            principal_id=example_user_assigned_identity.principal_id)
        example_workspace = azure.machinelearning.Workspace("example",
            name="example-workspace",
            location=example.location,
            resource_group_name=example.name,
            application_insights_id=example_insights.id,
            key_vault_id=example_key_vault.id,
            storage_account_id=example_account.id,
            high_business_impact=True,
            primary_user_assigned_identity=example_user_assigned_identity.id,
            identity={
                "type": "UserAssigned",
                "identity_ids": [example_user_assigned_identity.id],
            },
            encryption={
                "user_assigned_identity_id": example_user_assigned_identity.id,
                "key_vault_id": example_key_vault.id,
                "key_id": example_key.id,
            },
            opts = pulumi.ResourceOptions(depends_on=[
                    example_role1,
                    example_role2,
                    example_role3,
                    example_role4,
                    example_cosmosdb,
                ]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.MachineLearningServices` - 2025-06-01

        ## Import

        Machine Learning Workspace can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:machinelearning/workspace:Workspace example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.MachineLearningServices/workspaces/workspace1
        ```

        :param str resource_name: The name of the resource.
        :param WorkspaceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(WorkspaceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 application_insights_id: Optional[pulumi.Input[_builtins.str]] = None,
                 container_registry_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 encryption: Optional[pulumi.Input[Union['WorkspaceEncryptionArgs', 'WorkspaceEncryptionArgsDict']]] = None,
                 feature_store: Optional[pulumi.Input[Union['WorkspaceFeatureStoreArgs', 'WorkspaceFeatureStoreArgsDict']]] = None,
                 friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
                 high_business_impact: Optional[pulumi.Input[_builtins.bool]] = None,
                 identity: Optional[pulumi.Input[Union['WorkspaceIdentityArgs', 'WorkspaceIdentityArgsDict']]] = None,
                 image_build_compute_name: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 kind: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 managed_network: Optional[pulumi.Input[Union['WorkspaceManagedNetworkArgs', 'WorkspaceManagedNetworkArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_user_assigned_identity: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 serverless_compute: Optional[pulumi.Input[Union['WorkspaceServerlessComputeArgs', 'WorkspaceServerlessComputeArgsDict']]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 v1_legacy_mode_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = WorkspaceArgs.__new__(WorkspaceArgs)

            if application_insights_id is None and not opts.urn:
                raise TypeError("Missing required property 'application_insights_id'")
            __props__.__dict__["application_insights_id"] = application_insights_id
            __props__.__dict__["container_registry_id"] = container_registry_id
            __props__.__dict__["description"] = description
            __props__.__dict__["encryption"] = encryption
            __props__.__dict__["feature_store"] = feature_store
            __props__.__dict__["friendly_name"] = friendly_name
            __props__.__dict__["high_business_impact"] = high_business_impact
            if identity is None and not opts.urn:
                raise TypeError("Missing required property 'identity'")
            __props__.__dict__["identity"] = identity
            __props__.__dict__["image_build_compute_name"] = image_build_compute_name
            if key_vault_id is None and not opts.urn:
                raise TypeError("Missing required property 'key_vault_id'")
            __props__.__dict__["key_vault_id"] = key_vault_id
            __props__.__dict__["kind"] = kind
            __props__.__dict__["location"] = location
            __props__.__dict__["managed_network"] = managed_network
            __props__.__dict__["name"] = name
            __props__.__dict__["primary_user_assigned_identity"] = primary_user_assigned_identity
            __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["serverless_compute"] = serverless_compute
            __props__.__dict__["sku_name"] = sku_name
            if storage_account_id is None and not opts.urn:
                raise TypeError("Missing required property 'storage_account_id'")
            __props__.__dict__["storage_account_id"] = storage_account_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["v1_legacy_mode_enabled"] = v1_legacy_mode_enabled
            __props__.__dict__["discovery_url"] = None
            __props__.__dict__["workspace_id"] = None
        super(Workspace, __self__).__init__(
            'azure:machinelearning/workspace:Workspace',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            application_insights_id: Optional[pulumi.Input[_builtins.str]] = None,
            container_registry_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            discovery_url: Optional[pulumi.Input[_builtins.str]] = None,
            encryption: Optional[pulumi.Input[Union['WorkspaceEncryptionArgs', 'WorkspaceEncryptionArgsDict']]] = None,
            feature_store: Optional[pulumi.Input[Union['WorkspaceFeatureStoreArgs', 'WorkspaceFeatureStoreArgsDict']]] = None,
            friendly_name: Optional[pulumi.Input[_builtins.str]] = None,
            high_business_impact: Optional[pulumi.Input[_builtins.bool]] = None,
            identity: Optional[pulumi.Input[Union['WorkspaceIdentityArgs', 'WorkspaceIdentityArgsDict']]] = None,
            image_build_compute_name: Optional[pulumi.Input[_builtins.str]] = None,
            key_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
            kind: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            managed_network: Optional[pulumi.Input[Union['WorkspaceManagedNetworkArgs', 'WorkspaceManagedNetworkArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            primary_user_assigned_identity: Optional[pulumi.Input[_builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            serverless_compute: Optional[pulumi.Input[Union['WorkspaceServerlessComputeArgs', 'WorkspaceServerlessComputeArgsDict']]] = None,
            sku_name: Optional[pulumi.Input[_builtins.str]] = None,
            storage_account_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            v1_legacy_mode_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            workspace_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'Workspace':
        """
        Get an existing Workspace resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] application_insights_id: The ID of the Application Insights associated with this Machine Learning Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] container_registry_id: The ID of the container registry associated with this Machine Learning Workspace. Changing this forces a new resource to be created.
               
               > **Note:** The `admin_enabled` should be `true` in order to associate the Container Registry to this Machine Learning Workspace.
        :param pulumi.Input[_builtins.str] description: The description of this Machine Learning Workspace.
        :param pulumi.Input[_builtins.str] discovery_url: The url for the discovery service to identify regional endpoints for machine learning experimentation services.
        :param pulumi.Input[Union['WorkspaceEncryptionArgs', 'WorkspaceEncryptionArgsDict']] encryption: An `encryption` block as defined below. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['WorkspaceFeatureStoreArgs', 'WorkspaceFeatureStoreArgsDict']] feature_store: A `feature_store` block as defined below.
        :param pulumi.Input[_builtins.str] friendly_name: Display name for this Machine Learning Workspace.
        :param pulumi.Input[_builtins.bool] high_business_impact: Flag to signal High Business Impact (HBI) data in the workspace and reduce diagnostic data collected by the service. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['WorkspaceIdentityArgs', 'WorkspaceIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] image_build_compute_name: The compute name for image build of the Machine Learning Workspace.
        :param pulumi.Input[_builtins.str] key_vault_id: The ID of key vault associated with this Machine Learning Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] kind: The type of the Workspace. Possible values are `Default`, `FeatureStore`. Defaults to `Default`
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the Machine Learning Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['WorkspaceManagedNetworkArgs', 'WorkspaceManagedNetworkArgsDict']] managed_network: A `managed_network` block as defined below.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Machine Learning Workspace. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] primary_user_assigned_identity: The user assigned identity id that represents the workspace identity.
        :param pulumi.Input[_builtins.bool] public_network_access_enabled: Enable public access when this Machine Learning Workspace is behind VNet. Defaults to `true`.
               
               > **Note:** `public_access_behind_virtual_network_enabled` is deprecated and will be removed in favour of the property `public_network_access_enabled`.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group in which the Machine Learning Workspace should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[Union['WorkspaceServerlessComputeArgs', 'WorkspaceServerlessComputeArgsDict']] serverless_compute: A `serverless_compute` block as defined below.
        :param pulumi.Input[_builtins.str] sku_name: SKU/edition of the Machine Learning Workspace, possible values are `Free`, `Basic`, `Standard` and `Premium`. Defaults to `Basic`.
        :param pulumi.Input[_builtins.str] storage_account_id: The ID of the Storage Account associated with this Machine Learning Workspace. Changing this forces a new resource to be created.
               
               > **Note:** The `account_tier` cannot be `Premium` in order to associate the Storage Account to this Machine Learning Workspace.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        :param pulumi.Input[_builtins.bool] v1_legacy_mode_enabled: Enable V1 API features, enabling `v1_legacy_mode` may prevent you from using features provided by the v2 API. Defaults to `false`.
        :param pulumi.Input[_builtins.str] workspace_id: The immutable id associated with this workspace.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _WorkspaceState.__new__(_WorkspaceState)

        __props__.__dict__["application_insights_id"] = application_insights_id
        __props__.__dict__["container_registry_id"] = container_registry_id
        __props__.__dict__["description"] = description
        __props__.__dict__["discovery_url"] = discovery_url
        __props__.__dict__["encryption"] = encryption
        __props__.__dict__["feature_store"] = feature_store
        __props__.__dict__["friendly_name"] = friendly_name
        __props__.__dict__["high_business_impact"] = high_business_impact
        __props__.__dict__["identity"] = identity
        __props__.__dict__["image_build_compute_name"] = image_build_compute_name
        __props__.__dict__["key_vault_id"] = key_vault_id
        __props__.__dict__["kind"] = kind
        __props__.__dict__["location"] = location
        __props__.__dict__["managed_network"] = managed_network
        __props__.__dict__["name"] = name
        __props__.__dict__["primary_user_assigned_identity"] = primary_user_assigned_identity
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["serverless_compute"] = serverless_compute
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["storage_account_id"] = storage_account_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["v1_legacy_mode_enabled"] = v1_legacy_mode_enabled
        __props__.__dict__["workspace_id"] = workspace_id
        return Workspace(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="applicationInsightsId")
    def application_insights_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Application Insights associated with this Machine Learning Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "application_insights_id")

    @_builtins.property
    @pulumi.getter(name="containerRegistryId")
    def container_registry_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the container registry associated with this Machine Learning Workspace. Changing this forces a new resource to be created.

        > **Note:** The `admin_enabled` should be `true` in order to associate the Container Registry to this Machine Learning Workspace.
        """
        return pulumi.get(self, "container_registry_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of this Machine Learning Workspace.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="discoveryUrl")
    def discovery_url(self) -> pulumi.Output[_builtins.str]:
        """
        The url for the discovery service to identify regional endpoints for machine learning experimentation services.
        """
        return pulumi.get(self, "discovery_url")

    @_builtins.property
    @pulumi.getter
    def encryption(self) -> pulumi.Output[Optional['outputs.WorkspaceEncryption']]:
        """
        An `encryption` block as defined below. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "encryption")

    @_builtins.property
    @pulumi.getter(name="featureStore")
    def feature_store(self) -> pulumi.Output[Optional['outputs.WorkspaceFeatureStore']]:
        """
        A `feature_store` block as defined below.
        """
        return pulumi.get(self, "feature_store")

    @_builtins.property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Display name for this Machine Learning Workspace.
        """
        return pulumi.get(self, "friendly_name")

    @_builtins.property
    @pulumi.getter(name="highBusinessImpact")
    def high_business_impact(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Flag to signal High Business Impact (HBI) data in the workspace and reduce diagnostic data collected by the service. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "high_business_impact")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output['outputs.WorkspaceIdentity']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter(name="imageBuildComputeName")
    def image_build_compute_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The compute name for image build of the Machine Learning Workspace.
        """
        return pulumi.get(self, "image_build_compute_name")

    @_builtins.property
    @pulumi.getter(name="keyVaultId")
    def key_vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of key vault associated with this Machine Learning Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "key_vault_id")

    @_builtins.property
    @pulumi.getter
    def kind(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The type of the Workspace. Possible values are `Default`, `FeatureStore`. Defaults to `Default`
        """
        return pulumi.get(self, "kind")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the Machine Learning Workspace should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="managedNetwork")
    def managed_network(self) -> pulumi.Output['outputs.WorkspaceManagedNetwork']:
        """
        A `managed_network` block as defined below.
        """
        return pulumi.get(self, "managed_network")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Machine Learning Workspace. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="primaryUserAssignedIdentity")
    def primary_user_assigned_identity(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The user assigned identity id that represents the workspace identity.
        """
        return pulumi.get(self, "primary_user_assigned_identity")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable public access when this Machine Learning Workspace is behind VNet. Defaults to `true`.

        > **Note:** `public_access_behind_virtual_network_enabled` is deprecated and will be removed in favour of the property `public_network_access_enabled`.
        """
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Resource Group in which the Machine Learning Workspace should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="serverlessCompute")
    def serverless_compute(self) -> pulumi.Output[Optional['outputs.WorkspaceServerlessCompute']]:
        """
        A `serverless_compute` block as defined below.
        """
        return pulumi.get(self, "serverless_compute")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        SKU/edition of the Machine Learning Workspace, possible values are `Free`, `Basic`, `Standard` and `Premium`. Defaults to `Basic`.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter(name="storageAccountId")
    def storage_account_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Storage Account associated with this Machine Learning Workspace. Changing this forces a new resource to be created.

        > **Note:** The `account_tier` cannot be `Premium` in order to associate the Storage Account to this Machine Learning Workspace.
        """
        return pulumi.get(self, "storage_account_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="v1LegacyModeEnabled")
    def v1_legacy_mode_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Enable V1 API features, enabling `v1_legacy_mode` may prevent you from using features provided by the v2 API. Defaults to `false`.
        """
        return pulumi.get(self, "v1_legacy_mode_enabled")

    @_builtins.property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> pulumi.Output[_builtins.str]:
        """
        The immutable id associated with this workspace.
        """
        return pulumi.get(self, "workspace_id")

