# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['ManangementLockArgs', 'ManangementLock']

@pulumi.input_type
class ManangementLockArgs:
    def __init__(__self__, *,
                 lock_level: pulumi.Input[_builtins.str],
                 scope: pulumi.Input[_builtins.str],
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ManangementLock resource.
        :param pulumi.Input[_builtins.str] lock_level: Specifies the Level to be used for this Lock. Possible values are `CanNotDelete` and `ReadOnly`. Changing this forces a new resource to be created.
               
               > **Note:** `CanNotDelete` means authorized users are able to read and modify the resources, but not delete. `ReadOnly` means authorized users can only read from a resource, but they can't modify or delete it.
        :param pulumi.Input[_builtins.str] scope: Specifies the scope at which the Management Lock should be created. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Management Lock. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] notes: Specifies some notes about the lock. Maximum of 512 characters. Changing this forces a new resource to be created.
        """
        pulumi.set(__self__, "lock_level", lock_level)
        pulumi.set(__self__, "scope", scope)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)

    @_builtins.property
    @pulumi.getter(name="lockLevel")
    def lock_level(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the Level to be used for this Lock. Possible values are `CanNotDelete` and `ReadOnly`. Changing this forces a new resource to be created.

        > **Note:** `CanNotDelete` means authorized users are able to read and modify the resources, but not delete. `ReadOnly` means authorized users can only read from a resource, but they can't modify or delete it.
        """
        return pulumi.get(self, "lock_level")

    @lock_level.setter
    def lock_level(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "lock_level", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the scope at which the Management Lock should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "scope", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Management Lock. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies some notes about the lock. Maximum of 512 characters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notes", value)


@pulumi.input_type
class _ManangementLockState:
    def __init__(__self__, *,
                 lock_level: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ManangementLock resources.
        :param pulumi.Input[_builtins.str] lock_level: Specifies the Level to be used for this Lock. Possible values are `CanNotDelete` and `ReadOnly`. Changing this forces a new resource to be created.
               
               > **Note:** `CanNotDelete` means authorized users are able to read and modify the resources, but not delete. `ReadOnly` means authorized users can only read from a resource, but they can't modify or delete it.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Management Lock. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] notes: Specifies some notes about the lock. Maximum of 512 characters. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] scope: Specifies the scope at which the Management Lock should be created. Changing this forces a new resource to be created.
        """
        if lock_level is not None:
            pulumi.set(__self__, "lock_level", lock_level)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if notes is not None:
            pulumi.set(__self__, "notes", notes)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)

    @_builtins.property
    @pulumi.getter(name="lockLevel")
    def lock_level(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Level to be used for this Lock. Possible values are `CanNotDelete` and `ReadOnly`. Changing this forces a new resource to be created.

        > **Note:** `CanNotDelete` means authorized users are able to read and modify the resources, but not delete. `ReadOnly` means authorized users can only read from a resource, but they can't modify or delete it.
        """
        return pulumi.get(self, "lock_level")

    @lock_level.setter
    def lock_level(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "lock_level", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Management Lock. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def notes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies some notes about the lock. Maximum of 512 characters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "notes")

    @notes.setter
    def notes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "notes", value)

    @_builtins.property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the scope at which the Management Lock should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "scope", value)


warnings.warn("""azure.managementresource.ManangementLock has been deprecated in favor of azure.management.Lock""", DeprecationWarning)


@pulumi.type_token("azure:managementresource/manangementLock:ManangementLock")
class ManangementLock(pulumi.CustomResource):
    warnings.warn("""azure.managementresource.ManangementLock has been deprecated in favor of azure.management.Lock""", DeprecationWarning)

    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 lock_level: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Management Lock which is scoped to a Subscription, Resource Group or Resource.

        ## Example Usage

        ### Subscription Level Lock)

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_subscription()
        subscription_level = azure.management.Lock("subscription-level",
            name="subscription-level",
            scope=current.id,
            lock_level="CanNotDelete",
            notes="Items can't be deleted in this subscription!")
        ```

        ### Resource Group Level Lock)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="locked-resource-group",
            location="West Europe")
        resource_group_level = azure.management.Lock("resource-group-level",
            name="resource-group-level",
            scope=example.id,
            lock_level="ReadOnly",
            notes="This Resource Group is Read-Only")
        ```

        ### Resource Level Lock)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="locked-resource-group",
            location="West Europe")
        example_public_ip = azure.network.PublicIp("example",
            name="locked-publicip",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static",
            idle_timeout_in_minutes=30)
        public_ip = azure.management.Lock("public-ip",
            name="resource-ip",
            scope=example_public_ip.id,
            lock_level="CanNotDelete",
            notes="Locked because it's needed by a third-party")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Authorization` - 2020-05-01

        ## Import

        Management Locks can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:managementresource/manangementLock:ManangementLock lock1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Authorization/locks/lock1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] lock_level: Specifies the Level to be used for this Lock. Possible values are `CanNotDelete` and `ReadOnly`. Changing this forces a new resource to be created.
               
               > **Note:** `CanNotDelete` means authorized users are able to read and modify the resources, but not delete. `ReadOnly` means authorized users can only read from a resource, but they can't modify or delete it.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Management Lock. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] notes: Specifies some notes about the lock. Maximum of 512 characters. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] scope: Specifies the scope at which the Management Lock should be created. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManangementLockArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Management Lock which is scoped to a Subscription, Resource Group or Resource.

        ## Example Usage

        ### Subscription Level Lock)

        ```python
        import pulumi
        import pulumi_azure as azure

        current = azure.core.get_subscription()
        subscription_level = azure.management.Lock("subscription-level",
            name="subscription-level",
            scope=current.id,
            lock_level="CanNotDelete",
            notes="Items can't be deleted in this subscription!")
        ```

        ### Resource Group Level Lock)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="locked-resource-group",
            location="West Europe")
        resource_group_level = azure.management.Lock("resource-group-level",
            name="resource-group-level",
            scope=example.id,
            lock_level="ReadOnly",
            notes="This Resource Group is Read-Only")
        ```

        ### Resource Level Lock)

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="locked-resource-group",
            location="West Europe")
        example_public_ip = azure.network.PublicIp("example",
            name="locked-publicip",
            location=example.location,
            resource_group_name=example.name,
            allocation_method="Static",
            idle_timeout_in_minutes=30)
        public_ip = azure.management.Lock("public-ip",
            name="resource-ip",
            scope=example_public_ip.id,
            lock_level="CanNotDelete",
            notes="Locked because it's needed by a third-party")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Authorization` - 2020-05-01

        ## Import

        Management Locks can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:managementresource/manangementLock:ManangementLock lock1 /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/mygroup1/providers/Microsoft.Authorization/locks/lock1
        ```

        :param str resource_name: The name of the resource.
        :param ManangementLockArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManangementLockArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 lock_level: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 notes: Optional[pulumi.Input[_builtins.str]] = None,
                 scope: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        pulumi.log.warn("""ManangementLock is deprecated: azure.managementresource.ManangementLock has been deprecated in favor of azure.management.Lock""")
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManangementLockArgs.__new__(ManangementLockArgs)

            if lock_level is None and not opts.urn:
                raise TypeError("Missing required property 'lock_level'")
            __props__.__dict__["lock_level"] = lock_level
            __props__.__dict__["name"] = name
            __props__.__dict__["notes"] = notes
            if scope is None and not opts.urn:
                raise TypeError("Missing required property 'scope'")
            __props__.__dict__["scope"] = scope
        super(ManangementLock, __self__).__init__(
            'azure:managementresource/manangementLock:ManangementLock',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            lock_level: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            notes: Optional[pulumi.Input[_builtins.str]] = None,
            scope: Optional[pulumi.Input[_builtins.str]] = None) -> 'ManangementLock':
        """
        Get an existing ManangementLock resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] lock_level: Specifies the Level to be used for this Lock. Possible values are `CanNotDelete` and `ReadOnly`. Changing this forces a new resource to be created.
               
               > **Note:** `CanNotDelete` means authorized users are able to read and modify the resources, but not delete. `ReadOnly` means authorized users can only read from a resource, but they can't modify or delete it.
        :param pulumi.Input[_builtins.str] name: Specifies the name of the Management Lock. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] notes: Specifies some notes about the lock. Maximum of 512 characters. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] scope: Specifies the scope at which the Management Lock should be created. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManangementLockState.__new__(_ManangementLockState)

        __props__.__dict__["lock_level"] = lock_level
        __props__.__dict__["name"] = name
        __props__.__dict__["notes"] = notes
        __props__.__dict__["scope"] = scope
        return ManangementLock(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="lockLevel")
    def lock_level(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Level to be used for this Lock. Possible values are `CanNotDelete` and `ReadOnly`. Changing this forces a new resource to be created.

        > **Note:** `CanNotDelete` means authorized users are able to read and modify the resources, but not delete. `ReadOnly` means authorized users can only read from a resource, but they can't modify or delete it.
        """
        return pulumi.get(self, "lock_level")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Management Lock. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def notes(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Specifies some notes about the lock. Maximum of 512 characters. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "notes")

    @_builtins.property
    @pulumi.getter
    def scope(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the scope at which the Management Lock should be created. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "scope")

