# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetNetworkPacketCoreControlPlaneResult',
    'AwaitableGetNetworkPacketCoreControlPlaneResult',
    'get_network_packet_core_control_plane',
    'get_network_packet_core_control_plane_output',
]

@pulumi.output_type
class GetNetworkPacketCoreControlPlaneResult:
    """
    A collection of values returned by getNetworkPacketCoreControlPlane.
    """
    def __init__(__self__, control_plane_access_ipv4_address=None, control_plane_access_ipv4_gateway=None, control_plane_access_ipv4_subnet=None, control_plane_access_name=None, core_network_technology=None, id=None, identities=None, interoperability_settings_json=None, local_diagnostics_accesses=None, location=None, name=None, platforms=None, resource_group_name=None, site_ids=None, sku=None, software_version=None, tags=None, user_equipment_mtu_in_bytes=None):
        if control_plane_access_ipv4_address and not isinstance(control_plane_access_ipv4_address, str):
            raise TypeError("Expected argument 'control_plane_access_ipv4_address' to be a str")
        pulumi.set(__self__, "control_plane_access_ipv4_address", control_plane_access_ipv4_address)
        if control_plane_access_ipv4_gateway and not isinstance(control_plane_access_ipv4_gateway, str):
            raise TypeError("Expected argument 'control_plane_access_ipv4_gateway' to be a str")
        pulumi.set(__self__, "control_plane_access_ipv4_gateway", control_plane_access_ipv4_gateway)
        if control_plane_access_ipv4_subnet and not isinstance(control_plane_access_ipv4_subnet, str):
            raise TypeError("Expected argument 'control_plane_access_ipv4_subnet' to be a str")
        pulumi.set(__self__, "control_plane_access_ipv4_subnet", control_plane_access_ipv4_subnet)
        if control_plane_access_name and not isinstance(control_plane_access_name, str):
            raise TypeError("Expected argument 'control_plane_access_name' to be a str")
        pulumi.set(__self__, "control_plane_access_name", control_plane_access_name)
        if core_network_technology and not isinstance(core_network_technology, str):
            raise TypeError("Expected argument 'core_network_technology' to be a str")
        pulumi.set(__self__, "core_network_technology", core_network_technology)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identities and not isinstance(identities, list):
            raise TypeError("Expected argument 'identities' to be a list")
        pulumi.set(__self__, "identities", identities)
        if interoperability_settings_json and not isinstance(interoperability_settings_json, str):
            raise TypeError("Expected argument 'interoperability_settings_json' to be a str")
        pulumi.set(__self__, "interoperability_settings_json", interoperability_settings_json)
        if local_diagnostics_accesses and not isinstance(local_diagnostics_accesses, list):
            raise TypeError("Expected argument 'local_diagnostics_accesses' to be a list")
        pulumi.set(__self__, "local_diagnostics_accesses", local_diagnostics_accesses)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if platforms and not isinstance(platforms, list):
            raise TypeError("Expected argument 'platforms' to be a list")
        pulumi.set(__self__, "platforms", platforms)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if site_ids and not isinstance(site_ids, list):
            raise TypeError("Expected argument 'site_ids' to be a list")
        pulumi.set(__self__, "site_ids", site_ids)
        if sku and not isinstance(sku, str):
            raise TypeError("Expected argument 'sku' to be a str")
        pulumi.set(__self__, "sku", sku)
        if software_version and not isinstance(software_version, str):
            raise TypeError("Expected argument 'software_version' to be a str")
        pulumi.set(__self__, "software_version", software_version)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if user_equipment_mtu_in_bytes and not isinstance(user_equipment_mtu_in_bytes, int):
            raise TypeError("Expected argument 'user_equipment_mtu_in_bytes' to be a int")
        pulumi.set(__self__, "user_equipment_mtu_in_bytes", user_equipment_mtu_in_bytes)

    @_builtins.property
    @pulumi.getter(name="controlPlaneAccessIpv4Address")
    def control_plane_access_ipv4_address(self) -> _builtins.str:
        return pulumi.get(self, "control_plane_access_ipv4_address")

    @_builtins.property
    @pulumi.getter(name="controlPlaneAccessIpv4Gateway")
    def control_plane_access_ipv4_gateway(self) -> _builtins.str:
        return pulumi.get(self, "control_plane_access_ipv4_gateway")

    @_builtins.property
    @pulumi.getter(name="controlPlaneAccessIpv4Subnet")
    def control_plane_access_ipv4_subnet(self) -> _builtins.str:
        return pulumi.get(self, "control_plane_access_ipv4_subnet")

    @_builtins.property
    @pulumi.getter(name="controlPlaneAccessName")
    def control_plane_access_name(self) -> _builtins.str:
        return pulumi.get(self, "control_plane_access_name")

    @_builtins.property
    @pulumi.getter(name="coreNetworkTechnology")
    def core_network_technology(self) -> _builtins.str:
        """
        The core network technology generation.
        """
        return pulumi.get(self, "core_network_technology")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def identities(self) -> Sequence['outputs.GetNetworkPacketCoreControlPlaneIdentityResult']:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identities")

    @_builtins.property
    @pulumi.getter(name="interoperabilitySettingsJson")
    def interoperability_settings_json(self) -> _builtins.str:
        """
        Settings in JSON format to allow interoperability with third party components e.g. RANs and UEs.
        """
        return pulumi.get(self, "interoperability_settings_json")

    @_builtins.property
    @pulumi.getter(name="localDiagnosticsAccesses")
    def local_diagnostics_accesses(self) -> Sequence['outputs.GetNetworkPacketCoreControlPlaneLocalDiagnosticsAccessResult']:
        """
        One or more `local_diagnostics_access` blocks as defined below. The Kubernetes ingress configuration that controls access to the packet core diagnostics through local APIs.
        """
        return pulumi.get(self, "local_diagnostics_accesses")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Mobile Network Packet Core Control Plane exists.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The logical name for this interface.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def platforms(self) -> Sequence['outputs.GetNetworkPacketCoreControlPlanePlatformResult']:
        """
        A `platform` block as defined below.
        """
        return pulumi.get(self, "platforms")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="siteIds")
    def site_ids(self) -> Sequence[_builtins.str]:
        """
        The list of Mobile Network Site IDs in which this packet core control plane is deployed.
        """
        return pulumi.get(self, "site_ids")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> _builtins.str:
        """
        The SKU defining the throughput and SIM allowances for this packet core control plane deployment.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter(name="softwareVersion")
    def software_version(self) -> _builtins.str:
        """
        The version of the packet core software that is deployed.
        """
        return pulumi.get(self, "software_version")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags assigned to the Mobile Network Packet Core Control Plane.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="userEquipmentMtuInBytes")
    def user_equipment_mtu_in_bytes(self) -> _builtins.int:
        """
        The MTU in bytes that can be sent to the user equipment.
        """
        return pulumi.get(self, "user_equipment_mtu_in_bytes")


class AwaitableGetNetworkPacketCoreControlPlaneResult(GetNetworkPacketCoreControlPlaneResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkPacketCoreControlPlaneResult(
            control_plane_access_ipv4_address=self.control_plane_access_ipv4_address,
            control_plane_access_ipv4_gateway=self.control_plane_access_ipv4_gateway,
            control_plane_access_ipv4_subnet=self.control_plane_access_ipv4_subnet,
            control_plane_access_name=self.control_plane_access_name,
            core_network_technology=self.core_network_technology,
            id=self.id,
            identities=self.identities,
            interoperability_settings_json=self.interoperability_settings_json,
            local_diagnostics_accesses=self.local_diagnostics_accesses,
            location=self.location,
            name=self.name,
            platforms=self.platforms,
            resource_group_name=self.resource_group_name,
            site_ids=self.site_ids,
            sku=self.sku,
            software_version=self.software_version,
            tags=self.tags,
            user_equipment_mtu_in_bytes=self.user_equipment_mtu_in_bytes)


def get_network_packet_core_control_plane(name: Optional[_builtins.str] = None,
                                          resource_group_name: Optional[_builtins.str] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkPacketCoreControlPlaneResult:
    """
    Get information about a Mobile Network Packet Core Control Plane.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.mobile.get_network_packet_core_control_plane(name="example-mnpccp",
        resource_group_name="example-rg")
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.MobileNetwork` - 2022-11-01


    :param _builtins.str name: The name of the Mobile Network Packet Core Control Plane.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Mobile Network Packet Core Control Plane exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:mobile/getNetworkPacketCoreControlPlane:getNetworkPacketCoreControlPlane', __args__, opts=opts, typ=GetNetworkPacketCoreControlPlaneResult).value

    return AwaitableGetNetworkPacketCoreControlPlaneResult(
        control_plane_access_ipv4_address=pulumi.get(__ret__, 'control_plane_access_ipv4_address'),
        control_plane_access_ipv4_gateway=pulumi.get(__ret__, 'control_plane_access_ipv4_gateway'),
        control_plane_access_ipv4_subnet=pulumi.get(__ret__, 'control_plane_access_ipv4_subnet'),
        control_plane_access_name=pulumi.get(__ret__, 'control_plane_access_name'),
        core_network_technology=pulumi.get(__ret__, 'core_network_technology'),
        id=pulumi.get(__ret__, 'id'),
        identities=pulumi.get(__ret__, 'identities'),
        interoperability_settings_json=pulumi.get(__ret__, 'interoperability_settings_json'),
        local_diagnostics_accesses=pulumi.get(__ret__, 'local_diagnostics_accesses'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        platforms=pulumi.get(__ret__, 'platforms'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        site_ids=pulumi.get(__ret__, 'site_ids'),
        sku=pulumi.get(__ret__, 'sku'),
        software_version=pulumi.get(__ret__, 'software_version'),
        tags=pulumi.get(__ret__, 'tags'),
        user_equipment_mtu_in_bytes=pulumi.get(__ret__, 'user_equipment_mtu_in_bytes'))
def get_network_packet_core_control_plane_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkPacketCoreControlPlaneResult]:
    """
    Get information about a Mobile Network Packet Core Control Plane.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.mobile.get_network_packet_core_control_plane(name="example-mnpccp",
        resource_group_name="example-rg")
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.MobileNetwork` - 2022-11-01


    :param _builtins.str name: The name of the Mobile Network Packet Core Control Plane.
    :param _builtins.str resource_group_name: The name of the Resource Group where the Mobile Network Packet Core Control Plane exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:mobile/getNetworkPacketCoreControlPlane:getNetworkPacketCoreControlPlane', __args__, opts=opts, typ=GetNetworkPacketCoreControlPlaneResult)
    return __ret__.apply(lambda __response__: GetNetworkPacketCoreControlPlaneResult(
        control_plane_access_ipv4_address=pulumi.get(__response__, 'control_plane_access_ipv4_address'),
        control_plane_access_ipv4_gateway=pulumi.get(__response__, 'control_plane_access_ipv4_gateway'),
        control_plane_access_ipv4_subnet=pulumi.get(__response__, 'control_plane_access_ipv4_subnet'),
        control_plane_access_name=pulumi.get(__response__, 'control_plane_access_name'),
        core_network_technology=pulumi.get(__response__, 'core_network_technology'),
        id=pulumi.get(__response__, 'id'),
        identities=pulumi.get(__response__, 'identities'),
        interoperability_settings_json=pulumi.get(__response__, 'interoperability_settings_json'),
        local_diagnostics_accesses=pulumi.get(__response__, 'local_diagnostics_accesses'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        platforms=pulumi.get(__response__, 'platforms'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        site_ids=pulumi.get(__response__, 'site_ids'),
        sku=pulumi.get(__response__, 'sku'),
        software_version=pulumi.get(__response__, 'software_version'),
        tags=pulumi.get(__response__, 'tags'),
        user_equipment_mtu_in_bytes=pulumi.get(__response__, 'user_equipment_mtu_in_bytes')))
