# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetNetworkPacketCoreDataPlaneResult',
    'AwaitableGetNetworkPacketCoreDataPlaneResult',
    'get_network_packet_core_data_plane',
    'get_network_packet_core_data_plane_output',
]

@pulumi.output_type
class GetNetworkPacketCoreDataPlaneResult:
    """
    A collection of values returned by getNetworkPacketCoreDataPlane.
    """
    def __init__(__self__, id=None, location=None, mobile_network_packet_core_control_plane_id=None, name=None, tags=None, user_plane_access_ipv4_address=None, user_plane_access_ipv4_gateway=None, user_plane_access_ipv4_subnet=None, user_plane_access_name=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if mobile_network_packet_core_control_plane_id and not isinstance(mobile_network_packet_core_control_plane_id, str):
            raise TypeError("Expected argument 'mobile_network_packet_core_control_plane_id' to be a str")
        pulumi.set(__self__, "mobile_network_packet_core_control_plane_id", mobile_network_packet_core_control_plane_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if tags and not isinstance(tags, dict):
            raise TypeError("Expected argument 'tags' to be a dict")
        pulumi.set(__self__, "tags", tags)
        if user_plane_access_ipv4_address and not isinstance(user_plane_access_ipv4_address, str):
            raise TypeError("Expected argument 'user_plane_access_ipv4_address' to be a str")
        pulumi.set(__self__, "user_plane_access_ipv4_address", user_plane_access_ipv4_address)
        if user_plane_access_ipv4_gateway and not isinstance(user_plane_access_ipv4_gateway, str):
            raise TypeError("Expected argument 'user_plane_access_ipv4_gateway' to be a str")
        pulumi.set(__self__, "user_plane_access_ipv4_gateway", user_plane_access_ipv4_gateway)
        if user_plane_access_ipv4_subnet and not isinstance(user_plane_access_ipv4_subnet, str):
            raise TypeError("Expected argument 'user_plane_access_ipv4_subnet' to be a str")
        pulumi.set(__self__, "user_plane_access_ipv4_subnet", user_plane_access_ipv4_subnet)
        if user_plane_access_name and not isinstance(user_plane_access_name, str):
            raise TypeError("Expected argument 'user_plane_access_name' to be a str")
        pulumi.set(__self__, "user_plane_access_name", user_plane_access_name)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure Region where the Mobile Network Packet Core Data Plane should exist.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="mobileNetworkPacketCoreControlPlaneId")
    def mobile_network_packet_core_control_plane_id(self) -> _builtins.str:
        return pulumi.get(self, "mobile_network_packet_core_control_plane_id")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Mapping[str, _builtins.str]:
        """
        A mapping of tags which should be assigned to the Mobile Network Packet Core Data Plane.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="userPlaneAccessIpv4Address")
    def user_plane_access_ipv4_address(self) -> _builtins.str:
        """
        The IPv4 address for the user plane interface.
        """
        return pulumi.get(self, "user_plane_access_ipv4_address")

    @_builtins.property
    @pulumi.getter(name="userPlaneAccessIpv4Gateway")
    def user_plane_access_ipv4_gateway(self) -> _builtins.str:
        """
        The default IPv4 gateway for the user plane interface.
        """
        return pulumi.get(self, "user_plane_access_ipv4_gateway")

    @_builtins.property
    @pulumi.getter(name="userPlaneAccessIpv4Subnet")
    def user_plane_access_ipv4_subnet(self) -> _builtins.str:
        """
        The IPv4 subnet for the user plane interface.
        """
        return pulumi.get(self, "user_plane_access_ipv4_subnet")

    @_builtins.property
    @pulumi.getter(name="userPlaneAccessName")
    def user_plane_access_name(self) -> _builtins.str:
        """
        The logical name for thie user plane interface.
        """
        return pulumi.get(self, "user_plane_access_name")


class AwaitableGetNetworkPacketCoreDataPlaneResult(GetNetworkPacketCoreDataPlaneResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkPacketCoreDataPlaneResult(
            id=self.id,
            location=self.location,
            mobile_network_packet_core_control_plane_id=self.mobile_network_packet_core_control_plane_id,
            name=self.name,
            tags=self.tags,
            user_plane_access_ipv4_address=self.user_plane_access_ipv4_address,
            user_plane_access_ipv4_gateway=self.user_plane_access_ipv4_gateway,
            user_plane_access_ipv4_subnet=self.user_plane_access_ipv4_subnet,
            user_plane_access_name=self.user_plane_access_name)


def get_network_packet_core_data_plane(mobile_network_packet_core_control_plane_id: Optional[_builtins.str] = None,
                                       name: Optional[_builtins.str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkPacketCoreDataPlaneResult:
    """
    Get information a Mobile Network Packet Core Data Plane.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.mobile.get_network_packet_core_control_plane(name="example-mnpccp",
        resource_group_name="example-rg")
    example_get_network_packet_core_data_plane = azure.mobile.get_network_packet_core_data_plane(name="example-mnpcdp",
        mobile_network_packet_core_control_plane_id=example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.MobileNetwork` - 2022-11-01


    :param _builtins.str mobile_network_packet_core_control_plane_id: The ID of the Mobile Network Packet Core Data Plane.
    :param _builtins.str name: The name of the Mobile Network Packet Core Data Plane.
    """
    __args__ = dict()
    __args__['mobileNetworkPacketCoreControlPlaneId'] = mobile_network_packet_core_control_plane_id
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:mobile/getNetworkPacketCoreDataPlane:getNetworkPacketCoreDataPlane', __args__, opts=opts, typ=GetNetworkPacketCoreDataPlaneResult).value

    return AwaitableGetNetworkPacketCoreDataPlaneResult(
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        mobile_network_packet_core_control_plane_id=pulumi.get(__ret__, 'mobile_network_packet_core_control_plane_id'),
        name=pulumi.get(__ret__, 'name'),
        tags=pulumi.get(__ret__, 'tags'),
        user_plane_access_ipv4_address=pulumi.get(__ret__, 'user_plane_access_ipv4_address'),
        user_plane_access_ipv4_gateway=pulumi.get(__ret__, 'user_plane_access_ipv4_gateway'),
        user_plane_access_ipv4_subnet=pulumi.get(__ret__, 'user_plane_access_ipv4_subnet'),
        user_plane_access_name=pulumi.get(__ret__, 'user_plane_access_name'))
def get_network_packet_core_data_plane_output(mobile_network_packet_core_control_plane_id: Optional[pulumi.Input[_builtins.str]] = None,
                                              name: Optional[pulumi.Input[_builtins.str]] = None,
                                              opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNetworkPacketCoreDataPlaneResult]:
    """
    Get information a Mobile Network Packet Core Data Plane.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.mobile.get_network_packet_core_control_plane(name="example-mnpccp",
        resource_group_name="example-rg")
    example_get_network_packet_core_data_plane = azure.mobile.get_network_packet_core_data_plane(name="example-mnpcdp",
        mobile_network_packet_core_control_plane_id=example.id)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.MobileNetwork` - 2022-11-01


    :param _builtins.str mobile_network_packet_core_control_plane_id: The ID of the Mobile Network Packet Core Data Plane.
    :param _builtins.str name: The name of the Mobile Network Packet Core Data Plane.
    """
    __args__ = dict()
    __args__['mobileNetworkPacketCoreControlPlaneId'] = mobile_network_packet_core_control_plane_id
    __args__['name'] = name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:mobile/getNetworkPacketCoreDataPlane:getNetworkPacketCoreDataPlane', __args__, opts=opts, typ=GetNetworkPacketCoreDataPlaneResult)
    return __ret__.apply(lambda __response__: GetNetworkPacketCoreDataPlaneResult(
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        mobile_network_packet_core_control_plane_id=pulumi.get(__response__, 'mobile_network_packet_core_control_plane_id'),
        name=pulumi.get(__response__, 'name'),
        tags=pulumi.get(__response__, 'tags'),
        user_plane_access_ipv4_address=pulumi.get(__response__, 'user_plane_access_ipv4_address'),
        user_plane_access_ipv4_gateway=pulumi.get(__response__, 'user_plane_access_ipv4_gateway'),
        user_plane_access_ipv4_subnet=pulumi.get(__response__, 'user_plane_access_ipv4_subnet'),
        user_plane_access_name=pulumi.get(__response__, 'user_plane_access_name')))
