# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['DataCollectionRuleAssociationArgs', 'DataCollectionRuleAssociation']

@pulumi.input_type
class DataCollectionRuleAssociationArgs:
    def __init__(__self__, *,
                 target_resource_id: pulumi.Input[_builtins.str],
                 data_collection_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_collection_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a DataCollectionRuleAssociation resource.
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of the Azure Resource which to associate to a Data Collection Rule or a Data Collection Endpoint. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] data_collection_endpoint_id: The ID of the Data Collection Endpoint which will be associated to the target resource.
        :param pulumi.Input[_builtins.str] data_collection_rule_id: The ID of the Data Collection Rule which will be associated to the target resource.
               
               > **Note:** Exactly one of `data_collection_endpoint_id` and `data_collection_rule_id` blocks must be specified.
        :param pulumi.Input[_builtins.str] description: The description of the Data Collection Rule Association.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Data Collection Rule Association. Changing this forces a new Data Collection Rule Association to be created. Defaults to `configurationAccessEndpoint`.
               
               > **Note:** `name` is required when `data_collection_rule_id` is specified. And when `data_collection_endpoint_id` is specified, the `name` is populated with `configurationAccessEndpoint`.
        """
        pulumi.set(__self__, "target_resource_id", target_resource_id)
        if data_collection_endpoint_id is not None:
            pulumi.set(__self__, "data_collection_endpoint_id", data_collection_endpoint_id)
        if data_collection_rule_id is not None:
            pulumi.set(__self__, "data_collection_rule_id", data_collection_rule_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Azure Resource which to associate to a Data Collection Rule or a Data Collection Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "target_resource_id", value)

    @_builtins.property
    @pulumi.getter(name="dataCollectionEndpointId")
    def data_collection_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Data Collection Endpoint which will be associated to the target resource.
        """
        return pulumi.get(self, "data_collection_endpoint_id")

    @data_collection_endpoint_id.setter
    def data_collection_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_collection_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="dataCollectionRuleId")
    def data_collection_rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Data Collection Rule which will be associated to the target resource.

        > **Note:** Exactly one of `data_collection_endpoint_id` and `data_collection_rule_id` blocks must be specified.
        """
        return pulumi.get(self, "data_collection_rule_id")

    @data_collection_rule_id.setter
    def data_collection_rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_collection_rule_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Data Collection Rule Association.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Data Collection Rule Association. Changing this forces a new Data Collection Rule Association to be created. Defaults to `configurationAccessEndpoint`.

        > **Note:** `name` is required when `data_collection_rule_id` is specified. And when `data_collection_endpoint_id` is specified, the `name` is populated with `configurationAccessEndpoint`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class _DataCollectionRuleAssociationState:
    def __init__(__self__, *,
                 data_collection_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_collection_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering DataCollectionRuleAssociation resources.
        :param pulumi.Input[_builtins.str] data_collection_endpoint_id: The ID of the Data Collection Endpoint which will be associated to the target resource.
        :param pulumi.Input[_builtins.str] data_collection_rule_id: The ID of the Data Collection Rule which will be associated to the target resource.
               
               > **Note:** Exactly one of `data_collection_endpoint_id` and `data_collection_rule_id` blocks must be specified.
        :param pulumi.Input[_builtins.str] description: The description of the Data Collection Rule Association.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Data Collection Rule Association. Changing this forces a new Data Collection Rule Association to be created. Defaults to `configurationAccessEndpoint`.
               
               > **Note:** `name` is required when `data_collection_rule_id` is specified. And when `data_collection_endpoint_id` is specified, the `name` is populated with `configurationAccessEndpoint`.
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of the Azure Resource which to associate to a Data Collection Rule or a Data Collection Endpoint. Changing this forces a new resource to be created.
        """
        if data_collection_endpoint_id is not None:
            pulumi.set(__self__, "data_collection_endpoint_id", data_collection_endpoint_id)
        if data_collection_rule_id is not None:
            pulumi.set(__self__, "data_collection_rule_id", data_collection_rule_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if target_resource_id is not None:
            pulumi.set(__self__, "target_resource_id", target_resource_id)

    @_builtins.property
    @pulumi.getter(name="dataCollectionEndpointId")
    def data_collection_endpoint_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Data Collection Endpoint which will be associated to the target resource.
        """
        return pulumi.get(self, "data_collection_endpoint_id")

    @data_collection_endpoint_id.setter
    def data_collection_endpoint_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_collection_endpoint_id", value)

    @_builtins.property
    @pulumi.getter(name="dataCollectionRuleId")
    def data_collection_rule_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Data Collection Rule which will be associated to the target resource.

        > **Note:** Exactly one of `data_collection_endpoint_id` and `data_collection_rule_id` blocks must be specified.
        """
        return pulumi.get(self, "data_collection_rule_id")

    @data_collection_rule_id.setter
    def data_collection_rule_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_collection_rule_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the Data Collection Rule Association.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this Data Collection Rule Association. Changing this forces a new Data Collection Rule Association to be created. Defaults to `configurationAccessEndpoint`.

        > **Note:** `name` is required when `data_collection_rule_id` is specified. And when `data_collection_endpoint_id` is specified, the `name` is populated with `configurationAccessEndpoint`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Azure Resource which to associate to a Data Collection Rule or a Data Collection Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_resource_id")

    @target_resource_id.setter
    def target_resource_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "target_resource_id", value)


@pulumi.type_token("azure:monitoring/dataCollectionRuleAssociation:DataCollectionRuleAssociation")
class DataCollectionRuleAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_collection_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_collection_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a Data Collection Rule Association.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="virtualnetwork",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="nic",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "internal",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_linux_virtual_machine = azure.compute.LinuxVirtualMachine("example",
            name="machine",
            resource_group_name=example.name,
            location=example.location,
            size="Standard_B1ls",
            admin_username="adminuser",
            network_interface_ids=[example_network_interface.id],
            admin_password="example-Password@7890",
            disable_password_authentication=False,
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "Standard_LRS",
            },
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            })
        example_data_collection_rule = azure.monitoring.DataCollectionRule("example",
            name="example-dcr",
            resource_group_name=example.name,
            location=example.location,
            destinations={
                "azure_monitor_metrics": {
                    "name": "example-destination-metrics",
                },
            },
            data_flows=[{
                "streams": ["Microsoft-InsightsMetrics"],
                "destinations": ["example-destination-metrics"],
            }])
        example_data_collection_endpoint = azure.monitoring.DataCollectionEndpoint("example",
            name="example-dce",
            resource_group_name=example.name,
            location=example.location)
        # associate to a Data Collection Rule
        example1 = azure.monitoring.DataCollectionRuleAssociation("example1",
            name="example1-dcra",
            target_resource_id=example_linux_virtual_machine.id,
            data_collection_rule_id=example_data_collection_rule.id,
            description="example")
        # associate to a Data Collection Endpoint
        example2 = azure.monitoring.DataCollectionRuleAssociation("example2",
            target_resource_id=example_linux_virtual_machine.id,
            data_collection_endpoint_id=example_data_collection_endpoint.id,
            description="example")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights` - 2023-03-11

        ## Import

        Data Collection Rules Association can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/dataCollectionRuleAssociation:DataCollectionRuleAssociation example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/rg1/providers/Microsoft.Compute/virtualMachines/vm1/providers/Microsoft.Insights/dataCollectionRuleAssociations/dca1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data_collection_endpoint_id: The ID of the Data Collection Endpoint which will be associated to the target resource.
        :param pulumi.Input[_builtins.str] data_collection_rule_id: The ID of the Data Collection Rule which will be associated to the target resource.
               
               > **Note:** Exactly one of `data_collection_endpoint_id` and `data_collection_rule_id` blocks must be specified.
        :param pulumi.Input[_builtins.str] description: The description of the Data Collection Rule Association.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Data Collection Rule Association. Changing this forces a new Data Collection Rule Association to be created. Defaults to `configurationAccessEndpoint`.
               
               > **Note:** `name` is required when `data_collection_rule_id` is specified. And when `data_collection_endpoint_id` is specified, the `name` is populated with `configurationAccessEndpoint`.
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of the Azure Resource which to associate to a Data Collection Rule or a Data Collection Endpoint. Changing this forces a new resource to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataCollectionRuleAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a Data Collection Rule Association.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="virtualnetwork",
            address_spaces=["10.0.0.0/16"],
            location=example.location,
            resource_group_name=example.name)
        example_subnet = azure.network.Subnet("example",
            name="subnet",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"])
        example_network_interface = azure.network.NetworkInterface("example",
            name="nic",
            location=example.location,
            resource_group_name=example.name,
            ip_configurations=[{
                "name": "internal",
                "subnet_id": example_subnet.id,
                "private_ip_address_allocation": "Dynamic",
            }])
        example_linux_virtual_machine = azure.compute.LinuxVirtualMachine("example",
            name="machine",
            resource_group_name=example.name,
            location=example.location,
            size="Standard_B1ls",
            admin_username="adminuser",
            network_interface_ids=[example_network_interface.id],
            admin_password="example-Password@7890",
            disable_password_authentication=False,
            os_disk={
                "caching": "ReadWrite",
                "storage_account_type": "Standard_LRS",
            },
            source_image_reference={
                "publisher": "Canonical",
                "offer": "0001-com-ubuntu-server-jammy",
                "sku": "22_04-lts",
                "version": "latest",
            })
        example_data_collection_rule = azure.monitoring.DataCollectionRule("example",
            name="example-dcr",
            resource_group_name=example.name,
            location=example.location,
            destinations={
                "azure_monitor_metrics": {
                    "name": "example-destination-metrics",
                },
            },
            data_flows=[{
                "streams": ["Microsoft-InsightsMetrics"],
                "destinations": ["example-destination-metrics"],
            }])
        example_data_collection_endpoint = azure.monitoring.DataCollectionEndpoint("example",
            name="example-dce",
            resource_group_name=example.name,
            location=example.location)
        # associate to a Data Collection Rule
        example1 = azure.monitoring.DataCollectionRuleAssociation("example1",
            name="example1-dcra",
            target_resource_id=example_linux_virtual_machine.id,
            data_collection_rule_id=example_data_collection_rule.id,
            description="example")
        # associate to a Data Collection Endpoint
        example2 = azure.monitoring.DataCollectionRuleAssociation("example2",
            target_resource_id=example_linux_virtual_machine.id,
            data_collection_endpoint_id=example_data_collection_endpoint.id,
            description="example")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights` - 2023-03-11

        ## Import

        Data Collection Rules Association can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/dataCollectionRuleAssociation:DataCollectionRuleAssociation example /subscriptions/12345678-1234-9876-4563-123456789012/resourceGroups/rg1/providers/Microsoft.Compute/virtualMachines/vm1/providers/Microsoft.Insights/dataCollectionRuleAssociations/dca1
        ```

        :param str resource_name: The name of the resource.
        :param DataCollectionRuleAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataCollectionRuleAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_collection_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
                 data_collection_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 target_resource_id: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataCollectionRuleAssociationArgs.__new__(DataCollectionRuleAssociationArgs)

            __props__.__dict__["data_collection_endpoint_id"] = data_collection_endpoint_id
            __props__.__dict__["data_collection_rule_id"] = data_collection_rule_id
            __props__.__dict__["description"] = description
            __props__.__dict__["name"] = name
            if target_resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_resource_id'")
            __props__.__dict__["target_resource_id"] = target_resource_id
        super(DataCollectionRuleAssociation, __self__).__init__(
            'azure:monitoring/dataCollectionRuleAssociation:DataCollectionRuleAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            data_collection_endpoint_id: Optional[pulumi.Input[_builtins.str]] = None,
            data_collection_rule_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            target_resource_id: Optional[pulumi.Input[_builtins.str]] = None) -> 'DataCollectionRuleAssociation':
        """
        Get an existing DataCollectionRuleAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] data_collection_endpoint_id: The ID of the Data Collection Endpoint which will be associated to the target resource.
        :param pulumi.Input[_builtins.str] data_collection_rule_id: The ID of the Data Collection Rule which will be associated to the target resource.
               
               > **Note:** Exactly one of `data_collection_endpoint_id` and `data_collection_rule_id` blocks must be specified.
        :param pulumi.Input[_builtins.str] description: The description of the Data Collection Rule Association.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this Data Collection Rule Association. Changing this forces a new Data Collection Rule Association to be created. Defaults to `configurationAccessEndpoint`.
               
               > **Note:** `name` is required when `data_collection_rule_id` is specified. And when `data_collection_endpoint_id` is specified, the `name` is populated with `configurationAccessEndpoint`.
        :param pulumi.Input[_builtins.str] target_resource_id: The ID of the Azure Resource which to associate to a Data Collection Rule or a Data Collection Endpoint. Changing this forces a new resource to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataCollectionRuleAssociationState.__new__(_DataCollectionRuleAssociationState)

        __props__.__dict__["data_collection_endpoint_id"] = data_collection_endpoint_id
        __props__.__dict__["data_collection_rule_id"] = data_collection_rule_id
        __props__.__dict__["description"] = description
        __props__.__dict__["name"] = name
        __props__.__dict__["target_resource_id"] = target_resource_id
        return DataCollectionRuleAssociation(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="dataCollectionEndpointId")
    def data_collection_endpoint_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Data Collection Endpoint which will be associated to the target resource.
        """
        return pulumi.get(self, "data_collection_endpoint_id")

    @_builtins.property
    @pulumi.getter(name="dataCollectionRuleId")
    def data_collection_rule_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the Data Collection Rule which will be associated to the target resource.

        > **Note:** Exactly one of `data_collection_endpoint_id` and `data_collection_rule_id` blocks must be specified.
        """
        return pulumi.get(self, "data_collection_rule_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the Data Collection Rule Association.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this Data Collection Rule Association. Changing this forces a new Data Collection Rule Association to be created. Defaults to `configurationAccessEndpoint`.

        > **Note:** `name` is required when `data_collection_rule_id` is specified. And when `data_collection_endpoint_id` is specified, the `name` is populated with `configurationAccessEndpoint`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="targetResourceId")
    def target_resource_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Azure Resource which to associate to a Data Collection Rule or a Data Collection Endpoint. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "target_resource_id")

