# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ScheduledQueryRulesLogArgs', 'ScheduledQueryRulesLog']

@pulumi.input_type
class ScheduledQueryRulesLogArgs:
    def __init__(__self__, *,
                 criteria: pulumi.Input['ScheduledQueryRulesLogCriteriaArgs'],
                 data_source_id: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 authorized_resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a ScheduledQueryRulesLog resource.
        :param pulumi.Input['ScheduledQueryRulesLogCriteriaArgs'] criteria: A `criteria` block as defined below.
        :param pulumi.Input[_builtins.str] data_source_id: The resource URI over which log search query is to be run. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the scheduled query rule instance. Changing this forces a new resource to be created.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_resource_ids: A list of IDs of Resources referred into query.
        :param pulumi.Input[_builtins.str] description: The description of the scheduled query rule.
        :param pulumi.Input[_builtins.bool] enabled: Whether this scheduled query rule is enabled. Default is `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the resource should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the scheduled query rule. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "criteria", criteria)
        pulumi.set(__self__, "data_source_id", data_source_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if authorized_resource_ids is not None:
            pulumi.set(__self__, "authorized_resource_ids", authorized_resource_ids)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter
    def criteria(self) -> pulumi.Input['ScheduledQueryRulesLogCriteriaArgs']:
        """
        A `criteria` block as defined below.
        """
        return pulumi.get(self, "criteria")

    @criteria.setter
    def criteria(self, value: pulumi.Input['ScheduledQueryRulesLogCriteriaArgs']):
        pulumi.set(self, "criteria", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> pulumi.Input[_builtins.str]:
        """
        The resource URI over which log search query is to be run. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_source_id")

    @data_source_id.setter
    def data_source_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "data_source_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the resource group in which to create the scheduled query rule instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="authorizedResourceIds")
    def authorized_resource_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IDs of Resources referred into query.
        """
        return pulumi.get(self, "authorized_resource_ids")

    @authorized_resource_ids.setter
    def authorized_resource_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "authorized_resource_ids", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the scheduled query rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this scheduled query rule is enabled. Default is `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the resource should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the scheduled query rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ScheduledQueryRulesLogState:
    def __init__(__self__, *,
                 authorized_resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 criteria: Optional[pulumi.Input['ScheduledQueryRulesLogCriteriaArgs']] = None,
                 data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering ScheduledQueryRulesLog resources.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_resource_ids: A list of IDs of Resources referred into query.
        :param pulumi.Input['ScheduledQueryRulesLogCriteriaArgs'] criteria: A `criteria` block as defined below.
        :param pulumi.Input[_builtins.str] data_source_id: The resource URI over which log search query is to be run. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: The description of the scheduled query rule.
        :param pulumi.Input[_builtins.bool] enabled: Whether this scheduled query rule is enabled. Default is `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the resource should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the scheduled query rule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the scheduled query rule instance. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if authorized_resource_ids is not None:
            pulumi.set(__self__, "authorized_resource_ids", authorized_resource_ids)
        if criteria is not None:
            pulumi.set(__self__, "criteria", criteria)
        if data_source_id is not None:
            pulumi.set(__self__, "data_source_id", data_source_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="authorizedResourceIds")
    def authorized_resource_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of IDs of Resources referred into query.
        """
        return pulumi.get(self, "authorized_resource_ids")

    @authorized_resource_ids.setter
    def authorized_resource_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "authorized_resource_ids", value)

    @_builtins.property
    @pulumi.getter
    def criteria(self) -> Optional[pulumi.Input['ScheduledQueryRulesLogCriteriaArgs']]:
        """
        A `criteria` block as defined below.
        """
        return pulumi.get(self, "criteria")

    @criteria.setter
    def criteria(self, value: Optional[pulumi.Input['ScheduledQueryRulesLogCriteriaArgs']]):
        pulumi.set(self, "criteria", value)

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource URI over which log search query is to be run. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_source_id")

    @data_source_id.setter
    def data_source_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "data_source_id", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The description of the scheduled query rule.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether this scheduled query rule is enabled. Default is `true`.
        """
        return pulumi.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "enabled", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the Azure Region where the resource should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the scheduled query rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the resource group in which to create the scheduled query rule instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.type_token("azure:monitoring/scheduledQueryRulesLog:ScheduledQueryRulesLog")
class ScheduledQueryRulesLog(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorized_resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 criteria: Optional[pulumi.Input[Union['ScheduledQueryRulesLogCriteriaArgs', 'ScheduledQueryRulesLogCriteriaArgsDict']]] = None,
                 data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages a LogToMetricAction Scheduled Query Rules resource within Azure Monitor.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="monitoring-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="loganalytics",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        example_action_group = azure.monitoring.ActionGroup("example",
            name="example-actiongroup",
            resource_group_name=example.name,
            short_name="exampleact",
            webhook_receivers=[{
                "name": "callmyapi",
                "service_uri": "http://example.com/alert",
            }])
        # Example: Creates alert using the new Scheduled Query Rules metric
        example_metric_alert = azure.monitoring.MetricAlert("example",
            name="example-metricalert",
            resource_group_name=example.name,
            scopes=[example_analytics_workspace.id],
            description="Action will be triggered when Average_% Idle Time metric is less than 10.",
            frequency="PT1M",
            window_size="PT5M",
            criterias=[{
                "metric_namespace": "Microsoft.OperationalInsights/workspaces",
                "metric_name": "UsedCapacity",
                "aggregation": "Average",
                "operator": "LessThan",
                "threshold": 10,
            }],
            actions=[{
                "action_group_id": example_action_group.id,
            }])
        # Example: LogToMetric Action for the named Computer
        example_scheduled_query_rules_log = azure.monitoring.ScheduledQueryRulesLog("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            criteria={
                "metric_name": "Average_% Idle Time",
                "dimensions": [{
                    "name": "Computer",
                    "operator": "Include",
                    "values": ["targetVM"],
                }],
            },
            data_source_id=example_analytics_workspace.id,
            description="Scheduled query rule LogToMetric example",
            enabled=True,
            tags={
                "foo": "bar",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights` - 2018-04-16

        ## Import

        Scheduled Query Rule Log can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/scheduledQueryRulesLog:ScheduledQueryRulesLog example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Insights/scheduledQueryRules/myrulename
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_resource_ids: A list of IDs of Resources referred into query.
        :param pulumi.Input[Union['ScheduledQueryRulesLogCriteriaArgs', 'ScheduledQueryRulesLogCriteriaArgsDict']] criteria: A `criteria` block as defined below.
        :param pulumi.Input[_builtins.str] data_source_id: The resource URI over which log search query is to be run. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: The description of the scheduled query rule.
        :param pulumi.Input[_builtins.bool] enabled: Whether this scheduled query rule is enabled. Default is `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the resource should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the scheduled query rule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the scheduled query rule instance. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ScheduledQueryRulesLogArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a LogToMetricAction Scheduled Query Rules resource within Azure Monitor.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="monitoring-resources",
            location="West Europe")
        example_analytics_workspace = azure.operationalinsights.AnalyticsWorkspace("example",
            name="loganalytics",
            location=example.location,
            resource_group_name=example.name,
            sku="PerGB2018",
            retention_in_days=30)
        example_action_group = azure.monitoring.ActionGroup("example",
            name="example-actiongroup",
            resource_group_name=example.name,
            short_name="exampleact",
            webhook_receivers=[{
                "name": "callmyapi",
                "service_uri": "http://example.com/alert",
            }])
        # Example: Creates alert using the new Scheduled Query Rules metric
        example_metric_alert = azure.monitoring.MetricAlert("example",
            name="example-metricalert",
            resource_group_name=example.name,
            scopes=[example_analytics_workspace.id],
            description="Action will be triggered when Average_% Idle Time metric is less than 10.",
            frequency="PT1M",
            window_size="PT5M",
            criterias=[{
                "metric_namespace": "Microsoft.OperationalInsights/workspaces",
                "metric_name": "UsedCapacity",
                "aggregation": "Average",
                "operator": "LessThan",
                "threshold": 10,
            }],
            actions=[{
                "action_group_id": example_action_group.id,
            }])
        # Example: LogToMetric Action for the named Computer
        example_scheduled_query_rules_log = azure.monitoring.ScheduledQueryRulesLog("example",
            name="example",
            location=example.location,
            resource_group_name=example.name,
            criteria={
                "metric_name": "Average_% Idle Time",
                "dimensions": [{
                    "name": "Computer",
                    "operator": "Include",
                    "values": ["targetVM"],
                }],
            },
            data_source_id=example_analytics_workspace.id,
            description="Scheduled query rule LogToMetric example",
            enabled=True,
            tags={
                "foo": "bar",
            })
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Insights` - 2018-04-16

        ## Import

        Scheduled Query Rule Log can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:monitoring/scheduledQueryRulesLog:ScheduledQueryRulesLog example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Insights/scheduledQueryRules/myrulename
        ```

        :param str resource_name: The name of the resource.
        :param ScheduledQueryRulesLogArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ScheduledQueryRulesLogArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 authorized_resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 criteria: Optional[pulumi.Input[Union['ScheduledQueryRulesLogCriteriaArgs', 'ScheduledQueryRulesLogCriteriaArgsDict']]] = None,
                 data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ScheduledQueryRulesLogArgs.__new__(ScheduledQueryRulesLogArgs)

            __props__.__dict__["authorized_resource_ids"] = authorized_resource_ids
            if criteria is None and not opts.urn:
                raise TypeError("Missing required property 'criteria'")
            __props__.__dict__["criteria"] = criteria
            if data_source_id is None and not opts.urn:
                raise TypeError("Missing required property 'data_source_id'")
            __props__.__dict__["data_source_id"] = data_source_id
            __props__.__dict__["description"] = description
            __props__.__dict__["enabled"] = enabled
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["tags"] = tags
        super(ScheduledQueryRulesLog, __self__).__init__(
            'azure:monitoring/scheduledQueryRulesLog:ScheduledQueryRulesLog',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            authorized_resource_ids: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            criteria: Optional[pulumi.Input[Union['ScheduledQueryRulesLogCriteriaArgs', 'ScheduledQueryRulesLogCriteriaArgsDict']]] = None,
            data_source_id: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None) -> 'ScheduledQueryRulesLog':
        """
        Get an existing ScheduledQueryRulesLog resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] authorized_resource_ids: A list of IDs of Resources referred into query.
        :param pulumi.Input[Union['ScheduledQueryRulesLogCriteriaArgs', 'ScheduledQueryRulesLogCriteriaArgsDict']] criteria: A `criteria` block as defined below.
        :param pulumi.Input[_builtins.str] data_source_id: The resource URI over which log search query is to be run. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] description: The description of the scheduled query rule.
        :param pulumi.Input[_builtins.bool] enabled: Whether this scheduled query rule is enabled. Default is `true`.
        :param pulumi.Input[_builtins.str] location: Specifies the Azure Region where the resource should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the scheduled query rule. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the resource group in which to create the scheduled query rule instance. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ScheduledQueryRulesLogState.__new__(_ScheduledQueryRulesLogState)

        __props__.__dict__["authorized_resource_ids"] = authorized_resource_ids
        __props__.__dict__["criteria"] = criteria
        __props__.__dict__["data_source_id"] = data_source_id
        __props__.__dict__["description"] = description
        __props__.__dict__["enabled"] = enabled
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["tags"] = tags
        return ScheduledQueryRulesLog(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="authorizedResourceIds")
    def authorized_resource_ids(self) -> pulumi.Output[Optional[Sequence[_builtins.str]]]:
        """
        A list of IDs of Resources referred into query.
        """
        return pulumi.get(self, "authorized_resource_ids")

    @_builtins.property
    @pulumi.getter
    def criteria(self) -> pulumi.Output['outputs.ScheduledQueryRulesLogCriteria']:
        """
        A `criteria` block as defined below.
        """
        return pulumi.get(self, "criteria")

    @_builtins.property
    @pulumi.getter(name="dataSourceId")
    def data_source_id(self) -> pulumi.Output[_builtins.str]:
        """
        The resource URI over which log search query is to be run. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "data_source_id")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The description of the scheduled query rule.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether this scheduled query rule is enabled. Default is `true`.
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the Azure Region where the resource should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the scheduled query rule. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the resource group in which to create the scheduled query rule instance. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

