# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'FlexibleServerCustomerManagedKeyArgs',
    'FlexibleServerCustomerManagedKeyArgsDict',
    'FlexibleServerHighAvailabilityArgs',
    'FlexibleServerHighAvailabilityArgsDict',
    'FlexibleServerIdentityArgs',
    'FlexibleServerIdentityArgsDict',
    'FlexibleServerMaintenanceWindowArgs',
    'FlexibleServerMaintenanceWindowArgsDict',
    'FlexibleServerStorageArgs',
    'FlexibleServerStorageArgsDict',
]

MYPY = False

if not MYPY:
    class FlexibleServerCustomerManagedKeyArgsDict(TypedDict):
        geo_backup_key_vault_key_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the geo backup Key Vault Key. It can't cross region and need Customer Managed Key in same region as geo backup.
        """
        geo_backup_user_assigned_identity_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The geo backup user managed identity id for a Customer Managed Key. Should be added with `identity_ids`. It can't cross region and need identity in same region as geo backup.

        > **Note:** `primary_user_assigned_identity_id` or `geo_backup_user_assigned_identity_id` is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        key_vault_key_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        The ID of the Key Vault Key.
        """
        primary_user_assigned_identity_id: NotRequired[pulumi.Input[_builtins.str]]
        """
        Specifies the primary user managed identity id for a Customer Managed Key. Should be added with `identity_ids`.
        """
elif False:
    FlexibleServerCustomerManagedKeyArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlexibleServerCustomerManagedKeyArgs:
    def __init__(__self__, *,
                 geo_backup_key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 geo_backup_user_assigned_identity_id: Optional[pulumi.Input[_builtins.str]] = None,
                 key_vault_key_id: Optional[pulumi.Input[_builtins.str]] = None,
                 primary_user_assigned_identity_id: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] geo_backup_key_vault_key_id: The ID of the geo backup Key Vault Key. It can't cross region and need Customer Managed Key in same region as geo backup.
        :param pulumi.Input[_builtins.str] geo_backup_user_assigned_identity_id: The geo backup user managed identity id for a Customer Managed Key. Should be added with `identity_ids`. It can't cross region and need identity in same region as geo backup.
               
               > **Note:** `primary_user_assigned_identity_id` or `geo_backup_user_assigned_identity_id` is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        :param pulumi.Input[_builtins.str] key_vault_key_id: The ID of the Key Vault Key.
        :param pulumi.Input[_builtins.str] primary_user_assigned_identity_id: Specifies the primary user managed identity id for a Customer Managed Key. Should be added with `identity_ids`.
        """
        if geo_backup_key_vault_key_id is not None:
            pulumi.set(__self__, "geo_backup_key_vault_key_id", geo_backup_key_vault_key_id)
        if geo_backup_user_assigned_identity_id is not None:
            pulumi.set(__self__, "geo_backup_user_assigned_identity_id", geo_backup_user_assigned_identity_id)
        if key_vault_key_id is not None:
            pulumi.set(__self__, "key_vault_key_id", key_vault_key_id)
        if primary_user_assigned_identity_id is not None:
            pulumi.set(__self__, "primary_user_assigned_identity_id", primary_user_assigned_identity_id)

    @_builtins.property
    @pulumi.getter(name="geoBackupKeyVaultKeyId")
    def geo_backup_key_vault_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the geo backup Key Vault Key. It can't cross region and need Customer Managed Key in same region as geo backup.
        """
        return pulumi.get(self, "geo_backup_key_vault_key_id")

    @geo_backup_key_vault_key_id.setter
    def geo_backup_key_vault_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "geo_backup_key_vault_key_id", value)

    @_builtins.property
    @pulumi.getter(name="geoBackupUserAssignedIdentityId")
    def geo_backup_user_assigned_identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The geo backup user managed identity id for a Customer Managed Key. Should be added with `identity_ids`. It can't cross region and need identity in same region as geo backup.

        > **Note:** `primary_user_assigned_identity_id` or `geo_backup_user_assigned_identity_id` is required when `type` is set to `UserAssigned` or `SystemAssigned, UserAssigned`.
        """
        return pulumi.get(self, "geo_backup_user_assigned_identity_id")

    @geo_backup_user_assigned_identity_id.setter
    def geo_backup_user_assigned_identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "geo_backup_user_assigned_identity_id", value)

    @_builtins.property
    @pulumi.getter(name="keyVaultKeyId")
    def key_vault_key_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Key Vault Key.
        """
        return pulumi.get(self, "key_vault_key_id")

    @key_vault_key_id.setter
    def key_vault_key_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "key_vault_key_id", value)

    @_builtins.property
    @pulumi.getter(name="primaryUserAssignedIdentityId")
    def primary_user_assigned_identity_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the primary user managed identity id for a Customer Managed Key. Should be added with `identity_ids`.
        """
        return pulumi.get(self, "primary_user_assigned_identity_id")

    @primary_user_assigned_identity_id.setter
    def primary_user_assigned_identity_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "primary_user_assigned_identity_id", value)


if not MYPY:
    class FlexibleServerHighAvailabilityArgsDict(TypedDict):
        mode: pulumi.Input[_builtins.str]
        """
        The high availability mode for the MySQL Flexible Server. Possibles values are `SameZone` and `ZoneRedundant`.

        > **Note:** `storage[0].auto_grow_enabled` must be enabled when `high_availability` is enabled. To change the `high_availability` for a MySQL Flexible Server created with `high_availability` disabled during creation, the resource has to be recreated.
        """
        standby_availability_zone: NotRequired[pulumi.Input[_builtins.str]]
elif False:
    FlexibleServerHighAvailabilityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlexibleServerHighAvailabilityArgs:
    def __init__(__self__, *,
                 mode: pulumi.Input[_builtins.str],
                 standby_availability_zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        :param pulumi.Input[_builtins.str] mode: The high availability mode for the MySQL Flexible Server. Possibles values are `SameZone` and `ZoneRedundant`.
               
               > **Note:** `storage[0].auto_grow_enabled` must be enabled when `high_availability` is enabled. To change the `high_availability` for a MySQL Flexible Server created with `high_availability` disabled during creation, the resource has to be recreated.
        """
        pulumi.set(__self__, "mode", mode)
        if standby_availability_zone is not None:
            pulumi.set(__self__, "standby_availability_zone", standby_availability_zone)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> pulumi.Input[_builtins.str]:
        """
        The high availability mode for the MySQL Flexible Server. Possibles values are `SameZone` and `ZoneRedundant`.

        > **Note:** `storage[0].auto_grow_enabled` must be enabled when `high_availability` is enabled. To change the `high_availability` for a MySQL Flexible Server created with `high_availability` disabled during creation, the resource has to be recreated.
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "mode", value)

    @_builtins.property
    @pulumi.getter(name="standbyAvailabilityZone")
    def standby_availability_zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "standby_availability_zone")

    @standby_availability_zone.setter
    def standby_availability_zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "standby_availability_zone", value)


if not MYPY:
    class FlexibleServerIdentityArgsDict(TypedDict):
        identity_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]
        """
        A list of User Assigned Managed Identity IDs to be assigned to this MySQL Flexible Server.
        """
        type: pulumi.Input[_builtins.str]
        """
        Specifies the type of Managed Service Identity that should be configured on this MySQL Flexible Server. The only possible value is `UserAssigned`.
        """
elif False:
    FlexibleServerIdentityArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlexibleServerIdentityArgs:
    def __init__(__self__, *,
                 identity_ids: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]],
                 type: pulumi.Input[_builtins.str]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] identity_ids: A list of User Assigned Managed Identity IDs to be assigned to this MySQL Flexible Server.
        :param pulumi.Input[_builtins.str] type: Specifies the type of Managed Service Identity that should be configured on this MySQL Flexible Server. The only possible value is `UserAssigned`.
        """
        pulumi.set(__self__, "identity_ids", identity_ids)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="identityIds")
    def identity_ids(self) -> pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]:
        """
        A list of User Assigned Managed Identity IDs to be assigned to this MySQL Flexible Server.
        """
        return pulumi.get(self, "identity_ids")

    @identity_ids.setter
    def identity_ids(self, value: pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]):
        pulumi.set(self, "identity_ids", value)

    @_builtins.property
    @pulumi.getter
    def type(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the type of Managed Service Identity that should be configured on this MySQL Flexible Server. The only possible value is `UserAssigned`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "type", value)


if not MYPY:
    class FlexibleServerMaintenanceWindowArgsDict(TypedDict):
        day_of_week: NotRequired[pulumi.Input[_builtins.int]]
        """
        The day of week for maintenance window. Defaults to `0`.
        """
        start_hour: NotRequired[pulumi.Input[_builtins.int]]
        """
        The start hour for maintenance window. Defaults to `0`.
        """
        start_minute: NotRequired[pulumi.Input[_builtins.int]]
        """
        The start minute for maintenance window. Defaults to `0`.
        """
elif False:
    FlexibleServerMaintenanceWindowArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlexibleServerMaintenanceWindowArgs:
    def __init__(__self__, *,
                 day_of_week: Optional[pulumi.Input[_builtins.int]] = None,
                 start_hour: Optional[pulumi.Input[_builtins.int]] = None,
                 start_minute: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.int] day_of_week: The day of week for maintenance window. Defaults to `0`.
        :param pulumi.Input[_builtins.int] start_hour: The start hour for maintenance window. Defaults to `0`.
        :param pulumi.Input[_builtins.int] start_minute: The start minute for maintenance window. Defaults to `0`.
        """
        if day_of_week is not None:
            pulumi.set(__self__, "day_of_week", day_of_week)
        if start_hour is not None:
            pulumi.set(__self__, "start_hour", start_hour)
        if start_minute is not None:
            pulumi.set(__self__, "start_minute", start_minute)

    @_builtins.property
    @pulumi.getter(name="dayOfWeek")
    def day_of_week(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The day of week for maintenance window. Defaults to `0`.
        """
        return pulumi.get(self, "day_of_week")

    @day_of_week.setter
    def day_of_week(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "day_of_week", value)

    @_builtins.property
    @pulumi.getter(name="startHour")
    def start_hour(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The start hour for maintenance window. Defaults to `0`.
        """
        return pulumi.get(self, "start_hour")

    @start_hour.setter
    def start_hour(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_hour", value)

    @_builtins.property
    @pulumi.getter(name="startMinute")
    def start_minute(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The start minute for maintenance window. Defaults to `0`.
        """
        return pulumi.get(self, "start_minute")

    @start_minute.setter
    def start_minute(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "start_minute", value)


if not MYPY:
    class FlexibleServerStorageArgsDict(TypedDict):
        auto_grow_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Should Storage Auto Grow be enabled? Defaults to `true`.
        """
        io_scaling_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Should IOPS be scaled automatically? If `true`, `iops` can not be set. Defaults to `false`.
        """
        iops: NotRequired[pulumi.Input[_builtins.int]]
        """
        The storage IOPS for the MySQL Flexible Server. Possible values are between `360` and `20000`.
        """
        log_on_disk_enabled: NotRequired[pulumi.Input[_builtins.bool]]
        """
        Should Storage Log On Disk be enabled? Defaults to `false`.
        """
        size_gb: NotRequired[pulumi.Input[_builtins.int]]
        """
        The max storage allowed for the MySQL Flexible Server. Possible values are between `20` and `16384`.

        > **Note:** Decreasing `size_gb` forces a new resource to be created.
        """
elif False:
    FlexibleServerStorageArgsDict: TypeAlias = Mapping[str, Any]

@pulumi.input_type
class FlexibleServerStorageArgs:
    def __init__(__self__, *,
                 auto_grow_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 io_scaling_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 iops: Optional[pulumi.Input[_builtins.int]] = None,
                 log_on_disk_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 size_gb: Optional[pulumi.Input[_builtins.int]] = None):
        """
        :param pulumi.Input[_builtins.bool] auto_grow_enabled: Should Storage Auto Grow be enabled? Defaults to `true`.
        :param pulumi.Input[_builtins.bool] io_scaling_enabled: Should IOPS be scaled automatically? If `true`, `iops` can not be set. Defaults to `false`.
        :param pulumi.Input[_builtins.int] iops: The storage IOPS for the MySQL Flexible Server. Possible values are between `360` and `20000`.
        :param pulumi.Input[_builtins.bool] log_on_disk_enabled: Should Storage Log On Disk be enabled? Defaults to `false`.
        :param pulumi.Input[_builtins.int] size_gb: The max storage allowed for the MySQL Flexible Server. Possible values are between `20` and `16384`.
               
               > **Note:** Decreasing `size_gb` forces a new resource to be created.
        """
        if auto_grow_enabled is not None:
            pulumi.set(__self__, "auto_grow_enabled", auto_grow_enabled)
        if io_scaling_enabled is not None:
            pulumi.set(__self__, "io_scaling_enabled", io_scaling_enabled)
        if iops is not None:
            pulumi.set(__self__, "iops", iops)
        if log_on_disk_enabled is not None:
            pulumi.set(__self__, "log_on_disk_enabled", log_on_disk_enabled)
        if size_gb is not None:
            pulumi.set(__self__, "size_gb", size_gb)

    @_builtins.property
    @pulumi.getter(name="autoGrowEnabled")
    def auto_grow_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should Storage Auto Grow be enabled? Defaults to `true`.
        """
        return pulumi.get(self, "auto_grow_enabled")

    @auto_grow_enabled.setter
    def auto_grow_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "auto_grow_enabled", value)

    @_builtins.property
    @pulumi.getter(name="ioScalingEnabled")
    def io_scaling_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should IOPS be scaled automatically? If `true`, `iops` can not be set. Defaults to `false`.
        """
        return pulumi.get(self, "io_scaling_enabled")

    @io_scaling_enabled.setter
    def io_scaling_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "io_scaling_enabled", value)

    @_builtins.property
    @pulumi.getter
    def iops(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The storage IOPS for the MySQL Flexible Server. Possible values are between `360` and `20000`.
        """
        return pulumi.get(self, "iops")

    @iops.setter
    def iops(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "iops", value)

    @_builtins.property
    @pulumi.getter(name="logOnDiskEnabled")
    def log_on_disk_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should Storage Log On Disk be enabled? Defaults to `false`.
        """
        return pulumi.get(self, "log_on_disk_enabled")

    @log_on_disk_enabled.setter
    def log_on_disk_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "log_on_disk_enabled", value)

    @_builtins.property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The max storage allowed for the MySQL Flexible Server. Possible values are between `20` and `16384`.

        > **Note:** Decreasing `size_gb` forces a new resource to be created.
        """
        return pulumi.get(self, "size_gb")

    @size_gb.setter
    def size_gb(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "size_gb", value)


