# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['FlexibleServerArgs', 'FlexibleServer']

@pulumi.input_type
class FlexibleServerArgs:
    def __init__(__self__, *,
                 resource_group_name: pulumi.Input[_builtins.str],
                 administrator_login: Optional[pulumi.Input[_builtins.str]] = None,
                 administrator_password: Optional[pulumi.Input[_builtins.str]] = None,
                 administrator_password_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 create_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input['FlexibleServerCustomerManagedKeyArgs']] = None,
                 delegated_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 geo_redundant_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 high_availability: Optional[pulumi.Input['FlexibleServerHighAvailabilityArgs']] = None,
                 identity: Optional[pulumi.Input['FlexibleServerIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input['FlexibleServerMaintenanceWindowArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 point_in_time_restore_time_in_utc: Optional[pulumi.Input[_builtins.str]] = None,
                 private_dns_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_role: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage: Optional[pulumi.Input['FlexibleServerStorageArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a FlexibleServer resource.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the MySQL Flexible Server should exist. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input[_builtins.str] administrator_login: The Administrator login for the MySQL Flexible Server. Required when `create_mode` is `Default`. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input[_builtins.str] administrator_password: The Password associated with the `administrator_login` for the MySQL Flexible Server.
        :param pulumi.Input[_builtins.int] administrator_password_wo_version: An integer value used to trigger an update for `administrator_password_wo`. This property should be incremented when updating `administrator_password_wo`.
               
               > **Note:** Either `administrator_password` or `administrator_password_wo` is required when `create_mode` is `Default`.
        :param pulumi.Input[_builtins.int] backup_retention_days: The backup retention days for the MySQL Flexible Server. Possible values are between `1` and `35` days. Defaults to `7`.
        :param pulumi.Input[_builtins.str] create_mode: The creation mode which can be used to restore or replicate existing servers. Possible values are `Default`, `PointInTimeRestore`, `GeoRestore`, and `Replica`. Changing this forces a new MySQL Flexible Server to be created.
               
               > **Note:** Creating a `GeoRestore` server requires the source server with `geo_redundant_backup_enabled` enabled.
               
               > **Note:** When a server is first created it may not be immediately available for `geo restore` or `replica`. It may take a few minutes to several hours for the necessary metadata to be populated. Please see the [Geo Restore](https://learn.microsoft.com/azure/mysql/single-server/how-to-restore-server-portal#geo-restore) and the [Replica](https://learn.microsoft.com/azure/mysql/flexible-server/concepts-read-replicas#create-a-replica) for more information.
               
               > **Note:** When importing a MySQL Flexible Server, `create_mode` is not returned by the api so you will see a diff if `create_mode` is specified in your config. To prevent recreation, use the `ignore_changes` lifecycle meta-argument.
        :param pulumi.Input['FlexibleServerCustomerManagedKeyArgs'] customer_managed_key: A `customer_managed_key` block as defined below.
               
               > **Note:** `identity` is required when `customer_managed_key` is specified.
        :param pulumi.Input[_builtins.str] delegated_subnet_id: The ID of the virtual network subnet to create the MySQL Flexible Server. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input[_builtins.bool] geo_redundant_backup_enabled: Should geo redundant backup enabled? Defaults to `false`. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input['FlexibleServerHighAvailabilityArgs'] high_availability: A `high_availability` block as defined below.
        :param pulumi.Input['FlexibleServerIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the MySQL Flexible Server should exist. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input['FlexibleServerMaintenanceWindowArgs'] maintenance_window: A `maintenance_window` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this MySQL Flexible Server. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input[_builtins.str] point_in_time_restore_time_in_utc: The point in time to restore from `creation_source_server_id` when `create_mode` is `PointInTimeRestore`. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input[_builtins.str] private_dns_zone_id: The ID of the private DNS zone to create the MySQL Flexible Server. Changing this forces a new MySQL Flexible Server to be created.
               
               > **Note:** The `private_dns_zone_id` is required when setting a `delegated_subnet_id`. The `privatedns.Zone` should end with suffix `.mysql.database.azure.com`.
        :param pulumi.Input[_builtins.str] public_network_access: Whether approved public traffic is allowed through the firewall to this server. Possible values are `Enabled` and `Disabled`.
               
               > **Note:** `public_network_access` is automatically set to `Disabled` if the server is created with VNet Integration (i.e. values are provided for `delegated_subnet_id` and `private_dns_zone_id`").
        :param pulumi.Input[_builtins.str] replication_role: The replication role. Possible value is `None`.
               
               > **Note:** The `replication_role` cannot be set while creating and only can be updated from `Replica` to `None`.
        :param pulumi.Input[_builtins.str] sku_name: The SKU Name for the MySQL Flexible Server.
               
               > **Note:** `sku_name` should start with SKU tier `B (Burstable)`, `GP (General Purpose)`, `MO (Memory Optimized)` like `B_Standard_B1ms`.
        :param pulumi.Input[_builtins.str] source_server_id: The resource ID of the source MySQL Flexible Server to be restored. Required when `create_mode` is `PointInTimeRestore`, `GeoRestore`, and `Replica`. Changing this forces a new MySQL Flexible Server to be created.
               
               > **Note:** The replica server is always created in the same resource group and subscription as the source server.
        :param pulumi.Input['FlexibleServerStorageArgs'] storage: A `storage` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the MySQL Flexible Server.
        :param pulumi.Input[_builtins.str] version: The version of the MySQL Flexible Server to use. Possible values are `5.7`, and `8.0.21`.
        """
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if administrator_login is not None:
            pulumi.set(__self__, "administrator_login", administrator_login)
        if administrator_password is not None:
            pulumi.set(__self__, "administrator_password", administrator_password)
        if administrator_password_wo_version is not None:
            pulumi.set(__self__, "administrator_password_wo_version", administrator_password_wo_version)
        if backup_retention_days is not None:
            pulumi.set(__self__, "backup_retention_days", backup_retention_days)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if delegated_subnet_id is not None:
            pulumi.set(__self__, "delegated_subnet_id", delegated_subnet_id)
        if geo_redundant_backup_enabled is not None:
            pulumi.set(__self__, "geo_redundant_backup_enabled", geo_redundant_backup_enabled)
        if high_availability is not None:
            pulumi.set(__self__, "high_availability", high_availability)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if point_in_time_restore_time_in_utc is not None:
            pulumi.set(__self__, "point_in_time_restore_time_in_utc", point_in_time_restore_time_in_utc)
        if private_dns_zone_id is not None:
            pulumi.set(__self__, "private_dns_zone_id", private_dns_zone_id)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if replication_role is not None:
            pulumi.set(__self__, "replication_role", replication_role)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if source_server_id is not None:
            pulumi.set(__self__, "source_server_id", source_server_id)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Resource Group where the MySQL Flexible Server should exist. Changing this forces a new MySQL Flexible Server to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="administratorLogin")
    def administrator_login(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Administrator login for the MySQL Flexible Server. Required when `create_mode` is `Default`. Changing this forces a new MySQL Flexible Server to be created.
        """
        return pulumi.get(self, "administrator_login")

    @administrator_login.setter
    def administrator_login(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "administrator_login", value)

    @_builtins.property
    @pulumi.getter(name="administratorPassword")
    def administrator_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Password associated with the `administrator_login` for the MySQL Flexible Server.
        """
        return pulumi.get(self, "administrator_password")

    @administrator_password.setter
    def administrator_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "administrator_password", value)

    @_builtins.property
    @pulumi.getter(name="administratorPasswordWoVersion")
    def administrator_password_wo_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        An integer value used to trigger an update for `administrator_password_wo`. This property should be incremented when updating `administrator_password_wo`.

        > **Note:** Either `administrator_password` or `administrator_password_wo` is required when `create_mode` is `Default`.
        """
        return pulumi.get(self, "administrator_password_wo_version")

    @administrator_password_wo_version.setter
    def administrator_password_wo_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "administrator_password_wo_version", value)

    @_builtins.property
    @pulumi.getter(name="backupRetentionDays")
    def backup_retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The backup retention days for the MySQL Flexible Server. Possible values are between `1` and `35` days. Defaults to `7`.
        """
        return pulumi.get(self, "backup_retention_days")

    @backup_retention_days.setter
    def backup_retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_retention_days", value)

    @_builtins.property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation mode which can be used to restore or replicate existing servers. Possible values are `Default`, `PointInTimeRestore`, `GeoRestore`, and `Replica`. Changing this forces a new MySQL Flexible Server to be created.

        > **Note:** Creating a `GeoRestore` server requires the source server with `geo_redundant_backup_enabled` enabled.

        > **Note:** When a server is first created it may not be immediately available for `geo restore` or `replica`. It may take a few minutes to several hours for the necessary metadata to be populated. Please see the [Geo Restore](https://learn.microsoft.com/azure/mysql/single-server/how-to-restore-server-portal#geo-restore) and the [Replica](https://learn.microsoft.com/azure/mysql/flexible-server/concepts-read-replicas#create-a-replica) for more information.

        > **Note:** When importing a MySQL Flexible Server, `create_mode` is not returned by the api so you will see a diff if `create_mode` is specified in your config. To prevent recreation, use the `ignore_changes` lifecycle meta-argument.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_mode", value)

    @_builtins.property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input['FlexibleServerCustomerManagedKeyArgs']]:
        """
        A `customer_managed_key` block as defined below.

        > **Note:** `identity` is required when `customer_managed_key` is specified.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input['FlexibleServerCustomerManagedKeyArgs']]):
        pulumi.set(self, "customer_managed_key", value)

    @_builtins.property
    @pulumi.getter(name="delegatedSubnetId")
    def delegated_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the virtual network subnet to create the MySQL Flexible Server. Changing this forces a new MySQL Flexible Server to be created.
        """
        return pulumi.get(self, "delegated_subnet_id")

    @delegated_subnet_id.setter
    def delegated_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delegated_subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="geoRedundantBackupEnabled")
    def geo_redundant_backup_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should geo redundant backup enabled? Defaults to `false`. Changing this forces a new MySQL Flexible Server to be created.
        """
        return pulumi.get(self, "geo_redundant_backup_enabled")

    @geo_redundant_backup_enabled.setter
    def geo_redundant_backup_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "geo_redundant_backup_enabled", value)

    @_builtins.property
    @pulumi.getter(name="highAvailability")
    def high_availability(self) -> Optional[pulumi.Input['FlexibleServerHighAvailabilityArgs']]:
        """
        A `high_availability` block as defined below.
        """
        return pulumi.get(self, "high_availability")

    @high_availability.setter
    def high_availability(self, value: Optional[pulumi.Input['FlexibleServerHighAvailabilityArgs']]):
        pulumi.set(self, "high_availability", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['FlexibleServerIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['FlexibleServerIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the MySQL Flexible Server should exist. Changing this forces a new MySQL Flexible Server to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['FlexibleServerMaintenanceWindowArgs']]:
        """
        A `maintenance_window` block as defined below.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['FlexibleServerMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this MySQL Flexible Server. Changing this forces a new MySQL Flexible Server to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="pointInTimeRestoreTimeInUtc")
    def point_in_time_restore_time_in_utc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The point in time to restore from `creation_source_server_id` when `create_mode` is `PointInTimeRestore`. Changing this forces a new MySQL Flexible Server to be created.
        """
        return pulumi.get(self, "point_in_time_restore_time_in_utc")

    @point_in_time_restore_time_in_utc.setter
    def point_in_time_restore_time_in_utc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "point_in_time_restore_time_in_utc", value)

    @_builtins.property
    @pulumi.getter(name="privateDnsZoneId")
    def private_dns_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the private DNS zone to create the MySQL Flexible Server. Changing this forces a new MySQL Flexible Server to be created.

        > **Note:** The `private_dns_zone_id` is required when setting a `delegated_subnet_id`. The `privatedns.Zone` should end with suffix `.mysql.database.azure.com`.
        """
        return pulumi.get(self, "private_dns_zone_id")

    @private_dns_zone_id.setter
    def private_dns_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_dns_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether approved public traffic is allowed through the firewall to this server. Possible values are `Enabled` and `Disabled`.

        > **Note:** `public_network_access` is automatically set to `Disabled` if the server is created with VNet Integration (i.e. values are provided for `delegated_subnet_id` and `private_dns_zone_id`").
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_network_access", value)

    @_builtins.property
    @pulumi.getter(name="replicationRole")
    def replication_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The replication role. Possible value is `None`.

        > **Note:** The `replication_role` cannot be set while creating and only can be updated from `Replica` to `None`.
        """
        return pulumi.get(self, "replication_role")

    @replication_role.setter
    def replication_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replication_role", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU Name for the MySQL Flexible Server.

        > **Note:** `sku_name` should start with SKU tier `B (Burstable)`, `GP (General Purpose)`, `MO (Memory Optimized)` like `B_Standard_B1ms`.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="sourceServerId")
    def source_server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the source MySQL Flexible Server to be restored. Required when `create_mode` is `PointInTimeRestore`, `GeoRestore`, and `Replica`. Changing this forces a new MySQL Flexible Server to be created.

        > **Note:** The replica server is always created in the same resource group and subscription as the source server.
        """
        return pulumi.get(self, "source_server_id")

    @source_server_id.setter
    def source_server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_server_id", value)

    @_builtins.property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input['FlexibleServerStorageArgs']]:
        """
        A `storage` block as defined below.
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input['FlexibleServerStorageArgs']]):
        pulumi.set(self, "storage", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the MySQL Flexible Server.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the MySQL Flexible Server to use. Possible values are `5.7`, and `8.0.21`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.input_type
class _FlexibleServerState:
    def __init__(__self__, *,
                 administrator_login: Optional[pulumi.Input[_builtins.str]] = None,
                 administrator_password: Optional[pulumi.Input[_builtins.str]] = None,
                 administrator_password_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 create_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input['FlexibleServerCustomerManagedKeyArgs']] = None,
                 delegated_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 fqdn: Optional[pulumi.Input[_builtins.str]] = None,
                 geo_redundant_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 high_availability: Optional[pulumi.Input['FlexibleServerHighAvailabilityArgs']] = None,
                 identity: Optional[pulumi.Input['FlexibleServerIdentityArgs']] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input['FlexibleServerMaintenanceWindowArgs']] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 point_in_time_restore_time_in_utc: Optional[pulumi.Input[_builtins.str]] = None,
                 private_dns_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 replica_capacity: Optional[pulumi.Input[_builtins.int]] = None,
                 replication_role: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage: Optional[pulumi.Input['FlexibleServerStorageArgs']] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering FlexibleServer resources.
        :param pulumi.Input[_builtins.str] administrator_login: The Administrator login for the MySQL Flexible Server. Required when `create_mode` is `Default`. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input[_builtins.str] administrator_password: The Password associated with the `administrator_login` for the MySQL Flexible Server.
        :param pulumi.Input[_builtins.int] administrator_password_wo_version: An integer value used to trigger an update for `administrator_password_wo`. This property should be incremented when updating `administrator_password_wo`.
               
               > **Note:** Either `administrator_password` or `administrator_password_wo` is required when `create_mode` is `Default`.
        :param pulumi.Input[_builtins.int] backup_retention_days: The backup retention days for the MySQL Flexible Server. Possible values are between `1` and `35` days. Defaults to `7`.
        :param pulumi.Input[_builtins.str] create_mode: The creation mode which can be used to restore or replicate existing servers. Possible values are `Default`, `PointInTimeRestore`, `GeoRestore`, and `Replica`. Changing this forces a new MySQL Flexible Server to be created.
               
               > **Note:** Creating a `GeoRestore` server requires the source server with `geo_redundant_backup_enabled` enabled.
               
               > **Note:** When a server is first created it may not be immediately available for `geo restore` or `replica`. It may take a few minutes to several hours for the necessary metadata to be populated. Please see the [Geo Restore](https://learn.microsoft.com/azure/mysql/single-server/how-to-restore-server-portal#geo-restore) and the [Replica](https://learn.microsoft.com/azure/mysql/flexible-server/concepts-read-replicas#create-a-replica) for more information.
               
               > **Note:** When importing a MySQL Flexible Server, `create_mode` is not returned by the api so you will see a diff if `create_mode` is specified in your config. To prevent recreation, use the `ignore_changes` lifecycle meta-argument.
        :param pulumi.Input['FlexibleServerCustomerManagedKeyArgs'] customer_managed_key: A `customer_managed_key` block as defined below.
               
               > **Note:** `identity` is required when `customer_managed_key` is specified.
        :param pulumi.Input[_builtins.str] delegated_subnet_id: The ID of the virtual network subnet to create the MySQL Flexible Server. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input[_builtins.str] fqdn: The fully qualified domain name of the MySQL Flexible Server.
        :param pulumi.Input[_builtins.bool] geo_redundant_backup_enabled: Should geo redundant backup enabled? Defaults to `false`. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input['FlexibleServerHighAvailabilityArgs'] high_availability: A `high_availability` block as defined below.
        :param pulumi.Input['FlexibleServerIdentityArgs'] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the MySQL Flexible Server should exist. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input['FlexibleServerMaintenanceWindowArgs'] maintenance_window: A `maintenance_window` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this MySQL Flexible Server. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input[_builtins.str] point_in_time_restore_time_in_utc: The point in time to restore from `creation_source_server_id` when `create_mode` is `PointInTimeRestore`. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input[_builtins.str] private_dns_zone_id: The ID of the private DNS zone to create the MySQL Flexible Server. Changing this forces a new MySQL Flexible Server to be created.
               
               > **Note:** The `private_dns_zone_id` is required when setting a `delegated_subnet_id`. The `privatedns.Zone` should end with suffix `.mysql.database.azure.com`.
        :param pulumi.Input[_builtins.str] public_network_access: Whether approved public traffic is allowed through the firewall to this server. Possible values are `Enabled` and `Disabled`.
               
               > **Note:** `public_network_access` is automatically set to `Disabled` if the server is created with VNet Integration (i.e. values are provided for `delegated_subnet_id` and `private_dns_zone_id`").
        :param pulumi.Input[_builtins.int] replica_capacity: The maximum number of replicas that a primary MySQL Flexible Server can have.
        :param pulumi.Input[_builtins.str] replication_role: The replication role. Possible value is `None`.
               
               > **Note:** The `replication_role` cannot be set while creating and only can be updated from `Replica` to `None`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the MySQL Flexible Server should exist. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input[_builtins.str] sku_name: The SKU Name for the MySQL Flexible Server.
               
               > **Note:** `sku_name` should start with SKU tier `B (Burstable)`, `GP (General Purpose)`, `MO (Memory Optimized)` like `B_Standard_B1ms`.
        :param pulumi.Input[_builtins.str] source_server_id: The resource ID of the source MySQL Flexible Server to be restored. Required when `create_mode` is `PointInTimeRestore`, `GeoRestore`, and `Replica`. Changing this forces a new MySQL Flexible Server to be created.
               
               > **Note:** The replica server is always created in the same resource group and subscription as the source server.
        :param pulumi.Input['FlexibleServerStorageArgs'] storage: A `storage` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the MySQL Flexible Server.
        :param pulumi.Input[_builtins.str] version: The version of the MySQL Flexible Server to use. Possible values are `5.7`, and `8.0.21`.
        """
        if administrator_login is not None:
            pulumi.set(__self__, "administrator_login", administrator_login)
        if administrator_password is not None:
            pulumi.set(__self__, "administrator_password", administrator_password)
        if administrator_password_wo_version is not None:
            pulumi.set(__self__, "administrator_password_wo_version", administrator_password_wo_version)
        if backup_retention_days is not None:
            pulumi.set(__self__, "backup_retention_days", backup_retention_days)
        if create_mode is not None:
            pulumi.set(__self__, "create_mode", create_mode)
        if customer_managed_key is not None:
            pulumi.set(__self__, "customer_managed_key", customer_managed_key)
        if delegated_subnet_id is not None:
            pulumi.set(__self__, "delegated_subnet_id", delegated_subnet_id)
        if fqdn is not None:
            pulumi.set(__self__, "fqdn", fqdn)
        if geo_redundant_backup_enabled is not None:
            pulumi.set(__self__, "geo_redundant_backup_enabled", geo_redundant_backup_enabled)
        if high_availability is not None:
            pulumi.set(__self__, "high_availability", high_availability)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if point_in_time_restore_time_in_utc is not None:
            pulumi.set(__self__, "point_in_time_restore_time_in_utc", point_in_time_restore_time_in_utc)
        if private_dns_zone_id is not None:
            pulumi.set(__self__, "private_dns_zone_id", private_dns_zone_id)
        if public_network_access is not None:
            pulumi.set(__self__, "public_network_access", public_network_access)
        if public_network_access_enabled is not None:
            pulumi.set(__self__, "public_network_access_enabled", public_network_access_enabled)
        if replica_capacity is not None:
            pulumi.set(__self__, "replica_capacity", replica_capacity)
        if replication_role is not None:
            pulumi.set(__self__, "replication_role", replication_role)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if sku_name is not None:
            pulumi.set(__self__, "sku_name", sku_name)
        if source_server_id is not None:
            pulumi.set(__self__, "source_server_id", source_server_id)
        if storage is not None:
            pulumi.set(__self__, "storage", storage)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @_builtins.property
    @pulumi.getter(name="administratorLogin")
    def administrator_login(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Administrator login for the MySQL Flexible Server. Required when `create_mode` is `Default`. Changing this forces a new MySQL Flexible Server to be created.
        """
        return pulumi.get(self, "administrator_login")

    @administrator_login.setter
    def administrator_login(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "administrator_login", value)

    @_builtins.property
    @pulumi.getter(name="administratorPassword")
    def administrator_password(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Password associated with the `administrator_login` for the MySQL Flexible Server.
        """
        return pulumi.get(self, "administrator_password")

    @administrator_password.setter
    def administrator_password(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "administrator_password", value)

    @_builtins.property
    @pulumi.getter(name="administratorPasswordWoVersion")
    def administrator_password_wo_version(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        An integer value used to trigger an update for `administrator_password_wo`. This property should be incremented when updating `administrator_password_wo`.

        > **Note:** Either `administrator_password` or `administrator_password_wo` is required when `create_mode` is `Default`.
        """
        return pulumi.get(self, "administrator_password_wo_version")

    @administrator_password_wo_version.setter
    def administrator_password_wo_version(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "administrator_password_wo_version", value)

    @_builtins.property
    @pulumi.getter(name="backupRetentionDays")
    def backup_retention_days(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The backup retention days for the MySQL Flexible Server. Possible values are between `1` and `35` days. Defaults to `7`.
        """
        return pulumi.get(self, "backup_retention_days")

    @backup_retention_days.setter
    def backup_retention_days(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "backup_retention_days", value)

    @_builtins.property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation mode which can be used to restore or replicate existing servers. Possible values are `Default`, `PointInTimeRestore`, `GeoRestore`, and `Replica`. Changing this forces a new MySQL Flexible Server to be created.

        > **Note:** Creating a `GeoRestore` server requires the source server with `geo_redundant_backup_enabled` enabled.

        > **Note:** When a server is first created it may not be immediately available for `geo restore` or `replica`. It may take a few minutes to several hours for the necessary metadata to be populated. Please see the [Geo Restore](https://learn.microsoft.com/azure/mysql/single-server/how-to-restore-server-portal#geo-restore) and the [Replica](https://learn.microsoft.com/azure/mysql/flexible-server/concepts-read-replicas#create-a-replica) for more information.

        > **Note:** When importing a MySQL Flexible Server, `create_mode` is not returned by the api so you will see a diff if `create_mode` is specified in your config. To prevent recreation, use the `ignore_changes` lifecycle meta-argument.
        """
        return pulumi.get(self, "create_mode")

    @create_mode.setter
    def create_mode(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_mode", value)

    @_builtins.property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> Optional[pulumi.Input['FlexibleServerCustomerManagedKeyArgs']]:
        """
        A `customer_managed_key` block as defined below.

        > **Note:** `identity` is required when `customer_managed_key` is specified.
        """
        return pulumi.get(self, "customer_managed_key")

    @customer_managed_key.setter
    def customer_managed_key(self, value: Optional[pulumi.Input['FlexibleServerCustomerManagedKeyArgs']]):
        pulumi.set(self, "customer_managed_key", value)

    @_builtins.property
    @pulumi.getter(name="delegatedSubnetId")
    def delegated_subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the virtual network subnet to create the MySQL Flexible Server. Changing this forces a new MySQL Flexible Server to be created.
        """
        return pulumi.get(self, "delegated_subnet_id")

    @delegated_subnet_id.setter
    def delegated_subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "delegated_subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The fully qualified domain name of the MySQL Flexible Server.
        """
        return pulumi.get(self, "fqdn")

    @fqdn.setter
    def fqdn(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "fqdn", value)

    @_builtins.property
    @pulumi.getter(name="geoRedundantBackupEnabled")
    def geo_redundant_backup_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Should geo redundant backup enabled? Defaults to `false`. Changing this forces a new MySQL Flexible Server to be created.
        """
        return pulumi.get(self, "geo_redundant_backup_enabled")

    @geo_redundant_backup_enabled.setter
    def geo_redundant_backup_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "geo_redundant_backup_enabled", value)

    @_builtins.property
    @pulumi.getter(name="highAvailability")
    def high_availability(self) -> Optional[pulumi.Input['FlexibleServerHighAvailabilityArgs']]:
        """
        A `high_availability` block as defined below.
        """
        return pulumi.get(self, "high_availability")

    @high_availability.setter
    def high_availability(self, value: Optional[pulumi.Input['FlexibleServerHighAvailabilityArgs']]):
        pulumi.set(self, "high_availability", value)

    @_builtins.property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['FlexibleServerIdentityArgs']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['FlexibleServerIdentityArgs']]):
        pulumi.set(self, "identity", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Azure Region where the MySQL Flexible Server should exist. Changing this forces a new MySQL Flexible Server to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['FlexibleServerMaintenanceWindowArgs']]:
        """
        A `maintenance_window` block as defined below.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['FlexibleServerMaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name which should be used for this MySQL Flexible Server. Changing this forces a new MySQL Flexible Server to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="pointInTimeRestoreTimeInUtc")
    def point_in_time_restore_time_in_utc(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The point in time to restore from `creation_source_server_id` when `create_mode` is `PointInTimeRestore`. Changing this forces a new MySQL Flexible Server to be created.
        """
        return pulumi.get(self, "point_in_time_restore_time_in_utc")

    @point_in_time_restore_time_in_utc.setter
    def point_in_time_restore_time_in_utc(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "point_in_time_restore_time_in_utc", value)

    @_builtins.property
    @pulumi.getter(name="privateDnsZoneId")
    def private_dns_zone_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the private DNS zone to create the MySQL Flexible Server. Changing this forces a new MySQL Flexible Server to be created.

        > **Note:** The `private_dns_zone_id` is required when setting a `delegated_subnet_id`. The `privatedns.Zone` should end with suffix `.mysql.database.azure.com`.
        """
        return pulumi.get(self, "private_dns_zone_id")

    @private_dns_zone_id.setter
    def private_dns_zone_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "private_dns_zone_id", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Whether approved public traffic is allowed through the firewall to this server. Possible values are `Enabled` and `Disabled`.

        > **Note:** `public_network_access` is automatically set to `Disabled` if the server is created with VNet Integration (i.e. values are provided for `delegated_subnet_id` and `private_dns_zone_id`").
        """
        return pulumi.get(self, "public_network_access")

    @public_network_access.setter
    def public_network_access(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_network_access", value)

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        return pulumi.get(self, "public_network_access_enabled")

    @public_network_access_enabled.setter
    def public_network_access_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "public_network_access_enabled", value)

    @_builtins.property
    @pulumi.getter(name="replicaCapacity")
    def replica_capacity(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The maximum number of replicas that a primary MySQL Flexible Server can have.
        """
        return pulumi.get(self, "replica_capacity")

    @replica_capacity.setter
    def replica_capacity(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "replica_capacity", value)

    @_builtins.property
    @pulumi.getter(name="replicationRole")
    def replication_role(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The replication role. Possible value is `None`.

        > **Note:** The `replication_role` cannot be set while creating and only can be updated from `Replica` to `None`.
        """
        return pulumi.get(self, "replication_role")

    @replication_role.setter
    def replication_role(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "replication_role", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Resource Group where the MySQL Flexible Server should exist. Changing this forces a new MySQL Flexible Server to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU Name for the MySQL Flexible Server.

        > **Note:** `sku_name` should start with SKU tier `B (Burstable)`, `GP (General Purpose)`, `MO (Memory Optimized)` like `B_Standard_B1ms`.
        """
        return pulumi.get(self, "sku_name")

    @sku_name.setter
    def sku_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku_name", value)

    @_builtins.property
    @pulumi.getter(name="sourceServerId")
    def source_server_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The resource ID of the source MySQL Flexible Server to be restored. Required when `create_mode` is `PointInTimeRestore`, `GeoRestore`, and `Replica`. Changing this forces a new MySQL Flexible Server to be created.

        > **Note:** The replica server is always created in the same resource group and subscription as the source server.
        """
        return pulumi.get(self, "source_server_id")

    @source_server_id.setter
    def source_server_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "source_server_id", value)

    @_builtins.property
    @pulumi.getter
    def storage(self) -> Optional[pulumi.Input['FlexibleServerStorageArgs']]:
        """
        A `storage` block as defined below.
        """
        return pulumi.get(self, "storage")

    @storage.setter
    def storage(self, value: Optional[pulumi.Input['FlexibleServerStorageArgs']]):
        pulumi.set(self, "storage", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags which should be assigned to the MySQL Flexible Server.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The version of the MySQL Flexible Server to use. Possible values are `5.7`, and `8.0.21`.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "version", value)

    @_builtins.property
    @pulumi.getter
    def zone(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "zone")

    @zone.setter
    def zone(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "zone", value)


@pulumi.type_token("azure:mysql/flexibleServer:FlexibleServer")
class FlexibleServer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrator_login: Optional[pulumi.Input[_builtins.str]] = None,
                 administrator_password: Optional[pulumi.Input[_builtins.str]] = None,
                 administrator_password_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 create_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input[Union['FlexibleServerCustomerManagedKeyArgs', 'FlexibleServerCustomerManagedKeyArgsDict']]] = None,
                 delegated_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 geo_redundant_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 high_availability: Optional[pulumi.Input[Union['FlexibleServerHighAvailabilityArgs', 'FlexibleServerHighAvailabilityArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['FlexibleServerIdentityArgs', 'FlexibleServerIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['FlexibleServerMaintenanceWindowArgs', 'FlexibleServerMaintenanceWindowArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 point_in_time_restore_time_in_utc: Optional[pulumi.Input[_builtins.str]] = None,
                 private_dns_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_role: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage: Optional[pulumi.Input[Union['FlexibleServerStorageArgs', 'FlexibleServerStorageArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manages a MySQL Flexible Server.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vn",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="example-sn",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"],
            service_endpoints=["Microsoft.Storage"],
            delegations=[{
                "name": "fs",
                "service_delegation": {
                    "name": "Microsoft.DBforMySQL/flexibleServers",
                    "actions": ["Microsoft.Network/virtualNetworks/subnets/join/action"],
                },
            }])
        example_zone = azure.privatedns.Zone("example",
            name="example.mysql.database.azure.com",
            resource_group_name=example.name)
        example_zone_virtual_network_link = azure.privatedns.ZoneVirtualNetworkLink("example",
            name="exampleVnetZone.com",
            private_dns_zone_name=example_zone.name,
            virtual_network_id=example_virtual_network.id,
            resource_group_name=example.name)
        example_flexible_server = azure.mysql.FlexibleServer("example",
            name="example-fs",
            resource_group_name=example.name,
            location=example.location,
            administrator_login="psqladmin",
            administrator_password="H@Sh1CoR3!",
            backup_retention_days=7,
            delegated_subnet_id=example_subnet.id,
            private_dns_zone_id=example_zone.id,
            sku_name="GP_Standard_D2ds_v4",
            opts = pulumi.ResourceOptions(depends_on=[example_zone_virtual_network_link]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DBforMySQL` - 2023-12-30

        ## Import

        MySQL Flexible Servers can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mysql/flexibleServer:FlexibleServer example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DBforMySQL/flexibleServers/flexibleServer1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] administrator_login: The Administrator login for the MySQL Flexible Server. Required when `create_mode` is `Default`. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input[_builtins.str] administrator_password: The Password associated with the `administrator_login` for the MySQL Flexible Server.
        :param pulumi.Input[_builtins.int] administrator_password_wo_version: An integer value used to trigger an update for `administrator_password_wo`. This property should be incremented when updating `administrator_password_wo`.
               
               > **Note:** Either `administrator_password` or `administrator_password_wo` is required when `create_mode` is `Default`.
        :param pulumi.Input[_builtins.int] backup_retention_days: The backup retention days for the MySQL Flexible Server. Possible values are between `1` and `35` days. Defaults to `7`.
        :param pulumi.Input[_builtins.str] create_mode: The creation mode which can be used to restore or replicate existing servers. Possible values are `Default`, `PointInTimeRestore`, `GeoRestore`, and `Replica`. Changing this forces a new MySQL Flexible Server to be created.
               
               > **Note:** Creating a `GeoRestore` server requires the source server with `geo_redundant_backup_enabled` enabled.
               
               > **Note:** When a server is first created it may not be immediately available for `geo restore` or `replica`. It may take a few minutes to several hours for the necessary metadata to be populated. Please see the [Geo Restore](https://learn.microsoft.com/azure/mysql/single-server/how-to-restore-server-portal#geo-restore) and the [Replica](https://learn.microsoft.com/azure/mysql/flexible-server/concepts-read-replicas#create-a-replica) for more information.
               
               > **Note:** When importing a MySQL Flexible Server, `create_mode` is not returned by the api so you will see a diff if `create_mode` is specified in your config. To prevent recreation, use the `ignore_changes` lifecycle meta-argument.
        :param pulumi.Input[Union['FlexibleServerCustomerManagedKeyArgs', 'FlexibleServerCustomerManagedKeyArgsDict']] customer_managed_key: A `customer_managed_key` block as defined below.
               
               > **Note:** `identity` is required when `customer_managed_key` is specified.
        :param pulumi.Input[_builtins.str] delegated_subnet_id: The ID of the virtual network subnet to create the MySQL Flexible Server. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input[_builtins.bool] geo_redundant_backup_enabled: Should geo redundant backup enabled? Defaults to `false`. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input[Union['FlexibleServerHighAvailabilityArgs', 'FlexibleServerHighAvailabilityArgsDict']] high_availability: A `high_availability` block as defined below.
        :param pulumi.Input[Union['FlexibleServerIdentityArgs', 'FlexibleServerIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the MySQL Flexible Server should exist. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input[Union['FlexibleServerMaintenanceWindowArgs', 'FlexibleServerMaintenanceWindowArgsDict']] maintenance_window: A `maintenance_window` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this MySQL Flexible Server. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input[_builtins.str] point_in_time_restore_time_in_utc: The point in time to restore from `creation_source_server_id` when `create_mode` is `PointInTimeRestore`. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input[_builtins.str] private_dns_zone_id: The ID of the private DNS zone to create the MySQL Flexible Server. Changing this forces a new MySQL Flexible Server to be created.
               
               > **Note:** The `private_dns_zone_id` is required when setting a `delegated_subnet_id`. The `privatedns.Zone` should end with suffix `.mysql.database.azure.com`.
        :param pulumi.Input[_builtins.str] public_network_access: Whether approved public traffic is allowed through the firewall to this server. Possible values are `Enabled` and `Disabled`.
               
               > **Note:** `public_network_access` is automatically set to `Disabled` if the server is created with VNet Integration (i.e. values are provided for `delegated_subnet_id` and `private_dns_zone_id`").
        :param pulumi.Input[_builtins.str] replication_role: The replication role. Possible value is `None`.
               
               > **Note:** The `replication_role` cannot be set while creating and only can be updated from `Replica` to `None`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the MySQL Flexible Server should exist. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input[_builtins.str] sku_name: The SKU Name for the MySQL Flexible Server.
               
               > **Note:** `sku_name` should start with SKU tier `B (Burstable)`, `GP (General Purpose)`, `MO (Memory Optimized)` like `B_Standard_B1ms`.
        :param pulumi.Input[_builtins.str] source_server_id: The resource ID of the source MySQL Flexible Server to be restored. Required when `create_mode` is `PointInTimeRestore`, `GeoRestore`, and `Replica`. Changing this forces a new MySQL Flexible Server to be created.
               
               > **Note:** The replica server is always created in the same resource group and subscription as the source server.
        :param pulumi.Input[Union['FlexibleServerStorageArgs', 'FlexibleServerStorageArgsDict']] storage: A `storage` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the MySQL Flexible Server.
        :param pulumi.Input[_builtins.str] version: The version of the MySQL Flexible Server to use. Possible values are `5.7`, and `8.0.21`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: FlexibleServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages a MySQL Flexible Server.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vn",
            location=example.location,
            resource_group_name=example.name,
            address_spaces=["10.0.0.0/16"])
        example_subnet = azure.network.Subnet("example",
            name="example-sn",
            resource_group_name=example.name,
            virtual_network_name=example_virtual_network.name,
            address_prefixes=["10.0.2.0/24"],
            service_endpoints=["Microsoft.Storage"],
            delegations=[{
                "name": "fs",
                "service_delegation": {
                    "name": "Microsoft.DBforMySQL/flexibleServers",
                    "actions": ["Microsoft.Network/virtualNetworks/subnets/join/action"],
                },
            }])
        example_zone = azure.privatedns.Zone("example",
            name="example.mysql.database.azure.com",
            resource_group_name=example.name)
        example_zone_virtual_network_link = azure.privatedns.ZoneVirtualNetworkLink("example",
            name="exampleVnetZone.com",
            private_dns_zone_name=example_zone.name,
            virtual_network_id=example_virtual_network.id,
            resource_group_name=example.name)
        example_flexible_server = azure.mysql.FlexibleServer("example",
            name="example-fs",
            resource_group_name=example.name,
            location=example.location,
            administrator_login="psqladmin",
            administrator_password="H@Sh1CoR3!",
            backup_retention_days=7,
            delegated_subnet_id=example_subnet.id,
            private_dns_zone_id=example_zone.id,
            sku_name="GP_Standard_D2ds_v4",
            opts = pulumi.ResourceOptions(depends_on=[example_zone_virtual_network_link]))
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.DBforMySQL` - 2023-12-30

        ## Import

        MySQL Flexible Servers can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:mysql/flexibleServer:FlexibleServer example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.DBforMySQL/flexibleServers/flexibleServer1
        ```

        :param str resource_name: The name of the resource.
        :param FlexibleServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(FlexibleServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 administrator_login: Optional[pulumi.Input[_builtins.str]] = None,
                 administrator_password: Optional[pulumi.Input[_builtins.str]] = None,
                 administrator_password_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
                 backup_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
                 create_mode: Optional[pulumi.Input[_builtins.str]] = None,
                 customer_managed_key: Optional[pulumi.Input[Union['FlexibleServerCustomerManagedKeyArgs', 'FlexibleServerCustomerManagedKeyArgsDict']]] = None,
                 delegated_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 geo_redundant_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 high_availability: Optional[pulumi.Input[Union['FlexibleServerHighAvailabilityArgs', 'FlexibleServerHighAvailabilityArgsDict']]] = None,
                 identity: Optional[pulumi.Input[Union['FlexibleServerIdentityArgs', 'FlexibleServerIdentityArgsDict']]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 maintenance_window: Optional[pulumi.Input[Union['FlexibleServerMaintenanceWindowArgs', 'FlexibleServerMaintenanceWindowArgsDict']]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 point_in_time_restore_time_in_utc: Optional[pulumi.Input[_builtins.str]] = None,
                 private_dns_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
                 public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
                 replication_role: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku_name: Optional[pulumi.Input[_builtins.str]] = None,
                 source_server_id: Optional[pulumi.Input[_builtins.str]] = None,
                 storage: Optional[pulumi.Input[Union['FlexibleServerStorageArgs', 'FlexibleServerStorageArgsDict']]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 version: Optional[pulumi.Input[_builtins.str]] = None,
                 zone: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = FlexibleServerArgs.__new__(FlexibleServerArgs)

            __props__.__dict__["administrator_login"] = administrator_login
            __props__.__dict__["administrator_password"] = None if administrator_password is None else pulumi.Output.secret(administrator_password)
            __props__.__dict__["administrator_password_wo_version"] = administrator_password_wo_version
            __props__.__dict__["backup_retention_days"] = backup_retention_days
            __props__.__dict__["create_mode"] = create_mode
            __props__.__dict__["customer_managed_key"] = customer_managed_key
            __props__.__dict__["delegated_subnet_id"] = delegated_subnet_id
            __props__.__dict__["geo_redundant_backup_enabled"] = geo_redundant_backup_enabled
            __props__.__dict__["high_availability"] = high_availability
            __props__.__dict__["identity"] = identity
            __props__.__dict__["location"] = location
            __props__.__dict__["maintenance_window"] = maintenance_window
            __props__.__dict__["name"] = name
            __props__.__dict__["point_in_time_restore_time_in_utc"] = point_in_time_restore_time_in_utc
            __props__.__dict__["private_dns_zone_id"] = private_dns_zone_id
            __props__.__dict__["public_network_access"] = public_network_access
            __props__.__dict__["replication_role"] = replication_role
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            __props__.__dict__["sku_name"] = sku_name
            __props__.__dict__["source_server_id"] = source_server_id
            __props__.__dict__["storage"] = storage
            __props__.__dict__["tags"] = tags
            __props__.__dict__["version"] = version
            __props__.__dict__["zone"] = zone
            __props__.__dict__["fqdn"] = None
            __props__.__dict__["public_network_access_enabled"] = None
            __props__.__dict__["replica_capacity"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["administratorPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(FlexibleServer, __self__).__init__(
            'azure:mysql/flexibleServer:FlexibleServer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            administrator_login: Optional[pulumi.Input[_builtins.str]] = None,
            administrator_password: Optional[pulumi.Input[_builtins.str]] = None,
            administrator_password_wo_version: Optional[pulumi.Input[_builtins.int]] = None,
            backup_retention_days: Optional[pulumi.Input[_builtins.int]] = None,
            create_mode: Optional[pulumi.Input[_builtins.str]] = None,
            customer_managed_key: Optional[pulumi.Input[Union['FlexibleServerCustomerManagedKeyArgs', 'FlexibleServerCustomerManagedKeyArgsDict']]] = None,
            delegated_subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            fqdn: Optional[pulumi.Input[_builtins.str]] = None,
            geo_redundant_backup_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            high_availability: Optional[pulumi.Input[Union['FlexibleServerHighAvailabilityArgs', 'FlexibleServerHighAvailabilityArgsDict']]] = None,
            identity: Optional[pulumi.Input[Union['FlexibleServerIdentityArgs', 'FlexibleServerIdentityArgsDict']]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            maintenance_window: Optional[pulumi.Input[Union['FlexibleServerMaintenanceWindowArgs', 'FlexibleServerMaintenanceWindowArgsDict']]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            point_in_time_restore_time_in_utc: Optional[pulumi.Input[_builtins.str]] = None,
            private_dns_zone_id: Optional[pulumi.Input[_builtins.str]] = None,
            public_network_access: Optional[pulumi.Input[_builtins.str]] = None,
            public_network_access_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            replica_capacity: Optional[pulumi.Input[_builtins.int]] = None,
            replication_role: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            sku_name: Optional[pulumi.Input[_builtins.str]] = None,
            source_server_id: Optional[pulumi.Input[_builtins.str]] = None,
            storage: Optional[pulumi.Input[Union['FlexibleServerStorageArgs', 'FlexibleServerStorageArgsDict']]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            version: Optional[pulumi.Input[_builtins.str]] = None,
            zone: Optional[pulumi.Input[_builtins.str]] = None) -> 'FlexibleServer':
        """
        Get an existing FlexibleServer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] administrator_login: The Administrator login for the MySQL Flexible Server. Required when `create_mode` is `Default`. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input[_builtins.str] administrator_password: The Password associated with the `administrator_login` for the MySQL Flexible Server.
        :param pulumi.Input[_builtins.int] administrator_password_wo_version: An integer value used to trigger an update for `administrator_password_wo`. This property should be incremented when updating `administrator_password_wo`.
               
               > **Note:** Either `administrator_password` or `administrator_password_wo` is required when `create_mode` is `Default`.
        :param pulumi.Input[_builtins.int] backup_retention_days: The backup retention days for the MySQL Flexible Server. Possible values are between `1` and `35` days. Defaults to `7`.
        :param pulumi.Input[_builtins.str] create_mode: The creation mode which can be used to restore or replicate existing servers. Possible values are `Default`, `PointInTimeRestore`, `GeoRestore`, and `Replica`. Changing this forces a new MySQL Flexible Server to be created.
               
               > **Note:** Creating a `GeoRestore` server requires the source server with `geo_redundant_backup_enabled` enabled.
               
               > **Note:** When a server is first created it may not be immediately available for `geo restore` or `replica`. It may take a few minutes to several hours for the necessary metadata to be populated. Please see the [Geo Restore](https://learn.microsoft.com/azure/mysql/single-server/how-to-restore-server-portal#geo-restore) and the [Replica](https://learn.microsoft.com/azure/mysql/flexible-server/concepts-read-replicas#create-a-replica) for more information.
               
               > **Note:** When importing a MySQL Flexible Server, `create_mode` is not returned by the api so you will see a diff if `create_mode` is specified in your config. To prevent recreation, use the `ignore_changes` lifecycle meta-argument.
        :param pulumi.Input[Union['FlexibleServerCustomerManagedKeyArgs', 'FlexibleServerCustomerManagedKeyArgsDict']] customer_managed_key: A `customer_managed_key` block as defined below.
               
               > **Note:** `identity` is required when `customer_managed_key` is specified.
        :param pulumi.Input[_builtins.str] delegated_subnet_id: The ID of the virtual network subnet to create the MySQL Flexible Server. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input[_builtins.str] fqdn: The fully qualified domain name of the MySQL Flexible Server.
        :param pulumi.Input[_builtins.bool] geo_redundant_backup_enabled: Should geo redundant backup enabled? Defaults to `false`. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input[Union['FlexibleServerHighAvailabilityArgs', 'FlexibleServerHighAvailabilityArgsDict']] high_availability: A `high_availability` block as defined below.
        :param pulumi.Input[Union['FlexibleServerIdentityArgs', 'FlexibleServerIdentityArgsDict']] identity: An `identity` block as defined below.
        :param pulumi.Input[_builtins.str] location: The Azure Region where the MySQL Flexible Server should exist. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input[Union['FlexibleServerMaintenanceWindowArgs', 'FlexibleServerMaintenanceWindowArgsDict']] maintenance_window: A `maintenance_window` block as defined below.
        :param pulumi.Input[_builtins.str] name: The name which should be used for this MySQL Flexible Server. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input[_builtins.str] point_in_time_restore_time_in_utc: The point in time to restore from `creation_source_server_id` when `create_mode` is `PointInTimeRestore`. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input[_builtins.str] private_dns_zone_id: The ID of the private DNS zone to create the MySQL Flexible Server. Changing this forces a new MySQL Flexible Server to be created.
               
               > **Note:** The `private_dns_zone_id` is required when setting a `delegated_subnet_id`. The `privatedns.Zone` should end with suffix `.mysql.database.azure.com`.
        :param pulumi.Input[_builtins.str] public_network_access: Whether approved public traffic is allowed through the firewall to this server. Possible values are `Enabled` and `Disabled`.
               
               > **Note:** `public_network_access` is automatically set to `Disabled` if the server is created with VNet Integration (i.e. values are provided for `delegated_subnet_id` and `private_dns_zone_id`").
        :param pulumi.Input[_builtins.int] replica_capacity: The maximum number of replicas that a primary MySQL Flexible Server can have.
        :param pulumi.Input[_builtins.str] replication_role: The replication role. Possible value is `None`.
               
               > **Note:** The `replication_role` cannot be set while creating and only can be updated from `Replica` to `None`.
        :param pulumi.Input[_builtins.str] resource_group_name: The name of the Resource Group where the MySQL Flexible Server should exist. Changing this forces a new MySQL Flexible Server to be created.
        :param pulumi.Input[_builtins.str] sku_name: The SKU Name for the MySQL Flexible Server.
               
               > **Note:** `sku_name` should start with SKU tier `B (Burstable)`, `GP (General Purpose)`, `MO (Memory Optimized)` like `B_Standard_B1ms`.
        :param pulumi.Input[_builtins.str] source_server_id: The resource ID of the source MySQL Flexible Server to be restored. Required when `create_mode` is `PointInTimeRestore`, `GeoRestore`, and `Replica`. Changing this forces a new MySQL Flexible Server to be created.
               
               > **Note:** The replica server is always created in the same resource group and subscription as the source server.
        :param pulumi.Input[Union['FlexibleServerStorageArgs', 'FlexibleServerStorageArgsDict']] storage: A `storage` block as defined below.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags which should be assigned to the MySQL Flexible Server.
        :param pulumi.Input[_builtins.str] version: The version of the MySQL Flexible Server to use. Possible values are `5.7`, and `8.0.21`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _FlexibleServerState.__new__(_FlexibleServerState)

        __props__.__dict__["administrator_login"] = administrator_login
        __props__.__dict__["administrator_password"] = administrator_password
        __props__.__dict__["administrator_password_wo_version"] = administrator_password_wo_version
        __props__.__dict__["backup_retention_days"] = backup_retention_days
        __props__.__dict__["create_mode"] = create_mode
        __props__.__dict__["customer_managed_key"] = customer_managed_key
        __props__.__dict__["delegated_subnet_id"] = delegated_subnet_id
        __props__.__dict__["fqdn"] = fqdn
        __props__.__dict__["geo_redundant_backup_enabled"] = geo_redundant_backup_enabled
        __props__.__dict__["high_availability"] = high_availability
        __props__.__dict__["identity"] = identity
        __props__.__dict__["location"] = location
        __props__.__dict__["maintenance_window"] = maintenance_window
        __props__.__dict__["name"] = name
        __props__.__dict__["point_in_time_restore_time_in_utc"] = point_in_time_restore_time_in_utc
        __props__.__dict__["private_dns_zone_id"] = private_dns_zone_id
        __props__.__dict__["public_network_access"] = public_network_access
        __props__.__dict__["public_network_access_enabled"] = public_network_access_enabled
        __props__.__dict__["replica_capacity"] = replica_capacity
        __props__.__dict__["replication_role"] = replication_role
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["sku_name"] = sku_name
        __props__.__dict__["source_server_id"] = source_server_id
        __props__.__dict__["storage"] = storage
        __props__.__dict__["tags"] = tags
        __props__.__dict__["version"] = version
        __props__.__dict__["zone"] = zone
        return FlexibleServer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="administratorLogin")
    def administrator_login(self) -> pulumi.Output[_builtins.str]:
        """
        The Administrator login for the MySQL Flexible Server. Required when `create_mode` is `Default`. Changing this forces a new MySQL Flexible Server to be created.
        """
        return pulumi.get(self, "administrator_login")

    @_builtins.property
    @pulumi.getter(name="administratorPassword")
    def administrator_password(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The Password associated with the `administrator_login` for the MySQL Flexible Server.
        """
        return pulumi.get(self, "administrator_password")

    @_builtins.property
    @pulumi.getter(name="administratorPasswordWoVersion")
    def administrator_password_wo_version(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        An integer value used to trigger an update for `administrator_password_wo`. This property should be incremented when updating `administrator_password_wo`.

        > **Note:** Either `administrator_password` or `administrator_password_wo` is required when `create_mode` is `Default`.
        """
        return pulumi.get(self, "administrator_password_wo_version")

    @_builtins.property
    @pulumi.getter(name="backupRetentionDays")
    def backup_retention_days(self) -> pulumi.Output[Optional[_builtins.int]]:
        """
        The backup retention days for the MySQL Flexible Server. Possible values are between `1` and `35` days. Defaults to `7`.
        """
        return pulumi.get(self, "backup_retention_days")

    @_builtins.property
    @pulumi.getter(name="createMode")
    def create_mode(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The creation mode which can be used to restore or replicate existing servers. Possible values are `Default`, `PointInTimeRestore`, `GeoRestore`, and `Replica`. Changing this forces a new MySQL Flexible Server to be created.

        > **Note:** Creating a `GeoRestore` server requires the source server with `geo_redundant_backup_enabled` enabled.

        > **Note:** When a server is first created it may not be immediately available for `geo restore` or `replica`. It may take a few minutes to several hours for the necessary metadata to be populated. Please see the [Geo Restore](https://learn.microsoft.com/azure/mysql/single-server/how-to-restore-server-portal#geo-restore) and the [Replica](https://learn.microsoft.com/azure/mysql/flexible-server/concepts-read-replicas#create-a-replica) for more information.

        > **Note:** When importing a MySQL Flexible Server, `create_mode` is not returned by the api so you will see a diff if `create_mode` is specified in your config. To prevent recreation, use the `ignore_changes` lifecycle meta-argument.
        """
        return pulumi.get(self, "create_mode")

    @_builtins.property
    @pulumi.getter(name="customerManagedKey")
    def customer_managed_key(self) -> pulumi.Output[Optional['outputs.FlexibleServerCustomerManagedKey']]:
        """
        A `customer_managed_key` block as defined below.

        > **Note:** `identity` is required when `customer_managed_key` is specified.
        """
        return pulumi.get(self, "customer_managed_key")

    @_builtins.property
    @pulumi.getter(name="delegatedSubnetId")
    def delegated_subnet_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the virtual network subnet to create the MySQL Flexible Server. Changing this forces a new MySQL Flexible Server to be created.
        """
        return pulumi.get(self, "delegated_subnet_id")

    @_builtins.property
    @pulumi.getter
    def fqdn(self) -> pulumi.Output[_builtins.str]:
        """
        The fully qualified domain name of the MySQL Flexible Server.
        """
        return pulumi.get(self, "fqdn")

    @_builtins.property
    @pulumi.getter(name="geoRedundantBackupEnabled")
    def geo_redundant_backup_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Should geo redundant backup enabled? Defaults to `false`. Changing this forces a new MySQL Flexible Server to be created.
        """
        return pulumi.get(self, "geo_redundant_backup_enabled")

    @_builtins.property
    @pulumi.getter(name="highAvailability")
    def high_availability(self) -> pulumi.Output[Optional['outputs.FlexibleServerHighAvailability']]:
        """
        A `high_availability` block as defined below.
        """
        return pulumi.get(self, "high_availability")

    @_builtins.property
    @pulumi.getter
    def identity(self) -> pulumi.Output[Optional['outputs.FlexibleServerIdentity']]:
        """
        An `identity` block as defined below.
        """
        return pulumi.get(self, "identity")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The Azure Region where the MySQL Flexible Server should exist. Changing this forces a new MySQL Flexible Server to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> pulumi.Output[Optional['outputs.FlexibleServerMaintenanceWindow']]:
        """
        A `maintenance_window` block as defined below.
        """
        return pulumi.get(self, "maintenance_window")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name which should be used for this MySQL Flexible Server. Changing this forces a new MySQL Flexible Server to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="pointInTimeRestoreTimeInUtc")
    def point_in_time_restore_time_in_utc(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The point in time to restore from `creation_source_server_id` when `create_mode` is `PointInTimeRestore`. Changing this forces a new MySQL Flexible Server to be created.
        """
        return pulumi.get(self, "point_in_time_restore_time_in_utc")

    @_builtins.property
    @pulumi.getter(name="privateDnsZoneId")
    def private_dns_zone_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The ID of the private DNS zone to create the MySQL Flexible Server. Changing this forces a new MySQL Flexible Server to be created.

        > **Note:** The `private_dns_zone_id` is required when setting a `delegated_subnet_id`. The `privatedns.Zone` should end with suffix `.mysql.database.azure.com`.
        """
        return pulumi.get(self, "private_dns_zone_id")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccess")
    def public_network_access(self) -> pulumi.Output[_builtins.str]:
        """
        Whether approved public traffic is allowed through the firewall to this server. Possible values are `Enabled` and `Disabled`.

        > **Note:** `public_network_access` is automatically set to `Disabled` if the server is created with VNet Integration (i.e. values are provided for `delegated_subnet_id` and `private_dns_zone_id`").
        """
        return pulumi.get(self, "public_network_access")

    @_builtins.property
    @pulumi.getter(name="publicNetworkAccessEnabled")
    def public_network_access_enabled(self) -> pulumi.Output[_builtins.bool]:
        return pulumi.get(self, "public_network_access_enabled")

    @_builtins.property
    @pulumi.getter(name="replicaCapacity")
    def replica_capacity(self) -> pulumi.Output[_builtins.int]:
        """
        The maximum number of replicas that a primary MySQL Flexible Server can have.
        """
        return pulumi.get(self, "replica_capacity")

    @_builtins.property
    @pulumi.getter(name="replicationRole")
    def replication_role(self) -> pulumi.Output[_builtins.str]:
        """
        The replication role. Possible value is `None`.

        > **Note:** The `replication_role` cannot be set while creating and only can be updated from `Replica` to `None`.
        """
        return pulumi.get(self, "replication_role")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Resource Group where the MySQL Flexible Server should exist. Changing this forces a new MySQL Flexible Server to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="skuName")
    def sku_name(self) -> pulumi.Output[_builtins.str]:
        """
        The SKU Name for the MySQL Flexible Server.

        > **Note:** `sku_name` should start with SKU tier `B (Burstable)`, `GP (General Purpose)`, `MO (Memory Optimized)` like `B_Standard_B1ms`.
        """
        return pulumi.get(self, "sku_name")

    @_builtins.property
    @pulumi.getter(name="sourceServerId")
    def source_server_id(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The resource ID of the source MySQL Flexible Server to be restored. Required when `create_mode` is `PointInTimeRestore`, `GeoRestore`, and `Replica`. Changing this forces a new MySQL Flexible Server to be created.

        > **Note:** The replica server is always created in the same resource group and subscription as the source server.
        """
        return pulumi.get(self, "source_server_id")

    @_builtins.property
    @pulumi.getter
    def storage(self) -> pulumi.Output['outputs.FlexibleServerStorage']:
        """
        A `storage` block as defined below.
        """
        return pulumi.get(self, "storage")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags which should be assigned to the MySQL Flexible Server.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter
    def version(self) -> pulumi.Output[_builtins.str]:
        """
        The version of the MySQL Flexible Server to use. Possible values are `5.7`, and `8.0.21`.
        """
        return pulumi.get(self, "version")

    @_builtins.property
    @pulumi.getter
    def zone(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "zone")

