# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetExpressRouteCircuitResult',
    'AwaitableGetExpressRouteCircuitResult',
    'get_express_route_circuit',
    'get_express_route_circuit_output',
]

@pulumi.output_type
class GetExpressRouteCircuitResult:
    """
    A collection of values returned by getExpressRouteCircuit.
    """
    def __init__(__self__, id=None, location=None, name=None, peerings=None, resource_group_name=None, service_key=None, service_provider_properties=None, service_provider_provisioning_state=None, sku=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if peerings and not isinstance(peerings, list):
            raise TypeError("Expected argument 'peerings' to be a list")
        pulumi.set(__self__, "peerings", peerings)
        if resource_group_name and not isinstance(resource_group_name, str):
            raise TypeError("Expected argument 'resource_group_name' to be a str")
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        if service_key and not isinstance(service_key, str):
            raise TypeError("Expected argument 'service_key' to be a str")
        pulumi.set(__self__, "service_key", service_key)
        if service_provider_properties and not isinstance(service_provider_properties, list):
            raise TypeError("Expected argument 'service_provider_properties' to be a list")
        pulumi.set(__self__, "service_provider_properties", service_provider_properties)
        if service_provider_provisioning_state and not isinstance(service_provider_provisioning_state, str):
            raise TypeError("Expected argument 'service_provider_provisioning_state' to be a str")
        pulumi.set(__self__, "service_provider_provisioning_state", service_provider_provisioning_state)
        if sku and not isinstance(sku, dict):
            raise TypeError("Expected argument 'sku' to be a dict")
        pulumi.set(__self__, "sku", sku)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        """
        The Azure location where the ExpressRoute circuit exists
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def peerings(self) -> Sequence['outputs.GetExpressRouteCircuitPeeringResult']:
        """
        A `peerings` block for the ExpressRoute circuit as documented below
        """
        return pulumi.get(self, "peerings")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> _builtins.str:
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="serviceKey")
    def service_key(self) -> _builtins.str:
        """
        The string needed by the service provider to provision the ExpressRoute circuit.
        """
        return pulumi.get(self, "service_key")

    @_builtins.property
    @pulumi.getter(name="serviceProviderProperties")
    def service_provider_properties(self) -> Sequence['outputs.GetExpressRouteCircuitServiceProviderPropertyResult']:
        """
        A `service_provider_properties` block for the ExpressRoute circuit as documented below
        """
        return pulumi.get(self, "service_provider_properties")

    @_builtins.property
    @pulumi.getter(name="serviceProviderProvisioningState")
    def service_provider_provisioning_state(self) -> _builtins.str:
        """
        The ExpressRoute circuit provisioning state from your chosen service provider. Possible values are `NotProvisioned`, `Provisioning`, `Provisioned`, and `Deprovisioning`.
        """
        return pulumi.get(self, "service_provider_provisioning_state")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> 'outputs.GetExpressRouteCircuitSkuResult':
        """
        A `sku` block for the ExpressRoute circuit as documented below.
        """
        return pulumi.get(self, "sku")


class AwaitableGetExpressRouteCircuitResult(GetExpressRouteCircuitResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetExpressRouteCircuitResult(
            id=self.id,
            location=self.location,
            name=self.name,
            peerings=self.peerings,
            resource_group_name=self.resource_group_name,
            service_key=self.service_key,
            service_provider_properties=self.service_provider_properties,
            service_provider_provisioning_state=self.service_provider_provisioning_state,
            sku=self.sku)


def get_express_route_circuit(name: Optional[_builtins.str] = None,
                              resource_group_name: Optional[_builtins.str] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetExpressRouteCircuitResult:
    """
    Use this data source to access information about an existing ExpressRoute circuit.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_express_route_circuit(resource_group_name=example_azurerm_resource_group["name"],
        name=example_azurerm_express_route_circuit["name"])
    pulumi.export("expressRouteCircuitId", example.id)
    pulumi.export("serviceKey", example.service_key)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2024-05-01


    :param _builtins.str name: The name of the ExpressRoute circuit.
    :param _builtins.str resource_group_name: The Name of the Resource Group where the ExpressRoute circuit exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('azure:network/getExpressRouteCircuit:getExpressRouteCircuit', __args__, opts=opts, typ=GetExpressRouteCircuitResult).value

    return AwaitableGetExpressRouteCircuitResult(
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name=pulumi.get(__ret__, 'name'),
        peerings=pulumi.get(__ret__, 'peerings'),
        resource_group_name=pulumi.get(__ret__, 'resource_group_name'),
        service_key=pulumi.get(__ret__, 'service_key'),
        service_provider_properties=pulumi.get(__ret__, 'service_provider_properties'),
        service_provider_provisioning_state=pulumi.get(__ret__, 'service_provider_provisioning_state'),
        sku=pulumi.get(__ret__, 'sku'))
def get_express_route_circuit_output(name: Optional[pulumi.Input[_builtins.str]] = None,
                                     resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetExpressRouteCircuitResult]:
    """
    Use this data source to access information about an existing ExpressRoute circuit.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_azure as azure

    example = azure.network.get_express_route_circuit(resource_group_name=example_azurerm_resource_group["name"],
        name=example_azurerm_express_route_circuit["name"])
    pulumi.export("expressRouteCircuitId", example.id)
    pulumi.export("serviceKey", example.service_key)
    ```

    ## API Providers

    <!-- This section is generated, changes will be overwritten -->
    This data source uses the following Azure API Providers:

    * `Microsoft.Network` - 2024-05-01


    :param _builtins.str name: The name of the ExpressRoute circuit.
    :param _builtins.str resource_group_name: The Name of the Resource Group where the ExpressRoute circuit exists.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['resourceGroupName'] = resource_group_name
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('azure:network/getExpressRouteCircuit:getExpressRouteCircuit', __args__, opts=opts, typ=GetExpressRouteCircuitResult)
    return __ret__.apply(lambda __response__: GetExpressRouteCircuitResult(
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name=pulumi.get(__response__, 'name'),
        peerings=pulumi.get(__response__, 'peerings'),
        resource_group_name=pulumi.get(__response__, 'resource_group_name'),
        service_key=pulumi.get(__response__, 'service_key'),
        service_provider_properties=pulumi.get(__response__, 'service_provider_properties'),
        service_provider_provisioning_state=pulumi.get(__response__, 'service_provider_provisioning_state'),
        sku=pulumi.get(__response__, 'sku')))
