# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['RouteServerArgs', 'RouteServer']

@pulumi.input_type
class RouteServerArgs:
    def __init__(__self__, *,
                 public_ip_address_id: pulumi.Input[_builtins.str],
                 resource_group_name: pulumi.Input[_builtins.str],
                 sku: pulumi.Input[_builtins.str],
                 subnet_id: pulumi.Input[_builtins.str],
                 branch_to_branch_traffic_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hub_routing_preference: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a RouteServer resource.
        :param pulumi.Input[_builtins.str] public_ip_address_id: The ID of the Public IP Address. This option is required since September 1st 2021. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Route Server should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: The SKU of the Route Server. The only possible value is `Standard`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the Subnet that the Route Server will reside. Changing this forces a new resource to be created.
               
               > **Note:** Azure Route Server requires a dedicated subnet named RouteServerSubnet. The subnet size has to be at least /27 or short prefix (such as /26 or /25) and cannot be attached to any security group, otherwise, you'll receive an error message when deploying the Route Server.
        :param pulumi.Input[_builtins.bool] branch_to_branch_traffic_enabled: Whether to enable route exchange between Azure Route Server and the gateway(s).
        :param pulumi.Input[_builtins.str] hub_routing_preference: The hub routing preference. Valid values are `ASPath`, `ExpressRoute` or `VpnGateway`. Defaults to `ExpressRoute`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the Route Server should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Route Server. Changing this forces a new resource to be created.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        pulumi.set(__self__, "public_ip_address_id", public_ip_address_id)
        pulumi.set(__self__, "resource_group_name", resource_group_name)
        pulumi.set(__self__, "sku", sku)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if branch_to_branch_traffic_enabled is not None:
            pulumi.set(__self__, "branch_to_branch_traffic_enabled", branch_to_branch_traffic_enabled)
        if hub_routing_preference is not None:
            pulumi.set(__self__, "hub_routing_preference", hub_routing_preference)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @_builtins.property
    @pulumi.getter(name="publicIpAddressId")
    def public_ip_address_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Public IP Address. This option is required since September 1st 2021. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "public_ip_address_id")

    @public_ip_address_id.setter
    def public_ip_address_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "public_ip_address_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Input[_builtins.str]:
        """
        Specifies the name of the Resource Group where the Route Server should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Input[_builtins.str]:
        """
        The SKU of the Route Server. The only possible value is `Standard`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[_builtins.str]:
        """
        The ID of the Subnet that the Route Server will reside. Changing this forces a new resource to be created.

        > **Note:** Azure Route Server requires a dedicated subnet named RouteServerSubnet. The subnet size has to be at least /27 or short prefix (such as /26 or /25) and cannot be attached to any security group, otherwise, you'll receive an error message when deploying the Route Server.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter(name="branchToBranchTrafficEnabled")
    def branch_to_branch_traffic_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable route exchange between Azure Route Server and the gateway(s).
        """
        return pulumi.get(self, "branch_to_branch_traffic_enabled")

    @branch_to_branch_traffic_enabled.setter
    def branch_to_branch_traffic_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "branch_to_branch_traffic_enabled", value)

    @_builtins.property
    @pulumi.getter(name="hubRoutingPreference")
    def hub_routing_preference(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hub routing preference. Valid values are `ASPath`, `ExpressRoute` or `VpnGateway`. Defaults to `ExpressRoute`.
        """
        return pulumi.get(self, "hub_routing_preference")

    @hub_routing_preference.setter
    def hub_routing_preference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hub_routing_preference", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the Route Server should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Route Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _RouteServerState:
    def __init__(__self__, *,
                 branch_to_branch_traffic_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hub_routing_preference: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_address_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 routing_state: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 virtual_router_asn: Optional[pulumi.Input[_builtins.int]] = None,
                 virtual_router_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering RouteServer resources.
        :param pulumi.Input[_builtins.bool] branch_to_branch_traffic_enabled: Whether to enable route exchange between Azure Route Server and the gateway(s).
        :param pulumi.Input[_builtins.str] hub_routing_preference: The hub routing preference. Valid values are `ASPath`, `ExpressRoute` or `VpnGateway`. Defaults to `ExpressRoute`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the Route Server should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Route Server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] public_ip_address_id: The ID of the Public IP Address. This option is required since September 1st 2021. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Route Server should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: The SKU of the Route Server. The only possible value is `Standard`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the Subnet that the Route Server will reside. Changing this forces a new resource to be created.
               
               > **Note:** Azure Route Server requires a dedicated subnet named RouteServerSubnet. The subnet size has to be at least /27 or short prefix (such as /26 or /25) and cannot be attached to any security group, otherwise, you'll receive an error message when deploying the Route Server.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        if branch_to_branch_traffic_enabled is not None:
            pulumi.set(__self__, "branch_to_branch_traffic_enabled", branch_to_branch_traffic_enabled)
        if hub_routing_preference is not None:
            pulumi.set(__self__, "hub_routing_preference", hub_routing_preference)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if public_ip_address_id is not None:
            pulumi.set(__self__, "public_ip_address_id", public_ip_address_id)
        if resource_group_name is not None:
            pulumi.set(__self__, "resource_group_name", resource_group_name)
        if routing_state is not None:
            pulumi.set(__self__, "routing_state", routing_state)
        if sku is not None:
            pulumi.set(__self__, "sku", sku)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if virtual_router_asn is not None:
            pulumi.set(__self__, "virtual_router_asn", virtual_router_asn)
        if virtual_router_ips is not None:
            pulumi.set(__self__, "virtual_router_ips", virtual_router_ips)

    @_builtins.property
    @pulumi.getter(name="branchToBranchTrafficEnabled")
    def branch_to_branch_traffic_enabled(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether to enable route exchange between Azure Route Server and the gateway(s).
        """
        return pulumi.get(self, "branch_to_branch_traffic_enabled")

    @branch_to_branch_traffic_enabled.setter
    def branch_to_branch_traffic_enabled(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "branch_to_branch_traffic_enabled", value)

    @_builtins.property
    @pulumi.getter(name="hubRoutingPreference")
    def hub_routing_preference(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The hub routing preference. Valid values are `ASPath`, `ExpressRoute` or `VpnGateway`. Defaults to `ExpressRoute`.
        """
        return pulumi.get(self, "hub_routing_preference")

    @hub_routing_preference.setter
    def hub_routing_preference(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hub_routing_preference", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the supported Azure location where the Route Server should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Route Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter(name="publicIpAddressId")
    def public_ip_address_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Public IP Address. This option is required since September 1st 2021. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "public_ip_address_id")

    @public_ip_address_id.setter
    def public_ip_address_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "public_ip_address_id", value)

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Specifies the name of the Resource Group where the Route Server should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @resource_group_name.setter
    def resource_group_name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "resource_group_name", value)

    @_builtins.property
    @pulumi.getter(name="routingState")
    def routing_state(self) -> Optional[pulumi.Input[_builtins.str]]:
        return pulumi.get(self, "routing_state")

    @routing_state.setter
    def routing_state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "routing_state", value)

    @_builtins.property
    @pulumi.getter
    def sku(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The SKU of the Route Server. The only possible value is `Standard`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @sku.setter
    def sku(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "sku", value)

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the Subnet that the Route Server will reside. Changing this forces a new resource to be created.

        > **Note:** Azure Route Server requires a dedicated subnet named RouteServerSubnet. The subnet size has to be at least /27 or short prefix (such as /26 or /25) and cannot be attached to any security group, otherwise, you'll receive an error message when deploying the Route Server.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "subnet_id", value)

    @_builtins.property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "tags", value)

    @_builtins.property
    @pulumi.getter(name="virtualRouterAsn")
    def virtual_router_asn(self) -> Optional[pulumi.Input[_builtins.int]]:
        return pulumi.get(self, "virtual_router_asn")

    @virtual_router_asn.setter
    def virtual_router_asn(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "virtual_router_asn", value)

    @_builtins.property
    @pulumi.getter(name="virtualRouterIps")
    def virtual_router_ips(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "virtual_router_ips")

    @virtual_router_ips.setter
    def virtual_router_ips(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "virtual_router_ips", value)


@pulumi.type_token("azure:network/routeServer:RouteServer")
class RouteServer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 branch_to_branch_traffic_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hub_routing_preference: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_address_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        """
        Manages an Azure Route Server

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vn",
            address_spaces=["10.0.0.0/16"],
            resource_group_name=example.name,
            location=example.location,
            tags={
                "environment": "Production",
            })
        example_subnet = azure.network.Subnet("example",
            name="RouteServerSubnet",
            virtual_network_name=example_virtual_network.name,
            resource_group_name=example.name,
            address_prefixes=["10.0.1.0/24"])
        example_public_ip = azure.network.PublicIp("example",
            name="example-pip",
            resource_group_name=example.name,
            location=example.location,
            allocation_method="Static",
            sku="Standard")
        example_route_server = azure.network.RouteServer("example",
            name="example-routerserver",
            resource_group_name=example.name,
            location=example.location,
            sku="Standard",
            public_ip_address_id=example_public_ip.id,
            subnet_id=example_subnet.id,
            branch_to_branch_traffic_enabled=True,
            hub_routing_preference="ASPath")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2024-05-01

        ## Import

        Route Server can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/routeServer:RouteServer example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/virtualHubs/routeServer1
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] branch_to_branch_traffic_enabled: Whether to enable route exchange between Azure Route Server and the gateway(s).
        :param pulumi.Input[_builtins.str] hub_routing_preference: The hub routing preference. Valid values are `ASPath`, `ExpressRoute` or `VpnGateway`. Defaults to `ExpressRoute`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the Route Server should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Route Server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] public_ip_address_id: The ID of the Public IP Address. This option is required since September 1st 2021. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Route Server should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: The SKU of the Route Server. The only possible value is `Standard`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the Subnet that the Route Server will reside. Changing this forces a new resource to be created.
               
               > **Note:** Azure Route Server requires a dedicated subnet named RouteServerSubnet. The subnet size has to be at least /27 or short prefix (such as /26 or /25) and cannot be attached to any security group, otherwise, you'll receive an error message when deploying the Route Server.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteServerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Azure Route Server

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azure as azure

        example = azure.core.ResourceGroup("example",
            name="example-resources",
            location="West Europe")
        example_virtual_network = azure.network.VirtualNetwork("example",
            name="example-vn",
            address_spaces=["10.0.0.0/16"],
            resource_group_name=example.name,
            location=example.location,
            tags={
                "environment": "Production",
            })
        example_subnet = azure.network.Subnet("example",
            name="RouteServerSubnet",
            virtual_network_name=example_virtual_network.name,
            resource_group_name=example.name,
            address_prefixes=["10.0.1.0/24"])
        example_public_ip = azure.network.PublicIp("example",
            name="example-pip",
            resource_group_name=example.name,
            location=example.location,
            allocation_method="Static",
            sku="Standard")
        example_route_server = azure.network.RouteServer("example",
            name="example-routerserver",
            resource_group_name=example.name,
            location=example.location,
            sku="Standard",
            public_ip_address_id=example_public_ip.id,
            subnet_id=example_subnet.id,
            branch_to_branch_traffic_enabled=True,
            hub_routing_preference="ASPath")
        ```

        ## API Providers

        <!-- This section is generated, changes will be overwritten -->
        This resource uses the following Azure API Providers:

        * `Microsoft.Network` - 2024-05-01

        ## Import

        Route Server can be imported using the `resource id`, e.g.

        ```sh
        $ pulumi import azure:network/routeServer:RouteServer example /subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/group1/providers/Microsoft.Network/virtualHubs/routeServer1
        ```

        :param str resource_name: The name of the resource.
        :param RouteServerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteServerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 branch_to_branch_traffic_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
                 hub_routing_preference: Optional[pulumi.Input[_builtins.str]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 public_ip_address_id: Optional[pulumi.Input[_builtins.str]] = None,
                 resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
                 sku: Optional[pulumi.Input[_builtins.str]] = None,
                 subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
                 tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteServerArgs.__new__(RouteServerArgs)

            __props__.__dict__["branch_to_branch_traffic_enabled"] = branch_to_branch_traffic_enabled
            __props__.__dict__["hub_routing_preference"] = hub_routing_preference
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            if public_ip_address_id is None and not opts.urn:
                raise TypeError("Missing required property 'public_ip_address_id'")
            __props__.__dict__["public_ip_address_id"] = public_ip_address_id
            if resource_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'resource_group_name'")
            __props__.__dict__["resource_group_name"] = resource_group_name
            if sku is None and not opts.urn:
                raise TypeError("Missing required property 'sku'")
            __props__.__dict__["sku"] = sku
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["routing_state"] = None
            __props__.__dict__["virtual_router_asn"] = None
            __props__.__dict__["virtual_router_ips"] = None
        super(RouteServer, __self__).__init__(
            'azure:network/routeServer:RouteServer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            branch_to_branch_traffic_enabled: Optional[pulumi.Input[_builtins.bool]] = None,
            hub_routing_preference: Optional[pulumi.Input[_builtins.str]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            public_ip_address_id: Optional[pulumi.Input[_builtins.str]] = None,
            resource_group_name: Optional[pulumi.Input[_builtins.str]] = None,
            routing_state: Optional[pulumi.Input[_builtins.str]] = None,
            sku: Optional[pulumi.Input[_builtins.str]] = None,
            subnet_id: Optional[pulumi.Input[_builtins.str]] = None,
            tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            virtual_router_asn: Optional[pulumi.Input[_builtins.int]] = None,
            virtual_router_ips: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'RouteServer':
        """
        Get an existing RouteServer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] branch_to_branch_traffic_enabled: Whether to enable route exchange between Azure Route Server and the gateway(s).
        :param pulumi.Input[_builtins.str] hub_routing_preference: The hub routing preference. Valid values are `ASPath`, `ExpressRoute` or `VpnGateway`. Defaults to `ExpressRoute`.
        :param pulumi.Input[_builtins.str] location: Specifies the supported Azure location where the Route Server should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] name: The name of the Route Server. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] public_ip_address_id: The ID of the Public IP Address. This option is required since September 1st 2021. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] resource_group_name: Specifies the name of the Resource Group where the Route Server should exist. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] sku: The SKU of the Route Server. The only possible value is `Standard`. Changing this forces a new resource to be created.
        :param pulumi.Input[_builtins.str] subnet_id: The ID of the Subnet that the Route Server will reside. Changing this forces a new resource to be created.
               
               > **Note:** Azure Route Server requires a dedicated subnet named RouteServerSubnet. The subnet size has to be at least /27 or short prefix (such as /26 or /25) and cannot be attached to any security group, otherwise, you'll receive an error message when deploying the Route Server.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] tags: A mapping of tags to assign to the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouteServerState.__new__(_RouteServerState)

        __props__.__dict__["branch_to_branch_traffic_enabled"] = branch_to_branch_traffic_enabled
        __props__.__dict__["hub_routing_preference"] = hub_routing_preference
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["public_ip_address_id"] = public_ip_address_id
        __props__.__dict__["resource_group_name"] = resource_group_name
        __props__.__dict__["routing_state"] = routing_state
        __props__.__dict__["sku"] = sku
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["virtual_router_asn"] = virtual_router_asn
        __props__.__dict__["virtual_router_ips"] = virtual_router_ips
        return RouteServer(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="branchToBranchTrafficEnabled")
    def branch_to_branch_traffic_enabled(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Whether to enable route exchange between Azure Route Server and the gateway(s).
        """
        return pulumi.get(self, "branch_to_branch_traffic_enabled")

    @_builtins.property
    @pulumi.getter(name="hubRoutingPreference")
    def hub_routing_preference(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The hub routing preference. Valid values are `ASPath`, `ExpressRoute` or `VpnGateway`. Defaults to `ExpressRoute`.
        """
        return pulumi.get(self, "hub_routing_preference")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the supported Azure location where the Route Server should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Route Server. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="publicIpAddressId")
    def public_ip_address_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Public IP Address. This option is required since September 1st 2021. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "public_ip_address_id")

    @_builtins.property
    @pulumi.getter(name="resourceGroupName")
    def resource_group_name(self) -> pulumi.Output[_builtins.str]:
        """
        Specifies the name of the Resource Group where the Route Server should exist. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "resource_group_name")

    @_builtins.property
    @pulumi.getter(name="routingState")
    def routing_state(self) -> pulumi.Output[_builtins.str]:
        return pulumi.get(self, "routing_state")

    @_builtins.property
    @pulumi.getter
    def sku(self) -> pulumi.Output[_builtins.str]:
        """
        The SKU of the Route Server. The only possible value is `Standard`. Changing this forces a new resource to be created.
        """
        return pulumi.get(self, "sku")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the Subnet that the Route Server will reside. Changing this forces a new resource to be created.

        > **Note:** Azure Route Server requires a dedicated subnet named RouteServerSubnet. The subnet size has to be at least /27 or short prefix (such as /26 or /25) and cannot be attached to any security group, otherwise, you'll receive an error message when deploying the Route Server.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        A mapping of tags to assign to the resource.
        """
        return pulumi.get(self, "tags")

    @_builtins.property
    @pulumi.getter(name="virtualRouterAsn")
    def virtual_router_asn(self) -> pulumi.Output[_builtins.int]:
        return pulumi.get(self, "virtual_router_asn")

    @_builtins.property
    @pulumi.getter(name="virtualRouterIps")
    def virtual_router_ips(self) -> pulumi.Output[Sequence[_builtins.str]]:
        return pulumi.get(self, "virtual_router_ips")

